
const config = {
    development: {
        port: 3000,
        corsOrigin: 'http://localhost'
    },
    production: {
        port: process.env.PORT || 3000, 
        corsOrigin: process.env.APP_URL || '*'
    }
};

const getConfig = () => {
    const env = process.env.NODE_ENV || 'development';
    return config[env];
};


module.exports = {
    config,
    getConfig
};