<?php
    $footerContent = getContent('basic_footer.content', true);
    $footerElement = getContent('basic_footer.element', orderById: true);
    $socialIcons = getContent('social_icon.element', orderById: true);
    $policyPages = getContent('policy_pages.element');
    $socialLinks = getContent('short_links.element', orderById: true);
?>
<footer class="footer-section footer bg-overlay-black bg_img <?php if(request()->routeIs('home') || request()->routeIs('category') || request()->routeIs('subCategory') || request()->routeIs('search')): ?> d-none <?php endif; ?> pt-80" data-background="<?php echo e(getImage('assets/images/frontend/basic_footer/' . @$footerContent->data_values->background_image, '1920x789')); ?>">
    <div class="container">
        <div class="footer-top-area d-flex align-items-center justify-content-between flex-wrap">
            <div class="footer-logo">
                <a class="site-logo" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(siteLogo()); ?>" alt="logo"></a>
            </div>
            <div class="social-area">
                <ul class="footer-social">
                    <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e(@$item->data_values->url); ?>" target="_blank"><?php echo @$item->data_values->social_icon ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        </div>
        <div class="footer-bottom-area">
            <div class="row justify-content-center mb-30-none">
                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 mb-30">
                    <div class="footer-widget">
                        <h3 class="widget-title"><?php echo app('translator')->get('About Us'); ?></h3>
                        <p><?php echo e(__(@$footerContent->data_values->about_us)); ?></p>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-2 col-md-6 col-sm-6 mb-30">
                    <div class="footer-widget">
                        <h3 class="widget-title"><?php echo app('translator')->get('Categories'); ?></h3>
                        <ul class="footer-links">
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('category', $category->id)); ?>"><?php echo e(__($category->name)); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-2 col-md-6 col-sm-4 mb-30">
                    <div class="footer-widget">
                        <h3 class="widget-title"><?php echo app('translator')->get('Short Links'); ?></h3>
                        <ul class="footer-links">

                            <?php $__empty_1 = true; $__currentLoopData = $socialLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <li><a href="<?php echo e(route('links', $link->slug)); ?>"><?php echo e(__(@$link->data_values->title)); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-8 mb-30">
                    <div class="footer-widget">
                        <h3 class="widget-title"><?php echo app('translator')->get('Subscribe News Letter'); ?></h3>
                        <p><?php echo e(__(@$footerContent->data_values->subscribe_title)); ?></p>
                        <form class="subscribe-form" method="post">
                            <?php echo csrf_field(); ?>
                            <input name="email" type="email" placeholder="<?php echo app('translator')->get('Email Address'); ?>" required>
                            <button type="submit"><i class="fas fa-paper-plane"></i></button>
                        </form>
                        <div class="download-links">
                            <?php $__currentLoopData = $footerElement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a class="download-links__item" href="<?php echo e(@$footer->data_values->link); ?>" target="_blank">
                                    <img src="<?php echo e(getImage('assets/images/frontend/basic_footer/' . @$footer->data_values->store_image, '150x45')); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="copyright-area">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-12 text-center">
                    <div class="copyright-wrapper d-flex align-items-center justify-content-between flex-wrap">
                        <div class="copyright">
                            <p><?php echo app('translator')->get('Copyright'); ?> &copy; <?php echo e(date('Y')); ?> <?php echo app('translator')->get('All Rights Reserved By'); ?>
                                <a class="text--base" href="<?php echo e(route('home')); ?>"><?php echo e(gs('site_name')); ?></a>
                            </p>
                        </div>
                        <div class="copyright-link-area">
                            <ul class="copyright-link">
                                <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(route('policy.pages', $policy->slug)); ?>"><?php echo e(__(@$policy->data_values->title)); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>

<div class="modal alert-modal" id="alertModal">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <span class="alert-icon"><i class="fas fa-question-circle"></i></span>
                <p class="modal-description"><?php echo app('translator')->get('Subscription Alert!'); ?></p>
                <p class="modal--text"><?php echo app('translator')->get('Please subscribe a plan to view our paid items'); ?></p>
            </div>
            <div class="modal-footer">
                <button class="btn btn--dark btn--sm" data-bs-dismiss="modal" type="button"><?php echo app('translator')->get('Cancel'); ?></button>
                <a class="btn btn--base btn--sm" href="<?php echo e(route('subscription')); ?>"><?php echo app('translator')->get('Subscribe Now'); ?></a>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/mostream/tv.mostreams.com/core/resources/views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>