

<?php $__env->startSection('content'); ?>
    <section class="section--bg ptb-80">
        <div class="container">
            <?php $__currentLoopData = $channelCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $eligable = false;
                    if (auth()->check()) {
                        $subscribedChannels = auth()->user()->subscribedChannelId();
                        $eligable = in_array($category->id, $subscribedChannels) ? true : false;
                    }
                ?>
                <div class="tv-live py-4">
                    <div class="d-flex justify-content-between align-items-center flex-wrap gap-2 mb-4">
                        <div class="d-flex flex-wrap gap-2 gap-md-3 align-items-center">
                            <h3 class="fw-bold"><?php echo e(__($category->name)); ?> <?php echo app('translator')->get('Channels'); ?></h3>
                            <?php if(!$eligable): ?>
                                <button class="btn btn--base btn--sm channelSubscribeBtn" data-id="<?php echo e($category->id); ?>" data-price="<?php echo e(showAmount($category->price)); ?>">
                                    <span class="icon"><i class="fas fa-rocket fa-lg"></i></span>
                                    <?php echo app('translator')->get('Subscribe'); ?>
                                </button>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="tv-card-wrapper">
                        <?php $__currentLoopData = $category->channels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $channel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="tv-card">
                                <div class="tv-card__thumb">
                                    <a href="<?php echo e(route('watch.tv', $channel->id)); ?>"><img src="<?php echo e(getImage(getFilePath('television') . '/' . $channel->image, getFileSize('television'))); ?>" class="w-100" alt=""></a>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>
    <div class="modal alert-modal" id="channelModal">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <span class="alert-icon"><i class="fas fa-question-circle"></i></span>
                        <p class="modal-description"><?php echo app('translator')->get('Confirmation Alert!'); ?></p>
                        <p class="modal--text"><?php echo app('translator')->get('Are you sure to subscribe to this channel group?'); ?></p>
                        <p class="modal--text"><?php echo app('translator')->get('Monthly subscription price is '); ?> <span class="subscription-price"></span></p>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--dark btn--sm" data-bs-dismiss="modal" type="button"><?php echo app('translator')->get('No'); ?></button>
                        <button class="btn btn--base btn--sm" type="submit"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .tv-card__thumb {
            width: 110px;
            height: 110px;
            border-radius: 50%;
            overflow: hidden;
        }

        @media (max-width: 1199px) {
            .tv-card__thumb {
                width: 106px;
                height: 106px;
            }
        }

        @media (max-width: 767px) {
            .tv-card__thumb {
                width: 93px;
                height: 93px;
            }
        }

        @media (max-width: 575px) {
            .tv-card__thumb {
                width: 85px;
                height: 85px;
            }
        }

        .tv-card-wrapper {
            display: flex;
            justify-content: flex-start;
            flex-wrap: wrap;
            gap: 12px;
        }

        .tv-card {
            display: flex;
            justify-content: center;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.channelSubscribeBtn').on('click',function(e) {
                e.preventDefault();
                let modal = $("#channelModal");
                modal.find('.subscription-price').text($(this).data('price'));
                modal.find('form').attr('action', `<?php echo e(route('user.subscribe.channel', '')); ?>/${$(this).data('id')}`)
                modal.modal('show');
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasir/public_html/tv.mostreams.com/core/resources/views/templates/basic/live_tvs.blade.php ENDPATH**/ ?>