<?php
    use Illuminate\Support\Str;

    $breadcrumb = getContent('breadcrumb.content', true);
    $routeName = request()->route()->getName();

    // Default fallback title
    $pageTitle = $pageTitle ?? 'Movie Details';

    // Detect route or variable and assign a proper title
    if (Str::startsWith($routeName, 'live.tv') || !empty($channel) || !empty($liveTv)) {
        $pageTitle = 'Live TV';
    } elseif (Str::startsWith($routeName, 'ppv') || Str::contains($routeName, 'pay') || !empty($ppv)) {
        $pageTitle = 'Pay Per View';
    } elseif ((Str::startsWith($routeName, 'category.') || Str::contains($routeName, 'category')) && !empty($category)) {
        $pageTitle = $category->name ?? $pageTitle;
    } elseif ((Str::startsWith($routeName, 'movie.') || Str::contains($routeName, 'movie')) && !empty($movie)) {
        $pageTitle = $movie->title ?? $pageTitle;
    } elseif (Str::startsWith($routeName, 'game.') || Str::contains($routeName, 'game')) {
        $pageTitle = 'Game';
    }
?>

<section class="inner-banner-section banner-section bg-overlay-black bg_img"
         data-background="<?php echo e(getImage('assets/images/frontend/breadcrumb/' . @$breadcrumb->data_values->background_image, '1778x755')); ?>">
    <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-xl-12 text-center">
                <div class="banner-content">
                    <h1 class="title text-white"><?php echo e(__($pageTitle)); ?></h1>
                    <div class="breadcrumb-area">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-center">
                                <li class="breadcrumb-item">
                                    <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                                </li>
                                <li class="breadcrumb-item active" aria-current="page">
                                    <?php echo e(__($pageTitle)); ?>

                                </li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/nasir/public_html/tv.mostreams.com/core/resources/views/templates/basic/partials/breadcrumb.blade.php ENDPATH**/ ?>