<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <form action="<?php echo e(route('admin.item.store')); ?>" method="post" enctype="multipart/form-data" id="itemForm"
                      class="position-relative">
                    <div class="app d-none">
                        <div class="spinner"></div>
                    </div>
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="d-flex justify-content-end flex-wrap gap-3">
                            <div class="form-group">
                                <input class="form-control" name="id" type="number" placeholder="<?php echo app('translator')->get('Enter TMDB ID Ex: 1000'); ?>">
                            </div>
                            <div class="form-group">
                                <select class="form-control select2" data-minimum-results-for-search="-1" name="item_type">
                                    <option value="1"><?php echo app('translator')->get('Single Item'); ?></option>
                                    <option value="2"><?php echo app('translator')->get('Episode Item'); ?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <button class="btn btn-outline--dark fetchBtn h-45" type="button"><i
                                       class="las la-server"></i> <?php echo app('translator')->get('Fetch'); ?></button>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Portrait Image'); ?></label>
                                    <div class="image--uploader w-100">
                                        <div class="image-upload-wrapper">
                                            <div class="image-upload-preview portrait"
                                                 style="background-image: url(<?php echo e(getImage('/')); ?>)">
                                            </div>
                                            <div class="image-upload-input-wrapper">
                                                <input type="file" class="image-upload-input" name="portrait"
                                                       id="profilePicUpload1" accept=".png, .jpg, .jpeg">
                                                <label for="profilePicUpload1" class="bg--primary"><i
                                                       class="la la-cloud-upload"></i></label>
                                            </div>
                                        </div>
                                        <div class="mt-2">
                                            <small class="mt-3 text-muted"> <?php echo app('translator')->get('Supported Files:'); ?>
                                                <b><?php echo app('translator')->get('.png, .jpg, .jpeg'); ?></b>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Landscape Image'); ?></label>
                                    <div class="image--uploader w-100">
                                        <div class="image-upload-wrapper">
                                            <div class="image-upload-preview landscape"
                                                 style="background-image: url(<?php echo e(getImage('/')); ?>)">
                                            </div>
                                            <div class="image-upload-input-wrapper">
                                                <input type="file" class="image-upload-input" name="landscape"
                                                       id="profilePicUpload2" accept=".png, .jpg, .jpeg">
                                                <label for="profilePicUpload2" class="bg--primary"><i
                                                       class="la la-cloud-upload"></i></label>
                                            </div>
                                        </div>
                                        <div class="mt-2">
                                            <small class="mt-3 text-muted"> <?php echo app('translator')->get('Supported Files:'); ?>
                                                <b><?php echo app('translator')->get('.png, .jpg, .jpeg'); ?></b>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input name="portrait_url" type="hidden" value="">
                        <input name="landscape_url" type="hidden" value="">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Title'); ?></label>
                                <input class="form-control" name="title" type="text" value="<?php echo e(old('title')); ?>"
                                       required>
                            </div>
                            <div class="form-group col-md-6 version">
                                <label><?php echo app('translator')->get('Version'); ?></label>
                                <select class="form-control select2" data-minimum-results-for-search="-1" name="version">
                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                    <option value="0"><?php echo app('translator')->get('Free'); ?></option>
                                    <option value="1"><?php echo app('translator')->get('Paid'); ?></option>
                                    <option value="2"><?php echo app('translator')->get('Rent'); ?></option>
                                </select>
                            </div>
                            <div class="form-group col-md-6 rent-option d-none">
                                <label><?php echo app('translator')->get('Do you want to add it as rent?'); ?></label>
                                <div class="d-flex gap-3 flex-wrap">
                                    <div class="form-check">
                                        <input class="form-check-input" id="yes" name="version" type="radio"
                                               value="2">
                                        <label class="form-check-label" for="yes"><?php echo app('translator')->get('Yes'); ?></label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" id="no" name="version" type="radio"
                                               value="0">
                                        <label class="form-check-label" for="no"><?php echo app('translator')->get('No'); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row d-none" id="rentalArea">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Rent Price'); ?></label>
                                    <div class="input-group">
                                        <input class="form-control" name="rent_price" type="number" step="any"
                                               value="<?php echo e(old('rent_price')); ?>">
                                        <span class="input-group-text"><?php echo e(__(gs('cur_text'))); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Rental Period'); ?></label>
                                    <div class="input-group">
                                        <input class="form-control" name="rental_period" type="number"
                                               value="<?php echo e(old('rental_period')); ?>">
                                        <span class="input-group-text"><?php echo app('translator')->get('Days'); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Exclude from plan'); ?></label>
                                    <select class="form-control select2" data-minimum-results-for-search="-1"
                                            name="exclude_plan">
                                        <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                        <option value="0"><?php echo app('translator')->get('No'); ?></option>
                                        <option value="1"><?php echo app('translator')->get('Yes'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Category'); ?></label>
                                <select class="form-control select2" name="category" required>
                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-subcategories="<?php echo e($category->subcategories); ?>"
                                                value="<?php echo e($category->id); ?>"><?php echo e(__($category->name)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Subcategory'); ?></label>
                                <select class="form-control select2" name="sub_category_id">
                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Preview Text'); ?></label>
                                <textarea class="form-control" name="preview_text" rows="5" required><?php echo e(old('preview_text')); ?></textarea>
                            </div>
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Description'); ?></label>
                                <textarea class="form-control" name="description" rows="5" required><?php echo e(old('description')); ?></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-4  position-relative">
                                <label><?php echo app('translator')->get('Director'); ?></label>
                                <select class="form-control select2-auto-tokenize director-option" name="director[]"
                                        multiple="multiple" required></select>
                            </div>
                            <div class="form-group col-md-4  position-relative">
                                <label><?php echo app('translator')->get('Producer'); ?></label>
                                <select class="form-control select2-auto-tokenize producer-option" name="producer[]"
                                        multiple="multiple" required></select>
                            </div>
                            <div class="form-group col-md-4">
                                <label><?php echo app('translator')->get('Ratings'); ?> <small class="text--primary">(<?php echo app('translator')->get('Maximum 10 stars allowed'); ?>)</small></label>
                                <div class="input-group">
                                    <input class="form-control" name="ratings" type="number"
                                           value="<?php echo e(old('ratings')); ?>" step="any" max="10" required>
                                    <span class="input-group-text"><i class="las la-star"></i></span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6  position-relative">
                                <label><?php echo app('translator')->get('Genres'); ?></label>
                                <select class="form-control select2-auto-tokenize genres-option" name="genres[]"
                                        multiple="multiple" required></select>
                            </div>
                            <div class="form-group col-md-6  position-relative">
                                <label><?php echo app('translator')->get('Languages'); ?></label>
                                <select class="form-control select2-auto-tokenize language-option" name="language[]"
                                        multiple="multiple" required></select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6  position-relative">
                                <label class="form-control-label"><?php echo app('translator')->get('Casts'); ?></label>
                                <small class="text-facebook ml-2 mt-2"><?php echo app('translator')->get('Separate multiple by'); ?>
                                    <code>,</code>(<?php echo app('translator')->get('comma'); ?>) <?php echo app('translator')->get('or'); ?> <code><?php echo app('translator')->get('enter'); ?></code>
                                    <?php echo app('translator')->get('key'); ?></small>
                                <select class="form-control select2-auto-tokenize cast-option" name="casts[]"
                                        multiple="multiple" required></select>
                            </div>
                            <div class="form-group col-md-6 position-relative">
                                <label><?php echo app('translator')->get('Tags'); ?></label>
                                <small class="text-facebook ml-2 mt-2"><?php echo app('translator')->get('Separate multiple by'); ?>
                                    <code>,</code>(<?php echo app('translator')->get('comma'); ?>) <?php echo app('translator')->get('or'); ?> <code><?php echo app('translator')->get('enter'); ?></code>
                                    <?php echo app('translator')->get('key'); ?></small>
                                <select class="form-control select2-auto-tokenize tag-option" name="tags[]"
                                        multiple="multiple" required></select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3 form-group">
                                <label><?php echo app('translator')->get('Send Notification to Users'); ?></label>
                                <input name="notify_to_users" data-width="100%" data-size="large" data-onstyle="-success"
                                       data-offstyle="-danger" data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>" data-off="<?php echo app('translator')->get('No'); ?>" type="checkbox">
                            </div>
                            <div class="col-md-3 form-group">
                                <label><?php echo app('translator')->get('Send Notification to Subscriber'); ?></label>
                                <input name="notify_to_subscriber" data-width="100%" data-size="large" data-onstyle="-success"
                                       data-offstyle="-danger" data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>" data-off="<?php echo app('translator')->get('No'); ?>" type="checkbox">
                            </div>
                        </div>

                    </div>
                    <div class="card-footer">
                        <button class="btn btn--primary h-45 w-100" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.back','data' => ['route' => ''.e(route('admin.item.index')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['route' => ''.e(route('admin.item.index')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $attributes = $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $component = $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .image-upload-preview {
            background-size: cover !important;
        }

        .select2-container {
            min-width: 140px !important;
        }

        .app {
            position: absolute;
            display: flex;
            height: 100%;
            align-items: center;
            justify-content: center;
            width: 100%;
            z-index: 2;
            background: rgba(255, 255, 255, 0.596);
        }

        .spinner {
            border: 5px solid rgba(0, 0, 0, 0.25);
            width: 56px;
            height: 56px;
            border-radius: 50%;
            border-left-color: #4634ff;
            margin: 15px auto;
            animation: spin .8s ease infinite;
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"

            let rent = "<?php echo e(Status::RENT_VERSION); ?>";
            let version;
            let rentalArea = $('#rentalArea');

            $('#itemForm').on('submit', function(e) {
                version = $('[name=version]').find('option:selected').val();
                if (version == rent) {
                    e.preventDefault();
                    if (!$('[name=rent_price]').val()) {
                        notify('error', 'Rent price field is required');
                        return;
                    }
                    if (!$('[name=rental_period]').val()) {
                        notify('error', 'Rental period field is required');
                        return;
                    }
                    if (!$('[name=exclude_plan]').val()) {
                        notify('error', 'Exclude from plan field is required');
                        return;
                    }
                }
                $(this).off('submit').submit();
            });


            $.each($('.select2-auto-tokenize'), function(index, element) {
                $(element).select2({
                    dropdownParent: $(element).closest('.position-relative'),
                    tags: true,
                    tokenSeparators: [',']
                });
            });

            $('[name=category]').on('change', function() {
                var subcategoryOption = '<option><?php echo app('translator')->get('Select One'); ?></option>';
                var subcategories = $(this).find(':selected').data('subcategories');
                subcategories.forEach(subcategory => {
                    subcategoryOption +=
                        `<option value="${subcategory.id}">${subcategory.name}</option>`;
                });
                $('[name=sub_category_id]').html(subcategoryOption);
            });


            $('[name=version]').on('change', function(e) {
                version = Number($(this).val());
                if (version == rent) {
                    rentalArea.removeClass('d-none');
                } else {
                    rentalArea.addClass('d-none');
                }
            });


            $('[name=item_type]').on('change', function() {
                if ($(this).val() == '1') {
                    $('.version').removeClass('d-none');
                    $('.rent-option').addClass('d-none');
                } else {
                    $('.version').addClass('d-none');
                    $('.rent-option').removeClass('d-none');
                }
            });


            $('select[name=version]').val('<?php echo e(old('version')); ?>');
            $('select[name=category]').val('<?php echo e(old('category')); ?>');
            $('select[name=sub_category_id]').val('<?php echo e(old('sub_category_id')); ?>');


            $('.fetchBtn').on('click', function(e) {
                e.preventDefault();
                $('.app').removeClass('d-none');
                let data = {};
                data.id = $('[name=id]').val();
                if (!data.id) {
                    $('.app').addClass('d-none');
                    notify('error', 'Item ID field is required');
                    return;
                }
                data.item_type = $('[name=item_type]').find(":selected").val();
                

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: "POST",
                    url: "<?php echo e(route('admin.item.fetch')); ?>",
                    data: data,
                    success: function(response) {
                        if (response.success) {
                            setTimeout(() => {
                                $('.app').addClass('d-none');

                                var data = response.data;
                                var casts = response.casts;
                                var tags = response.tags;

                                var portraitImage =
                                    `https://image.tmdb.org/t/p/original${data.poster_path}`;
                                var landscapeImage =
                                    `https://image.tmdb.org/t/p/original${data.backdrop_path}`;

                                $('.portrait').attr('style',
                                    `background-image: url(${portraitImage})`);
                                $('.landscape').attr('style',
                                    `background-image: url(${landscapeImage})`);
                                $('[name=portrait_url]').val(portraitImage);
                                $('[name=landscape_url]').val(landscapeImage);

                                $('[name=ratings]').val(data.vote_average);
                                $('[name=title]').val(data.title ?? data.name);
                                $('[name=preview_text]').val(data.tagline);
                                $('[name=description]').val(data.overview);

                                // Cast list
                                var castOption = '';
                                $.each(casts.cast, function(index, value) {
                                    castOption +=
                                        `<option value="${value.name}" selected>${value.name}</option>`
                                });
                                $('.cast-option').html(castOption);

                                // producer
                                var producerOption = '';
                                $.each(casts.crew, function(index, value) {
                                    if (value.job == "Producer") {
                                        producerOption +=
                                            `<option value="${value.name}" selected>${value.name}</option>`
                                    }
                                });
                                $('.producer-option').html(producerOption);

                                // director
                                var directorOption = '';
                                $.each(casts.crew, function(index, value) {
                                    if (value.known_for_department == "Directing" &&
                                        (value.job == "Screenplay" || value.job ==
                                            "Director")) {
                                        directorOption +=
                                            `<option value="${value.name}" selected>${value.name}</option>`
                                    }
                                });
                                $('.director-option').html(directorOption);

                                if (directorOption == '') {
                                    $.each(data.created_by, function(index, value) {
                                        directorOption +=
                                            `<option value="${value.name}" selected>${value.name}</option>`
                                    });
                                    $('.director-option').html(directorOption);
                                }

                                // genres
                                var genresOption = '';
                                $.each(data.genres, function(index, value) {
                                    genresOption +=
                                        `<option value="${value.name}" selected>${value.name}</option>`
                                });
                                $('.genres-option').html(genresOption);
                                // language
                                var langOption = '';
                                $.each(data.spoken_languages, function(index, value) {
                                    langOption +=
                                        `<option value="${value.name}" selected>${value.name}</option>`
                                });
                                $('.language-option').html(langOption);

                                // tags
                                var tagOption = '';
                                $.each(tags.keywords ?? tags.results, function(index,
                                    value) {
                                    tagOption +=
                                        `<option value="${value.name}" selected>${value.name}</option>`
                                });
                                $('.tag-option').html(tagOption);

                                notify('success', 'Data imported successfully');
                            }, 3000);

                        } else {
                            $('.app').addClass('d-none');
                            notify('error', response.error);
                        }
                    }
                });
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasir/public_html/tv.mostreams.com/core/resources/views/admin/item/create.blade.php ENDPATH**/ ?>