<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <form action="<?php echo e(route('admin.item.update', $item->id)); ?>" method="post" enctype="multipart/form-data" id="itemForm">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Portrait Image'); ?></label>
                                    <div class="image--uploader w-100">
                                        <div class="image-upload-wrapper">
                                            <div class="image-upload-preview portrait" style="background-image: url(<?php echo e(getImage(getFilePath('item_portrait') . '/' . @$item->image->portrait)); ?>)">
                                            </div>
                                            <div class="image-upload-input-wrapper">
                                                <input type="file" class="image-upload-input" name="portrait" id="profilePicUpload1" accept=".png, .jpg, .jpeg">
                                                <label for="profilePicUpload1" class="bg--primary"><i class="la la-cloud-upload"></i></label>
                                            </div>
                                        </div>
                                        <div class="mt-2">
                                            <small class="mt-3 text-muted"> <?php echo app('translator')->get('Supported Files:'); ?>
                                                <b><?php echo app('translator')->get('.png, .jpg, .jpeg'); ?></b>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Landscape Image'); ?></label>
                                    <div class="image--uploader w-100">
                                        <div class="image-upload-wrapper">
                                            <div class="image-upload-preview landscape" style="background-image: url(<?php echo e(getImage(getFilePath('item_landscape') . '/' . @$item->image->landscape)); ?>)">
                                            </div>
                                            <div class="image-upload-input-wrapper">
                                                <input type="file" class="image-upload-input" name="landscape" id="profilePicUpload2" accept=".png, .jpg, .jpeg">
                                                <label for="profilePicUpload2" class="bg--primary"><i class="la la-cloud-upload"></i></label>
                                            </div>
                                        </div>
                                        <div class="mt-2">
                                            <small class="mt-3 text-muted"> <?php echo app('translator')->get('Supported Files:'); ?>
                                                <b><?php echo app('translator')->get('.png, .jpg, .jpeg'); ?></b>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Title'); ?></label>
                                <input class="form-control" name="title" type="text" value="<?php echo e($item->title); ?>" placeholder="Title">
                            </div>
                            <?php if($item->item_type == Status::EPISODE_ITEM): ?>
                                <div class="form-group col-md-6 rent-option">
                                    <label><?php echo app('translator')->get('Do you want to add it as rent?'); ?></label>
                                    <div class="d-flex gap-3 flex-wrap">
                                        <div class="form-check">
                                            <input class="form-check-input" id="yes" name="version" type="radio" value="2" <?php if($item->version == Status::RENT_VERSION): echo 'checked'; endif; ?>>
                                            <label class="form-check-label" for="yes"><?php echo app('translator')->get('Yes'); ?></label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" id="no" name="version" type="radio" value="0" <?php if($item->version == Status::FREE_VERSION): echo 'checked'; endif; ?>>
                                            <label class="form-check-label" for="no"><?php echo app('translator')->get('No'); ?></label>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <div class="form-group col-md-6 version">
                                    <label><?php echo app('translator')->get('Version'); ?></label>
                                    <select class="form-control select2" data-minimum-results-for-search="-1" name="version">
                                        <option value="0" <?php if($item->version == Status::FREE_VERSION): echo 'selected'; endif; ?>><?php echo app('translator')->get('Free'); ?></option>
                                        <option value="1" <?php if($item->version == Status::PAID_VERSION): echo 'selected'; endif; ?>><?php echo app('translator')->get('Paid'); ?></option>
                                        <option value="2" <?php if($item->version == Status::RENT_VERSION): echo 'selected'; endif; ?>><?php echo app('translator')->get('Rent'); ?></option>
                                    </select>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="row d-none" id="rentalArea">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Rent Price'); ?></label>
                                    <div class="input-group">
                                        <input class="form-control" name="rent_price" type="number" step="any" value="<?php echo e(getAmount($item->rent_price)); ?>">
                                        <span class="input-group-text"><?php echo e(__(gs('cur_text'))); ?></span>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Rental Period'); ?></label>
                                    <div class="input-group">
                                        <input class="form-control" name="rental_period" type="number" value="<?php echo e($item->rental_period); ?>">
                                        <span class="input-group-text"><?php echo app('translator')->get('Days'); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Exclude from plan'); ?></label>
                                    <select class="form-control select2" data-minimum-results-for-search="-1" name="exclude_plan">
                                        <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                        <option value="0" <?php if($item->exclude_plan == Status::NO): echo 'selected'; endif; ?>><?php echo app('translator')->get('No'); ?></option>
                                        <option value="1" <?php if($item->exclude_plan == Status::YES): echo 'selected'; endif; ?>><?php echo app('translator')->get('Yes'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Category'); ?></label>
                                <select class="form-control select2" name="category">
                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-subcategories="<?php echo e($category->subcategories); ?>" value="<?php echo e($category->id); ?>"><?php echo e(__($category->name)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Subcategory'); ?></label>
                                <select class="form-control select2" name="sub_category_id">
                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                    <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_categorie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($sub_categorie->id); ?>"><?php echo e(__($sub_categorie->name)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Preview Text'); ?></label>
                                <textarea class="form-control" name="preview_text" rows="5" placeholder="<?php echo app('translator')->get('Preview Text'); ?>"><?php echo e($item->preview_text); ?></textarea>
                            </div>
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Description'); ?></label>
                                <textarea class="form-control" name="description" rows="5" placeholder="<?php echo app('translator')->get('Description'); ?>"><?php echo e($item->description); ?></textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-4">
                                <label><?php echo app('translator')->get('Director'); ?></label>
                                <select class="form-control select2-auto-tokenize director-option" name="director[]" multiple="multiple" required>
                                    <?php $__currentLoopData = explode(',', $item->team->director); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $director): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($director); ?>" selected><?php echo e($director); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label><?php echo app('translator')->get('Producer'); ?></label>
                                <select class="form-control select2-auto-tokenize director-option" name="producer[]" multiple="multiple" required>
                                    <?php $__currentLoopData = explode(',', $item->team->producer); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($producer); ?>" selected><?php echo e($producer); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-4">
                                <label><?php echo app('translator')->get('Ratings'); ?> <small class="text--primary">(<?php echo app('translator')->get('Maximum 10 stars allowed'); ?>)</small></label>
                                <div class="input-group">
                                    <input class="form-control" name="ratings" type="number" step="any" value="<?php echo e($item->ratings); ?>" max="10" placeholder="<?php echo app('translator')->get('Ratings'); ?>" aria-describedby="ratingsHelpBlock">
                                    <span class="input-group-text"><i class="las la-star"></i></span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Genres'); ?></label>
                                <select class="form-control select2-auto-tokenize genres-option" name="genres[]" multiple="multiple" required>
                                    <?php $__currentLoopData = explode(',', @$item->team->genres); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $genre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($genre); ?>" selected><?php echo e($genre); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Languages'); ?></label>
                                <select class="form-control select2-auto-tokenize language-option" name="language[]" multiple="multiple" required>
                                    <?php $__currentLoopData = explode(',', @$item->team->language); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($lang); ?>" selected><?php echo e($lang); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="form-control-label"><?php echo app('translator')->get('Casts'); ?></label>
                                <small class="text-facebook ml-2 mt-2"><?php echo app('translator')->get('Separate multiple by'); ?> <code>,</code>(<?php echo app('translator')->get('comma'); ?>) <?php echo app('translator')->get('or'); ?> <code><?php echo app('translator')->get('enter'); ?></code> <?php echo app('translator')->get('key'); ?></small>

                                <select class="form-control select2-auto-tokenize" name="casts[]" placeholder="Add short words which better describe your site" multiple="multiple" required>
                                    <?php $__currentLoopData = explode(',', $item->team->casts); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cast): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cast); ?>" selected><?php echo e($cast); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label><?php echo app('translator')->get('Tags'); ?></label>
                                <small class="text-facebook ml-2 mt-2"><?php echo app('translator')->get('Separate multiple by'); ?> <code>,</code>(<?php echo app('translator')->get('comma'); ?>) <?php echo app('translator')->get('or'); ?> <code><?php echo app('translator')->get('enter'); ?></code> <?php echo app('translator')->get('key'); ?></small>
                                <select class="form-control select2-auto-tokenize" name="tags[]" placeholder="Add short words which better describe your site" multiple="multiple" required>
                                    <?php $__currentLoopData = explode(',', $item->tags); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($tag); ?>" selected><?php echo e($tag); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4 form-group">
                                <label><?php echo app('translator')->get('Total Views'); ?></label>
                                <input class="form-control" name="view" type="text" value="<?php echo e(@$item->view); ?>">
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo app('translator')->get('Status'); ?></label>
                                <input name="status" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Active'); ?>" data-off="<?php echo app('translator')->get('Inactive'); ?>" type="checkbox" <?php if($item->status): echo 'checked'; endif; ?>>
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo app('translator')->get('Featured'); ?></label>
                                <input name="featured" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>" data-off="<?php echo app('translator')->get('No'); ?>" type="checkbox" <?php if($item->featured): echo 'checked'; endif; ?>>
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo app('translator')->get('Trending'); ?></label>
                                <input name="trending" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>" data-off="<?php echo app('translator')->get('No'); ?>" type="checkbox" <?php if($item->trending): echo 'checked'; endif; ?>>
                            </div>
                            <div class="col-md-4 form-group">
                                <label><?php echo app('translator')->get('Single Section'); ?></label>
                                <input name="single" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>" data-off="<?php echo app('translator')->get('No'); ?>" type="checkbox" <?php if($item->single): echo 'checked'; endif; ?>>
                            </div>
                            <?php if($item->item_type == Status::SINGLE_ITEM): ?>
                                <div class="col-md-4 form-group">
                                    <label><?php echo app('translator')->get('Trailer'); ?></label>
                                    <input name="is_trailer" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-height="50" data-on="<?php echo app('translator')->get('Yes'); ?>" data-off="<?php echo app('translator')->get('No'); ?>" type="checkbox" <?php if($item->is_trailer): echo 'checked'; endif; ?>>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Update'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a class="btn btn--sm btn-outline--primary" href="<?php echo e(route('admin.item.index')); ?>"><i class="la la-undo"></i> <?php echo app('translator')->get('Back'); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .image-upload-preview {
            background-size: cover !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"


            let rent = "<?php echo e(Status::RENT_VERSION); ?>";
            let version;
            let rentalArea = $('#rentalArea');
            let currentVersion = "<?php echo e($item->version); ?>";

            $('select[name=category]').val('<?php echo e(@$item->category->id); ?>').change();
            $('select[name=sub_category_id]').val('<?php echo e(@$item->sub_category->id); ?>').change();
            $('select[name=version]').val('<?php echo e(@$item->version); ?>');

            $('[name=category]').no('change', function() {
                var subcategoryOption = '<option><?php echo app('translator')->get('Select One'); ?></option>';
                var subcategories = $(this).find(':selected').data('subcategories');

                if (subcategories) {
                    subcategories.forEach(subcategory => {
                        subcategoryOption += `<option value="${subcategory.id}">${subcategory.name}</option>`;
                    });
                }

                $('[name=sub_category_id]').html(subcategoryOption);

                if ('<?php echo e($item->sub_category_id); ?>') {
                    $('[name=sub_category_id]').val('<?php echo e($item->sub_category_id); ?>').change();
                }
            });


            $('#itemForm').on('submit', function(e) {
                version = $('[name=version]').find('option:selected').val();
                if (version == rent) {
                    e.preventDefault();
                    if (!$('[name=rent_price]').val()) {
                        notify('error', 'Rent price field is required');
                        return;
                    }
                    if (!$('[name=rental_period]').val()) {
                        notify('error', 'Rental period field is required');
                        return;
                    }
                    if (!$('[name=exclude_plan]').val()) {
                        notify('error', 'Exclude from plan field is required');
                        return;
                    }
                }
                $(this).off('submit').submit();
            });


            $.each($('.select2-auto-tokenize'), function(index, element) {
                $(element).select2({
                    dropdownParent: $(element).closest('.position-relative'),
                    tags: true,
                    tokenSeparators: [',']
                });
            });


            $('[name=version]').on('change', function(e) {
                version = Number($(this).val())
                if (!version) {
                    version = $('[name=version]:checked').val();
                }
                if (version != undefined) {
                    if (version == rent) {
                        rentalArea.removeClass('d-none');
                    } else {
                        rentalArea.addClass('d-none');
                    }
                }
            }).change();
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasir/public_html/tv.mostreams.com/core/resources/views/admin/item/edit.blade.php ENDPATH**/ ?>