@props(['videoFile' => ''])

<div class="row d-flex justify-content-center mt-3">
    <div class="col-md-12 col-lg-6">
        @php
            $isYoutube = preg_match('/youtu\.?be/', $videoFile);
            $youtubeId = null;
            if ($isYoutube) {
                preg_match('/(youtu\.be\/|v=)([a-zA-Z0-9_-]{11})/', $videoFile, $matches);
                $youtubeId = $matches[2] ?? null;
            }
        @endphp

        @if ($isYoutube && $youtubeId)
            <div class="plyr__video-embed" style="position:relative; padding-bottom:56.25%; height:0; overflow:hidden;">
                <iframe
                    src="https://www.youtube.com/embed/{{ $youtubeId }}?modestbranding=1&rel=0&showinfo=0&iv_load_policy=3"
                    allowfullscreen
                    allow="autoplay; encrypted-media"
                    style="position:absolute; top:0; left:0; width:100%; height:100%; border:0"
                    ></iframe>
            </div>
        @else
            <video class="plyr-video" playsinline controls style="width: 100%;">
                <source src="{{ $videoFile }}" type="video/mp4" />
                Your browser does not support the video tag.
            </video>
        @endif
    </div>
</div>
