<style>
    .info-category-bg {
        background-color: rgba(255, 111, 0, .5) !important;
    }
    
    .info-category-icon {
        color: #ff6f00 !important;
    }
</style>

<div class="col">
    <div class="metrics-container">

        <div class="row">
            <div class="mb-4 col-md-4">
                <div class="card shadow rounded py-2 px-3">
                    <div class="card-body text-muted font-weight-medium">
                        <p class="font-weight-bolder fs-5 mb-3">Last 24 hours</p>
                        <p class=""><?php echo e(__("Users registered")); ?>: <?php echo e(\App\Providers\DashboardServiceProvider::getLast24HoursRegisteredUsersCount()); ?></p>
                        <p class=""><?php echo e(__("New posts")); ?>: <?php echo e(\App\Providers\DashboardServiceProvider::getLast24HoursPostsCount()); ?></p>
                        <p class=""><?php echo e(__("New subscriptions")); ?>: <?php echo e(\App\Providers\DashboardServiceProvider::getLast24HoursSubscriptionsCount()); ?></p>
                        <p class="m-0"><?php echo e(__("Total earned")); ?>: <?php echo e(\App\Providers\SettingsServiceProvider::getWebsiteFormattedAmount(\App\Providers\DashboardServiceProvider::getLast24HoursTotalEarned())); ?></p>
                        <span class="pull-right"><a href="admin/users" class="primary-link"><?php echo e(__("Go to users")); ?> ››</a></span>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>

            <div class="mb-4 col-md-4">

                <div class="card shadow rounded py-2 px-3">
                    <div class="card-body text-muted font-weight-medium">
                        <p class="font-weight-bolder fs-5 mb-3">Payments</p>
                        <p><?php echo e(__("Active subscriptions")); ?>: <?php echo e(\App\Providers\DashboardServiceProvider::getActiveSubscriptionsCount()); ?></p>
                        <p><?php echo e(__("Subscriptions revenue")); ?>: <?php echo e(\App\Providers\SettingsServiceProvider::getWebsiteFormattedAmount(\App\Providers\DashboardServiceProvider::getTotalSubscriptionsRevenue())); ?></p>
                        <p><?php echo e(__("Total transactions")); ?>: <?php echo e(\App\Providers\DashboardServiceProvider::getTotalTransactionsCount()); ?></p>
                        <p class="m-0"><?php echo e(__("Total amount earned")); ?>: <?php echo e(\App\Providers\SettingsServiceProvider::getWebsiteFormattedAmount(\App\Providers\DashboardServiceProvider::getTotalEarned())); ?></p>
                        <span class="pull-right"><a href="admin/transactions" class="primary-link"><?php echo e(__("Go to payments")); ?> ››</a></span>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>

            <div class="mb-4 col-md-4">

                <div class="card shadow rounded py-2 px-3">
                    <div class="card-body text-muted font-weight-medium">
                        <p class="font-weight-bolder fs-5 mb-3">Content</p>
                        <p><?php echo e(__("Total posts")); ?>: <?php echo e(\App\Providers\DashboardServiceProvider::getPostsCount()); ?></p>
                        <p><?php echo e(__("Post attachments")); ?>: <?php echo e(\App\Providers\DashboardServiceProvider::getPostAttachmentsCount()); ?></p>
                        <p><?php echo e(__("Post comments")); ?>: <?php echo e(\App\Providers\DashboardServiceProvider::getPostCommentsCount()); ?></p>
                        <p class="m-0"><?php echo e(__("Total reactions")); ?>: <?php echo e(\App\Providers\DashboardServiceProvider::getReactionsCount()); ?></p>
                        <span class="pull-right"><a href="admin/user-posts" class="primary-link"><?php echo e(__("Go to content")); ?> ››</a></span>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>

        </div>

        <div class="row two-columns-graph-holder">
            <?php echo $__env->make('elements.admin.value_card', [
                'name' => 'newUsersValue',
                'route' => 'admin.metrics.new.users.value',
                'size' => 'col-xs-12 col-sm-12 col-md-6 col-lg-6',
                'title' => __('New users'),
                'form' => [
                    'trans' => [ucfirst(trim(str_replace('1 ','',trans_choice('days', 1,['number'=>1])))), ucfirst(trim(str_replace('2 ','',trans_choice('days', 2,['number'=>2]))))],
                    'function' => 'count',
                    'ranges' => [1, 7, 14, 30, 60, 90],
                    'range' => 30
                ]
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('elements.admin.partition_card', [
                'name' => 'rolesPerUser',
                'chart' => [
                    'size' => 180,
                    'color' => '255, 111, 0',
                    'total' => true
                ],
                'route' => 'admin.metrics.new.users.partition',
                'size' => 'col-xs-12 col-sm-12 col-md-6 col-lg-6',
                'title' => __('Users roles'),
                'form' => [
                    'function' => 'count',
                ]
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="row">
            <?php echo $__env->make('elements.admin.trend_card', [
                'name' => 'newUsersTrend',
                'chart' => [
                    'size' => 100,
                    'color_start' => 'rgba(255, 111, 0, 1)',
                    'color_stop' => 'rgba(255, 111, 0, 0.5)',
                    'border_color' => 'rgba(255, 111, 0, 0.7)',
                    'point_radius' => 10,
                    'total' => true
                ],
                'route' => 'admin.metrics.new.users.trend',
                'size' => 'col-12 col-lg-12 mb-4',
                'title' => __('Registered users'),
                'form' => [
                    'trans' => [ucfirst(trim(str_replace('1 ','',trans_choice('months', 1,['number'=>1])))), ucfirst(trim(str_replace('2 ','',trans_choice('months', 2,['number'=>2]))))],
                    'function' => 'count',
                    'unit' => 'month',
                    'ranges' => [3, 6, 12],
                    'range' => 12
                ]
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<?php /**PATH /home/nasir/public_html/modelz.mostreams.com/resources/views/elements/admin/metrics.blade.php ENDPATH**/ ?>