import React from "react";
import { Head } from "@inertiajs/inertia-react";
import Front from "@/Layouts/Front";
import __ from "@/Functions/Translate";
import { useState } from "react";
import axios from "axios";
import PrimaryButton from "@/Components/PrimaryButton";
import { toast } from "react-toastify";
import { FaHandSparkles } from "react-icons/fa";
import ProfileTabs from "./Partials/ProfileTabs";
import { Inertia } from "@inertiajs/inertia";
import SubscribePopup from "./Partials/SubscribePopup";

export default function StartStream({
    user,
    streamUser,
    userFollowsChannel,
    userIsSubscribed,
}) {
    const [activeTab, setActiveTab] = useState("Videos");

    const coverBg = {
        backgroundImage: `url(${streamUser.cover_picture})`,
    };

    const followUser = () => {
        if (!user) {
            toast.error(__("Please login to follow this channel"));
        } else {
            axios
                .get(route("follow", { user: streamUser.id }))
                .then((apiRes) => {
                    console.log(
                        Inertia.reload({
                            only: ["userFollowsChannel", "streamUser"],
                        })
                    );
                })
                .catch((Error) => toast.error(Error.response?.data?.error));
        }
    };

    return (
        <Front>
            {/* STREAMING CENTER CONTENTS */}
            <div className="-mt-[100px] max-w-5xl mx-auto">
                
                <div className="coverPic" style={coverBg}></div>

                <div className="flex flex-wrap bg-white justify-between rounded-b-lg shadow text-gray-700 -mt-2 dark:bg-zinc-900 items-center pb-4 pt-5 px-3">
                    <div className="flex items-center">
                        <div className="relative">
                            <div className="border-4 border-white rounded-full shadow -mt-[63px] ml-2 z-10">
                                <img
                                    src={streamUser.profile_picture}
                                    alt=""
                                    className="h-24 rounded-full w-24 cursor-pointer dark:border-red-100"
                                />
                            </div>
                        </div>
                        <div className="ml-3 pb-2">
                            <h3 className="text-indigo-700 text-xl dark:text-white font-bold lg:text-2xl">
                                {streamUser.name}
                            </h3>

                            <p className="text-indigo-800 dark:text-white">
                                @{streamUser.username}
                            </p>
                        </div>
                    </div>
                    <div className="flex flex-col md:flex-row md:items-center md:space-x-2 md:space-y-0 space-y-2">
                        <PrimaryButton onClick={(e) => followUser()}>
                            <FaHandSparkles className="mr-1" />
                            {userFollowsChannel ? __("Unfollow") : __("Follow")}
                        </PrimaryButton>
                        <SubscribePopup
                            user={streamUser}
                            userIsSubscribed={userIsSubscribed}
                        />
                    </div>
                </div>

                <ProfileTabs
                    streamUser={streamUser}
                    activeTab={activeTab}
                    setActiveTab={setActiveTab}
                />
            </div>
        </Front>
    );
}
