import PrimaryButton from "@/Components/PrimaryButton";
import TextInput from "@/Components/TextInput";
import Textarea from "@/Components/Textarea";
import __ from "@/Functions/Translate";
import { usePage } from "@inertiajs/inertia-react";
import { useState } from "react";

export default function StreamInstructions({ streamKey, streamUser }) {
    const { auth, rtmp_url } = usePage().props;
    const [tab, setTab] = useState("desktop");

    if (auth?.user?.username !== streamUser) {
        return __("User offline!");
    }

    return (
        <div className="bg-white p-5 dark:bg-zinc-900 mr-10">
            <div className="my-5">
                <button
                    onClick={(e) => setTab("desktop")}
                    className={`text-xl font-bold hover:text-indigo-800 dark:hover:text-indigo-600 ${
                        tab === "desktop"
                            ? "text-orange-400 dark:text-indigo-500 underline"
                            : "text-gray-700 dark:text-white"
                    }`}
                >
                    {__("Desktop Instructions")}
                </button>
                <button
                    onClick={(e) => setTab("mobile")}
                    className={`ml-3 text-xl font-bold hover:text-indigo-800 dark:hover:text-indigo-600 ${
                        tab === "mobile"
                            ? "text-orange-400 dark:text-indigo-500 underline"
                            : "text-gray-700 dark:text-white"
                    }`}
                >
                    {__("Mobile Instructions")}
                </button>
            </div>

            <h2 className="border-b text-2xl text-gray-700 dark:border-b-zinc-800 dark:text-white font-semibold mt-5 pb-2">
                {__("RTMP Server URL")}
            </h2>
            <TextInput
                className="text-xl w-full mt-3"
                value={
                    tab === "desktop" ? rtmp_url : `${rtmp_url}/${streamKey}`
                }
            />

            {tab == "desktop" ? (
                <>
                    <h2 className="border-b text-gray-700 text-xl dark:border-b-zinc-800 dark:text-white font-semibold mt-5 pb-2">
                        {__("RTMP Streaming Key")}
                    </h2>
                    <Textarea className="text-xl w-full" value={streamKey} />

                    <h2 className="border-b text-2xl text-gray-700 dark:border-b-zinc-800 dark:text-white font-semibold mt-5 pb-2">
                        {__("Download OBS - Open Broadcaster Software")}
                    </h2>
                    <a
                        className="flex text-xl dark:text-white hover:underline"
                        target="blank"
                        href="https://obsproject.com/"
                    >
                        https://obsproject.com
                    </a>

                    <h2 className="border-b text-2xl text-gray-700 dark:border-b-zinc-800 dark:text-white font-semibold mt-5 pb-2">
                        {__("Go to OBS->Settings->Stream")}
                    </h2>

                    <img src="/images/obs.png" alt="obs.png" />

                    <h2 className="border-b text-2xl text-gray-700 dark:border-b-zinc-800 dark:text-white font-semibold mt-5 pb-2">
                        {__("Happy Streaming!")}
                    </h2>
                </>
            ) : (
                <>
                    <h2 className="border-b text-2xl text-gray-700 dark:border-b-zinc-800 dark:text-white font-semibold mt-5 pb-2">
                        {__(
                            "Get a Mobile RTMP Ingesting App (ex. Larix Broadcaster)"
                        )}
                    </h2>

                    <a
                        className="flex text-xl dark:text-white hover:underline my-5"
                        target="blank"
                        href="https://apps.apple.com/us/app/larix-broadcaster/id1042474385"
                    >
                        Larix Broadcaster iOS
                    </a>

                    <a
                        className="flex text-xl dark:text-white hover:underline my-5"
                        target="blank"
                        href="https://play.google.com/store/apps/details?id=com.wmspanel.larix_broadcaster&hl=en&gl=US&pli=1"
                    >
                        Larix Broadcaster Android
                    </a>

                    <p className="text-gray-700 dark:text-white">
                        {__(
                            "Click Settings Cog -> Connections -> New Connection"
                        )}
                    </p>

                    <a
                        href="https://www.youtube.com/watch?v=Dhj0_QbtfTw&t=24s"
                        target="_blank"
                    >
                        <img src="/images/larix.jpeg" alt="larix app" />
                    </a>
                </>
            )}
        </div>
    );
}
