import { useEffect } from "react";
import __ from "@/Functions/Translate";

export default function HomepageHeader() {
    useEffect(() => {
        const style = document.createElement("style");
        style.innerHTML = `
            @keyframes gradient {
                0% { background-position: 0% 50%; }
                20% { background-position: 20% 50%; }
                40% { background-position: 40% 50%; }
                60% { background-position: 60% 50%; }
                80% { background-position: 80% 50%; }
                100% { background-position: 0% 50%; }
            }

            .animated-gradient {
                background: linear-gradient(-45deg, #ffe145, #f66f04, #bd1a00, #ffce5a);
                background-size: 400% 400%;
                animation: gradient 15s ease infinite;
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
            }
        `;
        document.head.appendChild(style);
    }, []);

    return (
        <>
            {/* Hero Section */}
            <div className="flex h-screen justify-center text-center w-full dark:bg-none homepage-header-bg items-center overflow-hidden relative">
                {/* Background Video */}
                <video 
                    className="h-full w-full absolute left-0 object-cover top-0"
                    src="/videos/homepage_header_video.mp4" 
                    autoPlay 
                    loop 
                    muted
                />

                {/* Overlay */}
                <div className="bg-black bg-opacity-50 h-full w-full absolute left-0 top-0"></div>

                {/* Content */}
                <div className="flex flex-col w-4/5 items-center lg:w-3/5 md:w-full relative">
                    <h1 className="text-5xl animated-gradient font-extrabold lg:text-7xl md:text-6xl px-4">
                        {__("Live Streaming at your fingertips")}
                    </h1>
                    <h2 className="text-2xl dark:text-zinc-200 md:text-3xl mt-6 px-4">
                        {__("Stream & watch live video streams directly from your browser")}
                    </h2>
                </div>
            </div>

            {/* Features Section */}
            <div className="bg-slate-50 dark:bg-black">
                <div className="bg-slate-100 w-full dark:bg-black py-10">
                    <div className="max-w-7xl mx-auto px-4">
                        <h2 className="text-4xl text-center text-indigo-900 dark:text-zinc-200 font-bold">
                            {__("Learn why Creators love our platform")}
                        </h2>
                    </div>
                </div>

                {/* Feature List */}
                <div className="max-w-7xl mx-auto">
                    <div className="md:flex md:flex-wrap">
                        {/* Feature: Live Streaming */}
                        <div className="items-center lg:flex md:w-1/2 px-5 py-10">
                            <div className="flex-shrink-0 w-48 mr-5">
                                <img src="/images/streaming-service.png" alt="live streaming" className="w-full" />
                            </div>
                            <div>
                                <h3 className="text-4xl text-indigo-900 dark:text-zinc-200 font-semibold">
                                    {__("Live Streaming")}
                                </h3>
                                <h4 className="text-indigo-900 text-xl dark:text-zinc-100 mt-5">
                                    {__("Stream directly from your browser. No additional complicated software to install. All you need is your computer & a camera.")}
                                </h4>
                            </div>
                        </div>

                        {/* Feature: Live Chat */}
                        <div className="items-center lg:flex md:w-1/2 px-5 py-10">
                            <div className="flex-shrink-0 w-48 mr-5">
                                <img src="/images/chat-service.png" alt="chat" className="w-full" />
                            </div>
                            <div>
                                <h3 className="text-4xl text-indigo-900 dark:text-zinc-200 font-semibold">
                                    {__("Live Chat")}
                                </h3>
                                <h4 className="text-indigo-900 text-xl dark:text-zinc-100 mt-5">
                                    {__("What would be a live stream without interaction? Your audience can interact with you and each other.")}
                                </h4>
                            </div>
                        </div>

                        {/* Feature: Subscription Tiers */}
                        <div className="items-center lg:flex md:w-1/2 px-5 py-10">
                            <div className="flex-shrink-0 w-40 md:w-48 mr-5">
                                <img src="/images/sub-service.png" alt="goals" className="w-full" />
                            </div>
                            <div>
                                <h3 className="text-4xl text-indigo-900 dark:text-zinc-200 font-semibold">
                                    {__("Subscription Tiers")}
                                </h3>
                                <h4 className="text-indigo-900 text-xl dark:text-zinc-100 mt-5">
                                    {__("Get recurring revenue from your fan base via membership tiers. You can offer 1, 6 and 12 months with discounts option.")}
                                </h4>
                            </div>
                        </div>

                        {/* Feature: Tips */}
                        <div className="items-center lg:flex md:w-1/2 px-5 py-10">
                            <div className="flex-shrink-0 w-48 mr-5">
                                <img src="/images/tips-service.png" alt="tips" className="w-full" />
                            </div>
                            <div>
                                <h3 className="text-4xl text-indigo-900 dark:text-zinc-200 font-semibold">
                                    {__("Tips")}
                                </h3>
                                <h4 className="text-indigo-900 text-xl dark:text-zinc-100 mt-5">
                                    {__("Every creator has their fans - the moment you get your first rewarding is an incredible appreciation sign for your hard work.")}
                                </h4>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </>
    );
}
