import React, { ReactNode } from "react";
export interface CookieConsentProps {
    children?: ReactNode;
    style: React.CSSProperties;
    buttonStyle: React.CSSProperties;
    declineButtonStyle: React.CSSProperties;
    contentStyle: React.CSSProperties;
    disableStyles: boolean;
    hideOnAccept: boolean;
    hideOnDecline: boolean;
    onAccept: (acceptedByScrolling: boolean) => void;
    onDecline: () => void;
    buttonText: string | ReactNode | Function;
    declineButtonText: string | ReactNode | Function;
    cookieName: string;
    cookieValue: string | object;
    declineCookieValue: string | object;
    setDeclineCookie: boolean;
    debug: boolean;
    expires: number;
    containerClasses: string;
    contentClasses: string;
    buttonClasses: string;
    buttonWrapperClasses: string;
    declineButtonClasses: string;
    buttonId: string;
    declineButtonId: string;
    overlayClasses: string;
    ariaAcceptLabel: string;
    ariaDeclineLabel: string;
    disableButtonStyles: boolean;
    enableDeclineButton: boolean;
    flipButtons: boolean;
    cookieSecurity?: boolean;
    overlay: boolean;
    acceptOnOverlayClick: boolean;
    acceptOnScroll: boolean;
    acceptOnScrollPercentage: number;
    ButtonComponent: any;
    extraCookieOptions: Object;
    overlayStyle: Object;
    customContentAttributes: Object;
    customContainerAttributes: Object;
    customButtonProps: Object;
    customDeclineButtonProps: Object;
    customButtonWrapperAttributes: Object;
    onOverlayClick: () => void;
    location: string;
    visible: string;
    sameSite: "strict" | "Strict" | "lax" | "Lax" | "none" | "None" | undefined;
}
export declare const defaultCookieConsentProps: CookieConsentProps;
