import AgoraRTM__default from 'agora-rtm-sdk';
export * from 'agora-rtm-sdk';

var createClient = function createClient(appId, config, areaCodes) {
  var client;
  function createClosure() {
    if (!client) {
      client = AgoraRTM__default.createInstance(appId, config, areaCodes);
    }
    return client;
  }
  return function () {
    return createClosure();
  };
};
var createChannel = function createChannel(channelId) {
  var channel;
  function createClosure(client) {
    if (!channel) {
      channel = client.createChannel(channelId);
    }
    return channel;
  }
  return function (client) {
    return createClosure(client);
  };
};
var createLazyClient = function createLazyClient() {
  var client;
  function createClosure(appId, config, areaCodes) {
    if (!client) {
      client = AgoraRTM__default.createInstance(appId, config, areaCodes);
    }
    return client;
  }
  return function (appId, config, areaCodes) {
    return createClosure(appId, config, areaCodes);
  };
};
var createLazyChannel = function createLazyChannel() {
  var channel;
  function createClosure(client, channelId) {
    if (!channel) {
      channel = client.createChannel(channelId);
    }
    return channel;
  }
  return function (client, channelId) {
    return createClosure(client, channelId);
  };
};
var AreaCode;
(function (AreaCode) {
  AreaCode["GLOBAL"] = "GLOBAL";
  AreaCode["INDIA"] = "INDIA";
  AreaCode["JAPAN"] = "JAPAN";
  AreaCode["ASIA"] = "ASIA";
  AreaCode["EUROPE"] = "EUROPE";
  AreaCode["CHINA"] = "CHINA";
  AreaCode["NORTH_AMERICA"] = "NORTH_AMERICA";
})(AreaCode || (AreaCode = {}));

export default AgoraRTM__default;
export { createChannel, createClient, createLazyChannel, createLazyClient };
//# sourceMappingURL=index.modern.js.map
