import { AblyChannel } from './ably-channel';
import { AblyAuth } from './ably/auth';
import { PresenceChannel } from './presence-channel';
/**
 * This class represents an Ably presence channel.
 */
export declare class AblyPresenceChannel extends AblyChannel implements PresenceChannel {
    presenceData: any;
    constructor(ably: any, name: string, options: any, auth: AblyAuth);
    unsubscribe(): void;
    /**
     * Register a callback to be called anytime the member list changes.
     */
    here(callback: Function): AblyPresenceChannel;
    /**
     * Listen for someone joining the channel.
     */
    joining(callback: Function): AblyPresenceChannel;
    /**
     * Listen for someone leaving the channel.
     */
    leaving(callback: Function): AblyPresenceChannel;
    /**
     * Enter presence
     * @param data - Data to be published while entering the channel
     * @param callback - success/error callback (err) => {}
     * @returns AblyPresenceChannel
     */
    enter(data: any, callback: Function): AblyPresenceChannel;
    /**
     * Leave presence
     * @param data - Data to be published while leaving the channel
     * @param callback - success/error callback (err) => {}
     * @returns AblyPresenceChannel
     */
    leave(data: any, callback?: Function): AblyPresenceChannel;
    /**
     * Update presence
     * @param data - Update presence with data
     * @param callback - success/error callback (err) => {}
     * @returns AblyPresenceChannel
     */
    update(data: any, callback: Function): AblyPresenceChannel;
    /**
     * Trigger client event on the channel.
     */
    whisper(eventName: string, data: any, callback?: Function): AblyPresenceChannel;
}
