<?php
if (IS_LOGGED == false) {
    exit("You ain't logged in!");
}

$track_id = 0;
if (!empty($_REQUEST['id'])) {
    $track_id = secure($_REQUEST['id']);
}
if (empty($track_id)) {
    exit("Invalid Track ID");
}

$getTrack = $db->where('id', $track_id)->getOne(T_SONGS);
if (empty($getTrack)) {
    exit("Invalid Track ID");
}

$data['status'] = 400;

if (empty($_POST['track_description'])) {
    $errors[] = lang("Please describe your request.");
}

if (empty($errors)) {
    $description = secure($_POST['track_description']);
    $final_array = ['track_id' => $track_id, 'description' => $description, 'time' => time(), 'user_id' => $user->id];
    $insert_report = $db->insert(T_REPORTS, $final_array);
    if ($insert_report) {
        runPlugin('AfterSongReported', $final_array);
        RecordUserActivities('report_track',array('track_user_id' => $getTrack->user_id, 'audio_id' => $getTrack->audio_id));
        $notif_data = array(
            'recipient_id' => 0,
            'type' => 'report',
            'admin' => 1,
            'time' => time()
        );
        $db->insert(T_NOTIFICATION,$notif_data);
        $data['status'] = 200;
    }
} else {
    $data['status'] = 400;
    $data['errors'] = $errors;
}
