<!DOCTYPE html>
<html class="dark" lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" type="image/png" href="<?php echo e(asset(opt('favicon', 'favicon.png'))); ?>" sizes="128x128" />

    <title inertia><?php echo e(opt('seo_title')); ?></title>

    <?php if(request()->route() && request()->route()->getName() == 'home'): ?>
    <meta name="description" content="<?php echo e(opt('seo_desc')); ?>" />
    <meta name="keywords" content="<?php echo e(opt('seo_keys')); ?>" />
    <?php endif; ?>

    <meta property="og:title" content="Mo Streams Gaming Platform" />
    <meta property="og:url" content="https://gaming.mostreams.com/" />
    <meta property="og:image" content="https://gaming.mostreams.com/public/images/Logo_Background.jpg" />


    <!-- Fonts -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('fonts/nunito/fonts.css')); ?>" />

    <script>
        window.PUSHER_KEY = '<?php echo e(env('PUSHER_APP_KEY')); ?>';
        window.PUSHER_CLUSTER = '<?php echo e(env('PUSHER_APP_CLUSTER')); ?>';
    </script>

    <!-- Scripts -->
    <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>
    <?php echo app('Illuminate\Foundation\Vite')->reactRefresh(); ?>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.jsx', "resources/js/Pages/{$page['component']}.jsx"]); ?>
    <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->head; } ?>

</head>

<body class="font-sans antialiased ">
    <div class="min-h-screen flex flex-col flex-auto flex-shrink-0">
        <?php if (isset($component)) { $__componentOriginalb013490f51a30cb3b5995d67d274073c1a17ea7b = $component; } ?>
<?php $component = App\View\Components\Translations::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('Translations'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Translations::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb013490f51a30cb3b5995d67d274073c1a17ea7b)): ?>
<?php $component = $__componentOriginalb013490f51a30cb3b5995d67d274073c1a17ea7b; ?>
<?php unset($__componentOriginalb013490f51a30cb3b5995d67d274073c1a17ea7b); ?>
<?php endif; ?>
        <?php if (!isset($__inertiaSsrDispatched)) { $__inertiaSsrDispatched = true; $__inertiaSsrResponse = app(\Inertia\Ssr\Gateway::class)->dispatch($page); }  if ($__inertiaSsrResponse) { echo $__inertiaSsrResponse->body; } else { ?><div id="app" data-page="<?php echo e(json_encode($page)); ?>"></div><?php } ?>
        <div id="modal-root"></div>
    </div>
</body>

</html><?php /**PATH /home/mostream/public_html/gaming.mostreams.com/resources/views/app.blade.php ENDPATH**/ ?>