<?php $__env->startSection('section_title'); ?>
<strong><?php echo e(__('Galleries Created by Streamers')); ?></strong>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('section_body'); ?>


<div class="my-5 bg-gray-200 text-gray-500 font-semibold border-2 border-gray-300 p-3 rounded">
    <?php echo e(__('Here you will find an overview of the galleries created by the streamers.')); ?>

</div>

<?php if(count($videos)): ?>

<div class="flex items-center justify-end p-5">
    <form method="GET">
        <div class="flex items-center">
            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input','data' => ['name' => 'search','class' => 'w-52 block mr-1','id' => 'search','type' => 'text']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'search','class' => 'w-52 block mr-1','id' => 'search','type' => 'text']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
            <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.button','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?><?php echo e(__('Search')); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
        </div>
    </form>
</div>

<div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 px-4">
    <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="mr-5 mb-5 border-2 rounded-lg">
        <div class="flex items-center p-2">
            <div class="w-10 flex-shrink-0 mr-2">
                <a target="_blank" href=<?php echo e(route("channel", ["user"=> $v->user->username])); ?>>
                    <img src=<?php echo e($v->user->profile_picture); ?> class="w-10 h-10 rounded-full" />
                </a>
            </div>
            <div class="flex-grow">
                <a target="_blank" href=<?php echo e(route("channel", ["user"=> $v->user->username])); ?>>
                    <p class="font-semibold text-gray-900 dark:text-gray-100">
                        <?php echo e('@' . $v->user->username); ?>

                    </p>
                </a>
            </div>
        </div>
        <div class="relative">
            <a href="/admin/galleries/view/<?php echo e($v->id); ?>" class="font-semibold dark:text-gray-100 hover:text-gray-800 text-gray-600 dark:hover:text-gray-400">
                <img src="<?php echo e($v->thumbnail); ?>" class="rounded-lg mb-3 " alt="" />
            </a>
            <div class="top-0 bg-indigo-800 text-white font-bold text-sm uppercase rounded-tr rounded-br px-2 py-1">
                <?php echo e(__("Price: ")); ?> <?php echo e($v->price < 1 ? __("Free") : $v->price . __(" tokens")); ?>

            </div>
            <div class="top-0 bg-yellow-400 text-white font-bold text-sm uppercase rounded-tr rounded-br px-2 py-1">
                <?php echo e(__("Photos: ")); ?> <?php echo e($v->photos->count()); ?>

            </div>
            <div class="top-0 bg-white-400 text-stone-400 font-bold text-sm uppercase rounded-tr rounded-br px-2 py-1">
                <?php echo e(__("Sales: ")); ?> <?php echo e($v->sales->count()); ?>

            </div>
        </div>
        <div class="w-full">
            <a href="/admin/galleries/view/<?php echo e($v->id); ?>" class="p-2 font-semibold dark:text-gray-100 hover:text-gray-800 text-gray-600 dark:hover:text-gray-400">
                <?php echo e($v->gallery_name); ?>

            </a>

            <a href="/admin/galleries/view/<?php echo e($v->id); ?>" class="p-2 font-semibold dark:text-gray-100 hover:text-gray-800 text-gray-600 dark:hover:text-gray-400">
                <img src=<?php echo e($v->previewPhotoUrl); ?> class="w-full" />
            </a>
        </div>

        <div class="px-2 py-2 flex">
            <a href="/admin/galleries/view/<?php echo e($v->id); ?>"><i class="fa-solid fa-pencil mr-2 text-teal-600"></i></a>
            <a href="/admin/galleries?remove=<?php echo e($v->id); ?>" onclick="return confirm('<?php echo e(__('Are you sure you want to remove this GALLERY?')); ?>')"><i class="fa-solid fa-trash text-red-400"></i></a>
        </div>

    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
</div>

<div class="p-5">
    <?php echo e($videos->links()); ?>

</div>

<?php else: ?>
<div class="bg-white p-3 rounded">
    <?php if(request()->filled('search')): ?>
    <?php echo e(__('No galleries matching ":searchTerm"', ['searchTerm' => request('search')])); ?>

    <a href="/admin/galleries" class="text-cyan-600 hover:underline"><?php echo e(__("Reset Search")); ?></a>
    <?php else: ?>
    <?php echo e(__('No galleries uploaded by streamers.')); ?>

    <?php endif; ?>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('extra_bottom'); ?>
<?php if(count($errors) > 0): ?>
<div class="alert alert-danger">
    <ul>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('adminExtraJS'); ?>
<script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/datatables/datatables.min.js')); ?>"></script>

<script>
    $('.dataTable').dataTable({
        ordering: false
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/crivion/Sites/php-twitcher/resources/views/admin/galleries.blade.php ENDPATH**/ ?>