@extends('admin.base')

@section('section_title')
<strong>{{ __('Galleries Created by Streamers') }}</strong>
@endsection

@section('section_body')


<div class="my-5 bg-gray-200 text-gray-500 font-semibold border-2 border-gray-300 p-3 rounded">
    {{ __('Here you will find an overview of the galleries created by the streamers.') }}
</div>

@if (count($videos))

<div class="flex items-center justify-end p-5">
    <form method="GET">
        <div class="flex items-center">
            <x-input name="search" class="w-52 block mr-1" id="search" type="text" />
            <x-button>{{ __('Search') }}</x-button>
        </div>
    </form>
</div>

<div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 px-4">
    @foreach($videos as $v)
    <div class="mr-5 mb-5 border-2 rounded-lg">
        <div class="flex items-center p-2">
            <div class="w-10 flex-shrink-0 mr-2">
                <a target="_blank" href={{route("channel", ["user"=> $v->user->username]) }}>
                    <img src={{ $v->user->profile_picture}} class="w-10 h-10 rounded-full" />
                </a>
            </div>
            <div class="flex-grow">
                <a target="_blank" href={{route("channel", ["user"=> $v->user->username]) }}>
                    <p class="font-semibold text-gray-900 dark:text-gray-100">
                        {{ '@' . $v->user->username }}
                    </p>
                </a>
            </div>
        </div>
        <div class="relative">
            <a href="/admin/galleries/view/{{ $v->id }}" class="font-semibold dark:text-gray-100 hover:text-gray-800 text-gray-600 dark:hover:text-gray-400">
                <img src="{{$v->thumbnail}}" class="rounded-lg mb-3 " alt="" />
            </a>
            <div class="top-0 bg-indigo-800 text-white font-bold text-sm uppercase rounded-tr rounded-br px-2 py-1">
                {{__("Price: ")}} {{ $v->price < 1 ? __("Free") : $v->price . __(" tokens") }}
            </div>
            <div class="top-0 bg-yellow-400 text-white font-bold text-sm uppercase rounded-tr rounded-br px-2 py-1">
                {{__("Photos: ")}} {{ $v->photos->count() }}
            </div>
            <div class="top-0 bg-white-400 text-stone-400 font-bold text-sm uppercase rounded-tr rounded-br px-2 py-1">
                {{__("Sales: ")}} {{ $v->sales->count() }}
            </div>
        </div>
        <div class="w-full">
            <a href="/admin/galleries/view/{{ $v->id }}" class="p-2 font-semibold dark:text-gray-100 hover:text-gray-800 text-gray-600 dark:hover:text-gray-400">
                {{ $v->gallery_name }}
            </a>

            <a href="/admin/galleries/view/{{ $v->id }}" class="p-2 font-semibold dark:text-gray-100 hover:text-gray-800 text-gray-600 dark:hover:text-gray-400">
                <img src={{ $v->previewPhotoUrl }} class="w-full" />
            </a>
        </div>

        <div class="px-2 py-2 flex">
            <a href="/admin/galleries/view/{{ $v->id }}"><i class="fa-solid fa-pencil mr-2 text-teal-600"></i></a>
            <a href="/admin/galleries?remove={{ $v->id }}" onclick="return confirm('{{ __('Are you sure you want to remove this GALLERY?')  }}')"><i class="fa-solid fa-trash text-red-400"></i></a>
        </div>

    </div>
    @endforeach
</div>
</div>

<div class="p-5">
    {{ $videos->links() }}
</div>

@else
<div class="bg-white p-3 rounded">
    @if(request()->filled('search'))
    {{ __('No galleries matching ":searchTerm"', ['searchTerm' => request('search')]) }}
    <a href="/admin/galleries" class="text-cyan-600 hover:underline">{{ __("Reset Search") }}</a>
    @else
    {{ __('No galleries uploaded by streamers.') }}
    @endif
</div>
@endif
@endsection

@section('extra_bottom')
@if (count($errors) > 0)
<div class="alert alert-danger">
    <ul>
        @foreach ($errors->all() as $error)
        <li>{{ $error }}</li>
        @endforeach
    </ul>
</div>
@endif
@endsection

@push('adminExtraJS')
<script src="{{ asset('js/jquery.min.js') }}"></script>
<script src="{{ asset('js/datatables/datatables.min.js') }}"></script>
{{-- attention, dynamic because only needed on this page to save resources --}}
<script>
    $('.dataTable').dataTable({
        ordering: false
    });
</script>
@endpush
