import Front from "@/Layouts/Front";
import __ from "@/Functions/Translate";
import { Head } from "@inertiajs/inertia-react";
import GalleryLoop from "../Channel/Partials/GalleryLoop";

export default function BrowseGalleries({ galleries, exploreImage }) {
  return (
    <Front
      containerClass="w-full"
      extraHeader={true}
      extraHeaderTitle={__("Browse Galleries")}
      extraHeaderImage={exploreImage}
      extraHeaderText={""}
      extraImageHeight={"h-10"}
    >
      <Head
        title={__("Browse Galleries")}
      />

      <div className="-mt-16">
        {galleries.length < 1 && (
          <div className="text-center text-xl font-medium dark:text-white text-gray-700">
            {__("No galleries to show")}
          </div>
        )}
        <GalleryLoop galleries={galleries.data} />
      </div>
    </Front>);
}
