import { useState, useEffect } from "react";
import __ from "@/Functions/Translate";
import { MdGeneratingTokens, MdOutlineInsertPhoto } from "react-icons/md";
import { Link } from "@inertiajs/inertia-react";
import { Tooltip } from "react-tooltip";
import "react-tooltip/dist/react-tooltip.css";
import Modal from "@/Components/Modal";
import SingleGallery from "@/Pages/Galleries/SingleGallery";

export default function GalleryLoop({ galleries }) {

  const [playVideo, setPlayVideo] = useState(false);
  const [modal, setModal] = useState(false);

  const playModal = (e, video) => {
    e.preventDefault();
    setPlayVideo(video);
    setModal(true);
  };

  const closeModal = () => {
    setModal(false);
  };

  return (<>
    <Modal show={modal} onClose={(e) => setModal(false)}>
      {playVideo && (
        <SingleGallery
          gallery={playVideo}
          inModal={true}
          closeModal={closeModal}
        />
      )}
    </Modal>
    {/* <div className="flex flex-wrap items-center md:mx-0 md:justify-start"> */}
    <div className="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6 gap-x-4 ">
      {galleries.map((v) => (
        <div
          className="mb-4 bg-white dark:bg-zinc-900 shadow rounded-lg"
          key={`gallery-${v.id}`}
        >
          <div className="relative w-full">
            <button onClick={(e) => playModal(e, v)}>
              <img
                src={v.previewPhotoUrl}
                className="rounded-t-lg mb-3 w-full h-full max-w-full"
                alt=""
              />
            </button>
            <div className="absolute top-5 left-0 bg-indigo-800 text-white font-bold text-sm uppercase rounded-tr rounded-br px-2 py-1">
              {v.price < 1 ? (
                __("Free")
              ) : (
                <div className="flex items-center">
                  <MdGeneratingTokens className="h-4 w-4 mr-1" />
                  {v.price}
                </div>
              )}
            </div>
          </div>
          <div className="flex flex-wrap items-center px-2 pb-2">
            <div className="w-10 flex-shrink-0 mr-2">
              <img
                src={v.user.profile_picture}
                className="w-10 h-10 rounded-full"
              />
            </div>
            <div>
              <div className="h-5 overflow-hidden">
                <a
                  data-tooltip-content={v.gallery_name}
                  data-tooltip-id={`tooltip-btng-${v.id}`}
                  onClick={(e) => playModal(e, v)}
                  className="cursor-pointer font-semibold inline  dark:text-gray-100 hover:text-gray-800 text-gray-600 dark:hover:text-gray-400"
                >
                  {v.gallery_name}
                </a>
              </div>
              <div className="mt-1.5 flex items-center text-xs text-gray-500 dark:text-gray-200">
                <div>
                  <Link
                    href={route("channel", {
                      user: v.user.username,
                    })}
                  >
                    @{v.user.username}
                  </Link>

                  <Tooltip anchorSelect="a" />
                </div>
                <div className="ml-2 inline-flex items-center">
                  <MdOutlineInsertPhoto className="w-4 h-4 mr-0.5" />
                  {v.photos_count === 1
                    ? __("1 photo")
                    : __(":photosCount photos", {
                      photosCount: v.photos_count,
                    })}
                </div>
              </div>
            </div>
          </div>
        </div>
      ))}
    </div>
  </>);
}
