import React from "react";

export default function PrimaryButton({
    type = "submit",
    className = "",
    processing,
    children,
    onClick,
}) {
    return (
        <button
            type={type}
            onClick={onClick}
            className={
                `border border-orange-400 rounded text-orange-400 font-bold hover:border-orange-700 hover:text-orange-700 inline-block mb-4 mt-5 px-4 py-2 ${
                    processing && "opacity-25"
                } ` + className
            }
            disabled={processing}
        >
            {children}
        </button>
    );
}
