"use strict";
const app = "";
var commonjsGlobal =
    typeof globalThis !== "undefined"
        ? globalThis
        : typeof window !== "undefined"
        ? window
        : typeof global !== "undefined"
        ? global
        : typeof self !== "undefined"
        ? self
        : {};
function getDefaultExportFromCjs(x) {
    return x &&
        x.__esModule &&
        Object.prototype.hasOwnProperty.call(x, "default")
        ? x["default"]
        : x;
}
var lodash = { exports: {} };
/**
 * @license
 * Lodash <https://lodash.com/>
 * Copyright OpenJS Foundation and other contributors <https://openjsf.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */
(function (module, exports) {
    (function () {
        var undefined$1;
        var VERSION2 = "4.17.21";
        var LARGE_ARRAY_SIZE2 = 200;
        var CORE_ERROR_TEXT =
                "Unsupported core-js use. Try https://npms.io/search?q=ponyfill.",
            FUNC_ERROR_TEXT = "Expected a function",
            INVALID_TEMPL_VAR_ERROR_TEXT =
                "Invalid `variable` option passed into `_.template`";
        var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
        var MAX_MEMOIZE_SIZE = 500;
        var PLACEHOLDER = "__lodash_placeholder__";
        var CLONE_DEEP_FLAG = 1,
            CLONE_FLAT_FLAG = 2,
            CLONE_SYMBOLS_FLAG = 4;
        var COMPARE_PARTIAL_FLAG2 = 1,
            COMPARE_UNORDERED_FLAG2 = 2;
        var WRAP_BIND_FLAG = 1,
            WRAP_BIND_KEY_FLAG = 2,
            WRAP_CURRY_BOUND_FLAG = 4,
            WRAP_CURRY_FLAG = 8,
            WRAP_CURRY_RIGHT_FLAG = 16,
            WRAP_PARTIAL_FLAG = 32,
            WRAP_PARTIAL_RIGHT_FLAG = 64,
            WRAP_ARY_FLAG = 128,
            WRAP_REARG_FLAG = 256,
            WRAP_FLIP_FLAG = 512;
        var DEFAULT_TRUNC_LENGTH = 30,
            DEFAULT_TRUNC_OMISSION = "...";
        var HOT_COUNT2 = 800,
            HOT_SPAN2 = 16;
        var LAZY_FILTER_FLAG = 1,
            LAZY_MAP_FLAG = 2,
            LAZY_WHILE_FLAG = 3;
        var INFINITY = 1 / 0,
            MAX_SAFE_INTEGER2 = 9007199254740991,
            MAX_INTEGER = 17976931348623157e292,
            NAN = 0 / 0;
        var MAX_ARRAY_LENGTH = 4294967295,
            MAX_ARRAY_INDEX = MAX_ARRAY_LENGTH - 1,
            HALF_MAX_ARRAY_LENGTH = MAX_ARRAY_LENGTH >>> 1;
        var wrapFlags = [
            ["ary", WRAP_ARY_FLAG],
            ["bind", WRAP_BIND_FLAG],
            ["bindKey", WRAP_BIND_KEY_FLAG],
            ["curry", WRAP_CURRY_FLAG],
            ["curryRight", WRAP_CURRY_RIGHT_FLAG],
            ["flip", WRAP_FLIP_FLAG],
            ["partial", WRAP_PARTIAL_FLAG],
            ["partialRight", WRAP_PARTIAL_RIGHT_FLAG],
            ["rearg", WRAP_REARG_FLAG],
        ];
        var argsTag2 = "[object Arguments]",
            arrayTag2 = "[object Array]",
            asyncTag2 = "[object AsyncFunction]",
            boolTag2 = "[object Boolean]",
            dateTag2 = "[object Date]",
            domExcTag = "[object DOMException]",
            errorTag2 = "[object Error]",
            funcTag2 = "[object Function]",
            genTag2 = "[object GeneratorFunction]",
            mapTag2 = "[object Map]",
            numberTag2 = "[object Number]",
            nullTag2 = "[object Null]",
            objectTag2 = "[object Object]",
            promiseTag2 = "[object Promise]",
            proxyTag2 = "[object Proxy]",
            regexpTag2 = "[object RegExp]",
            setTag2 = "[object Set]",
            stringTag2 = "[object String]",
            symbolTag2 = "[object Symbol]",
            undefinedTag2 = "[object Undefined]",
            weakMapTag2 = "[object WeakMap]",
            weakSetTag = "[object WeakSet]";
        var arrayBufferTag2 = "[object ArrayBuffer]",
            dataViewTag2 = "[object DataView]",
            float32Tag2 = "[object Float32Array]",
            float64Tag2 = "[object Float64Array]",
            int8Tag2 = "[object Int8Array]",
            int16Tag2 = "[object Int16Array]",
            int32Tag2 = "[object Int32Array]",
            uint8Tag2 = "[object Uint8Array]",
            uint8ClampedTag2 = "[object Uint8ClampedArray]",
            uint16Tag2 = "[object Uint16Array]",
            uint32Tag2 = "[object Uint32Array]";
        var reEmptyStringLeading = /\b__p \+= '';/g,
            reEmptyStringMiddle = /\b(__p \+=) '' \+/g,
            reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
        var reEscapedHtml = /&(?:amp|lt|gt|quot|#39);/g,
            reUnescapedHtml = /[&<>"']/g,
            reHasEscapedHtml = RegExp(reEscapedHtml.source),
            reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
        var reEscape = /<%-([\s\S]+?)%>/g,
            reEvaluate = /<%([\s\S]+?)%>/g,
            reInterpolate = /<%=([\s\S]+?)%>/g;
        var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,
            reIsPlainProp = /^\w*$/,
            rePropName =
                /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
        var reRegExpChar2 = /[\\^$.*+?()[\]{}|]/g,
            reHasRegExpChar = RegExp(reRegExpChar2.source);
        var reTrimStart = /^\s+/;
        var reWhitespace = /\s/;
        var reWrapComment = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/,
            reWrapDetails = /\{\n\/\* \[wrapped with (.+)\] \*/,
            reSplitDetails = /,? & /;
        var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;
        var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
        var reEscapeChar = /\\(\\)?/g;
        var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
        var reFlags = /\w*$/;
        var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
        var reIsBinary = /^0b[01]+$/i;
        var reIsHostCtor2 = /^\[object .+?Constructor\]$/;
        var reIsOctal = /^0o[0-7]+$/i;
        var reIsUint2 = /^(?:0|[1-9]\d*)$/;
        var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;
        var reNoMatch = /($^)/;
        var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
        var rsAstralRange = "\\ud800-\\udfff",
            rsComboMarksRange = "\\u0300-\\u036f",
            reComboHalfMarksRange = "\\ufe20-\\ufe2f",
            rsComboSymbolsRange = "\\u20d0-\\u20ff",
            rsComboRange =
                rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
            rsDingbatRange = "\\u2700-\\u27bf",
            rsLowerRange = "a-z\\xdf-\\xf6\\xf8-\\xff",
            rsMathOpRange = "\\xac\\xb1\\xd7\\xf7",
            rsNonCharRange = "\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf",
            rsPunctuationRange = "\\u2000-\\u206f",
            rsSpaceRange =
                " \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000",
            rsUpperRange = "A-Z\\xc0-\\xd6\\xd8-\\xde",
            rsVarRange = "\\ufe0e\\ufe0f",
            rsBreakRange =
                rsMathOpRange +
                rsNonCharRange +
                rsPunctuationRange +
                rsSpaceRange;
        var rsApos = "['\u2019]",
            rsAstral = "[" + rsAstralRange + "]",
            rsBreak = "[" + rsBreakRange + "]",
            rsCombo = "[" + rsComboRange + "]",
            rsDigits = "\\d+",
            rsDingbat = "[" + rsDingbatRange + "]",
            rsLower = "[" + rsLowerRange + "]",
            rsMisc =
                "[^" +
                rsAstralRange +
                rsBreakRange +
                rsDigits +
                rsDingbatRange +
                rsLowerRange +
                rsUpperRange +
                "]",
            rsFitz = "\\ud83c[\\udffb-\\udfff]",
            rsModifier = "(?:" + rsCombo + "|" + rsFitz + ")",
            rsNonAstral = "[^" + rsAstralRange + "]",
            rsRegional = "(?:\\ud83c[\\udde6-\\uddff]){2}",
            rsSurrPair = "[\\ud800-\\udbff][\\udc00-\\udfff]",
            rsUpper = "[" + rsUpperRange + "]",
            rsZWJ = "\\u200d";
        var rsMiscLower = "(?:" + rsLower + "|" + rsMisc + ")",
            rsMiscUpper = "(?:" + rsUpper + "|" + rsMisc + ")",
            rsOptContrLower = "(?:" + rsApos + "(?:d|ll|m|re|s|t|ve))?",
            rsOptContrUpper = "(?:" + rsApos + "(?:D|LL|M|RE|S|T|VE))?",
            reOptMod = rsModifier + "?",
            rsOptVar = "[" + rsVarRange + "]?",
            rsOptJoin =
                "(?:" +
                rsZWJ +
                "(?:" +
                [rsNonAstral, rsRegional, rsSurrPair].join("|") +
                ")" +
                rsOptVar +
                reOptMod +
                ")*",
            rsOrdLower = "\\d*(?:1st|2nd|3rd|(?![123])\\dth)(?=\\b|[A-Z_])",
            rsOrdUpper = "\\d*(?:1ST|2ND|3RD|(?![123])\\dTH)(?=\\b|[a-z_])",
            rsSeq = rsOptVar + reOptMod + rsOptJoin,
            rsEmoji =
                "(?:" +
                [rsDingbat, rsRegional, rsSurrPair].join("|") +
                ")" +
                rsSeq,
            rsSymbol =
                "(?:" +
                [
                    rsNonAstral + rsCombo + "?",
                    rsCombo,
                    rsRegional,
                    rsSurrPair,
                    rsAstral,
                ].join("|") +
                ")";
        var reApos = RegExp(rsApos, "g");
        var reComboMark = RegExp(rsCombo, "g");
        var reUnicode = RegExp(
            rsFitz + "(?=" + rsFitz + ")|" + rsSymbol + rsSeq,
            "g"
        );
        var reUnicodeWord = RegExp(
            [
                rsUpper +
                    "?" +
                    rsLower +
                    "+" +
                    rsOptContrLower +
                    "(?=" +
                    [rsBreak, rsUpper, "$"].join("|") +
                    ")",
                rsMiscUpper +
                    "+" +
                    rsOptContrUpper +
                    "(?=" +
                    [rsBreak, rsUpper + rsMiscLower, "$"].join("|") +
                    ")",
                rsUpper + "?" + rsMiscLower + "+" + rsOptContrLower,
                rsUpper + "+" + rsOptContrUpper,
                rsOrdUpper,
                rsOrdLower,
                rsDigits,
                rsEmoji,
            ].join("|"),
            "g"
        );
        var reHasUnicode = RegExp(
            "[" + rsZWJ + rsAstralRange + rsComboRange + rsVarRange + "]"
        );
        var reHasUnicodeWord =
            /[a-z][A-Z]|[A-Z]{2}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;
        var contextProps = [
            "Array",
            "Buffer",
            "DataView",
            "Date",
            "Error",
            "Float32Array",
            "Float64Array",
            "Function",
            "Int8Array",
            "Int16Array",
            "Int32Array",
            "Map",
            "Math",
            "Object",
            "Promise",
            "RegExp",
            "Set",
            "String",
            "Symbol",
            "TypeError",
            "Uint8Array",
            "Uint8ClampedArray",
            "Uint16Array",
            "Uint32Array",
            "WeakMap",
            "_",
            "clearTimeout",
            "isFinite",
            "parseInt",
            "setTimeout",
        ];
        var templateCounter = -1;
        var typedArrayTags2 = {};
        typedArrayTags2[float32Tag2] =
            typedArrayTags2[float64Tag2] =
            typedArrayTags2[int8Tag2] =
            typedArrayTags2[int16Tag2] =
            typedArrayTags2[int32Tag2] =
            typedArrayTags2[uint8Tag2] =
            typedArrayTags2[uint8ClampedTag2] =
            typedArrayTags2[uint16Tag2] =
            typedArrayTags2[uint32Tag2] =
                true;
        typedArrayTags2[argsTag2] =
            typedArrayTags2[arrayTag2] =
            typedArrayTags2[arrayBufferTag2] =
            typedArrayTags2[boolTag2] =
            typedArrayTags2[dataViewTag2] =
            typedArrayTags2[dateTag2] =
            typedArrayTags2[errorTag2] =
            typedArrayTags2[funcTag2] =
            typedArrayTags2[mapTag2] =
            typedArrayTags2[numberTag2] =
            typedArrayTags2[objectTag2] =
            typedArrayTags2[regexpTag2] =
            typedArrayTags2[setTag2] =
            typedArrayTags2[stringTag2] =
            typedArrayTags2[weakMapTag2] =
                false;
        var cloneableTags = {};
        cloneableTags[argsTag2] =
            cloneableTags[arrayTag2] =
            cloneableTags[arrayBufferTag2] =
            cloneableTags[dataViewTag2] =
            cloneableTags[boolTag2] =
            cloneableTags[dateTag2] =
            cloneableTags[float32Tag2] =
            cloneableTags[float64Tag2] =
            cloneableTags[int8Tag2] =
            cloneableTags[int16Tag2] =
            cloneableTags[int32Tag2] =
            cloneableTags[mapTag2] =
            cloneableTags[numberTag2] =
            cloneableTags[objectTag2] =
            cloneableTags[regexpTag2] =
            cloneableTags[setTag2] =
            cloneableTags[stringTag2] =
            cloneableTags[symbolTag2] =
            cloneableTags[uint8Tag2] =
            cloneableTags[uint8ClampedTag2] =
            cloneableTags[uint16Tag2] =
            cloneableTags[uint32Tag2] =
                true;
        cloneableTags[errorTag2] =
            cloneableTags[funcTag2] =
            cloneableTags[weakMapTag2] =
                false;
        var deburredLetters = {
            "\xC0": "A",
            "\xC1": "A",
            "\xC2": "A",
            "\xC3": "A",
            "\xC4": "A",
            "\xC5": "A",
            "\xE0": "a",
            "\xE1": "a",
            "\xE2": "a",
            "\xE3": "a",
            "\xE4": "a",
            "\xE5": "a",
            "\xC7": "C",
            "\xE7": "c",
            "\xD0": "D",
            "\xF0": "d",
            "\xC8": "E",
            "\xC9": "E",
            "\xCA": "E",
            "\xCB": "E",
            "\xE8": "e",
            "\xE9": "e",
            "\xEA": "e",
            "\xEB": "e",
            "\xCC": "I",
            "\xCD": "I",
            "\xCE": "I",
            "\xCF": "I",
            "\xEC": "i",
            "\xED": "i",
            "\xEE": "i",
            "\xEF": "i",
            "\xD1": "N",
            "\xF1": "n",
            "\xD2": "O",
            "\xD3": "O",
            "\xD4": "O",
            "\xD5": "O",
            "\xD6": "O",
            "\xD8": "O",
            "\xF2": "o",
            "\xF3": "o",
            "\xF4": "o",
            "\xF5": "o",
            "\xF6": "o",
            "\xF8": "o",
            "\xD9": "U",
            "\xDA": "U",
            "\xDB": "U",
            "\xDC": "U",
            "\xF9": "u",
            "\xFA": "u",
            "\xFB": "u",
            "\xFC": "u",
            "\xDD": "Y",
            "\xFD": "y",
            "\xFF": "y",
            "\xC6": "Ae",
            "\xE6": "ae",
            "\xDE": "Th",
            "\xFE": "th",
            "\xDF": "ss",
            "\u0100": "A",
            "\u0102": "A",
            "\u0104": "A",
            "\u0101": "a",
            "\u0103": "a",
            "\u0105": "a",
            "\u0106": "C",
            "\u0108": "C",
            "\u010A": "C",
            "\u010C": "C",
            "\u0107": "c",
            "\u0109": "c",
            "\u010B": "c",
            "\u010D": "c",
            "\u010E": "D",
            "\u0110": "D",
            "\u010F": "d",
            "\u0111": "d",
            "\u0112": "E",
            "\u0114": "E",
            "\u0116": "E",
            "\u0118": "E",
            "\u011A": "E",
            "\u0113": "e",
            "\u0115": "e",
            "\u0117": "e",
            "\u0119": "e",
            "\u011B": "e",
            "\u011C": "G",
            "\u011E": "G",
            "\u0120": "G",
            "\u0122": "G",
            "\u011D": "g",
            "\u011F": "g",
            "\u0121": "g",
            "\u0123": "g",
            "\u0124": "H",
            "\u0126": "H",
            "\u0125": "h",
            "\u0127": "h",
            "\u0128": "I",
            "\u012A": "I",
            "\u012C": "I",
            "\u012E": "I",
            "\u0130": "I",
            "\u0129": "i",
            "\u012B": "i",
            "\u012D": "i",
            "\u012F": "i",
            "\u0131": "i",
            "\u0134": "J",
            "\u0135": "j",
            "\u0136": "K",
            "\u0137": "k",
            "\u0138": "k",
            "\u0139": "L",
            "\u013B": "L",
            "\u013D": "L",
            "\u013F": "L",
            "\u0141": "L",
            "\u013A": "l",
            "\u013C": "l",
            "\u013E": "l",
            "\u0140": "l",
            "\u0142": "l",
            "\u0143": "N",
            "\u0145": "N",
            "\u0147": "N",
            "\u014A": "N",
            "\u0144": "n",
            "\u0146": "n",
            "\u0148": "n",
            "\u014B": "n",
            "\u014C": "O",
            "\u014E": "O",
            "\u0150": "O",
            "\u014D": "o",
            "\u014F": "o",
            "\u0151": "o",
            "\u0154": "R",
            "\u0156": "R",
            "\u0158": "R",
            "\u0155": "r",
            "\u0157": "r",
            "\u0159": "r",
            "\u015A": "S",
            "\u015C": "S",
            "\u015E": "S",
            "\u0160": "S",
            "\u015B": "s",
            "\u015D": "s",
            "\u015F": "s",
            "\u0161": "s",
            "\u0162": "T",
            "\u0164": "T",
            "\u0166": "T",
            "\u0163": "t",
            "\u0165": "t",
            "\u0167": "t",
            "\u0168": "U",
            "\u016A": "U",
            "\u016C": "U",
            "\u016E": "U",
            "\u0170": "U",
            "\u0172": "U",
            "\u0169": "u",
            "\u016B": "u",
            "\u016D": "u",
            "\u016F": "u",
            "\u0171": "u",
            "\u0173": "u",
            "\u0174": "W",
            "\u0175": "w",
            "\u0176": "Y",
            "\u0177": "y",
            "\u0178": "Y",
            "\u0179": "Z",
            "\u017B": "Z",
            "\u017D": "Z",
            "\u017A": "z",
            "\u017C": "z",
            "\u017E": "z",
            "\u0132": "IJ",
            "\u0133": "ij",
            "\u0152": "Oe",
            "\u0153": "oe",
            "\u0149": "'n",
            "\u017F": "s",
        };
        var htmlEscapes = {
            "&": "&amp;",
            "<": "&lt;",
            ">": "&gt;",
            '"': "&quot;",
            "'": "&#39;",
        };
        var htmlUnescapes = {
            "&amp;": "&",
            "&lt;": "<",
            "&gt;": ">",
            "&quot;": '"',
            "&#39;": "'",
        };
        var stringEscapes = {
            "\\": "\\",
            "'": "'",
            "\n": "n",
            "\r": "r",
            "\u2028": "u2028",
            "\u2029": "u2029",
        };
        var freeParseFloat = parseFloat,
            freeParseInt = parseInt;
        var freeGlobal2 =
            typeof commonjsGlobal == "object" &&
            commonjsGlobal &&
            commonjsGlobal.Object === Object &&
            commonjsGlobal;
        var freeSelf2 =
            typeof self == "object" && self && self.Object === Object && self;
        var root2 = freeGlobal2 || freeSelf2 || Function("return this")();
        var freeExports = exports && !exports.nodeType && exports;
        var freeModule =
            freeExports && true && module && !module.nodeType && module;
        var moduleExports = freeModule && freeModule.exports === freeExports;
        var freeProcess = moduleExports && freeGlobal2.process;
        var nodeUtil2 = (function () {
            try {
                var types =
                    freeModule &&
                    freeModule.require &&
                    freeModule.require("util").types;
                if (types) {
                    return types;
                }
                return (
                    freeProcess &&
                    freeProcess.binding &&
                    freeProcess.binding("util")
                );
            } catch (e) {}
        })();
        var nodeIsArrayBuffer = nodeUtil2 && nodeUtil2.isArrayBuffer,
            nodeIsDate = nodeUtil2 && nodeUtil2.isDate,
            nodeIsMap = nodeUtil2 && nodeUtil2.isMap,
            nodeIsRegExp = nodeUtil2 && nodeUtil2.isRegExp,
            nodeIsSet = nodeUtil2 && nodeUtil2.isSet,
            nodeIsTypedArray2 = nodeUtil2 && nodeUtil2.isTypedArray;
        function apply2(func, thisArg, args) {
            switch (args.length) {
                case 0:
                    return func.call(thisArg);
                case 1:
                    return func.call(thisArg, args[0]);
                case 2:
                    return func.call(thisArg, args[0], args[1]);
                case 3:
                    return func.call(thisArg, args[0], args[1], args[2]);
            }
            return func.apply(thisArg, args);
        }
        function arrayAggregator(array, setter, iteratee, accumulator) {
            var index2 = -1,
                length = array == null ? 0 : array.length;
            while (++index2 < length) {
                var value = array[index2];
                setter(accumulator, value, iteratee(value), array);
            }
            return accumulator;
        }
        function arrayEach(array, iteratee) {
            var index2 = -1,
                length = array == null ? 0 : array.length;
            while (++index2 < length) {
                if (iteratee(array[index2], index2, array) === false) {
                    break;
                }
            }
            return array;
        }
        function arrayEachRight(array, iteratee) {
            var length = array == null ? 0 : array.length;
            while (length--) {
                if (iteratee(array[length], length, array) === false) {
                    break;
                }
            }
            return array;
        }
        function arrayEvery(array, predicate) {
            var index2 = -1,
                length = array == null ? 0 : array.length;
            while (++index2 < length) {
                if (!predicate(array[index2], index2, array)) {
                    return false;
                }
            }
            return true;
        }
        function arrayFilter2(array, predicate) {
            var index2 = -1,
                length = array == null ? 0 : array.length,
                resIndex = 0,
                result = [];
            while (++index2 < length) {
                var value = array[index2];
                if (predicate(value, index2, array)) {
                    result[resIndex++] = value;
                }
            }
            return result;
        }
        function arrayIncludes(array, value) {
            var length = array == null ? 0 : array.length;
            return !!length && baseIndexOf(array, value, 0) > -1;
        }
        function arrayIncludesWith(array, value, comparator) {
            var index2 = -1,
                length = array == null ? 0 : array.length;
            while (++index2 < length) {
                if (comparator(value, array[index2])) {
                    return true;
                }
            }
            return false;
        }
        function arrayMap(array, iteratee) {
            var index2 = -1,
                length = array == null ? 0 : array.length,
                result = Array(length);
            while (++index2 < length) {
                result[index2] = iteratee(array[index2], index2, array);
            }
            return result;
        }
        function arrayPush2(array, values) {
            var index2 = -1,
                length = values.length,
                offset2 = array.length;
            while (++index2 < length) {
                array[offset2 + index2] = values[index2];
            }
            return array;
        }
        function arrayReduce(array, iteratee, accumulator, initAccum) {
            var index2 = -1,
                length = array == null ? 0 : array.length;
            if (initAccum && length) {
                accumulator = array[++index2];
            }
            while (++index2 < length) {
                accumulator = iteratee(
                    accumulator,
                    array[index2],
                    index2,
                    array
                );
            }
            return accumulator;
        }
        function arrayReduceRight(array, iteratee, accumulator, initAccum) {
            var length = array == null ? 0 : array.length;
            if (initAccum && length) {
                accumulator = array[--length];
            }
            while (length--) {
                accumulator = iteratee(
                    accumulator,
                    array[length],
                    length,
                    array
                );
            }
            return accumulator;
        }
        function arraySome2(array, predicate) {
            var index2 = -1,
                length = array == null ? 0 : array.length;
            while (++index2 < length) {
                if (predicate(array[index2], index2, array)) {
                    return true;
                }
            }
            return false;
        }
        var asciiSize = baseProperty("length");
        function asciiToArray(string) {
            return string.split("");
        }
        function asciiWords(string) {
            return string.match(reAsciiWord) || [];
        }
        function baseFindKey(collection, predicate, eachFunc) {
            var result;
            eachFunc(collection, function (value, key, collection2) {
                if (predicate(value, key, collection2)) {
                    result = key;
                    return false;
                }
            });
            return result;
        }
        function baseFindIndex(array, predicate, fromIndex, fromRight) {
            var length = array.length,
                index2 = fromIndex + (fromRight ? 1 : -1);
            while (fromRight ? index2-- : ++index2 < length) {
                if (predicate(array[index2], index2, array)) {
                    return index2;
                }
            }
            return -1;
        }
        function baseIndexOf(array, value, fromIndex) {
            return value === value
                ? strictIndexOf(array, value, fromIndex)
                : baseFindIndex(array, baseIsNaN, fromIndex);
        }
        function baseIndexOfWith(array, value, fromIndex, comparator) {
            var index2 = fromIndex - 1,
                length = array.length;
            while (++index2 < length) {
                if (comparator(array[index2], value)) {
                    return index2;
                }
            }
            return -1;
        }
        function baseIsNaN(value) {
            return value !== value;
        }
        function baseMean(array, iteratee) {
            var length = array == null ? 0 : array.length;
            return length ? baseSum(array, iteratee) / length : NAN;
        }
        function baseProperty(key) {
            return function (object) {
                return object == null ? undefined$1 : object[key];
            };
        }
        function basePropertyOf(object) {
            return function (key) {
                return object == null ? undefined$1 : object[key];
            };
        }
        function baseReduce(
            collection,
            iteratee,
            accumulator,
            initAccum,
            eachFunc
        ) {
            eachFunc(collection, function (value, index2, collection2) {
                accumulator = initAccum
                    ? ((initAccum = false), value)
                    : iteratee(accumulator, value, index2, collection2);
            });
            return accumulator;
        }
        function baseSortBy(array, comparer) {
            var length = array.length;
            array.sort(comparer);
            while (length--) {
                array[length] = array[length].value;
            }
            return array;
        }
        function baseSum(array, iteratee) {
            var result,
                index2 = -1,
                length = array.length;
            while (++index2 < length) {
                var current = iteratee(array[index2]);
                if (current !== undefined$1) {
                    result =
                        result === undefined$1 ? current : result + current;
                }
            }
            return result;
        }
        function baseTimes2(n, iteratee) {
            var index2 = -1,
                result = Array(n);
            while (++index2 < n) {
                result[index2] = iteratee(index2);
            }
            return result;
        }
        function baseToPairs(object, props2) {
            return arrayMap(props2, function (key) {
                return [key, object[key]];
            });
        }
        function baseTrim(string) {
            return string
                ? string
                      .slice(0, trimmedEndIndex(string) + 1)
                      .replace(reTrimStart, "")
                : string;
        }
        function baseUnary2(func) {
            return function (value) {
                return func(value);
            };
        }
        function baseValues(object, props2) {
            return arrayMap(props2, function (key) {
                return object[key];
            });
        }
        function cacheHas2(cache, key) {
            return cache.has(key);
        }
        function charsStartIndex(strSymbols, chrSymbols) {
            var index2 = -1,
                length = strSymbols.length;
            while (
                ++index2 < length &&
                baseIndexOf(chrSymbols, strSymbols[index2], 0) > -1
            ) {}
            return index2;
        }
        function charsEndIndex(strSymbols, chrSymbols) {
            var index2 = strSymbols.length;
            while (
                index2-- &&
                baseIndexOf(chrSymbols, strSymbols[index2], 0) > -1
            ) {}
            return index2;
        }
        function countHolders(array, placeholder2) {
            var length = array.length,
                result = 0;
            while (length--) {
                if (array[length] === placeholder2) {
                    ++result;
                }
            }
            return result;
        }
        var deburrLetter = basePropertyOf(deburredLetters);
        var escapeHtmlChar = basePropertyOf(htmlEscapes);
        function escapeStringChar(chr) {
            return "\\" + stringEscapes[chr];
        }
        function getValue2(object, key) {
            return object == null ? undefined$1 : object[key];
        }
        function hasUnicode(string) {
            return reHasUnicode.test(string);
        }
        function hasUnicodeWord(string) {
            return reHasUnicodeWord.test(string);
        }
        function iteratorToArray(iterator) {
            var data3,
                result = [];
            while (!(data3 = iterator.next()).done) {
                result.push(data3.value);
            }
            return result;
        }
        function mapToArray2(map2) {
            var index2 = -1,
                result = Array(map2.size);
            map2.forEach(function (value, key) {
                result[++index2] = [key, value];
            });
            return result;
        }
        function overArg2(func, transform) {
            return function (arg) {
                return func(transform(arg));
            };
        }
        function replaceHolders(array, placeholder2) {
            var index2 = -1,
                length = array.length,
                resIndex = 0,
                result = [];
            while (++index2 < length) {
                var value = array[index2];
                if (value === placeholder2 || value === PLACEHOLDER) {
                    array[index2] = PLACEHOLDER;
                    result[resIndex++] = index2;
                }
            }
            return result;
        }
        function setToArray2(set3) {
            var index2 = -1,
                result = Array(set3.size);
            set3.forEach(function (value) {
                result[++index2] = value;
            });
            return result;
        }
        function setToPairs(set3) {
            var index2 = -1,
                result = Array(set3.size);
            set3.forEach(function (value) {
                result[++index2] = [value, value];
            });
            return result;
        }
        function strictIndexOf(array, value, fromIndex) {
            var index2 = fromIndex - 1,
                length = array.length;
            while (++index2 < length) {
                if (array[index2] === value) {
                    return index2;
                }
            }
            return -1;
        }
        function strictLastIndexOf(array, value, fromIndex) {
            var index2 = fromIndex + 1;
            while (index2--) {
                if (array[index2] === value) {
                    return index2;
                }
            }
            return index2;
        }
        function stringSize(string) {
            return hasUnicode(string) ? unicodeSize(string) : asciiSize(string);
        }
        function stringToArray(string) {
            return hasUnicode(string)
                ? unicodeToArray(string)
                : asciiToArray(string);
        }
        function trimmedEndIndex(string) {
            var index2 = string.length;
            while (index2-- && reWhitespace.test(string.charAt(index2))) {}
            return index2;
        }
        var unescapeHtmlChar = basePropertyOf(htmlUnescapes);
        function unicodeSize(string) {
            var result = (reUnicode.lastIndex = 0);
            while (reUnicode.test(string)) {
                ++result;
            }
            return result;
        }
        function unicodeToArray(string) {
            return string.match(reUnicode) || [];
        }
        function unicodeWords(string) {
            return string.match(reUnicodeWord) || [];
        }
        var runInContext = function runInContext2(context) {
            context =
                context == null
                    ? root2
                    : _2.defaults(
                          root2.Object(),
                          context,
                          _2.pick(root2, contextProps)
                      );
            var Array2 = context.Array,
                Date2 = context.Date,
                Error2 = context.Error,
                Function2 = context.Function,
                Math2 = context.Math,
                Object2 = context.Object,
                RegExp2 = context.RegExp,
                String2 = context.String,
                TypeError2 = context.TypeError;
            var arrayProto2 = Array2.prototype,
                funcProto2 = Function2.prototype,
                objectProto2 = Object2.prototype;
            var coreJsData2 = context["__core-js_shared__"];
            var funcToString2 = funcProto2.toString;
            var hasOwnProperty2 = objectProto2.hasOwnProperty;
            var idCounter = 0;
            var maskSrcKey2 = (function () {
                var uid2 = /[^.]+$/.exec(
                    (coreJsData2 &&
                        coreJsData2.keys &&
                        coreJsData2.keys.IE_PROTO) ||
                        ""
                );
                return uid2 ? "Symbol(src)_1." + uid2 : "";
            })();
            var nativeObjectToString2 = objectProto2.toString;
            var objectCtorString2 = funcToString2.call(Object2);
            var oldDash = root2._;
            var reIsNative2 = RegExp2(
                "^" +
                    funcToString2
                        .call(hasOwnProperty2)
                        .replace(reRegExpChar2, "\\$&")
                        .replace(
                            /hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,
                            "$1.*?"
                        ) +
                    "$"
            );
            var Buffer2 = moduleExports ? context.Buffer : undefined$1,
                Symbol2 = context.Symbol,
                Uint8Array2 = context.Uint8Array,
                allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : undefined$1,
                getPrototype2 = overArg2(Object2.getPrototypeOf, Object2),
                objectCreate2 = Object2.create,
                propertyIsEnumerable2 = objectProto2.propertyIsEnumerable,
                splice2 = arrayProto2.splice,
                spreadableSymbol = Symbol2
                    ? Symbol2.isConcatSpreadable
                    : undefined$1,
                symIterator = Symbol2 ? Symbol2.iterator : undefined$1,
                symToStringTag2 = Symbol2 ? Symbol2.toStringTag : undefined$1;
            var defineProperty2 = (function () {
                try {
                    var func = getNative2(Object2, "defineProperty");
                    func({}, "", {});
                    return func;
                } catch (e) {}
            })();
            var ctxClearTimeout =
                    context.clearTimeout !== root2.clearTimeout &&
                    context.clearTimeout,
                ctxNow = Date2 && Date2.now !== root2.Date.now && Date2.now,
                ctxSetTimeout =
                    context.setTimeout !== root2.setTimeout &&
                    context.setTimeout;
            var nativeCeil = Math2.ceil,
                nativeFloor = Math2.floor,
                nativeGetSymbols2 = Object2.getOwnPropertySymbols,
                nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : undefined$1,
                nativeIsFinite = context.isFinite,
                nativeJoin = arrayProto2.join,
                nativeKeys2 = overArg2(Object2.keys, Object2),
                nativeMax2 = Math2.max,
                nativeMin = Math2.min,
                nativeNow2 = Date2.now,
                nativeParseInt = context.parseInt,
                nativeRandom = Math2.random,
                nativeReverse = arrayProto2.reverse;
            var DataView2 = getNative2(context, "DataView"),
                Map2 = getNative2(context, "Map"),
                Promise2 = getNative2(context, "Promise"),
                Set2 = getNative2(context, "Set"),
                WeakMap2 = getNative2(context, "WeakMap"),
                nativeCreate2 = getNative2(Object2, "create");
            var metaMap = WeakMap2 && new WeakMap2();
            var realNames = {};
            var dataViewCtorString2 = toSource2(DataView2),
                mapCtorString2 = toSource2(Map2),
                promiseCtorString2 = toSource2(Promise2),
                setCtorString2 = toSource2(Set2),
                weakMapCtorString2 = toSource2(WeakMap2);
            var symbolProto2 = Symbol2 ? Symbol2.prototype : undefined$1,
                symbolValueOf2 = symbolProto2
                    ? symbolProto2.valueOf
                    : undefined$1,
                symbolToString = symbolProto2
                    ? symbolProto2.toString
                    : undefined$1;
            function lodash2(value) {
                if (
                    isObjectLike2(value) &&
                    !isArray2(value) &&
                    !(value instanceof LazyWrapper)
                ) {
                    if (value instanceof LodashWrapper) {
                        return value;
                    }
                    if (hasOwnProperty2.call(value, "__wrapped__")) {
                        return wrapperClone(value);
                    }
                }
                return new LodashWrapper(value);
            }
            var baseCreate2 = (function () {
                function object() {}
                return function (proto) {
                    if (!isObject2(proto)) {
                        return {};
                    }
                    if (objectCreate2) {
                        return objectCreate2(proto);
                    }
                    object.prototype = proto;
                    var result2 = new object();
                    object.prototype = undefined$1;
                    return result2;
                };
            })();
            function baseLodash() {}
            function LodashWrapper(value, chainAll) {
                this.__wrapped__ = value;
                this.__actions__ = [];
                this.__chain__ = !!chainAll;
                this.__index__ = 0;
                this.__values__ = undefined$1;
            }
            lodash2.templateSettings = {
                escape: reEscape,
                evaluate: reEvaluate,
                interpolate: reInterpolate,
                variable: "",
                imports: {
                    _: lodash2,
                },
            };
            lodash2.prototype = baseLodash.prototype;
            lodash2.prototype.constructor = lodash2;
            LodashWrapper.prototype = baseCreate2(baseLodash.prototype);
            LodashWrapper.prototype.constructor = LodashWrapper;
            function LazyWrapper(value) {
                this.__wrapped__ = value;
                this.__actions__ = [];
                this.__dir__ = 1;
                this.__filtered__ = false;
                this.__iteratees__ = [];
                this.__takeCount__ = MAX_ARRAY_LENGTH;
                this.__views__ = [];
            }
            function lazyClone() {
                var result2 = new LazyWrapper(this.__wrapped__);
                result2.__actions__ = copyArray2(this.__actions__);
                result2.__dir__ = this.__dir__;
                result2.__filtered__ = this.__filtered__;
                result2.__iteratees__ = copyArray2(this.__iteratees__);
                result2.__takeCount__ = this.__takeCount__;
                result2.__views__ = copyArray2(this.__views__);
                return result2;
            }
            function lazyReverse() {
                if (this.__filtered__) {
                    var result2 = new LazyWrapper(this);
                    result2.__dir__ = -1;
                    result2.__filtered__ = true;
                } else {
                    result2 = this.clone();
                    result2.__dir__ *= -1;
                }
                return result2;
            }
            function lazyValue() {
                var array = this.__wrapped__.value(),
                    dir = this.__dir__,
                    isArr = isArray2(array),
                    isRight = dir < 0,
                    arrLength = isArr ? array.length : 0,
                    view = getView(0, arrLength, this.__views__),
                    start2 = view.start,
                    end = view.end,
                    length = end - start2,
                    index2 = isRight ? end : start2 - 1,
                    iteratees = this.__iteratees__,
                    iterLength = iteratees.length,
                    resIndex = 0,
                    takeCount = nativeMin(length, this.__takeCount__);
                if (
                    !isArr ||
                    (!isRight && arrLength == length && takeCount == length)
                ) {
                    return baseWrapperValue(array, this.__actions__);
                }
                var result2 = [];
                outer: while (length-- && resIndex < takeCount) {
                    index2 += dir;
                    var iterIndex = -1,
                        value = array[index2];
                    while (++iterIndex < iterLength) {
                        var data3 = iteratees[iterIndex],
                            iteratee2 = data3.iteratee,
                            type = data3.type,
                            computed = iteratee2(value);
                        if (type == LAZY_MAP_FLAG) {
                            value = computed;
                        } else if (!computed) {
                            if (type == LAZY_FILTER_FLAG) {
                                continue outer;
                            } else {
                                break outer;
                            }
                        }
                    }
                    result2[resIndex++] = value;
                }
                return result2;
            }
            LazyWrapper.prototype = baseCreate2(baseLodash.prototype);
            LazyWrapper.prototype.constructor = LazyWrapper;
            function Hash2(entries) {
                var index2 = -1,
                    length = entries == null ? 0 : entries.length;
                this.clear();
                while (++index2 < length) {
                    var entry = entries[index2];
                    this.set(entry[0], entry[1]);
                }
            }
            function hashClear2() {
                this.__data__ = nativeCreate2 ? nativeCreate2(null) : {};
                this.size = 0;
            }
            function hashDelete2(key) {
                var result2 = this.has(key) && delete this.__data__[key];
                this.size -= result2 ? 1 : 0;
                return result2;
            }
            function hashGet2(key) {
                var data3 = this.__data__;
                if (nativeCreate2) {
                    var result2 = data3[key];
                    return result2 === HASH_UNDEFINED2 ? undefined$1 : result2;
                }
                return hasOwnProperty2.call(data3, key)
                    ? data3[key]
                    : undefined$1;
            }
            function hashHas2(key) {
                var data3 = this.__data__;
                return nativeCreate2
                    ? data3[key] !== undefined$1
                    : hasOwnProperty2.call(data3, key);
            }
            function hashSet2(key, value) {
                var data3 = this.__data__;
                this.size += this.has(key) ? 0 : 1;
                data3[key] =
                    nativeCreate2 && value === undefined$1
                        ? HASH_UNDEFINED2
                        : value;
                return this;
            }
            Hash2.prototype.clear = hashClear2;
            Hash2.prototype["delete"] = hashDelete2;
            Hash2.prototype.get = hashGet2;
            Hash2.prototype.has = hashHas2;
            Hash2.prototype.set = hashSet2;
            function ListCache2(entries) {
                var index2 = -1,
                    length = entries == null ? 0 : entries.length;
                this.clear();
                while (++index2 < length) {
                    var entry = entries[index2];
                    this.set(entry[0], entry[1]);
                }
            }
            function listCacheClear2() {
                this.__data__ = [];
                this.size = 0;
            }
            function listCacheDelete2(key) {
                var data3 = this.__data__,
                    index2 = assocIndexOf2(data3, key);
                if (index2 < 0) {
                    return false;
                }
                var lastIndex = data3.length - 1;
                if (index2 == lastIndex) {
                    data3.pop();
                } else {
                    splice2.call(data3, index2, 1);
                }
                --this.size;
                return true;
            }
            function listCacheGet2(key) {
                var data3 = this.__data__,
                    index2 = assocIndexOf2(data3, key);
                return index2 < 0 ? undefined$1 : data3[index2][1];
            }
            function listCacheHas2(key) {
                return assocIndexOf2(this.__data__, key) > -1;
            }
            function listCacheSet2(key, value) {
                var data3 = this.__data__,
                    index2 = assocIndexOf2(data3, key);
                if (index2 < 0) {
                    ++this.size;
                    data3.push([key, value]);
                } else {
                    data3[index2][1] = value;
                }
                return this;
            }
            ListCache2.prototype.clear = listCacheClear2;
            ListCache2.prototype["delete"] = listCacheDelete2;
            ListCache2.prototype.get = listCacheGet2;
            ListCache2.prototype.has = listCacheHas2;
            ListCache2.prototype.set = listCacheSet2;
            function MapCache2(entries) {
                var index2 = -1,
                    length = entries == null ? 0 : entries.length;
                this.clear();
                while (++index2 < length) {
                    var entry = entries[index2];
                    this.set(entry[0], entry[1]);
                }
            }
            function mapCacheClear2() {
                this.size = 0;
                this.__data__ = {
                    hash: new Hash2(),
                    map: new (Map2 || ListCache2)(),
                    string: new Hash2(),
                };
            }
            function mapCacheDelete2(key) {
                var result2 = getMapData2(this, key)["delete"](key);
                this.size -= result2 ? 1 : 0;
                return result2;
            }
            function mapCacheGet2(key) {
                return getMapData2(this, key).get(key);
            }
            function mapCacheHas2(key) {
                return getMapData2(this, key).has(key);
            }
            function mapCacheSet2(key, value) {
                var data3 = getMapData2(this, key),
                    size3 = data3.size;
                data3.set(key, value);
                this.size += data3.size == size3 ? 0 : 1;
                return this;
            }
            MapCache2.prototype.clear = mapCacheClear2;
            MapCache2.prototype["delete"] = mapCacheDelete2;
            MapCache2.prototype.get = mapCacheGet2;
            MapCache2.prototype.has = mapCacheHas2;
            MapCache2.prototype.set = mapCacheSet2;
            function SetCache2(values2) {
                var index2 = -1,
                    length = values2 == null ? 0 : values2.length;
                this.__data__ = new MapCache2();
                while (++index2 < length) {
                    this.add(values2[index2]);
                }
            }
            function setCacheAdd2(value) {
                this.__data__.set(value, HASH_UNDEFINED2);
                return this;
            }
            function setCacheHas2(value) {
                return this.__data__.has(value);
            }
            SetCache2.prototype.add = SetCache2.prototype.push = setCacheAdd2;
            SetCache2.prototype.has = setCacheHas2;
            function Stack2(entries) {
                var data3 = (this.__data__ = new ListCache2(entries));
                this.size = data3.size;
            }
            function stackClear2() {
                this.__data__ = new ListCache2();
                this.size = 0;
            }
            function stackDelete2(key) {
                var data3 = this.__data__,
                    result2 = data3["delete"](key);
                this.size = data3.size;
                return result2;
            }
            function stackGet2(key) {
                return this.__data__.get(key);
            }
            function stackHas2(key) {
                return this.__data__.has(key);
            }
            function stackSet2(key, value) {
                var data3 = this.__data__;
                if (data3 instanceof ListCache2) {
                    var pairs = data3.__data__;
                    if (!Map2 || pairs.length < LARGE_ARRAY_SIZE2 - 1) {
                        pairs.push([key, value]);
                        this.size = ++data3.size;
                        return this;
                    }
                    data3 = this.__data__ = new MapCache2(pairs);
                }
                data3.set(key, value);
                this.size = data3.size;
                return this;
            }
            Stack2.prototype.clear = stackClear2;
            Stack2.prototype["delete"] = stackDelete2;
            Stack2.prototype.get = stackGet2;
            Stack2.prototype.has = stackHas2;
            Stack2.prototype.set = stackSet2;
            function arrayLikeKeys2(value, inherited) {
                var isArr = isArray2(value),
                    isArg = !isArr && isArguments2(value),
                    isBuff = !isArr && !isArg && isBuffer2(value),
                    isType =
                        !isArr && !isArg && !isBuff && isTypedArray2(value),
                    skipIndexes = isArr || isArg || isBuff || isType,
                    result2 = skipIndexes
                        ? baseTimes2(value.length, String2)
                        : [],
                    length = result2.length;
                for (var key in value) {
                    if (
                        (inherited || hasOwnProperty2.call(value, key)) &&
                        !(
                            skipIndexes &&
                            (key == "length" ||
                                (isBuff &&
                                    (key == "offset" || key == "parent")) ||
                                (isType &&
                                    (key == "buffer" ||
                                        key == "byteLength" ||
                                        key == "byteOffset")) ||
                                isIndex2(key, length))
                        )
                    ) {
                        result2.push(key);
                    }
                }
                return result2;
            }
            function arraySample(array) {
                var length = array.length;
                return length ? array[baseRandom(0, length - 1)] : undefined$1;
            }
            function arraySampleSize(array, n) {
                return shuffleSelf(
                    copyArray2(array),
                    baseClamp(n, 0, array.length)
                );
            }
            function arrayShuffle(array) {
                return shuffleSelf(copyArray2(array));
            }
            function assignMergeValue2(object, key, value) {
                if (
                    (value !== undefined$1 && !eq2(object[key], value)) ||
                    (value === undefined$1 && !(key in object))
                ) {
                    baseAssignValue2(object, key, value);
                }
            }
            function assignValue2(object, key, value) {
                var objValue = object[key];
                if (
                    !(
                        hasOwnProperty2.call(object, key) &&
                        eq2(objValue, value)
                    ) ||
                    (value === undefined$1 && !(key in object))
                ) {
                    baseAssignValue2(object, key, value);
                }
            }
            function assocIndexOf2(array, key) {
                var length = array.length;
                while (length--) {
                    if (eq2(array[length][0], key)) {
                        return length;
                    }
                }
                return -1;
            }
            function baseAggregator(
                collection,
                setter,
                iteratee2,
                accumulator
            ) {
                baseEach(collection, function (value, key, collection2) {
                    setter(accumulator, value, iteratee2(value), collection2);
                });
                return accumulator;
            }
            function baseAssign(object, source) {
                return object && copyObject2(source, keys2(source), object);
            }
            function baseAssignIn(object, source) {
                return object && copyObject2(source, keysIn2(source), object);
            }
            function baseAssignValue2(object, key, value) {
                if (key == "__proto__" && defineProperty2) {
                    defineProperty2(object, key, {
                        configurable: true,
                        enumerable: true,
                        value: value,
                        writable: true,
                    });
                } else {
                    object[key] = value;
                }
            }
            function baseAt(object, paths) {
                var index2 = -1,
                    length = paths.length,
                    result2 = Array2(length),
                    skip = object == null;
                while (++index2 < length) {
                    result2[index2] = skip
                        ? undefined$1
                        : get3(object, paths[index2]);
                }
                return result2;
            }
            function baseClamp(number, lower, upper) {
                if (number === number) {
                    if (upper !== undefined$1) {
                        number = number <= upper ? number : upper;
                    }
                    if (lower !== undefined$1) {
                        number = number >= lower ? number : lower;
                    }
                }
                return number;
            }
            function baseClone(value, bitmask, customizer, key, object, stack) {
                var result2,
                    isDeep = bitmask & CLONE_DEEP_FLAG,
                    isFlat = bitmask & CLONE_FLAT_FLAG,
                    isFull = bitmask & CLONE_SYMBOLS_FLAG;
                if (customizer) {
                    result2 = object
                        ? customizer(value, key, object, stack)
                        : customizer(value);
                }
                if (result2 !== undefined$1) {
                    return result2;
                }
                if (!isObject2(value)) {
                    return value;
                }
                var isArr = isArray2(value);
                if (isArr) {
                    result2 = initCloneArray(value);
                    if (!isDeep) {
                        return copyArray2(value, result2);
                    }
                } else {
                    var tag = getTag2(value),
                        isFunc = tag == funcTag2 || tag == genTag2;
                    if (isBuffer2(value)) {
                        return cloneBuffer2(value, isDeep);
                    }
                    if (
                        tag == objectTag2 ||
                        tag == argsTag2 ||
                        (isFunc && !object)
                    ) {
                        result2 =
                            isFlat || isFunc ? {} : initCloneObject2(value);
                        if (!isDeep) {
                            return isFlat
                                ? copySymbolsIn(
                                      value,
                                      baseAssignIn(result2, value)
                                  )
                                : copySymbols(
                                      value,
                                      baseAssign(result2, value)
                                  );
                        }
                    } else {
                        if (!cloneableTags[tag]) {
                            return object ? value : {};
                        }
                        result2 = initCloneByTag(value, tag, isDeep);
                    }
                }
                stack || (stack = new Stack2());
                var stacked = stack.get(value);
                if (stacked) {
                    return stacked;
                }
                stack.set(value, result2);
                if (isSet(value)) {
                    value.forEach(function (subValue) {
                        result2.add(
                            baseClone(
                                subValue,
                                bitmask,
                                customizer,
                                subValue,
                                value,
                                stack
                            )
                        );
                    });
                } else if (isMap2(value)) {
                    value.forEach(function (subValue, key2) {
                        result2.set(
                            key2,
                            baseClone(
                                subValue,
                                bitmask,
                                customizer,
                                key2,
                                value,
                                stack
                            )
                        );
                    });
                }
                var keysFunc = isFull
                    ? isFlat
                        ? getAllKeysIn
                        : getAllKeys2
                    : isFlat
                    ? keysIn2
                    : keys2;
                var props2 = isArr ? undefined$1 : keysFunc(value);
                arrayEach(props2 || value, function (subValue, key2) {
                    if (props2) {
                        key2 = subValue;
                        subValue = value[key2];
                    }
                    assignValue2(
                        result2,
                        key2,
                        baseClone(
                            subValue,
                            bitmask,
                            customizer,
                            key2,
                            value,
                            stack
                        )
                    );
                });
                return result2;
            }
            function baseConforms(source) {
                var props2 = keys2(source);
                return function (object) {
                    return baseConformsTo(object, source, props2);
                };
            }
            function baseConformsTo(object, source, props2) {
                var length = props2.length;
                if (object == null) {
                    return !length;
                }
                object = Object2(object);
                while (length--) {
                    var key = props2[length],
                        predicate = source[key],
                        value = object[key];
                    if (
                        (value === undefined$1 && !(key in object)) ||
                        !predicate(value)
                    ) {
                        return false;
                    }
                }
                return true;
            }
            function baseDelay(func, wait, args) {
                if (typeof func != "function") {
                    throw new TypeError2(FUNC_ERROR_TEXT);
                }
                return setTimeout2(function () {
                    func.apply(undefined$1, args);
                }, wait);
            }
            function baseDifference(array, values2, iteratee2, comparator) {
                var index2 = -1,
                    includes2 = arrayIncludes,
                    isCommon = true,
                    length = array.length,
                    result2 = [],
                    valuesLength = values2.length;
                if (!length) {
                    return result2;
                }
                if (iteratee2) {
                    values2 = arrayMap(values2, baseUnary2(iteratee2));
                }
                if (comparator) {
                    includes2 = arrayIncludesWith;
                    isCommon = false;
                } else if (values2.length >= LARGE_ARRAY_SIZE2) {
                    includes2 = cacheHas2;
                    isCommon = false;
                    values2 = new SetCache2(values2);
                }
                outer: while (++index2 < length) {
                    var value = array[index2],
                        computed = iteratee2 == null ? value : iteratee2(value);
                    value = comparator || value !== 0 ? value : 0;
                    if (isCommon && computed === computed) {
                        var valuesIndex = valuesLength;
                        while (valuesIndex--) {
                            if (values2[valuesIndex] === computed) {
                                continue outer;
                            }
                        }
                        result2.push(value);
                    } else if (!includes2(values2, computed, comparator)) {
                        result2.push(value);
                    }
                }
                return result2;
            }
            var baseEach = createBaseEach(baseForOwn);
            var baseEachRight = createBaseEach(baseForOwnRight, true);
            function baseEvery(collection, predicate) {
                var result2 = true;
                baseEach(collection, function (value, index2, collection2) {
                    result2 = !!predicate(value, index2, collection2);
                    return result2;
                });
                return result2;
            }
            function baseExtremum(array, iteratee2, comparator) {
                var index2 = -1,
                    length = array.length;
                while (++index2 < length) {
                    var value = array[index2],
                        current = iteratee2(value);
                    if (
                        current != null &&
                        (computed === undefined$1
                            ? current === current && !isSymbol2(current)
                            : comparator(current, computed))
                    ) {
                        var computed = current,
                            result2 = value;
                    }
                }
                return result2;
            }
            function baseFill(array, value, start2, end) {
                var length = array.length;
                start2 = toInteger(start2);
                if (start2 < 0) {
                    start2 = -start2 > length ? 0 : length + start2;
                }
                end =
                    end === undefined$1 || end > length
                        ? length
                        : toInteger(end);
                if (end < 0) {
                    end += length;
                }
                end = start2 > end ? 0 : toLength(end);
                while (start2 < end) {
                    array[start2++] = value;
                }
                return array;
            }
            function baseFilter(collection, predicate) {
                var result2 = [];
                baseEach(collection, function (value, index2, collection2) {
                    if (predicate(value, index2, collection2)) {
                        result2.push(value);
                    }
                });
                return result2;
            }
            function baseFlatten(array, depth, predicate, isStrict, result2) {
                var index2 = -1,
                    length = array.length;
                predicate || (predicate = isFlattenable);
                result2 || (result2 = []);
                while (++index2 < length) {
                    var value = array[index2];
                    if (depth > 0 && predicate(value)) {
                        if (depth > 1) {
                            baseFlatten(
                                value,
                                depth - 1,
                                predicate,
                                isStrict,
                                result2
                            );
                        } else {
                            arrayPush2(result2, value);
                        }
                    } else if (!isStrict) {
                        result2[result2.length] = value;
                    }
                }
                return result2;
            }
            var baseFor2 = createBaseFor2();
            var baseForRight = createBaseFor2(true);
            function baseForOwn(object, iteratee2) {
                return object && baseFor2(object, iteratee2, keys2);
            }
            function baseForOwnRight(object, iteratee2) {
                return object && baseForRight(object, iteratee2, keys2);
            }
            function baseFunctions(object, props2) {
                return arrayFilter2(props2, function (key) {
                    return isFunction2(object[key]);
                });
            }
            function baseGet(object, path) {
                path = castPath(path, object);
                var index2 = 0,
                    length = path.length;
                while (object != null && index2 < length) {
                    object = object[toKey(path[index2++])];
                }
                return index2 && index2 == length ? object : undefined$1;
            }
            function baseGetAllKeys2(object, keysFunc, symbolsFunc) {
                var result2 = keysFunc(object);
                return isArray2(object)
                    ? result2
                    : arrayPush2(result2, symbolsFunc(object));
            }
            function baseGetTag2(value) {
                if (value == null) {
                    return value === undefined$1 ? undefinedTag2 : nullTag2;
                }
                return symToStringTag2 && symToStringTag2 in Object2(value)
                    ? getRawTag2(value)
                    : objectToString2(value);
            }
            function baseGt(value, other) {
                return value > other;
            }
            function baseHas(object, key) {
                return object != null && hasOwnProperty2.call(object, key);
            }
            function baseHasIn(object, key) {
                return object != null && key in Object2(object);
            }
            function baseInRange(number, start2, end) {
                return (
                    number >= nativeMin(start2, end) &&
                    number < nativeMax2(start2, end)
                );
            }
            function baseIntersection(arrays, iteratee2, comparator) {
                var includes2 = comparator ? arrayIncludesWith : arrayIncludes,
                    length = arrays[0].length,
                    othLength = arrays.length,
                    othIndex = othLength,
                    caches = Array2(othLength),
                    maxLength = Infinity,
                    result2 = [];
                while (othIndex--) {
                    var array = arrays[othIndex];
                    if (othIndex && iteratee2) {
                        array = arrayMap(array, baseUnary2(iteratee2));
                    }
                    maxLength = nativeMin(array.length, maxLength);
                    caches[othIndex] =
                        !comparator &&
                        (iteratee2 || (length >= 120 && array.length >= 120))
                            ? new SetCache2(othIndex && array)
                            : undefined$1;
                }
                array = arrays[0];
                var index2 = -1,
                    seen = caches[0];
                outer: while (++index2 < length && result2.length < maxLength) {
                    var value = array[index2],
                        computed = iteratee2 ? iteratee2(value) : value;
                    value = comparator || value !== 0 ? value : 0;
                    if (
                        !(seen
                            ? cacheHas2(seen, computed)
                            : includes2(result2, computed, comparator))
                    ) {
                        othIndex = othLength;
                        while (--othIndex) {
                            var cache = caches[othIndex];
                            if (
                                !(cache
                                    ? cacheHas2(cache, computed)
                                    : includes2(
                                          arrays[othIndex],
                                          computed,
                                          comparator
                                      ))
                            ) {
                                continue outer;
                            }
                        }
                        if (seen) {
                            seen.push(computed);
                        }
                        result2.push(value);
                    }
                }
                return result2;
            }
            function baseInverter(object, setter, iteratee2, accumulator) {
                baseForOwn(object, function (value, key, object2) {
                    setter(accumulator, iteratee2(value), key, object2);
                });
                return accumulator;
            }
            function baseInvoke(object, path, args) {
                path = castPath(path, object);
                object = parent(object, path);
                var func = object == null ? object : object[toKey(last(path))];
                return func == null ? undefined$1 : apply2(func, object, args);
            }
            function baseIsArguments2(value) {
                return isObjectLike2(value) && baseGetTag2(value) == argsTag2;
            }
            function baseIsArrayBuffer(value) {
                return (
                    isObjectLike2(value) &&
                    baseGetTag2(value) == arrayBufferTag2
                );
            }
            function baseIsDate(value) {
                return isObjectLike2(value) && baseGetTag2(value) == dateTag2;
            }
            function baseIsEqual2(value, other, bitmask, customizer, stack) {
                if (value === other) {
                    return true;
                }
                if (
                    value == null ||
                    other == null ||
                    (!isObjectLike2(value) && !isObjectLike2(other))
                ) {
                    return value !== value && other !== other;
                }
                return baseIsEqualDeep2(
                    value,
                    other,
                    bitmask,
                    customizer,
                    baseIsEqual2,
                    stack
                );
            }
            function baseIsEqualDeep2(
                object,
                other,
                bitmask,
                customizer,
                equalFunc,
                stack
            ) {
                var objIsArr = isArray2(object),
                    othIsArr = isArray2(other),
                    objTag = objIsArr ? arrayTag2 : getTag2(object),
                    othTag = othIsArr ? arrayTag2 : getTag2(other);
                objTag = objTag == argsTag2 ? objectTag2 : objTag;
                othTag = othTag == argsTag2 ? objectTag2 : othTag;
                var objIsObj = objTag == objectTag2,
                    othIsObj = othTag == objectTag2,
                    isSameTag = objTag == othTag;
                if (isSameTag && isBuffer2(object)) {
                    if (!isBuffer2(other)) {
                        return false;
                    }
                    objIsArr = true;
                    objIsObj = false;
                }
                if (isSameTag && !objIsObj) {
                    stack || (stack = new Stack2());
                    return objIsArr || isTypedArray2(object)
                        ? equalArrays2(
                              object,
                              other,
                              bitmask,
                              customizer,
                              equalFunc,
                              stack
                          )
                        : equalByTag2(
                              object,
                              other,
                              objTag,
                              bitmask,
                              customizer,
                              equalFunc,
                              stack
                          );
                }
                if (!(bitmask & COMPARE_PARTIAL_FLAG2)) {
                    var objIsWrapped =
                            objIsObj &&
                            hasOwnProperty2.call(object, "__wrapped__"),
                        othIsWrapped =
                            othIsObj &&
                            hasOwnProperty2.call(other, "__wrapped__");
                    if (objIsWrapped || othIsWrapped) {
                        var objUnwrapped = objIsWrapped
                                ? object.value()
                                : object,
                            othUnwrapped = othIsWrapped ? other.value() : other;
                        stack || (stack = new Stack2());
                        return equalFunc(
                            objUnwrapped,
                            othUnwrapped,
                            bitmask,
                            customizer,
                            stack
                        );
                    }
                }
                if (!isSameTag) {
                    return false;
                }
                stack || (stack = new Stack2());
                return equalObjects2(
                    object,
                    other,
                    bitmask,
                    customizer,
                    equalFunc,
                    stack
                );
            }
            function baseIsMap(value) {
                return isObjectLike2(value) && getTag2(value) == mapTag2;
            }
            function baseIsMatch(object, source, matchData, customizer) {
                var index2 = matchData.length,
                    length = index2,
                    noCustomizer = !customizer;
                if (object == null) {
                    return !length;
                }
                object = Object2(object);
                while (index2--) {
                    var data3 = matchData[index2];
                    if (
                        noCustomizer && data3[2]
                            ? data3[1] !== object[data3[0]]
                            : !(data3[0] in object)
                    ) {
                        return false;
                    }
                }
                while (++index2 < length) {
                    data3 = matchData[index2];
                    var key = data3[0],
                        objValue = object[key],
                        srcValue = data3[1];
                    if (noCustomizer && data3[2]) {
                        if (objValue === undefined$1 && !(key in object)) {
                            return false;
                        }
                    } else {
                        var stack = new Stack2();
                        if (customizer) {
                            var result2 = customizer(
                                objValue,
                                srcValue,
                                key,
                                object,
                                source,
                                stack
                            );
                        }
                        if (
                            !(result2 === undefined$1
                                ? baseIsEqual2(
                                      srcValue,
                                      objValue,
                                      COMPARE_PARTIAL_FLAG2 |
                                          COMPARE_UNORDERED_FLAG2,
                                      customizer,
                                      stack
                                  )
                                : result2)
                        ) {
                            return false;
                        }
                    }
                }
                return true;
            }
            function baseIsNative2(value) {
                if (!isObject2(value) || isMasked2(value)) {
                    return false;
                }
                var pattern = isFunction2(value) ? reIsNative2 : reIsHostCtor2;
                return pattern.test(toSource2(value));
            }
            function baseIsRegExp(value) {
                return isObjectLike2(value) && baseGetTag2(value) == regexpTag2;
            }
            function baseIsSet(value) {
                return isObjectLike2(value) && getTag2(value) == setTag2;
            }
            function baseIsTypedArray2(value) {
                return (
                    isObjectLike2(value) &&
                    isLength2(value.length) &&
                    !!typedArrayTags2[baseGetTag2(value)]
                );
            }
            function baseIteratee(value) {
                if (typeof value == "function") {
                    return value;
                }
                if (value == null) {
                    return identity2;
                }
                if (typeof value == "object") {
                    return isArray2(value)
                        ? baseMatchesProperty(value[0], value[1])
                        : baseMatches(value);
                }
                return property(value);
            }
            function baseKeys2(object) {
                if (!isPrototype2(object)) {
                    return nativeKeys2(object);
                }
                var result2 = [];
                for (var key in Object2(object)) {
                    if (
                        hasOwnProperty2.call(object, key) &&
                        key != "constructor"
                    ) {
                        result2.push(key);
                    }
                }
                return result2;
            }
            function baseKeysIn2(object) {
                if (!isObject2(object)) {
                    return nativeKeysIn2(object);
                }
                var isProto = isPrototype2(object),
                    result2 = [];
                for (var key in object) {
                    if (
                        !(
                            key == "constructor" &&
                            (isProto || !hasOwnProperty2.call(object, key))
                        )
                    ) {
                        result2.push(key);
                    }
                }
                return result2;
            }
            function baseLt(value, other) {
                return value < other;
            }
            function baseMap(collection, iteratee2) {
                var index2 = -1,
                    result2 = isArrayLike2(collection)
                        ? Array2(collection.length)
                        : [];
                baseEach(collection, function (value, key, collection2) {
                    result2[++index2] = iteratee2(value, key, collection2);
                });
                return result2;
            }
            function baseMatches(source) {
                var matchData = getMatchData(source);
                if (matchData.length == 1 && matchData[0][2]) {
                    return matchesStrictComparable(
                        matchData[0][0],
                        matchData[0][1]
                    );
                }
                return function (object) {
                    return (
                        object === source ||
                        baseIsMatch(object, source, matchData)
                    );
                };
            }
            function baseMatchesProperty(path, srcValue) {
                if (isKey(path) && isStrictComparable(srcValue)) {
                    return matchesStrictComparable(toKey(path), srcValue);
                }
                return function (object) {
                    var objValue = get3(object, path);
                    return objValue === undefined$1 && objValue === srcValue
                        ? hasIn(object, path)
                        : baseIsEqual2(
                              srcValue,
                              objValue,
                              COMPARE_PARTIAL_FLAG2 | COMPARE_UNORDERED_FLAG2
                          );
                };
            }
            function baseMerge2(object, source, srcIndex, customizer, stack) {
                if (object === source) {
                    return;
                }
                baseFor2(
                    source,
                    function (srcValue, key) {
                        stack || (stack = new Stack2());
                        if (isObject2(srcValue)) {
                            baseMergeDeep2(
                                object,
                                source,
                                key,
                                srcIndex,
                                baseMerge2,
                                customizer,
                                stack
                            );
                        } else {
                            var newValue = customizer
                                ? customizer(
                                      safeGet2(object, key),
                                      srcValue,
                                      key + "",
                                      object,
                                      source,
                                      stack
                                  )
                                : undefined$1;
                            if (newValue === undefined$1) {
                                newValue = srcValue;
                            }
                            assignMergeValue2(object, key, newValue);
                        }
                    },
                    keysIn2
                );
            }
            function baseMergeDeep2(
                object,
                source,
                key,
                srcIndex,
                mergeFunc,
                customizer,
                stack
            ) {
                var objValue = safeGet2(object, key),
                    srcValue = safeGet2(source, key),
                    stacked = stack.get(srcValue);
                if (stacked) {
                    assignMergeValue2(object, key, stacked);
                    return;
                }
                var newValue = customizer
                    ? customizer(
                          objValue,
                          srcValue,
                          key + "",
                          object,
                          source,
                          stack
                      )
                    : undefined$1;
                var isCommon = newValue === undefined$1;
                if (isCommon) {
                    var isArr = isArray2(srcValue),
                        isBuff = !isArr && isBuffer2(srcValue),
                        isTyped = !isArr && !isBuff && isTypedArray2(srcValue);
                    newValue = srcValue;
                    if (isArr || isBuff || isTyped) {
                        if (isArray2(objValue)) {
                            newValue = objValue;
                        } else if (isArrayLikeObject2(objValue)) {
                            newValue = copyArray2(objValue);
                        } else if (isBuff) {
                            isCommon = false;
                            newValue = cloneBuffer2(srcValue, true);
                        } else if (isTyped) {
                            isCommon = false;
                            newValue = cloneTypedArray2(srcValue, true);
                        } else {
                            newValue = [];
                        }
                    } else if (
                        isPlainObject2(srcValue) ||
                        isArguments2(srcValue)
                    ) {
                        newValue = objValue;
                        if (isArguments2(objValue)) {
                            newValue = toPlainObject2(objValue);
                        } else if (
                            !isObject2(objValue) ||
                            isFunction2(objValue)
                        ) {
                            newValue = initCloneObject2(srcValue);
                        }
                    } else {
                        isCommon = false;
                    }
                }
                if (isCommon) {
                    stack.set(srcValue, newValue);
                    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
                    stack["delete"](srcValue);
                }
                assignMergeValue2(object, key, newValue);
            }
            function baseNth(array, n) {
                var length = array.length;
                if (!length) {
                    return;
                }
                n += n < 0 ? length : 0;
                return isIndex2(n, length) ? array[n] : undefined$1;
            }
            function baseOrderBy(collection, iteratees, orders) {
                if (iteratees.length) {
                    iteratees = arrayMap(iteratees, function (iteratee2) {
                        if (isArray2(iteratee2)) {
                            return function (value) {
                                return baseGet(
                                    value,
                                    iteratee2.length === 1
                                        ? iteratee2[0]
                                        : iteratee2
                                );
                            };
                        }
                        return iteratee2;
                    });
                } else {
                    iteratees = [identity2];
                }
                var index2 = -1;
                iteratees = arrayMap(iteratees, baseUnary2(getIteratee()));
                var result2 = baseMap(
                    collection,
                    function (value, key, collection2) {
                        var criteria = arrayMap(
                            iteratees,
                            function (iteratee2) {
                                return iteratee2(value);
                            }
                        );
                        return {
                            criteria: criteria,
                            index: ++index2,
                            value: value,
                        };
                    }
                );
                return baseSortBy(result2, function (object, other) {
                    return compareMultiple(object, other, orders);
                });
            }
            function basePick(object, paths) {
                return basePickBy(object, paths, function (value, path) {
                    return hasIn(object, path);
                });
            }
            function basePickBy(object, paths, predicate) {
                var index2 = -1,
                    length = paths.length,
                    result2 = {};
                while (++index2 < length) {
                    var path = paths[index2],
                        value = baseGet(object, path);
                    if (predicate(value, path)) {
                        baseSet(result2, castPath(path, object), value);
                    }
                }
                return result2;
            }
            function basePropertyDeep(path) {
                return function (object) {
                    return baseGet(object, path);
                };
            }
            function basePullAll(array, values2, iteratee2, comparator) {
                var indexOf2 = comparator ? baseIndexOfWith : baseIndexOf,
                    index2 = -1,
                    length = values2.length,
                    seen = array;
                if (array === values2) {
                    values2 = copyArray2(values2);
                }
                if (iteratee2) {
                    seen = arrayMap(array, baseUnary2(iteratee2));
                }
                while (++index2 < length) {
                    var fromIndex = 0,
                        value = values2[index2],
                        computed = iteratee2 ? iteratee2(value) : value;
                    while (
                        (fromIndex = indexOf2(
                            seen,
                            computed,
                            fromIndex,
                            comparator
                        )) > -1
                    ) {
                        if (seen !== array) {
                            splice2.call(seen, fromIndex, 1);
                        }
                        splice2.call(array, fromIndex, 1);
                    }
                }
                return array;
            }
            function basePullAt(array, indexes) {
                var length = array ? indexes.length : 0,
                    lastIndex = length - 1;
                while (length--) {
                    var index2 = indexes[length];
                    if (length == lastIndex || index2 !== previous) {
                        var previous = index2;
                        if (isIndex2(index2)) {
                            splice2.call(array, index2, 1);
                        } else {
                            baseUnset(array, index2);
                        }
                    }
                }
                return array;
            }
            function baseRandom(lower, upper) {
                return (
                    lower + nativeFloor(nativeRandom() * (upper - lower + 1))
                );
            }
            function baseRange(start2, end, step, fromRight) {
                var index2 = -1,
                    length = nativeMax2(
                        nativeCeil((end - start2) / (step || 1)),
                        0
                    ),
                    result2 = Array2(length);
                while (length--) {
                    result2[fromRight ? length : ++index2] = start2;
                    start2 += step;
                }
                return result2;
            }
            function baseRepeat(string, n) {
                var result2 = "";
                if (!string || n < 1 || n > MAX_SAFE_INTEGER2) {
                    return result2;
                }
                do {
                    if (n % 2) {
                        result2 += string;
                    }
                    n = nativeFloor(n / 2);
                    if (n) {
                        string += string;
                    }
                } while (n);
                return result2;
            }
            function baseRest2(func, start2) {
                return setToString2(
                    overRest2(func, start2, identity2),
                    func + ""
                );
            }
            function baseSample(collection) {
                return arraySample(values(collection));
            }
            function baseSampleSize(collection, n) {
                var array = values(collection);
                return shuffleSelf(array, baseClamp(n, 0, array.length));
            }
            function baseSet(object, path, value, customizer) {
                if (!isObject2(object)) {
                    return object;
                }
                path = castPath(path, object);
                var index2 = -1,
                    length = path.length,
                    lastIndex = length - 1,
                    nested = object;
                while (nested != null && ++index2 < length) {
                    var key = toKey(path[index2]),
                        newValue = value;
                    if (
                        key === "__proto__" ||
                        key === "constructor" ||
                        key === "prototype"
                    ) {
                        return object;
                    }
                    if (index2 != lastIndex) {
                        var objValue = nested[key];
                        newValue = customizer
                            ? customizer(objValue, key, nested)
                            : undefined$1;
                        if (newValue === undefined$1) {
                            newValue = isObject2(objValue)
                                ? objValue
                                : isIndex2(path[index2 + 1])
                                ? []
                                : {};
                        }
                    }
                    assignValue2(nested, key, newValue);
                    nested = nested[key];
                }
                return object;
            }
            var baseSetData = !metaMap
                ? identity2
                : function (func, data3) {
                      metaMap.set(func, data3);
                      return func;
                  };
            var baseSetToString2 = !defineProperty2
                ? identity2
                : function (func, string) {
                      return defineProperty2(func, "toString", {
                          configurable: true,
                          enumerable: false,
                          value: constant2(string),
                          writable: true,
                      });
                  };
            function baseShuffle(collection) {
                return shuffleSelf(values(collection));
            }
            function baseSlice(array, start2, end) {
                var index2 = -1,
                    length = array.length;
                if (start2 < 0) {
                    start2 = -start2 > length ? 0 : length + start2;
                }
                end = end > length ? length : end;
                if (end < 0) {
                    end += length;
                }
                length = start2 > end ? 0 : (end - start2) >>> 0;
                start2 >>>= 0;
                var result2 = Array2(length);
                while (++index2 < length) {
                    result2[index2] = array[index2 + start2];
                }
                return result2;
            }
            function baseSome(collection, predicate) {
                var result2;
                baseEach(collection, function (value, index2, collection2) {
                    result2 = predicate(value, index2, collection2);
                    return !result2;
                });
                return !!result2;
            }
            function baseSortedIndex(array, value, retHighest) {
                var low = 0,
                    high = array == null ? low : array.length;
                if (
                    typeof value == "number" &&
                    value === value &&
                    high <= HALF_MAX_ARRAY_LENGTH
                ) {
                    while (low < high) {
                        var mid = (low + high) >>> 1,
                            computed = array[mid];
                        if (
                            computed !== null &&
                            !isSymbol2(computed) &&
                            (retHighest ? computed <= value : computed < value)
                        ) {
                            low = mid + 1;
                        } else {
                            high = mid;
                        }
                    }
                    return high;
                }
                return baseSortedIndexBy(array, value, identity2, retHighest);
            }
            function baseSortedIndexBy(array, value, iteratee2, retHighest) {
                var low = 0,
                    high = array == null ? 0 : array.length;
                if (high === 0) {
                    return 0;
                }
                value = iteratee2(value);
                var valIsNaN = value !== value,
                    valIsNull = value === null,
                    valIsSymbol = isSymbol2(value),
                    valIsUndefined = value === undefined$1;
                while (low < high) {
                    var mid = nativeFloor((low + high) / 2),
                        computed = iteratee2(array[mid]),
                        othIsDefined = computed !== undefined$1,
                        othIsNull = computed === null,
                        othIsReflexive = computed === computed,
                        othIsSymbol = isSymbol2(computed);
                    if (valIsNaN) {
                        var setLow = retHighest || othIsReflexive;
                    } else if (valIsUndefined) {
                        setLow = othIsReflexive && (retHighest || othIsDefined);
                    } else if (valIsNull) {
                        setLow =
                            othIsReflexive &&
                            othIsDefined &&
                            (retHighest || !othIsNull);
                    } else if (valIsSymbol) {
                        setLow =
                            othIsReflexive &&
                            othIsDefined &&
                            !othIsNull &&
                            (retHighest || !othIsSymbol);
                    } else if (othIsNull || othIsSymbol) {
                        setLow = false;
                    } else {
                        setLow = retHighest
                            ? computed <= value
                            : computed < value;
                    }
                    if (setLow) {
                        low = mid + 1;
                    } else {
                        high = mid;
                    }
                }
                return nativeMin(high, MAX_ARRAY_INDEX);
            }
            function baseSortedUniq(array, iteratee2) {
                var index2 = -1,
                    length = array.length,
                    resIndex = 0,
                    result2 = [];
                while (++index2 < length) {
                    var value = array[index2],
                        computed = iteratee2 ? iteratee2(value) : value;
                    if (!index2 || !eq2(computed, seen)) {
                        var seen = computed;
                        result2[resIndex++] = value === 0 ? 0 : value;
                    }
                }
                return result2;
            }
            function baseToNumber(value) {
                if (typeof value == "number") {
                    return value;
                }
                if (isSymbol2(value)) {
                    return NAN;
                }
                return +value;
            }
            function baseToString(value) {
                if (typeof value == "string") {
                    return value;
                }
                if (isArray2(value)) {
                    return arrayMap(value, baseToString) + "";
                }
                if (isSymbol2(value)) {
                    return symbolToString ? symbolToString.call(value) : "";
                }
                var result2 = value + "";
                return result2 == "0" && 1 / value == -INFINITY
                    ? "-0"
                    : result2;
            }
            function baseUniq(array, iteratee2, comparator) {
                var index2 = -1,
                    includes2 = arrayIncludes,
                    length = array.length,
                    isCommon = true,
                    result2 = [],
                    seen = result2;
                if (comparator) {
                    isCommon = false;
                    includes2 = arrayIncludesWith;
                } else if (length >= LARGE_ARRAY_SIZE2) {
                    var set4 = iteratee2 ? null : createSet(array);
                    if (set4) {
                        return setToArray2(set4);
                    }
                    isCommon = false;
                    includes2 = cacheHas2;
                    seen = new SetCache2();
                } else {
                    seen = iteratee2 ? [] : result2;
                }
                outer: while (++index2 < length) {
                    var value = array[index2],
                        computed = iteratee2 ? iteratee2(value) : value;
                    value = comparator || value !== 0 ? value : 0;
                    if (isCommon && computed === computed) {
                        var seenIndex = seen.length;
                        while (seenIndex--) {
                            if (seen[seenIndex] === computed) {
                                continue outer;
                            }
                        }
                        if (iteratee2) {
                            seen.push(computed);
                        }
                        result2.push(value);
                    } else if (!includes2(seen, computed, comparator)) {
                        if (seen !== result2) {
                            seen.push(computed);
                        }
                        result2.push(value);
                    }
                }
                return result2;
            }
            function baseUnset(object, path) {
                path = castPath(path, object);
                object = parent(object, path);
                return object == null || delete object[toKey(last(path))];
            }
            function baseUpdate(object, path, updater, customizer) {
                return baseSet(
                    object,
                    path,
                    updater(baseGet(object, path)),
                    customizer
                );
            }
            function baseWhile(array, predicate, isDrop, fromRight) {
                var length = array.length,
                    index2 = fromRight ? length : -1;
                while (
                    (fromRight ? index2-- : ++index2 < length) &&
                    predicate(array[index2], index2, array)
                ) {}
                return isDrop
                    ? baseSlice(
                          array,
                          fromRight ? 0 : index2,
                          fromRight ? index2 + 1 : length
                      )
                    : baseSlice(
                          array,
                          fromRight ? index2 + 1 : 0,
                          fromRight ? length : index2
                      );
            }
            function baseWrapperValue(value, actions2) {
                var result2 = value;
                if (result2 instanceof LazyWrapper) {
                    result2 = result2.value();
                }
                return arrayReduce(
                    actions2,
                    function (result3, action) {
                        return action.func.apply(
                            action.thisArg,
                            arrayPush2([result3], action.args)
                        );
                    },
                    result2
                );
            }
            function baseXor(arrays, iteratee2, comparator) {
                var length = arrays.length;
                if (length < 2) {
                    return length ? baseUniq(arrays[0]) : [];
                }
                var index2 = -1,
                    result2 = Array2(length);
                while (++index2 < length) {
                    var array = arrays[index2],
                        othIndex = -1;
                    while (++othIndex < length) {
                        if (othIndex != index2) {
                            result2[index2] = baseDifference(
                                result2[index2] || array,
                                arrays[othIndex],
                                iteratee2,
                                comparator
                            );
                        }
                    }
                }
                return baseUniq(baseFlatten(result2, 1), iteratee2, comparator);
            }
            function baseZipObject(props2, values2, assignFunc) {
                var index2 = -1,
                    length = props2.length,
                    valsLength = values2.length,
                    result2 = {};
                while (++index2 < length) {
                    var value =
                        index2 < valsLength ? values2[index2] : undefined$1;
                    assignFunc(result2, props2[index2], value);
                }
                return result2;
            }
            function castArrayLikeObject(value) {
                return isArrayLikeObject2(value) ? value : [];
            }
            function castFunction(value) {
                return typeof value == "function" ? value : identity2;
            }
            function castPath(value, object) {
                if (isArray2(value)) {
                    return value;
                }
                return isKey(value, object)
                    ? [value]
                    : stringToPath(toString2(value));
            }
            var castRest = baseRest2;
            function castSlice(array, start2, end) {
                var length = array.length;
                end = end === undefined$1 ? length : end;
                return !start2 && end >= length
                    ? array
                    : baseSlice(array, start2, end);
            }
            var clearTimeout2 =
                ctxClearTimeout ||
                function (id) {
                    return root2.clearTimeout(id);
                };
            function cloneBuffer2(buffer, isDeep) {
                if (isDeep) {
                    return buffer.slice();
                }
                var length = buffer.length,
                    result2 = allocUnsafe
                        ? allocUnsafe(length)
                        : new buffer.constructor(length);
                buffer.copy(result2);
                return result2;
            }
            function cloneArrayBuffer2(arrayBuffer) {
                var result2 = new arrayBuffer.constructor(
                    arrayBuffer.byteLength
                );
                new Uint8Array2(result2).set(new Uint8Array2(arrayBuffer));
                return result2;
            }
            function cloneDataView(dataView, isDeep) {
                var buffer = isDeep
                    ? cloneArrayBuffer2(dataView.buffer)
                    : dataView.buffer;
                return new dataView.constructor(
                    buffer,
                    dataView.byteOffset,
                    dataView.byteLength
                );
            }
            function cloneRegExp(regexp) {
                var result2 = new regexp.constructor(
                    regexp.source,
                    reFlags.exec(regexp)
                );
                result2.lastIndex = regexp.lastIndex;
                return result2;
            }
            function cloneSymbol(symbol) {
                return symbolValueOf2
                    ? Object2(symbolValueOf2.call(symbol))
                    : {};
            }
            function cloneTypedArray2(typedArray, isDeep) {
                var buffer = isDeep
                    ? cloneArrayBuffer2(typedArray.buffer)
                    : typedArray.buffer;
                return new typedArray.constructor(
                    buffer,
                    typedArray.byteOffset,
                    typedArray.length
                );
            }
            function compareAscending(value, other) {
                if (value !== other) {
                    var valIsDefined = value !== undefined$1,
                        valIsNull = value === null,
                        valIsReflexive = value === value,
                        valIsSymbol = isSymbol2(value);
                    var othIsDefined = other !== undefined$1,
                        othIsNull = other === null,
                        othIsReflexive = other === other,
                        othIsSymbol = isSymbol2(other);
                    if (
                        (!othIsNull &&
                            !othIsSymbol &&
                            !valIsSymbol &&
                            value > other) ||
                        (valIsSymbol &&
                            othIsDefined &&
                            othIsReflexive &&
                            !othIsNull &&
                            !othIsSymbol) ||
                        (valIsNull && othIsDefined && othIsReflexive) ||
                        (!valIsDefined && othIsReflexive) ||
                        !valIsReflexive
                    ) {
                        return 1;
                    }
                    if (
                        (!valIsNull &&
                            !valIsSymbol &&
                            !othIsSymbol &&
                            value < other) ||
                        (othIsSymbol &&
                            valIsDefined &&
                            valIsReflexive &&
                            !valIsNull &&
                            !valIsSymbol) ||
                        (othIsNull && valIsDefined && valIsReflexive) ||
                        (!othIsDefined && valIsReflexive) ||
                        !othIsReflexive
                    ) {
                        return -1;
                    }
                }
                return 0;
            }
            function compareMultiple(object, other, orders) {
                var index2 = -1,
                    objCriteria = object.criteria,
                    othCriteria = other.criteria,
                    length = objCriteria.length,
                    ordersLength = orders.length;
                while (++index2 < length) {
                    var result2 = compareAscending(
                        objCriteria[index2],
                        othCriteria[index2]
                    );
                    if (result2) {
                        if (index2 >= ordersLength) {
                            return result2;
                        }
                        var order = orders[index2];
                        return result2 * (order == "desc" ? -1 : 1);
                    }
                }
                return object.index - other.index;
            }
            function composeArgs(args, partials, holders, isCurried) {
                var argsIndex = -1,
                    argsLength = args.length,
                    holdersLength = holders.length,
                    leftIndex = -1,
                    leftLength = partials.length,
                    rangeLength = nativeMax2(argsLength - holdersLength, 0),
                    result2 = Array2(leftLength + rangeLength),
                    isUncurried = !isCurried;
                while (++leftIndex < leftLength) {
                    result2[leftIndex] = partials[leftIndex];
                }
                while (++argsIndex < holdersLength) {
                    if (isUncurried || argsIndex < argsLength) {
                        result2[holders[argsIndex]] = args[argsIndex];
                    }
                }
                while (rangeLength--) {
                    result2[leftIndex++] = args[argsIndex++];
                }
                return result2;
            }
            function composeArgsRight(args, partials, holders, isCurried) {
                var argsIndex = -1,
                    argsLength = args.length,
                    holdersIndex = -1,
                    holdersLength = holders.length,
                    rightIndex = -1,
                    rightLength = partials.length,
                    rangeLength = nativeMax2(argsLength - holdersLength, 0),
                    result2 = Array2(rangeLength + rightLength),
                    isUncurried = !isCurried;
                while (++argsIndex < rangeLength) {
                    result2[argsIndex] = args[argsIndex];
                }
                var offset2 = argsIndex;
                while (++rightIndex < rightLength) {
                    result2[offset2 + rightIndex] = partials[rightIndex];
                }
                while (++holdersIndex < holdersLength) {
                    if (isUncurried || argsIndex < argsLength) {
                        result2[offset2 + holders[holdersIndex]] =
                            args[argsIndex++];
                    }
                }
                return result2;
            }
            function copyArray2(source, array) {
                var index2 = -1,
                    length = source.length;
                array || (array = Array2(length));
                while (++index2 < length) {
                    array[index2] = source[index2];
                }
                return array;
            }
            function copyObject2(source, props2, object, customizer) {
                var isNew = !object;
                object || (object = {});
                var index2 = -1,
                    length = props2.length;
                while (++index2 < length) {
                    var key = props2[index2];
                    var newValue = customizer
                        ? customizer(
                              object[key],
                              source[key],
                              key,
                              object,
                              source
                          )
                        : undefined$1;
                    if (newValue === undefined$1) {
                        newValue = source[key];
                    }
                    if (isNew) {
                        baseAssignValue2(object, key, newValue);
                    } else {
                        assignValue2(object, key, newValue);
                    }
                }
                return object;
            }
            function copySymbols(source, object) {
                return copyObject2(source, getSymbols2(source), object);
            }
            function copySymbolsIn(source, object) {
                return copyObject2(source, getSymbolsIn(source), object);
            }
            function createAggregator(setter, initializer) {
                return function (collection, iteratee2) {
                    var func = isArray2(collection)
                            ? arrayAggregator
                            : baseAggregator,
                        accumulator = initializer ? initializer() : {};
                    return func(
                        collection,
                        setter,
                        getIteratee(iteratee2, 2),
                        accumulator
                    );
                };
            }
            function createAssigner2(assigner) {
                return baseRest2(function (object, sources) {
                    var index2 = -1,
                        length = sources.length,
                        customizer =
                            length > 1 ? sources[length - 1] : undefined$1,
                        guard = length > 2 ? sources[2] : undefined$1;
                    customizer =
                        assigner.length > 3 && typeof customizer == "function"
                            ? (length--, customizer)
                            : undefined$1;
                    if (
                        guard &&
                        isIterateeCall2(sources[0], sources[1], guard)
                    ) {
                        customizer = length < 3 ? undefined$1 : customizer;
                        length = 1;
                    }
                    object = Object2(object);
                    while (++index2 < length) {
                        var source = sources[index2];
                        if (source) {
                            assigner(object, source, index2, customizer);
                        }
                    }
                    return object;
                });
            }
            function createBaseEach(eachFunc, fromRight) {
                return function (collection, iteratee2) {
                    if (collection == null) {
                        return collection;
                    }
                    if (!isArrayLike2(collection)) {
                        return eachFunc(collection, iteratee2);
                    }
                    var length = collection.length,
                        index2 = fromRight ? length : -1,
                        iterable = Object2(collection);
                    while (fromRight ? index2-- : ++index2 < length) {
                        if (
                            iteratee2(iterable[index2], index2, iterable) ===
                            false
                        ) {
                            break;
                        }
                    }
                    return collection;
                };
            }
            function createBaseFor2(fromRight) {
                return function (object, iteratee2, keysFunc) {
                    var index2 = -1,
                        iterable = Object2(object),
                        props2 = keysFunc(object),
                        length = props2.length;
                    while (length--) {
                        var key = props2[fromRight ? length : ++index2];
                        if (iteratee2(iterable[key], key, iterable) === false) {
                            break;
                        }
                    }
                    return object;
                };
            }
            function createBind(func, bitmask, thisArg) {
                var isBind = bitmask & WRAP_BIND_FLAG,
                    Ctor = createCtor(func);
                function wrapper() {
                    var fn2 =
                        this && this !== root2 && this instanceof wrapper
                            ? Ctor
                            : func;
                    return fn2.apply(isBind ? thisArg : this, arguments);
                }
                return wrapper;
            }
            function createCaseFirst(methodName) {
                return function (string) {
                    string = toString2(string);
                    var strSymbols = hasUnicode(string)
                        ? stringToArray(string)
                        : undefined$1;
                    var chr = strSymbols ? strSymbols[0] : string.charAt(0);
                    var trailing = strSymbols
                        ? castSlice(strSymbols, 1).join("")
                        : string.slice(1);
                    return chr[methodName]() + trailing;
                };
            }
            function createCompounder(callback) {
                return function (string) {
                    return arrayReduce(
                        words(deburr(string).replace(reApos, "")),
                        callback,
                        ""
                    );
                };
            }
            function createCtor(Ctor) {
                return function () {
                    var args = arguments;
                    switch (args.length) {
                        case 0:
                            return new Ctor();
                        case 1:
                            return new Ctor(args[0]);
                        case 2:
                            return new Ctor(args[0], args[1]);
                        case 3:
                            return new Ctor(args[0], args[1], args[2]);
                        case 4:
                            return new Ctor(args[0], args[1], args[2], args[3]);
                        case 5:
                            return new Ctor(
                                args[0],
                                args[1],
                                args[2],
                                args[3],
                                args[4]
                            );
                        case 6:
                            return new Ctor(
                                args[0],
                                args[1],
                                args[2],
                                args[3],
                                args[4],
                                args[5]
                            );
                        case 7:
                            return new Ctor(
                                args[0],
                                args[1],
                                args[2],
                                args[3],
                                args[4],
                                args[5],
                                args[6]
                            );
                    }
                    var thisBinding = baseCreate2(Ctor.prototype),
                        result2 = Ctor.apply(thisBinding, args);
                    return isObject2(result2) ? result2 : thisBinding;
                };
            }
            function createCurry(func, bitmask, arity) {
                var Ctor = createCtor(func);
                function wrapper() {
                    var length = arguments.length,
                        args = Array2(length),
                        index2 = length,
                        placeholder2 = getHolder(wrapper);
                    while (index2--) {
                        args[index2] = arguments[index2];
                    }
                    var holders =
                        length < 3 &&
                        args[0] !== placeholder2 &&
                        args[length - 1] !== placeholder2
                            ? []
                            : replaceHolders(args, placeholder2);
                    length -= holders.length;
                    if (length < arity) {
                        return createRecurry(
                            func,
                            bitmask,
                            createHybrid,
                            wrapper.placeholder,
                            undefined$1,
                            args,
                            holders,
                            undefined$1,
                            undefined$1,
                            arity - length
                        );
                    }
                    var fn2 =
                        this && this !== root2 && this instanceof wrapper
                            ? Ctor
                            : func;
                    return apply2(fn2, this, args);
                }
                return wrapper;
            }
            function createFind(findIndexFunc) {
                return function (collection, predicate, fromIndex) {
                    var iterable = Object2(collection);
                    if (!isArrayLike2(collection)) {
                        var iteratee2 = getIteratee(predicate, 3);
                        collection = keys2(collection);
                        predicate = function (key) {
                            return iteratee2(iterable[key], key, iterable);
                        };
                    }
                    var index2 = findIndexFunc(
                        collection,
                        predicate,
                        fromIndex
                    );
                    return index2 > -1
                        ? iterable[iteratee2 ? collection[index2] : index2]
                        : undefined$1;
                };
            }
            function createFlow(fromRight) {
                return flatRest(function (funcs) {
                    var length = funcs.length,
                        index2 = length,
                        prereq = LodashWrapper.prototype.thru;
                    if (fromRight) {
                        funcs.reverse();
                    }
                    while (index2--) {
                        var func = funcs[index2];
                        if (typeof func != "function") {
                            throw new TypeError2(FUNC_ERROR_TEXT);
                        }
                        if (
                            prereq &&
                            !wrapper &&
                            getFuncName(func) == "wrapper"
                        ) {
                            var wrapper = new LodashWrapper([], true);
                        }
                    }
                    index2 = wrapper ? index2 : length;
                    while (++index2 < length) {
                        func = funcs[index2];
                        var funcName = getFuncName(func),
                            data3 =
                                funcName == "wrapper"
                                    ? getData2(func)
                                    : undefined$1;
                        if (
                            data3 &&
                            isLaziable(data3[0]) &&
                            data3[1] ==
                                (WRAP_ARY_FLAG |
                                    WRAP_CURRY_FLAG |
                                    WRAP_PARTIAL_FLAG |
                                    WRAP_REARG_FLAG) &&
                            !data3[4].length &&
                            data3[9] == 1
                        ) {
                            wrapper = wrapper[getFuncName(data3[0])].apply(
                                wrapper,
                                data3[3]
                            );
                        } else {
                            wrapper =
                                func.length == 1 && isLaziable(func)
                                    ? wrapper[funcName]()
                                    : wrapper.thru(func);
                        }
                    }
                    return function () {
                        var args = arguments,
                            value = args[0];
                        if (wrapper && args.length == 1 && isArray2(value)) {
                            return wrapper.plant(value).value();
                        }
                        var index3 = 0,
                            result2 = length
                                ? funcs[index3].apply(this, args)
                                : value;
                        while (++index3 < length) {
                            result2 = funcs[index3].call(this, result2);
                        }
                        return result2;
                    };
                });
            }
            function createHybrid(
                func,
                bitmask,
                thisArg,
                partials,
                holders,
                partialsRight,
                holdersRight,
                argPos,
                ary2,
                arity
            ) {
                var isAry = bitmask & WRAP_ARY_FLAG,
                    isBind = bitmask & WRAP_BIND_FLAG,
                    isBindKey = bitmask & WRAP_BIND_KEY_FLAG,
                    isCurried =
                        bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG),
                    isFlip = bitmask & WRAP_FLIP_FLAG,
                    Ctor = isBindKey ? undefined$1 : createCtor(func);
                function wrapper() {
                    var length = arguments.length,
                        args = Array2(length),
                        index2 = length;
                    while (index2--) {
                        args[index2] = arguments[index2];
                    }
                    if (isCurried) {
                        var placeholder2 = getHolder(wrapper),
                            holdersCount = countHolders(args, placeholder2);
                    }
                    if (partials) {
                        args = composeArgs(args, partials, holders, isCurried);
                    }
                    if (partialsRight) {
                        args = composeArgsRight(
                            args,
                            partialsRight,
                            holdersRight,
                            isCurried
                        );
                    }
                    length -= holdersCount;
                    if (isCurried && length < arity) {
                        var newHolders = replaceHolders(args, placeholder2);
                        return createRecurry(
                            func,
                            bitmask,
                            createHybrid,
                            wrapper.placeholder,
                            thisArg,
                            args,
                            newHolders,
                            argPos,
                            ary2,
                            arity - length
                        );
                    }
                    var thisBinding = isBind ? thisArg : this,
                        fn2 = isBindKey ? thisBinding[func] : func;
                    length = args.length;
                    if (argPos) {
                        args = reorder(args, argPos);
                    } else if (isFlip && length > 1) {
                        args.reverse();
                    }
                    if (isAry && ary2 < length) {
                        args.length = ary2;
                    }
                    if (this && this !== root2 && this instanceof wrapper) {
                        fn2 = Ctor || createCtor(fn2);
                    }
                    return fn2.apply(thisBinding, args);
                }
                return wrapper;
            }
            function createInverter(setter, toIteratee) {
                return function (object, iteratee2) {
                    return baseInverter(
                        object,
                        setter,
                        toIteratee(iteratee2),
                        {}
                    );
                };
            }
            function createMathOperation(operator, defaultValue) {
                return function (value, other) {
                    var result2;
                    if (value === undefined$1 && other === undefined$1) {
                        return defaultValue;
                    }
                    if (value !== undefined$1) {
                        result2 = value;
                    }
                    if (other !== undefined$1) {
                        if (result2 === undefined$1) {
                            return other;
                        }
                        if (
                            typeof value == "string" ||
                            typeof other == "string"
                        ) {
                            value = baseToString(value);
                            other = baseToString(other);
                        } else {
                            value = baseToNumber(value);
                            other = baseToNumber(other);
                        }
                        result2 = operator(value, other);
                    }
                    return result2;
                };
            }
            function createOver(arrayFunc) {
                return flatRest(function (iteratees) {
                    iteratees = arrayMap(iteratees, baseUnary2(getIteratee()));
                    return baseRest2(function (args) {
                        var thisArg = this;
                        return arrayFunc(iteratees, function (iteratee2) {
                            return apply2(iteratee2, thisArg, args);
                        });
                    });
                });
            }
            function createPadding(length, chars) {
                chars = chars === undefined$1 ? " " : baseToString(chars);
                var charsLength = chars.length;
                if (charsLength < 2) {
                    return charsLength ? baseRepeat(chars, length) : chars;
                }
                var result2 = baseRepeat(
                    chars,
                    nativeCeil(length / stringSize(chars))
                );
                return hasUnicode(chars)
                    ? castSlice(stringToArray(result2), 0, length).join("")
                    : result2.slice(0, length);
            }
            function createPartial(func, bitmask, thisArg, partials) {
                var isBind = bitmask & WRAP_BIND_FLAG,
                    Ctor = createCtor(func);
                function wrapper() {
                    var argsIndex = -1,
                        argsLength = arguments.length,
                        leftIndex = -1,
                        leftLength = partials.length,
                        args = Array2(leftLength + argsLength),
                        fn2 =
                            this && this !== root2 && this instanceof wrapper
                                ? Ctor
                                : func;
                    while (++leftIndex < leftLength) {
                        args[leftIndex] = partials[leftIndex];
                    }
                    while (argsLength--) {
                        args[leftIndex++] = arguments[++argsIndex];
                    }
                    return apply2(fn2, isBind ? thisArg : this, args);
                }
                return wrapper;
            }
            function createRange(fromRight) {
                return function (start2, end, step) {
                    if (
                        step &&
                        typeof step != "number" &&
                        isIterateeCall2(start2, end, step)
                    ) {
                        end = step = undefined$1;
                    }
                    start2 = toFinite(start2);
                    if (end === undefined$1) {
                        end = start2;
                        start2 = 0;
                    } else {
                        end = toFinite(end);
                    }
                    step =
                        step === undefined$1
                            ? start2 < end
                                ? 1
                                : -1
                            : toFinite(step);
                    return baseRange(start2, end, step, fromRight);
                };
            }
            function createRelationalOperation(operator) {
                return function (value, other) {
                    if (
                        !(typeof value == "string" && typeof other == "string")
                    ) {
                        value = toNumber2(value);
                        other = toNumber2(other);
                    }
                    return operator(value, other);
                };
            }
            function createRecurry(
                func,
                bitmask,
                wrapFunc,
                placeholder2,
                thisArg,
                partials,
                holders,
                argPos,
                ary2,
                arity
            ) {
                var isCurry = bitmask & WRAP_CURRY_FLAG,
                    newHolders = isCurry ? holders : undefined$1,
                    newHoldersRight = isCurry ? undefined$1 : holders,
                    newPartials = isCurry ? partials : undefined$1,
                    newPartialsRight = isCurry ? undefined$1 : partials;
                bitmask |= isCurry
                    ? WRAP_PARTIAL_FLAG
                    : WRAP_PARTIAL_RIGHT_FLAG;
                bitmask &= ~(isCurry
                    ? WRAP_PARTIAL_RIGHT_FLAG
                    : WRAP_PARTIAL_FLAG);
                if (!(bitmask & WRAP_CURRY_BOUND_FLAG)) {
                    bitmask &= ~(WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG);
                }
                var newData = [
                    func,
                    bitmask,
                    thisArg,
                    newPartials,
                    newHolders,
                    newPartialsRight,
                    newHoldersRight,
                    argPos,
                    ary2,
                    arity,
                ];
                var result2 = wrapFunc.apply(undefined$1, newData);
                if (isLaziable(func)) {
                    setData(result2, newData);
                }
                result2.placeholder = placeholder2;
                return setWrapToString(result2, func, bitmask);
            }
            function createRound(methodName) {
                var func = Math2[methodName];
                return function (number, precision) {
                    number = toNumber2(number);
                    precision =
                        precision == null
                            ? 0
                            : nativeMin(toInteger(precision), 292);
                    if (precision && nativeIsFinite(number)) {
                        var pair = (toString2(number) + "e").split("e"),
                            value = func(
                                pair[0] + "e" + (+pair[1] + precision)
                            );
                        pair = (toString2(value) + "e").split("e");
                        return +(pair[0] + "e" + (+pair[1] - precision));
                    }
                    return func(number);
                };
            }
            var createSet = !(
                Set2 && 1 / setToArray2(new Set2([, -0]))[1] == INFINITY
            )
                ? noop2
                : function (values2) {
                      return new Set2(values2);
                  };
            function createToPairs(keysFunc) {
                return function (object) {
                    var tag = getTag2(object);
                    if (tag == mapTag2) {
                        return mapToArray2(object);
                    }
                    if (tag == setTag2) {
                        return setToPairs(object);
                    }
                    return baseToPairs(object, keysFunc(object));
                };
            }
            function createWrap(
                func,
                bitmask,
                thisArg,
                partials,
                holders,
                argPos,
                ary2,
                arity
            ) {
                var isBindKey = bitmask & WRAP_BIND_KEY_FLAG;
                if (!isBindKey && typeof func != "function") {
                    throw new TypeError2(FUNC_ERROR_TEXT);
                }
                var length = partials ? partials.length : 0;
                if (!length) {
                    bitmask &= ~(WRAP_PARTIAL_FLAG | WRAP_PARTIAL_RIGHT_FLAG);
                    partials = holders = undefined$1;
                }
                ary2 =
                    ary2 === undefined$1
                        ? ary2
                        : nativeMax2(toInteger(ary2), 0);
                arity = arity === undefined$1 ? arity : toInteger(arity);
                length -= holders ? holders.length : 0;
                if (bitmask & WRAP_PARTIAL_RIGHT_FLAG) {
                    var partialsRight = partials,
                        holdersRight = holders;
                    partials = holders = undefined$1;
                }
                var data3 = isBindKey ? undefined$1 : getData2(func);
                var newData = [
                    func,
                    bitmask,
                    thisArg,
                    partials,
                    holders,
                    partialsRight,
                    holdersRight,
                    argPos,
                    ary2,
                    arity,
                ];
                if (data3) {
                    mergeData2(newData, data3);
                }
                func = newData[0];
                bitmask = newData[1];
                thisArg = newData[2];
                partials = newData[3];
                holders = newData[4];
                arity = newData[9] =
                    newData[9] === undefined$1
                        ? isBindKey
                            ? 0
                            : func.length
                        : nativeMax2(newData[9] - length, 0);
                if (
                    !arity &&
                    bitmask & (WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG)
                ) {
                    bitmask &= ~(WRAP_CURRY_FLAG | WRAP_CURRY_RIGHT_FLAG);
                }
                if (!bitmask || bitmask == WRAP_BIND_FLAG) {
                    var result2 = createBind(func, bitmask, thisArg);
                } else if (
                    bitmask == WRAP_CURRY_FLAG ||
                    bitmask == WRAP_CURRY_RIGHT_FLAG
                ) {
                    result2 = createCurry(func, bitmask, arity);
                } else if (
                    (bitmask == WRAP_PARTIAL_FLAG ||
                        bitmask == (WRAP_BIND_FLAG | WRAP_PARTIAL_FLAG)) &&
                    !holders.length
                ) {
                    result2 = createPartial(func, bitmask, thisArg, partials);
                } else {
                    result2 = createHybrid.apply(undefined$1, newData);
                }
                var setter = data3 ? baseSetData : setData;
                return setWrapToString(setter(result2, newData), func, bitmask);
            }
            function customDefaultsAssignIn(objValue, srcValue, key, object) {
                if (
                    objValue === undefined$1 ||
                    (eq2(objValue, objectProto2[key]) &&
                        !hasOwnProperty2.call(object, key))
                ) {
                    return srcValue;
                }
                return objValue;
            }
            function customDefaultsMerge(
                objValue,
                srcValue,
                key,
                object,
                source,
                stack
            ) {
                if (isObject2(objValue) && isObject2(srcValue)) {
                    stack.set(srcValue, objValue);
                    baseMerge2(
                        objValue,
                        srcValue,
                        undefined$1,
                        customDefaultsMerge,
                        stack
                    );
                    stack["delete"](srcValue);
                }
                return objValue;
            }
            function customOmitClone(value) {
                return isPlainObject2(value) ? undefined$1 : value;
            }
            function equalArrays2(
                array,
                other,
                bitmask,
                customizer,
                equalFunc,
                stack
            ) {
                var isPartial = bitmask & COMPARE_PARTIAL_FLAG2,
                    arrLength = array.length,
                    othLength = other.length;
                if (
                    arrLength != othLength &&
                    !(isPartial && othLength > arrLength)
                ) {
                    return false;
                }
                var arrStacked = stack.get(array);
                var othStacked = stack.get(other);
                if (arrStacked && othStacked) {
                    return arrStacked == other && othStacked == array;
                }
                var index2 = -1,
                    result2 = true,
                    seen =
                        bitmask & COMPARE_UNORDERED_FLAG2
                            ? new SetCache2()
                            : undefined$1;
                stack.set(array, other);
                stack.set(other, array);
                while (++index2 < arrLength) {
                    var arrValue = array[index2],
                        othValue = other[index2];
                    if (customizer) {
                        var compared = isPartial
                            ? customizer(
                                  othValue,
                                  arrValue,
                                  index2,
                                  other,
                                  array,
                                  stack
                              )
                            : customizer(
                                  arrValue,
                                  othValue,
                                  index2,
                                  array,
                                  other,
                                  stack
                              );
                    }
                    if (compared !== undefined$1) {
                        if (compared) {
                            continue;
                        }
                        result2 = false;
                        break;
                    }
                    if (seen) {
                        if (
                            !arraySome2(other, function (othValue2, othIndex) {
                                if (
                                    !cacheHas2(seen, othIndex) &&
                                    (arrValue === othValue2 ||
                                        equalFunc(
                                            arrValue,
                                            othValue2,
                                            bitmask,
                                            customizer,
                                            stack
                                        ))
                                ) {
                                    return seen.push(othIndex);
                                }
                            })
                        ) {
                            result2 = false;
                            break;
                        }
                    } else if (
                        !(
                            arrValue === othValue ||
                            equalFunc(
                                arrValue,
                                othValue,
                                bitmask,
                                customizer,
                                stack
                            )
                        )
                    ) {
                        result2 = false;
                        break;
                    }
                }
                stack["delete"](array);
                stack["delete"](other);
                return result2;
            }
            function equalByTag2(
                object,
                other,
                tag,
                bitmask,
                customizer,
                equalFunc,
                stack
            ) {
                switch (tag) {
                    case dataViewTag2:
                        if (
                            object.byteLength != other.byteLength ||
                            object.byteOffset != other.byteOffset
                        ) {
                            return false;
                        }
                        object = object.buffer;
                        other = other.buffer;
                    case arrayBufferTag2:
                        if (
                            object.byteLength != other.byteLength ||
                            !equalFunc(
                                new Uint8Array2(object),
                                new Uint8Array2(other)
                            )
                        ) {
                            return false;
                        }
                        return true;
                    case boolTag2:
                    case dateTag2:
                    case numberTag2:
                        return eq2(+object, +other);
                    case errorTag2:
                        return (
                            object.name == other.name &&
                            object.message == other.message
                        );
                    case regexpTag2:
                    case stringTag2:
                        return object == other + "";
                    case mapTag2:
                        var convert = mapToArray2;
                    case setTag2:
                        var isPartial = bitmask & COMPARE_PARTIAL_FLAG2;
                        convert || (convert = setToArray2);
                        if (object.size != other.size && !isPartial) {
                            return false;
                        }
                        var stacked = stack.get(object);
                        if (stacked) {
                            return stacked == other;
                        }
                        bitmask |= COMPARE_UNORDERED_FLAG2;
                        stack.set(object, other);
                        var result2 = equalArrays2(
                            convert(object),
                            convert(other),
                            bitmask,
                            customizer,
                            equalFunc,
                            stack
                        );
                        stack["delete"](object);
                        return result2;
                    case symbolTag2:
                        if (symbolValueOf2) {
                            return (
                                symbolValueOf2.call(object) ==
                                symbolValueOf2.call(other)
                            );
                        }
                }
                return false;
            }
            function equalObjects2(
                object,
                other,
                bitmask,
                customizer,
                equalFunc,
                stack
            ) {
                var isPartial = bitmask & COMPARE_PARTIAL_FLAG2,
                    objProps = getAllKeys2(object),
                    objLength = objProps.length,
                    othProps = getAllKeys2(other),
                    othLength = othProps.length;
                if (objLength != othLength && !isPartial) {
                    return false;
                }
                var index2 = objLength;
                while (index2--) {
                    var key = objProps[index2];
                    if (
                        !(isPartial
                            ? key in other
                            : hasOwnProperty2.call(other, key))
                    ) {
                        return false;
                    }
                }
                var objStacked = stack.get(object);
                var othStacked = stack.get(other);
                if (objStacked && othStacked) {
                    return objStacked == other && othStacked == object;
                }
                var result2 = true;
                stack.set(object, other);
                stack.set(other, object);
                var skipCtor = isPartial;
                while (++index2 < objLength) {
                    key = objProps[index2];
                    var objValue = object[key],
                        othValue = other[key];
                    if (customizer) {
                        var compared = isPartial
                            ? customizer(
                                  othValue,
                                  objValue,
                                  key,
                                  other,
                                  object,
                                  stack
                              )
                            : customizer(
                                  objValue,
                                  othValue,
                                  key,
                                  object,
                                  other,
                                  stack
                              );
                    }
                    if (
                        !(compared === undefined$1
                            ? objValue === othValue ||
                              equalFunc(
                                  objValue,
                                  othValue,
                                  bitmask,
                                  customizer,
                                  stack
                              )
                            : compared)
                    ) {
                        result2 = false;
                        break;
                    }
                    skipCtor || (skipCtor = key == "constructor");
                }
                if (result2 && !skipCtor) {
                    var objCtor = object.constructor,
                        othCtor = other.constructor;
                    if (
                        objCtor != othCtor &&
                        "constructor" in object &&
                        "constructor" in other &&
                        !(
                            typeof objCtor == "function" &&
                            objCtor instanceof objCtor &&
                            typeof othCtor == "function" &&
                            othCtor instanceof othCtor
                        )
                    ) {
                        result2 = false;
                    }
                }
                stack["delete"](object);
                stack["delete"](other);
                return result2;
            }
            function flatRest(func) {
                return setToString2(
                    overRest2(func, undefined$1, flatten),
                    func + ""
                );
            }
            function getAllKeys2(object) {
                return baseGetAllKeys2(object, keys2, getSymbols2);
            }
            function getAllKeysIn(object) {
                return baseGetAllKeys2(object, keysIn2, getSymbolsIn);
            }
            var getData2 = !metaMap
                ? noop2
                : function (func) {
                      return metaMap.get(func);
                  };
            function getFuncName(func) {
                var result2 = func.name + "",
                    array = realNames[result2],
                    length = hasOwnProperty2.call(realNames, result2)
                        ? array.length
                        : 0;
                while (length--) {
                    var data3 = array[length],
                        otherFunc = data3.func;
                    if (otherFunc == null || otherFunc == func) {
                        return data3.name;
                    }
                }
                return result2;
            }
            function getHolder(func) {
                var object = hasOwnProperty2.call(lodash2, "placeholder")
                    ? lodash2
                    : func;
                return object.placeholder;
            }
            function getIteratee() {
                var result2 = lodash2.iteratee || iteratee;
                result2 = result2 === iteratee ? baseIteratee : result2;
                return arguments.length
                    ? result2(arguments[0], arguments[1])
                    : result2;
            }
            function getMapData2(map3, key) {
                var data3 = map3.__data__;
                return isKeyable2(key)
                    ? data3[typeof key == "string" ? "string" : "hash"]
                    : data3.map;
            }
            function getMatchData(object) {
                var result2 = keys2(object),
                    length = result2.length;
                while (length--) {
                    var key = result2[length],
                        value = object[key];
                    result2[length] = [key, value, isStrictComparable(value)];
                }
                return result2;
            }
            function getNative2(object, key) {
                var value = getValue2(object, key);
                return baseIsNative2(value) ? value : undefined$1;
            }
            function getRawTag2(value) {
                var isOwn = hasOwnProperty2.call(value, symToStringTag2),
                    tag = value[symToStringTag2];
                try {
                    value[symToStringTag2] = undefined$1;
                    var unmasked = true;
                } catch (e) {}
                var result2 = nativeObjectToString2.call(value);
                if (unmasked) {
                    if (isOwn) {
                        value[symToStringTag2] = tag;
                    } else {
                        delete value[symToStringTag2];
                    }
                }
                return result2;
            }
            var getSymbols2 = !nativeGetSymbols2
                ? stubArray2
                : function (object) {
                      if (object == null) {
                          return [];
                      }
                      object = Object2(object);
                      return arrayFilter2(
                          nativeGetSymbols2(object),
                          function (symbol) {
                              return propertyIsEnumerable2.call(object, symbol);
                          }
                      );
                  };
            var getSymbolsIn = !nativeGetSymbols2
                ? stubArray2
                : function (object) {
                      var result2 = [];
                      while (object) {
                          arrayPush2(result2, getSymbols2(object));
                          object = getPrototype2(object);
                      }
                      return result2;
                  };
            var getTag2 = baseGetTag2;
            if (
                (DataView2 &&
                    getTag2(new DataView2(new ArrayBuffer(1))) !=
                        dataViewTag2) ||
                (Map2 && getTag2(new Map2()) != mapTag2) ||
                (Promise2 && getTag2(Promise2.resolve()) != promiseTag2) ||
                (Set2 && getTag2(new Set2()) != setTag2) ||
                (WeakMap2 && getTag2(new WeakMap2()) != weakMapTag2)
            ) {
                getTag2 = function (value) {
                    var result2 = baseGetTag2(value),
                        Ctor =
                            result2 == objectTag2
                                ? value.constructor
                                : undefined$1,
                        ctorString = Ctor ? toSource2(Ctor) : "";
                    if (ctorString) {
                        switch (ctorString) {
                            case dataViewCtorString2:
                                return dataViewTag2;
                            case mapCtorString2:
                                return mapTag2;
                            case promiseCtorString2:
                                return promiseTag2;
                            case setCtorString2:
                                return setTag2;
                            case weakMapCtorString2:
                                return weakMapTag2;
                        }
                    }
                    return result2;
                };
            }
            function getView(start2, end, transforms2) {
                var index2 = -1,
                    length = transforms2.length;
                while (++index2 < length) {
                    var data3 = transforms2[index2],
                        size3 = data3.size;
                    switch (data3.type) {
                        case "drop":
                            start2 += size3;
                            break;
                        case "dropRight":
                            end -= size3;
                            break;
                        case "take":
                            end = nativeMin(end, start2 + size3);
                            break;
                        case "takeRight":
                            start2 = nativeMax2(start2, end - size3);
                            break;
                    }
                }
                return { start: start2, end: end };
            }
            function getWrapDetails(source) {
                var match = source.match(reWrapDetails);
                return match ? match[1].split(reSplitDetails) : [];
            }
            function hasPath(object, path, hasFunc) {
                path = castPath(path, object);
                var index2 = -1,
                    length = path.length,
                    result2 = false;
                while (++index2 < length) {
                    var key = toKey(path[index2]);
                    if (!(result2 = object != null && hasFunc(object, key))) {
                        break;
                    }
                    object = object[key];
                }
                if (result2 || ++index2 != length) {
                    return result2;
                }
                length = object == null ? 0 : object.length;
                return (
                    !!length &&
                    isLength2(length) &&
                    isIndex2(key, length) &&
                    (isArray2(object) || isArguments2(object))
                );
            }
            function initCloneArray(array) {
                var length = array.length,
                    result2 = new array.constructor(length);
                if (
                    length &&
                    typeof array[0] == "string" &&
                    hasOwnProperty2.call(array, "index")
                ) {
                    result2.index = array.index;
                    result2.input = array.input;
                }
                return result2;
            }
            function initCloneObject2(object) {
                return typeof object.constructor == "function" &&
                    !isPrototype2(object)
                    ? baseCreate2(getPrototype2(object))
                    : {};
            }
            function initCloneByTag(object, tag, isDeep) {
                var Ctor = object.constructor;
                switch (tag) {
                    case arrayBufferTag2:
                        return cloneArrayBuffer2(object);
                    case boolTag2:
                    case dateTag2:
                        return new Ctor(+object);
                    case dataViewTag2:
                        return cloneDataView(object, isDeep);
                    case float32Tag2:
                    case float64Tag2:
                    case int8Tag2:
                    case int16Tag2:
                    case int32Tag2:
                    case uint8Tag2:
                    case uint8ClampedTag2:
                    case uint16Tag2:
                    case uint32Tag2:
                        return cloneTypedArray2(object, isDeep);
                    case mapTag2:
                        return new Ctor();
                    case numberTag2:
                    case stringTag2:
                        return new Ctor(object);
                    case regexpTag2:
                        return cloneRegExp(object);
                    case setTag2:
                        return new Ctor();
                    case symbolTag2:
                        return cloneSymbol(object);
                }
            }
            function insertWrapDetails(source, details) {
                var length = details.length;
                if (!length) {
                    return source;
                }
                var lastIndex = length - 1;
                details[lastIndex] =
                    (length > 1 ? "& " : "") + details[lastIndex];
                details = details.join(length > 2 ? ", " : " ");
                return source.replace(
                    reWrapComment,
                    "{\n/* [wrapped with " + details + "] */\n"
                );
            }
            function isFlattenable(value) {
                return (
                    isArray2(value) ||
                    isArguments2(value) ||
                    !!(spreadableSymbol && value && value[spreadableSymbol])
                );
            }
            function isIndex2(value, length) {
                var type = typeof value;
                length = length == null ? MAX_SAFE_INTEGER2 : length;
                return (
                    !!length &&
                    (type == "number" ||
                        (type != "symbol" && reIsUint2.test(value))) &&
                    value > -1 &&
                    value % 1 == 0 &&
                    value < length
                );
            }
            function isIterateeCall2(value, index2, object) {
                if (!isObject2(object)) {
                    return false;
                }
                var type = typeof index2;
                if (
                    type == "number"
                        ? isArrayLike2(object) &&
                          isIndex2(index2, object.length)
                        : type == "string" && index2 in object
                ) {
                    return eq2(object[index2], value);
                }
                return false;
            }
            function isKey(value, object) {
                if (isArray2(value)) {
                    return false;
                }
                var type = typeof value;
                if (
                    type == "number" ||
                    type == "symbol" ||
                    type == "boolean" ||
                    value == null ||
                    isSymbol2(value)
                ) {
                    return true;
                }
                return (
                    reIsPlainProp.test(value) ||
                    !reIsDeepProp.test(value) ||
                    (object != null && value in Object2(object))
                );
            }
            function isKeyable2(value) {
                var type = typeof value;
                return type == "string" ||
                    type == "number" ||
                    type == "symbol" ||
                    type == "boolean"
                    ? value !== "__proto__"
                    : value === null;
            }
            function isLaziable(func) {
                var funcName = getFuncName(func),
                    other = lodash2[funcName];
                if (
                    typeof other != "function" ||
                    !(funcName in LazyWrapper.prototype)
                ) {
                    return false;
                }
                if (func === other) {
                    return true;
                }
                var data3 = getData2(other);
                return !!data3 && func === data3[0];
            }
            function isMasked2(func) {
                return !!maskSrcKey2 && maskSrcKey2 in func;
            }
            var isMaskable = coreJsData2 ? isFunction2 : stubFalse2;
            function isPrototype2(value) {
                var Ctor = value && value.constructor,
                    proto =
                        (typeof Ctor == "function" && Ctor.prototype) ||
                        objectProto2;
                return value === proto;
            }
            function isStrictComparable(value) {
                return value === value && !isObject2(value);
            }
            function matchesStrictComparable(key, srcValue) {
                return function (object) {
                    if (object == null) {
                        return false;
                    }
                    return (
                        object[key] === srcValue &&
                        (srcValue !== undefined$1 || key in Object2(object))
                    );
                };
            }
            function memoizeCapped(func) {
                var result2 = memoize(func, function (key) {
                    if (cache.size === MAX_MEMOIZE_SIZE) {
                        cache.clear();
                    }
                    return key;
                });
                var cache = result2.cache;
                return result2;
            }
            function mergeData2(data3, source) {
                var bitmask = data3[1],
                    srcBitmask = source[1],
                    newBitmask = bitmask | srcBitmask,
                    isCommon =
                        newBitmask <
                        (WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG | WRAP_ARY_FLAG);
                var isCombo =
                    (srcBitmask == WRAP_ARY_FLAG &&
                        bitmask == WRAP_CURRY_FLAG) ||
                    (srcBitmask == WRAP_ARY_FLAG &&
                        bitmask == WRAP_REARG_FLAG &&
                        data3[7].length <= source[8]) ||
                    (srcBitmask == (WRAP_ARY_FLAG | WRAP_REARG_FLAG) &&
                        source[7].length <= source[8] &&
                        bitmask == WRAP_CURRY_FLAG);
                if (!(isCommon || isCombo)) {
                    return data3;
                }
                if (srcBitmask & WRAP_BIND_FLAG) {
                    data3[2] = source[2];
                    newBitmask |=
                        bitmask & WRAP_BIND_FLAG ? 0 : WRAP_CURRY_BOUND_FLAG;
                }
                var value = source[3];
                if (value) {
                    var partials = data3[3];
                    data3[3] = partials
                        ? composeArgs(partials, value, source[4])
                        : value;
                    data3[4] = partials
                        ? replaceHolders(data3[3], PLACEHOLDER)
                        : source[4];
                }
                value = source[5];
                if (value) {
                    partials = data3[5];
                    data3[5] = partials
                        ? composeArgsRight(partials, value, source[6])
                        : value;
                    data3[6] = partials
                        ? replaceHolders(data3[5], PLACEHOLDER)
                        : source[6];
                }
                value = source[7];
                if (value) {
                    data3[7] = value;
                }
                if (srcBitmask & WRAP_ARY_FLAG) {
                    data3[8] =
                        data3[8] == null
                            ? source[8]
                            : nativeMin(data3[8], source[8]);
                }
                if (data3[9] == null) {
                    data3[9] = source[9];
                }
                data3[0] = source[0];
                data3[1] = newBitmask;
                return data3;
            }
            function nativeKeysIn2(object) {
                var result2 = [];
                if (object != null) {
                    for (var key in Object2(object)) {
                        result2.push(key);
                    }
                }
                return result2;
            }
            function objectToString2(value) {
                return nativeObjectToString2.call(value);
            }
            function overRest2(func, start2, transform2) {
                start2 = nativeMax2(
                    start2 === undefined$1 ? func.length - 1 : start2,
                    0
                );
                return function () {
                    var args = arguments,
                        index2 = -1,
                        length = nativeMax2(args.length - start2, 0),
                        array = Array2(length);
                    while (++index2 < length) {
                        array[index2] = args[start2 + index2];
                    }
                    index2 = -1;
                    var otherArgs = Array2(start2 + 1);
                    while (++index2 < start2) {
                        otherArgs[index2] = args[index2];
                    }
                    otherArgs[start2] = transform2(array);
                    return apply2(func, this, otherArgs);
                };
            }
            function parent(object, path) {
                return path.length < 2
                    ? object
                    : baseGet(object, baseSlice(path, 0, -1));
            }
            function reorder(array, indexes) {
                var arrLength = array.length,
                    length = nativeMin(indexes.length, arrLength),
                    oldArray = copyArray2(array);
                while (length--) {
                    var index2 = indexes[length];
                    array[length] = isIndex2(index2, arrLength)
                        ? oldArray[index2]
                        : undefined$1;
                }
                return array;
            }
            function safeGet2(object, key) {
                if (
                    key === "constructor" &&
                    typeof object[key] === "function"
                ) {
                    return;
                }
                if (key == "__proto__") {
                    return;
                }
                return object[key];
            }
            var setData = shortOut2(baseSetData);
            var setTimeout2 =
                ctxSetTimeout ||
                function (func, wait) {
                    return root2.setTimeout(func, wait);
                };
            var setToString2 = shortOut2(baseSetToString2);
            function setWrapToString(wrapper, reference, bitmask) {
                var source = reference + "";
                return setToString2(
                    wrapper,
                    insertWrapDetails(
                        source,
                        updateWrapDetails(getWrapDetails(source), bitmask)
                    )
                );
            }
            function shortOut2(func) {
                var count = 0,
                    lastCalled = 0;
                return function () {
                    var stamp = nativeNow2(),
                        remaining = HOT_SPAN2 - (stamp - lastCalled);
                    lastCalled = stamp;
                    if (remaining > 0) {
                        if (++count >= HOT_COUNT2) {
                            return arguments[0];
                        }
                    } else {
                        count = 0;
                    }
                    return func.apply(undefined$1, arguments);
                };
            }
            function shuffleSelf(array, size3) {
                var index2 = -1,
                    length = array.length,
                    lastIndex = length - 1;
                size3 = size3 === undefined$1 ? length : size3;
                while (++index2 < size3) {
                    var rand = baseRandom(index2, lastIndex),
                        value = array[rand];
                    array[rand] = array[index2];
                    array[index2] = value;
                }
                array.length = size3;
                return array;
            }
            var stringToPath = memoizeCapped(function (string) {
                var result2 = [];
                if (string.charCodeAt(0) === 46) {
                    result2.push("");
                }
                string.replace(
                    rePropName,
                    function (match, number, quote, subString) {
                        result2.push(
                            quote
                                ? subString.replace(reEscapeChar, "$1")
                                : number || match
                        );
                    }
                );
                return result2;
            });
            function toKey(value) {
                if (typeof value == "string" || isSymbol2(value)) {
                    return value;
                }
                var result2 = value + "";
                return result2 == "0" && 1 / value == -INFINITY
                    ? "-0"
                    : result2;
            }
            function toSource2(func) {
                if (func != null) {
                    try {
                        return funcToString2.call(func);
                    } catch (e) {}
                    try {
                        return func + "";
                    } catch (e) {}
                }
                return "";
            }
            function updateWrapDetails(details, bitmask) {
                arrayEach(wrapFlags, function (pair) {
                    var value = "_." + pair[0];
                    if (bitmask & pair[1] && !arrayIncludes(details, value)) {
                        details.push(value);
                    }
                });
                return details.sort();
            }
            function wrapperClone(wrapper) {
                if (wrapper instanceof LazyWrapper) {
                    return wrapper.clone();
                }
                var result2 = new LodashWrapper(
                    wrapper.__wrapped__,
                    wrapper.__chain__
                );
                result2.__actions__ = copyArray2(wrapper.__actions__);
                result2.__index__ = wrapper.__index__;
                result2.__values__ = wrapper.__values__;
                return result2;
            }
            function chunk(array, size3, guard) {
                if (
                    guard
                        ? isIterateeCall2(array, size3, guard)
                        : size3 === undefined$1
                ) {
                    size3 = 1;
                } else {
                    size3 = nativeMax2(toInteger(size3), 0);
                }
                var length = array == null ? 0 : array.length;
                if (!length || size3 < 1) {
                    return [];
                }
                var index2 = 0,
                    resIndex = 0,
                    result2 = Array2(nativeCeil(length / size3));
                while (index2 < length) {
                    result2[resIndex++] = baseSlice(
                        array,
                        index2,
                        (index2 += size3)
                    );
                }
                return result2;
            }
            function compact(array) {
                var index2 = -1,
                    length = array == null ? 0 : array.length,
                    resIndex = 0,
                    result2 = [];
                while (++index2 < length) {
                    var value = array[index2];
                    if (value) {
                        result2[resIndex++] = value;
                    }
                }
                return result2;
            }
            function concat2() {
                var length = arguments.length;
                if (!length) {
                    return [];
                }
                var args = Array2(length - 1),
                    array = arguments[0],
                    index2 = length;
                while (index2--) {
                    args[index2 - 1] = arguments[index2];
                }
                return arrayPush2(
                    isArray2(array) ? copyArray2(array) : [array],
                    baseFlatten(args, 1)
                );
            }
            var difference = baseRest2(function (array, values2) {
                return isArrayLikeObject2(array)
                    ? baseDifference(
                          array,
                          baseFlatten(values2, 1, isArrayLikeObject2, true)
                      )
                    : [];
            });
            var differenceBy = baseRest2(function (array, values2) {
                var iteratee2 = last(values2);
                if (isArrayLikeObject2(iteratee2)) {
                    iteratee2 = undefined$1;
                }
                return isArrayLikeObject2(array)
                    ? baseDifference(
                          array,
                          baseFlatten(values2, 1, isArrayLikeObject2, true),
                          getIteratee(iteratee2, 2)
                      )
                    : [];
            });
            var differenceWith = baseRest2(function (array, values2) {
                var comparator = last(values2);
                if (isArrayLikeObject2(comparator)) {
                    comparator = undefined$1;
                }
                return isArrayLikeObject2(array)
                    ? baseDifference(
                          array,
                          baseFlatten(values2, 1, isArrayLikeObject2, true),
                          undefined$1,
                          comparator
                      )
                    : [];
            });
            function drop2(array, n, guard) {
                var length = array == null ? 0 : array.length;
                if (!length) {
                    return [];
                }
                n = guard || n === undefined$1 ? 1 : toInteger(n);
                return baseSlice(array, n < 0 ? 0 : n, length);
            }
            function dropRight(array, n, guard) {
                var length = array == null ? 0 : array.length;
                if (!length) {
                    return [];
                }
                n = guard || n === undefined$1 ? 1 : toInteger(n);
                n = length - n;
                return baseSlice(array, 0, n < 0 ? 0 : n);
            }
            function dropRightWhile(array, predicate) {
                return array && array.length
                    ? baseWhile(array, getIteratee(predicate, 3), true, true)
                    : [];
            }
            function dropWhile(array, predicate) {
                return array && array.length
                    ? baseWhile(array, getIteratee(predicate, 3), true)
                    : [];
            }
            function fill(array, value, start2, end) {
                var length = array == null ? 0 : array.length;
                if (!length) {
                    return [];
                }
                if (
                    start2 &&
                    typeof start2 != "number" &&
                    isIterateeCall2(array, value, start2)
                ) {
                    start2 = 0;
                    end = length;
                }
                return baseFill(array, value, start2, end);
            }
            function findIndex2(array, predicate, fromIndex) {
                var length = array == null ? 0 : array.length;
                if (!length) {
                    return -1;
                }
                var index2 = fromIndex == null ? 0 : toInteger(fromIndex);
                if (index2 < 0) {
                    index2 = nativeMax2(length + index2, 0);
                }
                return baseFindIndex(array, getIteratee(predicate, 3), index2);
            }
            function findLastIndex(array, predicate, fromIndex) {
                var length = array == null ? 0 : array.length;
                if (!length) {
                    return -1;
                }
                var index2 = length - 1;
                if (fromIndex !== undefined$1) {
                    index2 = toInteger(fromIndex);
                    index2 =
                        fromIndex < 0
                            ? nativeMax2(length + index2, 0)
                            : nativeMin(index2, length - 1);
                }
                return baseFindIndex(
                    array,
                    getIteratee(predicate, 3),
                    index2,
                    true
                );
            }
            function flatten(array) {
                var length = array == null ? 0 : array.length;
                return length ? baseFlatten(array, 1) : [];
            }
            function flattenDeep(array) {
                var length = array == null ? 0 : array.length;
                return length ? baseFlatten(array, INFINITY) : [];
            }
            function flattenDepth(array, depth) {
                var length = array == null ? 0 : array.length;
                if (!length) {
                    return [];
                }
                depth = depth === undefined$1 ? 1 : toInteger(depth);
                return baseFlatten(array, depth);
            }
            function fromPairs(pairs) {
                var index2 = -1,
                    length = pairs == null ? 0 : pairs.length,
                    result2 = {};
                while (++index2 < length) {
                    var pair = pairs[index2];
                    result2[pair[0]] = pair[1];
                }
                return result2;
            }
            function head(array) {
                return array && array.length ? array[0] : undefined$1;
            }
            function indexOf(array, value, fromIndex) {
                var length = array == null ? 0 : array.length;
                if (!length) {
                    return -1;
                }
                var index2 = fromIndex == null ? 0 : toInteger(fromIndex);
                if (index2 < 0) {
                    index2 = nativeMax2(length + index2, 0);
                }
                return baseIndexOf(array, value, index2);
            }
            function initial(array) {
                var length = array == null ? 0 : array.length;
                return length ? baseSlice(array, 0, -1) : [];
            }
            var intersection = baseRest2(function (arrays) {
                var mapped = arrayMap(arrays, castArrayLikeObject);
                return mapped.length && mapped[0] === arrays[0]
                    ? baseIntersection(mapped)
                    : [];
            });
            var intersectionBy = baseRest2(function (arrays) {
                var iteratee2 = last(arrays),
                    mapped = arrayMap(arrays, castArrayLikeObject);
                if (iteratee2 === last(mapped)) {
                    iteratee2 = undefined$1;
                } else {
                    mapped.pop();
                }
                return mapped.length && mapped[0] === arrays[0]
                    ? baseIntersection(mapped, getIteratee(iteratee2, 2))
                    : [];
            });
            var intersectionWith = baseRest2(function (arrays) {
                var comparator = last(arrays),
                    mapped = arrayMap(arrays, castArrayLikeObject);
                comparator =
                    typeof comparator == "function" ? comparator : undefined$1;
                if (comparator) {
                    mapped.pop();
                }
                return mapped.length && mapped[0] === arrays[0]
                    ? baseIntersection(mapped, undefined$1, comparator)
                    : [];
            });
            function join(array, separator) {
                return array == null ? "" : nativeJoin.call(array, separator);
            }
            function last(array) {
                var length = array == null ? 0 : array.length;
                return length ? array[length - 1] : undefined$1;
            }
            function lastIndexOf(array, value, fromIndex) {
                var length = array == null ? 0 : array.length;
                if (!length) {
                    return -1;
                }
                var index2 = length;
                if (fromIndex !== undefined$1) {
                    index2 = toInteger(fromIndex);
                    index2 =
                        index2 < 0
                            ? nativeMax2(length + index2, 0)
                            : nativeMin(index2, length - 1);
                }
                return value === value
                    ? strictLastIndexOf(array, value, index2)
                    : baseFindIndex(array, baseIsNaN, index2, true);
            }
            function nth(array, n) {
                return array && array.length
                    ? baseNth(array, toInteger(n))
                    : undefined$1;
            }
            var pull = baseRest2(pullAll);
            function pullAll(array, values2) {
                return array && array.length && values2 && values2.length
                    ? basePullAll(array, values2)
                    : array;
            }
            function pullAllBy(array, values2, iteratee2) {
                return array && array.length && values2 && values2.length
                    ? basePullAll(array, values2, getIteratee(iteratee2, 2))
                    : array;
            }
            function pullAllWith(array, values2, comparator) {
                return array && array.length && values2 && values2.length
                    ? basePullAll(array, values2, undefined$1, comparator)
                    : array;
            }
            var pullAt = flatRest(function (array, indexes) {
                var length = array == null ? 0 : array.length,
                    result2 = baseAt(array, indexes);
                basePullAt(
                    array,
                    arrayMap(indexes, function (index2) {
                        return isIndex2(index2, length) ? +index2 : index2;
                    }).sort(compareAscending)
                );
                return result2;
            });
            function remove2(array, predicate) {
                var result2 = [];
                if (!(array && array.length)) {
                    return result2;
                }
                var index2 = -1,
                    indexes = [],
                    length = array.length;
                predicate = getIteratee(predicate, 3);
                while (++index2 < length) {
                    var value = array[index2];
                    if (predicate(value, index2, array)) {
                        result2.push(value);
                        indexes.push(index2);
                    }
                }
                basePullAt(array, indexes);
                return result2;
            }
            function reverse(array) {
                return array == null ? array : nativeReverse.call(array);
            }
            function slice(array, start2, end) {
                var length = array == null ? 0 : array.length;
                if (!length) {
                    return [];
                }
                if (
                    end &&
                    typeof end != "number" &&
                    isIterateeCall2(array, start2, end)
                ) {
                    start2 = 0;
                    end = length;
                } else {
                    start2 = start2 == null ? 0 : toInteger(start2);
                    end = end === undefined$1 ? length : toInteger(end);
                }
                return baseSlice(array, start2, end);
            }
            function sortedIndex(array, value) {
                return baseSortedIndex(array, value);
            }
            function sortedIndexBy(array, value, iteratee2) {
                return baseSortedIndexBy(
                    array,
                    value,
                    getIteratee(iteratee2, 2)
                );
            }
            function sortedIndexOf(array, value) {
                var length = array == null ? 0 : array.length;
                if (length) {
                    var index2 = baseSortedIndex(array, value);
                    if (index2 < length && eq2(array[index2], value)) {
                        return index2;
                    }
                }
                return -1;
            }
            function sortedLastIndex(array, value) {
                return baseSortedIndex(array, value, true);
            }
            function sortedLastIndexBy(array, value, iteratee2) {
                return baseSortedIndexBy(
                    array,
                    value,
                    getIteratee(iteratee2, 2),
                    true
                );
            }
            function sortedLastIndexOf(array, value) {
                var length = array == null ? 0 : array.length;
                if (length) {
                    var index2 = baseSortedIndex(array, value, true) - 1;
                    if (eq2(array[index2], value)) {
                        return index2;
                    }
                }
                return -1;
            }
            function sortedUniq(array) {
                return array && array.length ? baseSortedUniq(array) : [];
            }
            function sortedUniqBy(array, iteratee2) {
                return array && array.length
                    ? baseSortedUniq(array, getIteratee(iteratee2, 2))
                    : [];
            }
            function tail(array) {
                var length = array == null ? 0 : array.length;
                return length ? baseSlice(array, 1, length) : [];
            }
            function take(array, n, guard) {
                if (!(array && array.length)) {
                    return [];
                }
                n = guard || n === undefined$1 ? 1 : toInteger(n);
                return baseSlice(array, 0, n < 0 ? 0 : n);
            }
            function takeRight(array, n, guard) {
                var length = array == null ? 0 : array.length;
                if (!length) {
                    return [];
                }
                n = guard || n === undefined$1 ? 1 : toInteger(n);
                n = length - n;
                return baseSlice(array, n < 0 ? 0 : n, length);
            }
            function takeRightWhile(array, predicate) {
                return array && array.length
                    ? baseWhile(array, getIteratee(predicate, 3), false, true)
                    : [];
            }
            function takeWhile(array, predicate) {
                return array && array.length
                    ? baseWhile(array, getIteratee(predicate, 3))
                    : [];
            }
            var union = baseRest2(function (arrays) {
                return baseUniq(
                    baseFlatten(arrays, 1, isArrayLikeObject2, true)
                );
            });
            var unionBy = baseRest2(function (arrays) {
                var iteratee2 = last(arrays);
                if (isArrayLikeObject2(iteratee2)) {
                    iteratee2 = undefined$1;
                }
                return baseUniq(
                    baseFlatten(arrays, 1, isArrayLikeObject2, true),
                    getIteratee(iteratee2, 2)
                );
            });
            var unionWith = baseRest2(function (arrays) {
                var comparator = last(arrays);
                comparator =
                    typeof comparator == "function" ? comparator : undefined$1;
                return baseUniq(
                    baseFlatten(arrays, 1, isArrayLikeObject2, true),
                    undefined$1,
                    comparator
                );
            });
            function uniq(array) {
                return array && array.length ? baseUniq(array) : [];
            }
            function uniqBy(array, iteratee2) {
                return array && array.length
                    ? baseUniq(array, getIteratee(iteratee2, 2))
                    : [];
            }
            function uniqWith(array, comparator) {
                comparator =
                    typeof comparator == "function" ? comparator : undefined$1;
                return array && array.length
                    ? baseUniq(array, undefined$1, comparator)
                    : [];
            }
            function unzip(array) {
                if (!(array && array.length)) {
                    return [];
                }
                var length = 0;
                array = arrayFilter2(array, function (group) {
                    if (isArrayLikeObject2(group)) {
                        length = nativeMax2(group.length, length);
                        return true;
                    }
                });
                return baseTimes2(length, function (index2) {
                    return arrayMap(array, baseProperty(index2));
                });
            }
            function unzipWith(array, iteratee2) {
                if (!(array && array.length)) {
                    return [];
                }
                var result2 = unzip(array);
                if (iteratee2 == null) {
                    return result2;
                }
                return arrayMap(result2, function (group) {
                    return apply2(iteratee2, undefined$1, group);
                });
            }
            var without = baseRest2(function (array, values2) {
                return isArrayLikeObject2(array)
                    ? baseDifference(array, values2)
                    : [];
            });
            var xor = baseRest2(function (arrays) {
                return baseXor(arrayFilter2(arrays, isArrayLikeObject2));
            });
            var xorBy = baseRest2(function (arrays) {
                var iteratee2 = last(arrays);
                if (isArrayLikeObject2(iteratee2)) {
                    iteratee2 = undefined$1;
                }
                return baseXor(
                    arrayFilter2(arrays, isArrayLikeObject2),
                    getIteratee(iteratee2, 2)
                );
            });
            var xorWith = baseRest2(function (arrays) {
                var comparator = last(arrays);
                comparator =
                    typeof comparator == "function" ? comparator : undefined$1;
                return baseXor(
                    arrayFilter2(arrays, isArrayLikeObject2),
                    undefined$1,
                    comparator
                );
            });
            var zip = baseRest2(unzip);
            function zipObject(props2, values2) {
                return baseZipObject(props2 || [], values2 || [], assignValue2);
            }
            function zipObjectDeep(props2, values2) {
                return baseZipObject(props2 || [], values2 || [], baseSet);
            }
            var zipWith = baseRest2(function (arrays) {
                var length = arrays.length,
                    iteratee2 = length > 1 ? arrays[length - 1] : undefined$1;
                iteratee2 =
                    typeof iteratee2 == "function"
                        ? (arrays.pop(), iteratee2)
                        : undefined$1;
                return unzipWith(arrays, iteratee2);
            });
            function chain(value) {
                var result2 = lodash2(value);
                result2.__chain__ = true;
                return result2;
            }
            function tap(value, interceptor2) {
                interceptor2(value);
                return value;
            }
            function thru(value, interceptor2) {
                return interceptor2(value);
            }
            var wrapperAt = flatRest(function (paths) {
                var length = paths.length,
                    start2 = length ? paths[0] : 0,
                    value = this.__wrapped__,
                    interceptor2 = function (object) {
                        return baseAt(object, paths);
                    };
                if (
                    length > 1 ||
                    this.__actions__.length ||
                    !(value instanceof LazyWrapper) ||
                    !isIndex2(start2)
                ) {
                    return this.thru(interceptor2);
                }
                value = value.slice(start2, +start2 + (length ? 1 : 0));
                value.__actions__.push({
                    func: thru,
                    args: [interceptor2],
                    thisArg: undefined$1,
                });
                return new LodashWrapper(value, this.__chain__).thru(function (
                    array
                ) {
                    if (length && !array.length) {
                        array.push(undefined$1);
                    }
                    return array;
                });
            });
            function wrapperChain() {
                return chain(this);
            }
            function wrapperCommit() {
                return new LodashWrapper(this.value(), this.__chain__);
            }
            function wrapperNext() {
                if (this.__values__ === undefined$1) {
                    this.__values__ = toArray2(this.value());
                }
                var done = this.__index__ >= this.__values__.length,
                    value = done
                        ? undefined$1
                        : this.__values__[this.__index__++];
                return { done: done, value: value };
            }
            function wrapperToIterator() {
                return this;
            }
            function wrapperPlant(value) {
                var result2,
                    parent2 = this;
                while (parent2 instanceof baseLodash) {
                    var clone3 = wrapperClone(parent2);
                    clone3.__index__ = 0;
                    clone3.__values__ = undefined$1;
                    if (result2) {
                        previous.__wrapped__ = clone3;
                    } else {
                        result2 = clone3;
                    }
                    var previous = clone3;
                    parent2 = parent2.__wrapped__;
                }
                previous.__wrapped__ = value;
                return result2;
            }
            function wrapperReverse() {
                var value = this.__wrapped__;
                if (value instanceof LazyWrapper) {
                    var wrapped = value;
                    if (this.__actions__.length) {
                        wrapped = new LazyWrapper(this);
                    }
                    wrapped = wrapped.reverse();
                    wrapped.__actions__.push({
                        func: thru,
                        args: [reverse],
                        thisArg: undefined$1,
                    });
                    return new LodashWrapper(wrapped, this.__chain__);
                }
                return this.thru(reverse);
            }
            function wrapperValue() {
                return baseWrapperValue(this.__wrapped__, this.__actions__);
            }
            var countBy = createAggregator(function (result2, value, key) {
                if (hasOwnProperty2.call(result2, key)) {
                    ++result2[key];
                } else {
                    baseAssignValue2(result2, key, 1);
                }
            });
            function every(collection, predicate, guard) {
                var func = isArray2(collection) ? arrayEvery : baseEvery;
                if (guard && isIterateeCall2(collection, predicate, guard)) {
                    predicate = undefined$1;
                }
                return func(collection, getIteratee(predicate, 3));
            }
            function filter(collection, predicate) {
                var func = isArray2(collection) ? arrayFilter2 : baseFilter;
                return func(collection, getIteratee(predicate, 3));
            }
            var find2 = createFind(findIndex2);
            var findLast = createFind(findLastIndex);
            function flatMap(collection, iteratee2) {
                return baseFlatten(map2(collection, iteratee2), 1);
            }
            function flatMapDeep(collection, iteratee2) {
                return baseFlatten(map2(collection, iteratee2), INFINITY);
            }
            function flatMapDepth(collection, iteratee2, depth) {
                depth = depth === undefined$1 ? 1 : toInteger(depth);
                return baseFlatten(map2(collection, iteratee2), depth);
            }
            function forEach3(collection, iteratee2) {
                var func = isArray2(collection) ? arrayEach : baseEach;
                return func(collection, getIteratee(iteratee2, 3));
            }
            function forEachRight(collection, iteratee2) {
                var func = isArray2(collection)
                    ? arrayEachRight
                    : baseEachRight;
                return func(collection, getIteratee(iteratee2, 3));
            }
            var groupBy = createAggregator(function (result2, value, key) {
                if (hasOwnProperty2.call(result2, key)) {
                    result2[key].push(value);
                } else {
                    baseAssignValue2(result2, key, [value]);
                }
            });
            function includes(collection, value, fromIndex, guard) {
                collection = isArrayLike2(collection)
                    ? collection
                    : values(collection);
                fromIndex = fromIndex && !guard ? toInteger(fromIndex) : 0;
                var length = collection.length;
                if (fromIndex < 0) {
                    fromIndex = nativeMax2(length + fromIndex, 0);
                }
                return isString2(collection)
                    ? fromIndex <= length &&
                          collection.indexOf(value, fromIndex) > -1
                    : !!length &&
                          baseIndexOf(collection, value, fromIndex) > -1;
            }
            var invokeMap = baseRest2(function (collection, path, args) {
                var index2 = -1,
                    isFunc = typeof path == "function",
                    result2 = isArrayLike2(collection)
                        ? Array2(collection.length)
                        : [];
                baseEach(collection, function (value) {
                    result2[++index2] = isFunc
                        ? apply2(path, value, args)
                        : baseInvoke(value, path, args);
                });
                return result2;
            });
            var keyBy = createAggregator(function (result2, value, key) {
                baseAssignValue2(result2, key, value);
            });
            function map2(collection, iteratee2) {
                var func = isArray2(collection) ? arrayMap : baseMap;
                return func(collection, getIteratee(iteratee2, 3));
            }
            function orderBy(collection, iteratees, orders, guard) {
                if (collection == null) {
                    return [];
                }
                if (!isArray2(iteratees)) {
                    iteratees = iteratees == null ? [] : [iteratees];
                }
                orders = guard ? undefined$1 : orders;
                if (!isArray2(orders)) {
                    orders = orders == null ? [] : [orders];
                }
                return baseOrderBy(collection, iteratees, orders);
            }
            var partition = createAggregator(
                function (result2, value, key) {
                    result2[key ? 0 : 1].push(value);
                },
                function () {
                    return [[], []];
                }
            );
            function reduce(collection, iteratee2, accumulator) {
                var func = isArray2(collection) ? arrayReduce : baseReduce,
                    initAccum = arguments.length < 3;
                return func(
                    collection,
                    getIteratee(iteratee2, 4),
                    accumulator,
                    initAccum,
                    baseEach
                );
            }
            function reduceRight(collection, iteratee2, accumulator) {
                var func = isArray2(collection) ? arrayReduceRight : baseReduce,
                    initAccum = arguments.length < 3;
                return func(
                    collection,
                    getIteratee(iteratee2, 4),
                    accumulator,
                    initAccum,
                    baseEachRight
                );
            }
            function reject(collection, predicate) {
                var func = isArray2(collection) ? arrayFilter2 : baseFilter;
                return func(collection, negate(getIteratee(predicate, 3)));
            }
            function sample(collection) {
                var func = isArray2(collection) ? arraySample : baseSample;
                return func(collection);
            }
            function sampleSize(collection, n, guard) {
                if (
                    guard
                        ? isIterateeCall2(collection, n, guard)
                        : n === undefined$1
                ) {
                    n = 1;
                } else {
                    n = toInteger(n);
                }
                var func = isArray2(collection)
                    ? arraySampleSize
                    : baseSampleSize;
                return func(collection, n);
            }
            function shuffle(collection) {
                var func = isArray2(collection) ? arrayShuffle : baseShuffle;
                return func(collection);
            }
            function size2(collection) {
                if (collection == null) {
                    return 0;
                }
                if (isArrayLike2(collection)) {
                    return isString2(collection)
                        ? stringSize(collection)
                        : collection.length;
                }
                var tag = getTag2(collection);
                if (tag == mapTag2 || tag == setTag2) {
                    return collection.size;
                }
                return baseKeys2(collection).length;
            }
            function some(collection, predicate, guard) {
                var func = isArray2(collection) ? arraySome2 : baseSome;
                if (guard && isIterateeCall2(collection, predicate, guard)) {
                    predicate = undefined$1;
                }
                return func(collection, getIteratee(predicate, 3));
            }
            var sortBy = baseRest2(function (collection, iteratees) {
                if (collection == null) {
                    return [];
                }
                var length = iteratees.length;
                if (
                    length > 1 &&
                    isIterateeCall2(collection, iteratees[0], iteratees[1])
                ) {
                    iteratees = [];
                } else if (
                    length > 2 &&
                    isIterateeCall2(iteratees[0], iteratees[1], iteratees[2])
                ) {
                    iteratees = [iteratees[0]];
                }
                return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
            });
            var now =
                ctxNow ||
                function () {
                    return root2.Date.now();
                };
            function after(n, func) {
                if (typeof func != "function") {
                    throw new TypeError2(FUNC_ERROR_TEXT);
                }
                n = toInteger(n);
                return function () {
                    if (--n < 1) {
                        return func.apply(this, arguments);
                    }
                };
            }
            function ary(func, n, guard) {
                n = guard ? undefined$1 : n;
                n = func && n == null ? func.length : n;
                return createWrap(
                    func,
                    WRAP_ARY_FLAG,
                    undefined$1,
                    undefined$1,
                    undefined$1,
                    undefined$1,
                    n
                );
            }
            function before(n, func) {
                var result2;
                if (typeof func != "function") {
                    throw new TypeError2(FUNC_ERROR_TEXT);
                }
                n = toInteger(n);
                return function () {
                    if (--n > 0) {
                        result2 = func.apply(this, arguments);
                    }
                    if (n <= 1) {
                        func = undefined$1;
                    }
                    return result2;
                };
            }
            var bind5 = baseRest2(function (func, thisArg, partials) {
                var bitmask = WRAP_BIND_FLAG;
                if (partials.length) {
                    var holders = replaceHolders(partials, getHolder(bind5));
                    bitmask |= WRAP_PARTIAL_FLAG;
                }
                return createWrap(func, bitmask, thisArg, partials, holders);
            });
            var bindKey = baseRest2(function (object, key, partials) {
                var bitmask = WRAP_BIND_FLAG | WRAP_BIND_KEY_FLAG;
                if (partials.length) {
                    var holders = replaceHolders(partials, getHolder(bindKey));
                    bitmask |= WRAP_PARTIAL_FLAG;
                }
                return createWrap(key, bitmask, object, partials, holders);
            });
            function curry(func, arity, guard) {
                arity = guard ? undefined$1 : arity;
                var result2 = createWrap(
                    func,
                    WRAP_CURRY_FLAG,
                    undefined$1,
                    undefined$1,
                    undefined$1,
                    undefined$1,
                    undefined$1,
                    arity
                );
                result2.placeholder = curry.placeholder;
                return result2;
            }
            function curryRight(func, arity, guard) {
                arity = guard ? undefined$1 : arity;
                var result2 = createWrap(
                    func,
                    WRAP_CURRY_RIGHT_FLAG,
                    undefined$1,
                    undefined$1,
                    undefined$1,
                    undefined$1,
                    undefined$1,
                    arity
                );
                result2.placeholder = curryRight.placeholder;
                return result2;
            }
            function debounce2(func, wait, options) {
                var lastArgs,
                    lastThis,
                    maxWait,
                    result2,
                    timerId,
                    lastCallTime,
                    lastInvokeTime = 0,
                    leading = false,
                    maxing = false,
                    trailing = true;
                if (typeof func != "function") {
                    throw new TypeError2(FUNC_ERROR_TEXT);
                }
                wait = toNumber2(wait) || 0;
                if (isObject2(options)) {
                    leading = !!options.leading;
                    maxing = "maxWait" in options;
                    maxWait = maxing
                        ? nativeMax2(toNumber2(options.maxWait) || 0, wait)
                        : maxWait;
                    trailing =
                        "trailing" in options ? !!options.trailing : trailing;
                }
                function invokeFunc(time) {
                    var args = lastArgs,
                        thisArg = lastThis;
                    lastArgs = lastThis = undefined$1;
                    lastInvokeTime = time;
                    result2 = func.apply(thisArg, args);
                    return result2;
                }
                function leadingEdge(time) {
                    lastInvokeTime = time;
                    timerId = setTimeout2(timerExpired, wait);
                    return leading ? invokeFunc(time) : result2;
                }
                function remainingWait(time) {
                    var timeSinceLastCall = time - lastCallTime,
                        timeSinceLastInvoke = time - lastInvokeTime,
                        timeWaiting = wait - timeSinceLastCall;
                    return maxing
                        ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke)
                        : timeWaiting;
                }
                function shouldInvoke(time) {
                    var timeSinceLastCall = time - lastCallTime,
                        timeSinceLastInvoke = time - lastInvokeTime;
                    return (
                        lastCallTime === undefined$1 ||
                        timeSinceLastCall >= wait ||
                        timeSinceLastCall < 0 ||
                        (maxing && timeSinceLastInvoke >= maxWait)
                    );
                }
                function timerExpired() {
                    var time = now();
                    if (shouldInvoke(time)) {
                        return trailingEdge(time);
                    }
                    timerId = setTimeout2(timerExpired, remainingWait(time));
                }
                function trailingEdge(time) {
                    timerId = undefined$1;
                    if (trailing && lastArgs) {
                        return invokeFunc(time);
                    }
                    lastArgs = lastThis = undefined$1;
                    return result2;
                }
                function cancel() {
                    if (timerId !== undefined$1) {
                        clearTimeout2(timerId);
                    }
                    lastInvokeTime = 0;
                    lastArgs = lastCallTime = lastThis = timerId = undefined$1;
                }
                function flush() {
                    return timerId === undefined$1
                        ? result2
                        : trailingEdge(now());
                }
                function debounced() {
                    var time = now(),
                        isInvoking = shouldInvoke(time);
                    lastArgs = arguments;
                    lastThis = this;
                    lastCallTime = time;
                    if (isInvoking) {
                        if (timerId === undefined$1) {
                            return leadingEdge(lastCallTime);
                        }
                        if (maxing) {
                            clearTimeout2(timerId);
                            timerId = setTimeout2(timerExpired, wait);
                            return invokeFunc(lastCallTime);
                        }
                    }
                    if (timerId === undefined$1) {
                        timerId = setTimeout2(timerExpired, wait);
                    }
                    return result2;
                }
                debounced.cancel = cancel;
                debounced.flush = flush;
                return debounced;
            }
            var defer = baseRest2(function (func, args) {
                return baseDelay(func, 1, args);
            });
            var delay = baseRest2(function (func, wait, args) {
                return baseDelay(func, toNumber2(wait) || 0, args);
            });
            function flip2(func) {
                return createWrap(func, WRAP_FLIP_FLAG);
            }
            function memoize(func, resolver) {
                if (
                    typeof func != "function" ||
                    (resolver != null && typeof resolver != "function")
                ) {
                    throw new TypeError2(FUNC_ERROR_TEXT);
                }
                var memoized = function () {
                    var args = arguments,
                        key = resolver ? resolver.apply(this, args) : args[0],
                        cache = memoized.cache;
                    if (cache.has(key)) {
                        return cache.get(key);
                    }
                    var result2 = func.apply(this, args);
                    memoized.cache = cache.set(key, result2) || cache;
                    return result2;
                };
                memoized.cache = new (memoize.Cache || MapCache2)();
                return memoized;
            }
            memoize.Cache = MapCache2;
            function negate(predicate) {
                if (typeof predicate != "function") {
                    throw new TypeError2(FUNC_ERROR_TEXT);
                }
                return function () {
                    var args = arguments;
                    switch (args.length) {
                        case 0:
                            return !predicate.call(this);
                        case 1:
                            return !predicate.call(this, args[0]);
                        case 2:
                            return !predicate.call(this, args[0], args[1]);
                        case 3:
                            return !predicate.call(
                                this,
                                args[0],
                                args[1],
                                args[2]
                            );
                    }
                    return !predicate.apply(this, args);
                };
            }
            function once2(func) {
                return before(2, func);
            }
            var overArgs = castRest(function (func, transforms2) {
                transforms2 =
                    transforms2.length == 1 && isArray2(transforms2[0])
                        ? arrayMap(transforms2[0], baseUnary2(getIteratee()))
                        : arrayMap(
                              baseFlatten(transforms2, 1),
                              baseUnary2(getIteratee())
                          );
                var funcsLength = transforms2.length;
                return baseRest2(function (args) {
                    var index2 = -1,
                        length = nativeMin(args.length, funcsLength);
                    while (++index2 < length) {
                        args[index2] = transforms2[index2].call(
                            this,
                            args[index2]
                        );
                    }
                    return apply2(func, this, args);
                });
            });
            var partial = baseRest2(function (func, partials) {
                var holders = replaceHolders(partials, getHolder(partial));
                return createWrap(
                    func,
                    WRAP_PARTIAL_FLAG,
                    undefined$1,
                    partials,
                    holders
                );
            });
            var partialRight = baseRest2(function (func, partials) {
                var holders = replaceHolders(partials, getHolder(partialRight));
                return createWrap(
                    func,
                    WRAP_PARTIAL_RIGHT_FLAG,
                    undefined$1,
                    partials,
                    holders
                );
            });
            var rearg = flatRest(function (func, indexes) {
                return createWrap(
                    func,
                    WRAP_REARG_FLAG,
                    undefined$1,
                    undefined$1,
                    undefined$1,
                    indexes
                );
            });
            function rest(func, start2) {
                if (typeof func != "function") {
                    throw new TypeError2(FUNC_ERROR_TEXT);
                }
                start2 = start2 === undefined$1 ? start2 : toInteger(start2);
                return baseRest2(func, start2);
            }
            function spread2(func, start2) {
                if (typeof func != "function") {
                    throw new TypeError2(FUNC_ERROR_TEXT);
                }
                start2 = start2 == null ? 0 : nativeMax2(toInteger(start2), 0);
                return baseRest2(function (args) {
                    var array = args[start2],
                        otherArgs = castSlice(args, 0, start2);
                    if (array) {
                        arrayPush2(otherArgs, array);
                    }
                    return apply2(func, this, otherArgs);
                });
            }
            function throttle2(func, wait, options) {
                var leading = true,
                    trailing = true;
                if (typeof func != "function") {
                    throw new TypeError2(FUNC_ERROR_TEXT);
                }
                if (isObject2(options)) {
                    leading =
                        "leading" in options ? !!options.leading : leading;
                    trailing =
                        "trailing" in options ? !!options.trailing : trailing;
                }
                return debounce2(func, wait, {
                    leading: leading,
                    maxWait: wait,
                    trailing: trailing,
                });
            }
            function unary(func) {
                return ary(func, 1);
            }
            function wrap(value, wrapper) {
                return partial(castFunction(wrapper), value);
            }
            function castArray() {
                if (!arguments.length) {
                    return [];
                }
                var value = arguments[0];
                return isArray2(value) ? value : [value];
            }
            function clone2(value) {
                return baseClone(value, CLONE_SYMBOLS_FLAG);
            }
            function cloneWith(value, customizer) {
                customizer =
                    typeof customizer == "function" ? customizer : undefined$1;
                return baseClone(value, CLONE_SYMBOLS_FLAG, customizer);
            }
            function cloneDeep(value) {
                return baseClone(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
            }
            function cloneDeepWith(value, customizer) {
                customizer =
                    typeof customizer == "function" ? customizer : undefined$1;
                return baseClone(
                    value,
                    CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG,
                    customizer
                );
            }
            function conformsTo(object, source) {
                return (
                    source == null ||
                    baseConformsTo(object, source, keys2(source))
                );
            }
            function eq2(value, other) {
                return value === other || (value !== value && other !== other);
            }
            var gt = createRelationalOperation(baseGt);
            var gte = createRelationalOperation(function (value, other) {
                return value >= other;
            });
            var isArguments2 = baseIsArguments2(
                (function () {
                    return arguments;
                })()
            )
                ? baseIsArguments2
                : function (value) {
                      return (
                          isObjectLike2(value) &&
                          hasOwnProperty2.call(value, "callee") &&
                          !propertyIsEnumerable2.call(value, "callee")
                      );
                  };
            var isArray2 = Array2.isArray;
            var isArrayBuffer2 = nodeIsArrayBuffer
                ? baseUnary2(nodeIsArrayBuffer)
                : baseIsArrayBuffer;
            function isArrayLike2(value) {
                return (
                    value != null &&
                    isLength2(value.length) &&
                    !isFunction2(value)
                );
            }
            function isArrayLikeObject2(value) {
                return isObjectLike2(value) && isArrayLike2(value);
            }
            function isBoolean2(value) {
                return (
                    value === true ||
                    value === false ||
                    (isObjectLike2(value) && baseGetTag2(value) == boolTag2)
                );
            }
            var isBuffer2 = nativeIsBuffer || stubFalse2;
            var isDate2 = nodeIsDate ? baseUnary2(nodeIsDate) : baseIsDate;
            function isElement(value) {
                return (
                    isObjectLike2(value) &&
                    value.nodeType === 1 &&
                    !isPlainObject2(value)
                );
            }
            function isEmpty2(value) {
                if (value == null) {
                    return true;
                }
                if (
                    isArrayLike2(value) &&
                    (isArray2(value) ||
                        typeof value == "string" ||
                        typeof value.splice == "function" ||
                        isBuffer2(value) ||
                        isTypedArray2(value) ||
                        isArguments2(value))
                ) {
                    return !value.length;
                }
                var tag = getTag2(value);
                if (tag == mapTag2 || tag == setTag2) {
                    return !value.size;
                }
                if (isPrototype2(value)) {
                    return !baseKeys2(value).length;
                }
                for (var key in value) {
                    if (hasOwnProperty2.call(value, key)) {
                        return false;
                    }
                }
                return true;
            }
            function isEqual2(value, other) {
                return baseIsEqual2(value, other);
            }
            function isEqualWith(value, other, customizer) {
                customizer =
                    typeof customizer == "function" ? customizer : undefined$1;
                var result2 = customizer
                    ? customizer(value, other)
                    : undefined$1;
                return result2 === undefined$1
                    ? baseIsEqual2(value, other, undefined$1, customizer)
                    : !!result2;
            }
            function isError(value) {
                if (!isObjectLike2(value)) {
                    return false;
                }
                var tag = baseGetTag2(value);
                return (
                    tag == errorTag2 ||
                    tag == domExcTag ||
                    (typeof value.message == "string" &&
                        typeof value.name == "string" &&
                        !isPlainObject2(value))
                );
            }
            function isFinite2(value) {
                return typeof value == "number" && nativeIsFinite(value);
            }
            function isFunction2(value) {
                if (!isObject2(value)) {
                    return false;
                }
                var tag = baseGetTag2(value);
                return (
                    tag == funcTag2 ||
                    tag == genTag2 ||
                    tag == asyncTag2 ||
                    tag == proxyTag2
                );
            }
            function isInteger(value) {
                return typeof value == "number" && value == toInteger(value);
            }
            function isLength2(value) {
                return (
                    typeof value == "number" &&
                    value > -1 &&
                    value % 1 == 0 &&
                    value <= MAX_SAFE_INTEGER2
                );
            }
            function isObject2(value) {
                var type = typeof value;
                return (
                    value != null && (type == "object" || type == "function")
                );
            }
            function isObjectLike2(value) {
                return value != null && typeof value == "object";
            }
            var isMap2 = nodeIsMap ? baseUnary2(nodeIsMap) : baseIsMap;
            function isMatch(object, source) {
                return (
                    object === source ||
                    baseIsMatch(object, source, getMatchData(source))
                );
            }
            function isMatchWith(object, source, customizer) {
                customizer =
                    typeof customizer == "function" ? customizer : undefined$1;
                return baseIsMatch(
                    object,
                    source,
                    getMatchData(source),
                    customizer
                );
            }
            function isNaN2(value) {
                return isNumber2(value) && value != +value;
            }
            function isNative2(value) {
                if (isMaskable(value)) {
                    throw new Error2(CORE_ERROR_TEXT);
                }
                return baseIsNative2(value);
            }
            function isNull2(value) {
                return value === null;
            }
            function isNil(value) {
                return value == null;
            }
            function isNumber2(value) {
                return (
                    typeof value == "number" ||
                    (isObjectLike2(value) && baseGetTag2(value) == numberTag2)
                );
            }
            function isPlainObject2(value) {
                if (!isObjectLike2(value) || baseGetTag2(value) != objectTag2) {
                    return false;
                }
                var proto = getPrototype2(value);
                if (proto === null) {
                    return true;
                }
                var Ctor =
                    hasOwnProperty2.call(proto, "constructor") &&
                    proto.constructor;
                return (
                    typeof Ctor == "function" &&
                    Ctor instanceof Ctor &&
                    funcToString2.call(Ctor) == objectCtorString2
                );
            }
            var isRegExp2 = nodeIsRegExp
                ? baseUnary2(nodeIsRegExp)
                : baseIsRegExp;
            function isSafeInteger(value) {
                return (
                    isInteger(value) &&
                    value >= -MAX_SAFE_INTEGER2 &&
                    value <= MAX_SAFE_INTEGER2
                );
            }
            var isSet = nodeIsSet ? baseUnary2(nodeIsSet) : baseIsSet;
            function isString2(value) {
                return (
                    typeof value == "string" ||
                    (!isArray2(value) &&
                        isObjectLike2(value) &&
                        baseGetTag2(value) == stringTag2)
                );
            }
            function isSymbol2(value) {
                return (
                    typeof value == "symbol" ||
                    (isObjectLike2(value) && baseGetTag2(value) == symbolTag2)
                );
            }
            var isTypedArray2 = nodeIsTypedArray2
                ? baseUnary2(nodeIsTypedArray2)
                : baseIsTypedArray2;
            function isUndefined2(value) {
                return value === undefined$1;
            }
            function isWeakMap(value) {
                return isObjectLike2(value) && getTag2(value) == weakMapTag2;
            }
            function isWeakSet(value) {
                return isObjectLike2(value) && baseGetTag2(value) == weakSetTag;
            }
            var lt = createRelationalOperation(baseLt);
            var lte = createRelationalOperation(function (value, other) {
                return value <= other;
            });
            function toArray2(value) {
                if (!value) {
                    return [];
                }
                if (isArrayLike2(value)) {
                    return isString2(value)
                        ? stringToArray(value)
                        : copyArray2(value);
                }
                if (symIterator && value[symIterator]) {
                    return iteratorToArray(value[symIterator]());
                }
                var tag = getTag2(value),
                    func =
                        tag == mapTag2
                            ? mapToArray2
                            : tag == setTag2
                            ? setToArray2
                            : values;
                return func(value);
            }
            function toFinite(value) {
                if (!value) {
                    return value === 0 ? value : 0;
                }
                value = toNumber2(value);
                if (value === INFINITY || value === -INFINITY) {
                    var sign = value < 0 ? -1 : 1;
                    return sign * MAX_INTEGER;
                }
                return value === value ? value : 0;
            }
            function toInteger(value) {
                var result2 = toFinite(value),
                    remainder = result2 % 1;
                return result2 === result2
                    ? remainder
                        ? result2 - remainder
                        : result2
                    : 0;
            }
            function toLength(value) {
                return value
                    ? baseClamp(toInteger(value), 0, MAX_ARRAY_LENGTH)
                    : 0;
            }
            function toNumber2(value) {
                if (typeof value == "number") {
                    return value;
                }
                if (isSymbol2(value)) {
                    return NAN;
                }
                if (isObject2(value)) {
                    var other =
                        typeof value.valueOf == "function"
                            ? value.valueOf()
                            : value;
                    value = isObject2(other) ? other + "" : other;
                }
                if (typeof value != "string") {
                    return value === 0 ? value : +value;
                }
                value = baseTrim(value);
                var isBinary = reIsBinary.test(value);
                return isBinary || reIsOctal.test(value)
                    ? freeParseInt(value.slice(2), isBinary ? 2 : 8)
                    : reIsBadHex.test(value)
                    ? NAN
                    : +value;
            }
            function toPlainObject2(value) {
                return copyObject2(value, keysIn2(value));
            }
            function toSafeInteger(value) {
                return value
                    ? baseClamp(
                          toInteger(value),
                          -MAX_SAFE_INTEGER2,
                          MAX_SAFE_INTEGER2
                      )
                    : value === 0
                    ? value
                    : 0;
            }
            function toString2(value) {
                return value == null ? "" : baseToString(value);
            }
            var assign = createAssigner2(function (object, source) {
                if (isPrototype2(source) || isArrayLike2(source)) {
                    copyObject2(source, keys2(source), object);
                    return;
                }
                for (var key in source) {
                    if (hasOwnProperty2.call(source, key)) {
                        assignValue2(object, key, source[key]);
                    }
                }
            });
            var assignIn = createAssigner2(function (object, source) {
                copyObject2(source, keysIn2(source), object);
            });
            var assignInWith = createAssigner2(function (
                object,
                source,
                srcIndex,
                customizer
            ) {
                copyObject2(source, keysIn2(source), object, customizer);
            });
            var assignWith = createAssigner2(function (
                object,
                source,
                srcIndex,
                customizer
            ) {
                copyObject2(source, keys2(source), object, customizer);
            });
            var at = flatRest(baseAt);
            function create2(prototype2, properties) {
                var result2 = baseCreate2(prototype2);
                return properties == null
                    ? result2
                    : baseAssign(result2, properties);
            }
            var defaults2 = baseRest2(function (object, sources) {
                object = Object2(object);
                var index2 = -1;
                var length = sources.length;
                var guard = length > 2 ? sources[2] : undefined$1;
                if (guard && isIterateeCall2(sources[0], sources[1], guard)) {
                    length = 1;
                }
                while (++index2 < length) {
                    var source = sources[index2];
                    var props2 = keysIn2(source);
                    var propsIndex = -1;
                    var propsLength = props2.length;
                    while (++propsIndex < propsLength) {
                        var key = props2[propsIndex];
                        var value = object[key];
                        if (
                            value === undefined$1 ||
                            (eq2(value, objectProto2[key]) &&
                                !hasOwnProperty2.call(object, key))
                        ) {
                            object[key] = source[key];
                        }
                    }
                }
                return object;
            });
            var defaultsDeep = baseRest2(function (args) {
                args.push(undefined$1, customDefaultsMerge);
                return apply2(mergeWith, undefined$1, args);
            });
            function findKey(object, predicate) {
                return baseFindKey(
                    object,
                    getIteratee(predicate, 3),
                    baseForOwn
                );
            }
            function findLastKey(object, predicate) {
                return baseFindKey(
                    object,
                    getIteratee(predicate, 3),
                    baseForOwnRight
                );
            }
            function forIn(object, iteratee2) {
                return object == null
                    ? object
                    : baseFor2(object, getIteratee(iteratee2, 3), keysIn2);
            }
            function forInRight(object, iteratee2) {
                return object == null
                    ? object
                    : baseForRight(object, getIteratee(iteratee2, 3), keysIn2);
            }
            function forOwn(object, iteratee2) {
                return object && baseForOwn(object, getIteratee(iteratee2, 3));
            }
            function forOwnRight(object, iteratee2) {
                return (
                    object && baseForOwnRight(object, getIteratee(iteratee2, 3))
                );
            }
            function functions(object) {
                return object == null
                    ? []
                    : baseFunctions(object, keys2(object));
            }
            function functionsIn(object) {
                return object == null
                    ? []
                    : baseFunctions(object, keysIn2(object));
            }
            function get3(object, path, defaultValue) {
                var result2 =
                    object == null ? undefined$1 : baseGet(object, path);
                return result2 === undefined$1 ? defaultValue : result2;
            }
            function has2(object, path) {
                return object != null && hasPath(object, path, baseHas);
            }
            function hasIn(object, path) {
                return object != null && hasPath(object, path, baseHasIn);
            }
            var invert = createInverter(function (result2, value, key) {
                if (value != null && typeof value.toString != "function") {
                    value = nativeObjectToString2.call(value);
                }
                result2[value] = key;
            }, constant2(identity2));
            var invertBy = createInverter(function (result2, value, key) {
                if (value != null && typeof value.toString != "function") {
                    value = nativeObjectToString2.call(value);
                }
                if (hasOwnProperty2.call(result2, value)) {
                    result2[value].push(key);
                } else {
                    result2[value] = [key];
                }
            }, getIteratee);
            var invoke = baseRest2(baseInvoke);
            function keys2(object) {
                return isArrayLike2(object)
                    ? arrayLikeKeys2(object)
                    : baseKeys2(object);
            }
            function keysIn2(object) {
                return isArrayLike2(object)
                    ? arrayLikeKeys2(object, true)
                    : baseKeysIn2(object);
            }
            function mapKeys(object, iteratee2) {
                var result2 = {};
                iteratee2 = getIteratee(iteratee2, 3);
                baseForOwn(object, function (value, key, object2) {
                    baseAssignValue2(
                        result2,
                        iteratee2(value, key, object2),
                        value
                    );
                });
                return result2;
            }
            function mapValues(object, iteratee2) {
                var result2 = {};
                iteratee2 = getIteratee(iteratee2, 3);
                baseForOwn(object, function (value, key, object2) {
                    baseAssignValue2(
                        result2,
                        key,
                        iteratee2(value, key, object2)
                    );
                });
                return result2;
            }
            var merge2 = createAssigner2(function (object, source, srcIndex) {
                baseMerge2(object, source, srcIndex);
            });
            var mergeWith = createAssigner2(function (
                object,
                source,
                srcIndex,
                customizer
            ) {
                baseMerge2(object, source, srcIndex, customizer);
            });
            var omit = flatRest(function (object, paths) {
                var result2 = {};
                if (object == null) {
                    return result2;
                }
                var isDeep = false;
                paths = arrayMap(paths, function (path) {
                    path = castPath(path, object);
                    isDeep || (isDeep = path.length > 1);
                    return path;
                });
                copyObject2(object, getAllKeysIn(object), result2);
                if (isDeep) {
                    result2 = baseClone(
                        result2,
                        CLONE_DEEP_FLAG | CLONE_FLAT_FLAG | CLONE_SYMBOLS_FLAG,
                        customOmitClone
                    );
                }
                var length = paths.length;
                while (length--) {
                    baseUnset(result2, paths[length]);
                }
                return result2;
            });
            function omitBy(object, predicate) {
                return pickBy(object, negate(getIteratee(predicate)));
            }
            var pick = flatRest(function (object, paths) {
                return object == null ? {} : basePick(object, paths);
            });
            function pickBy(object, predicate) {
                if (object == null) {
                    return {};
                }
                var props2 = arrayMap(getAllKeysIn(object), function (prop) {
                    return [prop];
                });
                predicate = getIteratee(predicate);
                return basePickBy(object, props2, function (value, path) {
                    return predicate(value, path[0]);
                });
            }
            function result(object, path, defaultValue) {
                path = castPath(path, object);
                var index2 = -1,
                    length = path.length;
                if (!length) {
                    length = 1;
                    object = undefined$1;
                }
                while (++index2 < length) {
                    var value =
                        object == null
                            ? undefined$1
                            : object[toKey(path[index2])];
                    if (value === undefined$1) {
                        index2 = length;
                        value = defaultValue;
                    }
                    object = isFunction2(value) ? value.call(object) : value;
                }
                return object;
            }
            function set3(object, path, value) {
                return object == null ? object : baseSet(object, path, value);
            }
            function setWith(object, path, value, customizer) {
                customizer =
                    typeof customizer == "function" ? customizer : undefined$1;
                return object == null
                    ? object
                    : baseSet(object, path, value, customizer);
            }
            var toPairs = createToPairs(keys2);
            var toPairsIn = createToPairs(keysIn2);
            function transform(object, iteratee2, accumulator) {
                var isArr = isArray2(object),
                    isArrLike =
                        isArr || isBuffer2(object) || isTypedArray2(object);
                iteratee2 = getIteratee(iteratee2, 4);
                if (accumulator == null) {
                    var Ctor = object && object.constructor;
                    if (isArrLike) {
                        accumulator = isArr ? new Ctor() : [];
                    } else if (isObject2(object)) {
                        accumulator = isFunction2(Ctor)
                            ? baseCreate2(getPrototype2(object))
                            : {};
                    } else {
                        accumulator = {};
                    }
                }
                (isArrLike ? arrayEach : baseForOwn)(
                    object,
                    function (value, index2, object2) {
                        return iteratee2(accumulator, value, index2, object2);
                    }
                );
                return accumulator;
            }
            function unset(object, path) {
                return object == null ? true : baseUnset(object, path);
            }
            function update3(object, path, updater) {
                return object == null
                    ? object
                    : baseUpdate(object, path, castFunction(updater));
            }
            function updateWith(object, path, updater, customizer) {
                customizer =
                    typeof customizer == "function" ? customizer : undefined$1;
                return object == null
                    ? object
                    : baseUpdate(
                          object,
                          path,
                          castFunction(updater),
                          customizer
                      );
            }
            function values(object) {
                return object == null ? [] : baseValues(object, keys2(object));
            }
            function valuesIn(object) {
                return object == null
                    ? []
                    : baseValues(object, keysIn2(object));
            }
            function clamp(number, lower, upper) {
                if (upper === undefined$1) {
                    upper = lower;
                    lower = undefined$1;
                }
                if (upper !== undefined$1) {
                    upper = toNumber2(upper);
                    upper = upper === upper ? upper : 0;
                }
                if (lower !== undefined$1) {
                    lower = toNumber2(lower);
                    lower = lower === lower ? lower : 0;
                }
                return baseClamp(toNumber2(number), lower, upper);
            }
            function inRange(number, start2, end) {
                start2 = toFinite(start2);
                if (end === undefined$1) {
                    end = start2;
                    start2 = 0;
                } else {
                    end = toFinite(end);
                }
                number = toNumber2(number);
                return baseInRange(number, start2, end);
            }
            function random(lower, upper, floating) {
                if (
                    floating &&
                    typeof floating != "boolean" &&
                    isIterateeCall2(lower, upper, floating)
                ) {
                    upper = floating = undefined$1;
                }
                if (floating === undefined$1) {
                    if (typeof upper == "boolean") {
                        floating = upper;
                        upper = undefined$1;
                    } else if (typeof lower == "boolean") {
                        floating = lower;
                        lower = undefined$1;
                    }
                }
                if (lower === undefined$1 && upper === undefined$1) {
                    lower = 0;
                    upper = 1;
                } else {
                    lower = toFinite(lower);
                    if (upper === undefined$1) {
                        upper = lower;
                        lower = 0;
                    } else {
                        upper = toFinite(upper);
                    }
                }
                if (lower > upper) {
                    var temp = lower;
                    lower = upper;
                    upper = temp;
                }
                if (floating || lower % 1 || upper % 1) {
                    var rand = nativeRandom();
                    return nativeMin(
                        lower +
                            rand *
                                (upper -
                                    lower +
                                    freeParseFloat(
                                        "1e-" + ((rand + "").length - 1)
                                    )),
                        upper
                    );
                }
                return baseRandom(lower, upper);
            }
            var camelCase3 = createCompounder(function (result2, word, index2) {
                word = word.toLowerCase();
                return result2 + (index2 ? capitalize2(word) : word);
            });
            function capitalize2(string) {
                return upperFirst(toString2(string).toLowerCase());
            }
            function deburr(string) {
                string = toString2(string);
                return (
                    string &&
                    string
                        .replace(reLatin, deburrLetter)
                        .replace(reComboMark, "")
                );
            }
            function endsWith2(string, target2, position) {
                string = toString2(string);
                target2 = baseToString(target2);
                var length = string.length;
                position =
                    position === undefined$1
                        ? length
                        : baseClamp(toInteger(position), 0, length);
                var end = position;
                position -= target2.length;
                return position >= 0 && string.slice(position, end) == target2;
            }
            function escape(string) {
                string = toString2(string);
                return string && reHasUnescapedHtml.test(string)
                    ? string.replace(reUnescapedHtml, escapeHtmlChar)
                    : string;
            }
            function escapeRegExp(string) {
                string = toString2(string);
                return string && reHasRegExpChar.test(string)
                    ? string.replace(reRegExpChar2, "\\$&")
                    : string;
            }
            var kebabCase3 = createCompounder(function (result2, word, index2) {
                return result2 + (index2 ? "-" : "") + word.toLowerCase();
            });
            var lowerCase = createCompounder(function (result2, word, index2) {
                return result2 + (index2 ? " " : "") + word.toLowerCase();
            });
            var lowerFirst = createCaseFirst("toLowerCase");
            function pad(string, length, chars) {
                string = toString2(string);
                length = toInteger(length);
                var strLength = length ? stringSize(string) : 0;
                if (!length || strLength >= length) {
                    return string;
                }
                var mid = (length - strLength) / 2;
                return (
                    createPadding(nativeFloor(mid), chars) +
                    string +
                    createPadding(nativeCeil(mid), chars)
                );
            }
            function padEnd(string, length, chars) {
                string = toString2(string);
                length = toInteger(length);
                var strLength = length ? stringSize(string) : 0;
                return length && strLength < length
                    ? string + createPadding(length - strLength, chars)
                    : string;
            }
            function padStart(string, length, chars) {
                string = toString2(string);
                length = toInteger(length);
                var strLength = length ? stringSize(string) : 0;
                return length && strLength < length
                    ? createPadding(length - strLength, chars) + string
                    : string;
            }
            function parseInt2(string, radix, guard) {
                if (guard || radix == null) {
                    radix = 0;
                } else if (radix) {
                    radix = +radix;
                }
                return nativeParseInt(
                    toString2(string).replace(reTrimStart, ""),
                    radix || 0
                );
            }
            function repeat(string, n, guard) {
                if (
                    guard
                        ? isIterateeCall2(string, n, guard)
                        : n === undefined$1
                ) {
                    n = 1;
                } else {
                    n = toInteger(n);
                }
                return baseRepeat(toString2(string), n);
            }
            function replace() {
                var args = arguments,
                    string = toString2(args[0]);
                return args.length < 3
                    ? string
                    : string.replace(args[1], args[2]);
            }
            var snakeCase = createCompounder(function (result2, word, index2) {
                return result2 + (index2 ? "_" : "") + word.toLowerCase();
            });
            function split(string, separator, limit2) {
                if (
                    limit2 &&
                    typeof limit2 != "number" &&
                    isIterateeCall2(string, separator, limit2)
                ) {
                    separator = limit2 = undefined$1;
                }
                limit2 =
                    limit2 === undefined$1 ? MAX_ARRAY_LENGTH : limit2 >>> 0;
                if (!limit2) {
                    return [];
                }
                string = toString2(string);
                if (
                    string &&
                    (typeof separator == "string" ||
                        (separator != null && !isRegExp2(separator)))
                ) {
                    separator = baseToString(separator);
                    if (!separator && hasUnicode(string)) {
                        return castSlice(stringToArray(string), 0, limit2);
                    }
                }
                return string.split(separator, limit2);
            }
            var startCase = createCompounder(function (result2, word, index2) {
                return result2 + (index2 ? " " : "") + upperFirst(word);
            });
            function startsWith(string, target2, position) {
                string = toString2(string);
                position =
                    position == null
                        ? 0
                        : baseClamp(toInteger(position), 0, string.length);
                target2 = baseToString(target2);
                return (
                    string.slice(position, position + target2.length) == target2
                );
            }
            function template(string, options, guard) {
                var settings = lodash2.templateSettings;
                if (guard && isIterateeCall2(string, options, guard)) {
                    options = undefined$1;
                }
                string = toString2(string);
                options = assignInWith(
                    {},
                    options,
                    settings,
                    customDefaultsAssignIn
                );
                var imports = assignInWith(
                        {},
                        options.imports,
                        settings.imports,
                        customDefaultsAssignIn
                    ),
                    importsKeys = keys2(imports),
                    importsValues = baseValues(imports, importsKeys);
                var isEscaping,
                    isEvaluating,
                    index2 = 0,
                    interpolate = options.interpolate || reNoMatch,
                    source = "__p += '";
                var reDelimiters = RegExp2(
                    (options.escape || reNoMatch).source +
                        "|" +
                        interpolate.source +
                        "|" +
                        (interpolate === reInterpolate
                            ? reEsTemplate
                            : reNoMatch
                        ).source +
                        "|" +
                        (options.evaluate || reNoMatch).source +
                        "|$",
                    "g"
                );
                var sourceURL =
                    "//# sourceURL=" +
                    (hasOwnProperty2.call(options, "sourceURL")
                        ? (options.sourceURL + "").replace(/\s/g, " ")
                        : "lodash.templateSources[" + ++templateCounter + "]") +
                    "\n";
                string.replace(
                    reDelimiters,
                    function (
                        match,
                        escapeValue,
                        interpolateValue,
                        esTemplateValue,
                        evaluateValue,
                        offset2
                    ) {
                        interpolateValue ||
                            (interpolateValue = esTemplateValue);
                        source += string
                            .slice(index2, offset2)
                            .replace(reUnescapedString, escapeStringChar);
                        if (escapeValue) {
                            isEscaping = true;
                            source += "' +\n__e(" + escapeValue + ") +\n'";
                        }
                        if (evaluateValue) {
                            isEvaluating = true;
                            source += "';\n" + evaluateValue + ";\n__p += '";
                        }
                        if (interpolateValue) {
                            source +=
                                "' +\n((__t = (" +
                                interpolateValue +
                                ")) == null ? '' : __t) +\n'";
                        }
                        index2 = offset2 + match.length;
                        return match;
                    }
                );
                source += "';\n";
                var variable =
                    hasOwnProperty2.call(options, "variable") &&
                    options.variable;
                if (!variable) {
                    source = "with (obj) {\n" + source + "\n}\n";
                } else if (reForbiddenIdentifierChars.test(variable)) {
                    throw new Error2(INVALID_TEMPL_VAR_ERROR_TEXT);
                }
                source = (
                    isEvaluating
                        ? source.replace(reEmptyStringLeading, "")
                        : source
                )
                    .replace(reEmptyStringMiddle, "$1")
                    .replace(reEmptyStringTrailing, "$1;");
                source =
                    "function(" +
                    (variable || "obj") +
                    ") {\n" +
                    (variable ? "" : "obj || (obj = {});\n") +
                    "var __t, __p = ''" +
                    (isEscaping ? ", __e = _.escape" : "") +
                    (isEvaluating
                        ? ", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n"
                        : ";\n") +
                    source +
                    "return __p\n}";
                var result2 = attempt(function () {
                    return Function2(
                        importsKeys,
                        sourceURL + "return " + source
                    ).apply(undefined$1, importsValues);
                });
                result2.source = source;
                if (isError(result2)) {
                    throw result2;
                }
                return result2;
            }
            function toLower(value) {
                return toString2(value).toLowerCase();
            }
            function toUpper(value) {
                return toString2(value).toUpperCase();
            }
            function trim2(string, chars, guard) {
                string = toString2(string);
                if (string && (guard || chars === undefined$1)) {
                    return baseTrim(string);
                }
                if (!string || !(chars = baseToString(chars))) {
                    return string;
                }
                var strSymbols = stringToArray(string),
                    chrSymbols = stringToArray(chars),
                    start2 = charsStartIndex(strSymbols, chrSymbols),
                    end = charsEndIndex(strSymbols, chrSymbols) + 1;
                return castSlice(strSymbols, start2, end).join("");
            }
            function trimEnd(string, chars, guard) {
                string = toString2(string);
                if (string && (guard || chars === undefined$1)) {
                    return string.slice(0, trimmedEndIndex(string) + 1);
                }
                if (!string || !(chars = baseToString(chars))) {
                    return string;
                }
                var strSymbols = stringToArray(string),
                    end = charsEndIndex(strSymbols, stringToArray(chars)) + 1;
                return castSlice(strSymbols, 0, end).join("");
            }
            function trimStart(string, chars, guard) {
                string = toString2(string);
                if (string && (guard || chars === undefined$1)) {
                    return string.replace(reTrimStart, "");
                }
                if (!string || !(chars = baseToString(chars))) {
                    return string;
                }
                var strSymbols = stringToArray(string),
                    start2 = charsStartIndex(strSymbols, stringToArray(chars));
                return castSlice(strSymbols, start2).join("");
            }
            function truncate(string, options) {
                var length = DEFAULT_TRUNC_LENGTH,
                    omission = DEFAULT_TRUNC_OMISSION;
                if (isObject2(options)) {
                    var separator =
                        "separator" in options ? options.separator : separator;
                    length =
                        "length" in options
                            ? toInteger(options.length)
                            : length;
                    omission =
                        "omission" in options
                            ? baseToString(options.omission)
                            : omission;
                }
                string = toString2(string);
                var strLength = string.length;
                if (hasUnicode(string)) {
                    var strSymbols = stringToArray(string);
                    strLength = strSymbols.length;
                }
                if (length >= strLength) {
                    return string;
                }
                var end = length - stringSize(omission);
                if (end < 1) {
                    return omission;
                }
                var result2 = strSymbols
                    ? castSlice(strSymbols, 0, end).join("")
                    : string.slice(0, end);
                if (separator === undefined$1) {
                    return result2 + omission;
                }
                if (strSymbols) {
                    end += result2.length - end;
                }
                if (isRegExp2(separator)) {
                    if (string.slice(end).search(separator)) {
                        var match,
                            substring = result2;
                        if (!separator.global) {
                            separator = RegExp2(
                                separator.source,
                                toString2(reFlags.exec(separator)) + "g"
                            );
                        }
                        separator.lastIndex = 0;
                        while ((match = separator.exec(substring))) {
                            var newEnd = match.index;
                        }
                        result2 = result2.slice(
                            0,
                            newEnd === undefined$1 ? end : newEnd
                        );
                    }
                } else if (
                    string.indexOf(baseToString(separator), end) != end
                ) {
                    var index2 = result2.lastIndexOf(separator);
                    if (index2 > -1) {
                        result2 = result2.slice(0, index2);
                    }
                }
                return result2 + omission;
            }
            function unescape2(string) {
                string = toString2(string);
                return string && reHasEscapedHtml.test(string)
                    ? string.replace(reEscapedHtml, unescapeHtmlChar)
                    : string;
            }
            var upperCase = createCompounder(function (result2, word, index2) {
                return result2 + (index2 ? " " : "") + word.toUpperCase();
            });
            var upperFirst = createCaseFirst("toUpperCase");
            function words(string, pattern, guard) {
                string = toString2(string);
                pattern = guard ? undefined$1 : pattern;
                if (pattern === undefined$1) {
                    return hasUnicodeWord(string)
                        ? unicodeWords(string)
                        : asciiWords(string);
                }
                return string.match(pattern) || [];
            }
            var attempt = baseRest2(function (func, args) {
                try {
                    return apply2(func, undefined$1, args);
                } catch (e) {
                    return isError(e) ? e : new Error2(e);
                }
            });
            var bindAll = flatRest(function (object, methodNames) {
                arrayEach(methodNames, function (key) {
                    key = toKey(key);
                    baseAssignValue2(object, key, bind5(object[key], object));
                });
                return object;
            });
            function cond(pairs) {
                var length = pairs == null ? 0 : pairs.length,
                    toIteratee = getIteratee();
                pairs = !length
                    ? []
                    : arrayMap(pairs, function (pair) {
                          if (typeof pair[1] != "function") {
                              throw new TypeError2(FUNC_ERROR_TEXT);
                          }
                          return [toIteratee(pair[0]), pair[1]];
                      });
                return baseRest2(function (args) {
                    var index2 = -1;
                    while (++index2 < length) {
                        var pair = pairs[index2];
                        if (apply2(pair[0], this, args)) {
                            return apply2(pair[1], this, args);
                        }
                    }
                });
            }
            function conforms(source) {
                return baseConforms(baseClone(source, CLONE_DEEP_FLAG));
            }
            function constant2(value) {
                return function () {
                    return value;
                };
            }
            function defaultTo(value, defaultValue) {
                return value == null || value !== value ? defaultValue : value;
            }
            var flow = createFlow();
            var flowRight = createFlow(true);
            function identity2(value) {
                return value;
            }
            function iteratee(func) {
                return baseIteratee(
                    typeof func == "function"
                        ? func
                        : baseClone(func, CLONE_DEEP_FLAG)
                );
            }
            function matches2(source) {
                return baseMatches(baseClone(source, CLONE_DEEP_FLAG));
            }
            function matchesProperty(path, srcValue) {
                return baseMatchesProperty(
                    path,
                    baseClone(srcValue, CLONE_DEEP_FLAG)
                );
            }
            var method = baseRest2(function (path, args) {
                return function (object) {
                    return baseInvoke(object, path, args);
                };
            });
            var methodOf = baseRest2(function (object, args) {
                return function (path) {
                    return baseInvoke(object, path, args);
                };
            });
            function mixin(object, source, options) {
                var props2 = keys2(source),
                    methodNames = baseFunctions(source, props2);
                if (
                    options == null &&
                    !(
                        isObject2(source) &&
                        (methodNames.length || !props2.length)
                    )
                ) {
                    options = source;
                    source = object;
                    object = this;
                    methodNames = baseFunctions(source, keys2(source));
                }
                var chain2 =
                        !(isObject2(options) && "chain" in options) ||
                        !!options.chain,
                    isFunc = isFunction2(object);
                arrayEach(methodNames, function (methodName) {
                    var func = source[methodName];
                    object[methodName] = func;
                    if (isFunc) {
                        object.prototype[methodName] = function () {
                            var chainAll = this.__chain__;
                            if (chain2 || chainAll) {
                                var result2 = object(this.__wrapped__),
                                    actions2 = (result2.__actions__ =
                                        copyArray2(this.__actions__));
                                actions2.push({
                                    func: func,
                                    args: arguments,
                                    thisArg: object,
                                });
                                result2.__chain__ = chainAll;
                                return result2;
                            }
                            return func.apply(
                                object,
                                arrayPush2([this.value()], arguments)
                            );
                        };
                    }
                });
                return object;
            }
            function noConflict() {
                if (root2._ === this) {
                    root2._ = oldDash;
                }
                return this;
            }
            function noop2() {}
            function nthArg(n) {
                n = toInteger(n);
                return baseRest2(function (args) {
                    return baseNth(args, n);
                });
            }
            var over = createOver(arrayMap);
            var overEvery = createOver(arrayEvery);
            var overSome = createOver(arraySome2);
            function property(path) {
                return isKey(path)
                    ? baseProperty(toKey(path))
                    : basePropertyDeep(path);
            }
            function propertyOf(object) {
                return function (path) {
                    return object == null ? undefined$1 : baseGet(object, path);
                };
            }
            var range = createRange();
            var rangeRight = createRange(true);
            function stubArray2() {
                return [];
            }
            function stubFalse2() {
                return false;
            }
            function stubObject() {
                return {};
            }
            function stubString() {
                return "";
            }
            function stubTrue() {
                return true;
            }
            function times(n, iteratee2) {
                n = toInteger(n);
                if (n < 1 || n > MAX_SAFE_INTEGER2) {
                    return [];
                }
                var index2 = MAX_ARRAY_LENGTH,
                    length = nativeMin(n, MAX_ARRAY_LENGTH);
                iteratee2 = getIteratee(iteratee2);
                n -= MAX_ARRAY_LENGTH;
                var result2 = baseTimes2(length, iteratee2);
                while (++index2 < n) {
                    iteratee2(index2);
                }
                return result2;
            }
            function toPath(value) {
                if (isArray2(value)) {
                    return arrayMap(value, toKey);
                }
                return isSymbol2(value)
                    ? [value]
                    : copyArray2(stringToPath(toString2(value)));
            }
            function uniqueId(prefix2) {
                var id = ++idCounter;
                return toString2(prefix2) + id;
            }
            var add2 = createMathOperation(function (augend, addend) {
                return augend + addend;
            }, 0);
            var ceil = createRound("ceil");
            var divide = createMathOperation(function (dividend, divisor) {
                return dividend / divisor;
            }, 1);
            var floor = createRound("floor");
            function max(array) {
                return array && array.length
                    ? baseExtremum(array, identity2, baseGt)
                    : undefined$1;
            }
            function maxBy(array, iteratee2) {
                return array && array.length
                    ? baseExtremum(array, getIteratee(iteratee2, 2), baseGt)
                    : undefined$1;
            }
            function mean(array) {
                return baseMean(array, identity2);
            }
            function meanBy(array, iteratee2) {
                return baseMean(array, getIteratee(iteratee2, 2));
            }
            function min(array) {
                return array && array.length
                    ? baseExtremum(array, identity2, baseLt)
                    : undefined$1;
            }
            function minBy(array, iteratee2) {
                return array && array.length
                    ? baseExtremum(array, getIteratee(iteratee2, 2), baseLt)
                    : undefined$1;
            }
            var multiply = createMathOperation(function (
                multiplier,
                multiplicand
            ) {
                return multiplier * multiplicand;
            },
            1);
            var round = createRound("round");
            var subtract = createMathOperation(function (minuend, subtrahend) {
                return minuend - subtrahend;
            }, 0);
            function sum(array) {
                return array && array.length ? baseSum(array, identity2) : 0;
            }
            function sumBy(array, iteratee2) {
                return array && array.length
                    ? baseSum(array, getIteratee(iteratee2, 2))
                    : 0;
            }
            lodash2.after = after;
            lodash2.ary = ary;
            lodash2.assign = assign;
            lodash2.assignIn = assignIn;
            lodash2.assignInWith = assignInWith;
            lodash2.assignWith = assignWith;
            lodash2.at = at;
            lodash2.before = before;
            lodash2.bind = bind5;
            lodash2.bindAll = bindAll;
            lodash2.bindKey = bindKey;
            lodash2.castArray = castArray;
            lodash2.chain = chain;
            lodash2.chunk = chunk;
            lodash2.compact = compact;
            lodash2.concat = concat2;
            lodash2.cond = cond;
            lodash2.conforms = conforms;
            lodash2.constant = constant2;
            lodash2.countBy = countBy;
            lodash2.create = create2;
            lodash2.curry = curry;
            lodash2.curryRight = curryRight;
            lodash2.debounce = debounce2;
            lodash2.defaults = defaults2;
            lodash2.defaultsDeep = defaultsDeep;
            lodash2.defer = defer;
            lodash2.delay = delay;
            lodash2.difference = difference;
            lodash2.differenceBy = differenceBy;
            lodash2.differenceWith = differenceWith;
            lodash2.drop = drop2;
            lodash2.dropRight = dropRight;
            lodash2.dropRightWhile = dropRightWhile;
            lodash2.dropWhile = dropWhile;
            lodash2.fill = fill;
            lodash2.filter = filter;
            lodash2.flatMap = flatMap;
            lodash2.flatMapDeep = flatMapDeep;
            lodash2.flatMapDepth = flatMapDepth;
            lodash2.flatten = flatten;
            lodash2.flattenDeep = flattenDeep;
            lodash2.flattenDepth = flattenDepth;
            lodash2.flip = flip2;
            lodash2.flow = flow;
            lodash2.flowRight = flowRight;
            lodash2.fromPairs = fromPairs;
            lodash2.functions = functions;
            lodash2.functionsIn = functionsIn;
            lodash2.groupBy = groupBy;
            lodash2.initial = initial;
            lodash2.intersection = intersection;
            lodash2.intersectionBy = intersectionBy;
            lodash2.intersectionWith = intersectionWith;
            lodash2.invert = invert;
            lodash2.invertBy = invertBy;
            lodash2.invokeMap = invokeMap;
            lodash2.iteratee = iteratee;
            lodash2.keyBy = keyBy;
            lodash2.keys = keys2;
            lodash2.keysIn = keysIn2;
            lodash2.map = map2;
            lodash2.mapKeys = mapKeys;
            lodash2.mapValues = mapValues;
            lodash2.matches = matches2;
            lodash2.matchesProperty = matchesProperty;
            lodash2.memoize = memoize;
            lodash2.merge = merge2;
            lodash2.mergeWith = mergeWith;
            lodash2.method = method;
            lodash2.methodOf = methodOf;
            lodash2.mixin = mixin;
            lodash2.negate = negate;
            lodash2.nthArg = nthArg;
            lodash2.omit = omit;
            lodash2.omitBy = omitBy;
            lodash2.once = once2;
            lodash2.orderBy = orderBy;
            lodash2.over = over;
            lodash2.overArgs = overArgs;
            lodash2.overEvery = overEvery;
            lodash2.overSome = overSome;
            lodash2.partial = partial;
            lodash2.partialRight = partialRight;
            lodash2.partition = partition;
            lodash2.pick = pick;
            lodash2.pickBy = pickBy;
            lodash2.property = property;
            lodash2.propertyOf = propertyOf;
            lodash2.pull = pull;
            lodash2.pullAll = pullAll;
            lodash2.pullAllBy = pullAllBy;
            lodash2.pullAllWith = pullAllWith;
            lodash2.pullAt = pullAt;
            lodash2.range = range;
            lodash2.rangeRight = rangeRight;
            lodash2.rearg = rearg;
            lodash2.reject = reject;
            lodash2.remove = remove2;
            lodash2.rest = rest;
            lodash2.reverse = reverse;
            lodash2.sampleSize = sampleSize;
            lodash2.set = set3;
            lodash2.setWith = setWith;
            lodash2.shuffle = shuffle;
            lodash2.slice = slice;
            lodash2.sortBy = sortBy;
            lodash2.sortedUniq = sortedUniq;
            lodash2.sortedUniqBy = sortedUniqBy;
            lodash2.split = split;
            lodash2.spread = spread2;
            lodash2.tail = tail;
            lodash2.take = take;
            lodash2.takeRight = takeRight;
            lodash2.takeRightWhile = takeRightWhile;
            lodash2.takeWhile = takeWhile;
            lodash2.tap = tap;
            lodash2.throttle = throttle2;
            lodash2.thru = thru;
            lodash2.toArray = toArray2;
            lodash2.toPairs = toPairs;
            lodash2.toPairsIn = toPairsIn;
            lodash2.toPath = toPath;
            lodash2.toPlainObject = toPlainObject2;
            lodash2.transform = transform;
            lodash2.unary = unary;
            lodash2.union = union;
            lodash2.unionBy = unionBy;
            lodash2.unionWith = unionWith;
            lodash2.uniq = uniq;
            lodash2.uniqBy = uniqBy;
            lodash2.uniqWith = uniqWith;
            lodash2.unset = unset;
            lodash2.unzip = unzip;
            lodash2.unzipWith = unzipWith;
            lodash2.update = update3;
            lodash2.updateWith = updateWith;
            lodash2.values = values;
            lodash2.valuesIn = valuesIn;
            lodash2.without = without;
            lodash2.words = words;
            lodash2.wrap = wrap;
            lodash2.xor = xor;
            lodash2.xorBy = xorBy;
            lodash2.xorWith = xorWith;
            lodash2.zip = zip;
            lodash2.zipObject = zipObject;
            lodash2.zipObjectDeep = zipObjectDeep;
            lodash2.zipWith = zipWith;
            lodash2.entries = toPairs;
            lodash2.entriesIn = toPairsIn;
            lodash2.extend = assignIn;
            lodash2.extendWith = assignInWith;
            mixin(lodash2, lodash2);
            lodash2.add = add2;
            lodash2.attempt = attempt;
            lodash2.camelCase = camelCase3;
            lodash2.capitalize = capitalize2;
            lodash2.ceil = ceil;
            lodash2.clamp = clamp;
            lodash2.clone = clone2;
            lodash2.cloneDeep = cloneDeep;
            lodash2.cloneDeepWith = cloneDeepWith;
            lodash2.cloneWith = cloneWith;
            lodash2.conformsTo = conformsTo;
            lodash2.deburr = deburr;
            lodash2.defaultTo = defaultTo;
            lodash2.divide = divide;
            lodash2.endsWith = endsWith2;
            lodash2.eq = eq2;
            lodash2.escape = escape;
            lodash2.escapeRegExp = escapeRegExp;
            lodash2.every = every;
            lodash2.find = find2;
            lodash2.findIndex = findIndex2;
            lodash2.findKey = findKey;
            lodash2.findLast = findLast;
            lodash2.findLastIndex = findLastIndex;
            lodash2.findLastKey = findLastKey;
            lodash2.floor = floor;
            lodash2.forEach = forEach3;
            lodash2.forEachRight = forEachRight;
            lodash2.forIn = forIn;
            lodash2.forInRight = forInRight;
            lodash2.forOwn = forOwn;
            lodash2.forOwnRight = forOwnRight;
            lodash2.get = get3;
            lodash2.gt = gt;
            lodash2.gte = gte;
            lodash2.has = has2;
            lodash2.hasIn = hasIn;
            lodash2.head = head;
            lodash2.identity = identity2;
            lodash2.includes = includes;
            lodash2.indexOf = indexOf;
            lodash2.inRange = inRange;
            lodash2.invoke = invoke;
            lodash2.isArguments = isArguments2;
            lodash2.isArray = isArray2;
            lodash2.isArrayBuffer = isArrayBuffer2;
            lodash2.isArrayLike = isArrayLike2;
            lodash2.isArrayLikeObject = isArrayLikeObject2;
            lodash2.isBoolean = isBoolean2;
            lodash2.isBuffer = isBuffer2;
            lodash2.isDate = isDate2;
            lodash2.isElement = isElement;
            lodash2.isEmpty = isEmpty2;
            lodash2.isEqual = isEqual2;
            lodash2.isEqualWith = isEqualWith;
            lodash2.isError = isError;
            lodash2.isFinite = isFinite2;
            lodash2.isFunction = isFunction2;
            lodash2.isInteger = isInteger;
            lodash2.isLength = isLength2;
            lodash2.isMap = isMap2;
            lodash2.isMatch = isMatch;
            lodash2.isMatchWith = isMatchWith;
            lodash2.isNaN = isNaN2;
            lodash2.isNative = isNative2;
            lodash2.isNil = isNil;
            lodash2.isNull = isNull2;
            lodash2.isNumber = isNumber2;
            lodash2.isObject = isObject2;
            lodash2.isObjectLike = isObjectLike2;
            lodash2.isPlainObject = isPlainObject2;
            lodash2.isRegExp = isRegExp2;
            lodash2.isSafeInteger = isSafeInteger;
            lodash2.isSet = isSet;
            lodash2.isString = isString2;
            lodash2.isSymbol = isSymbol2;
            lodash2.isTypedArray = isTypedArray2;
            lodash2.isUndefined = isUndefined2;
            lodash2.isWeakMap = isWeakMap;
            lodash2.isWeakSet = isWeakSet;
            lodash2.join = join;
            lodash2.kebabCase = kebabCase3;
            lodash2.last = last;
            lodash2.lastIndexOf = lastIndexOf;
            lodash2.lowerCase = lowerCase;
            lodash2.lowerFirst = lowerFirst;
            lodash2.lt = lt;
            lodash2.lte = lte;
            lodash2.max = max;
            lodash2.maxBy = maxBy;
            lodash2.mean = mean;
            lodash2.meanBy = meanBy;
            lodash2.min = min;
            lodash2.minBy = minBy;
            lodash2.stubArray = stubArray2;
            lodash2.stubFalse = stubFalse2;
            lodash2.stubObject = stubObject;
            lodash2.stubString = stubString;
            lodash2.stubTrue = stubTrue;
            lodash2.multiply = multiply;
            lodash2.nth = nth;
            lodash2.noConflict = noConflict;
            lodash2.noop = noop2;
            lodash2.now = now;
            lodash2.pad = pad;
            lodash2.padEnd = padEnd;
            lodash2.padStart = padStart;
            lodash2.parseInt = parseInt2;
            lodash2.random = random;
            lodash2.reduce = reduce;
            lodash2.reduceRight = reduceRight;
            lodash2.repeat = repeat;
            lodash2.replace = replace;
            lodash2.result = result;
            lodash2.round = round;
            lodash2.runInContext = runInContext2;
            lodash2.sample = sample;
            lodash2.size = size2;
            lodash2.snakeCase = snakeCase;
            lodash2.some = some;
            lodash2.sortedIndex = sortedIndex;
            lodash2.sortedIndexBy = sortedIndexBy;
            lodash2.sortedIndexOf = sortedIndexOf;
            lodash2.sortedLastIndex = sortedLastIndex;
            lodash2.sortedLastIndexBy = sortedLastIndexBy;
            lodash2.sortedLastIndexOf = sortedLastIndexOf;
            lodash2.startCase = startCase;
            lodash2.startsWith = startsWith;
            lodash2.subtract = subtract;
            lodash2.sum = sum;
            lodash2.sumBy = sumBy;
            lodash2.template = template;
            lodash2.times = times;
            lodash2.toFinite = toFinite;
            lodash2.toInteger = toInteger;
            lodash2.toLength = toLength;
            lodash2.toLower = toLower;
            lodash2.toNumber = toNumber2;
            lodash2.toSafeInteger = toSafeInteger;
            lodash2.toString = toString2;
            lodash2.toUpper = toUpper;
            lodash2.trim = trim2;
            lodash2.trimEnd = trimEnd;
            lodash2.trimStart = trimStart;
            lodash2.truncate = truncate;
            lodash2.unescape = unescape2;
            lodash2.uniqueId = uniqueId;
            lodash2.upperCase = upperCase;
            lodash2.upperFirst = upperFirst;
            lodash2.each = forEach3;
            lodash2.eachRight = forEachRight;
            lodash2.first = head;
            mixin(
                lodash2,
                (function () {
                    var source = {};
                    baseForOwn(lodash2, function (func, methodName) {
                        if (
                            !hasOwnProperty2.call(lodash2.prototype, methodName)
                        ) {
                            source[methodName] = func;
                        }
                    });
                    return source;
                })(),
                { chain: false }
            );
            lodash2.VERSION = VERSION2;
            arrayEach(
                [
                    "bind",
                    "bindKey",
                    "curry",
                    "curryRight",
                    "partial",
                    "partialRight",
                ],
                function (methodName) {
                    lodash2[methodName].placeholder = lodash2;
                }
            );
            arrayEach(["drop", "take"], function (methodName, index2) {
                LazyWrapper.prototype[methodName] = function (n) {
                    n = n === undefined$1 ? 1 : nativeMax2(toInteger(n), 0);
                    var result2 =
                        this.__filtered__ && !index2
                            ? new LazyWrapper(this)
                            : this.clone();
                    if (result2.__filtered__) {
                        result2.__takeCount__ = nativeMin(
                            n,
                            result2.__takeCount__
                        );
                    } else {
                        result2.__views__.push({
                            size: nativeMin(n, MAX_ARRAY_LENGTH),
                            type:
                                methodName +
                                (result2.__dir__ < 0 ? "Right" : ""),
                        });
                    }
                    return result2;
                };
                LazyWrapper.prototype[methodName + "Right"] = function (n) {
                    return this.reverse()[methodName](n).reverse();
                };
            });
            arrayEach(
                ["filter", "map", "takeWhile"],
                function (methodName, index2) {
                    var type = index2 + 1,
                        isFilter =
                            type == LAZY_FILTER_FLAG || type == LAZY_WHILE_FLAG;
                    LazyWrapper.prototype[methodName] = function (iteratee2) {
                        var result2 = this.clone();
                        result2.__iteratees__.push({
                            iteratee: getIteratee(iteratee2, 3),
                            type: type,
                        });
                        result2.__filtered__ = result2.__filtered__ || isFilter;
                        return result2;
                    };
                }
            );
            arrayEach(["head", "last"], function (methodName, index2) {
                var takeName = "take" + (index2 ? "Right" : "");
                LazyWrapper.prototype[methodName] = function () {
                    return this[takeName](1).value()[0];
                };
            });
            arrayEach(["initial", "tail"], function (methodName, index2) {
                var dropName = "drop" + (index2 ? "" : "Right");
                LazyWrapper.prototype[methodName] = function () {
                    return this.__filtered__
                        ? new LazyWrapper(this)
                        : this[dropName](1);
                };
            });
            LazyWrapper.prototype.compact = function () {
                return this.filter(identity2);
            };
            LazyWrapper.prototype.find = function (predicate) {
                return this.filter(predicate).head();
            };
            LazyWrapper.prototype.findLast = function (predicate) {
                return this.reverse().find(predicate);
            };
            LazyWrapper.prototype.invokeMap = baseRest2(function (path, args) {
                if (typeof path == "function") {
                    return new LazyWrapper(this);
                }
                return this.map(function (value) {
                    return baseInvoke(value, path, args);
                });
            });
            LazyWrapper.prototype.reject = function (predicate) {
                return this.filter(negate(getIteratee(predicate)));
            };
            LazyWrapper.prototype.slice = function (start2, end) {
                start2 = toInteger(start2);
                var result2 = this;
                if (result2.__filtered__ && (start2 > 0 || end < 0)) {
                    return new LazyWrapper(result2);
                }
                if (start2 < 0) {
                    result2 = result2.takeRight(-start2);
                } else if (start2) {
                    result2 = result2.drop(start2);
                }
                if (end !== undefined$1) {
                    end = toInteger(end);
                    result2 =
                        end < 0
                            ? result2.dropRight(-end)
                            : result2.take(end - start2);
                }
                return result2;
            };
            LazyWrapper.prototype.takeRightWhile = function (predicate) {
                return this.reverse().takeWhile(predicate).reverse();
            };
            LazyWrapper.prototype.toArray = function () {
                return this.take(MAX_ARRAY_LENGTH);
            };
            baseForOwn(LazyWrapper.prototype, function (func, methodName) {
                var checkIteratee = /^(?:filter|find|map|reject)|While$/.test(
                        methodName
                    ),
                    isTaker = /^(?:head|last)$/.test(methodName),
                    lodashFunc =
                        lodash2[
                            isTaker
                                ? "take" + (methodName == "last" ? "Right" : "")
                                : methodName
                        ],
                    retUnwrapped = isTaker || /^find/.test(methodName);
                if (!lodashFunc) {
                    return;
                }
                lodash2.prototype[methodName] = function () {
                    var value = this.__wrapped__,
                        args = isTaker ? [1] : arguments,
                        isLazy = value instanceof LazyWrapper,
                        iteratee2 = args[0],
                        useLazy = isLazy || isArray2(value);
                    var interceptor2 = function (value2) {
                        var result3 = lodashFunc.apply(
                            lodash2,
                            arrayPush2([value2], args)
                        );
                        return isTaker && chainAll ? result3[0] : result3;
                    };
                    if (
                        useLazy &&
                        checkIteratee &&
                        typeof iteratee2 == "function" &&
                        iteratee2.length != 1
                    ) {
                        isLazy = useLazy = false;
                    }
                    var chainAll = this.__chain__,
                        isHybrid = !!this.__actions__.length,
                        isUnwrapped = retUnwrapped && !chainAll,
                        onlyLazy = isLazy && !isHybrid;
                    if (!retUnwrapped && useLazy) {
                        value = onlyLazy ? value : new LazyWrapper(this);
                        var result2 = func.apply(value, args);
                        result2.__actions__.push({
                            func: thru,
                            args: [interceptor2],
                            thisArg: undefined$1,
                        });
                        return new LodashWrapper(result2, chainAll);
                    }
                    if (isUnwrapped && onlyLazy) {
                        return func.apply(this, args);
                    }
                    result2 = this.thru(interceptor2);
                    return isUnwrapped
                        ? isTaker
                            ? result2.value()[0]
                            : result2.value()
                        : result2;
                };
            });
            arrayEach(
                ["pop", "push", "shift", "sort", "splice", "unshift"],
                function (methodName) {
                    var func = arrayProto2[methodName],
                        chainName = /^(?:push|sort|unshift)$/.test(methodName)
                            ? "tap"
                            : "thru",
                        retUnwrapped = /^(?:pop|shift)$/.test(methodName);
                    lodash2.prototype[methodName] = function () {
                        var args = arguments;
                        if (retUnwrapped && !this.__chain__) {
                            var value = this.value();
                            return func.apply(
                                isArray2(value) ? value : [],
                                args
                            );
                        }
                        return this[chainName](function (value2) {
                            return func.apply(
                                isArray2(value2) ? value2 : [],
                                args
                            );
                        });
                    };
                }
            );
            baseForOwn(LazyWrapper.prototype, function (func, methodName) {
                var lodashFunc = lodash2[methodName];
                if (lodashFunc) {
                    var key = lodashFunc.name + "";
                    if (!hasOwnProperty2.call(realNames, key)) {
                        realNames[key] = [];
                    }
                    realNames[key].push({ name: methodName, func: lodashFunc });
                }
            });
            realNames[createHybrid(undefined$1, WRAP_BIND_KEY_FLAG).name] = [
                {
                    name: "wrapper",
                    func: undefined$1,
                },
            ];
            LazyWrapper.prototype.clone = lazyClone;
            LazyWrapper.prototype.reverse = lazyReverse;
            LazyWrapper.prototype.value = lazyValue;
            lodash2.prototype.at = wrapperAt;
            lodash2.prototype.chain = wrapperChain;
            lodash2.prototype.commit = wrapperCommit;
            lodash2.prototype.next = wrapperNext;
            lodash2.prototype.plant = wrapperPlant;
            lodash2.prototype.reverse = wrapperReverse;
            lodash2.prototype.toJSON =
                lodash2.prototype.valueOf =
                lodash2.prototype.value =
                    wrapperValue;
            lodash2.prototype.first = lodash2.prototype.head;
            if (symIterator) {
                lodash2.prototype[symIterator] = wrapperToIterator;
            }
            return lodash2;
        };
        var _2 = runInContext();
        if (freeModule) {
            (freeModule.exports = _2)._ = _2;
            freeExports._ = _2;
        } else {
            root2._ = _2;
        }
    }.call(commonjsGlobal));
})(lodash, lodash.exports);
const _ = lodash.exports;
var axios$6 = { exports: {} };
var axios$5 = { exports: {} };
var bind$5 = function bind(fn2, thisArg) {
    return function wrap() {
        var args = new Array(arguments.length);
        for (var i = 0; i < args.length; i++) {
            args[i] = arguments[i];
        }
        return fn2.apply(thisArg, args);
    };
};
var bind$4 = bind$5;
var toString$2 = Object.prototype.toString;
var kindOf = (function (cache) {
    return function (thing) {
        var str = toString$2.call(thing);
        return cache[str] || (cache[str] = str.slice(8, -1).toLowerCase());
    };
})(/* @__PURE__ */ Object.create(null));
function kindOfTest(type) {
    type = type.toLowerCase();
    return function isKindOf(thing) {
        return kindOf(thing) === type;
    };
}
function isArray$8(val) {
    return Array.isArray(val);
}
function isUndefined$1(val) {
    return typeof val === "undefined";
}
function isBuffer$4(val) {
    return (
        val !== null &&
        !isUndefined$1(val) &&
        val.constructor !== null &&
        !isUndefined$1(val.constructor) &&
        typeof val.constructor.isBuffer === "function" &&
        val.constructor.isBuffer(val)
    );
}
var isArrayBuffer = kindOfTest("ArrayBuffer");
function isArrayBufferView(val) {
    var result;
    if (typeof ArrayBuffer !== "undefined" && ArrayBuffer.isView) {
        result = ArrayBuffer.isView(val);
    } else {
        result = val && val.buffer && isArrayBuffer(val.buffer);
    }
    return result;
}
function isString$3(val) {
    return typeof val === "string";
}
function isNumber$2(val) {
    return typeof val === "number";
}
function isObject$c(val) {
    return val !== null && typeof val === "object";
}
function isPlainObject$3(val) {
    if (kindOf(val) !== "object") {
        return false;
    }
    var prototype2 = Object.getPrototypeOf(val);
    return prototype2 === null || prototype2 === Object.prototype;
}
var isDate = kindOfTest("Date");
var isFile$1 = kindOfTest("File");
var isBlob = kindOfTest("Blob");
var isFileList = kindOfTest("FileList");
function isFunction$8(val) {
    return toString$2.call(val) === "[object Function]";
}
function isStream(val) {
    return isObject$c(val) && isFunction$8(val.pipe);
}
function isFormData(thing) {
    var pattern = "[object FormData]";
    return (
        thing &&
        ((typeof FormData === "function" && thing instanceof FormData) ||
            toString$2.call(thing) === pattern ||
            (isFunction$8(thing.toString) && thing.toString() === pattern))
    );
}
var isURLSearchParams = kindOfTest("URLSearchParams");
function trim$1(str) {
    return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g, "");
}
function isStandardBrowserEnv() {
    if (
        typeof navigator !== "undefined" &&
        (navigator.product === "ReactNative" ||
            navigator.product === "NativeScript" ||
            navigator.product === "NS")
    ) {
        return false;
    }
    return typeof window !== "undefined" && typeof document !== "undefined";
}
function forEach(obj, fn2) {
    if (obj === null || typeof obj === "undefined") {
        return;
    }
    if (typeof obj !== "object") {
        obj = [obj];
    }
    if (isArray$8(obj)) {
        for (var i = 0, l = obj.length; i < l; i++) {
            fn2.call(null, obj[i], i, obj);
        }
    } else {
        for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) {
                fn2.call(null, obj[key], key, obj);
            }
        }
    }
}
function merge$1() {
    var result = {};
    function assignValue2(val, key) {
        if (isPlainObject$3(result[key]) && isPlainObject$3(val)) {
            result[key] = merge$1(result[key], val);
        } else if (isPlainObject$3(val)) {
            result[key] = merge$1({}, val);
        } else if (isArray$8(val)) {
            result[key] = val.slice();
        } else {
            result[key] = val;
        }
    }
    for (var i = 0, l = arguments.length; i < l; i++) {
        forEach(arguments[i], assignValue2);
    }
    return result;
}
function extend$2(a, b, thisArg) {
    forEach(b, function assignValue2(val, key) {
        if (thisArg && typeof val === "function") {
            a[key] = bind$4(val, thisArg);
        } else {
            a[key] = val;
        }
    });
    return a;
}
function stripBOM(content) {
    if (content.charCodeAt(0) === 65279) {
        content = content.slice(1);
    }
    return content;
}
function inherits(constructor, superConstructor, props2, descriptors2) {
    constructor.prototype = Object.create(
        superConstructor.prototype,
        descriptors2
    );
    constructor.prototype.constructor = constructor;
    props2 && Object.assign(constructor.prototype, props2);
}
function toFlatObject(sourceObj, destObj, filter) {
    var props2;
    var i;
    var prop;
    var merged = {};
    destObj = destObj || {};
    do {
        props2 = Object.getOwnPropertyNames(sourceObj);
        i = props2.length;
        while (i-- > 0) {
            prop = props2[i];
            if (!merged[prop]) {
                destObj[prop] = sourceObj[prop];
                merged[prop] = true;
            }
        }
        sourceObj = Object.getPrototypeOf(sourceObj);
    } while (
        sourceObj &&
        (!filter || filter(sourceObj, destObj)) &&
        sourceObj !== Object.prototype
    );
    return destObj;
}
function endsWith(str, searchString, position) {
    str = String(str);
    if (position === void 0 || position > str.length) {
        position = str.length;
    }
    position -= searchString.length;
    var lastIndex = str.indexOf(searchString, position);
    return lastIndex !== -1 && lastIndex === position;
}
function toArray$2(thing) {
    if (!thing) return null;
    var i = thing.length;
    if (isUndefined$1(i)) return null;
    var arr = new Array(i);
    while (i-- > 0) {
        arr[i] = thing[i];
    }
    return arr;
}
var isTypedArray$4 = (function (TypedArray) {
    return function (thing) {
        return TypedArray && thing instanceof TypedArray;
    };
})(typeof Uint8Array !== "undefined" && Object.getPrototypeOf(Uint8Array));
var utils$b = {
    isArray: isArray$8,
    isArrayBuffer,
    isBuffer: isBuffer$4,
    isFormData,
    isArrayBufferView,
    isString: isString$3,
    isNumber: isNumber$2,
    isObject: isObject$c,
    isPlainObject: isPlainObject$3,
    isUndefined: isUndefined$1,
    isDate,
    isFile: isFile$1,
    isBlob,
    isFunction: isFunction$8,
    isStream,
    isURLSearchParams,
    isStandardBrowserEnv,
    forEach,
    merge: merge$1,
    extend: extend$2,
    trim: trim$1,
    stripBOM,
    inherits,
    toFlatObject,
    kindOf,
    kindOfTest,
    endsWith,
    toArray: toArray$2,
    isTypedArray: isTypedArray$4,
    isFileList,
};
var utils$a = utils$b;
function encode(val) {
    return encodeURIComponent(val)
        .replace(/%3A/gi, ":")
        .replace(/%24/g, "$")
        .replace(/%2C/gi, ",")
        .replace(/%20/g, "+")
        .replace(/%5B/gi, "[")
        .replace(/%5D/gi, "]");
}
var buildURL$2 = function buildURL(url, params, paramsSerializer) {
    if (!params) {
        return url;
    }
    var serializedParams;
    if (paramsSerializer) {
        serializedParams = paramsSerializer(params);
    } else if (utils$a.isURLSearchParams(params)) {
        serializedParams = params.toString();
    } else {
        var parts = [];
        utils$a.forEach(params, function serialize(val, key) {
            if (val === null || typeof val === "undefined") {
                return;
            }
            if (utils$a.isArray(val)) {
                key = key + "[]";
            } else {
                val = [val];
            }
            utils$a.forEach(val, function parseValue(v) {
                if (utils$a.isDate(v)) {
                    v = v.toISOString();
                } else if (utils$a.isObject(v)) {
                    v = JSON.stringify(v);
                }
                parts.push(encode(key) + "=" + encode(v));
            });
        });
        serializedParams = parts.join("&");
    }
    if (serializedParams) {
        var hashmarkIndex = url.indexOf("#");
        if (hashmarkIndex !== -1) {
            url = url.slice(0, hashmarkIndex);
        }
        url += (url.indexOf("?") === -1 ? "?" : "&") + serializedParams;
    }
    return url;
};
var utils$9 = utils$b;
function InterceptorManager$1() {
    this.handlers = [];
}

InterceptorManager$1.prototype.use = function use(
    fulfilled,
    rejected,
    options
) {
    this.handlers.push({
        fulfilled,
        rejected,
        synchronous: options ? options.synchronous : false,
        runWhen: options ? options.runWhen : null,
    });
    return this.handlers.length - 1;
};
InterceptorManager$1.prototype.eject = function eject(id) {
    if (this.handlers[id]) {
        this.handlers[id] = null;
    }
};
InterceptorManager$1.prototype.forEach = function forEach2(fn2) {
    utils$9.forEach(this.handlers, function forEachHandler(h) {
        if (h !== null) {
            fn2(h);
        }
    });
};
var InterceptorManager_1 = InterceptorManager$1;
var utils$8 = utils$b;
var normalizeHeaderName$1 = function normalizeHeaderName(
    headers,
    normalizedName
) {
    utils$8.forEach(headers, function processHeader(value, name2) {
        if (
            name2 !== normalizedName &&
            name2.toUpperCase() === normalizedName.toUpperCase()
        ) {
            headers[normalizedName] = value;
            delete headers[name2];
        }
    });
};
var utils$7 = utils$b;
function AxiosError$2(message, code, config2, request2, response) {
    Error.call(this);
    this.message = message;
    this.name = "AxiosError";
    code && (this.code = code);
    config2 && (this.config = config2);
    request2 && (this.request = request2);
    response && (this.response = response);
}
utils$7.inherits(AxiosError$2, Error, {
    toJSON: function toJSON() {
        return {
            message: this.message,
            name: this.name,
            description: this.description,
            number: this.number,
            fileName: this.fileName,
            lineNumber: this.lineNumber,
            columnNumber: this.columnNumber,
            stack: this.stack,
            config: this.config,
            code: this.code,
            status:
                this.response && this.response.status
                    ? this.response.status
                    : null,
        };
    },
});
var prototype = AxiosError$2.prototype;
var descriptors = {};
[
    "ERR_BAD_OPTION_VALUE",
    "ERR_BAD_OPTION",
    "ECONNABORTED",
    "ETIMEDOUT",
    "ERR_NETWORK",
    "ERR_FR_TOO_MANY_REDIRECTS",
    "ERR_DEPRECATED",
    "ERR_BAD_RESPONSE",
    "ERR_BAD_REQUEST",
    "ERR_CANCELED",
].forEach(function (code) {
    descriptors[code] = { value: code };
});
Object.defineProperties(AxiosError$2, descriptors);
Object.defineProperty(prototype, "isAxiosError", { value: true });
AxiosError$2.from = function (
    error2,
    code,
    config2,
    request2,
    response,
    customProps
) {
    var axiosError = Object.create(prototype);
    utils$7.toFlatObject(error2, axiosError, function filter(obj) {
        return obj !== Error.prototype;
    });
    AxiosError$2.call(
        axiosError,
        error2.message,
        code,
        config2,
        request2,
        response
    );
    axiosError.name = error2.name;
    customProps && Object.assign(axiosError, customProps);
    return axiosError;
};
var AxiosError_1 = AxiosError$2;
var transitional = {
    silentJSONParsing: true,
    forcedJSONParsing: true,
    clarifyTimeoutError: false,
};
var utils$6 = utils$b;
function toFormData$1(obj, formData) {
    formData = formData || new FormData();
    var stack = [];
    function convertValue(value) {
        if (value === null) return "";
        if (utils$6.isDate(value)) {
            return value.toISOString();
        }
        if (utils$6.isArrayBuffer(value) || utils$6.isTypedArray(value)) {
            return typeof Blob === "function"
                ? new Blob([value])
                : Buffer.from(value);
        }
        return value;
    }
    function build(data3, parentKey) {
        if (utils$6.isPlainObject(data3) || utils$6.isArray(data3)) {
            if (stack.indexOf(data3) !== -1) {
                throw Error("Circular reference detected in " + parentKey);
            }
            stack.push(data3);
            utils$6.forEach(data3, function each(value, key) {
                if (utils$6.isUndefined(value)) return;
                var fullKey = parentKey ? parentKey + "." + key : key;
                var arr;
                if (value && !parentKey && typeof value === "object") {
                    if (utils$6.endsWith(key, "{}")) {
                        value = JSON.stringify(value);
                    } else if (
                        utils$6.endsWith(key, "[]") &&
                        (arr = utils$6.toArray(value))
                    ) {
                        arr.forEach(function (el) {
                            !utils$6.isUndefined(el) &&
                                formData.append(fullKey, convertValue(el));
                        });
                        return;
                    }
                }
                build(value, fullKey);
            });
            stack.pop();
        } else {
            formData.append(parentKey, convertValue(data3));
        }
    }
    build(obj);
    return formData;
}
var toFormData_1 = toFormData$1;
var settle;
var hasRequiredSettle;
function requireSettle() {
    if (hasRequiredSettle) return settle;
    hasRequiredSettle = 1;
    var AxiosError2 = AxiosError_1;
    settle = function settle2(resolve, reject, response) {
        var validateStatus2 = response.config.validateStatus;
        if (
            !response.status ||
            !validateStatus2 ||
            validateStatus2(response.status)
        ) {
            resolve(response);
        } else {
            reject(
                new AxiosError2(
                    "Request failed with status code " + response.status,
                    [AxiosError2.ERR_BAD_REQUEST, AxiosError2.ERR_BAD_RESPONSE][
                        Math.floor(response.status / 100) - 4
                    ],
                    response.config,
                    response.request,
                    response
                )
            );
        }
    };
    return settle;
}
var cookies;
var hasRequiredCookies;
function requireCookies() {
    if (hasRequiredCookies) return cookies;
    hasRequiredCookies = 1;
    var utils2 = utils$b;
    cookies = utils2.isStandardBrowserEnv()
        ? (function standardBrowserEnv() {
              return {
                  write: function write2(
                      name2,
                      value,
                      expires,
                      path,
                      domain,
                      secure
                  ) {
                      var cookie = [];
                      cookie.push(name2 + "=" + encodeURIComponent(value));
                      if (utils2.isNumber(expires)) {
                          cookie.push(
                              "expires=" + new Date(expires).toGMTString()
                          );
                      }
                      if (utils2.isString(path)) {
                          cookie.push("path=" + path);
                      }
                      if (utils2.isString(domain)) {
                          cookie.push("domain=" + domain);
                      }
                      if (secure === true) {
                          cookie.push("secure");
                      }
                      document.cookie = cookie.join("; ");
                  },
                  read: function read(name2) {
                      var match = document.cookie.match(
                          new RegExp("(^|;\\s*)(" + name2 + ")=([^;]*)")
                      );
                      return match ? decodeURIComponent(match[3]) : null;
                  },
                  remove: function remove2(name2) {
                      this.write(name2, "", Date.now() - 864e5);
                  },
              };
          })()
        : (function nonStandardBrowserEnv() {
              return {
                  write: function write2() {},
                  read: function read() {
                      return null;
                  },
                  remove: function remove2() {},
              };
          })();
    return cookies;
}
var isAbsoluteURL$1 = function isAbsoluteURL(url) {
    return /^([a-z][a-z\d+\-.]*:)?\/\//i.test(url);
};
var combineURLs$1 = function combineURLs(baseURL, relativeURL) {
    return relativeURL
        ? baseURL.replace(/\/+$/, "") + "/" + relativeURL.replace(/^\/+/, "")
        : baseURL;
};
var isAbsoluteURL2 = isAbsoluteURL$1;
var combineURLs2 = combineURLs$1;
var buildFullPath$1 = function buildFullPath(baseURL, requestedURL) {
    if (baseURL && !isAbsoluteURL2(requestedURL)) {
        return combineURLs2(baseURL, requestedURL);
    }
    return requestedURL;
};
var parseHeaders;
var hasRequiredParseHeaders;
function requireParseHeaders() {
    if (hasRequiredParseHeaders) return parseHeaders;
    hasRequiredParseHeaders = 1;
    var utils2 = utils$b;
    var ignoreDuplicateOf = [
        "age",
        "authorization",
        "content-length",
        "content-type",
        "etag",
        "expires",
        "from",
        "host",
        "if-modified-since",
        "if-unmodified-since",
        "last-modified",
        "location",
        "max-forwards",
        "proxy-authorization",
        "referer",
        "retry-after",
        "user-agent",
    ];
    parseHeaders = function parseHeaders2(headers) {
        var parsed = {};
        var key;
        var val;
        var i;
        if (!headers) {
            return parsed;
        }
        utils2.forEach(headers.split("\n"), function parser(line) {
            i = line.indexOf(":");
            key = utils2.trim(line.substr(0, i)).toLowerCase();
            val = utils2.trim(line.substr(i + 1));
            if (key) {
                if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {
                    return;
                }
                if (key === "set-cookie") {
                    parsed[key] = (parsed[key] ? parsed[key] : []).concat([
                        val,
                    ]);
                } else {
                    parsed[key] = parsed[key] ? parsed[key] + ", " + val : val;
                }
            }
        });
        return parsed;
    };
    return parseHeaders;
}
var isURLSameOrigin;
var hasRequiredIsURLSameOrigin;
function requireIsURLSameOrigin() {
    if (hasRequiredIsURLSameOrigin) return isURLSameOrigin;
    hasRequiredIsURLSameOrigin = 1;
    var utils2 = utils$b;
    isURLSameOrigin = utils2.isStandardBrowserEnv()
        ? (function standardBrowserEnv() {
              var msie = /(msie|trident)/i.test(navigator.userAgent);
              var urlParsingNode = document.createElement("a");
              var originURL;
              function resolveURL(url) {
                  var href = url;
                  if (msie) {
                      urlParsingNode.setAttribute("href", href);
                      href = urlParsingNode.href;
                  }
                  urlParsingNode.setAttribute("href", href);
                  return {
                      href: urlParsingNode.href,
                      protocol: urlParsingNode.protocol
                          ? urlParsingNode.protocol.replace(/:$/, "")
                          : "",
                      host: urlParsingNode.host,
                      search: urlParsingNode.search
                          ? urlParsingNode.search.replace(/^\?/, "")
                          : "",
                      hash: urlParsingNode.hash
                          ? urlParsingNode.hash.replace(/^#/, "")
                          : "",
                      hostname: urlParsingNode.hostname,
                      port: urlParsingNode.port,
                      pathname:
                          urlParsingNode.pathname.charAt(0) === "/"
                              ? urlParsingNode.pathname
                              : "/" + urlParsingNode.pathname,
                  };
              }
              originURL = resolveURL(window.location.href);
              return function isURLSameOrigin2(requestURL) {
                  var parsed = utils2.isString(requestURL)
                      ? resolveURL(requestURL)
                      : requestURL;
                  return (
                      parsed.protocol === originURL.protocol &&
                      parsed.host === originURL.host
                  );
              };
          })()
        : (function nonStandardBrowserEnv() {
              return function isURLSameOrigin2() {
                  return true;
              };
          })();
    return isURLSameOrigin;
}
var CanceledError_1;
var hasRequiredCanceledError;
function requireCanceledError() {
    if (hasRequiredCanceledError) return CanceledError_1;
    hasRequiredCanceledError = 1;
    var AxiosError2 = AxiosError_1;
    var utils2 = utils$b;
    function CanceledError2(message) {
        AxiosError2.call(
            this,
            message == null ? "canceled" : message,
            AxiosError2.ERR_CANCELED
        );
        this.name = "CanceledError";
    }
    utils2.inherits(CanceledError2, AxiosError2, {
        __CANCEL__: true,
    });
    CanceledError_1 = CanceledError2;
    return CanceledError_1;
}
var parseProtocol;
var hasRequiredParseProtocol;
function requireParseProtocol() {
    if (hasRequiredParseProtocol) return parseProtocol;
    hasRequiredParseProtocol = 1;
    parseProtocol = function parseProtocol2(url) {
        var match = /^([-+\w]{1,25})(:?\/\/|:)/.exec(url);
        return (match && match[1]) || "";
    };
    return parseProtocol;
}
var xhr;
var hasRequiredXhr;
function requireXhr() {
    if (hasRequiredXhr) return xhr;
    hasRequiredXhr = 1;
    var utils2 = utils$b;
    var settle2 = requireSettle();
    var cookies2 = requireCookies();
    var buildURL3 = buildURL$2;
    var buildFullPath3 = buildFullPath$1;
    var parseHeaders2 = requireParseHeaders();
    var isURLSameOrigin2 = requireIsURLSameOrigin();
    var transitionalDefaults2 = transitional;
    var AxiosError2 = AxiosError_1;
    var CanceledError2 = requireCanceledError();
    var parseProtocol2 = requireParseProtocol();
    xhr = function xhrAdapter(config2) {
        return new Promise(function dispatchXhrRequest(resolve, reject) {
            var requestData = config2.data;
            var requestHeaders = config2.headers;
            var responseType = config2.responseType;
            var onCanceled;
            function done() {
                if (config2.cancelToken) {
                    config2.cancelToken.unsubscribe(onCanceled);
                }
                if (config2.signal) {
                    config2.signal.removeEventListener("abort", onCanceled);
                }
            }
            if (
                utils2.isFormData(requestData) &&
                utils2.isStandardBrowserEnv()
            ) {
                delete requestHeaders["Content-Type"];
            }
            var request2 = new XMLHttpRequest();
            if (config2.auth) {
                var username = config2.auth.username || "";
                var password = config2.auth.password
                    ? unescape(encodeURIComponent(config2.auth.password))
                    : "";
                requestHeaders.Authorization =
                    "Basic " + btoa(username + ":" + password);
            }
            var fullPath = buildFullPath3(config2.baseURL, config2.url);
            request2.open(
                config2.method.toUpperCase(),
                buildURL3(fullPath, config2.params, config2.paramsSerializer),
                true
            );
            request2.timeout = config2.timeout;
            function onloadend() {
                if (!request2) {
                    return;
                }
                var responseHeaders =
                    "getAllResponseHeaders" in request2
                        ? parseHeaders2(request2.getAllResponseHeaders())
                        : null;
                var responseData =
                    !responseType ||
                    responseType === "text" ||
                    responseType === "json"
                        ? request2.responseText
                        : request2.response;
                var response = {
                    data: responseData,
                    status: request2.status,
                    statusText: request2.statusText,
                    headers: responseHeaders,
                    config: config2,
                    request: request2,
                };
                settle2(
                    function _resolve(value) {
                        resolve(value);
                        done();
                    },
                    function _reject(err) {
                        reject(err);
                        done();
                    },
                    response
                );
                request2 = null;
            }
            if ("onloadend" in request2) {
                request2.onloadend = onloadend;
            } else {
                request2.onreadystatechange = function handleLoad() {
                    if (!request2 || request2.readyState !== 4) {
                        return;
                    }
                    if (
                        request2.status === 0 &&
                        !(
                            request2.responseURL &&
                            request2.responseURL.indexOf("file:") === 0
                        )
                    ) {
                        return;
                    }
                    setTimeout(onloadend);
                };
            }
            request2.onabort = function handleAbort() {
                if (!request2) {
                    return;
                }
                reject(
                    new AxiosError2(
                        "Request aborted",
                        AxiosError2.ECONNABORTED,
                        config2,
                        request2
                    )
                );
                request2 = null;
            };
            request2.onerror = function handleError2() {
                reject(
                    new AxiosError2(
                        "Network Error",
                        AxiosError2.ERR_NETWORK,
                        config2,
                        request2,
                        request2
                    )
                );
                request2 = null;
            };
            request2.ontimeout = function handleTimeout() {
                var timeoutErrorMessage = config2.timeout
                    ? "timeout of " + config2.timeout + "ms exceeded"
                    : "timeout exceeded";
                var transitional3 =
                    config2.transitional || transitionalDefaults2;
                if (config2.timeoutErrorMessage) {
                    timeoutErrorMessage = config2.timeoutErrorMessage;
                }
                reject(
                    new AxiosError2(
                        timeoutErrorMessage,
                        transitional3.clarifyTimeoutError
                            ? AxiosError2.ETIMEDOUT
                            : AxiosError2.ECONNABORTED,
                        config2,
                        request2
                    )
                );
                request2 = null;
            };
            if (utils2.isStandardBrowserEnv()) {
                var xsrfValue =
                    (config2.withCredentials || isURLSameOrigin2(fullPath)) &&
                    config2.xsrfCookieName
                        ? cookies2.read(config2.xsrfCookieName)
                        : void 0;
                if (xsrfValue) {
                    requestHeaders[config2.xsrfHeaderName] = xsrfValue;
                }
            }
            if ("setRequestHeader" in request2) {
                utils2.forEach(
                    requestHeaders,
                    function setRequestHeader(val, key) {
                        if (
                            typeof requestData === "undefined" &&
                            key.toLowerCase() === "content-type"
                        ) {
                            delete requestHeaders[key];
                        } else {
                            request2.setRequestHeader(key, val);
                        }
                    }
                );
            }
            if (!utils2.isUndefined(config2.withCredentials)) {
                request2.withCredentials = !!config2.withCredentials;
            }
            if (responseType && responseType !== "json") {
                request2.responseType = config2.responseType;
            }
            if (typeof config2.onDownloadProgress === "function") {
                request2.addEventListener(
                    "progress",
                    config2.onDownloadProgress
                );
            }
            if (
                typeof config2.onUploadProgress === "function" &&
                request2.upload
            ) {
                request2.upload.addEventListener(
                    "progress",
                    config2.onUploadProgress
                );
            }
            if (config2.cancelToken || config2.signal) {
                onCanceled = function (cancel) {
                    if (!request2) {
                        return;
                    }
                    reject(
                        !cancel || (cancel && cancel.type)
                            ? new CanceledError2()
                            : cancel
                    );
                    request2.abort();
                    request2 = null;
                };
                config2.cancelToken &&
                    config2.cancelToken.subscribe(onCanceled);
                if (config2.signal) {
                    config2.signal.aborted
                        ? onCanceled()
                        : config2.signal.addEventListener("abort", onCanceled);
                }
            }
            if (!requestData) {
                requestData = null;
            }
            var protocol = parseProtocol2(fullPath);
            if (
                protocol &&
                ["http", "https", "file"].indexOf(protocol) === -1
            ) {
                reject(
                    new AxiosError2(
                        "Unsupported protocol " + protocol + ":",
                        AxiosError2.ERR_BAD_REQUEST,
                        config2
                    )
                );
                return;
            }
            request2.send(requestData);
        });
    };
    return xhr;
}
var _null;
var hasRequired_null;
function require_null() {
    if (hasRequired_null) return _null;
    hasRequired_null = 1;
    _null = null;
    return _null;
}
var utils$5 = utils$b;
var normalizeHeaderName2 = normalizeHeaderName$1;
var AxiosError$1 = AxiosError_1;
var transitionalDefaults = transitional;
var toFormData = toFormData_1;
var DEFAULT_CONTENT_TYPE = {
    "Content-Type": "application/x-www-form-urlencoded",
};
function setContentTypeIfUnset(headers, value) {
    if (
        !utils$5.isUndefined(headers) &&
        utils$5.isUndefined(headers["Content-Type"])
    ) {
        headers["Content-Type"] = value;
    }
}
function getDefaultAdapter() {
    var adapter;
    if (typeof XMLHttpRequest !== "undefined") {
        adapter = requireXhr();
    } else if (
        typeof process !== "undefined" &&
        Object.prototype.toString.call(process) === "[object process]"
    ) {
        adapter = requireXhr();
    }
    return adapter;
}
function stringifySafely(rawValue, parser, encoder) {
    if (utils$5.isString(rawValue)) {
        try {
            (parser || JSON.parse)(rawValue);
            return utils$5.trim(rawValue);
        } catch (e) {
            if (e.name !== "SyntaxError") {
                throw e;
            }
        }
    }
    return (encoder || JSON.stringify)(rawValue);
}
var defaults$4 = {
    transitional: transitionalDefaults,
    adapter: getDefaultAdapter(),
    transformRequest: [
        function transformRequest(data3, headers) {
            normalizeHeaderName2(headers, "Accept");
            normalizeHeaderName2(headers, "Content-Type");
            if (
                utils$5.isFormData(data3) ||
                utils$5.isArrayBuffer(data3) ||
                utils$5.isBuffer(data3) ||
                utils$5.isStream(data3) ||
                utils$5.isFile(data3) ||
                utils$5.isBlob(data3)
            ) {
                return data3;
            }
            if (utils$5.isArrayBufferView(data3)) {
                return data3.buffer;
            }
            if (utils$5.isURLSearchParams(data3)) {
                setContentTypeIfUnset(
                    headers,
                    "application/x-www-form-urlencoded;charset=utf-8"
                );
                return data3.toString();
            }
            var isObjectPayload = utils$5.isObject(data3);
            var contentType = headers && headers["Content-Type"];
            var isFileList2;
            if (
                (isFileList2 = utils$5.isFileList(data3)) ||
                (isObjectPayload && contentType === "multipart/form-data")
            ) {
                var _FormData = this.env && this.env.FormData;
                return toFormData(
                    isFileList2 ? { "files[]": data3 } : data3,
                    _FormData && new _FormData()
                );
            } else if (isObjectPayload || contentType === "application/json") {
                setContentTypeIfUnset(headers, "application/json");
                return stringifySafely(data3);
            }
            return data3;
        },
    ],
    transformResponse: [
        function transformResponse(data3) {
            var transitional3 = this.transitional || defaults$4.transitional;
            var silentJSONParsing =
                transitional3 && transitional3.silentJSONParsing;
            var forcedJSONParsing =
                transitional3 && transitional3.forcedJSONParsing;
            var strictJSONParsing =
                !silentJSONParsing && this.responseType === "json";
            if (
                strictJSONParsing ||
                (forcedJSONParsing && utils$5.isString(data3) && data3.length)
            ) {
                try {
                    return JSON.parse(data3);
                } catch (e) {
                    if (strictJSONParsing) {
                        if (e.name === "SyntaxError") {
                            throw AxiosError$1.from(
                                e,
                                AxiosError$1.ERR_BAD_RESPONSE,
                                this,
                                null,
                                this.response
                            );
                        }
                        throw e;
                    }
                }
            }
            return data3;
        },
    ],
    timeout: 0,
    xsrfCookieName: "XSRF-TOKEN",
    xsrfHeaderName: "X-XSRF-TOKEN",
    maxContentLength: -1,
    maxBodyLength: -1,
    env: {
        FormData: require_null(),
    },
    validateStatus: function validateStatus(status) {
        return status >= 200 && status < 300;
    },
    headers: {
        common: {
            Accept: "application/json, text/plain, */*",
        },
    },
};
utils$5.forEach(
    ["delete", "get", "head"],
    function forEachMethodNoData(method) {
        defaults$4.headers[method] = {};
    }
);
utils$5.forEach(
    ["post", "put", "patch"],
    function forEachMethodWithData(method) {
        defaults$4.headers[method] = utils$5.merge(DEFAULT_CONTENT_TYPE);
    }
);
var defaults_1 = defaults$4;
var utils$4 = utils$b;
var defaults$3 = defaults_1;
var transformData$1 = function transformData(data3, headers, fns) {
    var context = this || defaults$3;
    utils$4.forEach(fns, function transform(fn2) {
        data3 = fn2.call(context, data3, headers);
    });
    return data3;
};
var isCancel$1;
var hasRequiredIsCancel;
function requireIsCancel() {
    if (hasRequiredIsCancel) return isCancel$1;
    hasRequiredIsCancel = 1;
    isCancel$1 = function isCancel2(value) {
        return !!(value && value.__CANCEL__);
    };
    return isCancel$1;
}
var utils$3 = utils$b;
var transformData2 = transformData$1;
var isCancel = requireIsCancel();
var defaults$2 = defaults_1;
var CanceledError = requireCanceledError();
function throwIfCancellationRequested(config2) {
    if (config2.cancelToken) {
        config2.cancelToken.throwIfRequested();
    }
    if (config2.signal && config2.signal.aborted) {
        throw new CanceledError();
    }
}
var dispatchRequest$1 = function dispatchRequest(config2) {
    throwIfCancellationRequested(config2);
    config2.headers = config2.headers || {};
    config2.data = transformData2.call(
        config2,
        config2.data,
        config2.headers,
        config2.transformRequest
    );
    config2.headers = utils$3.merge(
        config2.headers.common || {},
        config2.headers[config2.method] || {},
        config2.headers
    );
    utils$3.forEach(
        ["delete", "get", "head", "post", "put", "patch", "common"],
        function cleanHeaderConfig(method) {
            delete config2.headers[method];
        }
    );
    var adapter = config2.adapter || defaults$2.adapter;
    return adapter(config2).then(
        function onAdapterResolution(response) {
            throwIfCancellationRequested(config2);
            response.data = transformData2.call(
                config2,
                response.data,
                response.headers,
                config2.transformResponse
            );
            return response;
        },
        function onAdapterRejection(reason) {
            if (!isCancel(reason)) {
                throwIfCancellationRequested(config2);
                if (reason && reason.response) {
                    reason.response.data = transformData2.call(
                        config2,
                        reason.response.data,
                        reason.response.headers,
                        config2.transformResponse
                    );
                }
            }
            return Promise.reject(reason);
        }
    );
};
var utils$2 = utils$b;
var mergeConfig$2 = function mergeConfig(config1, config2) {
    config2 = config2 || {};
    var config3 = {};
    function getMergedValue(target2, source) {
        if (utils$2.isPlainObject(target2) && utils$2.isPlainObject(source)) {
            return utils$2.merge(target2, source);
        } else if (utils$2.isPlainObject(source)) {
            return utils$2.merge({}, source);
        } else if (utils$2.isArray(source)) {
            return source.slice();
        }
        return source;
    }
    function mergeDeepProperties(prop) {
        if (!utils$2.isUndefined(config2[prop])) {
            return getMergedValue(config1[prop], config2[prop]);
        } else if (!utils$2.isUndefined(config1[prop])) {
            return getMergedValue(void 0, config1[prop]);
        }
    }
    function valueFromConfig2(prop) {
        if (!utils$2.isUndefined(config2[prop])) {
            return getMergedValue(void 0, config2[prop]);
        }
    }
    function defaultToConfig2(prop) {
        if (!utils$2.isUndefined(config2[prop])) {
            return getMergedValue(void 0, config2[prop]);
        } else if (!utils$2.isUndefined(config1[prop])) {
            return getMergedValue(void 0, config1[prop]);
        }
    }
    function mergeDirectKeys(prop) {
        if (prop in config2) {
            return getMergedValue(config1[prop], config2[prop]);
        } else if (prop in config1) {
            return getMergedValue(void 0, config1[prop]);
        }
    }
    var mergeMap = {
        url: valueFromConfig2,
        method: valueFromConfig2,
        data: valueFromConfig2,
        baseURL: defaultToConfig2,
        transformRequest: defaultToConfig2,
        transformResponse: defaultToConfig2,
        paramsSerializer: defaultToConfig2,
        timeout: defaultToConfig2,
        timeoutMessage: defaultToConfig2,
        withCredentials: defaultToConfig2,
        adapter: defaultToConfig2,
        responseType: defaultToConfig2,
        xsrfCookieName: defaultToConfig2,
        xsrfHeaderName: defaultToConfig2,
        onUploadProgress: defaultToConfig2,
        onDownloadProgress: defaultToConfig2,
        decompress: defaultToConfig2,
        maxContentLength: defaultToConfig2,
        maxBodyLength: defaultToConfig2,
        beforeRedirect: defaultToConfig2,
        transport: defaultToConfig2,
        httpAgent: defaultToConfig2,
        httpsAgent: defaultToConfig2,
        cancelToken: defaultToConfig2,
        socketPath: defaultToConfig2,
        responseEncoding: defaultToConfig2,
        validateStatus: mergeDirectKeys,
    };
    utils$2.forEach(
        Object.keys(config1).concat(Object.keys(config2)),
        function computeConfigValue(prop) {
            var merge2 = mergeMap[prop] || mergeDeepProperties;
            var configValue = merge2(prop);
            (utils$2.isUndefined(configValue) && merge2 !== mergeDirectKeys) ||
                (config3[prop] = configValue);
        }
    );
    return config3;
};
var data$3;
var hasRequiredData;
function requireData() {
    if (hasRequiredData) return data$3;
    hasRequiredData = 1;
    data$3 = {
        version: "0.27.2",
    };
    return data$3;
}
var VERSION = requireData().version;
var AxiosError = AxiosError_1;
var validators$1 = {};
["object", "boolean", "number", "function", "string", "symbol"].forEach(
    function (type, i) {
        validators$1[type] = function validator2(thing) {
            return typeof thing === type || "a" + (i < 1 ? "n " : " ") + type;
        };
    }
);
var deprecatedWarnings = {};
validators$1.transitional = function transitional2(
    validator2,
    version2,
    message
) {
    function formatMessage(opt, desc) {
        return (
            "[Axios v" +
            VERSION +
            "] Transitional option '" +
            opt +
            "'" +
            desc +
            (message ? ". " + message : "")
        );
    }
    return function (value, opt, opts) {
        if (validator2 === false) {
            throw new AxiosError(
                formatMessage(
                    opt,
                    " has been removed" + (version2 ? " in " + version2 : "")
                ),
                AxiosError.ERR_DEPRECATED
            );
        }
        if (version2 && !deprecatedWarnings[opt]) {
            deprecatedWarnings[opt] = true;
            console.warn(
                formatMessage(
                    opt,
                    " has been deprecated since v" +
                        version2 +
                        " and will be removed in the near future"
                )
            );
        }
        return validator2 ? validator2(value, opt, opts) : true;
    };
};
function assertOptions(options, schema, allowUnknown) {
    if (typeof options !== "object") {
        throw new AxiosError(
            "options must be an object",
            AxiosError.ERR_BAD_OPTION_VALUE
        );
    }
    var keys2 = Object.keys(options);
    var i = keys2.length;
    while (i-- > 0) {
        var opt = keys2[i];
        var validator2 = schema[opt];
        if (validator2) {
            var value = options[opt];
            var result = value === void 0 || validator2(value, opt, options);
            if (result !== true) {
                throw new AxiosError(
                    "option " + opt + " must be " + result,
                    AxiosError.ERR_BAD_OPTION_VALUE
                );
            }
            continue;
        }
        if (allowUnknown !== true) {
            throw new AxiosError(
                "Unknown option " + opt,
                AxiosError.ERR_BAD_OPTION
            );
        }
    }
}
var validator$1 = {
    assertOptions,
    validators: validators$1,
};
var utils$1 = utils$b;
var buildURL$1 = buildURL$2;
var InterceptorManager = InterceptorManager_1;
var dispatchRequest2 = dispatchRequest$1;
var mergeConfig$1 = mergeConfig$2;
var buildFullPath2 = buildFullPath$1;
var validator = validator$1;
var validators = validator.validators;
function Axios$1(instanceConfig) {
    this.defaults = instanceConfig;
    this.interceptors = {
        request: new InterceptorManager(),
        response: new InterceptorManager(),
    };
}
Axios$1.prototype.request = function request(configOrUrl, config2) {
    if (typeof configOrUrl === "string") {
        config2 = config2 || {};
        config2.url = configOrUrl;
    } else {
        config2 = configOrUrl || {};
    }
    config2 = mergeConfig$1(this.defaults, config2);
    if (config2.method) {
        config2.method = config2.method.toLowerCase();
    } else if (this.defaults.method) {
        config2.method = this.defaults.method.toLowerCase();
    } else {
        config2.method = "get";
    }
    var transitional3 = config2.transitional;
    if (transitional3 !== void 0) {
        validator.assertOptions(
            transitional3,
            {
                silentJSONParsing: validators.transitional(validators.boolean),
                forcedJSONParsing: validators.transitional(validators.boolean),
                clarifyTimeoutError: validators.transitional(
                    validators.boolean
                ),
            },
            false
        );
    }
    var requestInterceptorChain = [];
    var synchronousRequestInterceptors = true;
    this.interceptors.request.forEach(function unshiftRequestInterceptors(
        interceptor2
    ) {
        if (
            typeof interceptor2.runWhen === "function" &&
            interceptor2.runWhen(config2) === false
        ) {
            return;
        }
        synchronousRequestInterceptors =
            synchronousRequestInterceptors && interceptor2.synchronous;
        requestInterceptorChain.unshift(
            interceptor2.fulfilled,
            interceptor2.rejected
        );
    });
    var responseInterceptorChain = [];
    this.interceptors.response.forEach(function pushResponseInterceptors(
        interceptor2
    ) {
        responseInterceptorChain.push(
            interceptor2.fulfilled,
            interceptor2.rejected
        );
    });
    var promise;
    if (!synchronousRequestInterceptors) {
        var chain = [dispatchRequest2, void 0];
        Array.prototype.unshift.apply(chain, requestInterceptorChain);
        chain = chain.concat(responseInterceptorChain);
        promise = Promise.resolve(config2);
        while (chain.length) {
            promise = promise.then(chain.shift(), chain.shift());
        }
        return promise;
    }
    var newConfig = config2;
    while (requestInterceptorChain.length) {
        var onFulfilled = requestInterceptorChain.shift();
        var onRejected = requestInterceptorChain.shift();
        try {
            newConfig = onFulfilled(newConfig);
        } catch (error2) {
            onRejected(error2);
            break;
        }
    }
    try {
        promise = dispatchRequest2(newConfig);
    } catch (error2) {
        return Promise.reject(error2);
    }
    while (responseInterceptorChain.length) {
        promise = promise.then(
            responseInterceptorChain.shift(),
            responseInterceptorChain.shift()
        );
    }
    return promise;
};
Axios$1.prototype.getUri = function getUri(config2) {
    config2 = mergeConfig$1(this.defaults, config2);
    var fullPath = buildFullPath2(config2.baseURL, config2.url);
    return buildURL$1(fullPath, config2.params, config2.paramsSerializer);
};
utils$1.forEach(
    ["delete", "get", "head", "options"],
    function forEachMethodNoData2(method) {
        Axios$1.prototype[method] = function (url, config2) {
            return this.request(
                mergeConfig$1(config2 || {}, {
                    method,
                    url,
                    data: (config2 || {}).data,
                })
            );
        };
    }
);
utils$1.forEach(
    ["post", "put", "patch"],
    function forEachMethodWithData2(method) {
        function generateHTTPMethod(isForm) {
            return function httpMethod(url, data3, config2) {
                return this.request(
                    mergeConfig$1(config2 || {}, {
                        method,
                        headers: isForm
                            ? {
                                  "Content-Type": "multipart/form-data",
                              }
                            : {},
                        url,
                        data: data3,
                    })
                );
            };
        }
        Axios$1.prototype[method] = generateHTTPMethod();
        Axios$1.prototype[method + "Form"] = generateHTTPMethod(true);
    }
);
var Axios_1 = Axios$1;
var CancelToken_1;
var hasRequiredCancelToken;
function requireCancelToken() {
    if (hasRequiredCancelToken) return CancelToken_1;
    hasRequiredCancelToken = 1;
    var CanceledError2 = requireCanceledError();
    function CancelToken(executor) {
        if (typeof executor !== "function") {
            throw new TypeError("executor must be a function.");
        }
        var resolvePromise;
        this.promise = new Promise(function promiseExecutor(resolve) {
            resolvePromise = resolve;
        });
        var token = this;
        this.promise.then(function (cancel) {
            if (!token._listeners) return;
            var i;
            var l = token._listeners.length;
            for (i = 0; i < l; i++) {
                token._listeners[i](cancel);
            }
            token._listeners = null;
        });
        this.promise.then = function (onfulfilled) {
            var _resolve;
            var promise = new Promise(function (resolve) {
                token.subscribe(resolve);
                _resolve = resolve;
            }).then(onfulfilled);
            promise.cancel = function reject() {
                token.unsubscribe(_resolve);
            };
            return promise;
        };
        executor(function cancel(message) {
            if (token.reason) {
                return;
            }
            token.reason = new CanceledError2(message);
            resolvePromise(token.reason);
        });
    }
    CancelToken.prototype.throwIfRequested = function throwIfRequested() {
        if (this.reason) {
            throw this.reason;
        }
    };
    CancelToken.prototype.subscribe = function subscribe(listener) {
        if (this.reason) {
            listener(this.reason);
            return;
        }
        if (this._listeners) {
            this._listeners.push(listener);
        } else {
            this._listeners = [listener];
        }
    };
    CancelToken.prototype.unsubscribe = function unsubscribe(listener) {
        if (!this._listeners) {
            return;
        }
        var index2 = this._listeners.indexOf(listener);
        if (index2 !== -1) {
            this._listeners.splice(index2, 1);
        }
    };
    CancelToken.source = function source() {
        var cancel;
        var token = new CancelToken(function executor(c) {
            cancel = c;
        });
        return {
            token,
            cancel,
        };
    };
    CancelToken_1 = CancelToken;
    return CancelToken_1;
}
var spread;
var hasRequiredSpread;
function requireSpread() {
    if (hasRequiredSpread) return spread;
    hasRequiredSpread = 1;
    spread = function spread2(callback) {
        return function wrap(arr) {
            return callback.apply(null, arr);
        };
    };
    return spread;
}
var isAxiosError;
var hasRequiredIsAxiosError;
function requireIsAxiosError() {
    if (hasRequiredIsAxiosError) return isAxiosError;
    hasRequiredIsAxiosError = 1;
    var utils2 = utils$b;
    isAxiosError = function isAxiosError2(payload) {
        return utils2.isObject(payload) && payload.isAxiosError === true;
    };
    return isAxiosError;
}
var utils = utils$b;
var bind$3 = bind$5;
var Axios = Axios_1;
var mergeConfig2 = mergeConfig$2;
var defaults$1 = defaults_1;
function createInstance(defaultConfig) {
    var context = new Axios(defaultConfig);
    var instance = bind$3(Axios.prototype.request, context);
    utils.extend(instance, Axios.prototype, context);
    utils.extend(instance, context);
    instance.create = function create2(instanceConfig) {
        return createInstance(mergeConfig2(defaultConfig, instanceConfig));
    };
    return instance;
}
var axios$4 = createInstance(defaults$1);
axios$4.Axios = Axios;
axios$4.CanceledError = requireCanceledError();
axios$4.CancelToken = requireCancelToken();
axios$4.isCancel = requireIsCancel();
axios$4.VERSION = requireData().version;
axios$4.toFormData = toFormData_1;
axios$4.AxiosError = AxiosError_1;
axios$4.Cancel = axios$4.CanceledError;
axios$4.all = function all(promises) {
    return Promise.all(promises);
};
axios$4.spread = requireSpread();
axios$4.isAxiosError = requireIsAxiosError();
axios$5.exports = axios$4;
axios$5.exports.default = axios$4;
(function (module) {
    module.exports = axios$5.exports;
})(axios$6);
const axios$3 = /* @__PURE__ */ getDefaultExportFromCjs(axios$6.exports);
window._ = _;
window.axios = axios$3;
window.axios.defaults.headers.common["X-Requested-With"] = "XMLHttpRequest";
var flushPending = false;
var flushing$1 = false;
var queue$1 = [];
function scheduler(callback) {
    queueJob(callback);
}
function queueJob(job) {
    if (!queue$1.includes(job)) queue$1.push(job);
    queueFlush();
}
function dequeueJob(job) {
    let index2 = queue$1.indexOf(job);
    if (index2 !== -1) queue$1.splice(index2, 1);
}
function queueFlush() {
    if (!flushing$1 && !flushPending) {
        flushPending = true;
        queueMicrotask(flushJobs);
    }
}
function flushJobs() {
    flushPending = false;
    flushing$1 = true;
    for (let i = 0; i < queue$1.length; i++) {
        queue$1[i]();
    }
    queue$1.length = 0;
    flushing$1 = false;
}
var reactive;
var effect;
var release;
var raw;
var shouldSchedule = true;
function disableEffectScheduling(callback) {
    shouldSchedule = false;
    callback();
    shouldSchedule = true;
}
function setReactivityEngine(engine) {
    reactive = engine.reactive;
    release = engine.release;
    effect = (callback) =>
        engine.effect(callback, {
            scheduler: (task) => {
                if (shouldSchedule) {
                    scheduler(task);
                } else {
                    task();
                }
            },
        });
    raw = engine.raw;
}
function overrideEffect(override) {
    effect = override;
}
function elementBoundEffect(el) {
    let cleanup2 = () => {};
    let wrappedEffect = (callback) => {
        let effectReference = effect(callback);
        if (!el._x_effects) {
            el._x_effects = /* @__PURE__ */ new Set();
            el._x_runEffects = () => {
                el._x_effects.forEach((i) => i());
            };
        }
        el._x_effects.add(effectReference);
        cleanup2 = () => {
            if (effectReference === void 0) return;
            el._x_effects.delete(effectReference);
            release(effectReference);
        };
        return effectReference;
    };
    return [
        wrappedEffect,
        () => {
            cleanup2();
        },
    ];
}
var onAttributeAddeds = [];
var onElRemoveds = [];
var onElAddeds = [];
function onElAdded(callback) {
    onElAddeds.push(callback);
}
function onElRemoved(el, callback) {
    if (typeof callback === "function") {
        if (!el._x_cleanups) el._x_cleanups = [];
        el._x_cleanups.push(callback);
    } else {
        callback = el;
        onElRemoveds.push(callback);
    }
}
function onAttributesAdded(callback) {
    onAttributeAddeds.push(callback);
}
function onAttributeRemoved(el, name2, callback) {
    if (!el._x_attributeCleanups) el._x_attributeCleanups = {};
    if (!el._x_attributeCleanups[name2]) el._x_attributeCleanups[name2] = [];
    el._x_attributeCleanups[name2].push(callback);
}
function cleanupAttributes(el, names) {
    if (!el._x_attributeCleanups) return;
    Object.entries(el._x_attributeCleanups).forEach(([name2, value]) => {
        if (names === void 0 || names.includes(name2)) {
            value.forEach((i) => i());
            delete el._x_attributeCleanups[name2];
        }
    });
}
var observer$1 = new MutationObserver(onMutate);
var currentlyObserving = false;
function startObservingMutations() {
    observer$1.observe(document, {
        subtree: true,
        childList: true,
        attributes: true,
        attributeOldValue: true,
    });
    currentlyObserving = true;
}
function stopObservingMutations() {
    flushObserver();
    observer$1.disconnect();
    currentlyObserving = false;
}
var recordQueue = [];
var willProcessRecordQueue = false;
function flushObserver() {
    recordQueue = recordQueue.concat(observer$1.takeRecords());
    if (recordQueue.length && !willProcessRecordQueue) {
        willProcessRecordQueue = true;
        queueMicrotask(() => {
            processRecordQueue();
            willProcessRecordQueue = false;
        });
    }
}
function processRecordQueue() {
    onMutate(recordQueue);
    recordQueue.length = 0;
}
function mutateDom(callback) {
    if (!currentlyObserving) return callback();
    stopObservingMutations();
    let result = callback();
    startObservingMutations();
    return result;
}
var isCollecting = false;
var deferredMutations = [];
function deferMutations() {
    isCollecting = true;
}
function flushAndStopDeferringMutations() {
    isCollecting = false;
    onMutate(deferredMutations);
    deferredMutations = [];
}
function onMutate(mutations) {
    if (isCollecting) {
        deferredMutations = deferredMutations.concat(mutations);
        return;
    }
    let addedNodes = [];
    let removedNodes = [];
    let addedAttributes = /* @__PURE__ */ new Map();
    let removedAttributes = /* @__PURE__ */ new Map();
    for (let i = 0; i < mutations.length; i++) {
        if (mutations[i].target._x_ignoreMutationObserver) continue;
        if (mutations[i].type === "childList") {
            mutations[i].addedNodes.forEach(
                (node) => node.nodeType === 1 && addedNodes.push(node)
            );
            mutations[i].removedNodes.forEach(
                (node) => node.nodeType === 1 && removedNodes.push(node)
            );
        }
        if (mutations[i].type === "attributes") {
            let el = mutations[i].target;
            let name2 = mutations[i].attributeName;
            let oldValue = mutations[i].oldValue;
            let add2 = () => {
                if (!addedAttributes.has(el)) addedAttributes.set(el, []);
                addedAttributes
                    .get(el)
                    .push({ name: name2, value: el.getAttribute(name2) });
            };
            let remove2 = () => {
                if (!removedAttributes.has(el)) removedAttributes.set(el, []);
                removedAttributes.get(el).push(name2);
            };
            if (el.hasAttribute(name2) && oldValue === null) {
                add2();
            } else if (el.hasAttribute(name2)) {
                remove2();
                add2();
            } else {
                remove2();
            }
        }
    }
    removedAttributes.forEach((attrs2, el) => {
        cleanupAttributes(el, attrs2);
    });
    addedAttributes.forEach((attrs2, el) => {
        onAttributeAddeds.forEach((i) => i(el, attrs2));
    });
    for (let node of removedNodes) {
        if (addedNodes.includes(node)) continue;
        onElRemoveds.forEach((i) => i(node));
        if (node._x_cleanups) {
            while (node._x_cleanups.length) node._x_cleanups.pop()();
        }
    }
    addedNodes.forEach((node) => {
        node._x_ignoreSelf = true;
        node._x_ignore = true;
    });
    for (let node of addedNodes) {
        if (removedNodes.includes(node)) continue;
        if (!node.isConnected) continue;
        delete node._x_ignoreSelf;
        delete node._x_ignore;
        onElAddeds.forEach((i) => i(node));
        node._x_ignore = true;
        node._x_ignoreSelf = true;
    }
    addedNodes.forEach((node) => {
        delete node._x_ignoreSelf;
        delete node._x_ignore;
    });
    addedNodes = null;
    removedNodes = null;
    addedAttributes = null;
    removedAttributes = null;
}
function scope(node) {
    return mergeProxies(closestDataStack(node));
}
function addScopeToNode(node, data22, referenceNode) {
    node._x_dataStack = [data22, ...closestDataStack(referenceNode || node)];
    return () => {
        node._x_dataStack = node._x_dataStack.filter((i) => i !== data22);
    };
}
function refreshScope(element, scope2) {
    let existingScope = element._x_dataStack[0];
    Object.entries(scope2).forEach(([key, value]) => {
        existingScope[key] = value;
    });
}
function closestDataStack(node) {
    if (node._x_dataStack) return node._x_dataStack;
    if (typeof ShadowRoot === "function" && node instanceof ShadowRoot) {
        return closestDataStack(node.host);
    }
    if (!node.parentNode) {
        return [];
    }
    return closestDataStack(node.parentNode);
}
function mergeProxies(objects) {
    let thisProxy = new Proxy(
        {},
        {
            ownKeys: () => {
                return Array.from(
                    new Set(objects.flatMap((i) => Object.keys(i)))
                );
            },
            has: (target2, name2) => {
                return objects.some((obj) => obj.hasOwnProperty(name2));
            },
            get: (target2, name2) => {
                return (objects.find((obj) => {
                    if (obj.hasOwnProperty(name2)) {
                        let descriptor = Object.getOwnPropertyDescriptor(
                            obj,
                            name2
                        );
                        if (
                            (descriptor.get &&
                                descriptor.get._x_alreadyBound) ||
                            (descriptor.set && descriptor.set._x_alreadyBound)
                        ) {
                            return true;
                        }
                        if (
                            (descriptor.get || descriptor.set) &&
                            descriptor.enumerable
                        ) {
                            let getter = descriptor.get;
                            let setter = descriptor.set;
                            let property = descriptor;
                            getter = getter && getter.bind(thisProxy);
                            setter = setter && setter.bind(thisProxy);
                            if (getter) getter._x_alreadyBound = true;
                            if (setter) setter._x_alreadyBound = true;
                            Object.defineProperty(obj, name2, {
                                ...property,
                                get: getter,
                                set: setter,
                            });
                        }
                        return true;
                    }
                    return false;
                }) || {})[name2];
            },
            set: (target2, name2, value) => {
                let closestObjectWithKey = objects.find((obj) =>
                    obj.hasOwnProperty(name2)
                );
                if (closestObjectWithKey) {
                    closestObjectWithKey[name2] = value;
                } else {
                    objects[objects.length - 1][name2] = value;
                }
                return true;
            },
        }
    );
    return thisProxy;
}
function initInterceptors(data22) {
    let isObject2 = (val) =>
        typeof val === "object" && !Array.isArray(val) && val !== null;
    let recurse = (obj, basePath = "") => {
        Object.entries(Object.getOwnPropertyDescriptors(obj)).forEach(
            ([key, { value, enumerable }]) => {
                if (enumerable === false || value === void 0) return;
                let path = basePath === "" ? key : `${basePath}.${key}`;
                if (
                    typeof value === "object" &&
                    value !== null &&
                    value._x_interceptor
                ) {
                    obj[key] = value.initialize(data22, path, key);
                } else {
                    if (
                        isObject2(value) &&
                        value !== obj &&
                        !(value instanceof Element)
                    ) {
                        recurse(value, path);
                    }
                }
            }
        );
    };
    return recurse(data22);
}
function interceptor(callback, mutateObj = () => {}) {
    let obj = {
        initialValue: void 0,
        _x_interceptor: true,
        initialize(data22, path, key) {
            return callback(
                this.initialValue,
                () => get(data22, path),
                (value) => set$1(data22, path, value),
                path,
                key
            );
        },
    };
    mutateObj(obj);
    return (initialValue) => {
        if (
            typeof initialValue === "object" &&
            initialValue !== null &&
            initialValue._x_interceptor
        ) {
            let initialize = obj.initialize.bind(obj);
            obj.initialize = (data22, path, key) => {
                let innerValue = initialValue.initialize(data22, path, key);
                obj.initialValue = innerValue;
                return initialize(data22, path, key);
            };
        } else {
            obj.initialValue = initialValue;
        }
        return obj;
    };
}
function get(obj, path) {
    return path.split(".").reduce((carry, segment) => carry[segment], obj);
}
function set$1(obj, path, value) {
    if (typeof path === "string") path = path.split(".");
    if (path.length === 1) obj[path[0]] = value;
    else if (path.length === 0) throw error;
    else {
        if (obj[path[0]]) return set$1(obj[path[0]], path.slice(1), value);
        else {
            obj[path[0]] = {};
            return set$1(obj[path[0]], path.slice(1), value);
        }
    }
}
var magics = {};
function magic(name2, callback) {
    magics[name2] = callback;
}
function injectMagics(obj, el) {
    Object.entries(magics).forEach(([name2, callback]) => {
        Object.defineProperty(obj, `$${name2}`, {
            get() {
                let [utilities, cleanup2] = getElementBoundUtilities(el);
                utilities = { interceptor, ...utilities };
                onElRemoved(el, cleanup2);
                return callback(el, utilities);
            },
            enumerable: false,
        });
    });
    return obj;
}
function tryCatch(el, expression, callback, ...args) {
    try {
        return callback(...args);
    } catch (e) {
        handleError$1(e, el, expression);
    }
}
function handleError$1(error2, el, expression = void 0) {
    Object.assign(error2, { el, expression });
    console.warn(
        `Alpine Expression Error: ${error2.message}

${expression ? 'Expression: "' + expression + '"\n\n' : ""}`,
        el
    );
    setTimeout(() => {
        throw error2;
    }, 0);
}
var shouldAutoEvaluateFunctions = true;
function dontAutoEvaluateFunctions(callback) {
    let cache = shouldAutoEvaluateFunctions;
    shouldAutoEvaluateFunctions = false;
    callback();
    shouldAutoEvaluateFunctions = cache;
}
function evaluate(el, expression, extras = {}) {
    let result;
    evaluateLater(el, expression)((value) => (result = value), extras);
    return result;
}
function evaluateLater(...args) {
    return theEvaluatorFunction(...args);
}
var theEvaluatorFunction = normalEvaluator;
function setEvaluator(newEvaluator) {
    theEvaluatorFunction = newEvaluator;
}
function normalEvaluator(el, expression) {
    let overriddenMagics = {};
    injectMagics(overriddenMagics, el);
    let dataStack = [overriddenMagics, ...closestDataStack(el)];
    if (typeof expression === "function") {
        return generateEvaluatorFromFunction(dataStack, expression);
    }
    let evaluator = generateEvaluatorFromString(dataStack, expression, el);
    return tryCatch.bind(null, el, expression, evaluator);
}
function generateEvaluatorFromFunction(dataStack, func) {
    return (receiver = () => {}, { scope: scope2 = {}, params = [] } = {}) => {
        let result = func.apply(mergeProxies([scope2, ...dataStack]), params);
        runIfTypeOfFunction(receiver, result);
    };
}
var evaluatorMemo = {};
function generateFunctionFromString(expression, el) {
    if (evaluatorMemo[expression]) {
        return evaluatorMemo[expression];
    }
    let AsyncFunction = Object.getPrototypeOf(async function () {}).constructor;
    let rightSideSafeExpression =
        /^[\n\s]*if.*\(.*\)/.test(expression) ||
        /^(let|const)\s/.test(expression)
            ? `(() => { ${expression} })()`
            : expression;
    const safeAsyncFunction = () => {
        try {
            return new AsyncFunction(
                ["__self", "scope"],
                `with (scope) { __self.result = ${rightSideSafeExpression} }; __self.finished = true; return __self.result;`
            );
        } catch (error2) {
            handleError$1(error2, el, expression);
            return Promise.resolve();
        }
    };
    let func = safeAsyncFunction();
    evaluatorMemo[expression] = func;
    return func;
}
function generateEvaluatorFromString(dataStack, expression, el) {
    let func = generateFunctionFromString(expression, el);
    return (receiver = () => {}, { scope: scope2 = {}, params = [] } = {}) => {
        func.result = void 0;
        func.finished = false;
        let completeScope = mergeProxies([scope2, ...dataStack]);
        if (typeof func === "function") {
            let promise = func(func, completeScope).catch((error2) =>
                handleError$1(error2, el, expression)
            );
            if (func.finished) {
                runIfTypeOfFunction(
                    receiver,
                    func.result,
                    completeScope,
                    params,
                    el
                );
                func.result = void 0;
            } else {
                promise
                    .then((result) => {
                        runIfTypeOfFunction(
                            receiver,
                            result,
                            completeScope,
                            params,
                            el
                        );
                    })
                    .catch((error2) => handleError$1(error2, el, expression))
                    .finally(() => (func.result = void 0));
            }
        }
    };
}
function runIfTypeOfFunction(receiver, value, scope2, params, el) {
    if (shouldAutoEvaluateFunctions && typeof value === "function") {
        let result = value.apply(scope2, params);
        if (result instanceof Promise) {
            result
                .then((i) => runIfTypeOfFunction(receiver, i, scope2, params))
                .catch((error2) => handleError$1(error2, el, value));
        } else {
            receiver(result);
        }
    } else {
        receiver(value);
    }
}
var prefixAsString = "x-";
function prefix(subject = "") {
    return prefixAsString + subject;
}
function setPrefix(newPrefix) {
    prefixAsString = newPrefix;
}
var directiveHandlers = {};
function directive$2(name2, callback) {
    directiveHandlers[name2] = callback;
}
function directives$1(el, attributes, originalAttributeOverride) {
    attributes = Array.from(attributes);
    if (el._x_virtualDirectives) {
        let vAttributes = Object.entries(el._x_virtualDirectives).map(
            ([name2, value]) => ({ name: name2, value })
        );
        let staticAttributes = attributesOnly(vAttributes);
        vAttributes = vAttributes.map((attribute) => {
            if (
                staticAttributes.find((attr2) => attr2.name === attribute.name)
            ) {
                return {
                    name: `x-bind:${attribute.name}`,
                    value: `"${attribute.value}"`,
                };
            }
            return attribute;
        });
        attributes = attributes.concat(vAttributes);
    }
    let transformedAttributeMap = {};
    let directives2 = attributes
        .map(
            toTransformedAttributes(
                (newName, oldName) =>
                    (transformedAttributeMap[newName] = oldName)
            )
        )
        .filter(outNonAlpineAttributes)
        .map(
            toParsedDirectives(
                transformedAttributeMap,
                originalAttributeOverride
            )
        )
        .sort(byPriority);
    return directives2.map((directive2) => {
        return getDirectiveHandler(el, directive2);
    });
}
function attributesOnly(attributes) {
    return Array.from(attributes)
        .map(toTransformedAttributes())
        .filter((attr2) => !outNonAlpineAttributes(attr2));
}
var isDeferringHandlers = false;
var directiveHandlerStacks = /* @__PURE__ */ new Map();
var currentHandlerStackKey = Symbol();
function deferHandlingDirectives(callback) {
    isDeferringHandlers = true;
    let key = Symbol();
    currentHandlerStackKey = key;
    directiveHandlerStacks.set(key, []);
    let flushHandlers = () => {
        while (directiveHandlerStacks.get(key).length)
            directiveHandlerStacks.get(key).shift()();
        directiveHandlerStacks.delete(key);
    };
    let stopDeferring = () => {
        isDeferringHandlers = false;
        flushHandlers();
    };
    callback(flushHandlers);
    stopDeferring();
}
function getElementBoundUtilities(el) {
    let cleanups = [];
    let cleanup2 = (callback) => cleanups.push(callback);
    let [effect3, cleanupEffect] = elementBoundEffect(el);
    cleanups.push(cleanupEffect);
    let utilities = {
        Alpine: alpine_default,
        effect: effect3,
        cleanup: cleanup2,
        evaluateLater: evaluateLater.bind(evaluateLater, el),
        evaluate: evaluate.bind(evaluate, el),
    };
    let doCleanup = () => cleanups.forEach((i) => i());
    return [utilities, doCleanup];
}
function getDirectiveHandler(el, directive2) {
    let noop2 = () => {};
    let handler3 = directiveHandlers[directive2.type] || noop2;
    let [utilities, cleanup2] = getElementBoundUtilities(el);
    onAttributeRemoved(el, directive2.original, cleanup2);
    let fullHandler = () => {
        if (el._x_ignore || el._x_ignoreSelf) return;
        handler3.inline && handler3.inline(el, directive2, utilities);
        handler3 = handler3.bind(handler3, el, directive2, utilities);
        isDeferringHandlers
            ? directiveHandlerStacks.get(currentHandlerStackKey).push(handler3)
            : handler3();
    };
    fullHandler.runCleanups = cleanup2;
    return fullHandler;
}
var startingWith =
    (subject, replacement) =>
    ({ name: name2, value }) => {
        if (name2.startsWith(subject))
            name2 = name2.replace(subject, replacement);
        return { name: name2, value };
    };
var into = (i) => i;
function toTransformedAttributes(callback = () => {}) {
    return ({ name: name2, value }) => {
        let { name: newName, value: newValue } = attributeTransformers.reduce(
            (carry, transform) => {
                return transform(carry);
            },
            { name: name2, value }
        );
        if (newName !== name2) callback(newName, name2);
        return { name: newName, value: newValue };
    };
}
var attributeTransformers = [];
function mapAttributes(callback) {
    attributeTransformers.push(callback);
}
function outNonAlpineAttributes({ name: name2 }) {
    return alpineAttributeRegex().test(name2);
}
var alpineAttributeRegex = () => new RegExp(`^${prefixAsString}([^:^.]+)\\b`);
function toParsedDirectives(
    transformedAttributeMap,
    originalAttributeOverride
) {
    return ({ name: name2, value }) => {
        let typeMatch = name2.match(alpineAttributeRegex());
        let valueMatch = name2.match(/:([a-zA-Z0-9\-:]+)/);
        let modifiers2 = name2.match(/\.[^.\]]+(?=[^\]]*$)/g) || [];
        let original =
            originalAttributeOverride ||
            transformedAttributeMap[name2] ||
            name2;
        return {
            type: typeMatch ? typeMatch[1] : null,
            value: valueMatch ? valueMatch[1] : null,
            modifiers: modifiers2.map((i) => i.replace(".", "")),
            expression: value,
            original,
        };
    };
}
var DEFAULT = "DEFAULT";
var directiveOrder = [
    "ignore",
    "ref",
    "data",
    "id",
    "bind",
    "init",
    "for",
    "mask",
    "model",
    "modelable",
    "transition",
    "show",
    "if",
    DEFAULT,
    "teleport",
];
function byPriority(a, b) {
    let typeA = directiveOrder.indexOf(a.type) === -1 ? DEFAULT : a.type;
    let typeB = directiveOrder.indexOf(b.type) === -1 ? DEFAULT : b.type;
    return directiveOrder.indexOf(typeA) - directiveOrder.indexOf(typeB);
}
function dispatch(el, name2, detail = {}) {
    el.dispatchEvent(
        new CustomEvent(name2, {
            detail,
            bubbles: true,
            composed: true,
            cancelable: true,
        })
    );
}
var tickStack = [];
var isHolding = false;
function nextTick$1(callback = () => {}) {
    queueMicrotask(() => {
        isHolding ||
            setTimeout(() => {
                releaseNextTicks();
            });
    });
    return new Promise((res2) => {
        tickStack.push(() => {
            callback();
            res2();
        });
    });
}
function releaseNextTicks() {
    isHolding = false;
    while (tickStack.length) tickStack.shift()();
}
function holdNextTicks() {
    isHolding = true;
}
function walk(el, callback) {
    if (typeof ShadowRoot === "function" && el instanceof ShadowRoot) {
        Array.from(el.children).forEach((el2) => walk(el2, callback));
        return;
    }
    let skip = false;
    callback(el, () => (skip = true));
    if (skip) return;
    let node = el.firstElementChild;
    while (node) {
        walk(node, callback);
        node = node.nextElementSibling;
    }
}
function warn$1(message, ...args) {
    console.warn(`Alpine Warning: ${message}`, ...args);
}
function start() {
    if (!document.body)
        warn$1(
            "Unable to initialize. Trying to load Alpine before `<body>` is available. Did you forget to add `defer` in Alpine's `<script>` tag?"
        );
    dispatch(document, "alpine:init");
    dispatch(document, "alpine:initializing");
    startObservingMutations();
    onElAdded((el) => initTree(el, walk));
    onElRemoved((el) => destroyTree(el));
    onAttributesAdded((el, attrs2) => {
        directives$1(el, attrs2).forEach((handle) => handle());
    });
    let outNestedComponents = (el) => !closestRoot(el.parentElement, true);
    Array.from(document.querySelectorAll(allSelectors()))
        .filter(outNestedComponents)
        .forEach((el) => {
            initTree(el);
        });
    dispatch(document, "alpine:initialized");
}
var rootSelectorCallbacks = [];
var initSelectorCallbacks = [];
function rootSelectors() {
    return rootSelectorCallbacks.map((fn2) => fn2());
}
function allSelectors() {
    return rootSelectorCallbacks
        .concat(initSelectorCallbacks)
        .map((fn2) => fn2());
}
function addRootSelector(selectorCallback) {
    rootSelectorCallbacks.push(selectorCallback);
}
function addInitSelector(selectorCallback) {
    initSelectorCallbacks.push(selectorCallback);
}
function closestRoot(el, includeInitSelectors = false) {
    return findClosest(el, (element) => {
        const selectors = includeInitSelectors
            ? allSelectors()
            : rootSelectors();
        if (selectors.some((selector) => element.matches(selector)))
            return true;
    });
}
function findClosest(el, callback) {
    if (!el) return;
    if (callback(el)) return el;
    if (el._x_teleportBack) el = el._x_teleportBack;
    if (!el.parentElement) return;
    return findClosest(el.parentElement, callback);
}
function isRoot(el) {
    return rootSelectors().some((selector) => el.matches(selector));
}
function initTree(el, walker = walk) {
    deferHandlingDirectives(() => {
        walker(el, (el2, skip) => {
            directives$1(el2, el2.attributes).forEach((handle) => handle());
            el2._x_ignore && skip();
        });
    });
}
function destroyTree(root2) {
    walk(root2, (el) => cleanupAttributes(el));
}
function setClasses(el, value) {
    if (Array.isArray(value)) {
        return setClassesFromString(el, value.join(" "));
    } else if (typeof value === "object" && value !== null) {
        return setClassesFromObject(el, value);
    } else if (typeof value === "function") {
        return setClasses(el, value());
    }
    return setClassesFromString(el, value);
}
function setClassesFromString(el, classString) {
    let missingClasses = (classString2) =>
        classString2
            .split(" ")
            .filter((i) => !el.classList.contains(i))
            .filter(Boolean);
    let addClassesAndReturnUndo = (classes) => {
        el.classList.add(...classes);
        return () => {
            el.classList.remove(...classes);
        };
    };
    classString = classString === true ? (classString = "") : classString || "";
    return addClassesAndReturnUndo(missingClasses(classString));
}
function setClassesFromObject(el, classObject) {
    let split = (classString) => classString.split(" ").filter(Boolean);
    let forAdd = Object.entries(classObject)
        .flatMap(([classString, bool]) => (bool ? split(classString) : false))
        .filter(Boolean);
    let forRemove = Object.entries(classObject)
        .flatMap(([classString, bool]) => (!bool ? split(classString) : false))
        .filter(Boolean);
    let added = [];
    let removed = [];
    forRemove.forEach((i) => {
        if (el.classList.contains(i)) {
            el.classList.remove(i);
            removed.push(i);
        }
    });
    forAdd.forEach((i) => {
        if (!el.classList.contains(i)) {
            el.classList.add(i);
            added.push(i);
        }
    });
    return () => {
        removed.forEach((i) => el.classList.add(i));
        added.forEach((i) => el.classList.remove(i));
    };
}
function setStyles$1(el, value) {
    if (typeof value === "object" && value !== null) {
        return setStylesFromObject(el, value);
    }
    return setStylesFromString(el, value);
}
function setStylesFromObject(el, value) {
    let previousStyles = {};
    Object.entries(value).forEach(([key, value2]) => {
        previousStyles[key] = el.style[key];
        if (!key.startsWith("--")) {
            key = kebabCase(key);
        }
        el.style.setProperty(key, value2);
    });
    setTimeout(() => {
        if (el.style.length === 0) {
            el.removeAttribute("style");
        }
    });
    return () => {
        setStyles$1(el, previousStyles);
    };
}
function setStylesFromString(el, value) {
    let cache = el.getAttribute("style", value);
    el.setAttribute("style", value);
    return () => {
        el.setAttribute("style", cache || "");
    };
}
function kebabCase(subject) {
    return subject.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase();
}
function once$1(callback, fallback = () => {}) {
    let called = false;
    return function () {
        if (!called) {
            called = true;
            callback.apply(this, arguments);
        } else {
            fallback.apply(this, arguments);
        }
    };
}
directive$2(
    "transition",
    (
        el,
        { value, modifiers: modifiers2, expression },
        { evaluate: evaluate2 }
    ) => {
        if (typeof expression === "function")
            expression = evaluate2(expression);
        if (!expression) {
            registerTransitionsFromHelper(el, modifiers2, value);
        } else {
            registerTransitionsFromClassString(el, expression, value);
        }
    }
);
function registerTransitionsFromClassString(el, classString, stage) {
    registerTransitionObject(el, setClasses, "");
    let directiveStorageMap = {
        enter: (classes) => {
            el._x_transition.enter.during = classes;
        },
        "enter-start": (classes) => {
            el._x_transition.enter.start = classes;
        },
        "enter-end": (classes) => {
            el._x_transition.enter.end = classes;
        },
        leave: (classes) => {
            el._x_transition.leave.during = classes;
        },
        "leave-start": (classes) => {
            el._x_transition.leave.start = classes;
        },
        "leave-end": (classes) => {
            el._x_transition.leave.end = classes;
        },
    };
    directiveStorageMap[stage](classString);
}
function registerTransitionsFromHelper(el, modifiers2, stage) {
    registerTransitionObject(el, setStyles$1);
    let doesntSpecify =
        !modifiers2.includes("in") && !modifiers2.includes("out") && !stage;
    let transitioningIn =
        doesntSpecify || modifiers2.includes("in") || ["enter"].includes(stage);
    let transitioningOut =
        doesntSpecify ||
        modifiers2.includes("out") ||
        ["leave"].includes(stage);
    if (modifiers2.includes("in") && !doesntSpecify) {
        modifiers2 = modifiers2.filter(
            (i, index2) => index2 < modifiers2.indexOf("out")
        );
    }
    if (modifiers2.includes("out") && !doesntSpecify) {
        modifiers2 = modifiers2.filter(
            (i, index2) => index2 > modifiers2.indexOf("out")
        );
    }
    let wantsAll =
        !modifiers2.includes("opacity") && !modifiers2.includes("scale");
    let wantsOpacity = wantsAll || modifiers2.includes("opacity");
    let wantsScale = wantsAll || modifiers2.includes("scale");
    let opacityValue = wantsOpacity ? 0 : 1;
    let scaleValue = wantsScale
        ? modifierValue(modifiers2, "scale", 95) / 100
        : 1;
    let delay = modifierValue(modifiers2, "delay", 0);
    let origin = modifierValue(modifiers2, "origin", "center");
    let property = "opacity, transform";
    let durationIn = modifierValue(modifiers2, "duration", 150) / 1e3;
    let durationOut = modifierValue(modifiers2, "duration", 75) / 1e3;
    let easing = `cubic-bezier(0.4, 0.0, 0.2, 1)`;
    if (transitioningIn) {
        el._x_transition.enter.during = {
            transformOrigin: origin,
            transitionDelay: delay,
            transitionProperty: property,
            transitionDuration: `${durationIn}s`,
            transitionTimingFunction: easing,
        };
        el._x_transition.enter.start = {
            opacity: opacityValue,
            transform: `scale(${scaleValue})`,
        };
        el._x_transition.enter.end = {
            opacity: 1,
            transform: `scale(1)`,
        };
    }
    if (transitioningOut) {
        el._x_transition.leave.during = {
            transformOrigin: origin,
            transitionDelay: delay,
            transitionProperty: property,
            transitionDuration: `${durationOut}s`,
            transitionTimingFunction: easing,
        };
        el._x_transition.leave.start = {
            opacity: 1,
            transform: `scale(1)`,
        };
        el._x_transition.leave.end = {
            opacity: opacityValue,
            transform: `scale(${scaleValue})`,
        };
    }
}
function registerTransitionObject(el, setFunction, defaultValue = {}) {
    if (!el._x_transition)
        el._x_transition = {
            enter: {
                during: defaultValue,
                start: defaultValue,
                end: defaultValue,
            },
            leave: {
                during: defaultValue,
                start: defaultValue,
                end: defaultValue,
            },
            in(before = () => {}, after = () => {}) {
                transition$1(
                    el,
                    setFunction,
                    {
                        during: this.enter.during,
                        start: this.enter.start,
                        end: this.enter.end,
                    },
                    before,
                    after
                );
            },
            out(before = () => {}, after = () => {}) {
                transition$1(
                    el,
                    setFunction,
                    {
                        during: this.leave.during,
                        start: this.leave.start,
                        end: this.leave.end,
                    },
                    before,
                    after
                );
            },
        };
}
window.Element.prototype._x_toggleAndCascadeWithTransitions = function (
    el,
    value,
    show3,
    hide3
) {
    const nextTick2 =
        document.visibilityState === "visible"
            ? requestAnimationFrame
            : setTimeout;
    let clickAwayCompatibleShow = () => nextTick2(show3);
    if (value) {
        if (
            el._x_transition &&
            (el._x_transition.enter || el._x_transition.leave)
        ) {
            el._x_transition.enter &&
            (Object.entries(el._x_transition.enter.during).length ||
                Object.entries(el._x_transition.enter.start).length ||
                Object.entries(el._x_transition.enter.end).length)
                ? el._x_transition.in(show3)
                : clickAwayCompatibleShow();
        } else {
            el._x_transition
                ? el._x_transition.in(show3)
                : clickAwayCompatibleShow();
        }
        return;
    }
    el._x_hidePromise = el._x_transition
        ? new Promise((resolve, reject) => {
              el._x_transition.out(
                  () => {},
                  () => resolve(hide3)
              );
              el._x_transitioning.beforeCancel(() =>
                  reject({ isFromCancelledTransition: true })
              );
          })
        : Promise.resolve(hide3);
    queueMicrotask(() => {
        let closest = closestHide(el);
        if (closest) {
            if (!closest._x_hideChildren) closest._x_hideChildren = [];
            closest._x_hideChildren.push(el);
        } else {
            nextTick2(() => {
                let hideAfterChildren = (el2) => {
                    let carry = Promise.all([
                        el2._x_hidePromise,
                        ...(el2._x_hideChildren || []).map(hideAfterChildren),
                    ]).then(([i]) => i());
                    delete el2._x_hidePromise;
                    delete el2._x_hideChildren;
                    return carry;
                };
                hideAfterChildren(el).catch((e) => {
                    if (!e.isFromCancelledTransition) throw e;
                });
            });
        }
    });
};
function closestHide(el) {
    let parent = el.parentNode;
    if (!parent) return;
    return parent._x_hidePromise ? parent : closestHide(parent);
}
function transition$1(
    el,
    setFunction,
    { during, start: start2, end } = {},
    before = () => {},
    after = () => {}
) {
    if (el._x_transitioning) el._x_transitioning.cancel();
    if (
        Object.keys(during).length === 0 &&
        Object.keys(start2).length === 0 &&
        Object.keys(end).length === 0
    ) {
        before();
        after();
        return;
    }
    let undoStart, undoDuring, undoEnd;
    performTransition(el, {
        start() {
            undoStart = setFunction(el, start2);
        },
        during() {
            undoDuring = setFunction(el, during);
        },
        before,
        end() {
            undoStart();
            undoEnd = setFunction(el, end);
        },
        after,
        cleanup() {
            undoDuring();
            undoEnd();
        },
    });
}
function performTransition(el, stages) {
    let interrupted, reachedBefore, reachedEnd;
    let finish = once$1(() => {
        mutateDom(() => {
            interrupted = true;
            if (!reachedBefore) stages.before();
            if (!reachedEnd) {
                stages.end();
                releaseNextTicks();
            }
            stages.after();
            if (el.isConnected) stages.cleanup();
            delete el._x_transitioning;
        });
    });
    el._x_transitioning = {
        beforeCancels: [],
        beforeCancel(callback) {
            this.beforeCancels.push(callback);
        },
        cancel: once$1(function () {
            while (this.beforeCancels.length) {
                this.beforeCancels.shift()();
            }
            finish();
        }),
        finish,
    };
    mutateDom(() => {
        stages.start();
        stages.during();
    });
    holdNextTicks();
    requestAnimationFrame(() => {
        if (interrupted) return;
        let duration =
            Number(
                getComputedStyle(el)
                    .transitionDuration.replace(/,.*/, "")
                    .replace("s", "")
            ) * 1e3;
        let delay =
            Number(
                getComputedStyle(el)
                    .transitionDelay.replace(/,.*/, "")
                    .replace("s", "")
            ) * 1e3;
        if (duration === 0)
            duration =
                Number(
                    getComputedStyle(el).animationDuration.replace("s", "")
                ) * 1e3;
        mutateDom(() => {
            stages.before();
        });
        reachedBefore = true;
        requestAnimationFrame(() => {
            if (interrupted) return;
            mutateDom(() => {
                stages.end();
            });
            releaseNextTicks();
            setTimeout(el._x_transitioning.finish, duration + delay);
            reachedEnd = true;
        });
    });
}
function modifierValue(modifiers2, key, fallback) {
    if (modifiers2.indexOf(key) === -1) return fallback;
    const rawValue = modifiers2[modifiers2.indexOf(key) + 1];
    if (!rawValue) return fallback;
    if (key === "scale") {
        if (isNaN(rawValue)) return fallback;
    }
    if (key === "duration") {
        let match = rawValue.match(/([0-9]+)ms/);
        if (match) return match[1];
    }
    if (key === "origin") {
        if (
            ["top", "right", "left", "center", "bottom"].includes(
                modifiers2[modifiers2.indexOf(key) + 2]
            )
        ) {
            return [rawValue, modifiers2[modifiers2.indexOf(key) + 2]].join(
                " "
            );
        }
    }
    return rawValue;
}
var isCloning = false;
function skipDuringClone(callback, fallback = () => {}) {
    return (...args) => (isCloning ? fallback(...args) : callback(...args));
}
function clone(oldEl, newEl) {
    if (!newEl._x_dataStack) newEl._x_dataStack = oldEl._x_dataStack;
    isCloning = true;
    dontRegisterReactiveSideEffects(() => {
        cloneTree(newEl);
    });
    isCloning = false;
}
function cloneTree(el) {
    let hasRunThroughFirstEl = false;
    let shallowWalker = (el2, callback) => {
        walk(el2, (el3, skip) => {
            if (hasRunThroughFirstEl && isRoot(el3)) return skip();
            hasRunThroughFirstEl = true;
            callback(el3, skip);
        });
    };
    initTree(el, shallowWalker);
}
function dontRegisterReactiveSideEffects(callback) {
    let cache = effect;
    overrideEffect((callback2, el) => {
        let storedEffect = cache(callback2);
        release(storedEffect);
        return () => {};
    });
    callback();
    overrideEffect(cache);
}
function bind$2(el, name2, value, modifiers2 = []) {
    if (!el._x_bindings) el._x_bindings = reactive({});
    el._x_bindings[name2] = value;
    name2 = modifiers2.includes("camel") ? camelCase(name2) : name2;
    switch (name2) {
        case "value":
            bindInputValue(el, value);
            break;
        case "style":
            bindStyles(el, value);
            break;
        case "class":
            bindClasses(el, value);
            break;
        default:
            bindAttribute(el, name2, value);
            break;
    }
}
function bindInputValue(el, value) {
    if (el.type === "radio") {
        if (el.attributes.value === void 0) {
            el.value = value;
        }
        if (window.fromModel) {
            el.checked = checkedAttrLooseCompare(el.value, value);
        }
    } else if (el.type === "checkbox") {
        if (Number.isInteger(value)) {
            el.value = value;
        } else if (
            !Number.isInteger(value) &&
            !Array.isArray(value) &&
            typeof value !== "boolean" &&
            ![null, void 0].includes(value)
        ) {
            el.value = String(value);
        } else {
            if (Array.isArray(value)) {
                el.checked = value.some((val) =>
                    checkedAttrLooseCompare(val, el.value)
                );
            } else {
                el.checked = !!value;
            }
        }
    } else if (el.tagName === "SELECT") {
        updateSelect(el, value);
    } else {
        if (el.value === value) return;
        el.value = value;
    }
}
function bindClasses(el, value) {
    if (el._x_undoAddedClasses) el._x_undoAddedClasses();
    el._x_undoAddedClasses = setClasses(el, value);
}
function bindStyles(el, value) {
    if (el._x_undoAddedStyles) el._x_undoAddedStyles();
    el._x_undoAddedStyles = setStyles$1(el, value);
}
function bindAttribute(el, name2, value) {
    if (
        [null, void 0, false].includes(value) &&
        attributeShouldntBePreservedIfFalsy(name2)
    ) {
        el.removeAttribute(name2);
    } else {
        if (isBooleanAttr$1(name2)) value = name2;
        setIfChanged(el, name2, value);
    }
}
function setIfChanged(el, attrName, value) {
    if (el.getAttribute(attrName) != value) {
        el.setAttribute(attrName, value);
    }
}
function updateSelect(el, value) {
    const arrayWrappedValue = [].concat(value).map((value2) => {
        return value2 + "";
    });
    Array.from(el.options).forEach((option2) => {
        option2.selected = arrayWrappedValue.includes(option2.value);
    });
}
function camelCase(subject) {
    return subject
        .toLowerCase()
        .replace(/-(\w)/g, (match, char) => char.toUpperCase());
}
function checkedAttrLooseCompare(valueA, valueB) {
    return valueA == valueB;
}
function isBooleanAttr$1(attrName) {
    const booleanAttributes = [
        "disabled",
        "checked",
        "required",
        "readonly",
        "hidden",
        "open",
        "selected",
        "autofocus",
        "itemscope",
        "multiple",
        "novalidate",
        "allowfullscreen",
        "allowpaymentrequest",
        "formnovalidate",
        "autoplay",
        "controls",
        "loop",
        "muted",
        "playsinline",
        "default",
        "ismap",
        "reversed",
        "async",
        "defer",
        "nomodule",
    ];
    return booleanAttributes.includes(attrName);
}
function attributeShouldntBePreservedIfFalsy(name2) {
    return ![
        "aria-pressed",
        "aria-checked",
        "aria-expanded",
        "aria-selected",
    ].includes(name2);
}
function getBinding(el, name2, fallback) {
    if (el._x_bindings && el._x_bindings[name2] !== void 0)
        return el._x_bindings[name2];
    let attr2 = el.getAttribute(name2);
    if (attr2 === null)
        return typeof fallback === "function" ? fallback() : fallback;
    if (isBooleanAttr$1(name2)) {
        return !![name2, "true"].includes(attr2);
    }
    if (attr2 === "") return true;
    return attr2;
}
function debounce$2(func, wait) {
    var timeout;
    return function () {
        var context = this,
            args = arguments;
        var later = function () {
            timeout = null;
            func.apply(context, args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}
function throttle(func, limit2) {
    let inThrottle;
    return function () {
        let context = this,
            args = arguments;
        if (!inThrottle) {
            func.apply(context, args);
            inThrottle = true;
            setTimeout(() => (inThrottle = false), limit2);
        }
    };
}
function plugin$4(callback) {
    callback(alpine_default);
}
var stores = {};
var isReactive = false;
function store(name2, value) {
    if (!isReactive) {
        stores = reactive(stores);
        isReactive = true;
    }
    if (value === void 0) {
        return stores[name2];
    }
    stores[name2] = value;
    if (
        typeof value === "object" &&
        value !== null &&
        value.hasOwnProperty("init") &&
        typeof value.init === "function"
    ) {
        stores[name2].init();
    }
    initInterceptors(stores[name2]);
}
function getStores() {
    return stores;
}
var binds = {};
function bind2(name2, bindings) {
    let getBindings =
        typeof bindings !== "function" ? () => bindings : bindings;
    if (name2 instanceof Element) {
        applyBindingsObject(name2, getBindings());
    } else {
        binds[name2] = getBindings;
    }
}
function injectBindingProviders(obj) {
    Object.entries(binds).forEach(([name2, callback]) => {
        Object.defineProperty(obj, name2, {
            get() {
                return (...args) => {
                    return callback(...args);
                };
            },
        });
    });
    return obj;
}
function applyBindingsObject(el, obj, original) {
    let cleanupRunners = [];
    while (cleanupRunners.length) cleanupRunners.pop()();
    let attributes = Object.entries(obj).map(([name2, value]) => ({
        name: name2,
        value,
    }));
    let staticAttributes = attributesOnly(attributes);
    attributes = attributes.map((attribute) => {
        if (staticAttributes.find((attr2) => attr2.name === attribute.name)) {
            return {
                name: `x-bind:${attribute.name}`,
                value: `"${attribute.value}"`,
            };
        }
        return attribute;
    });
    directives$1(el, attributes, original).map((handle) => {
        cleanupRunners.push(handle.runCleanups);
        handle();
    });
}
var datas = {};
function data$2(name2, callback) {
    datas[name2] = callback;
}
function injectDataProviders(obj, context) {
    Object.entries(datas).forEach(([name2, callback]) => {
        Object.defineProperty(obj, name2, {
            get() {
                return (...args) => {
                    return callback.bind(context)(...args);
                };
            },
            enumerable: false,
        });
    });
    return obj;
}
var Alpine = {
    get reactive() {
        return reactive;
    },
    get release() {
        return release;
    },
    get effect() {
        return effect;
    },
    get raw() {
        return raw;
    },
    version: "3.10.3",
    flushAndStopDeferringMutations,
    dontAutoEvaluateFunctions,
    disableEffectScheduling,
    setReactivityEngine,
    closestDataStack,
    skipDuringClone,
    addRootSelector,
    addInitSelector,
    addScopeToNode,
    deferMutations,
    mapAttributes,
    evaluateLater,
    setEvaluator,
    mergeProxies,
    findClosest,
    closestRoot,
    interceptor,
    transition: transition$1,
    setStyles: setStyles$1,
    mutateDom,
    directive: directive$2,
    throttle,
    debounce: debounce$2,
    evaluate,
    initTree,
    nextTick: nextTick$1,
    prefixed: prefix,
    prefix: setPrefix,
    plugin: plugin$4,
    magic,
    store,
    start,
    clone,
    bound: getBinding,
    $data: scope,
    data: data$2,
    bind: bind2,
};
var alpine_default = Alpine;
function makeMap$1(str, expectsLowerCase) {
    const map2 = /* @__PURE__ */ Object.create(null);
    const list2 = str.split(",");
    for (let i = 0; i < list2.length; i++) {
        map2[list2[i]] = true;
    }
    return expectsLowerCase
        ? (val) => !!map2[val.toLowerCase()]
        : (val) => !!map2[val];
}
var EMPTY_OBJ = Object.freeze({});
Object.freeze([]);
var extend$1 = Object.assign;
var hasOwnProperty$d = Object.prototype.hasOwnProperty;
var hasOwn$1 = (val, key) => hasOwnProperty$d.call(val, key);
var isArray$7 = Array.isArray;
var isMap = (val) => toTypeString(val) === "[object Map]";
var isString$2 = (val) => typeof val === "string";
var isSymbol = (val) => typeof val === "symbol";
var isObject$b = (val) => val !== null && typeof val === "object";
var objectToString$2 = Object.prototype.toString;
var toTypeString = (value) => objectToString$2.call(value);
var toRawType$1 = (value) => {
    return toTypeString(value).slice(8, -1);
};
var isIntegerKey = (key) =>
    isString$2(key) &&
    key !== "NaN" &&
    key[0] !== "-" &&
    "" + parseInt(key, 10) === key;
var cacheStringFunction = (fn2) => {
    const cache = /* @__PURE__ */ Object.create(null);
    return (str) => {
        const hit = cache[str];
        return hit || (cache[str] = fn2(str));
    };
};
var capitalize$1 = cacheStringFunction(
    (str) => str.charAt(0).toUpperCase() + str.slice(1)
);
var hasChanged$1 = (value, oldValue) =>
    value !== oldValue && (value === value || oldValue === oldValue);
var targetMap = /* @__PURE__ */ new WeakMap();
var effectStack = [];
var activeEffect;
var ITERATE_KEY = Symbol("iterate");
var MAP_KEY_ITERATE_KEY = Symbol("Map key iterate");
function isEffect(fn2) {
    return fn2 && fn2._isEffect === true;
}
function effect2(fn2, options = EMPTY_OBJ) {
    if (isEffect(fn2)) {
        fn2 = fn2.raw;
    }
    const effect3 = createReactiveEffect(fn2, options);
    if (!options.lazy) {
        effect3();
    }
    return effect3;
}
function stop(effect3) {
    if (effect3.active) {
        cleanup(effect3);
        if (effect3.options.onStop) {
            effect3.options.onStop();
        }
        effect3.active = false;
    }
}
var uid$3 = 0;
function createReactiveEffect(fn2, options) {
    const effect3 = function reactiveEffect() {
        if (!effect3.active) {
            return fn2();
        }
        if (!effectStack.includes(effect3)) {
            cleanup(effect3);
            try {
                enableTracking();
                effectStack.push(effect3);
                activeEffect = effect3;
                return fn2();
            } finally {
                effectStack.pop();
                resetTracking();
                activeEffect = effectStack[effectStack.length - 1];
            }
        }
    };
    effect3.id = uid$3++;
    effect3.allowRecurse = !!options.allowRecurse;
    effect3._isEffect = true;
    effect3.active = true;
    effect3.raw = fn2;
    effect3.deps = [];
    effect3.options = options;
    return effect3;
}
function cleanup(effect3) {
    const { deps } = effect3;
    if (deps.length) {
        for (let i = 0; i < deps.length; i++) {
            deps[i].delete(effect3);
        }
        deps.length = 0;
    }
}
var shouldTrack = true;
var trackStack = [];
function pauseTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = false;
}
function enableTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = true;
}
function resetTracking() {
    const last = trackStack.pop();
    shouldTrack = last === void 0 ? true : last;
}
function track(target2, type, key) {
    if (!shouldTrack || activeEffect === void 0) {
        return;
    }
    let depsMap = targetMap.get(target2);
    if (!depsMap) {
        targetMap.set(target2, (depsMap = /* @__PURE__ */ new Map()));
    }
    let dep = depsMap.get(key);
    if (!dep) {
        depsMap.set(key, (dep = /* @__PURE__ */ new Set()));
    }
    if (!dep.has(activeEffect)) {
        dep.add(activeEffect);
        activeEffect.deps.push(dep);
        if (activeEffect.options.onTrack) {
            activeEffect.options.onTrack({
                effect: activeEffect,
                target: target2,
                type,
                key,
            });
        }
    }
}
function trigger$1(target2, type, key, newValue, oldValue, oldTarget) {
    const depsMap = targetMap.get(target2);
    if (!depsMap) {
        return;
    }
    const effects = /* @__PURE__ */ new Set();
    const add2 = (effectsToAdd) => {
        if (effectsToAdd) {
            effectsToAdd.forEach((effect3) => {
                if (effect3 !== activeEffect || effect3.allowRecurse) {
                    effects.add(effect3);
                }
            });
        }
    };
    if (type === "clear") {
        depsMap.forEach(add2);
    } else if (key === "length" && isArray$7(target2)) {
        depsMap.forEach((dep, key2) => {
            if (key2 === "length" || key2 >= newValue) {
                add2(dep);
            }
        });
    } else {
        if (key !== void 0) {
            add2(depsMap.get(key));
        }
        switch (type) {
            case "add":
                if (!isArray$7(target2)) {
                    add2(depsMap.get(ITERATE_KEY));
                    if (isMap(target2)) {
                        add2(depsMap.get(MAP_KEY_ITERATE_KEY));
                    }
                } else if (isIntegerKey(key)) {
                    add2(depsMap.get("length"));
                }
                break;
            case "delete":
                if (!isArray$7(target2)) {
                    add2(depsMap.get(ITERATE_KEY));
                    if (isMap(target2)) {
                        add2(depsMap.get(MAP_KEY_ITERATE_KEY));
                    }
                }
                break;
            case "set":
                if (isMap(target2)) {
                    add2(depsMap.get(ITERATE_KEY));
                }
                break;
        }
    }
    const run2 = (effect3) => {
        if (effect3.options.onTrigger) {
            effect3.options.onTrigger({
                effect: effect3,
                target: target2,
                key,
                type,
                newValue,
                oldValue,
                oldTarget,
            });
        }
        if (effect3.options.scheduler) {
            effect3.options.scheduler(effect3);
        } else {
            effect3();
        }
    };
    effects.forEach(run2);
}
var isNonTrackableKeys = /* @__PURE__ */ makeMap$1(
    `__proto__,__v_isRef,__isVue`
);
var builtInSymbols = new Set(
    Object.getOwnPropertyNames(Symbol)
        .map((key) => Symbol[key])
        .filter(isSymbol)
);
var get2 = /* @__PURE__ */ createGetter();
var shallowGet = /* @__PURE__ */ createGetter(false, true);
var readonlyGet = /* @__PURE__ */ createGetter(true);
var shallowReadonlyGet = /* @__PURE__ */ createGetter(true, true);
var arrayInstrumentations = {};
["includes", "indexOf", "lastIndexOf"].forEach((key) => {
    const method = Array.prototype[key];
    arrayInstrumentations[key] = function (...args) {
        const arr = toRaw(this);
        for (let i = 0, l = this.length; i < l; i++) {
            track(arr, "get", i + "");
        }
        const res2 = method.apply(arr, args);
        if (res2 === -1 || res2 === false) {
            return method.apply(arr, args.map(toRaw));
        } else {
            return res2;
        }
    };
});
["push", "pop", "shift", "unshift", "splice"].forEach((key) => {
    const method = Array.prototype[key];
    arrayInstrumentations[key] = function (...args) {
        pauseTracking();
        const res2 = method.apply(this, args);
        resetTracking();
        return res2;
    };
});
function createGetter(isReadonly2 = false, shallow = false) {
    return function get3(target2, key, receiver) {
        if (key === "__v_isReactive") {
            return !isReadonly2;
        } else if (key === "__v_isReadonly") {
            return isReadonly2;
        } else if (
            key === "__v_raw" &&
            receiver ===
                (isReadonly2
                    ? shallow
                        ? shallowReadonlyMap
                        : readonlyMap
                    : shallow
                    ? shallowReactiveMap
                    : reactiveMap
                ).get(target2)
        ) {
            return target2;
        }
        const targetIsArray = isArray$7(target2);
        if (
            !isReadonly2 &&
            targetIsArray &&
            hasOwn$1(arrayInstrumentations, key)
        ) {
            return Reflect.get(arrayInstrumentations, key, receiver);
        }
        const res2 = Reflect.get(target2, key, receiver);
        if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
            return res2;
        }
        if (!isReadonly2) {
            track(target2, "get", key);
        }
        if (shallow) {
            return res2;
        }
        if (isRef$1(res2)) {
            const shouldUnwrap = !targetIsArray || !isIntegerKey(key);
            return shouldUnwrap ? res2.value : res2;
        }
        if (isObject$b(res2)) {
            return isReadonly2 ? readonly(res2) : reactive2(res2);
        }
        return res2;
    };
}
var set2 = /* @__PURE__ */ createSetter();
var shallowSet = /* @__PURE__ */ createSetter(true);
function createSetter(shallow = false) {
    return function set3(target2, key, value, receiver) {
        let oldValue = target2[key];
        if (!shallow) {
            value = toRaw(value);
            oldValue = toRaw(oldValue);
            if (!isArray$7(target2) && isRef$1(oldValue) && !isRef$1(value)) {
                oldValue.value = value;
                return true;
            }
        }
        const hadKey =
            isArray$7(target2) && isIntegerKey(key)
                ? Number(key) < target2.length
                : hasOwn$1(target2, key);
        const result = Reflect.set(target2, key, value, receiver);
        if (target2 === toRaw(receiver)) {
            if (!hadKey) {
                trigger$1(target2, "add", key, value);
            } else if (hasChanged$1(value, oldValue)) {
                trigger$1(target2, "set", key, value, oldValue);
            }
        }
        return result;
    };
}
function deleteProperty(target2, key) {
    const hadKey = hasOwn$1(target2, key);
    const oldValue = target2[key];
    const result = Reflect.deleteProperty(target2, key);
    if (result && hadKey) {
        trigger$1(target2, "delete", key, void 0, oldValue);
    }
    return result;
}
function has$1(target2, key) {
    const result = Reflect.has(target2, key);
    if (!isSymbol(key) || !builtInSymbols.has(key)) {
        track(target2, "has", key);
    }
    return result;
}
function ownKeys$3(target2) {
    track(target2, "iterate", isArray$7(target2) ? "length" : ITERATE_KEY);
    return Reflect.ownKeys(target2);
}
var mutableHandlers = {
    get: get2,
    set: set2,
    deleteProperty,
    has: has$1,
    ownKeys: ownKeys$3,
};
var readonlyHandlers = {
    get: readonlyGet,
    set(target2, key) {
        {
            console.warn(
                `Set operation on key "${String(
                    key
                )}" failed: target is readonly.`,
                target2
            );
        }
        return true;
    },
    deleteProperty(target2, key) {
        {
            console.warn(
                `Delete operation on key "${String(
                    key
                )}" failed: target is readonly.`,
                target2
            );
        }
        return true;
    },
};
extend$1({}, mutableHandlers, {
    get: shallowGet,
    set: shallowSet,
});
extend$1({}, readonlyHandlers, {
    get: shallowReadonlyGet,
});
var toReactive = (value) => (isObject$b(value) ? reactive2(value) : value);
var toReadonly = (value) => (isObject$b(value) ? readonly(value) : value);
var toShallow = (value) => value;
var getProto = (v) => Reflect.getPrototypeOf(v);
function get$1(target2, key, isReadonly2 = false, isShallow = false) {
    target2 = target2["__v_raw"];
    const rawTarget = toRaw(target2);
    const rawKey = toRaw(key);
    if (key !== rawKey) {
        !isReadonly2 && track(rawTarget, "get", key);
    }
    !isReadonly2 && track(rawTarget, "get", rawKey);
    const { has: has2 } = getProto(rawTarget);
    const wrap = isShallow ? toShallow : isReadonly2 ? toReadonly : toReactive;
    if (has2.call(rawTarget, key)) {
        return wrap(target2.get(key));
    } else if (has2.call(rawTarget, rawKey)) {
        return wrap(target2.get(rawKey));
    } else if (target2 !== rawTarget) {
        target2.get(key);
    }
}
function has$1$1(key, isReadonly2 = false) {
    const target2 = this["__v_raw"];
    const rawTarget = toRaw(target2);
    const rawKey = toRaw(key);
    if (key !== rawKey) {
        !isReadonly2 && track(rawTarget, "has", key);
    }
    !isReadonly2 && track(rawTarget, "has", rawKey);
    return key === rawKey
        ? target2.has(key)
        : target2.has(key) || target2.has(rawKey);
}
function size(target2, isReadonly2 = false) {
    target2 = target2["__v_raw"];
    !isReadonly2 && track(toRaw(target2), "iterate", ITERATE_KEY);
    return Reflect.get(target2, "size", target2);
}
function add$2(value) {
    value = toRaw(value);
    const target2 = toRaw(this);
    const proto = getProto(target2);
    const hadKey = proto.has.call(target2, value);
    if (!hadKey) {
        target2.add(value);
        trigger$1(target2, "add", value, value);
    }
    return this;
}
function set$1$1(key, value) {
    value = toRaw(value);
    const target2 = toRaw(this);
    const { has: has2, get: get3 } = getProto(target2);
    let hadKey = has2.call(target2, key);
    if (!hadKey) {
        key = toRaw(key);
        hadKey = has2.call(target2, key);
    } else {
        checkIdentityKeys(target2, has2, key);
    }
    const oldValue = get3.call(target2, key);
    target2.set(key, value);
    if (!hadKey) {
        trigger$1(target2, "add", key, value);
    } else if (hasChanged$1(value, oldValue)) {
        trigger$1(target2, "set", key, value, oldValue);
    }
    return this;
}
function deleteEntry(key) {
    const target2 = toRaw(this);
    const { has: has2, get: get3 } = getProto(target2);
    let hadKey = has2.call(target2, key);
    if (!hadKey) {
        key = toRaw(key);
        hadKey = has2.call(target2, key);
    } else {
        checkIdentityKeys(target2, has2, key);
    }
    const oldValue = get3 ? get3.call(target2, key) : void 0;
    const result = target2.delete(key);
    if (hadKey) {
        trigger$1(target2, "delete", key, void 0, oldValue);
    }
    return result;
}
function clear$2() {
    const target2 = toRaw(this);
    const hadItems = target2.size !== 0;
    const oldTarget = isMap(target2) ? new Map(target2) : new Set(target2);
    const result = target2.clear();
    if (hadItems) {
        trigger$1(target2, "clear", void 0, void 0, oldTarget);
    }
    return result;
}
function createForEach(isReadonly2, isShallow) {
    return function forEach3(callback, thisArg) {
        const observed = this;
        const target2 = observed["__v_raw"];
        const rawTarget = toRaw(target2);
        const wrap = isShallow
            ? toShallow
            : isReadonly2
            ? toReadonly
            : toReactive;
        !isReadonly2 && track(rawTarget, "iterate", ITERATE_KEY);
        return target2.forEach((value, key) => {
            return callback.call(thisArg, wrap(value), wrap(key), observed);
        });
    };
}
function createIterableMethod(method, isReadonly2, isShallow) {
    return function (...args) {
        const target2 = this["__v_raw"];
        const rawTarget = toRaw(target2);
        const targetIsMap = isMap(rawTarget);
        const isPair =
            method === "entries" || (method === Symbol.iterator && targetIsMap);
        const isKeyOnly = method === "keys" && targetIsMap;
        const innerIterator = target2[method](...args);
        const wrap = isShallow
            ? toShallow
            : isReadonly2
            ? toReadonly
            : toReactive;
        !isReadonly2 &&
            track(
                rawTarget,
                "iterate",
                isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY
            );
        return {
            next() {
                const { value, done } = innerIterator.next();
                return done
                    ? { value, done }
                    : {
                          value: isPair
                              ? [wrap(value[0]), wrap(value[1])]
                              : wrap(value),
                          done,
                      };
            },
            [Symbol.iterator]() {
                return this;
            },
        };
    };
}
function createReadonlyMethod(type) {
    return function (...args) {
        {
            const key = args[0] ? `on key "${args[0]}" ` : ``;
            console.warn(
                `${capitalize$1(
                    type
                )} operation ${key}failed: target is readonly.`,
                toRaw(this)
            );
        }
        return type === "delete" ? false : this;
    };
}
var mutableInstrumentations = {
    get(key) {
        return get$1(this, key);
    },
    get size() {
        return size(this);
    },
    has: has$1$1,
    add: add$2,
    set: set$1$1,
    delete: deleteEntry,
    clear: clear$2,
    forEach: createForEach(false, false),
};
var shallowInstrumentations = {
    get(key) {
        return get$1(this, key, false, true);
    },
    get size() {
        return size(this);
    },
    has: has$1$1,
    add: add$2,
    set: set$1$1,
    delete: deleteEntry,
    clear: clear$2,
    forEach: createForEach(false, true),
};
var readonlyInstrumentations = {
    get(key) {
        return get$1(this, key, true);
    },
    get size() {
        return size(this, true);
    },
    has(key) {
        return has$1$1.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, false),
};
var shallowReadonlyInstrumentations = {
    get(key) {
        return get$1(this, key, true, true);
    },
    get size() {
        return size(this, true);
    },
    has(key) {
        return has$1$1.call(this, key, true);
    },
    add: createReadonlyMethod("add"),
    set: createReadonlyMethod("set"),
    delete: createReadonlyMethod("delete"),
    clear: createReadonlyMethod("clear"),
    forEach: createForEach(true, true),
};
var iteratorMethods = ["keys", "values", "entries", Symbol.iterator];
iteratorMethods.forEach((method) => {
    mutableInstrumentations[method] = createIterableMethod(
        method,
        false,
        false
    );
    readonlyInstrumentations[method] = createIterableMethod(
        method,
        true,
        false
    );
    shallowInstrumentations[method] = createIterableMethod(method, false, true);
    shallowReadonlyInstrumentations[method] = createIterableMethod(
        method,
        true,
        true
    );
});
function createInstrumentationGetter(isReadonly2, shallow) {
    const instrumentations = shallow
        ? isReadonly2
            ? shallowReadonlyInstrumentations
            : shallowInstrumentations
        : isReadonly2
        ? readonlyInstrumentations
        : mutableInstrumentations;
    return (target2, key, receiver) => {
        if (key === "__v_isReactive") {
            return !isReadonly2;
        } else if (key === "__v_isReadonly") {
            return isReadonly2;
        } else if (key === "__v_raw") {
            return target2;
        }
        return Reflect.get(
            hasOwn$1(instrumentations, key) && key in target2
                ? instrumentations
                : target2,
            key,
            receiver
        );
    };
}
var mutableCollectionHandlers = {
    get: createInstrumentationGetter(false, false),
};
var readonlyCollectionHandlers = {
    get: createInstrumentationGetter(true, false),
};
function checkIdentityKeys(target2, has2, key) {
    const rawKey = toRaw(key);
    if (rawKey !== key && has2.call(target2, rawKey)) {
        const type = toRawType$1(target2);
        console.warn(
            `Reactive ${type} contains both the raw and reactive versions of the same object${
                type === `Map` ? ` as keys` : ``
            }, which can lead to inconsistencies. Avoid differentiating between the raw and reactive versions of an object and only use the reactive version if possible.`
        );
    }
}
var reactiveMap = /* @__PURE__ */ new WeakMap();
var shallowReactiveMap = /* @__PURE__ */ new WeakMap();
var readonlyMap = /* @__PURE__ */ new WeakMap();
var shallowReadonlyMap = /* @__PURE__ */ new WeakMap();
function targetTypeMap(rawType) {
    switch (rawType) {
        case "Object":
        case "Array":
            return 1;
        case "Map":
        case "Set":
        case "WeakMap":
        case "WeakSet":
            return 2;
        default:
            return 0;
    }
}
function getTargetType(value) {
    return value["__v_skip"] || !Object.isExtensible(value)
        ? 0
        : targetTypeMap(toRawType$1(value));
}
function reactive2(target2) {
    if (target2 && target2["__v_isReadonly"]) {
        return target2;
    }
    return createReactiveObject(
        target2,
        false,
        mutableHandlers,
        mutableCollectionHandlers,
        reactiveMap
    );
}
function readonly(target2) {
    return createReactiveObject(
        target2,
        true,
        readonlyHandlers,
        readonlyCollectionHandlers,
        readonlyMap
    );
}
function createReactiveObject(
    target2,
    isReadonly2,
    baseHandlers,
    collectionHandlers,
    proxyMap
) {
    if (!isObject$b(target2)) {
        {
            console.warn(`value cannot be made reactive: ${String(target2)}`);
        }
        return target2;
    }
    if (target2["__v_raw"] && !(isReadonly2 && target2["__v_isReactive"])) {
        return target2;
    }
    const existingProxy = proxyMap.get(target2);
    if (existingProxy) {
        return existingProxy;
    }
    const targetType = getTargetType(target2);
    if (targetType === 0) {
        return target2;
    }
    const proxy2 = new Proxy(
        target2,
        targetType === 2 ? collectionHandlers : baseHandlers
    );
    proxyMap.set(target2, proxy2);
    return proxy2;
}
function toRaw(observed) {
    return (observed && toRaw(observed["__v_raw"])) || observed;
}
function isRef$1(r) {
    return Boolean(r && r.__v_isRef === true);
}
magic("nextTick", () => nextTick$1);
magic("dispatch", (el) => dispatch.bind(dispatch, el));
magic(
    "watch",
    (el, { evaluateLater: evaluateLater2, effect: effect3 }) =>
        (key, callback) => {
            let evaluate2 = evaluateLater2(key);
            let firstTime = true;
            let oldValue;
            let effectReference = effect3(() =>
                evaluate2((value) => {
                    JSON.stringify(value);
                    if (!firstTime) {
                        queueMicrotask(() => {
                            callback(value, oldValue);
                            oldValue = value;
                        });
                    } else {
                        oldValue = value;
                    }
                    firstTime = false;
                })
            );
            el._x_effects.delete(effectReference);
        }
);
magic("store", getStores);
magic("data", (el) => scope(el));
magic("root", (el) => closestRoot(el));
magic("refs", (el) => {
    if (el._x_refs_proxy) return el._x_refs_proxy;
    el._x_refs_proxy = mergeProxies(getArrayOfRefObject(el));
    return el._x_refs_proxy;
});
function getArrayOfRefObject(el) {
    let refObjects = [];
    let currentEl = el;
    while (currentEl) {
        if (currentEl._x_refs) refObjects.push(currentEl._x_refs);
        currentEl = currentEl.parentNode;
    }
    return refObjects;
}
var globalIdMemo = {};
function findAndIncrementId(name2) {
    if (!globalIdMemo[name2]) globalIdMemo[name2] = 0;
    return ++globalIdMemo[name2];
}
function closestIdRoot(el, name2) {
    return findClosest(el, (element) => {
        if (element._x_ids && element._x_ids[name2]) return true;
    });
}
function setIdRoot(el, name2) {
    if (!el._x_ids) el._x_ids = {};
    if (!el._x_ids[name2]) el._x_ids[name2] = findAndIncrementId(name2);
}
magic("id", (el) => (name2, key = null) => {
    let root2 = closestIdRoot(el, name2);
    let id = root2 ? root2._x_ids[name2] : findAndIncrementId(name2);
    return key ? `${name2}-${id}-${key}` : `${name2}-${id}`;
});
magic("el", (el) => el);
warnMissingPluginMagic("Focus", "focus", "focus");
warnMissingPluginMagic("Persist", "persist", "persist");
function warnMissingPluginMagic(name2, magicName, slug) {
    magic(magicName, (el) =>
        warn$1(
            `You can't use [$${directiveName}] without first installing the "${name2}" plugin here: https://alpinejs.dev/plugins/${slug}`,
            el
        )
    );
}
directive$2(
    "modelable",
    (
        el,
        { expression },
        { effect: effect3, evaluateLater: evaluateLater2 }
    ) => {
        let func = evaluateLater2(expression);
        let innerGet = () => {
            let result;
            func((i) => (result = i));
            return result;
        };
        let evaluateInnerSet = evaluateLater2(`${expression} = __placeholder`);
        let innerSet = (val) =>
            evaluateInnerSet(() => {}, { scope: { __placeholder: val } });
        let initialValue = innerGet();
        innerSet(initialValue);
        queueMicrotask(() => {
            if (!el._x_model) return;
            el._x_removeModelListeners["default"]();
            let outerGet = el._x_model.get;
            let outerSet = el._x_model.set;
            effect3(() => innerSet(outerGet()));
            effect3(() => outerSet(innerGet()));
        });
    }
);
directive$2("teleport", (el, { expression }, { cleanup: cleanup2 }) => {
    if (el.tagName.toLowerCase() !== "template")
        warn$1("x-teleport can only be used on a <template> tag", el);
    let target2 = document.querySelector(expression);
    if (!target2)
        warn$1(`Cannot find x-teleport element for selector: "${expression}"`);
    let clone2 = el.content.cloneNode(true).firstElementChild;
    el._x_teleport = clone2;
    clone2._x_teleportBack = el;
    if (el._x_forwardEvents) {
        el._x_forwardEvents.forEach((eventName) => {
            clone2.addEventListener(eventName, (e) => {
                e.stopPropagation();
                el.dispatchEvent(new e.constructor(e.type, e));
            });
        });
    }
    addScopeToNode(clone2, {}, el);
    mutateDom(() => {
        target2.appendChild(clone2);
        initTree(clone2);
        clone2._x_ignore = true;
    });
    cleanup2(() => clone2.remove());
});
var handler = () => {};
handler.inline = (el, { modifiers: modifiers2 }, { cleanup: cleanup2 }) => {
    modifiers2.includes("self")
        ? (el._x_ignoreSelf = true)
        : (el._x_ignore = true);
    cleanup2(() => {
        modifiers2.includes("self")
            ? delete el._x_ignoreSelf
            : delete el._x_ignore;
    });
};
directive$2("ignore", handler);
directive$2("effect", (el, { expression }, { effect: effect3 }) =>
    effect3(evaluateLater(el, expression))
);
function on$1(el, event2, modifiers2, callback) {
    let listenerTarget = el;
    let handler3 = (e) => callback(e);
    let options = {};
    let wrapHandler = (callback2, wrapper) => (e) => wrapper(callback2, e);
    if (modifiers2.includes("dot")) event2 = dotSyntax(event2);
    if (modifiers2.includes("camel")) event2 = camelCase2(event2);
    if (modifiers2.includes("passive")) options.passive = true;
    if (modifiers2.includes("capture")) options.capture = true;
    if (modifiers2.includes("window")) listenerTarget = window;
    if (modifiers2.includes("document")) listenerTarget = document;
    if (modifiers2.includes("prevent"))
        handler3 = wrapHandler(handler3, (next, e) => {
            e.preventDefault();
            next(e);
        });
    if (modifiers2.includes("stop"))
        handler3 = wrapHandler(handler3, (next, e) => {
            e.stopPropagation();
            next(e);
        });
    if (modifiers2.includes("self"))
        handler3 = wrapHandler(handler3, (next, e) => {
            e.target === el && next(e);
        });
    if (modifiers2.includes("away") || modifiers2.includes("outside")) {
        listenerTarget = document;
        handler3 = wrapHandler(handler3, (next, e) => {
            if (el.contains(e.target)) return;
            if (e.target.isConnected === false) return;
            if (el.offsetWidth < 1 && el.offsetHeight < 1) return;
            if (el._x_isShown === false) return;
            next(e);
        });
    }
    if (modifiers2.includes("once")) {
        handler3 = wrapHandler(handler3, (next, e) => {
            next(e);
            listenerTarget.removeEventListener(event2, handler3, options);
        });
    }
    handler3 = wrapHandler(handler3, (next, e) => {
        if (isKeyEvent(event2)) {
            if (isListeningForASpecificKeyThatHasntBeenPressed(e, modifiers2)) {
                return;
            }
        }
        next(e);
    });
    if (modifiers2.includes("debounce")) {
        let nextModifier =
            modifiers2[modifiers2.indexOf("debounce") + 1] || "invalid-wait";
        let wait = isNumeric$1(nextModifier.split("ms")[0])
            ? Number(nextModifier.split("ms")[0])
            : 250;
        handler3 = debounce$2(handler3, wait);
    }
    if (modifiers2.includes("throttle")) {
        let nextModifier =
            modifiers2[modifiers2.indexOf("throttle") + 1] || "invalid-wait";
        let wait = isNumeric$1(nextModifier.split("ms")[0])
            ? Number(nextModifier.split("ms")[0])
            : 250;
        handler3 = throttle(handler3, wait);
    }
    listenerTarget.addEventListener(event2, handler3, options);
    return () => {
        listenerTarget.removeEventListener(event2, handler3, options);
    };
}
function dotSyntax(subject) {
    return subject.replace(/-/g, ".");
}
function camelCase2(subject) {
    return subject
        .toLowerCase()
        .replace(/-(\w)/g, (match, char) => char.toUpperCase());
}
function isNumeric$1(subject) {
    return !Array.isArray(subject) && !isNaN(subject);
}
function kebabCase2(subject) {
    return subject
        .replace(/([a-z])([A-Z])/g, "$1-$2")
        .replace(/[_\s]/, "-")
        .toLowerCase();
}
function isKeyEvent(event2) {
    return ["keydown", "keyup"].includes(event2);
}
function isListeningForASpecificKeyThatHasntBeenPressed(e, modifiers2) {
    let keyModifiers = modifiers2.filter((i) => {
        return !["window", "document", "prevent", "stop", "once"].includes(i);
    });
    if (keyModifiers.includes("debounce")) {
        let debounceIndex = keyModifiers.indexOf("debounce");
        keyModifiers.splice(
            debounceIndex,
            isNumeric$1(
                (keyModifiers[debounceIndex + 1] || "invalid-wait").split(
                    "ms"
                )[0]
            )
                ? 2
                : 1
        );
    }
    if (keyModifiers.length === 0) return false;
    if (
        keyModifiers.length === 1 &&
        keyToModifiers(e.key).includes(keyModifiers[0])
    )
        return false;
    const systemKeyModifiers = ["ctrl", "shift", "alt", "meta", "cmd", "super"];
    const selectedSystemKeyModifiers = systemKeyModifiers.filter((modifier) =>
        keyModifiers.includes(modifier)
    );
    keyModifiers = keyModifiers.filter(
        (i) => !selectedSystemKeyModifiers.includes(i)
    );
    if (selectedSystemKeyModifiers.length > 0) {
        const activelyPressedKeyModifiers = selectedSystemKeyModifiers.filter(
            (modifier) => {
                if (modifier === "cmd" || modifier === "super")
                    modifier = "meta";
                return e[`${modifier}Key`];
            }
        );
        if (
            activelyPressedKeyModifiers.length ===
            selectedSystemKeyModifiers.length
        ) {
            if (keyToModifiers(e.key).includes(keyModifiers[0])) return false;
        }
    }
    return true;
}
function keyToModifiers(key) {
    if (!key) return [];
    key = kebabCase2(key);
    let modifierToKeyMap = {
        ctrl: "control",
        slash: "/",
        space: "-",
        spacebar: "-",
        cmd: "meta",
        esc: "escape",
        up: "arrow-up",
        down: "arrow-down",
        left: "arrow-left",
        right: "arrow-right",
        period: ".",
        equal: "=",
    };
    modifierToKeyMap[key] = key;
    return Object.keys(modifierToKeyMap)
        .map((modifier) => {
            if (modifierToKeyMap[modifier] === key) return modifier;
        })
        .filter((modifier) => modifier);
}
directive$2(
    "model",
    (
        el,
        { modifiers: modifiers2, expression },
        { effect: effect3, cleanup: cleanup2 }
    ) => {
        let evaluate2 = evaluateLater(el, expression);
        let assignmentExpression = `${expression} = rightSideOfExpression($event, ${expression})`;
        let evaluateAssignment = evaluateLater(el, assignmentExpression);
        var event2 =
            el.tagName.toLowerCase() === "select" ||
            ["checkbox", "radio"].includes(el.type) ||
            modifiers2.includes("lazy")
                ? "change"
                : "input";
        let assigmentFunction = generateAssignmentFunction(
            el,
            modifiers2,
            expression
        );
        let removeListener = on$1(el, event2, modifiers2, (e) => {
            evaluateAssignment(() => {}, {
                scope: {
                    $event: e,
                    rightSideOfExpression: assigmentFunction,
                },
            });
        });
        if (!el._x_removeModelListeners) el._x_removeModelListeners = {};
        el._x_removeModelListeners["default"] = removeListener;
        cleanup2(() => el._x_removeModelListeners["default"]());
        let evaluateSetModel = evaluateLater(
            el,
            `${expression} = __placeholder`
        );
        el._x_model = {
            get() {
                let result;
                evaluate2((value) => (result = value));
                return result;
            },
            set(value) {
                evaluateSetModel(() => {}, { scope: { __placeholder: value } });
            },
        };
        el._x_forceModelUpdate = () => {
            evaluate2((value) => {
                if (value === void 0 && expression.match(/\./)) value = "";
                window.fromModel = true;
                mutateDom(() => bind$2(el, "value", value));
                delete window.fromModel;
            });
        };
        effect3(() => {
            if (
                modifiers2.includes("unintrusive") &&
                document.activeElement.isSameNode(el)
            )
                return;
            el._x_forceModelUpdate();
        });
    }
);
function generateAssignmentFunction(el, modifiers2, expression) {
    if (el.type === "radio") {
        mutateDom(() => {
            if (!el.hasAttribute("name")) el.setAttribute("name", expression);
        });
    }
    return (event2, currentValue) => {
        return mutateDom(() => {
            if (event2 instanceof CustomEvent && event2.detail !== void 0) {
                return event2.detail || event2.target.value;
            } else if (el.type === "checkbox") {
                if (Array.isArray(currentValue)) {
                    let newValue = modifiers2.includes("number")
                        ? safeParseNumber(event2.target.value)
                        : event2.target.value;
                    return event2.target.checked
                        ? currentValue.concat([newValue])
                        : currentValue.filter(
                              (el2) => !checkedAttrLooseCompare2(el2, newValue)
                          );
                } else {
                    return event2.target.checked;
                }
            } else if (el.tagName.toLowerCase() === "select" && el.multiple) {
                return modifiers2.includes("number")
                    ? Array.from(event2.target.selectedOptions).map(
                          (option2) => {
                              let rawValue = option2.value || option2.text;
                              return safeParseNumber(rawValue);
                          }
                      )
                    : Array.from(event2.target.selectedOptions).map(
                          (option2) => {
                              return option2.value || option2.text;
                          }
                      );
            } else {
                let rawValue = event2.target.value;
                return modifiers2.includes("number")
                    ? safeParseNumber(rawValue)
                    : modifiers2.includes("trim")
                    ? rawValue.trim()
                    : rawValue;
            }
        });
    };
}
function safeParseNumber(rawValue) {
    let number = rawValue ? parseFloat(rawValue) : null;
    return isNumeric2(number) ? number : rawValue;
}
function checkedAttrLooseCompare2(valueA, valueB) {
    return valueA == valueB;
}
function isNumeric2(subject) {
    return !Array.isArray(subject) && !isNaN(subject);
}
directive$2("cloak", (el) =>
    queueMicrotask(() => mutateDom(() => el.removeAttribute(prefix("cloak"))))
);
addInitSelector(() => `[${prefix("init")}]`);
directive$2(
    "init",
    skipDuringClone((el, { expression }, { evaluate: evaluate2 }) => {
        if (typeof expression === "string") {
            return !!expression.trim() && evaluate2(expression, {}, false);
        }
        return evaluate2(expression, {}, false);
    })
);
directive$2(
    "text",
    (
        el,
        { expression },
        { effect: effect3, evaluateLater: evaluateLater2 }
    ) => {
        let evaluate2 = evaluateLater2(expression);
        effect3(() => {
            evaluate2((value) => {
                mutateDom(() => {
                    el.textContent = value;
                });
            });
        });
    }
);
directive$2(
    "html",
    (
        el,
        { expression },
        { effect: effect3, evaluateLater: evaluateLater2 }
    ) => {
        let evaluate2 = evaluateLater2(expression);
        effect3(() => {
            evaluate2((value) => {
                mutateDom(() => {
                    el.innerHTML = value;
                    el._x_ignoreSelf = true;
                    initTree(el);
                    delete el._x_ignoreSelf;
                });
            });
        });
    }
);
mapAttributes(startingWith(":", into(prefix("bind:"))));
directive$2(
    "bind",
    (
        el,
        { value, modifiers: modifiers2, expression, original },
        { effect: effect3 }
    ) => {
        if (!value) {
            let bindingProviders = {};
            injectBindingProviders(bindingProviders);
            let getBindings = evaluateLater(el, expression);
            getBindings(
                (bindings) => {
                    applyBindingsObject(el, bindings, original);
                },
                { scope: bindingProviders }
            );
            return;
        }
        if (value === "key") return storeKeyForXFor(el, expression);
        let evaluate2 = evaluateLater(el, expression);
        effect3(() =>
            evaluate2((result) => {
                if (result === void 0 && expression.match(/\./)) result = "";
                mutateDom(() => bind$2(el, value, result, modifiers2));
            })
        );
    }
);
function storeKeyForXFor(el, expression) {
    el._x_keyExpression = expression;
}
addRootSelector(() => `[${prefix("data")}]`);
directive$2(
    "data",
    skipDuringClone((el, { expression }, { cleanup: cleanup2 }) => {
        expression = expression === "" ? "{}" : expression;
        let magicContext = {};
        injectMagics(magicContext, el);
        let dataProviderContext = {};
        injectDataProviders(dataProviderContext, magicContext);
        let data22 = evaluate(el, expression, { scope: dataProviderContext });
        if (data22 === void 0) data22 = {};
        injectMagics(data22, el);
        let reactiveData = reactive(data22);
        initInterceptors(reactiveData);
        let undo = addScopeToNode(el, reactiveData);
        reactiveData["init"] && evaluate(el, reactiveData["init"]);
        cleanup2(() => {
            reactiveData["destroy"] && evaluate(el, reactiveData["destroy"]);
            undo();
        });
    })
);
directive$2(
    "show",
    (el, { modifiers: modifiers2, expression }, { effect: effect3 }) => {
        let evaluate2 = evaluateLater(el, expression);
        if (!el._x_doHide)
            el._x_doHide = () => {
                mutateDom(() => {
                    el.style.setProperty(
                        "display",
                        "none",
                        modifiers2.includes("important") ? "important" : void 0
                    );
                });
            };
        if (!el._x_doShow)
            el._x_doShow = () => {
                mutateDom(() => {
                    if (el.style.length === 1 && el.style.display === "none") {
                        el.removeAttribute("style");
                    } else {
                        el.style.removeProperty("display");
                    }
                });
            };
        let hide3 = () => {
            el._x_doHide();
            el._x_isShown = false;
        };
        let show3 = () => {
            el._x_doShow();
            el._x_isShown = true;
        };
        let clickAwayCompatibleShow = () => setTimeout(show3);
        let toggle = once$1(
            (value) => (value ? show3() : hide3()),
            (value) => {
                if (
                    typeof el._x_toggleAndCascadeWithTransitions === "function"
                ) {
                    el._x_toggleAndCascadeWithTransitions(
                        el,
                        value,
                        show3,
                        hide3
                    );
                } else {
                    value ? clickAwayCompatibleShow() : hide3();
                }
            }
        );
        let oldValue;
        let firstTime = true;
        effect3(() =>
            evaluate2((value) => {
                if (!firstTime && value === oldValue) return;
                if (modifiers2.includes("immediate"))
                    value ? clickAwayCompatibleShow() : hide3();
                toggle(value);
                oldValue = value;
                firstTime = false;
            })
        );
    }
);
directive$2(
    "for",
    (el, { expression }, { effect: effect3, cleanup: cleanup2 }) => {
        let iteratorNames = parseForExpression(expression);
        let evaluateItems = evaluateLater(el, iteratorNames.items);
        let evaluateKey = evaluateLater(el, el._x_keyExpression || "index");
        el._x_prevKeys = [];
        el._x_lookup = {};
        effect3(() => loop(el, iteratorNames, evaluateItems, evaluateKey));
        cleanup2(() => {
            Object.values(el._x_lookup).forEach((el2) => el2.remove());
            delete el._x_prevKeys;
            delete el._x_lookup;
        });
    }
);
function loop(el, iteratorNames, evaluateItems, evaluateKey) {
    let isObject2 = (i) => typeof i === "object" && !Array.isArray(i);
    let templateEl = el;
    evaluateItems((items) => {
        if (isNumeric3(items) && items >= 0) {
            items = Array.from(Array(items).keys(), (i) => i + 1);
        }
        if (items === void 0) items = [];
        let lookup = el._x_lookup;
        let prevKeys = el._x_prevKeys;
        let scopes = [];
        let keys2 = [];
        if (isObject2(items)) {
            items = Object.entries(items).map(([key, value]) => {
                let scope2 = getIterationScopeVariables(
                    iteratorNames,
                    value,
                    key,
                    items
                );
                evaluateKey((value2) => keys2.push(value2), {
                    scope: { index: key, ...scope2 },
                });
                scopes.push(scope2);
            });
        } else {
            for (let i = 0; i < items.length; i++) {
                let scope2 = getIterationScopeVariables(
                    iteratorNames,
                    items[i],
                    i,
                    items
                );
                evaluateKey((value) => keys2.push(value), {
                    scope: { index: i, ...scope2 },
                });
                scopes.push(scope2);
            }
        }
        let adds = [];
        let moves = [];
        let removes = [];
        let sames = [];
        for (let i = 0; i < prevKeys.length; i++) {
            let key = prevKeys[i];
            if (keys2.indexOf(key) === -1) removes.push(key);
        }
        prevKeys = prevKeys.filter((key) => !removes.includes(key));
        let lastKey = "template";
        for (let i = 0; i < keys2.length; i++) {
            let key = keys2[i];
            let prevIndex = prevKeys.indexOf(key);
            if (prevIndex === -1) {
                prevKeys.splice(i, 0, key);
                adds.push([lastKey, i]);
            } else if (prevIndex !== i) {
                let keyInSpot = prevKeys.splice(i, 1)[0];
                let keyForSpot = prevKeys.splice(prevIndex - 1, 1)[0];
                prevKeys.splice(i, 0, keyForSpot);
                prevKeys.splice(prevIndex, 0, keyInSpot);
                moves.push([keyInSpot, keyForSpot]);
            } else {
                sames.push(key);
            }
            lastKey = key;
        }
        for (let i = 0; i < removes.length; i++) {
            let key = removes[i];
            if (!!lookup[key]._x_effects) {
                lookup[key]._x_effects.forEach(dequeueJob);
            }
            lookup[key].remove();
            lookup[key] = null;
            delete lookup[key];
        }
        for (let i = 0; i < moves.length; i++) {
            let [keyInSpot, keyForSpot] = moves[i];
            let elInSpot = lookup[keyInSpot];
            let elForSpot = lookup[keyForSpot];
            let marker = document.createElement("div");
            mutateDom(() => {
                elForSpot.after(marker);
                elInSpot.after(elForSpot);
                elForSpot._x_currentIfEl &&
                    elForSpot.after(elForSpot._x_currentIfEl);
                marker.before(elInSpot);
                elInSpot._x_currentIfEl &&
                    elInSpot.after(elInSpot._x_currentIfEl);
                marker.remove();
            });
            refreshScope(elForSpot, scopes[keys2.indexOf(keyForSpot)]);
        }
        for (let i = 0; i < adds.length; i++) {
            let [lastKey2, index2] = adds[i];
            let lastEl =
                lastKey2 === "template" ? templateEl : lookup[lastKey2];
            if (lastEl._x_currentIfEl) lastEl = lastEl._x_currentIfEl;
            let scope2 = scopes[index2];
            let key = keys2[index2];
            let clone2 = document.importNode(
                templateEl.content,
                true
            ).firstElementChild;
            addScopeToNode(clone2, reactive(scope2), templateEl);
            mutateDom(() => {
                lastEl.after(clone2);
                initTree(clone2);
            });
            if (typeof key === "object") {
                warn$1(
                    "x-for key cannot be an object, it must be a string or an integer",
                    templateEl
                );
            }
            lookup[key] = clone2;
        }
        for (let i = 0; i < sames.length; i++) {
            refreshScope(lookup[sames[i]], scopes[keys2.indexOf(sames[i])]);
        }
        templateEl._x_prevKeys = keys2;
    });
}
function parseForExpression(expression) {
    let forIteratorRE = /,([^,\}\]]*)(?:,([^,\}\]]*))?$/;
    let stripParensRE = /^\s*\(|\)\s*$/g;
    let forAliasRE = /([\s\S]*?)\s+(?:in|of)\s+([\s\S]*)/;
    let inMatch = expression.match(forAliasRE);
    if (!inMatch) return;
    let res2 = {};
    res2.items = inMatch[2].trim();
    let item2 = inMatch[1].replace(stripParensRE, "").trim();
    let iteratorMatch = item2.match(forIteratorRE);
    if (iteratorMatch) {
        res2.item = item2.replace(forIteratorRE, "").trim();
        res2.index = iteratorMatch[1].trim();
        if (iteratorMatch[2]) {
            res2.collection = iteratorMatch[2].trim();
        }
    } else {
        res2.item = item2;
    }
    return res2;
}
function getIterationScopeVariables(iteratorNames, item2, index2, items) {
    let scopeVariables = {};
    if (/^\[.*\]$/.test(iteratorNames.item) && Array.isArray(item2)) {
        let names = iteratorNames.item
            .replace("[", "")
            .replace("]", "")
            .split(",")
            .map((i) => i.trim());
        names.forEach((name2, i) => {
            scopeVariables[name2] = item2[i];
        });
    } else if (
        /^\{.*\}$/.test(iteratorNames.item) &&
        !Array.isArray(item2) &&
        typeof item2 === "object"
    ) {
        let names = iteratorNames.item
            .replace("{", "")
            .replace("}", "")
            .split(",")
            .map((i) => i.trim());
        names.forEach((name2) => {
            scopeVariables[name2] = item2[name2];
        });
    } else {
        scopeVariables[iteratorNames.item] = item2;
    }
    if (iteratorNames.index) scopeVariables[iteratorNames.index] = index2;
    if (iteratorNames.collection)
        scopeVariables[iteratorNames.collection] = items;
    return scopeVariables;
}
function isNumeric3(subject) {
    return !Array.isArray(subject) && !isNaN(subject);
}
function handler2() {}
handler2.inline = (el, { expression }, { cleanup: cleanup2 }) => {
    let root2 = closestRoot(el);
    if (!root2._x_refs) root2._x_refs = {};
    root2._x_refs[expression] = el;
    cleanup2(() => delete root2._x_refs[expression]);
};
directive$2("ref", handler2);
directive$2(
    "if",
    (el, { expression }, { effect: effect3, cleanup: cleanup2 }) => {
        let evaluate2 = evaluateLater(el, expression);
        let show3 = () => {
            if (el._x_currentIfEl) return el._x_currentIfEl;
            let clone2 = el.content.cloneNode(true).firstElementChild;
            addScopeToNode(clone2, {}, el);
            mutateDom(() => {
                el.after(clone2);
                initTree(clone2);
            });
            el._x_currentIfEl = clone2;
            el._x_undoIf = () => {
                walk(clone2, (node) => {
                    if (!!node._x_effects) {
                        node._x_effects.forEach(dequeueJob);
                    }
                });
                clone2.remove();
                delete el._x_currentIfEl;
            };
            return clone2;
        };
        let hide3 = () => {
            if (!el._x_undoIf) return;
            el._x_undoIf();
            delete el._x_undoIf;
        };
        effect3(() =>
            evaluate2((value) => {
                value ? show3() : hide3();
            })
        );
        cleanup2(() => el._x_undoIf && el._x_undoIf());
    }
);
directive$2("id", (el, { expression }, { evaluate: evaluate2 }) => {
    let names = evaluate2(expression);
    names.forEach((name2) => setIdRoot(el, name2));
});
mapAttributes(startingWith("@", into(prefix("on:"))));
directive$2(
    "on",
    skipDuringClone(
        (
            el,
            { value, modifiers: modifiers2, expression },
            { cleanup: cleanup2 }
        ) => {
            let evaluate2 = expression
                ? evaluateLater(el, expression)
                : () => {};
            if (el.tagName.toLowerCase() === "template") {
                if (!el._x_forwardEvents) el._x_forwardEvents = [];
                if (!el._x_forwardEvents.includes(value))
                    el._x_forwardEvents.push(value);
            }
            let removeListener = on$1(el, value, modifiers2, (e) => {
                evaluate2(() => {}, { scope: { $event: e }, params: [e] });
            });
            cleanup2(() => removeListener());
        }
    )
);
warnMissingPluginDirective("Collapse", "collapse", "collapse");
warnMissingPluginDirective("Intersect", "intersect", "intersect");
warnMissingPluginDirective("Focus", "trap", "focus");
warnMissingPluginDirective("Mask", "mask", "mask");
function warnMissingPluginDirective(name2, directiveName2, slug) {
    directive$2(directiveName2, (el) =>
        warn$1(
            `You can't use [x-${directiveName2}] without first installing the "${name2}" plugin here: https://alpinejs.dev/plugins/${slug}`,
            el
        )
    );
}
alpine_default.setEvaluator(normalEvaluator);
alpine_default.setReactivityEngine({
    reactive: reactive2,
    effect: effect2,
    release: stop,
    raw: toRaw,
});
var src_default = alpine_default;
var module_default = src_default;
/*!
 * Vue.js v2.7.10
 * (c) 2014-2022 Evan You
 * Released under the MIT License.
 */
var emptyObject = Object.freeze({});
var isArray$6 = Array.isArray;
function isUndef(v) {
    return v === void 0 || v === null;
}
function isDef(v) {
    return v !== void 0 && v !== null;
}
function isTrue(v) {
    return v === true;
}
function isFalse(v) {
    return v === false;
}
function isPrimitive(value) {
    return (
        typeof value === "string" ||
        typeof value === "number" ||
        typeof value === "symbol" ||
        typeof value === "boolean"
    );
}
function isFunction$7(value) {
    return typeof value === "function";
}
function isObject$a(obj) {
    return obj !== null && typeof obj === "object";
}
var _toString = Object.prototype.toString;
function toRawType(value) {
    return _toString.call(value).slice(8, -1);
}
function isPlainObject$2(obj) {
    return _toString.call(obj) === "[object Object]";
}
function isRegExp(v) {
    return _toString.call(v) === "[object RegExp]";
}
function isValidArrayIndex(val) {
    var n = parseFloat(String(val));
    return n >= 0 && Math.floor(n) === n && isFinite(val);
}
function isPromise(val) {
    return (
        isDef(val) &&
        typeof val.then === "function" &&
        typeof val.catch === "function"
    );
}
function toString$1(val) {
    return val == null
        ? ""
        : Array.isArray(val) ||
          (isPlainObject$2(val) && val.toString === _toString)
        ? JSON.stringify(val, null, 2)
        : String(val);
}
function toNumber$1(val) {
    var n = parseFloat(val);
    return isNaN(n) ? val : n;
}
function makeMap(str, expectsLowerCase) {
    var map2 = /* @__PURE__ */ Object.create(null);
    var list2 = str.split(",");
    for (var i = 0; i < list2.length; i++) {
        map2[list2[i]] = true;
    }
    return expectsLowerCase
        ? function (val) {
              return map2[val.toLowerCase()];
          }
        : function (val) {
              return map2[val];
          };
}
makeMap("slot,component", true);
var isReservedAttribute = makeMap("key,ref,slot,slot-scope,is");
function remove$2(arr, item2) {
    if (arr.length) {
        var index2 = arr.indexOf(item2);
        if (index2 > -1) {
            return arr.splice(index2, 1);
        }
    }
}
var hasOwnProperty$c = Object.prototype.hasOwnProperty;
function hasOwn(obj, key) {
    return hasOwnProperty$c.call(obj, key);
}
function cached(fn2) {
    var cache = /* @__PURE__ */ Object.create(null);
    return function cachedFn(str) {
        var hit = cache[str];
        return hit || (cache[str] = fn2(str));
    };
}
var camelizeRE = /-(\w)/g;
var camelize = cached(function (str) {
    return str.replace(camelizeRE, function (_2, c) {
        return c ? c.toUpperCase() : "";
    });
});
var capitalize = cached(function (str) {
    return str.charAt(0).toUpperCase() + str.slice(1);
});
var hyphenateRE = /\B([A-Z])/g;
var hyphenate = cached(function (str) {
    return str.replace(hyphenateRE, "-$1").toLowerCase();
});
function polyfillBind(fn2, ctx) {
    function boundFn(a) {
        var l = arguments.length;
        return l
            ? l > 1
                ? fn2.apply(ctx, arguments)
                : fn2.call(ctx, a)
            : fn2.call(ctx);
    }
    boundFn._length = fn2.length;
    return boundFn;
}
function nativeBind(fn2, ctx) {
    return fn2.bind(ctx);
}
var bind$1 = Function.prototype.bind ? nativeBind : polyfillBind;
function toArray$1(list2, start2) {
    start2 = start2 || 0;
    var i = list2.length - start2;
    var ret = new Array(i);
    while (i--) {
        ret[i] = list2[i + start2];
    }
    return ret;
}
function extend(to, _from) {
    for (var key in _from) {
        to[key] = _from[key];
    }
    return to;
}
function toObject(arr) {
    var res2 = {};
    for (var i = 0; i < arr.length; i++) {
        if (arr[i]) {
            extend(res2, arr[i]);
        }
    }
    return res2;
}
function noop(a, b, c) {}
var no = function (a, b, c) {
    return false;
};
var identity$3 = function (_2) {
    return _2;
};
function looseEqual(a, b) {
    if (a === b) return true;
    var isObjectA = isObject$a(a);
    var isObjectB = isObject$a(b);
    if (isObjectA && isObjectB) {
        try {
            var isArrayA = Array.isArray(a);
            var isArrayB = Array.isArray(b);
            if (isArrayA && isArrayB) {
                return (
                    a.length === b.length &&
                    a.every(function (e, i) {
                        return looseEqual(e, b[i]);
                    })
                );
            } else if (a instanceof Date && b instanceof Date) {
                return a.getTime() === b.getTime();
            } else if (!isArrayA && !isArrayB) {
                var keysA = Object.keys(a);
                var keysB = Object.keys(b);
                return (
                    keysA.length === keysB.length &&
                    keysA.every(function (key) {
                        return looseEqual(a[key], b[key]);
                    })
                );
            } else {
                return false;
            }
        } catch (e) {
            return false;
        }
    } else if (!isObjectA && !isObjectB) {
        return String(a) === String(b);
    } else {
        return false;
    }
}
function looseIndexOf(arr, val) {
    for (var i = 0; i < arr.length; i++) {
        if (looseEqual(arr[i], val)) return i;
    }
    return -1;
}
function once(fn2) {
    var called = false;
    return function () {
        if (!called) {
            called = true;
            fn2.apply(this, arguments);
        }
    };
}
function hasChanged(x, y) {
    if (x === y) {
        return x === 0 && 1 / x !== 1 / y;
    } else {
        return x === x || y === y;
    }
}
var SSR_ATTR = "data-server-rendered";
var ASSET_TYPES = ["component", "directive", "filter"];
var LIFECYCLE_HOOKS = [
    "beforeCreate",
    "created",
    "beforeMount",
    "mounted",
    "beforeUpdate",
    "updated",
    "beforeDestroy",
    "destroyed",
    "activated",
    "deactivated",
    "errorCaptured",
    "serverPrefetch",
    "renderTracked",
    "renderTriggered",
];
var config = {
    optionMergeStrategies: /* @__PURE__ */ Object.create(null),
    silent: false,
    productionTip: false,
    devtools: false,
    performance: false,
    errorHandler: null,
    warnHandler: null,
    ignoredElements: [],
    keyCodes: /* @__PURE__ */ Object.create(null),
    isReservedTag: no,
    isReservedAttr: no,
    isUnknownElement: no,
    getTagNamespace: noop,
    parsePlatformTagName: identity$3,
    mustUseProp: no,
    async: true,
    _lifecycleHooks: LIFECYCLE_HOOKS,
};
var unicodeRegExp =
    /a-zA-Z\u00B7\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u037D\u037F-\u1FFF\u200C-\u200D\u203F-\u2040\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD/;
function isReserved(str) {
    var c = (str + "").charCodeAt(0);
    return c === 36 || c === 95;
}
function def(obj, key, val, enumerable) {
    Object.defineProperty(obj, key, {
        value: val,
        enumerable: !!enumerable,
        writable: true,
        configurable: true,
    });
}
var bailRE = new RegExp("[^".concat(unicodeRegExp.source, ".$_\\d]"));
function parsePath(path) {
    if (bailRE.test(path)) {
        return;
    }
    var segments = path.split(".");
    return function (obj) {
        for (var i = 0; i < segments.length; i++) {
            if (!obj) return;
            obj = obj[segments[i]];
        }
        return obj;
    };
}
var hasProto = "__proto__" in {};
var inBrowser = typeof window !== "undefined";
var UA = inBrowser && window.navigator.userAgent.toLowerCase();
var isIE$2 = UA && /msie|trident/.test(UA);
var isIE9 = UA && UA.indexOf("msie 9.0") > 0;
var isEdge = UA && UA.indexOf("edge/") > 0;
UA && UA.indexOf("android") > 0;
var isIOS$1 = UA && /iphone|ipad|ipod|ios/.test(UA);
UA && /chrome\/\d+/.test(UA) && !isEdge;
UA && /phantomjs/.test(UA);
var isFF = UA && UA.match(/firefox\/(\d+)/);
var nativeWatch = {}.watch;
var supportsPassive$1 = false;
if (inBrowser) {
    try {
        var opts$1 = {};
        Object.defineProperty(opts$1, "passive", {
            get: function () {
                supportsPassive$1 = true;
            },
        });
        window.addEventListener("test-passive", null, opts$1);
    } catch (e) {}
}
var _isServer;
var isServerRendering = function () {
    if (_isServer === void 0) {
        if (!inBrowser && typeof global !== "undefined") {
            _isServer =
                global["process"] && global["process"].env.VUE_ENV === "server";
        } else {
            _isServer = false;
        }
    }
    return _isServer;
};
var devtools = inBrowser && window.__VUE_DEVTOOLS_GLOBAL_HOOK__;
function isNative(Ctor) {
    return typeof Ctor === "function" && /native code/.test(Ctor.toString());
}
var hasSymbol =
    typeof Symbol !== "undefined" &&
    isNative(Symbol) &&
    typeof Reflect !== "undefined" &&
    isNative(Reflect.ownKeys);
var _Set$1;
if (typeof Set !== "undefined" && isNative(Set)) {
    _Set$1 = Set;
} else {
    _Set$1 = (function () {
        function Set2() {
            this.set = /* @__PURE__ */ Object.create(null);
        }
        Set2.prototype.has = function (key) {
            return this.set[key] === true;
        };
        Set2.prototype.add = function (key) {
            this.set[key] = true;
        };
        Set2.prototype.clear = function () {
            this.set = /* @__PURE__ */ Object.create(null);
        };
        return Set2;
    })();
}
var currentInstance = null;
function setCurrentInstance(vm) {
    if (vm === void 0) {
        vm = null;
    }
    if (!vm) currentInstance && currentInstance._scope.off();
    currentInstance = vm;
    vm && vm._scope.on();
}
var VNode = (function () {
    function VNode2(
        tag,
        data3,
        children,
        text2,
        elm,
        context,
        componentOptions,
        asyncFactory
    ) {
        this.tag = tag;
        this.data = data3;
        this.children = children;
        this.text = text2;
        this.elm = elm;
        this.ns = void 0;
        this.context = context;
        this.fnContext = void 0;
        this.fnOptions = void 0;
        this.fnScopeId = void 0;
        this.key = data3 && data3.key;
        this.componentOptions = componentOptions;
        this.componentInstance = void 0;
        this.parent = void 0;
        this.raw = false;
        this.isStatic = false;
        this.isRootInsert = true;
        this.isComment = false;
        this.isCloned = false;
        this.isOnce = false;
        this.asyncFactory = asyncFactory;
        this.asyncMeta = void 0;
        this.isAsyncPlaceholder = false;
    }
    Object.defineProperty(VNode2.prototype, "child", {
        get: function () {
            return this.componentInstance;
        },
        enumerable: false,
        configurable: true,
    });
    return VNode2;
})();
var createEmptyVNode = function (text2) {
    if (text2 === void 0) {
        text2 = "";
    }
    var node = new VNode();
    node.text = text2;
    node.isComment = true;
    return node;
};
function createTextVNode(val) {
    return new VNode(void 0, void 0, void 0, String(val));
}
function cloneVNode(vnode) {
    var cloned = new VNode(
        vnode.tag,
        vnode.data,
        vnode.children && vnode.children.slice(),
        vnode.text,
        vnode.elm,
        vnode.context,
        vnode.componentOptions,
        vnode.asyncFactory
    );
    cloned.ns = vnode.ns;
    cloned.isStatic = vnode.isStatic;
    cloned.key = vnode.key;
    cloned.isComment = vnode.isComment;
    cloned.fnContext = vnode.fnContext;
    cloned.fnOptions = vnode.fnOptions;
    cloned.fnScopeId = vnode.fnScopeId;
    cloned.asyncMeta = vnode.asyncMeta;
    cloned.isCloned = true;
    return cloned;
}
var uid$2 = 0;
var Dep = (function () {
    function Dep2() {
        this.id = uid$2++;
        this.subs = [];
    }
    Dep2.prototype.addSub = function (sub) {
        this.subs.push(sub);
    };
    Dep2.prototype.removeSub = function (sub) {
        remove$2(this.subs, sub);
    };
    Dep2.prototype.depend = function (info) {
        if (Dep2.target) {
            Dep2.target.addDep(this);
        }
    };
    Dep2.prototype.notify = function (info) {
        var subs = this.subs.slice();
        for (var i = 0, l = subs.length; i < l; i++) {
            subs[i].update();
        }
    };
    return Dep2;
})();
Dep.target = null;
var targetStack = [];
function pushTarget(target2) {
    targetStack.push(target2);
    Dep.target = target2;
}
function popTarget() {
    targetStack.pop();
    Dep.target = targetStack[targetStack.length - 1];
}
var arrayProto$1 = Array.prototype;
var arrayMethods = Object.create(arrayProto$1);
var methodsToPatch = [
    "push",
    "pop",
    "shift",
    "unshift",
    "splice",
    "sort",
    "reverse",
];
methodsToPatch.forEach(function (method) {
    var original = arrayProto$1[method];
    def(arrayMethods, method, function mutator() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var result = original.apply(this, args);
        var ob = this.__ob__;
        var inserted;
        switch (method) {
            case "push":
            case "unshift":
                inserted = args;
                break;
            case "splice":
                inserted = args.slice(2);
                break;
        }
        if (inserted) ob.observeArray(inserted);
        {
            ob.dep.notify();
        }
        return result;
    });
});
var arrayKeys = Object.getOwnPropertyNames(arrayMethods);
var NO_INIITIAL_VALUE = {};
var shouldObserve = true;
function toggleObserving(value) {
    shouldObserve = value;
}
var mockDep = {
    notify: noop,
    depend: noop,
    addSub: noop,
    removeSub: noop,
};
var Observer = (function () {
    function Observer2(value, shallow, mock) {
        if (shallow === void 0) {
            shallow = false;
        }
        if (mock === void 0) {
            mock = false;
        }
        this.value = value;
        this.shallow = shallow;
        this.mock = mock;
        this.dep = mock ? mockDep : new Dep();
        this.vmCount = 0;
        def(value, "__ob__", this);
        if (isArray$6(value)) {
            if (!mock) {
                if (hasProto) {
                    value.__proto__ = arrayMethods;
                } else {
                    for (var i = 0, l = arrayKeys.length; i < l; i++) {
                        var key = arrayKeys[i];
                        def(value, key, arrayMethods[key]);
                    }
                }
            }
            if (!shallow) {
                this.observeArray(value);
            }
        } else {
            var keys2 = Object.keys(value);
            for (var i = 0; i < keys2.length; i++) {
                var key = keys2[i];
                defineReactive(
                    value,
                    key,
                    NO_INIITIAL_VALUE,
                    void 0,
                    shallow,
                    mock
                );
            }
        }
    }
    Observer2.prototype.observeArray = function (value) {
        for (var i = 0, l = value.length; i < l; i++) {
            observe(value[i], false, this.mock);
        }
    };
    return Observer2;
})();
function observe(value, shallow, ssrMockReactivity) {
    if (!isObject$a(value) || isRef(value) || value instanceof VNode) {
        return;
    }
    var ob;
    if (hasOwn(value, "__ob__") && value.__ob__ instanceof Observer) {
        ob = value.__ob__;
    } else if (
        shouldObserve &&
        (ssrMockReactivity || !isServerRendering()) &&
        (isArray$6(value) || isPlainObject$2(value)) &&
        Object.isExtensible(value) &&
        !value.__v_skip
    ) {
        ob = new Observer(value, shallow, ssrMockReactivity);
    }
    return ob;
}
function defineReactive(obj, key, val, customSetter, shallow, mock) {
    var dep = new Dep();
    var property = Object.getOwnPropertyDescriptor(obj, key);
    if (property && property.configurable === false) {
        return;
    }
    var getter = property && property.get;
    var setter = property && property.set;
    if (
        (!getter || setter) &&
        (val === NO_INIITIAL_VALUE || arguments.length === 2)
    ) {
        val = obj[key];
    }
    var childOb = !shallow && observe(val, false, mock);
    Object.defineProperty(obj, key, {
        enumerable: true,
        configurable: true,
        get: function reactiveGetter() {
            var value = getter ? getter.call(obj) : val;
            if (Dep.target) {
                {
                    dep.depend();
                }
                if (childOb) {
                    childOb.dep.depend();
                    if (isArray$6(value)) {
                        dependArray(value);
                    }
                }
            }
            return isRef(value) && !shallow ? value.value : value;
        },
        set: function reactiveSetter(newVal) {
            var value = getter ? getter.call(obj) : val;
            if (!hasChanged(value, newVal)) {
                return;
            }
            if (setter) {
                setter.call(obj, newVal);
            } else if (getter) {
                return;
            } else if (!shallow && isRef(value) && !isRef(newVal)) {
                value.value = newVal;
                return;
            } else {
                val = newVal;
            }
            childOb = !shallow && observe(newVal, false, mock);
            {
                dep.notify();
            }
        },
    });
    return dep;
}
function set(target2, key, val) {
    if (isReadonly(target2)) {
        return;
    }
    var ob = target2.__ob__;
    if (isArray$6(target2) && isValidArrayIndex(key)) {
        target2.length = Math.max(target2.length, key);
        target2.splice(key, 1, val);
        if (ob && !ob.shallow && ob.mock) {
            observe(val, false, true);
        }
        return val;
    }
    if (key in target2 && !(key in Object.prototype)) {
        target2[key] = val;
        return val;
    }
    if (target2._isVue || (ob && ob.vmCount)) {
        return val;
    }
    if (!ob) {
        target2[key] = val;
        return val;
    }
    defineReactive(ob.value, key, val, void 0, ob.shallow, ob.mock);
    {
        ob.dep.notify();
    }
    return val;
}
function del(target2, key) {
    if (isArray$6(target2) && isValidArrayIndex(key)) {
        target2.splice(key, 1);
        return;
    }
    var ob = target2.__ob__;
    if (target2._isVue || (ob && ob.vmCount)) {
        return;
    }
    if (isReadonly(target2)) {
        return;
    }
    if (!hasOwn(target2, key)) {
        return;
    }
    delete target2[key];
    if (!ob) {
        return;
    }
    {
        ob.dep.notify();
    }
}
function dependArray(value) {
    for (var e = void 0, i = 0, l = value.length; i < l; i++) {
        e = value[i];
        if (e && e.__ob__) {
            e.__ob__.dep.depend();
        }
        if (isArray$6(e)) {
            dependArray(e);
        }
    }
}
function shallowReactive(target2) {
    makeReactive(target2, true);
    def(target2, "__v_isShallow", true);
    return target2;
}
function makeReactive(target2, shallow) {
    if (!isReadonly(target2)) {
        observe(target2, shallow, isServerRendering());
    }
}
function isReadonly(value) {
    return !!(value && value.__v_isReadonly);
}
function isRef(r) {
    return !!(r && r.__v_isRef === true);
}
function proxyWithRefUnwrap(target2, source, key) {
    Object.defineProperty(target2, key, {
        enumerable: true,
        configurable: true,
        get: function () {
            var val = source[key];
            if (isRef(val)) {
                return val.value;
            } else {
                var ob = val && val.__ob__;
                if (ob) ob.dep.depend();
                return val;
            }
        },
        set: function (value) {
            var oldValue = source[key];
            if (isRef(oldValue) && !isRef(value)) {
                oldValue.value = value;
            } else {
                source[key] = value;
            }
        },
    });
}
var activeEffectScope;
var EffectScope = (function () {
    function EffectScope2(detached) {
        if (detached === void 0) {
            detached = false;
        }
        this.active = true;
        this.effects = [];
        this.cleanups = [];
        if (!detached && activeEffectScope) {
            this.parent = activeEffectScope;
            this.index =
                (
                    activeEffectScope.scopes || (activeEffectScope.scopes = [])
                ).push(this) - 1;
        }
    }
    EffectScope2.prototype.run = function (fn2) {
        if (this.active) {
            var currentEffectScope = activeEffectScope;
            try {
                activeEffectScope = this;
                return fn2();
            } finally {
                activeEffectScope = currentEffectScope;
            }
        }
    };
    EffectScope2.prototype.on = function () {
        activeEffectScope = this;
    };
    EffectScope2.prototype.off = function () {
        activeEffectScope = this.parent;
    };
    EffectScope2.prototype.stop = function (fromParent) {
        if (this.active) {
            var i = void 0,
                l = void 0;
            for (i = 0, l = this.effects.length; i < l; i++) {
                this.effects[i].teardown();
            }
            for (i = 0, l = this.cleanups.length; i < l; i++) {
                this.cleanups[i]();
            }
            if (this.scopes) {
                for (i = 0, l = this.scopes.length; i < l; i++) {
                    this.scopes[i].stop(true);
                }
            }
            if (this.parent && !fromParent) {
                var last = this.parent.scopes.pop();
                if (last && last !== this) {
                    this.parent.scopes[this.index] = last;
                    last.index = this.index;
                }
            }
            this.active = false;
        }
    };
    return EffectScope2;
})();
function recordEffectScope(effect3, scope2) {
    if (scope2 === void 0) {
        scope2 = activeEffectScope;
    }
    if (scope2 && scope2.active) {
        scope2.effects.push(effect3);
    }
}
function resolveProvided(vm) {
    var existing = vm._provided;
    var parentProvides = vm.$parent && vm.$parent._provided;
    if (parentProvides === existing) {
        return (vm._provided = Object.create(parentProvides));
    } else {
        return existing;
    }
}
var normalizeEvent = cached(function (name2) {
    var passive = name2.charAt(0) === "&";
    name2 = passive ? name2.slice(1) : name2;
    var once2 = name2.charAt(0) === "~";
    name2 = once2 ? name2.slice(1) : name2;
    var capture = name2.charAt(0) === "!";
    name2 = capture ? name2.slice(1) : name2;
    return {
        name: name2,
        once: once2,
        capture,
        passive,
    };
});
function createFnInvoker(fns, vm) {
    function invoker() {
        var fns2 = invoker.fns;
        if (isArray$6(fns2)) {
            var cloned = fns2.slice();
            for (var i = 0; i < cloned.length; i++) {
                invokeWithErrorHandling(
                    cloned[i],
                    null,
                    arguments,
                    vm,
                    "v-on handler"
                );
            }
        } else {
            return invokeWithErrorHandling(
                fns2,
                null,
                arguments,
                vm,
                "v-on handler"
            );
        }
    }
    invoker.fns = fns;
    return invoker;
}
function updateListeners(on2, oldOn, add2, remove2, createOnceHandler2, vm) {
    var name2, cur, old, event2;
    for (name2 in on2) {
        cur = on2[name2];
        old = oldOn[name2];
        event2 = normalizeEvent(name2);
        if (isUndef(cur));
        else if (isUndef(old)) {
            if (isUndef(cur.fns)) {
                cur = on2[name2] = createFnInvoker(cur, vm);
            }
            if (isTrue(event2.once)) {
                cur = on2[name2] = createOnceHandler2(
                    event2.name,
                    cur,
                    event2.capture
                );
            }
            add2(
                event2.name,
                cur,
                event2.capture,
                event2.passive,
                event2.params
            );
        } else if (cur !== old) {
            old.fns = cur;
            on2[name2] = old;
        }
    }
    for (name2 in oldOn) {
        if (isUndef(on2[name2])) {
            event2 = normalizeEvent(name2);
            remove2(event2.name, oldOn[name2], event2.capture);
        }
    }
}
function mergeVNodeHook(def2, hookKey, hook) {
    if (def2 instanceof VNode) {
        def2 = def2.data.hook || (def2.data.hook = {});
    }
    var invoker;
    var oldHook = def2[hookKey];
    function wrappedHook() {
        hook.apply(this, arguments);
        remove$2(invoker.fns, wrappedHook);
    }
    if (isUndef(oldHook)) {
        invoker = createFnInvoker([wrappedHook]);
    } else {
        if (isDef(oldHook.fns) && isTrue(oldHook.merged)) {
            invoker = oldHook;
            invoker.fns.push(wrappedHook);
        } else {
            invoker = createFnInvoker([oldHook, wrappedHook]);
        }
    }
    invoker.merged = true;
    def2[hookKey] = invoker;
}
function extractPropsFromVNodeData(data3, Ctor, tag) {
    var propOptions = Ctor.options.props;
    if (isUndef(propOptions)) {
        return;
    }
    var res2 = {};
    var attrs2 = data3.attrs,
        props2 = data3.props;
    if (isDef(attrs2) || isDef(props2)) {
        for (var key in propOptions) {
            var altKey = hyphenate(key);
            checkProp(res2, props2, key, altKey, true) ||
                checkProp(res2, attrs2, key, altKey, false);
        }
    }
    return res2;
}
function checkProp(res2, hash, key, altKey, preserve) {
    if (isDef(hash)) {
        if (hasOwn(hash, key)) {
            res2[key] = hash[key];
            if (!preserve) {
                delete hash[key];
            }
            return true;
        } else if (hasOwn(hash, altKey)) {
            res2[key] = hash[altKey];
            if (!preserve) {
                delete hash[altKey];
            }
            return true;
        }
    }
    return false;
}
function simpleNormalizeChildren(children) {
    for (var i = 0; i < children.length; i++) {
        if (isArray$6(children[i])) {
            return Array.prototype.concat.apply([], children);
        }
    }
    return children;
}
function normalizeChildren(children) {
    return isPrimitive(children)
        ? [createTextVNode(children)]
        : isArray$6(children)
        ? normalizeArrayChildren(children)
        : void 0;
}
function isTextNode(node) {
    return isDef(node) && isDef(node.text) && isFalse(node.isComment);
}
function normalizeArrayChildren(children, nestedIndex) {
    var res2 = [];
    var i, c, lastIndex, last;
    for (i = 0; i < children.length; i++) {
        c = children[i];
        if (isUndef(c) || typeof c === "boolean") continue;
        lastIndex = res2.length - 1;
        last = res2[lastIndex];
        if (isArray$6(c)) {
            if (c.length > 0) {
                c = normalizeArrayChildren(
                    c,
                    "".concat(nestedIndex || "", "_").concat(i)
                );
                if (isTextNode(c[0]) && isTextNode(last)) {
                    res2[lastIndex] = createTextVNode(last.text + c[0].text);
                    c.shift();
                }
                res2.push.apply(res2, c);
            }
        } else if (isPrimitive(c)) {
            if (isTextNode(last)) {
                res2[lastIndex] = createTextVNode(last.text + c);
            } else if (c !== "") {
                res2.push(createTextVNode(c));
            }
        } else {
            if (isTextNode(c) && isTextNode(last)) {
                res2[lastIndex] = createTextVNode(last.text + c.text);
            } else {
                if (
                    isTrue(children._isVList) &&
                    isDef(c.tag) &&
                    isUndef(c.key) &&
                    isDef(nestedIndex)
                ) {
                    c.key = "__vlist".concat(nestedIndex, "_").concat(i, "__");
                }
                res2.push(c);
            }
        }
    }
    return res2;
}
function renderList(val, render3) {
    var ret = null,
        i,
        l,
        keys2,
        key;
    if (isArray$6(val) || typeof val === "string") {
        ret = new Array(val.length);
        for (i = 0, l = val.length; i < l; i++) {
            ret[i] = render3(val[i], i);
        }
    } else if (typeof val === "number") {
        ret = new Array(val);
        for (i = 0; i < val; i++) {
            ret[i] = render3(i + 1, i);
        }
    } else if (isObject$a(val)) {
        if (hasSymbol && val[Symbol.iterator]) {
            ret = [];
            var iterator = val[Symbol.iterator]();
            var result = iterator.next();
            while (!result.done) {
                ret.push(render3(result.value, ret.length));
                result = iterator.next();
            }
        } else {
            keys2 = Object.keys(val);
            ret = new Array(keys2.length);
            for (i = 0, l = keys2.length; i < l; i++) {
                key = keys2[i];
                ret[i] = render3(val[key], key, i);
            }
        }
    }
    if (!isDef(ret)) {
        ret = [];
    }
    ret._isVList = true;
    return ret;
}
function renderSlot(name2, fallbackRender, props2, bindObject) {
    var scopedSlotFn = this.$scopedSlots[name2];
    var nodes;
    if (scopedSlotFn) {
        props2 = props2 || {};
        if (bindObject) {
            props2 = extend(extend({}, bindObject), props2);
        }
        nodes =
            scopedSlotFn(props2) ||
            (isFunction$7(fallbackRender) ? fallbackRender() : fallbackRender);
    } else {
        nodes =
            this.$slots[name2] ||
            (isFunction$7(fallbackRender) ? fallbackRender() : fallbackRender);
    }
    var target2 = props2 && props2.slot;
    if (target2) {
        return this.$createElement("template", { slot: target2 }, nodes);
    } else {
        return nodes;
    }
}
function resolveFilter(id) {
    return resolveAsset(this.$options, "filters", id) || identity$3;
}
function isKeyNotMatch(expect, actual) {
    if (isArray$6(expect)) {
        return expect.indexOf(actual) === -1;
    } else {
        return expect !== actual;
    }
}
function checkKeyCodes(
    eventKeyCode,
    key,
    builtInKeyCode,
    eventKeyName,
    builtInKeyName
) {
    var mappedKeyCode = config.keyCodes[key] || builtInKeyCode;
    if (builtInKeyName && eventKeyName && !config.keyCodes[key]) {
        return isKeyNotMatch(builtInKeyName, eventKeyName);
    } else if (mappedKeyCode) {
        return isKeyNotMatch(mappedKeyCode, eventKeyCode);
    } else if (eventKeyName) {
        return hyphenate(eventKeyName) !== key;
    }
    return eventKeyCode === void 0;
}
function bindObjectProps(data3, tag, value, asProp, isSync) {
    if (value) {
        if (!isObject$a(value));
        else {
            if (isArray$6(value)) {
                value = toObject(value);
            }
            var hash = void 0;
            var _loop_1 = function (key2) {
                if (
                    key2 === "class" ||
                    key2 === "style" ||
                    isReservedAttribute(key2)
                ) {
                    hash = data3;
                } else {
                    var type = data3.attrs && data3.attrs.type;
                    hash =
                        asProp || config.mustUseProp(tag, type, key2)
                            ? data3.domProps || (data3.domProps = {})
                            : data3.attrs || (data3.attrs = {});
                }
                var camelizedKey = camelize(key2);
                var hyphenatedKey = hyphenate(key2);
                if (!(camelizedKey in hash) && !(hyphenatedKey in hash)) {
                    hash[key2] = value[key2];
                    if (isSync) {
                        var on2 = data3.on || (data3.on = {});
                        on2["update:".concat(key2)] = function ($event) {
                            value[key2] = $event;
                        };
                    }
                }
            };
            for (var key in value) {
                _loop_1(key);
            }
        }
    }
    return data3;
}
function renderStatic(index2, isInFor) {
    var cached2 = this._staticTrees || (this._staticTrees = []);
    var tree = cached2[index2];
    if (tree && !isInFor) {
        return tree;
    }
    tree = cached2[index2] = this.$options.staticRenderFns[index2].call(
        this._renderProxy,
        this._c,
        this
    );
    markStatic(tree, "__static__".concat(index2), false);
    return tree;
}
function markOnce(tree, index2, key) {
    markStatic(
        tree,
        "__once__".concat(index2).concat(key ? "_".concat(key) : ""),
        true
    );
    return tree;
}
function markStatic(tree, key, isOnce) {
    if (isArray$6(tree)) {
        for (var i = 0; i < tree.length; i++) {
            if (tree[i] && typeof tree[i] !== "string") {
                markStaticNode(tree[i], "".concat(key, "_").concat(i), isOnce);
            }
        }
    } else {
        markStaticNode(tree, key, isOnce);
    }
}
function markStaticNode(node, key, isOnce) {
    node.isStatic = true;
    node.key = key;
    node.isOnce = isOnce;
}
function bindObjectListeners(data3, value) {
    if (value) {
        if (!isPlainObject$2(value));
        else {
            var on2 = (data3.on = data3.on ? extend({}, data3.on) : {});
            for (var key in value) {
                var existing = on2[key];
                var ours = value[key];
                on2[key] = existing ? [].concat(existing, ours) : ours;
            }
        }
    }
    return data3;
}
function resolveScopedSlots(fns, res2, hasDynamicKeys, contentHashKey) {
    res2 = res2 || { $stable: !hasDynamicKeys };
    for (var i = 0; i < fns.length; i++) {
        var slot = fns[i];
        if (isArray$6(slot)) {
            resolveScopedSlots(slot, res2, hasDynamicKeys);
        } else if (slot) {
            if (slot.proxy) {
                slot.fn.proxy = true;
            }
            res2[slot.key] = slot.fn;
        }
    }
    if (contentHashKey) {
        res2.$key = contentHashKey;
    }
    return res2;
}
function bindDynamicKeys(baseObj, values) {
    for (var i = 0; i < values.length; i += 2) {
        var key = values[i];
        if (typeof key === "string" && key) {
            baseObj[values[i]] = values[i + 1];
        }
    }
    return baseObj;
}
function prependModifier(value, symbol) {
    return typeof value === "string" ? symbol + value : value;
}
function installRenderHelpers(target2) {
    target2._o = markOnce;
    target2._n = toNumber$1;
    target2._s = toString$1;
    target2._l = renderList;
    target2._t = renderSlot;
    target2._q = looseEqual;
    target2._i = looseIndexOf;
    target2._m = renderStatic;
    target2._f = resolveFilter;
    target2._k = checkKeyCodes;
    target2._b = bindObjectProps;
    target2._v = createTextVNode;
    target2._e = createEmptyVNode;
    target2._u = resolveScopedSlots;
    target2._g = bindObjectListeners;
    target2._d = bindDynamicKeys;
    target2._p = prependModifier;
}
function resolveSlots(children, context) {
    if (!children || !children.length) {
        return {};
    }
    var slots = {};
    for (var i = 0, l = children.length; i < l; i++) {
        var child = children[i];
        var data3 = child.data;
        if (data3 && data3.attrs && data3.attrs.slot) {
            delete data3.attrs.slot;
        }
        if (
            (child.context === context || child.fnContext === context) &&
            data3 &&
            data3.slot != null
        ) {
            var name_1 = data3.slot;
            var slot = slots[name_1] || (slots[name_1] = []);
            if (child.tag === "template") {
                slot.push.apply(slot, child.children || []);
            } else {
                slot.push(child);
            }
        } else {
            (slots.default || (slots.default = [])).push(child);
        }
    }
    for (var name_2 in slots) {
        if (slots[name_2].every(isWhitespace)) {
            delete slots[name_2];
        }
    }
    return slots;
}
function isWhitespace(node) {
    return (node.isComment && !node.asyncFactory) || node.text === " ";
}
function isAsyncPlaceholder(node) {
    return node.isComment && node.asyncFactory;
}
function normalizeScopedSlots(
    ownerVm,
    scopedSlots,
    normalSlots,
    prevScopedSlots
) {
    var res2;
    var hasNormalSlots = Object.keys(normalSlots).length > 0;
    var isStable = scopedSlots ? !!scopedSlots.$stable : !hasNormalSlots;
    var key = scopedSlots && scopedSlots.$key;
    if (!scopedSlots) {
        res2 = {};
    } else if (scopedSlots._normalized) {
        return scopedSlots._normalized;
    } else if (
        isStable &&
        prevScopedSlots &&
        prevScopedSlots !== emptyObject &&
        key === prevScopedSlots.$key &&
        !hasNormalSlots &&
        !prevScopedSlots.$hasNormal
    ) {
        return prevScopedSlots;
    } else {
        res2 = {};
        for (var key_1 in scopedSlots) {
            if (scopedSlots[key_1] && key_1[0] !== "$") {
                res2[key_1] = normalizeScopedSlot(
                    ownerVm,
                    normalSlots,
                    key_1,
                    scopedSlots[key_1]
                );
            }
        }
    }
    for (var key_2 in normalSlots) {
        if (!(key_2 in res2)) {
            res2[key_2] = proxyNormalSlot(normalSlots, key_2);
        }
    }
    if (scopedSlots && Object.isExtensible(scopedSlots)) {
        scopedSlots._normalized = res2;
    }
    def(res2, "$stable", isStable);
    def(res2, "$key", key);
    def(res2, "$hasNormal", hasNormalSlots);
    return res2;
}
function normalizeScopedSlot(vm, normalSlots, key, fn2) {
    var normalized = function () {
        var cur = currentInstance;
        setCurrentInstance(vm);
        var res2 = arguments.length ? fn2.apply(null, arguments) : fn2({});
        res2 =
            res2 && typeof res2 === "object" && !isArray$6(res2)
                ? [res2]
                : normalizeChildren(res2);
        var vnode = res2 && res2[0];
        setCurrentInstance(cur);
        return res2 &&
            (!vnode ||
                (res2.length === 1 &&
                    vnode.isComment &&
                    !isAsyncPlaceholder(vnode)))
            ? void 0
            : res2;
    };
    if (fn2.proxy) {
        Object.defineProperty(normalSlots, key, {
            get: normalized,
            enumerable: true,
            configurable: true,
        });
    }
    return normalized;
}
function proxyNormalSlot(slots, key) {
    return function () {
        return slots[key];
    };
}
function initSetup(vm) {
    var options = vm.$options;
    var setup = options.setup;
    if (setup) {
        var ctx = (vm._setupContext = createSetupContext(vm));
        setCurrentInstance(vm);
        pushTarget();
        var setupResult = invokeWithErrorHandling(
            setup,
            null,
            [vm._props || shallowReactive({}), ctx],
            vm,
            "setup"
        );
        popTarget();
        setCurrentInstance();
        if (isFunction$7(setupResult)) {
            options.render = setupResult;
        } else if (isObject$a(setupResult)) {
            vm._setupState = setupResult;
            if (!setupResult.__sfc) {
                for (var key in setupResult) {
                    if (!isReserved(key)) {
                        proxyWithRefUnwrap(vm, setupResult, key);
                    }
                }
            } else {
                var proxy2 = (vm._setupProxy = {});
                for (var key in setupResult) {
                    if (key !== "__sfc") {
                        proxyWithRefUnwrap(proxy2, setupResult, key);
                    }
                }
            }
        } else;
    }
}
function createSetupContext(vm) {
    return {
        get attrs() {
            if (!vm._attrsProxy) {
                var proxy2 = (vm._attrsProxy = {});
                def(proxy2, "_v_attr_proxy", true);
                syncSetupProxy(proxy2, vm.$attrs, emptyObject, vm, "$attrs");
            }
            return vm._attrsProxy;
        },
        get listeners() {
            if (!vm._listenersProxy) {
                var proxy2 = (vm._listenersProxy = {});
                syncSetupProxy(
                    proxy2,
                    vm.$listeners,
                    emptyObject,
                    vm,
                    "$listeners"
                );
            }
            return vm._listenersProxy;
        },
        get slots() {
            return initSlotsProxy(vm);
        },
        emit: bind$1(vm.$emit, vm),
        expose: function (exposed) {
            if (exposed) {
                Object.keys(exposed).forEach(function (key) {
                    return proxyWithRefUnwrap(vm, exposed, key);
                });
            }
        },
    };
}
function syncSetupProxy(to, from, prev, instance, type) {
    var changed = false;
    for (var key in from) {
        if (!(key in to)) {
            changed = true;
            defineProxyAttr(to, key, instance, type);
        } else if (from[key] !== prev[key]) {
            changed = true;
        }
    }
    for (var key in to) {
        if (!(key in from)) {
            changed = true;
            delete to[key];
        }
    }
    return changed;
}
function defineProxyAttr(proxy2, key, instance, type) {
    Object.defineProperty(proxy2, key, {
        enumerable: true,
        configurable: true,
        get: function () {
            return instance[type][key];
        },
    });
}
function initSlotsProxy(vm) {
    if (!vm._slotsProxy) {
        syncSetupSlots((vm._slotsProxy = {}), vm.$scopedSlots);
    }
    return vm._slotsProxy;
}
function syncSetupSlots(to, from) {
    for (var key in from) {
        to[key] = from[key];
    }
    for (var key in to) {
        if (!(key in from)) {
            delete to[key];
        }
    }
}
function initRender(vm) {
    vm._vnode = null;
    vm._staticTrees = null;
    var options = vm.$options;
    var parentVnode = (vm.$vnode = options._parentVnode);
    var renderContext = parentVnode && parentVnode.context;
    vm.$slots = resolveSlots(options._renderChildren, renderContext);
    vm.$scopedSlots = parentVnode
        ? normalizeScopedSlots(
              vm.$parent,
              parentVnode.data.scopedSlots,
              vm.$slots
          )
        : emptyObject;
    vm._c = function (a, b, c, d) {
        return createElement$1$1(vm, a, b, c, d, false);
    };
    vm.$createElement = function (a, b, c, d) {
        return createElement$1$1(vm, a, b, c, d, true);
    };
    var parentData = parentVnode && parentVnode.data;
    {
        defineReactive(
            vm,
            "$attrs",
            (parentData && parentData.attrs) || emptyObject,
            null,
            true
        );
        defineReactive(
            vm,
            "$listeners",
            options._parentListeners || emptyObject,
            null,
            true
        );
    }
}
var currentRenderingInstance = null;
function renderMixin(Vue2) {
    installRenderHelpers(Vue2.prototype);
    Vue2.prototype.$nextTick = function (fn2) {
        return nextTick(fn2, this);
    };
    Vue2.prototype._render = function () {
        var vm = this;
        var _a = vm.$options,
            render3 = _a.render,
            _parentVnode = _a._parentVnode;
        if (_parentVnode && vm._isMounted) {
            vm.$scopedSlots = normalizeScopedSlots(
                vm.$parent,
                _parentVnode.data.scopedSlots,
                vm.$slots,
                vm.$scopedSlots
            );
            if (vm._slotsProxy) {
                syncSetupSlots(vm._slotsProxy, vm.$scopedSlots);
            }
        }
        vm.$vnode = _parentVnode;
        var vnode;
        try {
            setCurrentInstance(vm);
            currentRenderingInstance = vm;
            vnode = render3.call(vm._renderProxy, vm.$createElement);
        } catch (e) {
            handleError(e, vm, "render");
            {
                vnode = vm._vnode;
            }
        } finally {
            currentRenderingInstance = null;
            setCurrentInstance();
        }
        if (isArray$6(vnode) && vnode.length === 1) {
            vnode = vnode[0];
        }
        if (!(vnode instanceof VNode)) {
            vnode = createEmptyVNode();
        }
        vnode.parent = _parentVnode;
        return vnode;
    };
}
function ensureCtor(comp, base) {
    if (
        comp.__esModule ||
        (hasSymbol && comp[Symbol.toStringTag] === "Module")
    ) {
        comp = comp.default;
    }
    return isObject$a(comp) ? base.extend(comp) : comp;
}
function createAsyncPlaceholder(factory, data3, context, children, tag) {
    var node = createEmptyVNode();
    node.asyncFactory = factory;
    node.asyncMeta = { data: data3, context, children, tag };
    return node;
}
function resolveAsyncComponent(factory, baseCtor) {
    if (isTrue(factory.error) && isDef(factory.errorComp)) {
        return factory.errorComp;
    }
    if (isDef(factory.resolved)) {
        return factory.resolved;
    }
    var owner = currentRenderingInstance;
    if (
        owner &&
        isDef(factory.owners) &&
        factory.owners.indexOf(owner) === -1
    ) {
        factory.owners.push(owner);
    }
    if (isTrue(factory.loading) && isDef(factory.loadingComp)) {
        return factory.loadingComp;
    }
    if (owner && !isDef(factory.owners)) {
        var owners_1 = (factory.owners = [owner]);
        var sync_1 = true;
        var timerLoading_1 = null;
        var timerTimeout_1 = null;
        owner.$on("hook:destroyed", function () {
            return remove$2(owners_1, owner);
        });
        var forceRender_1 = function (renderCompleted) {
            for (var i = 0, l = owners_1.length; i < l; i++) {
                owners_1[i].$forceUpdate();
            }
            if (renderCompleted) {
                owners_1.length = 0;
                if (timerLoading_1 !== null) {
                    clearTimeout(timerLoading_1);
                    timerLoading_1 = null;
                }
                if (timerTimeout_1 !== null) {
                    clearTimeout(timerTimeout_1);
                    timerTimeout_1 = null;
                }
            }
        };
        var resolve = once(function (res2) {
            factory.resolved = ensureCtor(res2, baseCtor);
            if (!sync_1) {
                forceRender_1(true);
            } else {
                owners_1.length = 0;
            }
        });
        var reject_1 = once(function (reason) {
            if (isDef(factory.errorComp)) {
                factory.error = true;
                forceRender_1(true);
            }
        });
        var res_1 = factory(resolve, reject_1);
        if (isObject$a(res_1)) {
            if (isPromise(res_1)) {
                if (isUndef(factory.resolved)) {
                    res_1.then(resolve, reject_1);
                }
            } else if (isPromise(res_1.component)) {
                res_1.component.then(resolve, reject_1);
                if (isDef(res_1.error)) {
                    factory.errorComp = ensureCtor(res_1.error, baseCtor);
                }
                if (isDef(res_1.loading)) {
                    factory.loadingComp = ensureCtor(res_1.loading, baseCtor);
                    if (res_1.delay === 0) {
                        factory.loading = true;
                    } else {
                        timerLoading_1 = setTimeout(function () {
                            timerLoading_1 = null;
                            if (
                                isUndef(factory.resolved) &&
                                isUndef(factory.error)
                            ) {
                                factory.loading = true;
                                forceRender_1(false);
                            }
                        }, res_1.delay || 200);
                    }
                }
                if (isDef(res_1.timeout)) {
                    timerTimeout_1 = setTimeout(function () {
                        timerTimeout_1 = null;
                        if (isUndef(factory.resolved)) {
                            reject_1(null);
                        }
                    }, res_1.timeout);
                }
            }
        }
        sync_1 = false;
        return factory.loading ? factory.loadingComp : factory.resolved;
    }
}
function getFirstComponentChild(children) {
    if (isArray$6(children)) {
        for (var i = 0; i < children.length; i++) {
            var c = children[i];
            if (
                isDef(c) &&
                (isDef(c.componentOptions) || isAsyncPlaceholder(c))
            ) {
                return c;
            }
        }
    }
}
var SIMPLE_NORMALIZE = 1;
var ALWAYS_NORMALIZE = 2;
function createElement$1$1(
    context,
    tag,
    data3,
    children,
    normalizationType,
    alwaysNormalize
) {
    if (isArray$6(data3) || isPrimitive(data3)) {
        normalizationType = children;
        children = data3;
        data3 = void 0;
    }
    if (isTrue(alwaysNormalize)) {
        normalizationType = ALWAYS_NORMALIZE;
    }
    return _createElement(context, tag, data3, children, normalizationType);
}
function _createElement(context, tag, data3, children, normalizationType) {
    if (isDef(data3) && isDef(data3.__ob__)) {
        return createEmptyVNode();
    }
    if (isDef(data3) && isDef(data3.is)) {
        tag = data3.is;
    }
    if (!tag) {
        return createEmptyVNode();
    }
    if (isArray$6(children) && isFunction$7(children[0])) {
        data3 = data3 || {};
        data3.scopedSlots = { default: children[0] };
        children.length = 0;
    }
    if (normalizationType === ALWAYS_NORMALIZE) {
        children = normalizeChildren(children);
    } else if (normalizationType === SIMPLE_NORMALIZE) {
        children = simpleNormalizeChildren(children);
    }
    var vnode, ns2;
    if (typeof tag === "string") {
        var Ctor = void 0;
        ns2 =
            (context.$vnode && context.$vnode.ns) ||
            config.getTagNamespace(tag);
        if (config.isReservedTag(tag)) {
            vnode = new VNode(
                config.parsePlatformTagName(tag),
                data3,
                children,
                void 0,
                void 0,
                context
            );
        } else if (
            (!data3 || !data3.pre) &&
            isDef((Ctor = resolveAsset(context.$options, "components", tag)))
        ) {
            vnode = createComponent(Ctor, data3, context, children, tag);
        } else {
            vnode = new VNode(tag, data3, children, void 0, void 0, context);
        }
    } else {
        vnode = createComponent(tag, data3, context, children);
    }
    if (isArray$6(vnode)) {
        return vnode;
    } else if (isDef(vnode)) {
        if (isDef(ns2)) applyNS(vnode, ns2);
        if (isDef(data3)) registerDeepBindings(data3);
        return vnode;
    } else {
        return createEmptyVNode();
    }
}
function applyNS(vnode, ns2, force) {
    vnode.ns = ns2;
    if (vnode.tag === "foreignObject") {
        ns2 = void 0;
        force = true;
    }
    if (isDef(vnode.children)) {
        for (var i = 0, l = vnode.children.length; i < l; i++) {
            var child = vnode.children[i];
            if (
                isDef(child.tag) &&
                (isUndef(child.ns) || (isTrue(force) && child.tag !== "svg"))
            ) {
                applyNS(child, ns2, force);
            }
        }
    }
}
function registerDeepBindings(data3) {
    if (isObject$a(data3.style)) {
        traverse(data3.style);
    }
    if (isObject$a(data3.class)) {
        traverse(data3.class);
    }
}
function handleError(err, vm, info) {
    pushTarget();
    try {
        if (vm) {
            var cur = vm;
            while ((cur = cur.$parent)) {
                var hooks2 = cur.$options.errorCaptured;
                if (hooks2) {
                    for (var i = 0; i < hooks2.length; i++) {
                        try {
                            var capture =
                                hooks2[i].call(cur, err, vm, info) === false;
                            if (capture) return;
                        } catch (e) {
                            globalHandleError(e, cur, "errorCaptured hook");
                        }
                    }
                }
            }
        }
        globalHandleError(err, vm, info);
    } finally {
        popTarget();
    }
}
function invokeWithErrorHandling(handler3, context, args, vm, info) {
    var res2;
    try {
        res2 = args ? handler3.apply(context, args) : handler3.call(context);
        if (res2 && !res2._isVue && isPromise(res2) && !res2._handled) {
            res2.catch(function (e) {
                return handleError(e, vm, info + " (Promise/async)");
            });
            res2._handled = true;
        }
    } catch (e) {
        handleError(e, vm, info);
    }
    return res2;
}
function globalHandleError(err, vm, info) {
    if (config.errorHandler) {
        try {
            return config.errorHandler.call(null, err, vm, info);
        } catch (e) {
            if (e !== err) {
                logError(e);
            }
        }
    }
    logError(err);
}
function logError(err, vm, info) {
    if (inBrowser && typeof console !== "undefined") {
        console.error(err);
    } else {
        throw err;
    }
}
var isUsingMicroTask = false;
var callbacks = [];
var pending = false;
function flushCallbacks() {
    pending = false;
    var copies = callbacks.slice(0);
    callbacks.length = 0;
    for (var i = 0; i < copies.length; i++) {
        copies[i]();
    }
}
var timerFunc;
if (typeof Promise !== "undefined" && isNative(Promise)) {
    var p_1 = Promise.resolve();
    timerFunc = function () {
        p_1.then(flushCallbacks);
        if (isIOS$1) setTimeout(noop);
    };
    isUsingMicroTask = true;
} else if (
    !isIE$2 &&
    typeof MutationObserver !== "undefined" &&
    (isNative(MutationObserver) ||
        MutationObserver.toString() === "[object MutationObserverConstructor]")
) {
    var counter_1 = 1;
    var observer = new MutationObserver(flushCallbacks);
    var textNode_1 = document.createTextNode(String(counter_1));
    observer.observe(textNode_1, {
        characterData: true,
    });
    timerFunc = function () {
        counter_1 = (counter_1 + 1) % 2;
        textNode_1.data = String(counter_1);
    };
    isUsingMicroTask = true;
} else if (typeof setImmediate !== "undefined" && isNative(setImmediate)) {
    timerFunc = function () {
        setImmediate(flushCallbacks);
    };
} else {
    timerFunc = function () {
        setTimeout(flushCallbacks, 0);
    };
}
function nextTick(cb, ctx) {
    var _resolve;
    callbacks.push(function () {
        if (cb) {
            try {
                cb.call(ctx);
            } catch (e) {
                handleError(e, ctx, "nextTick");
            }
        } else if (_resolve) {
            _resolve(ctx);
        }
    });
    if (!pending) {
        pending = true;
        timerFunc();
    }
    if (!cb && typeof Promise !== "undefined") {
        return new Promise(function (resolve) {
            _resolve = resolve;
        });
    }
}
var version = "2.7.10";
var seenObjects = new _Set$1();
function traverse(val) {
    _traverse(val, seenObjects);
    seenObjects.clear();
    return val;
}
function _traverse(val, seen) {
    var i, keys2;
    var isA = isArray$6(val);
    if (
        (!isA && !isObject$a(val)) ||
        Object.isFrozen(val) ||
        val instanceof VNode
    ) {
        return;
    }
    if (val.__ob__) {
        var depId = val.__ob__.dep.id;
        if (seen.has(depId)) {
            return;
        }
        seen.add(depId);
    }
    if (isA) {
        i = val.length;
        while (i--) _traverse(val[i], seen);
    } else if (isRef(val)) {
        _traverse(val.value, seen);
    } else {
        keys2 = Object.keys(val);
        i = keys2.length;
        while (i--) _traverse(val[keys2[i]], seen);
    }
}
var uid$1 = 0;
var Watcher = (function () {
    function Watcher2(vm, expOrFn, cb, options, isRenderWatcher) {
        recordEffectScope(
            this,
            activeEffectScope && !activeEffectScope._vm
                ? activeEffectScope
                : vm
                ? vm._scope
                : void 0
        );
        if ((this.vm = vm) && isRenderWatcher) {
            vm._watcher = this;
        }
        if (options) {
            this.deep = !!options.deep;
            this.user = !!options.user;
            this.lazy = !!options.lazy;
            this.sync = !!options.sync;
            this.before = options.before;
        } else {
            this.deep = this.user = this.lazy = this.sync = false;
        }
        this.cb = cb;
        this.id = ++uid$1;
        this.active = true;
        this.post = false;
        this.dirty = this.lazy;
        this.deps = [];
        this.newDeps = [];
        this.depIds = new _Set$1();
        this.newDepIds = new _Set$1();
        this.expression = "";
        if (isFunction$7(expOrFn)) {
            this.getter = expOrFn;
        } else {
            this.getter = parsePath(expOrFn);
            if (!this.getter) {
                this.getter = noop;
            }
        }
        this.value = this.lazy ? void 0 : this.get();
    }
    Watcher2.prototype.get = function () {
        pushTarget(this);
        var value;
        var vm = this.vm;
        try {
            value = this.getter.call(vm, vm);
        } catch (e) {
            if (this.user) {
                handleError(
                    e,
                    vm,
                    'getter for watcher "'.concat(this.expression, '"')
                );
            } else {
                throw e;
            }
        } finally {
            if (this.deep) {
                traverse(value);
            }
            popTarget();
            this.cleanupDeps();
        }
        return value;
    };
    Watcher2.prototype.addDep = function (dep) {
        var id = dep.id;
        if (!this.newDepIds.has(id)) {
            this.newDepIds.add(id);
            this.newDeps.push(dep);
            if (!this.depIds.has(id)) {
                dep.addSub(this);
            }
        }
    };
    Watcher2.prototype.cleanupDeps = function () {
        var i = this.deps.length;
        while (i--) {
            var dep = this.deps[i];
            if (!this.newDepIds.has(dep.id)) {
                dep.removeSub(this);
            }
        }
        var tmp = this.depIds;
        this.depIds = this.newDepIds;
        this.newDepIds = tmp;
        this.newDepIds.clear();
        tmp = this.deps;
        this.deps = this.newDeps;
        this.newDeps = tmp;
        this.newDeps.length = 0;
    };
    Watcher2.prototype.update = function () {
        if (this.lazy) {
            this.dirty = true;
        } else if (this.sync) {
            this.run();
        } else {
            queueWatcher(this);
        }
    };
    Watcher2.prototype.run = function () {
        if (this.active) {
            var value = this.get();
            if (value !== this.value || isObject$a(value) || this.deep) {
                var oldValue = this.value;
                this.value = value;
                if (this.user) {
                    var info = 'callback for watcher "'.concat(
                        this.expression,
                        '"'
                    );
                    invokeWithErrorHandling(
                        this.cb,
                        this.vm,
                        [value, oldValue],
                        this.vm,
                        info
                    );
                } else {
                    this.cb.call(this.vm, value, oldValue);
                }
            }
        }
    };
    Watcher2.prototype.evaluate = function () {
        this.value = this.get();
        this.dirty = false;
    };
    Watcher2.prototype.depend = function () {
        var i = this.deps.length;
        while (i--) {
            this.deps[i].depend();
        }
    };
    Watcher2.prototype.teardown = function () {
        if (this.vm && !this.vm._isBeingDestroyed) {
            remove$2(this.vm._scope.effects, this);
        }
        if (this.active) {
            var i = this.deps.length;
            while (i--) {
                this.deps[i].removeSub(this);
            }
            this.active = false;
            if (this.onStop) {
                this.onStop();
            }
        }
    };
    return Watcher2;
})();
function initEvents(vm) {
    vm._events = /* @__PURE__ */ Object.create(null);
    vm._hasHookEvent = false;
    var listeners2 = vm.$options._parentListeners;
    if (listeners2) {
        updateComponentListeners(vm, listeners2);
    }
}
var target$1;
function add$1(event2, fn2) {
    target$1.$on(event2, fn2);
}
function remove$1(event2, fn2) {
    target$1.$off(event2, fn2);
}
function createOnceHandler$1(event2, fn2) {
    var _target = target$1;
    return function onceHandler() {
        var res2 = fn2.apply(null, arguments);
        if (res2 !== null) {
            _target.$off(event2, onceHandler);
        }
    };
}
function updateComponentListeners(vm, listeners2, oldListeners) {
    target$1 = vm;
    updateListeners(
        listeners2,
        oldListeners || {},
        add$1,
        remove$1,
        createOnceHandler$1,
        vm
    );
    target$1 = void 0;
}
function eventsMixin(Vue2) {
    var hookRE = /^hook:/;
    Vue2.prototype.$on = function (event2, fn2) {
        var vm = this;
        if (isArray$6(event2)) {
            for (var i = 0, l = event2.length; i < l; i++) {
                vm.$on(event2[i], fn2);
            }
        } else {
            (vm._events[event2] || (vm._events[event2] = [])).push(fn2);
            if (hookRE.test(event2)) {
                vm._hasHookEvent = true;
            }
        }
        return vm;
    };
    Vue2.prototype.$once = function (event2, fn2) {
        var vm = this;
        function on2() {
            vm.$off(event2, on2);
            fn2.apply(vm, arguments);
        }
        on2.fn = fn2;
        vm.$on(event2, on2);
        return vm;
    };
    Vue2.prototype.$off = function (event2, fn2) {
        var vm = this;
        if (!arguments.length) {
            vm._events = /* @__PURE__ */ Object.create(null);
            return vm;
        }
        if (isArray$6(event2)) {
            for (var i_1 = 0, l = event2.length; i_1 < l; i_1++) {
                vm.$off(event2[i_1], fn2);
            }
            return vm;
        }
        var cbs = vm._events[event2];
        if (!cbs) {
            return vm;
        }
        if (!fn2) {
            vm._events[event2] = null;
            return vm;
        }
        var cb;
        var i = cbs.length;
        while (i--) {
            cb = cbs[i];
            if (cb === fn2 || cb.fn === fn2) {
                cbs.splice(i, 1);
                break;
            }
        }
        return vm;
    };
    Vue2.prototype.$emit = function (event2) {
        var vm = this;
        var cbs = vm._events[event2];
        if (cbs) {
            cbs = cbs.length > 1 ? toArray$1(cbs) : cbs;
            var args = toArray$1(arguments, 1);
            var info = 'event handler for "'.concat(event2, '"');
            for (var i = 0, l = cbs.length; i < l; i++) {
                invokeWithErrorHandling(cbs[i], vm, args, vm, info);
            }
        }
        return vm;
    };
}
var activeInstance = null;
function setActiveInstance(vm) {
    var prevActiveInstance = activeInstance;
    activeInstance = vm;
    return function () {
        activeInstance = prevActiveInstance;
    };
}
function initLifecycle(vm) {
    var options = vm.$options;
    var parent = options.parent;
    if (parent && !options.abstract) {
        while (parent.$options.abstract && parent.$parent) {
            parent = parent.$parent;
        }
        parent.$children.push(vm);
    }
    vm.$parent = parent;
    vm.$root = parent ? parent.$root : vm;
    vm.$children = [];
    vm.$refs = {};
    vm._provided = parent
        ? parent._provided
        : /* @__PURE__ */ Object.create(null);
    vm._watcher = null;
    vm._inactive = null;
    vm._directInactive = false;
    vm._isMounted = false;
    vm._isDestroyed = false;
    vm._isBeingDestroyed = false;
}
function lifecycleMixin(Vue2) {
    Vue2.prototype._update = function (vnode, hydrating) {
        var vm = this;
        var prevEl = vm.$el;
        var prevVnode = vm._vnode;
        var restoreActiveInstance = setActiveInstance(vm);
        vm._vnode = vnode;
        if (!prevVnode) {
            vm.$el = vm.__patch__(vm.$el, vnode, hydrating, false);
        } else {
            vm.$el = vm.__patch__(prevVnode, vnode);
        }
        restoreActiveInstance();
        if (prevEl) {
            prevEl.__vue__ = null;
        }
        if (vm.$el) {
            vm.$el.__vue__ = vm;
        }
        var wrapper = vm;
        while (
            wrapper &&
            wrapper.$vnode &&
            wrapper.$parent &&
            wrapper.$vnode === wrapper.$parent._vnode
        ) {
            wrapper.$parent.$el = wrapper.$el;
            wrapper = wrapper.$parent;
        }
    };
    Vue2.prototype.$forceUpdate = function () {
        var vm = this;
        if (vm._watcher) {
            vm._watcher.update();
        }
    };
    Vue2.prototype.$destroy = function () {
        var vm = this;
        if (vm._isBeingDestroyed) {
            return;
        }
        callHook$1(vm, "beforeDestroy");
        vm._isBeingDestroyed = true;
        var parent = vm.$parent;
        if (parent && !parent._isBeingDestroyed && !vm.$options.abstract) {
            remove$2(parent.$children, vm);
        }
        vm._scope.stop();
        if (vm._data.__ob__) {
            vm._data.__ob__.vmCount--;
        }
        vm._isDestroyed = true;
        vm.__patch__(vm._vnode, null);
        callHook$1(vm, "destroyed");
        vm.$off();
        if (vm.$el) {
            vm.$el.__vue__ = null;
        }
        if (vm.$vnode) {
            vm.$vnode.parent = null;
        }
    };
}
function mountComponent(vm, el, hydrating) {
    vm.$el = el;
    if (!vm.$options.render) {
        vm.$options.render = createEmptyVNode;
    }
    callHook$1(vm, "beforeMount");
    var updateComponent;
    {
        updateComponent = function () {
            vm._update(vm._render(), hydrating);
        };
    }
    var watcherOptions = {
        before: function () {
            if (vm._isMounted && !vm._isDestroyed) {
                callHook$1(vm, "beforeUpdate");
            }
        },
    };
    new Watcher(vm, updateComponent, noop, watcherOptions, true);
    hydrating = false;
    var preWatchers = vm._preWatchers;
    if (preWatchers) {
        for (var i = 0; i < preWatchers.length; i++) {
            preWatchers[i].run();
        }
    }
    if (vm.$vnode == null) {
        vm._isMounted = true;
        callHook$1(vm, "mounted");
    }
    return vm;
}
function updateChildComponent(
    vm,
    propsData,
    listeners2,
    parentVnode,
    renderChildren
) {
    var newScopedSlots = parentVnode.data.scopedSlots;
    var oldScopedSlots = vm.$scopedSlots;
    var hasDynamicScopedSlot = !!(
        (newScopedSlots && !newScopedSlots.$stable) ||
        (oldScopedSlots !== emptyObject && !oldScopedSlots.$stable) ||
        (newScopedSlots && vm.$scopedSlots.$key !== newScopedSlots.$key) ||
        (!newScopedSlots && vm.$scopedSlots.$key)
    );
    var needsForceUpdate = !!(
        renderChildren ||
        vm.$options._renderChildren ||
        hasDynamicScopedSlot
    );
    var prevVNode = vm.$vnode;
    vm.$options._parentVnode = parentVnode;
    vm.$vnode = parentVnode;
    if (vm._vnode) {
        vm._vnode.parent = parentVnode;
    }
    vm.$options._renderChildren = renderChildren;
    var attrs2 = parentVnode.data.attrs || emptyObject;
    if (vm._attrsProxy) {
        if (
            syncSetupProxy(
                vm._attrsProxy,
                attrs2,
                (prevVNode.data && prevVNode.data.attrs) || emptyObject,
                vm,
                "$attrs"
            )
        ) {
            needsForceUpdate = true;
        }
    }
    vm.$attrs = attrs2;
    listeners2 = listeners2 || emptyObject;
    var prevListeners = vm.$options._parentListeners;
    if (vm._listenersProxy) {
        syncSetupProxy(
            vm._listenersProxy,
            listeners2,
            prevListeners || emptyObject,
            vm,
            "$listeners"
        );
    }
    vm.$listeners = vm.$options._parentListeners = listeners2;
    updateComponentListeners(vm, listeners2, prevListeners);
    if (propsData && vm.$options.props) {
        toggleObserving(false);
        var props2 = vm._props;
        var propKeys = vm.$options._propKeys || [];
        for (var i = 0; i < propKeys.length; i++) {
            var key = propKeys[i];
            var propOptions = vm.$options.props;
            props2[key] = validateProp(key, propOptions, propsData, vm);
        }
        toggleObserving(true);
        vm.$options.propsData = propsData;
    }
    if (needsForceUpdate) {
        vm.$slots = resolveSlots(renderChildren, parentVnode.context);
        vm.$forceUpdate();
    }
}
function isInInactiveTree(vm) {
    while (vm && (vm = vm.$parent)) {
        if (vm._inactive) return true;
    }
    return false;
}
function activateChildComponent(vm, direct) {
    if (direct) {
        vm._directInactive = false;
        if (isInInactiveTree(vm)) {
            return;
        }
    } else if (vm._directInactive) {
        return;
    }
    if (vm._inactive || vm._inactive === null) {
        vm._inactive = false;
        for (var i = 0; i < vm.$children.length; i++) {
            activateChildComponent(vm.$children[i]);
        }
        callHook$1(vm, "activated");
    }
}
function deactivateChildComponent(vm, direct) {
    if (direct) {
        vm._directInactive = true;
        if (isInInactiveTree(vm)) {
            return;
        }
    }
    if (!vm._inactive) {
        vm._inactive = true;
        for (var i = 0; i < vm.$children.length; i++) {
            deactivateChildComponent(vm.$children[i]);
        }
        callHook$1(vm, "deactivated");
    }
}
function callHook$1(vm, hook, args, setContext) {
    if (setContext === void 0) {
        setContext = true;
    }
    pushTarget();
    var prev = currentInstance;
    setContext && setCurrentInstance(vm);
    var handlers = vm.$options[hook];
    var info = "".concat(hook, " hook");
    if (handlers) {
        for (var i = 0, j = handlers.length; i < j; i++) {
            invokeWithErrorHandling(handlers[i], vm, args || null, vm, info);
        }
    }
    if (vm._hasHookEvent) {
        vm.$emit("hook:" + hook);
    }
    setContext && setCurrentInstance(prev);
    popTarget();
}
var queue = [];
var activatedChildren = [];
var has = {};
var waiting = false;
var flushing = false;
var index$1 = 0;
function resetSchedulerState() {
    index$1 = queue.length = activatedChildren.length = 0;
    has = {};
    waiting = flushing = false;
}
var currentFlushTimestamp = 0;
var getNow = Date.now;
if (inBrowser && !isIE$2) {
    var performance_1 = window.performance;
    if (
        performance_1 &&
        typeof performance_1.now === "function" &&
        getNow() > document.createEvent("Event").timeStamp
    ) {
        getNow = function () {
            return performance_1.now();
        };
    }
}
var sortCompareFn = function (a, b) {
    if (a.post) {
        if (!b.post) return 1;
    } else if (b.post) {
        return -1;
    }
    return a.id - b.id;
};
function flushSchedulerQueue() {
    currentFlushTimestamp = getNow();
    flushing = true;
    var watcher, id;
    queue.sort(sortCompareFn);
    for (index$1 = 0; index$1 < queue.length; index$1++) {
        watcher = queue[index$1];
        if (watcher.before) {
            watcher.before();
        }
        id = watcher.id;
        has[id] = null;
        watcher.run();
    }
    var activatedQueue = activatedChildren.slice();
    var updatedQueue = queue.slice();
    resetSchedulerState();
    callActivatedHooks(activatedQueue);
    callUpdatedHooks(updatedQueue);
    if (devtools && config.devtools) {
        devtools.emit("flush");
    }
}
function callUpdatedHooks(queue2) {
    var i = queue2.length;
    while (i--) {
        var watcher = queue2[i];
        var vm = watcher.vm;
        if (
            vm &&
            vm._watcher === watcher &&
            vm._isMounted &&
            !vm._isDestroyed
        ) {
            callHook$1(vm, "updated");
        }
    }
}
function queueActivatedComponent(vm) {
    vm._inactive = false;
    activatedChildren.push(vm);
}
function callActivatedHooks(queue2) {
    for (var i = 0; i < queue2.length; i++) {
        queue2[i]._inactive = true;
        activateChildComponent(queue2[i], true);
    }
}
function queueWatcher(watcher) {
    var id = watcher.id;
    if (has[id] != null) {
        return;
    }
    if (watcher === Dep.target && watcher.noRecurse) {
        return;
    }
    has[id] = true;
    if (!flushing) {
        queue.push(watcher);
    } else {
        var i = queue.length - 1;
        while (i > index$1 && queue[i].id > watcher.id) {
            i--;
        }
        queue.splice(i + 1, 0, watcher);
    }
    if (!waiting) {
        waiting = true;
        nextTick(flushSchedulerQueue);
    }
}
function initProvide(vm) {
    var provideOption = vm.$options.provide;
    if (provideOption) {
        var provided = isFunction$7(provideOption)
            ? provideOption.call(vm)
            : provideOption;
        if (!isObject$a(provided)) {
            return;
        }
        var source = resolveProvided(vm);
        var keys2 = hasSymbol
            ? Reflect.ownKeys(provided)
            : Object.keys(provided);
        for (var i = 0; i < keys2.length; i++) {
            var key = keys2[i];
            Object.defineProperty(
                source,
                key,
                Object.getOwnPropertyDescriptor(provided, key)
            );
        }
    }
}
function initInjections(vm) {
    var result = resolveInject(vm.$options.inject, vm);
    if (result) {
        toggleObserving(false);
        Object.keys(result).forEach(function (key) {
            {
                defineReactive(vm, key, result[key]);
            }
        });
        toggleObserving(true);
    }
}
function resolveInject(inject, vm) {
    if (inject) {
        var result = /* @__PURE__ */ Object.create(null);
        var keys2 = hasSymbol ? Reflect.ownKeys(inject) : Object.keys(inject);
        for (var i = 0; i < keys2.length; i++) {
            var key = keys2[i];
            if (key === "__ob__") continue;
            var provideKey = inject[key].from;
            if (provideKey in vm._provided) {
                result[key] = vm._provided[provideKey];
            } else if ("default" in inject[key]) {
                var provideDefault = inject[key].default;
                result[key] = isFunction$7(provideDefault)
                    ? provideDefault.call(vm)
                    : provideDefault;
            } else;
        }
        return result;
    }
}
function FunctionalRenderContext(data3, props2, children, parent, Ctor) {
    var _this = this;
    var options = Ctor.options;
    var contextVm;
    if (hasOwn(parent, "_uid")) {
        contextVm = Object.create(parent);
        contextVm._original = parent;
    } else {
        contextVm = parent;
        parent = parent._original;
    }
    var isCompiled = isTrue(options._compiled);
    var needNormalization = !isCompiled;
    this.data = data3;
    this.props = props2;
    this.children = children;
    this.parent = parent;
    this.listeners = data3.on || emptyObject;
    this.injections = resolveInject(options.inject, parent);
    this.slots = function () {
        if (!_this.$slots) {
            normalizeScopedSlots(
                parent,
                data3.scopedSlots,
                (_this.$slots = resolveSlots(children, parent))
            );
        }
        return _this.$slots;
    };
    Object.defineProperty(this, "scopedSlots", {
        enumerable: true,
        get: function () {
            return normalizeScopedSlots(
                parent,
                data3.scopedSlots,
                this.slots()
            );
        },
    });
    if (isCompiled) {
        this.$options = options;
        this.$slots = this.slots();
        this.$scopedSlots = normalizeScopedSlots(
            parent,
            data3.scopedSlots,
            this.$slots
        );
    }
    if (options._scopeId) {
        this._c = function (a, b, c, d) {
            var vnode = createElement$1$1(
                contextVm,
                a,
                b,
                c,
                d,
                needNormalization
            );
            if (vnode && !isArray$6(vnode)) {
                vnode.fnScopeId = options._scopeId;
                vnode.fnContext = parent;
            }
            return vnode;
        };
    } else {
        this._c = function (a, b, c, d) {
            return createElement$1$1(contextVm, a, b, c, d, needNormalization);
        };
    }
}
installRenderHelpers(FunctionalRenderContext.prototype);
function createFunctionalComponent(
    Ctor,
    propsData,
    data3,
    contextVm,
    children
) {
    var options = Ctor.options;
    var props2 = {};
    var propOptions = options.props;
    if (isDef(propOptions)) {
        for (var key in propOptions) {
            props2[key] = validateProp(
                key,
                propOptions,
                propsData || emptyObject
            );
        }
    } else {
        if (isDef(data3.attrs)) mergeProps(props2, data3.attrs);
        if (isDef(data3.props)) mergeProps(props2, data3.props);
    }
    var renderContext = new FunctionalRenderContext(
        data3,
        props2,
        children,
        contextVm,
        Ctor
    );
    var vnode = options.render.call(null, renderContext._c, renderContext);
    if (vnode instanceof VNode) {
        return cloneAndMarkFunctionalResult(
            vnode,
            data3,
            renderContext.parent,
            options
        );
    } else if (isArray$6(vnode)) {
        var vnodes = normalizeChildren(vnode) || [];
        var res2 = new Array(vnodes.length);
        for (var i = 0; i < vnodes.length; i++) {
            res2[i] = cloneAndMarkFunctionalResult(
                vnodes[i],
                data3,
                renderContext.parent,
                options
            );
        }
        return res2;
    }
}
function cloneAndMarkFunctionalResult(
    vnode,
    data3,
    contextVm,
    options,
    renderContext
) {
    var clone2 = cloneVNode(vnode);
    clone2.fnContext = contextVm;
    clone2.fnOptions = options;
    if (data3.slot) {
        (clone2.data || (clone2.data = {})).slot = data3.slot;
    }
    return clone2;
}
function mergeProps(to, from) {
    for (var key in from) {
        to[camelize(key)] = from[key];
    }
}
function getComponentName(options) {
    return options.name || options.__name || options._componentTag;
}
var componentVNodeHooks = {
    init: function (vnode, hydrating) {
        if (
            vnode.componentInstance &&
            !vnode.componentInstance._isDestroyed &&
            vnode.data.keepAlive
        ) {
            var mountedNode = vnode;
            componentVNodeHooks.prepatch(mountedNode, mountedNode);
        } else {
            var child = (vnode.componentInstance =
                createComponentInstanceForVnode(vnode, activeInstance));
            child.$mount(hydrating ? vnode.elm : void 0, hydrating);
        }
    },
    prepatch: function (oldVnode, vnode) {
        var options = vnode.componentOptions;
        var child = (vnode.componentInstance = oldVnode.componentInstance);
        updateChildComponent(
            child,
            options.propsData,
            options.listeners,
            vnode,
            options.children
        );
    },
    insert: function (vnode) {
        var context = vnode.context,
            componentInstance = vnode.componentInstance;
        if (!componentInstance._isMounted) {
            componentInstance._isMounted = true;
            callHook$1(componentInstance, "mounted");
        }
        if (vnode.data.keepAlive) {
            if (context._isMounted) {
                queueActivatedComponent(componentInstance);
            } else {
                activateChildComponent(componentInstance, true);
            }
        }
    },
    destroy: function (vnode) {
        var componentInstance = vnode.componentInstance;
        if (!componentInstance._isDestroyed) {
            if (!vnode.data.keepAlive) {
                componentInstance.$destroy();
            } else {
                deactivateChildComponent(componentInstance, true);
            }
        }
    },
};
var hooksToMerge = Object.keys(componentVNodeHooks);
function createComponent(Ctor, data3, context, children, tag) {
    if (isUndef(Ctor)) {
        return;
    }
    var baseCtor = context.$options._base;
    if (isObject$a(Ctor)) {
        Ctor = baseCtor.extend(Ctor);
    }
    if (typeof Ctor !== "function") {
        return;
    }
    var asyncFactory;
    if (isUndef(Ctor.cid)) {
        asyncFactory = Ctor;
        Ctor = resolveAsyncComponent(asyncFactory, baseCtor);
        if (Ctor === void 0) {
            return createAsyncPlaceholder(
                asyncFactory,
                data3,
                context,
                children,
                tag
            );
        }
    }
    data3 = data3 || {};
    resolveConstructorOptions(Ctor);
    if (isDef(data3.model)) {
        transformModel(Ctor.options, data3);
    }
    var propsData = extractPropsFromVNodeData(data3, Ctor);
    if (isTrue(Ctor.options.functional)) {
        return createFunctionalComponent(
            Ctor,
            propsData,
            data3,
            context,
            children
        );
    }
    var listeners2 = data3.on;
    data3.on = data3.nativeOn;
    if (isTrue(Ctor.options.abstract)) {
        var slot = data3.slot;
        data3 = {};
        if (slot) {
            data3.slot = slot;
        }
    }
    installComponentHooks(data3);
    var name2 = getComponentName(Ctor.options) || tag;
    var vnode = new VNode(
        "vue-component-"
            .concat(Ctor.cid)
            .concat(name2 ? "-".concat(name2) : ""),
        data3,
        void 0,
        void 0,
        void 0,
        context,
        { Ctor, propsData, listeners: listeners2, tag, children },
        asyncFactory
    );
    return vnode;
}
function createComponentInstanceForVnode(vnode, parent) {
    var options = {
        _isComponent: true,
        _parentVnode: vnode,
        parent,
    };
    var inlineTemplate = vnode.data.inlineTemplate;
    if (isDef(inlineTemplate)) {
        options.render = inlineTemplate.render;
        options.staticRenderFns = inlineTemplate.staticRenderFns;
    }
    return new vnode.componentOptions.Ctor(options);
}
function installComponentHooks(data3) {
    var hooks2 = data3.hook || (data3.hook = {});
    for (var i = 0; i < hooksToMerge.length; i++) {
        var key = hooksToMerge[i];
        var existing = hooks2[key];
        var toMerge = componentVNodeHooks[key];
        if (existing !== toMerge && !(existing && existing._merged)) {
            hooks2[key] = existing ? mergeHook(toMerge, existing) : toMerge;
        }
    }
}
function mergeHook(f1, f2) {
    var merged = function (a, b) {
        f1(a, b);
        f2(a, b);
    };
    merged._merged = true;
    return merged;
}
function transformModel(options, data3) {
    var prop = (options.model && options.model.prop) || "value";
    var event2 = (options.model && options.model.event) || "input";
    (data3.attrs || (data3.attrs = {}))[prop] = data3.model.value;
    var on2 = data3.on || (data3.on = {});
    var existing = on2[event2];
    var callback = data3.model.callback;
    if (isDef(existing)) {
        if (
            isArray$6(existing)
                ? existing.indexOf(callback) === -1
                : existing !== callback
        ) {
            on2[event2] = [callback].concat(existing);
        }
    } else {
        on2[event2] = callback;
    }
}
var warn = noop;
var strats = config.optionMergeStrategies;
function mergeData(to, from) {
    if (!from) return to;
    var key, toVal, fromVal;
    var keys2 = hasSymbol ? Reflect.ownKeys(from) : Object.keys(from);
    for (var i = 0; i < keys2.length; i++) {
        key = keys2[i];
        if (key === "__ob__") continue;
        toVal = to[key];
        fromVal = from[key];
        if (!hasOwn(to, key)) {
            set(to, key, fromVal);
        } else if (
            toVal !== fromVal &&
            isPlainObject$2(toVal) &&
            isPlainObject$2(fromVal)
        ) {
            mergeData(toVal, fromVal);
        }
    }
    return to;
}
function mergeDataOrFn(parentVal, childVal, vm) {
    if (!vm) {
        if (!childVal) {
            return parentVal;
        }
        if (!parentVal) {
            return childVal;
        }
        return function mergedDataFn() {
            return mergeData(
                isFunction$7(childVal) ? childVal.call(this, this) : childVal,
                isFunction$7(parentVal) ? parentVal.call(this, this) : parentVal
            );
        };
    } else {
        return function mergedInstanceDataFn() {
            var instanceData = isFunction$7(childVal)
                ? childVal.call(vm, vm)
                : childVal;
            var defaultData = isFunction$7(parentVal)
                ? parentVal.call(vm, vm)
                : parentVal;
            if (instanceData) {
                return mergeData(instanceData, defaultData);
            } else {
                return defaultData;
            }
        };
    }
}
strats.data = function (parentVal, childVal, vm) {
    if (!vm) {
        if (childVal && typeof childVal !== "function") {
            return parentVal;
        }
        return mergeDataOrFn(parentVal, childVal);
    }
    return mergeDataOrFn(parentVal, childVal, vm);
};
function mergeLifecycleHook(parentVal, childVal) {
    var res2 = childVal
        ? parentVal
            ? parentVal.concat(childVal)
            : isArray$6(childVal)
            ? childVal
            : [childVal]
        : parentVal;
    return res2 ? dedupeHooks(res2) : res2;
}
function dedupeHooks(hooks2) {
    var res2 = [];
    for (var i = 0; i < hooks2.length; i++) {
        if (res2.indexOf(hooks2[i]) === -1) {
            res2.push(hooks2[i]);
        }
    }
    return res2;
}
LIFECYCLE_HOOKS.forEach(function (hook) {
    strats[hook] = mergeLifecycleHook;
});
function mergeAssets(parentVal, childVal, vm, key) {
    var res2 = Object.create(parentVal || null);
    if (childVal) {
        return extend(res2, childVal);
    } else {
        return res2;
    }
}
ASSET_TYPES.forEach(function (type) {
    strats[type + "s"] = mergeAssets;
});
strats.watch = function (parentVal, childVal, vm, key) {
    if (parentVal === nativeWatch) parentVal = void 0;
    if (childVal === nativeWatch) childVal = void 0;
    if (!childVal) return Object.create(parentVal || null);
    if (!parentVal) return childVal;
    var ret = {};
    extend(ret, parentVal);
    for (var key_1 in childVal) {
        var parent_1 = ret[key_1];
        var child = childVal[key_1];
        if (parent_1 && !isArray$6(parent_1)) {
            parent_1 = [parent_1];
        }
        ret[key_1] = parent_1
            ? parent_1.concat(child)
            : isArray$6(child)
            ? child
            : [child];
    }
    return ret;
};
strats.props =
    strats.methods =
    strats.inject =
    strats.computed =
        function (parentVal, childVal, vm, key) {
            if (childVal && false) {
                assertObjectType(key, childVal);
            }
            if (!parentVal) return childVal;
            var ret = /* @__PURE__ */ Object.create(null);
            extend(ret, parentVal);
            if (childVal) extend(ret, childVal);
            return ret;
        };
strats.provide = mergeDataOrFn;
var defaultStrat = function (parentVal, childVal) {
    return childVal === void 0 ? parentVal : childVal;
};
function normalizeProps(options, vm) {
    var props2 = options.props;
    if (!props2) return;
    var res2 = {};
    var i, val, name2;
    if (isArray$6(props2)) {
        i = props2.length;
        while (i--) {
            val = props2[i];
            if (typeof val === "string") {
                name2 = camelize(val);
                res2[name2] = { type: null };
            }
        }
    } else if (isPlainObject$2(props2)) {
        for (var key in props2) {
            val = props2[key];
            name2 = camelize(key);
            res2[name2] = isPlainObject$2(val) ? val : { type: val };
        }
    } else;
    options.props = res2;
}
function normalizeInject(options, vm) {
    var inject = options.inject;
    if (!inject) return;
    var normalized = (options.inject = {});
    if (isArray$6(inject)) {
        for (var i = 0; i < inject.length; i++) {
            normalized[inject[i]] = { from: inject[i] };
        }
    } else if (isPlainObject$2(inject)) {
        for (var key in inject) {
            var val = inject[key];
            normalized[key] = isPlainObject$2(val)
                ? extend({ from: key }, val)
                : { from: val };
        }
    } else;
}
function normalizeDirectives$1(options) {
    var dirs = options.directives;
    if (dirs) {
        for (var key in dirs) {
            var def2 = dirs[key];
            if (isFunction$7(def2)) {
                dirs[key] = { bind: def2, update: def2 };
            }
        }
    }
}
function assertObjectType(name2, value, vm) {
    if (!isPlainObject$2(value)) {
        warn(
            'Invalid value for option "'.concat(
                name2,
                '": expected an Object, '
            ) + "but got ".concat(toRawType(value), ".")
        );
    }
}
function mergeOptions(parent, child, vm) {
    if (isFunction$7(child)) {
        child = child.options;
    }
    normalizeProps(child);
    normalizeInject(child);
    normalizeDirectives$1(child);
    if (!child._base) {
        if (child.extends) {
            parent = mergeOptions(parent, child.extends, vm);
        }
        if (child.mixins) {
            for (var i = 0, l = child.mixins.length; i < l; i++) {
                parent = mergeOptions(parent, child.mixins[i], vm);
            }
        }
    }
    var options = {};
    var key;
    for (key in parent) {
        mergeField(key);
    }
    for (key in child) {
        if (!hasOwn(parent, key)) {
            mergeField(key);
        }
    }
    function mergeField(key2) {
        var strat = strats[key2] || defaultStrat;
        options[key2] = strat(parent[key2], child[key2], vm, key2);
    }
    return options;
}
function resolveAsset(options, type, id, warnMissing) {
    if (typeof id !== "string") {
        return;
    }
    var assets = options[type];
    if (hasOwn(assets, id)) return assets[id];
    var camelizedId = camelize(id);
    if (hasOwn(assets, camelizedId)) return assets[camelizedId];
    var PascalCaseId = capitalize(camelizedId);
    if (hasOwn(assets, PascalCaseId)) return assets[PascalCaseId];
    var res2 = assets[id] || assets[camelizedId] || assets[PascalCaseId];
    return res2;
}
function validateProp(key, propOptions, propsData, vm) {
    var prop = propOptions[key];
    var absent = !hasOwn(propsData, key);
    var value = propsData[key];
    var booleanIndex = getTypeIndex(Boolean, prop.type);
    if (booleanIndex > -1) {
        if (absent && !hasOwn(prop, "default")) {
            value = false;
        } else if (value === "" || value === hyphenate(key)) {
            var stringIndex = getTypeIndex(String, prop.type);
            if (stringIndex < 0 || booleanIndex < stringIndex) {
                value = true;
            }
        }
    }
    if (value === void 0) {
        value = getPropDefaultValue(vm, prop, key);
        var prevShouldObserve = shouldObserve;
        toggleObserving(true);
        observe(value);
        toggleObserving(prevShouldObserve);
    }
    return value;
}
function getPropDefaultValue(vm, prop, key) {
    if (!hasOwn(prop, "default")) {
        return void 0;
    }
    var def2 = prop.default;
    if (
        vm &&
        vm.$options.propsData &&
        vm.$options.propsData[key] === void 0 &&
        vm._props[key] !== void 0
    ) {
        return vm._props[key];
    }
    return isFunction$7(def2) && getType$1(prop.type) !== "Function"
        ? def2.call(vm)
        : def2;
}
var functionTypeCheckRE = /^\s*function (\w+)/;
function getType$1(fn2) {
    var match = fn2 && fn2.toString().match(functionTypeCheckRE);
    return match ? match[1] : "";
}
function isSameType(a, b) {
    return getType$1(a) === getType$1(b);
}
function getTypeIndex(type, expectedTypes) {
    if (!isArray$6(expectedTypes)) {
        return isSameType(expectedTypes, type) ? 0 : -1;
    }
    for (var i = 0, len = expectedTypes.length; i < len; i++) {
        if (isSameType(expectedTypes[i], type)) {
            return i;
        }
    }
    return -1;
}
var sharedPropertyDefinition = {
    enumerable: true,
    configurable: true,
    get: noop,
    set: noop,
};
function proxy(target2, sourceKey, key) {
    sharedPropertyDefinition.get = function proxyGetter() {
        return this[sourceKey][key];
    };
    sharedPropertyDefinition.set = function proxySetter(val) {
        this[sourceKey][key] = val;
    };
    Object.defineProperty(target2, key, sharedPropertyDefinition);
}
function initState(vm) {
    var opts = vm.$options;
    if (opts.props) initProps$1(vm, opts.props);
    initSetup(vm);
    if (opts.methods) initMethods(vm, opts.methods);
    if (opts.data) {
        initData(vm);
    } else {
        var ob = observe((vm._data = {}));
        ob && ob.vmCount++;
    }
    if (opts.computed) initComputed$1(vm, opts.computed);
    if (opts.watch && opts.watch !== nativeWatch) {
        initWatch(vm, opts.watch);
    }
}
function initProps$1(vm, propsOptions) {
    var propsData = vm.$options.propsData || {};
    var props2 = (vm._props = shallowReactive({}));
    var keys2 = (vm.$options._propKeys = []);
    var isRoot2 = !vm.$parent;
    if (!isRoot2) {
        toggleObserving(false);
    }
    var _loop_1 = function (key2) {
        keys2.push(key2);
        var value = validateProp(key2, propsOptions, propsData, vm);
        {
            defineReactive(props2, key2, value);
        }
        if (!(key2 in vm)) {
            proxy(vm, "_props", key2);
        }
    };
    for (var key in propsOptions) {
        _loop_1(key);
    }
    toggleObserving(true);
}
function initData(vm) {
    var data3 = vm.$options.data;
    data3 = vm._data = isFunction$7(data3) ? getData(data3, vm) : data3 || {};
    if (!isPlainObject$2(data3)) {
        data3 = {};
    }
    var keys2 = Object.keys(data3);
    var props2 = vm.$options.props;
    vm.$options.methods;
    var i = keys2.length;
    while (i--) {
        var key = keys2[i];
        if (props2 && hasOwn(props2, key));
        else if (!isReserved(key)) {
            proxy(vm, "_data", key);
        }
    }
    var ob = observe(data3);
    ob && ob.vmCount++;
}
function getData(data3, vm) {
    pushTarget();
    try {
        return data3.call(vm, vm);
    } catch (e) {
        handleError(e, vm, "data()");
        return {};
    } finally {
        popTarget();
    }
}
var computedWatcherOptions = { lazy: true };
function initComputed$1(vm, computed) {
    var watchers = (vm._computedWatchers = /* @__PURE__ */ Object.create(null));
    var isSSR = isServerRendering();
    for (var key in computed) {
        var userDef = computed[key];
        var getter = isFunction$7(userDef) ? userDef : userDef.get;
        if (!isSSR) {
            watchers[key] = new Watcher(
                vm,
                getter || noop,
                noop,
                computedWatcherOptions
            );
        }
        if (!(key in vm)) {
            defineComputed(vm, key, userDef);
        }
    }
}
function defineComputed(target2, key, userDef) {
    var shouldCache = !isServerRendering();
    if (isFunction$7(userDef)) {
        sharedPropertyDefinition.get = shouldCache
            ? createComputedGetter(key)
            : createGetterInvoker(userDef);
        sharedPropertyDefinition.set = noop;
    } else {
        sharedPropertyDefinition.get = userDef.get
            ? shouldCache && userDef.cache !== false
                ? createComputedGetter(key)
                : createGetterInvoker(userDef.get)
            : noop;
        sharedPropertyDefinition.set = userDef.set || noop;
    }
    Object.defineProperty(target2, key, sharedPropertyDefinition);
}
function createComputedGetter(key) {
    return function computedGetter() {
        var watcher = this._computedWatchers && this._computedWatchers[key];
        if (watcher) {
            if (watcher.dirty) {
                watcher.evaluate();
            }
            if (Dep.target) {
                watcher.depend();
            }
            return watcher.value;
        }
    };
}
function createGetterInvoker(fn2) {
    return function computedGetter() {
        return fn2.call(this, this);
    };
}
function initMethods(vm, methods2) {
    vm.$options.props;
    for (var key in methods2) {
        vm[key] =
            typeof methods2[key] !== "function"
                ? noop
                : bind$1(methods2[key], vm);
    }
}
function initWatch(vm, watch) {
    for (var key in watch) {
        var handler3 = watch[key];
        if (isArray$6(handler3)) {
            for (var i = 0; i < handler3.length; i++) {
                createWatcher(vm, key, handler3[i]);
            }
        } else {
            createWatcher(vm, key, handler3);
        }
    }
}
function createWatcher(vm, expOrFn, handler3, options) {
    if (isPlainObject$2(handler3)) {
        options = handler3;
        handler3 = handler3.handler;
    }
    if (typeof handler3 === "string") {
        handler3 = vm[handler3];
    }
    return vm.$watch(expOrFn, handler3, options);
}
function stateMixin(Vue2) {
    var dataDef = {};
    dataDef.get = function () {
        return this._data;
    };
    var propsDef = {};
    propsDef.get = function () {
        return this._props;
    };
    Object.defineProperty(Vue2.prototype, "$data", dataDef);
    Object.defineProperty(Vue2.prototype, "$props", propsDef);
    Vue2.prototype.$set = set;
    Vue2.prototype.$delete = del;
    Vue2.prototype.$watch = function (expOrFn, cb, options) {
        var vm = this;
        if (isPlainObject$2(cb)) {
            return createWatcher(vm, expOrFn, cb, options);
        }
        options = options || {};
        options.user = true;
        var watcher = new Watcher(vm, expOrFn, cb, options);
        if (options.immediate) {
            var info = 'callback for immediate watcher "'.concat(
                watcher.expression,
                '"'
            );
            pushTarget();
            invokeWithErrorHandling(cb, vm, [watcher.value], vm, info);
            popTarget();
        }
        return function unwatchFn() {
            watcher.teardown();
        };
    };
}
var uid = 0;
function initMixin$1(Vue2) {
    Vue2.prototype._init = function (options) {
        var vm = this;
        vm._uid = uid++;
        vm._isVue = true;
        vm.__v_skip = true;
        vm._scope = new EffectScope(true);
        vm._scope._vm = true;
        if (options && options._isComponent) {
            initInternalComponent(vm, options);
        } else {
            vm.$options = mergeOptions(
                resolveConstructorOptions(vm.constructor),
                options || {},
                vm
            );
        }
        {
            vm._renderProxy = vm;
        }
        vm._self = vm;
        initLifecycle(vm);
        initEvents(vm);
        initRender(vm);
        callHook$1(vm, "beforeCreate", void 0, false);
        initInjections(vm);
        initState(vm);
        initProvide(vm);
        callHook$1(vm, "created");
        if (vm.$options.el) {
            vm.$mount(vm.$options.el);
        }
    };
}
function initInternalComponent(vm, options) {
    var opts = (vm.$options = Object.create(vm.constructor.options));
    var parentVnode = options._parentVnode;
    opts.parent = options.parent;
    opts._parentVnode = parentVnode;
    var vnodeComponentOptions = parentVnode.componentOptions;
    opts.propsData = vnodeComponentOptions.propsData;
    opts._parentListeners = vnodeComponentOptions.listeners;
    opts._renderChildren = vnodeComponentOptions.children;
    opts._componentTag = vnodeComponentOptions.tag;
    if (options.render) {
        opts.render = options.render;
        opts.staticRenderFns = options.staticRenderFns;
    }
}
function resolveConstructorOptions(Ctor) {
    var options = Ctor.options;
    if (Ctor.super) {
        var superOptions = resolveConstructorOptions(Ctor.super);
        var cachedSuperOptions = Ctor.superOptions;
        if (superOptions !== cachedSuperOptions) {
            Ctor.superOptions = superOptions;
            var modifiedOptions = resolveModifiedOptions(Ctor);
            if (modifiedOptions) {
                extend(Ctor.extendOptions, modifiedOptions);
            }
            options = Ctor.options = mergeOptions(
                superOptions,
                Ctor.extendOptions
            );
            if (options.name) {
                options.components[options.name] = Ctor;
            }
        }
    }
    return options;
}
function resolveModifiedOptions(Ctor) {
    var modified;
    var latest = Ctor.options;
    var sealed = Ctor.sealedOptions;
    for (var key in latest) {
        if (latest[key] !== sealed[key]) {
            if (!modified) modified = {};
            modified[key] = latest[key];
        }
    }
    return modified;
}
function Vue(options) {
    this._init(options);
}
initMixin$1(Vue);
stateMixin(Vue);
eventsMixin(Vue);
lifecycleMixin(Vue);
renderMixin(Vue);
function initUse(Vue2) {
    Vue2.use = function (plugin2) {
        var installedPlugins =
            this._installedPlugins || (this._installedPlugins = []);
        if (installedPlugins.indexOf(plugin2) > -1) {
            return this;
        }
        var args = toArray$1(arguments, 1);
        args.unshift(this);
        if (isFunction$7(plugin2.install)) {
            plugin2.install.apply(plugin2, args);
        } else if (isFunction$7(plugin2)) {
            plugin2.apply(null, args);
        }
        installedPlugins.push(plugin2);
        return this;
    };
}
function initMixin(Vue2) {
    Vue2.mixin = function (mixin) {
        this.options = mergeOptions(this.options, mixin);
        return this;
    };
}
function initExtend(Vue2) {
    Vue2.cid = 0;
    var cid = 1;
    Vue2.extend = function (extendOptions) {
        extendOptions = extendOptions || {};
        var Super = this;
        var SuperId = Super.cid;
        var cachedCtors = extendOptions._Ctor || (extendOptions._Ctor = {});
        if (cachedCtors[SuperId]) {
            return cachedCtors[SuperId];
        }
        var name2 =
            getComponentName(extendOptions) || getComponentName(Super.options);
        var Sub = function VueComponent(options) {
            this._init(options);
        };
        Sub.prototype = Object.create(Super.prototype);
        Sub.prototype.constructor = Sub;
        Sub.cid = cid++;
        Sub.options = mergeOptions(Super.options, extendOptions);
        Sub["super"] = Super;
        if (Sub.options.props) {
            initProps(Sub);
        }
        if (Sub.options.computed) {
            initComputed(Sub);
        }
        Sub.extend = Super.extend;
        Sub.mixin = Super.mixin;
        Sub.use = Super.use;
        ASSET_TYPES.forEach(function (type) {
            Sub[type] = Super[type];
        });
        if (name2) {
            Sub.options.components[name2] = Sub;
        }
        Sub.superOptions = Super.options;
        Sub.extendOptions = extendOptions;
        Sub.sealedOptions = extend({}, Sub.options);
        cachedCtors[SuperId] = Sub;
        return Sub;
    };
}
function initProps(Comp) {
    var props2 = Comp.options.props;
    for (var key in props2) {
        proxy(Comp.prototype, "_props", key);
    }
}
function initComputed(Comp) {
    var computed = Comp.options.computed;
    for (var key in computed) {
        defineComputed(Comp.prototype, key, computed[key]);
    }
}
function initAssetRegisters(Vue2) {
    ASSET_TYPES.forEach(function (type) {
        Vue2[type] = function (id, definition) {
            if (!definition) {
                return this.options[type + "s"][id];
            } else {
                if (type === "component" && isPlainObject$2(definition)) {
                    definition.name = definition.name || id;
                    definition = this.options._base.extend(definition);
                }
                if (type === "directive" && isFunction$7(definition)) {
                    definition = { bind: definition, update: definition };
                }
                this.options[type + "s"][id] = definition;
                return definition;
            }
        };
    });
}
function _getComponentName(opts) {
    return opts && (getComponentName(opts.Ctor.options) || opts.tag);
}
function matches(pattern, name2) {
    if (isArray$6(pattern)) {
        return pattern.indexOf(name2) > -1;
    } else if (typeof pattern === "string") {
        return pattern.split(",").indexOf(name2) > -1;
    } else if (isRegExp(pattern)) {
        return pattern.test(name2);
    }
    return false;
}
function pruneCache(keepAliveInstance, filter) {
    var cache = keepAliveInstance.cache,
        keys2 = keepAliveInstance.keys,
        _vnode = keepAliveInstance._vnode;
    for (var key in cache) {
        var entry = cache[key];
        if (entry) {
            var name_1 = entry.name;
            if (name_1 && !filter(name_1)) {
                pruneCacheEntry(cache, key, keys2, _vnode);
            }
        }
    }
}
function pruneCacheEntry(cache, key, keys2, current) {
    var entry = cache[key];
    if (entry && (!current || entry.tag !== current.tag)) {
        entry.componentInstance.$destroy();
    }
    cache[key] = null;
    remove$2(keys2, key);
}
var patternTypes = [String, RegExp, Array];
var KeepAlive = {
    name: "keep-alive",
    abstract: true,
    props: {
        include: patternTypes,
        exclude: patternTypes,
        max: [String, Number],
    },
    methods: {
        cacheVNode: function () {
            var _a = this,
                cache = _a.cache,
                keys2 = _a.keys,
                vnodeToCache = _a.vnodeToCache,
                keyToCache = _a.keyToCache;
            if (vnodeToCache) {
                var tag = vnodeToCache.tag,
                    componentInstance = vnodeToCache.componentInstance,
                    componentOptions = vnodeToCache.componentOptions;
                cache[keyToCache] = {
                    name: _getComponentName(componentOptions),
                    tag,
                    componentInstance,
                };
                keys2.push(keyToCache);
                if (this.max && keys2.length > parseInt(this.max)) {
                    pruneCacheEntry(cache, keys2[0], keys2, this._vnode);
                }
                this.vnodeToCache = null;
            }
        },
    },
    created: function () {
        this.cache = /* @__PURE__ */ Object.create(null);
        this.keys = [];
    },
    destroyed: function () {
        for (var key in this.cache) {
            pruneCacheEntry(this.cache, key, this.keys);
        }
    },
    mounted: function () {
        var _this = this;
        this.cacheVNode();
        this.$watch("include", function (val) {
            pruneCache(_this, function (name2) {
                return matches(val, name2);
            });
        });
        this.$watch("exclude", function (val) {
            pruneCache(_this, function (name2) {
                return !matches(val, name2);
            });
        });
    },
    updated: function () {
        this.cacheVNode();
    },
    render: function () {
        var slot = this.$slots.default;
        var vnode = getFirstComponentChild(slot);
        var componentOptions = vnode && vnode.componentOptions;
        if (componentOptions) {
            var name_2 = _getComponentName(componentOptions);
            var _a = this,
                include = _a.include,
                exclude = _a.exclude;
            if (
                (include && (!name_2 || !matches(include, name_2))) ||
                (exclude && name_2 && matches(exclude, name_2))
            ) {
                return vnode;
            }
            var _b = this,
                cache = _b.cache,
                keys2 = _b.keys;
            var key =
                vnode.key == null
                    ? componentOptions.Ctor.cid +
                      (componentOptions.tag
                          ? "::".concat(componentOptions.tag)
                          : "")
                    : vnode.key;
            if (cache[key]) {
                vnode.componentInstance = cache[key].componentInstance;
                remove$2(keys2, key);
                keys2.push(key);
            } else {
                this.vnodeToCache = vnode;
                this.keyToCache = key;
            }
            vnode.data.keepAlive = true;
        }
        return vnode || (slot && slot[0]);
    },
};
var builtInComponents = {
    KeepAlive,
};
function initGlobalAPI(Vue2) {
    var configDef = {};
    configDef.get = function () {
        return config;
    };
    Object.defineProperty(Vue2, "config", configDef);
    Vue2.util = {
        warn,
        extend,
        mergeOptions,
        defineReactive,
    };
    Vue2.set = set;
    Vue2.delete = del;
    Vue2.nextTick = nextTick;
    Vue2.observable = function (obj) {
        observe(obj);
        return obj;
    };
    Vue2.options = /* @__PURE__ */ Object.create(null);
    ASSET_TYPES.forEach(function (type) {
        Vue2.options[type + "s"] = /* @__PURE__ */ Object.create(null);
    });
    Vue2.options._base = Vue2;
    extend(Vue2.options.components, builtInComponents);
    initUse(Vue2);
    initMixin(Vue2);
    initExtend(Vue2);
    initAssetRegisters(Vue2);
}
initGlobalAPI(Vue);
Object.defineProperty(Vue.prototype, "$isServer", {
    get: isServerRendering,
});
Object.defineProperty(Vue.prototype, "$ssrContext", {
    get: function () {
        return this.$vnode && this.$vnode.ssrContext;
    },
});
Object.defineProperty(Vue, "FunctionalRenderContext", {
    value: FunctionalRenderContext,
});
Vue.version = version;
var isReservedAttr = makeMap("style,class");
var acceptValue = makeMap("input,textarea,option,select,progress");
var mustUseProp = function (tag, type, attr2) {
    return (
        (attr2 === "value" && acceptValue(tag) && type !== "button") ||
        (attr2 === "selected" && tag === "option") ||
        (attr2 === "checked" && tag === "input") ||
        (attr2 === "muted" && tag === "video")
    );
};
var isEnumeratedAttr = makeMap("contenteditable,draggable,spellcheck");
var isValidContentEditableValue = makeMap("events,caret,typing,plaintext-only");
var convertEnumeratedValue = function (key, value) {
    return isFalsyAttrValue(value) || value === "false"
        ? "false"
        : key === "contenteditable" && isValidContentEditableValue(value)
        ? value
        : "true";
};
var isBooleanAttr = makeMap(
    "allowfullscreen,async,autofocus,autoplay,checked,compact,controls,declare,default,defaultchecked,defaultmuted,defaultselected,defer,disabled,enabled,formnovalidate,hidden,indeterminate,inert,ismap,itemscope,loop,multiple,muted,nohref,noresize,noshade,novalidate,nowrap,open,pauseonexit,readonly,required,reversed,scoped,seamless,selected,sortable,truespeed,typemustmatch,visible"
);
var xlinkNS = "http://www.w3.org/1999/xlink";
var isXlink = function (name2) {
    return name2.charAt(5) === ":" && name2.slice(0, 5) === "xlink";
};
var getXlinkProp = function (name2) {
    return isXlink(name2) ? name2.slice(6, name2.length) : "";
};
var isFalsyAttrValue = function (val) {
    return val == null || val === false;
};
function genClassForVnode(vnode) {
    var data3 = vnode.data;
    var parentNode2 = vnode;
    var childNode = vnode;
    while (isDef(childNode.componentInstance)) {
        childNode = childNode.componentInstance._vnode;
        if (childNode && childNode.data) {
            data3 = mergeClassData(childNode.data, data3);
        }
    }
    while (isDef((parentNode2 = parentNode2.parent))) {
        if (parentNode2 && parentNode2.data) {
            data3 = mergeClassData(data3, parentNode2.data);
        }
    }
    return renderClass(data3.staticClass, data3.class);
}
function mergeClassData(child, parent) {
    return {
        staticClass: concat(child.staticClass, parent.staticClass),
        class: isDef(child.class) ? [child.class, parent.class] : parent.class,
    };
}
function renderClass(staticClass, dynamicClass) {
    if (isDef(staticClass) || isDef(dynamicClass)) {
        return concat(staticClass, stringifyClass(dynamicClass));
    }
    return "";
}
function concat(a, b) {
    return a ? (b ? a + " " + b : a) : b || "";
}
function stringifyClass(value) {
    if (Array.isArray(value)) {
        return stringifyArray(value);
    }
    if (isObject$a(value)) {
        return stringifyObject(value);
    }
    if (typeof value === "string") {
        return value;
    }
    return "";
}
function stringifyArray(value) {
    var res2 = "";
    var stringified;
    for (var i = 0, l = value.length; i < l; i++) {
        if (
            isDef((stringified = stringifyClass(value[i]))) &&
            stringified !== ""
        ) {
            if (res2) res2 += " ";
            res2 += stringified;
        }
    }
    return res2;
}
function stringifyObject(value) {
    var res2 = "";
    for (var key in value) {
        if (value[key]) {
            if (res2) res2 += " ";
            res2 += key;
        }
    }
    return res2;
}
var namespaceMap = {
    svg: "http://www.w3.org/2000/svg",
    math: "http://www.w3.org/1998/Math/MathML",
};
var isHTMLTag = makeMap(
    "html,body,base,head,link,meta,style,title,address,article,aside,footer,header,h1,h2,h3,h4,h5,h6,hgroup,nav,section,div,dd,dl,dt,figcaption,figure,picture,hr,img,li,main,ol,p,pre,ul,a,b,abbr,bdi,bdo,br,cite,code,data,dfn,em,i,kbd,mark,q,rp,rt,rtc,ruby,s,samp,small,span,strong,sub,sup,time,u,var,wbr,area,audio,map,track,video,embed,object,param,source,canvas,script,noscript,del,ins,caption,col,colgroup,table,thead,tbody,td,th,tr,button,datalist,fieldset,form,input,label,legend,meter,optgroup,option,output,progress,select,textarea,details,dialog,menu,menuitem,summary,content,element,shadow,template,blockquote,iframe,tfoot"
);
var isSVG = makeMap(
    "svg,animate,circle,clippath,cursor,defs,desc,ellipse,filter,font-face,foreignobject,g,glyph,image,line,marker,mask,missing-glyph,path,pattern,polygon,polyline,rect,switch,symbol,text,textpath,tspan,use,view",
    true
);
var isReservedTag = function (tag) {
    return isHTMLTag(tag) || isSVG(tag);
};
function getTagNamespace(tag) {
    if (isSVG(tag)) {
        return "svg";
    }
    if (tag === "math") {
        return "math";
    }
}
var unknownElementCache = /* @__PURE__ */ Object.create(null);
function isUnknownElement(tag) {
    if (!inBrowser) {
        return true;
    }
    if (isReservedTag(tag)) {
        return false;
    }
    tag = tag.toLowerCase();
    if (unknownElementCache[tag] != null) {
        return unknownElementCache[tag];
    }
    var el = document.createElement(tag);
    if (tag.indexOf("-") > -1) {
        return (unknownElementCache[tag] =
            el.constructor === window.HTMLUnknownElement ||
            el.constructor === window.HTMLElement);
    } else {
        return (unknownElementCache[tag] = /HTMLUnknownElement/.test(
            el.toString()
        ));
    }
}
var isTextInputType = makeMap("text,number,password,search,email,tel,url");
function query(el) {
    if (typeof el === "string") {
        var selected = document.querySelector(el);
        if (!selected) {
            return document.createElement("div");
        }
        return selected;
    } else {
        return el;
    }
}
function createElement$2(tagName2, vnode) {
    var elm = document.createElement(tagName2);
    if (tagName2 !== "select") {
        return elm;
    }
    if (
        vnode.data &&
        vnode.data.attrs &&
        vnode.data.attrs.multiple !== void 0
    ) {
        elm.setAttribute("multiple", "multiple");
    }
    return elm;
}
function createElementNS(namespace, tagName2) {
    return document.createElementNS(namespaceMap[namespace], tagName2);
}
function createTextNode(text2) {
    return document.createTextNode(text2);
}
function createComment(text2) {
    return document.createComment(text2);
}
function insertBefore$1(parentNode2, newNode, referenceNode) {
    parentNode2.insertBefore(newNode, referenceNode);
}
function removeChild(node, child) {
    node.removeChild(child);
}
function appendChild$1(node, child) {
    node.appendChild(child);
}
function parentNode(node) {
    return node.parentNode;
}
function nextSibling(node) {
    return node.nextSibling;
}
function tagName(node) {
    return node.tagName;
}
function setTextContent(node, text2) {
    node.textContent = text2;
}
function setStyleScope(node, scopeId) {
    node.setAttribute(scopeId, "");
}
var nodeOps = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    createElement: createElement$2,
    createElementNS,
    createTextNode,
    createComment,
    insertBefore: insertBefore$1,
    removeChild,
    appendChild: appendChild$1,
    parentNode,
    nextSibling,
    tagName,
    setTextContent,
    setStyleScope,
});
var ref = {
    create: function (_2, vnode) {
        registerRef(vnode);
    },
    update: function (oldVnode, vnode) {
        if (oldVnode.data.ref !== vnode.data.ref) {
            registerRef(oldVnode, true);
            registerRef(vnode);
        }
    },
    destroy: function (vnode) {
        registerRef(vnode, true);
    },
};
function registerRef(vnode, isRemoval) {
    var ref2 = vnode.data.ref;
    if (!isDef(ref2)) return;
    var vm = vnode.context;
    var refValue = vnode.componentInstance || vnode.elm;
    var value = isRemoval ? null : refValue;
    var $refsValue = isRemoval ? void 0 : refValue;
    if (isFunction$7(ref2)) {
        invokeWithErrorHandling(ref2, vm, [value], vm, "template ref function");
        return;
    }
    var isFor = vnode.data.refInFor;
    var _isString = typeof ref2 === "string" || typeof ref2 === "number";
    var _isRef = isRef(ref2);
    var refs = vm.$refs;
    if (_isString || _isRef) {
        if (isFor) {
            var existing = _isString ? refs[ref2] : ref2.value;
            if (isRemoval) {
                isArray$6(existing) && remove$2(existing, refValue);
            } else {
                if (!isArray$6(existing)) {
                    if (_isString) {
                        refs[ref2] = [refValue];
                        setSetupRef(vm, ref2, refs[ref2]);
                    } else {
                        ref2.value = [refValue];
                    }
                } else if (!existing.includes(refValue)) {
                    existing.push(refValue);
                }
            }
        } else if (_isString) {
            if (isRemoval && refs[ref2] !== refValue) {
                return;
            }
            refs[ref2] = $refsValue;
            setSetupRef(vm, ref2, value);
        } else if (_isRef) {
            if (isRemoval && ref2.value !== refValue) {
                return;
            }
            ref2.value = value;
        } else;
    }
}
function setSetupRef(_a, key, val) {
    var _setupState = _a._setupState;
    if (_setupState && hasOwn(_setupState, key)) {
        if (isRef(_setupState[key])) {
            _setupState[key].value = val;
        } else {
            _setupState[key] = val;
        }
    }
}
var emptyNode = new VNode("", {}, []);
var hooks = ["create", "activate", "update", "remove", "destroy"];
function sameVnode(a, b) {
    return (
        a.key === b.key &&
        a.asyncFactory === b.asyncFactory &&
        ((a.tag === b.tag &&
            a.isComment === b.isComment &&
            isDef(a.data) === isDef(b.data) &&
            sameInputType(a, b)) ||
            (isTrue(a.isAsyncPlaceholder) && isUndef(b.asyncFactory.error)))
    );
}
function sameInputType(a, b) {
    if (a.tag !== "input") return true;
    var i;
    var typeA = isDef((i = a.data)) && isDef((i = i.attrs)) && i.type;
    var typeB = isDef((i = b.data)) && isDef((i = i.attrs)) && i.type;
    return (
        typeA === typeB || (isTextInputType(typeA) && isTextInputType(typeB))
    );
}
function createKeyToOldIdx(children, beginIdx, endIdx) {
    var i, key;
    var map2 = {};
    for (i = beginIdx; i <= endIdx; ++i) {
        key = children[i].key;
        if (isDef(key)) map2[key] = i;
    }
    return map2;
}
function createPatchFunction(backend) {
    var i, j;
    var cbs = {};
    var modules2 = backend.modules,
        nodeOps2 = backend.nodeOps;
    for (i = 0; i < hooks.length; ++i) {
        cbs[hooks[i]] = [];
        for (j = 0; j < modules2.length; ++j) {
            if (isDef(modules2[j][hooks[i]])) {
                cbs[hooks[i]].push(modules2[j][hooks[i]]);
            }
        }
    }
    function emptyNodeAt(elm) {
        return new VNode(
            nodeOps2.tagName(elm).toLowerCase(),
            {},
            [],
            void 0,
            elm
        );
    }
    function createRmCb(childElm, listeners2) {
        function remove2() {
            if (--remove2.listeners === 0) {
                removeNode(childElm);
            }
        }
        remove2.listeners = listeners2;
        return remove2;
    }
    function removeNode(el) {
        var parent = nodeOps2.parentNode(el);
        if (isDef(parent)) {
            nodeOps2.removeChild(parent, el);
        }
    }
    function createElm(
        vnode,
        insertedVnodeQueue,
        parentElm,
        refElm,
        nested,
        ownerArray,
        index2
    ) {
        if (isDef(vnode.elm) && isDef(ownerArray)) {
            vnode = ownerArray[index2] = cloneVNode(vnode);
        }
        vnode.isRootInsert = !nested;
        if (createComponent2(vnode, insertedVnodeQueue, parentElm, refElm)) {
            return;
        }
        var data3 = vnode.data;
        var children = vnode.children;
        var tag = vnode.tag;
        if (isDef(tag)) {
            vnode.elm = vnode.ns
                ? nodeOps2.createElementNS(vnode.ns, tag)
                : nodeOps2.createElement(tag, vnode);
            setScope(vnode);
            createChildren(vnode, children, insertedVnodeQueue);
            if (isDef(data3)) {
                invokeCreateHooks(vnode, insertedVnodeQueue);
            }
            insert(parentElm, vnode.elm, refElm);
        } else if (isTrue(vnode.isComment)) {
            vnode.elm = nodeOps2.createComment(vnode.text);
            insert(parentElm, vnode.elm, refElm);
        } else {
            vnode.elm = nodeOps2.createTextNode(vnode.text);
            insert(parentElm, vnode.elm, refElm);
        }
    }
    function createComponent2(vnode, insertedVnodeQueue, parentElm, refElm) {
        var i2 = vnode.data;
        if (isDef(i2)) {
            var isReactivated = isDef(vnode.componentInstance) && i2.keepAlive;
            if (isDef((i2 = i2.hook)) && isDef((i2 = i2.init))) {
                i2(vnode, false);
            }
            if (isDef(vnode.componentInstance)) {
                initComponent(vnode, insertedVnodeQueue);
                insert(parentElm, vnode.elm, refElm);
                if (isTrue(isReactivated)) {
                    reactivateComponent(
                        vnode,
                        insertedVnodeQueue,
                        parentElm,
                        refElm
                    );
                }
                return true;
            }
        }
    }
    function initComponent(vnode, insertedVnodeQueue) {
        if (isDef(vnode.data.pendingInsert)) {
            insertedVnodeQueue.push.apply(
                insertedVnodeQueue,
                vnode.data.pendingInsert
            );
            vnode.data.pendingInsert = null;
        }
        vnode.elm = vnode.componentInstance.$el;
        if (isPatchable(vnode)) {
            invokeCreateHooks(vnode, insertedVnodeQueue);
            setScope(vnode);
        } else {
            registerRef(vnode);
            insertedVnodeQueue.push(vnode);
        }
    }
    function reactivateComponent(vnode, insertedVnodeQueue, parentElm, refElm) {
        var i2;
        var innerNode = vnode;
        while (innerNode.componentInstance) {
            innerNode = innerNode.componentInstance._vnode;
            if (isDef((i2 = innerNode.data)) && isDef((i2 = i2.transition))) {
                for (i2 = 0; i2 < cbs.activate.length; ++i2) {
                    cbs.activate[i2](emptyNode, innerNode);
                }
                insertedVnodeQueue.push(innerNode);
                break;
            }
        }
        insert(parentElm, vnode.elm, refElm);
    }
    function insert(parent, elm, ref2) {
        if (isDef(parent)) {
            if (isDef(ref2)) {
                if (nodeOps2.parentNode(ref2) === parent) {
                    nodeOps2.insertBefore(parent, elm, ref2);
                }
            } else {
                nodeOps2.appendChild(parent, elm);
            }
        }
    }
    function createChildren(vnode, children, insertedVnodeQueue) {
        if (isArray$6(children)) {
            for (var i_1 = 0; i_1 < children.length; ++i_1) {
                createElm(
                    children[i_1],
                    insertedVnodeQueue,
                    vnode.elm,
                    null,
                    true,
                    children,
                    i_1
                );
            }
        } else if (isPrimitive(vnode.text)) {
            nodeOps2.appendChild(
                vnode.elm,
                nodeOps2.createTextNode(String(vnode.text))
            );
        }
    }
    function isPatchable(vnode) {
        while (vnode.componentInstance) {
            vnode = vnode.componentInstance._vnode;
        }
        return isDef(vnode.tag);
    }
    function invokeCreateHooks(vnode, insertedVnodeQueue) {
        for (var i_2 = 0; i_2 < cbs.create.length; ++i_2) {
            cbs.create[i_2](emptyNode, vnode);
        }
        i = vnode.data.hook;
        if (isDef(i)) {
            if (isDef(i.create)) i.create(emptyNode, vnode);
            if (isDef(i.insert)) insertedVnodeQueue.push(vnode);
        }
    }
    function setScope(vnode) {
        var i2;
        if (isDef((i2 = vnode.fnScopeId))) {
            nodeOps2.setStyleScope(vnode.elm, i2);
        } else {
            var ancestor = vnode;
            while (ancestor) {
                if (
                    isDef((i2 = ancestor.context)) &&
                    isDef((i2 = i2.$options._scopeId))
                ) {
                    nodeOps2.setStyleScope(vnode.elm, i2);
                }
                ancestor = ancestor.parent;
            }
        }
        if (
            isDef((i2 = activeInstance)) &&
            i2 !== vnode.context &&
            i2 !== vnode.fnContext &&
            isDef((i2 = i2.$options._scopeId))
        ) {
            nodeOps2.setStyleScope(vnode.elm, i2);
        }
    }
    function addVnodes(
        parentElm,
        refElm,
        vnodes,
        startIdx,
        endIdx,
        insertedVnodeQueue
    ) {
        for (; startIdx <= endIdx; ++startIdx) {
            createElm(
                vnodes[startIdx],
                insertedVnodeQueue,
                parentElm,
                refElm,
                false,
                vnodes,
                startIdx
            );
        }
    }
    function invokeDestroyHook(vnode) {
        var i2, j2;
        var data3 = vnode.data;
        if (isDef(data3)) {
            if (isDef((i2 = data3.hook)) && isDef((i2 = i2.destroy))) i2(vnode);
            for (i2 = 0; i2 < cbs.destroy.length; ++i2) cbs.destroy[i2](vnode);
        }
        if (isDef((i2 = vnode.children))) {
            for (j2 = 0; j2 < vnode.children.length; ++j2) {
                invokeDestroyHook(vnode.children[j2]);
            }
        }
    }
    function removeVnodes(vnodes, startIdx, endIdx) {
        for (; startIdx <= endIdx; ++startIdx) {
            var ch = vnodes[startIdx];
            if (isDef(ch)) {
                if (isDef(ch.tag)) {
                    removeAndInvokeRemoveHook(ch);
                    invokeDestroyHook(ch);
                } else {
                    removeNode(ch.elm);
                }
            }
        }
    }
    function removeAndInvokeRemoveHook(vnode, rm) {
        if (isDef(rm) || isDef(vnode.data)) {
            var i_3;
            var listeners2 = cbs.remove.length + 1;
            if (isDef(rm)) {
                rm.listeners += listeners2;
            } else {
                rm = createRmCb(vnode.elm, listeners2);
            }
            if (
                isDef((i_3 = vnode.componentInstance)) &&
                isDef((i_3 = i_3._vnode)) &&
                isDef(i_3.data)
            ) {
                removeAndInvokeRemoveHook(i_3, rm);
            }
            for (i_3 = 0; i_3 < cbs.remove.length; ++i_3) {
                cbs.remove[i_3](vnode, rm);
            }
            if (isDef((i_3 = vnode.data.hook)) && isDef((i_3 = i_3.remove))) {
                i_3(vnode, rm);
            } else {
                rm();
            }
        } else {
            removeNode(vnode.elm);
        }
    }
    function updateChildren(
        parentElm,
        oldCh,
        newCh,
        insertedVnodeQueue,
        removeOnly
    ) {
        var oldStartIdx = 0;
        var newStartIdx = 0;
        var oldEndIdx = oldCh.length - 1;
        var oldStartVnode = oldCh[0];
        var oldEndVnode = oldCh[oldEndIdx];
        var newEndIdx = newCh.length - 1;
        var newStartVnode = newCh[0];
        var newEndVnode = newCh[newEndIdx];
        var oldKeyToIdx, idxInOld, vnodeToMove, refElm;
        var canMove = !removeOnly;
        while (oldStartIdx <= oldEndIdx && newStartIdx <= newEndIdx) {
            if (isUndef(oldStartVnode)) {
                oldStartVnode = oldCh[++oldStartIdx];
            } else if (isUndef(oldEndVnode)) {
                oldEndVnode = oldCh[--oldEndIdx];
            } else if (sameVnode(oldStartVnode, newStartVnode)) {
                patchVnode(
                    oldStartVnode,
                    newStartVnode,
                    insertedVnodeQueue,
                    newCh,
                    newStartIdx
                );
                oldStartVnode = oldCh[++oldStartIdx];
                newStartVnode = newCh[++newStartIdx];
            } else if (sameVnode(oldEndVnode, newEndVnode)) {
                patchVnode(
                    oldEndVnode,
                    newEndVnode,
                    insertedVnodeQueue,
                    newCh,
                    newEndIdx
                );
                oldEndVnode = oldCh[--oldEndIdx];
                newEndVnode = newCh[--newEndIdx];
            } else if (sameVnode(oldStartVnode, newEndVnode)) {
                patchVnode(
                    oldStartVnode,
                    newEndVnode,
                    insertedVnodeQueue,
                    newCh,
                    newEndIdx
                );
                canMove &&
                    nodeOps2.insertBefore(
                        parentElm,
                        oldStartVnode.elm,
                        nodeOps2.nextSibling(oldEndVnode.elm)
                    );
                oldStartVnode = oldCh[++oldStartIdx];
                newEndVnode = newCh[--newEndIdx];
            } else if (sameVnode(oldEndVnode, newStartVnode)) {
                patchVnode(
                    oldEndVnode,
                    newStartVnode,
                    insertedVnodeQueue,
                    newCh,
                    newStartIdx
                );
                canMove &&
                    nodeOps2.insertBefore(
                        parentElm,
                        oldEndVnode.elm,
                        oldStartVnode.elm
                    );
                oldEndVnode = oldCh[--oldEndIdx];
                newStartVnode = newCh[++newStartIdx];
            } else {
                if (isUndef(oldKeyToIdx))
                    oldKeyToIdx = createKeyToOldIdx(
                        oldCh,
                        oldStartIdx,
                        oldEndIdx
                    );
                idxInOld = isDef(newStartVnode.key)
                    ? oldKeyToIdx[newStartVnode.key]
                    : findIdxInOld(
                          newStartVnode,
                          oldCh,
                          oldStartIdx,
                          oldEndIdx
                      );
                if (isUndef(idxInOld)) {
                    createElm(
                        newStartVnode,
                        insertedVnodeQueue,
                        parentElm,
                        oldStartVnode.elm,
                        false,
                        newCh,
                        newStartIdx
                    );
                } else {
                    vnodeToMove = oldCh[idxInOld];
                    if (sameVnode(vnodeToMove, newStartVnode)) {
                        patchVnode(
                            vnodeToMove,
                            newStartVnode,
                            insertedVnodeQueue,
                            newCh,
                            newStartIdx
                        );
                        oldCh[idxInOld] = void 0;
                        canMove &&
                            nodeOps2.insertBefore(
                                parentElm,
                                vnodeToMove.elm,
                                oldStartVnode.elm
                            );
                    } else {
                        createElm(
                            newStartVnode,
                            insertedVnodeQueue,
                            parentElm,
                            oldStartVnode.elm,
                            false,
                            newCh,
                            newStartIdx
                        );
                    }
                }
                newStartVnode = newCh[++newStartIdx];
            }
        }
        if (oldStartIdx > oldEndIdx) {
            refElm = isUndef(newCh[newEndIdx + 1])
                ? null
                : newCh[newEndIdx + 1].elm;
            addVnodes(
                parentElm,
                refElm,
                newCh,
                newStartIdx,
                newEndIdx,
                insertedVnodeQueue
            );
        } else if (newStartIdx > newEndIdx) {
            removeVnodes(oldCh, oldStartIdx, oldEndIdx);
        }
    }
    function findIdxInOld(node, oldCh, start2, end) {
        for (var i_5 = start2; i_5 < end; i_5++) {
            var c = oldCh[i_5];
            if (isDef(c) && sameVnode(node, c)) return i_5;
        }
    }
    function patchVnode(
        oldVnode,
        vnode,
        insertedVnodeQueue,
        ownerArray,
        index2,
        removeOnly
    ) {
        if (oldVnode === vnode) {
            return;
        }
        if (isDef(vnode.elm) && isDef(ownerArray)) {
            vnode = ownerArray[index2] = cloneVNode(vnode);
        }
        var elm = (vnode.elm = oldVnode.elm);
        if (isTrue(oldVnode.isAsyncPlaceholder)) {
            if (isDef(vnode.asyncFactory.resolved)) {
                hydrate(oldVnode.elm, vnode, insertedVnodeQueue);
            } else {
                vnode.isAsyncPlaceholder = true;
            }
            return;
        }
        if (
            isTrue(vnode.isStatic) &&
            isTrue(oldVnode.isStatic) &&
            vnode.key === oldVnode.key &&
            (isTrue(vnode.isCloned) || isTrue(vnode.isOnce))
        ) {
            vnode.componentInstance = oldVnode.componentInstance;
            return;
        }
        var i2;
        var data3 = vnode.data;
        if (
            isDef(data3) &&
            isDef((i2 = data3.hook)) &&
            isDef((i2 = i2.prepatch))
        ) {
            i2(oldVnode, vnode);
        }
        var oldCh = oldVnode.children;
        var ch = vnode.children;
        if (isDef(data3) && isPatchable(vnode)) {
            for (i2 = 0; i2 < cbs.update.length; ++i2)
                cbs.update[i2](oldVnode, vnode);
            if (isDef((i2 = data3.hook)) && isDef((i2 = i2.update)))
                i2(oldVnode, vnode);
        }
        if (isUndef(vnode.text)) {
            if (isDef(oldCh) && isDef(ch)) {
                if (oldCh !== ch)
                    updateChildren(
                        elm,
                        oldCh,
                        ch,
                        insertedVnodeQueue,
                        removeOnly
                    );
            } else if (isDef(ch)) {
                if (isDef(oldVnode.text)) nodeOps2.setTextContent(elm, "");
                addVnodes(elm, null, ch, 0, ch.length - 1, insertedVnodeQueue);
            } else if (isDef(oldCh)) {
                removeVnodes(oldCh, 0, oldCh.length - 1);
            } else if (isDef(oldVnode.text)) {
                nodeOps2.setTextContent(elm, "");
            }
        } else if (oldVnode.text !== vnode.text) {
            nodeOps2.setTextContent(elm, vnode.text);
        }
        if (isDef(data3)) {
            if (isDef((i2 = data3.hook)) && isDef((i2 = i2.postpatch)))
                i2(oldVnode, vnode);
        }
    }
    function invokeInsertHook(vnode, queue2, initial) {
        if (isTrue(initial) && isDef(vnode.parent)) {
            vnode.parent.data.pendingInsert = queue2;
        } else {
            for (var i_6 = 0; i_6 < queue2.length; ++i_6) {
                queue2[i_6].data.hook.insert(queue2[i_6]);
            }
        }
    }
    var isRenderedModule = makeMap("attrs,class,staticClass,staticStyle,key");
    function hydrate(elm, vnode, insertedVnodeQueue, inVPre) {
        var i2;
        var tag = vnode.tag,
            data3 = vnode.data,
            children = vnode.children;
        inVPre = inVPre || (data3 && data3.pre);
        vnode.elm = elm;
        if (isTrue(vnode.isComment) && isDef(vnode.asyncFactory)) {
            vnode.isAsyncPlaceholder = true;
            return true;
        }
        if (isDef(data3)) {
            if (isDef((i2 = data3.hook)) && isDef((i2 = i2.init)))
                i2(vnode, true);
            if (isDef((i2 = vnode.componentInstance))) {
                initComponent(vnode, insertedVnodeQueue);
                return true;
            }
        }
        if (isDef(tag)) {
            if (isDef(children)) {
                if (!elm.hasChildNodes()) {
                    createChildren(vnode, children, insertedVnodeQueue);
                } else {
                    if (
                        isDef((i2 = data3)) &&
                        isDef((i2 = i2.domProps)) &&
                        isDef((i2 = i2.innerHTML))
                    ) {
                        if (i2 !== elm.innerHTML) {
                            return false;
                        }
                    } else {
                        var childrenMatch = true;
                        var childNode = elm.firstChild;
                        for (var i_7 = 0; i_7 < children.length; i_7++) {
                            if (
                                !childNode ||
                                !hydrate(
                                    childNode,
                                    children[i_7],
                                    insertedVnodeQueue,
                                    inVPre
                                )
                            ) {
                                childrenMatch = false;
                                break;
                            }
                            childNode = childNode.nextSibling;
                        }
                        if (!childrenMatch || childNode) {
                            return false;
                        }
                    }
                }
            }
            if (isDef(data3)) {
                var fullInvoke = false;
                for (var key in data3) {
                    if (!isRenderedModule(key)) {
                        fullInvoke = true;
                        invokeCreateHooks(vnode, insertedVnodeQueue);
                        break;
                    }
                }
                if (!fullInvoke && data3["class"]) {
                    traverse(data3["class"]);
                }
            }
        } else if (elm.data !== vnode.text) {
            elm.data = vnode.text;
        }
        return true;
    }
    return function patch2(oldVnode, vnode, hydrating, removeOnly) {
        if (isUndef(vnode)) {
            if (isDef(oldVnode)) invokeDestroyHook(oldVnode);
            return;
        }
        var isInitialPatch = false;
        var insertedVnodeQueue = [];
        if (isUndef(oldVnode)) {
            isInitialPatch = true;
            createElm(vnode, insertedVnodeQueue);
        } else {
            var isRealElement = isDef(oldVnode.nodeType);
            if (!isRealElement && sameVnode(oldVnode, vnode)) {
                patchVnode(
                    oldVnode,
                    vnode,
                    insertedVnodeQueue,
                    null,
                    null,
                    removeOnly
                );
            } else {
                if (isRealElement) {
                    if (
                        oldVnode.nodeType === 1 &&
                        oldVnode.hasAttribute(SSR_ATTR)
                    ) {
                        oldVnode.removeAttribute(SSR_ATTR);
                        hydrating = true;
                    }
                    if (isTrue(hydrating)) {
                        if (hydrate(oldVnode, vnode, insertedVnodeQueue)) {
                            invokeInsertHook(vnode, insertedVnodeQueue, true);
                            return oldVnode;
                        }
                    }
                    oldVnode = emptyNodeAt(oldVnode);
                }
                var oldElm = oldVnode.elm;
                var parentElm = nodeOps2.parentNode(oldElm);
                createElm(
                    vnode,
                    insertedVnodeQueue,
                    oldElm._leaveCb ? null : parentElm,
                    nodeOps2.nextSibling(oldElm)
                );
                if (isDef(vnode.parent)) {
                    var ancestor = vnode.parent;
                    var patchable = isPatchable(vnode);
                    while (ancestor) {
                        for (var i_8 = 0; i_8 < cbs.destroy.length; ++i_8) {
                            cbs.destroy[i_8](ancestor);
                        }
                        ancestor.elm = vnode.elm;
                        if (patchable) {
                            for (var i_9 = 0; i_9 < cbs.create.length; ++i_9) {
                                cbs.create[i_9](emptyNode, ancestor);
                            }
                            var insert_1 = ancestor.data.hook.insert;
                            if (insert_1.merged) {
                                for (
                                    var i_10 = 1;
                                    i_10 < insert_1.fns.length;
                                    i_10++
                                ) {
                                    insert_1.fns[i_10]();
                                }
                            }
                        } else {
                            registerRef(ancestor);
                        }
                        ancestor = ancestor.parent;
                    }
                }
                if (isDef(parentElm)) {
                    removeVnodes([oldVnode], 0, 0);
                } else if (isDef(oldVnode.tag)) {
                    invokeDestroyHook(oldVnode);
                }
            }
        }
        invokeInsertHook(vnode, insertedVnodeQueue, isInitialPatch);
        return vnode.elm;
    };
}
var directives = {
    create: updateDirectives,
    update: updateDirectives,
    destroy: function unbindDirectives(vnode) {
        updateDirectives(vnode, emptyNode);
    },
};
function updateDirectives(oldVnode, vnode) {
    if (oldVnode.data.directives || vnode.data.directives) {
        _update(oldVnode, vnode);
    }
}
function _update(oldVnode, vnode) {
    var isCreate = oldVnode === emptyNode;
    var isDestroy = vnode === emptyNode;
    var oldDirs = normalizeDirectives(
        oldVnode.data.directives,
        oldVnode.context
    );
    var newDirs = normalizeDirectives(vnode.data.directives, vnode.context);
    var dirsWithInsert = [];
    var dirsWithPostpatch = [];
    var key, oldDir, dir;
    for (key in newDirs) {
        oldDir = oldDirs[key];
        dir = newDirs[key];
        if (!oldDir) {
            callHook(dir, "bind", vnode, oldVnode);
            if (dir.def && dir.def.inserted) {
                dirsWithInsert.push(dir);
            }
        } else {
            dir.oldValue = oldDir.value;
            dir.oldArg = oldDir.arg;
            callHook(dir, "update", vnode, oldVnode);
            if (dir.def && dir.def.componentUpdated) {
                dirsWithPostpatch.push(dir);
            }
        }
    }
    if (dirsWithInsert.length) {
        var callInsert = function () {
            for (var i = 0; i < dirsWithInsert.length; i++) {
                callHook(dirsWithInsert[i], "inserted", vnode, oldVnode);
            }
        };
        if (isCreate) {
            mergeVNodeHook(vnode, "insert", callInsert);
        } else {
            callInsert();
        }
    }
    if (dirsWithPostpatch.length) {
        mergeVNodeHook(vnode, "postpatch", function () {
            for (var i = 0; i < dirsWithPostpatch.length; i++) {
                callHook(
                    dirsWithPostpatch[i],
                    "componentUpdated",
                    vnode,
                    oldVnode
                );
            }
        });
    }
    if (!isCreate) {
        for (key in oldDirs) {
            if (!newDirs[key]) {
                callHook(oldDirs[key], "unbind", oldVnode, oldVnode, isDestroy);
            }
        }
    }
}
var emptyModifiers = /* @__PURE__ */ Object.create(null);
function normalizeDirectives(dirs, vm) {
    var res2 = /* @__PURE__ */ Object.create(null);
    if (!dirs) {
        return res2;
    }
    var i, dir;
    for (i = 0; i < dirs.length; i++) {
        dir = dirs[i];
        if (!dir.modifiers) {
            dir.modifiers = emptyModifiers;
        }
        res2[getRawDirName(dir)] = dir;
        if (vm._setupState && vm._setupState.__sfc) {
            var setupDef =
                dir.def || resolveAsset(vm, "_setupState", "v-" + dir.name);
            if (typeof setupDef === "function") {
                dir.def = {
                    bind: setupDef,
                    update: setupDef,
                };
            } else {
                dir.def = setupDef;
            }
        }
        dir.def = dir.def || resolveAsset(vm.$options, "directives", dir.name);
    }
    return res2;
}
function getRawDirName(dir) {
    return (
        dir.rawName ||
        ""
            .concat(dir.name, ".")
            .concat(Object.keys(dir.modifiers || {}).join("."))
    );
}
function callHook(dir, hook, vnode, oldVnode, isDestroy) {
    var fn2 = dir.def && dir.def[hook];
    if (fn2) {
        try {
            fn2(vnode.elm, dir, vnode, oldVnode, isDestroy);
        } catch (e) {
            handleError(
                e,
                vnode.context,
                "directive ".concat(dir.name, " ").concat(hook, " hook")
            );
        }
    }
}
var baseModules = [ref, directives];
function updateAttrs(oldVnode, vnode) {
    var opts = vnode.componentOptions;
    if (isDef(opts) && opts.Ctor.options.inheritAttrs === false) {
        return;
    }
    if (isUndef(oldVnode.data.attrs) && isUndef(vnode.data.attrs)) {
        return;
    }
    var key, cur, old;
    var elm = vnode.elm;
    var oldAttrs = oldVnode.data.attrs || {};
    var attrs2 = vnode.data.attrs || {};
    if (isDef(attrs2.__ob__) || isTrue(attrs2._v_attr_proxy)) {
        attrs2 = vnode.data.attrs = extend({}, attrs2);
    }
    for (key in attrs2) {
        cur = attrs2[key];
        old = oldAttrs[key];
        if (old !== cur) {
            setAttr(elm, key, cur, vnode.data.pre);
        }
    }
    if ((isIE$2 || isEdge) && attrs2.value !== oldAttrs.value) {
        setAttr(elm, "value", attrs2.value);
    }
    for (key in oldAttrs) {
        if (isUndef(attrs2[key])) {
            if (isXlink(key)) {
                elm.removeAttributeNS(xlinkNS, getXlinkProp(key));
            } else if (!isEnumeratedAttr(key)) {
                elm.removeAttribute(key);
            }
        }
    }
}
function setAttr(el, key, value, isInPre) {
    if (isInPre || el.tagName.indexOf("-") > -1) {
        baseSetAttr(el, key, value);
    } else if (isBooleanAttr(key)) {
        if (isFalsyAttrValue(value)) {
            el.removeAttribute(key);
        } else {
            value =
                key === "allowfullscreen" && el.tagName === "EMBED"
                    ? "true"
                    : key;
            el.setAttribute(key, value);
        }
    } else if (isEnumeratedAttr(key)) {
        el.setAttribute(key, convertEnumeratedValue(key, value));
    } else if (isXlink(key)) {
        if (isFalsyAttrValue(value)) {
            el.removeAttributeNS(xlinkNS, getXlinkProp(key));
        } else {
            el.setAttributeNS(xlinkNS, key, value);
        }
    } else {
        baseSetAttr(el, key, value);
    }
}
function baseSetAttr(el, key, value) {
    if (isFalsyAttrValue(value)) {
        el.removeAttribute(key);
    } else {
        if (
            isIE$2 &&
            !isIE9 &&
            el.tagName === "TEXTAREA" &&
            key === "placeholder" &&
            value !== "" &&
            !el.__ieph
        ) {
            var blocker_1 = function (e) {
                e.stopImmediatePropagation();
                el.removeEventListener("input", blocker_1);
            };
            el.addEventListener("input", blocker_1);
            el.__ieph = true;
        }
        el.setAttribute(key, value);
    }
}
var attrs = {
    create: updateAttrs,
    update: updateAttrs,
};
function updateClass(oldVnode, vnode) {
    var el = vnode.elm;
    var data3 = vnode.data;
    var oldData = oldVnode.data;
    if (
        isUndef(data3.staticClass) &&
        isUndef(data3.class) &&
        (isUndef(oldData) ||
            (isUndef(oldData.staticClass) && isUndef(oldData.class)))
    ) {
        return;
    }
    var cls = genClassForVnode(vnode);
    var transitionClass = el._transitionClasses;
    if (isDef(transitionClass)) {
        cls = concat(cls, stringifyClass(transitionClass));
    }
    if (cls !== el._prevClass) {
        el.setAttribute("class", cls);
        el._prevClass = cls;
    }
}
var klass = {
    create: updateClass,
    update: updateClass,
};
var RANGE_TOKEN = "__r";
var CHECKBOX_RADIO_TOKEN = "__c";
function normalizeEvents(on2) {
    if (isDef(on2[RANGE_TOKEN])) {
        var event_1 = isIE$2 ? "change" : "input";
        on2[event_1] = [].concat(on2[RANGE_TOKEN], on2[event_1] || []);
        delete on2[RANGE_TOKEN];
    }
    if (isDef(on2[CHECKBOX_RADIO_TOKEN])) {
        on2.change = [].concat(on2[CHECKBOX_RADIO_TOKEN], on2.change || []);
        delete on2[CHECKBOX_RADIO_TOKEN];
    }
}
var target;
function createOnceHandler(event2, handler3, capture) {
    var _target = target;
    return function onceHandler() {
        var res2 = handler3.apply(null, arguments);
        if (res2 !== null) {
            remove(event2, onceHandler, capture, _target);
        }
    };
}
var useMicrotaskFix = isUsingMicroTask && !(isFF && Number(isFF[1]) <= 53);
function add(name2, handler3, capture, passive) {
    if (useMicrotaskFix) {
        var attachedTimestamp_1 = currentFlushTimestamp;
        var original_1 = handler3;
        handler3 = original_1._wrapper = function (e) {
            if (
                e.target === e.currentTarget ||
                e.timeStamp >= attachedTimestamp_1 ||
                e.timeStamp <= 0 ||
                e.target.ownerDocument !== document
            ) {
                return original_1.apply(this, arguments);
            }
        };
    }
    target.addEventListener(
        name2,
        handler3,
        supportsPassive$1 ? { capture, passive } : capture
    );
}
function remove(name2, handler3, capture, _target) {
    (_target || target).removeEventListener(
        name2,
        handler3._wrapper || handler3,
        capture
    );
}
function updateDOMListeners(oldVnode, vnode) {
    if (isUndef(oldVnode.data.on) && isUndef(vnode.data.on)) {
        return;
    }
    var on2 = vnode.data.on || {};
    var oldOn = oldVnode.data.on || {};
    target = vnode.elm || oldVnode.elm;
    normalizeEvents(on2);
    updateListeners(on2, oldOn, add, remove, createOnceHandler, vnode.context);
    target = void 0;
}
var events = {
    create: updateDOMListeners,
    update: updateDOMListeners,
    destroy: function (vnode) {
        return updateDOMListeners(vnode, emptyNode);
    },
};
var svgContainer;
function updateDOMProps(oldVnode, vnode) {
    if (isUndef(oldVnode.data.domProps) && isUndef(vnode.data.domProps)) {
        return;
    }
    var key, cur;
    var elm = vnode.elm;
    var oldProps = oldVnode.data.domProps || {};
    var props2 = vnode.data.domProps || {};
    if (isDef(props2.__ob__) || isTrue(props2._v_attr_proxy)) {
        props2 = vnode.data.domProps = extend({}, props2);
    }
    for (key in oldProps) {
        if (!(key in props2)) {
            elm[key] = "";
        }
    }
    for (key in props2) {
        cur = props2[key];
        if (key === "textContent" || key === "innerHTML") {
            if (vnode.children) vnode.children.length = 0;
            if (cur === oldProps[key]) continue;
            if (elm.childNodes.length === 1) {
                elm.removeChild(elm.childNodes[0]);
            }
        }
        if (key === "value" && elm.tagName !== "PROGRESS") {
            elm._value = cur;
            var strCur = isUndef(cur) ? "" : String(cur);
            if (shouldUpdateValue(elm, strCur)) {
                elm.value = strCur;
            }
        } else if (
            key === "innerHTML" &&
            isSVG(elm.tagName) &&
            isUndef(elm.innerHTML)
        ) {
            svgContainer = svgContainer || document.createElement("div");
            svgContainer.innerHTML = "<svg>".concat(cur, "</svg>");
            var svg2 = svgContainer.firstChild;
            while (elm.firstChild) {
                elm.removeChild(elm.firstChild);
            }
            while (svg2.firstChild) {
                elm.appendChild(svg2.firstChild);
            }
        } else if (cur !== oldProps[key]) {
            try {
                elm[key] = cur;
            } catch (e) {}
        }
    }
}
function shouldUpdateValue(elm, checkVal) {
    return (
        !elm.composing &&
        (elm.tagName === "OPTION" ||
            isNotInFocusAndDirty(elm, checkVal) ||
            isDirtyWithModifiers(elm, checkVal))
    );
}
function isNotInFocusAndDirty(elm, checkVal) {
    var notInFocus = true;
    try {
        notInFocus = document.activeElement !== elm;
    } catch (e) {}
    return notInFocus && elm.value !== checkVal;
}
function isDirtyWithModifiers(elm, newVal) {
    var value = elm.value;
    var modifiers2 = elm._vModifiers;
    if (isDef(modifiers2)) {
        if (modifiers2.number) {
            return toNumber$1(value) !== toNumber$1(newVal);
        }
        if (modifiers2.trim) {
            return value.trim() !== newVal.trim();
        }
    }
    return value !== newVal;
}
var domProps = {
    create: updateDOMProps,
    update: updateDOMProps,
};
var parseStyleText = cached(function (cssText) {
    var res2 = {};
    var listDelimiter = /;(?![^(]*\))/g;
    var propertyDelimiter = /:(.+)/;
    cssText.split(listDelimiter).forEach(function (item2) {
        if (item2) {
            var tmp = item2.split(propertyDelimiter);
            tmp.length > 1 && (res2[tmp[0].trim()] = tmp[1].trim());
        }
    });
    return res2;
});
function normalizeStyleData(data3) {
    var style2 = normalizeStyleBinding(data3.style);
    return data3.staticStyle ? extend(data3.staticStyle, style2) : style2;
}
function normalizeStyleBinding(bindingStyle) {
    if (Array.isArray(bindingStyle)) {
        return toObject(bindingStyle);
    }
    if (typeof bindingStyle === "string") {
        return parseStyleText(bindingStyle);
    }
    return bindingStyle;
}
function getStyle(vnode, checkChild) {
    var res2 = {};
    var styleData;
    if (checkChild) {
        var childNode = vnode;
        while (childNode.componentInstance) {
            childNode = childNode.componentInstance._vnode;
            if (
                childNode &&
                childNode.data &&
                (styleData = normalizeStyleData(childNode.data))
            ) {
                extend(res2, styleData);
            }
        }
    }
    if ((styleData = normalizeStyleData(vnode.data))) {
        extend(res2, styleData);
    }
    var parentNode2 = vnode;
    while ((parentNode2 = parentNode2.parent)) {
        if (
            parentNode2.data &&
            (styleData = normalizeStyleData(parentNode2.data))
        ) {
            extend(res2, styleData);
        }
    }
    return res2;
}
var cssVarRE = /^--/;
var importantRE = /\s*!important$/;
var setProp = function (el, name2, val) {
    if (cssVarRE.test(name2)) {
        el.style.setProperty(name2, val);
    } else if (importantRE.test(val)) {
        el.style.setProperty(
            hyphenate(name2),
            val.replace(importantRE, ""),
            "important"
        );
    } else {
        var normalizedName = normalize(name2);
        if (Array.isArray(val)) {
            for (var i = 0, len = val.length; i < len; i++) {
                el.style[normalizedName] = val[i];
            }
        } else {
            el.style[normalizedName] = val;
        }
    }
};
var vendorNames = ["Webkit", "Moz", "ms"];
var emptyStyle;
var normalize = cached(function (prop) {
    emptyStyle = emptyStyle || document.createElement("div").style;
    prop = camelize(prop);
    if (prop !== "filter" && prop in emptyStyle) {
        return prop;
    }
    var capName = prop.charAt(0).toUpperCase() + prop.slice(1);
    for (var i = 0; i < vendorNames.length; i++) {
        var name_1 = vendorNames[i] + capName;
        if (name_1 in emptyStyle) {
            return name_1;
        }
    }
});
function updateStyle(oldVnode, vnode) {
    var data3 = vnode.data;
    var oldData = oldVnode.data;
    if (
        isUndef(data3.staticStyle) &&
        isUndef(data3.style) &&
        isUndef(oldData.staticStyle) &&
        isUndef(oldData.style)
    ) {
        return;
    }
    var cur, name2;
    var el = vnode.elm;
    var oldStaticStyle = oldData.staticStyle;
    var oldStyleBinding = oldData.normalizedStyle || oldData.style || {};
    var oldStyle = oldStaticStyle || oldStyleBinding;
    var style2 = normalizeStyleBinding(vnode.data.style) || {};
    vnode.data.normalizedStyle = isDef(style2.__ob__)
        ? extend({}, style2)
        : style2;
    var newStyle = getStyle(vnode, true);
    for (name2 in oldStyle) {
        if (isUndef(newStyle[name2])) {
            setProp(el, name2, "");
        }
    }
    for (name2 in newStyle) {
        cur = newStyle[name2];
        if (cur !== oldStyle[name2]) {
            setProp(el, name2, cur == null ? "" : cur);
        }
    }
}
var style = {
    create: updateStyle,
    update: updateStyle,
};
var whitespaceRE = /\s+/;
function addClass(el, cls) {
    if (!cls || !(cls = cls.trim())) {
        return;
    }
    if (el.classList) {
        if (cls.indexOf(" ") > -1) {
            cls.split(whitespaceRE).forEach(function (c) {
                return el.classList.add(c);
            });
        } else {
            el.classList.add(cls);
        }
    } else {
        var cur = " ".concat(el.getAttribute("class") || "", " ");
        if (cur.indexOf(" " + cls + " ") < 0) {
            el.setAttribute("class", (cur + cls).trim());
        }
    }
}
function removeClass(el, cls) {
    if (!cls || !(cls = cls.trim())) {
        return;
    }
    if (el.classList) {
        if (cls.indexOf(" ") > -1) {
            cls.split(whitespaceRE).forEach(function (c) {
                return el.classList.remove(c);
            });
        } else {
            el.classList.remove(cls);
        }
        if (!el.classList.length) {
            el.removeAttribute("class");
        }
    } else {
        var cur = " ".concat(el.getAttribute("class") || "", " ");
        var tar = " " + cls + " ";
        while (cur.indexOf(tar) >= 0) {
            cur = cur.replace(tar, " ");
        }
        cur = cur.trim();
        if (cur) {
            el.setAttribute("class", cur);
        } else {
            el.removeAttribute("class");
        }
    }
}
function resolveTransition(def2) {
    if (!def2) {
        return;
    }
    if (typeof def2 === "object") {
        var res2 = {};
        if (def2.css !== false) {
            extend(res2, autoCssTransition(def2.name || "v"));
        }
        extend(res2, def2);
        return res2;
    } else if (typeof def2 === "string") {
        return autoCssTransition(def2);
    }
}
var autoCssTransition = cached(function (name2) {
    return {
        enterClass: "".concat(name2, "-enter"),
        enterToClass: "".concat(name2, "-enter-to"),
        enterActiveClass: "".concat(name2, "-enter-active"),
        leaveClass: "".concat(name2, "-leave"),
        leaveToClass: "".concat(name2, "-leave-to"),
        leaveActiveClass: "".concat(name2, "-leave-active"),
    };
});
var hasTransition = inBrowser && !isIE9;
var TRANSITION$1 = "transition";
var ANIMATION = "animation";
var transitionProp = "transition";
var transitionEndEvent = "transitionend";
var animationProp = "animation";
var animationEndEvent = "animationend";
if (hasTransition) {
    if (
        window.ontransitionend === void 0 &&
        window.onwebkittransitionend !== void 0
    ) {
        transitionProp = "WebkitTransition";
        transitionEndEvent = "webkitTransitionEnd";
    }
    if (
        window.onanimationend === void 0 &&
        window.onwebkitanimationend !== void 0
    ) {
        animationProp = "WebkitAnimation";
        animationEndEvent = "webkitAnimationEnd";
    }
}
var raf = inBrowser
    ? window.requestAnimationFrame
        ? window.requestAnimationFrame.bind(window)
        : setTimeout
    : function (fn2) {
          return fn2();
      };
function nextFrame(fn2) {
    raf(function () {
        raf(fn2);
    });
}
function addTransitionClass(el, cls) {
    var transitionClasses =
        el._transitionClasses || (el._transitionClasses = []);
    if (transitionClasses.indexOf(cls) < 0) {
        transitionClasses.push(cls);
        addClass(el, cls);
    }
}
function removeTransitionClass(el, cls) {
    if (el._transitionClasses) {
        remove$2(el._transitionClasses, cls);
    }
    removeClass(el, cls);
}
function whenTransitionEnds(el, expectedType, cb) {
    var _a = getTransitionInfo(el, expectedType),
        type = _a.type,
        timeout = _a.timeout,
        propCount = _a.propCount;
    if (!type) return cb();
    var event2 = type === TRANSITION$1 ? transitionEndEvent : animationEndEvent;
    var ended = 0;
    var end = function () {
        el.removeEventListener(event2, onEnd);
        cb();
    };
    var onEnd = function (e) {
        if (e.target === el) {
            if (++ended >= propCount) {
                end();
            }
        }
    };
    setTimeout(function () {
        if (ended < propCount) {
            end();
        }
    }, timeout + 1);
    el.addEventListener(event2, onEnd);
}
var transformRE = /\b(transform|all)(,|$)/;
function getTransitionInfo(el, expectedType) {
    var styles2 = window.getComputedStyle(el);
    var transitionDelays = (styles2[transitionProp + "Delay"] || "").split(
        ", "
    );
    var transitionDurations = (
        styles2[transitionProp + "Duration"] || ""
    ).split(", ");
    var transitionTimeout = getTimeout(transitionDelays, transitionDurations);
    var animationDelays = (styles2[animationProp + "Delay"] || "").split(", ");
    var animationDurations = (styles2[animationProp + "Duration"] || "").split(
        ", "
    );
    var animationTimeout = getTimeout(animationDelays, animationDurations);
    var type;
    var timeout = 0;
    var propCount = 0;
    if (expectedType === TRANSITION$1) {
        if (transitionTimeout > 0) {
            type = TRANSITION$1;
            timeout = transitionTimeout;
            propCount = transitionDurations.length;
        }
    } else if (expectedType === ANIMATION) {
        if (animationTimeout > 0) {
            type = ANIMATION;
            timeout = animationTimeout;
            propCount = animationDurations.length;
        }
    } else {
        timeout = Math.max(transitionTimeout, animationTimeout);
        type =
            timeout > 0
                ? transitionTimeout > animationTimeout
                    ? TRANSITION$1
                    : ANIMATION
                : null;
        propCount = type
            ? type === TRANSITION$1
                ? transitionDurations.length
                : animationDurations.length
            : 0;
    }
    var hasTransform =
        type === TRANSITION$1 &&
        transformRE.test(styles2[transitionProp + "Property"]);
    return {
        type,
        timeout,
        propCount,
        hasTransform,
    };
}
function getTimeout(delays, durations) {
    while (delays.length < durations.length) {
        delays = delays.concat(delays);
    }
    return Math.max.apply(
        null,
        durations.map(function (d, i) {
            return toMs(d) + toMs(delays[i]);
        })
    );
}
function toMs(s) {
    return Number(s.slice(0, -1).replace(",", ".")) * 1e3;
}
function enter(vnode, toggleDisplay) {
    var el = vnode.elm;
    if (isDef(el._leaveCb)) {
        el._leaveCb.cancelled = true;
        el._leaveCb();
    }
    var data3 = resolveTransition(vnode.data.transition);
    if (isUndef(data3)) {
        return;
    }
    if (isDef(el._enterCb) || el.nodeType !== 1) {
        return;
    }
    var css = data3.css,
        type = data3.type,
        enterClass = data3.enterClass,
        enterToClass = data3.enterToClass,
        enterActiveClass = data3.enterActiveClass,
        appearClass = data3.appearClass,
        appearToClass = data3.appearToClass,
        appearActiveClass = data3.appearActiveClass,
        beforeEnter = data3.beforeEnter,
        enter2 = data3.enter,
        afterEnter = data3.afterEnter,
        enterCancelled = data3.enterCancelled,
        beforeAppear = data3.beforeAppear,
        appear = data3.appear,
        afterAppear = data3.afterAppear,
        appearCancelled = data3.appearCancelled,
        duration = data3.duration;
    var context = activeInstance;
    var transitionNode = activeInstance.$vnode;
    while (transitionNode && transitionNode.parent) {
        context = transitionNode.context;
        transitionNode = transitionNode.parent;
    }
    var isAppear = !context._isMounted || !vnode.isRootInsert;
    if (isAppear && !appear && appear !== "") {
        return;
    }
    var startClass = isAppear && appearClass ? appearClass : enterClass;
    var activeClass =
        isAppear && appearActiveClass ? appearActiveClass : enterActiveClass;
    var toClass = isAppear && appearToClass ? appearToClass : enterToClass;
    var beforeEnterHook = isAppear ? beforeAppear || beforeEnter : beforeEnter;
    var enterHook = isAppear
        ? isFunction$7(appear)
            ? appear
            : enter2
        : enter2;
    var afterEnterHook = isAppear ? afterAppear || afterEnter : afterEnter;
    var enterCancelledHook = isAppear
        ? appearCancelled || enterCancelled
        : enterCancelled;
    var explicitEnterDuration = toNumber$1(
        isObject$a(duration) ? duration.enter : duration
    );
    var expectsCSS = css !== false && !isIE9;
    var userWantsControl = getHookArgumentsLength(enterHook);
    var cb = (el._enterCb = once(function () {
        if (expectsCSS) {
            removeTransitionClass(el, toClass);
            removeTransitionClass(el, activeClass);
        }
        if (cb.cancelled) {
            if (expectsCSS) {
                removeTransitionClass(el, startClass);
            }
            enterCancelledHook && enterCancelledHook(el);
        } else {
            afterEnterHook && afterEnterHook(el);
        }
        el._enterCb = null;
    }));
    if (!vnode.data.show) {
        mergeVNodeHook(vnode, "insert", function () {
            var parent = el.parentNode;
            var pendingNode =
                parent && parent._pending && parent._pending[vnode.key];
            if (
                pendingNode &&
                pendingNode.tag === vnode.tag &&
                pendingNode.elm._leaveCb
            ) {
                pendingNode.elm._leaveCb();
            }
            enterHook && enterHook(el, cb);
        });
    }
    beforeEnterHook && beforeEnterHook(el);
    if (expectsCSS) {
        addTransitionClass(el, startClass);
        addTransitionClass(el, activeClass);
        nextFrame(function () {
            removeTransitionClass(el, startClass);
            if (!cb.cancelled) {
                addTransitionClass(el, toClass);
                if (!userWantsControl) {
                    if (isValidDuration(explicitEnterDuration)) {
                        setTimeout(cb, explicitEnterDuration);
                    } else {
                        whenTransitionEnds(el, type, cb);
                    }
                }
            }
        });
    }
    if (vnode.data.show) {
        toggleDisplay && toggleDisplay();
        enterHook && enterHook(el, cb);
    }
    if (!expectsCSS && !userWantsControl) {
        cb();
    }
}
function leave(vnode, rm) {
    var el = vnode.elm;
    if (isDef(el._enterCb)) {
        el._enterCb.cancelled = true;
        el._enterCb();
    }
    var data3 = resolveTransition(vnode.data.transition);
    if (isUndef(data3) || el.nodeType !== 1) {
        return rm();
    }
    if (isDef(el._leaveCb)) {
        return;
    }
    var css = data3.css,
        type = data3.type,
        leaveClass = data3.leaveClass,
        leaveToClass = data3.leaveToClass,
        leaveActiveClass = data3.leaveActiveClass,
        beforeLeave = data3.beforeLeave,
        leave2 = data3.leave,
        afterLeave = data3.afterLeave,
        leaveCancelled = data3.leaveCancelled,
        delayLeave = data3.delayLeave,
        duration = data3.duration;
    var expectsCSS = css !== false && !isIE9;
    var userWantsControl = getHookArgumentsLength(leave2);
    var explicitLeaveDuration = toNumber$1(
        isObject$a(duration) ? duration.leave : duration
    );
    var cb = (el._leaveCb = once(function () {
        if (el.parentNode && el.parentNode._pending) {
            el.parentNode._pending[vnode.key] = null;
        }
        if (expectsCSS) {
            removeTransitionClass(el, leaveToClass);
            removeTransitionClass(el, leaveActiveClass);
        }
        if (cb.cancelled) {
            if (expectsCSS) {
                removeTransitionClass(el, leaveClass);
            }
            leaveCancelled && leaveCancelled(el);
        } else {
            rm();
            afterLeave && afterLeave(el);
        }
        el._leaveCb = null;
    }));
    if (delayLeave) {
        delayLeave(performLeave);
    } else {
        performLeave();
    }
    function performLeave() {
        if (cb.cancelled) {
            return;
        }
        if (!vnode.data.show && el.parentNode) {
            (el.parentNode._pending || (el.parentNode._pending = {}))[
                vnode.key
            ] = vnode;
        }
        beforeLeave && beforeLeave(el);
        if (expectsCSS) {
            addTransitionClass(el, leaveClass);
            addTransitionClass(el, leaveActiveClass);
            nextFrame(function () {
                removeTransitionClass(el, leaveClass);
                if (!cb.cancelled) {
                    addTransitionClass(el, leaveToClass);
                    if (!userWantsControl) {
                        if (isValidDuration(explicitLeaveDuration)) {
                            setTimeout(cb, explicitLeaveDuration);
                        } else {
                            whenTransitionEnds(el, type, cb);
                        }
                    }
                }
            });
        }
        leave2 && leave2(el, cb);
        if (!expectsCSS && !userWantsControl) {
            cb();
        }
    }
}
function isValidDuration(val) {
    return typeof val === "number" && !isNaN(val);
}
function getHookArgumentsLength(fn2) {
    if (isUndef(fn2)) {
        return false;
    }
    var invokerFns = fn2.fns;
    if (isDef(invokerFns)) {
        return getHookArgumentsLength(
            Array.isArray(invokerFns) ? invokerFns[0] : invokerFns
        );
    } else {
        return (fn2._length || fn2.length) > 1;
    }
}
function _enter(_2, vnode) {
    if (vnode.data.show !== true) {
        enter(vnode);
    }
}
var transition = inBrowser
    ? {
          create: _enter,
          activate: _enter,
          remove: function (vnode, rm) {
              if (vnode.data.show !== true) {
                  leave(vnode, rm);
              } else {
                  rm();
              }
          },
      }
    : {};
var platformModules = [attrs, klass, events, domProps, style, transition];
var modules = platformModules.concat(baseModules);
var patch = createPatchFunction({ nodeOps, modules });
if (isIE9) {
    document.addEventListener("selectionchange", function () {
        var el = document.activeElement;
        if (el && el.vmodel) {
            trigger(el, "input");
        }
    });
}
var directive$1 = {
    inserted: function (el, binding, vnode, oldVnode) {
        if (vnode.tag === "select") {
            if (oldVnode.elm && !oldVnode.elm._vOptions) {
                mergeVNodeHook(vnode, "postpatch", function () {
                    directive$1.componentUpdated(el, binding, vnode);
                });
            } else {
                setSelected(el, binding, vnode.context);
            }
            el._vOptions = [].map.call(el.options, getValue$2);
        } else if (vnode.tag === "textarea" || isTextInputType(el.type)) {
            el._vModifiers = binding.modifiers;
            if (!binding.modifiers.lazy) {
                el.addEventListener("compositionstart", onCompositionStart);
                el.addEventListener("compositionend", onCompositionEnd);
                el.addEventListener("change", onCompositionEnd);
                if (isIE9) {
                    el.vmodel = true;
                }
            }
        }
    },
    componentUpdated: function (el, binding, vnode) {
        if (vnode.tag === "select") {
            setSelected(el, binding, vnode.context);
            var prevOptions_1 = el._vOptions;
            var curOptions_1 = (el._vOptions = [].map.call(
                el.options,
                getValue$2
            ));
            if (
                curOptions_1.some(function (o, i) {
                    return !looseEqual(o, prevOptions_1[i]);
                })
            ) {
                var needReset = el.multiple
                    ? binding.value.some(function (v) {
                          return hasNoMatchingOption(v, curOptions_1);
                      })
                    : binding.value !== binding.oldValue &&
                      hasNoMatchingOption(binding.value, curOptions_1);
                if (needReset) {
                    trigger(el, "change");
                }
            }
        }
    },
};
function setSelected(el, binding, vm) {
    actuallySetSelected(el, binding);
    if (isIE$2 || isEdge) {
        setTimeout(function () {
            actuallySetSelected(el, binding);
        }, 0);
    }
}
function actuallySetSelected(el, binding, vm) {
    var value = binding.value;
    var isMultiple = el.multiple;
    if (isMultiple && !Array.isArray(value)) {
        return;
    }
    var selected, option2;
    for (var i = 0, l = el.options.length; i < l; i++) {
        option2 = el.options[i];
        if (isMultiple) {
            selected = looseIndexOf(value, getValue$2(option2)) > -1;
            if (option2.selected !== selected) {
                option2.selected = selected;
            }
        } else {
            if (looseEqual(getValue$2(option2), value)) {
                if (el.selectedIndex !== i) {
                    el.selectedIndex = i;
                }
                return;
            }
        }
    }
    if (!isMultiple) {
        el.selectedIndex = -1;
    }
}
function hasNoMatchingOption(value, options) {
    return options.every(function (o) {
        return !looseEqual(o, value);
    });
}
function getValue$2(option2) {
    return "_value" in option2 ? option2._value : option2.value;
}
function onCompositionStart(e) {
    e.target.composing = true;
}
function onCompositionEnd(e) {
    if (!e.target.composing) return;
    e.target.composing = false;
    trigger(e.target, "input");
}
function trigger(el, type) {
    var e = document.createEvent("HTMLEvents");
    e.initEvent(type, true, true);
    el.dispatchEvent(e);
}
function locateNode(vnode) {
    return vnode.componentInstance && (!vnode.data || !vnode.data.transition)
        ? locateNode(vnode.componentInstance._vnode)
        : vnode;
}
var show = {
    bind: function (el, _a, vnode) {
        var value = _a.value;
        vnode = locateNode(vnode);
        var transition2 = vnode.data && vnode.data.transition;
        var originalDisplay = (el.__vOriginalDisplay =
            el.style.display === "none" ? "" : el.style.display);
        if (value && transition2) {
            vnode.data.show = true;
            enter(vnode, function () {
                el.style.display = originalDisplay;
            });
        } else {
            el.style.display = value ? originalDisplay : "none";
        }
    },
    update: function (el, _a, vnode) {
        var value = _a.value,
            oldValue = _a.oldValue;
        if (!value === !oldValue) return;
        vnode = locateNode(vnode);
        var transition2 = vnode.data && vnode.data.transition;
        if (transition2) {
            vnode.data.show = true;
            if (value) {
                enter(vnode, function () {
                    el.style.display = el.__vOriginalDisplay;
                });
            } else {
                leave(vnode, function () {
                    el.style.display = "none";
                });
            }
        } else {
            el.style.display = value ? el.__vOriginalDisplay : "none";
        }
    },
    unbind: function (el, binding, vnode, oldVnode, isDestroy) {
        if (!isDestroy) {
            el.style.display = el.__vOriginalDisplay;
        }
    },
};
var platformDirectives = {
    model: directive$1,
    show,
};
var transitionProps = {
    name: String,
    appear: Boolean,
    css: Boolean,
    mode: String,
    type: String,
    enterClass: String,
    leaveClass: String,
    enterToClass: String,
    leaveToClass: String,
    enterActiveClass: String,
    leaveActiveClass: String,
    appearClass: String,
    appearActiveClass: String,
    appearToClass: String,
    duration: [Number, String, Object],
};
function getRealChild(vnode) {
    var compOptions = vnode && vnode.componentOptions;
    if (compOptions && compOptions.Ctor.options.abstract) {
        return getRealChild(getFirstComponentChild(compOptions.children));
    } else {
        return vnode;
    }
}
function extractTransitionData(comp) {
    var data3 = {};
    var options = comp.$options;
    for (var key in options.propsData) {
        data3[key] = comp[key];
    }
    var listeners2 = options._parentListeners;
    for (var key in listeners2) {
        data3[camelize(key)] = listeners2[key];
    }
    return data3;
}
function placeholder(h, rawChild) {
    if (/\d-keep-alive$/.test(rawChild.tag)) {
        return h("keep-alive", {
            props: rawChild.componentOptions.propsData,
        });
    }
}
function hasParentTransition(vnode) {
    while ((vnode = vnode.parent)) {
        if (vnode.data.transition) {
            return true;
        }
    }
}
function isSameChild(child, oldChild) {
    return oldChild.key === child.key && oldChild.tag === child.tag;
}
var isNotTextNode = function (c) {
    return c.tag || isAsyncPlaceholder(c);
};
var isVShowDirective = function (d) {
    return d.name === "show";
};
var Transition = {
    name: "transition",
    props: transitionProps,
    abstract: true,
    render: function (h) {
        var _this = this;
        var children = this.$slots.default;
        if (!children) {
            return;
        }
        children = children.filter(isNotTextNode);
        if (!children.length) {
            return;
        }
        var mode = this.mode;
        var rawChild = children[0];
        if (hasParentTransition(this.$vnode)) {
            return rawChild;
        }
        var child = getRealChild(rawChild);
        if (!child) {
            return rawChild;
        }
        if (this._leaving) {
            return placeholder(h, rawChild);
        }
        var id = "__transition-".concat(this._uid, "-");
        child.key =
            child.key == null
                ? child.isComment
                    ? id + "comment"
                    : id + child.tag
                : isPrimitive(child.key)
                ? String(child.key).indexOf(id) === 0
                    ? child.key
                    : id + child.key
                : child.key;
        var data3 = ((child.data || (child.data = {})).transition =
            extractTransitionData(this));
        var oldRawChild = this._vnode;
        var oldChild = getRealChild(oldRawChild);
        if (
            child.data.directives &&
            child.data.directives.some(isVShowDirective)
        ) {
            child.data.show = true;
        }
        if (
            oldChild &&
            oldChild.data &&
            !isSameChild(child, oldChild) &&
            !isAsyncPlaceholder(oldChild) &&
            !(
                oldChild.componentInstance &&
                oldChild.componentInstance._vnode.isComment
            )
        ) {
            var oldData = (oldChild.data.transition = extend({}, data3));
            if (mode === "out-in") {
                this._leaving = true;
                mergeVNodeHook(oldData, "afterLeave", function () {
                    _this._leaving = false;
                    _this.$forceUpdate();
                });
                return placeholder(h, rawChild);
            } else if (mode === "in-out") {
                if (isAsyncPlaceholder(child)) {
                    return oldRawChild;
                }
                var delayedLeave_1;
                var performLeave = function () {
                    delayedLeave_1();
                };
                mergeVNodeHook(data3, "afterEnter", performLeave);
                mergeVNodeHook(data3, "enterCancelled", performLeave);
                mergeVNodeHook(oldData, "delayLeave", function (leave2) {
                    delayedLeave_1 = leave2;
                });
            }
        }
        return rawChild;
    },
};
var props = extend(
    {
        tag: String,
        moveClass: String,
    },
    transitionProps
);
delete props.mode;
var TransitionGroup = {
    props,
    beforeMount: function () {
        var _this = this;
        var update3 = this._update;
        this._update = function (vnode, hydrating) {
            var restoreActiveInstance = setActiveInstance(_this);
            _this.__patch__(_this._vnode, _this.kept, false, true);
            _this._vnode = _this.kept;
            restoreActiveInstance();
            update3.call(_this, vnode, hydrating);
        };
    },
    render: function (h) {
        var tag = this.tag || this.$vnode.data.tag || "span";
        var map2 = /* @__PURE__ */ Object.create(null);
        var prevChildren = (this.prevChildren = this.children);
        var rawChildren = this.$slots.default || [];
        var children = (this.children = []);
        var transitionData = extractTransitionData(this);
        for (var i = 0; i < rawChildren.length; i++) {
            var c = rawChildren[i];
            if (c.tag) {
                if (c.key != null && String(c.key).indexOf("__vlist") !== 0) {
                    children.push(c);
                    map2[c.key] = c;
                    (c.data || (c.data = {})).transition = transitionData;
                }
            }
        }
        if (prevChildren) {
            var kept = [];
            var removed = [];
            for (var i = 0; i < prevChildren.length; i++) {
                var c = prevChildren[i];
                c.data.transition = transitionData;
                c.data.pos = c.elm.getBoundingClientRect();
                if (map2[c.key]) {
                    kept.push(c);
                } else {
                    removed.push(c);
                }
            }
            this.kept = h(tag, null, kept);
            this.removed = removed;
        }
        return h(tag, null, children);
    },
    updated: function () {
        var children = this.prevChildren;
        var moveClass = this.moveClass || (this.name || "v") + "-move";
        if (!children.length || !this.hasMove(children[0].elm, moveClass)) {
            return;
        }
        children.forEach(callPendingCbs);
        children.forEach(recordPosition);
        children.forEach(applyTranslation);
        this._reflow = document.body.offsetHeight;
        children.forEach(function (c) {
            if (c.data.moved) {
                var el_1 = c.elm;
                var s = el_1.style;
                addTransitionClass(el_1, moveClass);
                s.transform = s.WebkitTransform = s.transitionDuration = "";
                el_1.addEventListener(
                    transitionEndEvent,
                    (el_1._moveCb = function cb(e) {
                        if (e && e.target !== el_1) {
                            return;
                        }
                        if (!e || /transform$/.test(e.propertyName)) {
                            el_1.removeEventListener(transitionEndEvent, cb);
                            el_1._moveCb = null;
                            removeTransitionClass(el_1, moveClass);
                        }
                    })
                );
            }
        });
    },
    methods: {
        hasMove: function (el, moveClass) {
            if (!hasTransition) {
                return false;
            }
            if (this._hasMove) {
                return this._hasMove;
            }
            var clone2 = el.cloneNode();
            if (el._transitionClasses) {
                el._transitionClasses.forEach(function (cls) {
                    removeClass(clone2, cls);
                });
            }
            addClass(clone2, moveClass);
            clone2.style.display = "none";
            this.$el.appendChild(clone2);
            var info = getTransitionInfo(clone2);
            this.$el.removeChild(clone2);
            return (this._hasMove = info.hasTransform);
        },
    },
};
function callPendingCbs(c) {
    if (c.elm._moveCb) {
        c.elm._moveCb();
    }
    if (c.elm._enterCb) {
        c.elm._enterCb();
    }
}
function recordPosition(c) {
    c.data.newPos = c.elm.getBoundingClientRect();
}
function applyTranslation(c) {
    var oldPos = c.data.pos;
    var newPos = c.data.newPos;
    var dx = oldPos.left - newPos.left;
    var dy = oldPos.top - newPos.top;
    if (dx || dy) {
        c.data.moved = true;
        var s = c.elm.style;
        s.transform = s.WebkitTransform = "translate("
            .concat(dx, "px,")
            .concat(dy, "px)");
        s.transitionDuration = "0s";
    }
}
var platformComponents = {
    Transition,
    TransitionGroup,
};
Vue.config.mustUseProp = mustUseProp;
Vue.config.isReservedTag = isReservedTag;
Vue.config.isReservedAttr = isReservedAttr;
Vue.config.getTagNamespace = getTagNamespace;
Vue.config.isUnknownElement = isUnknownElement;
extend(Vue.options.directives, platformDirectives);
extend(Vue.options.components, platformComponents);
Vue.prototype.__patch__ = inBrowser ? patch : noop;
Vue.prototype.$mount = function (el, hydrating) {
    el = el && inBrowser ? query(el) : void 0;
    return mountComponent(this, el, hydrating);
};
if (inBrowser) {
    setTimeout(function () {
        if (config.devtools) {
            if (devtools) {
                devtools.emit("init", Vue);
            }
        }
    }, 0);
}
const CreatePost_vue_vue_type_style_index_0_lang = "";
function normalizeComponent$3(
    scriptExports,
    render3,
    staticRenderFns,
    functionalTemplate,
    injectStyles,
    scopeId,
    moduleIdentifier,
    shadowMode
) {
    var options =
        typeof scriptExports === "function"
            ? scriptExports.options
            : scriptExports;
    if (render3) {
        options.render = render3;
        options.staticRenderFns = staticRenderFns;
        options._compiled = true;
    }
    if (functionalTemplate) {
        options.functional = true;
    }
    if (scopeId) {
        options._scopeId = "data-v-" + scopeId;
    }
    var hook;
    if (moduleIdentifier) {
        hook = function (context) {
            context =
                context ||
                (this.$vnode && this.$vnode.ssrContext) ||
                (this.parent &&
                    this.parent.$vnode &&
                    this.parent.$vnode.ssrContext);
            if (!context && typeof __VUE_SSR_CONTEXT__ !== "undefined") {
                context = __VUE_SSR_CONTEXT__;
            }
            if (injectStyles) {
                injectStyles.call(this, context);
            }
            if (context && context._registeredComponents) {
                context._registeredComponents.add(moduleIdentifier);
            }
        };
        options._ssrRegister = hook;
    } else if (injectStyles) {
        hook = shadowMode
            ? function () {
                  injectStyles.call(
                      this,
                      (options.functional ? this.parent : this).$root.$options
                          .shadowRoot
                  );
              }
            : injectStyles;
    }
    if (hook) {
        if (options.functional) {
            options._injectStyles = hook;
            var originalRender = options.render;
            options.render = function renderWithStyleInjection(h, context) {
                hook.call(context);
                return originalRender(h, context);
            };
        } else {
            var existing = options.beforeCreate;
            options.beforeCreate = existing
                ? [].concat(existing, hook)
                : [hook];
        }
    }
    return {
        exports: scriptExports,
        options,
    };
}
const axios$2 = window.axios;
const _sfc_main$1 = {
    data() {
        return {
            writeSomethingTranslated: window.writeSomething,
            savePostTranslated: window.savePost,
            freePostTranslated: window.freePost,
            paidPostTranslated: window.paidPost,
            imageUploadTranslated: window.imageUpload,
            videoUploadTranslated: window.videoUpload,
            audioUploadTranslated: window.audioUpload,
            zipUploadTranslated: window.zipUpload,
            processingUploadTranslated: window.processingUpload,
            profilePic: "/images/default-profile-pic.png",
            cameraIcon: "/images/camera-icon.png",
            videoIcon: "/images/videocam-icon.png",
            zipIcon: "/images/zip-icon.svg",
            audioIcon: "/images/mic-icon.png",
            trashIcon: "/images/trash-icon.svg",
            authUser: null,
            postLockType: "Free",
            text_content: "",
            showSpinner: false,
            post: null,
            selectedPhotos: [],
            uploadPercentage: 0,
            attachmentType: null,
            file: null,
            chunks: [],
            uploaded: 0,
            loadPostSpinner: false,
            showFreeOrPaid: false,
        };
    },
    mounted() {
        this.getUser();
        this.getProfilePic();
    },
    methods: {
        getPostsLimit() {
            document.dispatchEvent(window.getPostsLimitEvent);
        },
        showTypeDropdown() {
            this.showFreeOrPaid = !this.showFreeOrPaid;
        },
        getProfilePic() {
            const vm = this;
            axios$2
                .get("/profile/get/profilePicture")
                .then(function (response) {
                    vm.profilePic = response.data.picture;
                })
                .catch(function (error2) {
                    vm.$toast.error(
                        "Fetching Profile Pic: " + error2.toString()
                    );
                });
        },
        getUser() {
            const vm = this;
            axios$2
                .post("/messages/get/auth-user")
                .then(function (response) {
                    vm.authUser = response.data;
                })
                .catch(function (error2) {
                    vm.$toast.error("Fetching User: " + error2.toString());
                });
        },
        changePostLockType(lockType) {
            const vm = this;
            vm.postLockType = lockType;
            vm.savePost();
            vm.showFreeOrPaid = false;
        },
        selectPhotos() {
            this.$refs.imageUploads.click();
        },
        appendPhotos(event2) {
            const filesNum = event2.target.files.length;
            const attachments = event2.target.files;
            for (let i = 0; i < filesNum; i++) {
                const file2 = attachments[i];
                this.selectedPhotos.push({
                    file: file2,
                    url: URL.createObjectURL(file2),
                });
            }
        },
        removePhoto(index2) {
            console.log("Removing Photo By Index: " + index2);
            this.selectedPhotos.splice(index2, 1);
        },
        savePost() {
            const vm = this;
            vm.showSpinner = true;
            axios$2
                .post("/save-post", {
                    text_content: vm.text_content,
                    lock_type: vm.postLockType,
                })
                .then(function (response) {
                    if (response.data.result) {
                        vm.post = response.data.post;
                        vm.text_content = "";
                        if (vm.selectedPhotos.length > 0) {
                            vm.uploadPhotos(vm.post);
                        } else if (vm.file) {
                            vm.createChunks();
                        } else {
                            vm.loadPost(vm.post);
                        }
                        vm.getPostsLimit();
                    } else {
                        response.data.errors.forEach(function (err) {
                            vm.$toast.error(err);
                        });
                    }
                })
                .catch(function (error2) {
                    let response = error2.response.data;
                    if (typeof response.errors != "undefined") {
                        for (let err in response.errors) {
                            if (response.errors.hasOwnProperty(err)) {
                                vm.$toast.error(response.errors[err][0]);
                            }
                        }
                    } else {
                        vm.$toast.error(error2.toString());
                    }
                })
                .then(function () {
                    vm.showSpinner = false;
                });
        },
        uploadPhotos(postID) {
            const vm = this;
            vm.showSpinner = true;
            const postData = new FormData();
            postData.append("media_type", "Image");
            for (let fileKey in this.selectedPhotos) {
                postData.append(
                    "imageUpload[]",
                    this.selectedPhotos[fileKey].file
                );
            }
            axios$2
                .post("/post/attach-media/" + postID, postData, {
                    onUploadProgress: (event2) => {
                        vm.uploadPercentage = parseInt(
                            Math.round((event2.loaded / event2.total) * 100)
                        );
                    },
                })
                .then(function (response) {
                    if (response.data.result) {
                        vm.loadPost(postID);
                    } else {
                        response.data.errors.forEach(function (err) {
                            vm.$toast.error(err);
                        });
                    }
                })
                .catch(function (error2) {
                    let response = error2.response.data;
                    if (typeof response.errors != "undefined") {
                        for (let err in response.errors) {
                            if (response.errors.hasOwnProperty(err)) {
                                vm.$toast.error(response.errors[err][0]);
                            }
                        }
                    } else {
                        vm.$toast.error(error2.toString());
                    }
                })
                .then(function () {
                    vm.showSpinner = false;
                    vm.selectedPhotos = [];
                    vm.uploadPercentage = 0;
                });
        },
        loadPost(postID) {
            const vm = this;
            vm.loadPostSpinner = true;
            axios$2
                .get("/post/loadById/" + postID)
                .then(function (response) {
                    const currentHTML = vm.$refs.vueAppendedPosts.innerHTML;
                    vm.$refs.vueAppendedPosts.innerHTML =
                        response.data + currentHTML;
                })
                .catch(function (error2) {
                    vm.$toast.error(error2.toString());
                })
                .finally(function () {
                    vm.loadPostSpinner = false;
                });
        },
        appendMedia() {
            console.log("setting file");
            this.file = event.target.files.item(0);
            console.log(this.file);
        },
        removeFile() {
            this.file = null;
            this.chunks = [];
        },
        selectMedia(mediaType) {
            this.attachmentType = mediaType;
            if (mediaType === "Video") {
                this.$refs.videoUploads.click();
            } else if (mediaType === "Audio") {
                this.$refs.audioUploads.click();
            } else if (mediaType === "ZIP") {
                this.$refs.zipUploads.click();
            }
        },
        createChunks() {
            let size2 = 1024 * 1024 * 8,
                chunks = Math.ceil(this.file.size / size2);
            for (let i = 0; i < chunks; i++) {
                this.chunks.push(
                    this.file.slice(
                        i * size2,
                        Math.min(i * size2 + size2, this.file.size),
                        this.file.type
                    )
                );
            }
        },
        uploadChunks() {
            const vm = this;
            vm.showSpinner = true;
            vm.loadPostSpinner = true;
            const postData = new FormData();
            postData.append("media_type", vm.attachmentType);
            postData.append("is_last", vm.chunks.length === 1);
            postData.set("file", this.chunks[0], `${this.file.name}.part`);
            axios$2
                .post("/post/attach-media/" + vm.post, postData, {
                    onUploadProgress: (event2) => {
                        vm.uploaded += event2.loaded;
                    },
                })
                .then(function (response) {
                    if (response.data.result) {
                        if (vm.chunks.length <= 1) {
                            vm.file = null;
                            vm.chunks = [];
                            vm.uploadPercentage = 0;
                            vm.uploaded = 0;
                            vm.attachmentType = null;
                            vm.loadPost(vm.post);
                        }
                        vm.chunks.shift();
                    } else {
                        response.data.errors.forEach(function (err) {
                            vm.$toast.error(err);
                        });
                    }
                })
                .catch(function (error2) {
                    vm.file = null;
                    vm.chunks = [];
                    vm.uploadPercentage = 0;
                    vm.uploaded = 0;
                    let response = error2.response.data;
                    if (typeof response.errors != "undefined") {
                        for (let err in response.errors) {
                            if (response.errors.hasOwnProperty(err)) {
                                vm.$toast.error(response.errors[err][0]);
                            }
                        }
                    } else {
                        vm.$toast.error(error2.toString());
                    }
                })
                .then(function () {
                    vm.showSpinner = false;
                });
        },
    },
    watch: {
        chunks(n, o) {
            if (n.length > 0) {
                this.uploadChunks();
            }
        },
    },
    computed: {
        progress() {
            if (this.file) {
                return Math.floor((this.uploaded * 100) / this.file.size);
            } else {
                return 0;
            }
        },
    },
};
var _sfc_render$1 = function render() {
    var _vm = this,
        _c = _vm._self._c;
    return _c("div", [
        _c("div", { attrs: { id: "belowCreatePost" } }, [
            _c("textarea", {
                directives: [
                    {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.text_content,
                        expression: "text_content",
                    },
                ],
                staticClass:
                    "w-full shadow-sm rounded-lg focus:outline-none focus:ring-0 p-3 text-stone-600",
                attrs: { placeholder: _vm.writeSomethingTranslated, rows: "4" },
                domProps: { value: _vm.text_content },
                on: {
                    input: function ($event) {
                        if ($event.target.composing) return;
                        _vm.text_content = $event.target.value;
                    },
                },
            }),
            _c(
                "div",
                {
                    staticClass:
                        "flex flex-wrap items-center justify-between bg-white py-3 flex-grow rounded-lg shadow-sm px-2",
                },
                [
                    _c("div", { staticClass: "flex items-center space-x-2" }, [
                        _c(
                            "a",
                            {
                                directives: [
                                    {
                                        name: "tooltip",
                                        rawName: "v-tooltip",
                                        value: _vm.imageUploadTranslated,
                                        expression: "imageUploadTranslated",
                                    },
                                ],
                                staticClass: "text-333 mr-1",
                                attrs: { href: "javascript:void(0)" },
                                on: { click: _vm.selectPhotos },
                            },
                            [
                                _c("img", {
                                    staticClass: "w-7",
                                    attrs: {
                                        src: _vm.cameraIcon,
                                        alt: "camera icon",
                                    },
                                }),
                            ]
                        ),
                        _c(
                            "a",
                            {
                                directives: [
                                    {
                                        name: "tooltip",
                                        rawName: "v-tooltip",
                                        value: _vm.videoUploadTranslated,
                                        expression: "videoUploadTranslated",
                                    },
                                ],
                                staticClass: "text-333",
                                attrs: { href: "javascript:void(0)" },
                                on: {
                                    click: function ($event) {
                                        return _vm.selectMedia("Video");
                                    },
                                },
                            },
                            [
                                _c("img", {
                                    staticClass: "w-6",
                                    attrs: {
                                        src: _vm.videoIcon,
                                        alt: "video icon",
                                    },
                                }),
                            ]
                        ),
                        _c(
                            "a",
                            {
                                directives: [
                                    {
                                        name: "tooltip",
                                        rawName: "v-tooltip",
                                        value: _vm.audioUploadTranslated,
                                        expression: "audioUploadTranslated",
                                    },
                                ],
                                staticClass: "text-333",
                                attrs: { href: "javascript:void(0)" },
                                on: {
                                    click: function ($event) {
                                        return _vm.selectMedia("Audio");
                                    },
                                },
                            },
                            [
                                _c("img", {
                                    staticClass: "w-6 h-6",
                                    attrs: {
                                        src: _vm.audioIcon,
                                        alt: "audio icon",
                                    },
                                }),
                            ]
                        ),
                        _c(
                            "a",
                            {
                                directives: [
                                    {
                                        name: "tooltip",
                                        rawName: "v-tooltip",
                                        value: _vm.zipUploadTranslated,
                                        expression: "zipUploadTranslated",
                                    },
                                ],
                                staticClass: "text-333",
                                attrs: { href: "javascript:void(0)" },
                                on: {
                                    click: function ($event) {
                                        return _vm.selectMedia("ZIP");
                                    },
                                },
                            },
                            [
                                _c("img", {
                                    staticClass: "w-6 h-6",
                                    attrs: {
                                        src: _vm.zipIcon,
                                        alt: "zip icon",
                                    },
                                }),
                            ]
                        ),
                        _c("input", {
                            ref: "imageUploads",
                            staticClass: "hidden",
                            attrs: {
                                accept: "image/*",
                                multiple: "",
                                type: "file",
                            },
                            on: { change: _vm.appendPhotos },
                        }),
                        _c("input", {
                            ref: "videoUploads",
                            staticClass: "hidden",
                            attrs: {
                                accept: "video/mp4,video/webm,video/ogg,video/quicktime",
                                type: "file",
                            },
                            on: { change: _vm.appendMedia },
                        }),
                        _c("input", {
                            ref: "audioUploads",
                            staticClass: "hidden",
                            attrs: {
                                accept: "audio/mp3,audio/ogg,audio/wav",
                                type: "file",
                            },
                            on: { change: _vm.appendMedia },
                        }),
                        _c("input", {
                            ref: "zipUploads",
                            staticClass: "hidden",
                            attrs: {
                                accept: "zip,application/zip,application/x-zip,application/x-zip-compressed,.zip",
                                type: "file",
                            },
                            on: { change: _vm.appendMedia },
                        }),
                    ]),
                    _c("div", [
                        _c("div", { staticClass: "relative" }, [
                            _c(
                                "a",
                                {
                                    staticClass:
                                        "px-4 py-2 bg-indigo-800 text-white rounded-full text-sm font-semibold hover:bg-indigo-600",
                                    attrs: { href: "javascript:void(0)" },
                                    on: {
                                        click: function ($event) {
                                            return _vm.showTypeDropdown();
                                        },
                                    },
                                },
                                [
                                    _vm._v(
                                        " " +
                                            _vm._s(_vm.savePostTranslated) +
                                            " "
                                    ),
                                    !_vm.showFreeOrPaid
                                        ? _c("i", {
                                              staticClass:
                                                  "fas fa-chevron-down",
                                          })
                                        : _vm._e(),
                                    _vm.showFreeOrPaid
                                        ? _c("i", {
                                              staticClass: "fas fa-chevron-up",
                                          })
                                        : _vm._e(),
                                ]
                            ),
                            _c(
                                "div",
                                {
                                    staticClass:
                                        "rounded-lg border bg-white absolute top-10 left-[-20px] xl:left-[-80px] z-10 xl:w-60",
                                    class: { hidden: !_vm.showFreeOrPaid },
                                },
                                [
                                    _c(
                                        "a",
                                        {
                                            staticClass:
                                                "flex w-full p-2 border-b text-gray-600 items-center hover:bg-gray-100",
                                            attrs: {
                                                href: "javascript:void(0)",
                                            },
                                            on: {
                                                click: function ($event) {
                                                    return _vm.changePostLockType(
                                                        "Free"
                                                    );
                                                },
                                            },
                                        },
                                        [
                                            _c("i", {
                                                staticClass:
                                                    "fas fa-lock-open text-gray-300 mr-1",
                                            }),
                                            _c(
                                                "span",
                                                {
                                                    staticClass:
                                                        "hidden xl:block",
                                                },
                                                [_vm._v("Available to Anyone")]
                                            ),
                                            _c(
                                                "span",
                                                { staticClass: "xl:hidden" },
                                                [_vm._v("Free Post")]
                                            ),
                                        ]
                                    ),
                                    _c(
                                        "a",
                                        {
                                            staticClass:
                                                "flex w-full p-2 text-gray-600 items-center hover:bg-gray-100",
                                            attrs: {
                                                href: "javascript:void(0)",
                                            },
                                            on: {
                                                click: function ($event) {
                                                    return _vm.changePostLockType(
                                                        "Paid"
                                                    );
                                                },
                                            },
                                        },
                                        [
                                            _c("i", {
                                                staticClass:
                                                    "fas fa-lock text-gray-300 mr-1",
                                            }),
                                            _c(
                                                "span",
                                                {
                                                    staticClass:
                                                        "hidden xl:block",
                                                },
                                                [
                                                    _vm._v(
                                                        "Only for Paid Subscribers"
                                                    ),
                                                ]
                                            ),
                                            _c(
                                                "span",
                                                { staticClass: "xl:hidden" },
                                                [_vm._v("Paid Post")]
                                            ),
                                        ]
                                    ),
                                ]
                            ),
                        ]),
                    ]),
                ]
            ),
        ]),
        _c(
            "div",
            {
                staticClass: "flex flex-wrap mt-2 mb-5 bg-white p-5 rounded-lg",
                class: {
                    hidden: !_vm.selectedPhotos.length && _vm.file === null,
                },
            },
            [
                _vm._l(_vm.selectedPhotos, function (p, pIndex) {
                    return _c(
                        "div",
                        {
                            key: "photoIndex" + pIndex,
                            staticClass: "text-center mr-2 mb-2",
                        },
                        [
                            _c("img", {
                                staticClass: "w-24 rounded-lg aspect-sqaure",
                                attrs: { src: p.url, alt: "" },
                            }),
                            _c(
                                "a",
                                {
                                    staticClass: "text-rose-600 inline-block",
                                    attrs: { href: "javascript:void(0)" },
                                    on: {
                                        click: function ($event) {
                                            return _vm.removePhoto(pIndex);
                                        },
                                    },
                                },
                                [
                                    _c("img", {
                                        staticClass: "w-4",
                                        attrs: {
                                            src: _vm.trashIcon,
                                            alt: "trash icon",
                                        },
                                    }),
                                ]
                            ),
                        ]
                    );
                }),
                _vm.file
                    ? _c("div", [
                          _vm._v(" " + _vm._s(_vm.file.name) + " - "),
                          _c(
                              "a",
                              {
                                  staticClass: "text-danger d-inline-block",
                                  attrs: { href: "javascript:void(0)" },
                                  on: { click: _vm.removeFile },
                              },
                              [
                                  _c("img", {
                                      staticClass: "w-4",
                                      attrs: {
                                          src: _vm.trashIcon,
                                          alt: "trash icon",
                                      },
                                  }),
                              ]
                          ),
                      ])
                    : _vm._e(),
            ],
            2
        ),
        _c(
            "div",
            {
                staticClass:
                    "progress-wrapper mt-5 mb-3 bg-white px-5 pt-2 pb-8 rounded-lg shadow-sm",
                class: { hidden: _vm.uploadPercentage === 0 },
                attrs: { id: "progress-photos" },
            },
            [
                _c("div", { staticClass: "progress-percentage text-center" }, [
                    _c(
                        "span",
                        { staticClass: "text-xl font-bold text-stone-600" },
                        [_vm._v(_vm._s(_vm.uploadPercentage) + "%")]
                    ),
                ]),
                _c(
                    "div",
                    {
                        staticClass:
                            "w-full bg-gray-200 rounded-full h-2.5 dark:bg-gray-700",
                    },
                    [
                        _c("div", {
                            staticClass: "bg-indigo-600 h-2.5 rounded-full",
                            style: "width:" + _vm.uploadPercentage + "%;",
                        }),
                    ]
                ),
            ]
        ),
        _c(
            "div",
            {
                staticClass:
                    "progress-wrapper mt-5 mb-3 bg-white px-5 pt-2 pb-8 rounded-lg shadow-sm",
                class: { hidden: _vm.progress === 0 || _vm.progress > 100 },
                attrs: { id: "progress-others" },
            },
            [
                _c("div", { staticClass: "progress-percentage text-center" }, [
                    _c(
                        "span",
                        { staticClass: "text-xl font-bold text-stone-600" },
                        [_vm._v(_vm._s(_vm.progress) + "%")]
                    ),
                ]),
                _c(
                    "div",
                    {
                        staticClass:
                            "w-full bg-gray-200 rounded-full h-2.5 dark:bg-gray-700",
                    },
                    [
                        _c("div", {
                            staticClass: "bg-indigo-600 h-2.5 rounded-full",
                            style: "width:" + _vm.progress + "%;",
                        }),
                    ]
                ),
            ]
        ),
        _vm.loadPostSpinner || _vm.showSpinner
            ? _c(
                  "div",
                  {
                      staticClass:
                          "text-center mb-4 p-3 bg-white text-stone-500 rounded-lg shadow-sm",
                  },
                  [_vm._v(" " + _vm._s(_vm.processingUploadTranslated) + " ")]
              )
            : _vm._e(),
        _c("div", { ref: "vueAppendedPosts", staticClass: "mt-7" }),
    ]);
};
var _sfc_staticRenderFns$1 = [];
var __component__$1 = /* @__PURE__ */ normalizeComponent$3(
    _sfc_main$1,
    _sfc_render$1,
    _sfc_staticRenderFns$1,
    false,
    null,
    null,
    null,
    null
);
const CreatePost = __component__$1.exports;
const UpdatePost_vue_vue_type_style_index_0_lang = "";
const axios$1 = window.axios;
const _sfc_main = {
    data() {
        return {
            writeSomethingTranslated: window.writeSomething,
            updatePostTranslated: window.updatePost,
            freePostTranslated: window.freePost,
            paidPostTranslated: window.paidPost,
            imageUploadTranslated: window.imageUpload,
            videoUploadTranslated: window.videoUpload,
            audioUploadTranslated: window.audioUpload,
            zipUploadTranslated: window.zipUpload,
            zipDownloadTranslated: window.zipDownload,
            deleteMediaTranslated: window.removeMedia,
            successfullyUpdatedPost: window.successfullyUpdatedPost,
            profilePic: "/images/default-profile-pic.png",
            authUser: null,
            postLockType: "Paid",
            text_content: "",
            showSpinner: false,
            postJSON: {},
            selectedPhotos: [],
            uploadPercentage: 0,
            attachmentType: null,
            file: null,
            chunks: [],
            uploaded: 0,
            main_media: {},
            extra_media: [],
        };
    },
    mounted() {
        this.getUser();
        this.getProfilePic();
        this.getPost();
    },
    methods: {
        getProfilePic() {
            const vm = this;
            axios$1
                .get("/profile/get/profilePicture")
                .then(function (response) {
                    vm.profilePic = response.data.picture;
                })
                .catch(function (error2) {
                    vm.$toast.error(
                        "Fetching Profile Pic: " + error2.toString()
                    );
                });
        },
        getUser() {
            const vm = this;
            axios$1
                .post("/messages/get/auth-user")
                .then(function (response) {
                    vm.authUser = response.data;
                })
                .catch(function (error2) {
                    vm.$toast.error("Fetching User: " + error2.toString());
                });
        },
        getPost() {
            const vm = this;
            if (this.post < 1) {
                vm.$toast.error("Invalid post id");
                window.setInterval(function () {
                    document.location.href = "/feed";
                }, 2e3);
            }
            axios$1
                .get("/post/json/" + this.post)
                .then(function (response) {
                    vm.postJSON = response.data;
                    vm.text_content = response.data.text_content;
                    vm.postLockType = response.data.lock_type;
                    if (response.data.media_content) {
                        vm.main_media = {
                            media_content: response.data.media_content,
                            type: response.data.media_type,
                        };
                    }
                    vm.extra_media = response.data.postmedia;
                })
                .catch(function (error2) {
                    vm.$toast.error("Fetching Post: " + error2.toString());
                });
        },
        changePostLockType() {
            if (this.postLockType === "Paid") {
                this.postLockType = "Free";
            } else if (this.postLockType === "Free") {
                this.postLockType = "Paid";
            }
        },
        selectPhotos() {
            this.$refs.imageUploads.click();
        },
        appendPhotos(event2) {
            const filesNum = event2.target.files.length;
            const attachments = event2.target.files;
            for (let i = 0; i < filesNum; i++) {
                const file2 = attachments[i];
                this.selectedPhotos.push({
                    file: file2,
                    url: URL.createObjectURL(file2),
                });
            }
        },
        removePhoto(index2) {
            console.log("Removing Photo By Index: " + index2);
            this.selectedPhotos.splice(index2, 1);
        },
        savePost() {
            const vm = this;
            vm.showSpinner = true;
            axios$1
                .post("/post/save/" + vm.postJSON.id, {
                    text_content: vm.text_content,
                    lock_type: vm.postLockType,
                })
                .then(function (response) {
                    if (response.data.result) {
                        vm.getPost();
                        if (vm.selectedPhotos.length > 0) {
                            vm.uploadPhotos(vm.postJSON.id);
                        } else if (vm.file) {
                            vm.createChunks();
                        } else {
                            vm.$toast.info(vm.successfullyUpdatedPost);
                        }
                    } else {
                        response.data.errors.forEach(function (err) {
                            vm.$toast.error(err);
                        });
                    }
                })
                .catch(function (error2) {
                    vm.$toast.error(error2.toString());
                })
                .then(function () {
                    vm.showSpinner = false;
                });
        },
        uploadPhotos(postID) {
            const vm = this;
            vm.showSpinner = true;
            const postData = new FormData();
            postData.append("media_type", "Image");
            for (let fileKey in this.selectedPhotos) {
                postData.append(
                    "imageUpload[]",
                    this.selectedPhotos[fileKey].file
                );
            }
            axios$1
                .post("/post/attach-media/" + postID, postData, {
                    onUploadProgress: (event2) => {
                        vm.uploadPercentage = parseInt(
                            Math.round((event2.loaded / event2.total) * 100)
                        );
                    },
                })
                .then(function (response) {
                    if (response.data.result) {
                        vm.getPost();
                    } else {
                        response.data.errors.forEach(function (err) {
                            vm.$toast.error(err);
                        });
                    }
                })
                .catch(function (error2) {
                    let response = error2.response.data;
                    if (typeof response.errors != "undefined") {
                        for (let err in response.errors) {
                            if (response.errors.hasOwnProperty(err)) {
                                vm.$toast.error(response.errors[err][0]);
                            }
                        }
                    } else {
                        vm.$toast.error(error2.toString());
                    }
                })
                .then(function () {
                    vm.showSpinner = false;
                    vm.selectedPhotos = [];
                    vm.uploadPercentage = 0;
                });
        },
        loadPost(postID) {
            const vm = this;
            vm.showSpinner = true;
            axios$1
                .get("/post/loadById/" + postID)
                .then(function (response) {
                    const currentHTML = vm.$refs.vueAppendedPosts.innerHTML;
                    vm.$refs.vueAppendedPosts.innerHTML =
                        response.data + currentHTML;
                })
                .catch(function (error2) {
                    vm.$toast.error(error2.toString());
                })
                .then(function () {
                    vm.showSpinner = false;
                });
        },
        appendMedia() {
            console.log("setting file");
            this.file = event.target.files.item(0);
            console.log(this.file);
        },
        removeFile() {
            this.file = null;
            this.chunks = [];
        },
        selectMedia(mediaType) {
            this.attachmentType = mediaType;
            if (mediaType === "Video") {
                this.$refs.videoUploads.click();
            } else if (mediaType === "Audio") {
                this.$refs.audioUploads.click();
            } else if (mediaType === "ZIP") {
                this.$refs.zipUploads.click();
            }
        },
        createChunks() {
            let size2 = 1024 * 1024 * 8,
                chunks = Math.ceil(this.file.size / size2);
            for (let i = 0; i < chunks; i++) {
                this.chunks.push(
                    this.file.slice(
                        i * size2,
                        Math.min(i * size2 + size2, this.file.size),
                        this.file.type
                    )
                );
            }
        },
        uploadChunks() {
            const vm = this;
            vm.showSpinner = true;
            const postData = new FormData();
            postData.append("media_type", vm.attachmentType);
            postData.append("is_last", vm.chunks.length === 1);
            postData.set("file", this.chunks[0], `${this.file.name}.part`);
            axios$1
                .post("/post/attach-media/" + vm.post, postData, {
                    onUploadProgress: (event2) => {
                        vm.uploaded += event2.loaded;
                    },
                })
                .then(function (response) {
                    if (response.data.result) {
                        if (vm.chunks.length <= 1) {
                            vm.file = null;
                            vm.chunks = [];
                            vm.uploadPercentage = 0;
                            vm.uploaded = 0;
                            vm.attachmentType = null;
                            vm.getPost();
                        }
                        vm.chunks.shift();
                    } else {
                        response.data.errors.forEach(function (err) {
                            vm.$toast.error(err);
                        });
                    }
                })
                .catch(function (error2) {
                    vm.file = null;
                    vm.chunks = [];
                    vm.uploadPercentage = 0;
                    vm.uploaded = 0;
                    let response = error2.response.data;
                    if (typeof response.errors != "undefined") {
                        for (let err in response.errors) {
                            if (response.errors.hasOwnProperty(err)) {
                                vm.$toast.error(response.errors[err][0]);
                            }
                        }
                    } else {
                        vm.$toast.error(error2.toString());
                    }
                })
                .then(function () {
                    vm.showSpinner = false;
                });
        },
    },
    watch: {
        chunks(n, o) {
            if (n.length > 0) {
                this.uploadChunks();
            }
        },
    },
    computed: {
        progress() {
            if (this.file) {
                return Math.floor((this.uploaded * 100) / this.file.size);
            } else {
                return 0;
            }
        },
        mediaNotEmpty() {
            return Object.keys(this.main_media).length;
        },
        post() {
            let url = document.location.href;
            let urlParts = url.split("/");
            return urlParts[urlParts.length - 1];
        },
    },
};
var _sfc_render = function render2() {
    var _vm = this,
        _c = _vm._self._c;
    return _c("div", [
        _c("div", { staticClass: "card mb-4 p-4" }, [
            _c("div", { staticClass: "row" }, [
                _c(
                    "div",
                    { staticClass: "col-sm-2 d-md-block d-none d-sm-none" },
                    [
                        _c(
                            "div",
                            {
                                staticClass:
                                    "profilePicSmall mt-0 ml-0 mr-2 mb-2 profilePicOnlineSm",
                            },
                            [
                                _c("img", {
                                    staticClass: "img-fluid",
                                    attrs: { src: _vm.profilePic, alt: "" },
                                }),
                            ]
                        ),
                    ]
                ),
                _c(
                    "div",
                    {
                        staticClass: "col-12 col-sm-10",
                        attrs: { id: "belowCreatePost" },
                    },
                    [
                        _c("textarea", {
                            directives: [
                                {
                                    name: "model",
                                    rawName: "v-model",
                                    value: _vm.text_content,
                                    expression: "text_content",
                                },
                            ],
                            staticClass: "form-control",
                            attrs: {
                                id: "createPost",
                                placeholder: _vm.writeSomethingTranslated,
                                rows: "4",
                            },
                            domProps: { value: _vm.text_content },
                            on: {
                                input: function ($event) {
                                    if ($event.target.composing) return;
                                    _vm.text_content = $event.target.value;
                                },
                            },
                        }),
                        _c("br"),
                        _c("div", { staticClass: "row" }, [
                            _c(
                                "div",
                                { staticClass: "col-12 col-sm-12 col-md-8" },
                                [
                                    _c(
                                        "a",
                                        {
                                            directives: [
                                                {
                                                    name: "tooltip",
                                                    rawName: "v-tooltip",
                                                    value: _vm.imageUploadTranslated,
                                                    expression:
                                                        "imageUploadTranslated",
                                                },
                                            ],
                                            staticClass: "text-333 mr-1",
                                            attrs: {
                                                href: "javascript:void(0)",
                                            },
                                            on: { click: _vm.selectPhotos },
                                        },
                                        [_vm._m(0)]
                                    ),
                                    _c(
                                        "a",
                                        {
                                            directives: [
                                                {
                                                    name: "tooltip",
                                                    rawName: "v-tooltip",
                                                    value: _vm.videoUploadTranslated,
                                                    expression:
                                                        "videoUploadTranslated",
                                                },
                                            ],
                                            staticClass: "text-333",
                                            attrs: {
                                                href: "javascript:void(0)",
                                            },
                                            on: {
                                                click: function ($event) {
                                                    return _vm.selectMedia(
                                                        "Video"
                                                    );
                                                },
                                            },
                                        },
                                        [_vm._m(1)]
                                    ),
                                    _c(
                                        "a",
                                        {
                                            directives: [
                                                {
                                                    name: "tooltip",
                                                    rawName: "v-tooltip",
                                                    value: "Upload Audio",
                                                    expression:
                                                        "'Upload Audio'",
                                                },
                                            ],
                                            staticClass: "text-333",
                                            attrs: {
                                                href: "javascript:void(0)",
                                            },
                                            on: {
                                                click: function ($event) {
                                                    return _vm.selectMedia(
                                                        "Audio"
                                                    );
                                                },
                                            },
                                        },
                                        [_vm._m(2)]
                                    ),
                                    _vm.postLockType === "Paid"
                                        ? _c(
                                              "a",
                                              {
                                                  ref: "paidPostLockIcon",
                                                  staticClass: "text-333",
                                                  attrs: {
                                                      href: "javascript:void(0)",
                                                  },
                                                  on: {
                                                      click: _vm.changePostLockType,
                                                  },
                                              },
                                              [
                                                  _c("img", {
                                                      staticClass:
                                                          "post-uploader-icons lock-closed-icon",
                                                      attrs: {
                                                          alt: "locked icon",
                                                          src: _vm.profilePic,
                                                      },
                                                  }),
                                                  _vm._v(
                                                      " " +
                                                          _vm._s(
                                                              _vm.paidPostTranslated
                                                          ) +
                                                          " "
                                                  ),
                                              ]
                                          )
                                        : _vm._e(),
                                    _c("input", {
                                        ref: "imageUploads",
                                        staticClass: "d-none",
                                        attrs: {
                                            accept: "image/*",
                                            multiple: "",
                                            type: "file",
                                        },
                                        on: { change: _vm.appendPhotos },
                                    }),
                                    _c("input", {
                                        ref: "videoUploads",
                                        staticClass: "d-none",
                                        attrs: {
                                            accept: "video/mp4,video/webm,video/ogg,video/quicktime",
                                            type: "file",
                                        },
                                        on: { change: _vm.appendMedia },
                                    }),
                                    _c("input", {
                                        ref: "audioUploads",
                                        staticClass: "d-none",
                                        attrs: {
                                            accept: "audio/mp3,audio/ogg,audio/wav",
                                            type: "file",
                                        },
                                        on: { change: _vm.appendMedia },
                                    }),
                                    _c("input", {
                                        ref: "zipUploads",
                                        staticClass: "d-none",
                                        attrs: {
                                            accept: "zip,application/zip,application/x-zip,application/x-zip-compressed,.zip",
                                            type: "file",
                                        },
                                        on: { change: _vm.appendMedia },
                                    }),
                                ]
                            ),
                            _c(
                                "div",
                                {
                                    staticClass:
                                        "col-12 col-sm-12 col-md-4 text-right",
                                },
                                [
                                    _c(
                                        "a",
                                        {
                                            staticClass:
                                                "btnBlue mr-0 mb-2 mt-3 mt-sm-1 mt-md-0 mt-sm-3",
                                            attrs: {
                                                href: "javascript:void(0)",
                                            },
                                            on: { click: _vm.savePost },
                                        },
                                        [
                                            _c("i", {
                                                staticClass:
                                                    "far fa-paper-plane mr-1",
                                            }),
                                            _vm._v(
                                                " " +
                                                    _vm._s(
                                                        _vm.updatePostTranslated
                                                    ) +
                                                    " "
                                            ),
                                        ]
                                    ),
                                ]
                            ),
                        ]),
                    ]
                ),
            ]),
            _c(
                "div",
                { staticClass: "row" },
                [
                    _vm._l(_vm.selectedPhotos, function (p, pIndex) {
                        return _c(
                            "div",
                            {
                                key: "photoIndex" + pIndex,
                                staticClass: "col-6 col-md-3 text-center",
                            },
                            [
                                _c("img", {
                                    staticClass: "img-fluid rounded",
                                    attrs: { src: p.url, alt: "" },
                                }),
                                _c("br"),
                                _c(
                                    "a",
                                    {
                                        staticClass:
                                            "text-danger d-inline-block",
                                        attrs: { href: "javascript:void(0)" },
                                        on: {
                                            click: function ($event) {
                                                return _vm.removePhoto(pIndex);
                                            },
                                        },
                                    },
                                    [_c("i", { staticClass: "fas fa-trash" })]
                                ),
                            ]
                        );
                    }),
                    _vm.file
                        ? _c("div", [
                              _vm._v(" " + _vm._s(_vm.file.name) + " - "),
                              _c(
                                  "a",
                                  {
                                      staticClass: "text-danger d-inline-block",
                                      attrs: { href: "javascript:void(0)" },
                                      on: { click: _vm.removeFile },
                                  },
                                  [_c("i", { staticClass: "fas fa-trash" })]
                              ),
                          ])
                        : _vm._e(),
                ],
                2
            ),
            _c(
                "div",
                {
                    staticClass: "progress-wrapper mt-5 mb-3",
                    class: { "d-none": _vm.uploadPercentage === 0 },
                    attrs: { id: "progress-photos" },
                },
                [
                    _c("div", { staticClass: "progress-info" }, [
                        _c(
                            "div",
                            { staticClass: "progress-percentage text-center" },
                            [
                                _c(
                                    "span",
                                    { staticClass: "percent text-primary" },
                                    [_vm._v(_vm._s(_vm.uploadPercentage) + "%")]
                                ),
                            ]
                        ),
                    ]),
                    _c("div", { staticClass: "progress progress-xs" }, [
                        _c("div", {
                            staticClass: "progress-bar progress-bar-striped",
                            style: "width:" + _vm.uploadPercentage + "%;",
                            attrs: {
                                "aria-valuemax": "100",
                                "aria-valuemin": "0",
                                "aria-valuenow": _vm.uploadPercentage,
                                role: "progressbar",
                            },
                        }),
                    ]),
                ]
            ),
            _c(
                "div",
                {
                    staticClass: "progress-wrapper mt-5 mb-3",
                    class: {
                        "d-none": _vm.progress === 0 || _vm.progress > 100,
                    },
                    attrs: { id: "progress-others" },
                },
                [
                    _c("div", { staticClass: "progress-info" }, [
                        _c(
                            "div",
                            { staticClass: "progress-percentage text-center" },
                            [
                                _c(
                                    "span",
                                    { staticClass: "percent text-primary" },
                                    [_vm._v(_vm._s(_vm.progress) + "%")]
                                ),
                            ]
                        ),
                    ]),
                    _c("div", { staticClass: "progress progress-xs" }, [
                        _c("div", {
                            staticClass: "progress-bar progress-bar-striped",
                            style: "width:" + _vm.progress + "%;",
                            attrs: {
                                "aria-valuemax": "100",
                                "aria-valuemin": "0",
                                "aria-valuenow": _vm.progress,
                                role: "progressbar",
                            },
                        }),
                    ]),
                ]
            ),
        ]),
        _vm.mediaNotEmpty
            ? _c("div", { staticClass: "card p-4 mb-4" }, [
                  _c(
                      "a",
                      {
                          staticClass: "btn btn-light remove-media col-3",
                          attrs: {
                              href: "/post/delete-media/" + _vm.postJSON.id,
                          },
                      },
                      [
                          _c("i", { staticClass: "fas fa-backspace" }),
                          _vm._v(" " + _vm._s(_vm.deleteMediaTranslated) + " "),
                      ]
                  ),
                  _vm.main_media.type === "Image"
                      ? _c("img", {
                            directives: [
                                {
                                    name: "img",
                                    rawName: "v-img",
                                    value: {
                                        src: _vm.main_media.media_content,
                                    },
                                    expression:
                                        "{ src: main_media.media_content }",
                                },
                            ],
                            staticClass: "img-fluid",
                            attrs: { src: _vm.main_media.media_content },
                        })
                      : _vm._e(),
                  _vm.main_media.type === "Video"
                      ? _c(
                            "video",
                            {
                                attrs: {
                                    controls: "",
                                    preload: "metadata",
                                    disablePictureInPicture: "",
                                },
                            },
                            [
                                _c("source", {
                                    attrs: {
                                        src:
                                            _vm.main_media.media_content +
                                            "#t=0.5",
                                        type: "video/mp4",
                                    },
                                }),
                            ]
                        )
                      : _vm._e(),
                  _vm.main_media.type === "Audio"
                      ? _c(
                            "audio",
                            {
                                staticClass: "w-100 p-2",
                                attrs: {
                                    controls: "",
                                    controlsList: "download",
                                },
                            },
                            [
                                _c("source", {
                                    attrs: {
                                        src: _vm.main_media.media_content,
                                        type: "audio/mp3",
                                    },
                                }),
                            ]
                        )
                      : _vm._e(),
                  _vm.main_media.type === "ZIP"
                      ? _c(
                            "a",
                            {
                                staticClass: "ml-1 mt-2 btn btn-primary btn-sm",
                                attrs: {
                                    href:
                                        "/post/download-zip/" + _vm.postJSON.id,
                                    target: "_blank",
                                },
                            },
                            [
                                _c("i", { staticClass: "fas fa-file-archive" }),
                                _vm._v(
                                    " " +
                                        _vm._s(_vm.zipDownloadTranslated) +
                                        " "
                                ),
                            ]
                        )
                      : _vm._e(),
              ])
            : _vm._e(),
        _vm.extra_media.length
            ? _c("div", { staticClass: "card p-4 mb-4" }, [
                  _c(
                      "div",
                      { staticClass: "row" },
                      _vm._l(_vm.extra_media, function (m, mIndex) {
                          return _c("div", { staticClass: "col-6" }, [
                              _c("img", {
                                  directives: [
                                      {
                                          name: "img",
                                          rawName: "v-img",
                                          value: { src: m.media_content },
                                          expression:
                                              "{ src: m.media_content }",
                                      },
                                  ],
                                  staticClass: "img-fluid",
                                  attrs: { src: m.media_content, alt: "" },
                              }),
                          ]);
                      }),
                      0
                  ),
              ])
            : _vm._e(),
    ]);
};
var _sfc_staticRenderFns = [
    function () {
        var _vm = this,
            _c = _vm._self._c;
        return _c("h4", { staticClass: "d-inline createImageIcon" }, [
            _c("i", { staticClass: "fa fa-image" }),
        ]);
    },
    function () {
        var _vm = this,
            _c = _vm._self._c;
        return _c("h4", { staticClass: "d-inline createVideoIcon" }, [
            _c("i", { staticClass: "fa fa-video" }),
        ]);
    },
    function () {
        var _vm = this,
            _c = _vm._self._c;
        return _c("h4", { staticClass: "d-inline createAudioIcon" }, [
            _c("i", { staticClass: "fa fa-music" }),
        ]);
    },
];
var __component__ = /* @__PURE__ */ normalizeComponent$3(
    _sfc_main,
    _sfc_render,
    _sfc_staticRenderFns,
    false,
    null,
    null,
    null,
    null
);
const UpdatePost = __component__.exports;
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) {
        return value instanceof P
            ? value
            : new P(function (resolve) {
                  resolve(value);
              });
    }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) {
            try {
                step(generator.next(value));
            } catch (e) {
                reject(e);
            }
        }
        function rejected(value) {
            try {
                step(generator["throw"](value));
            } catch (e) {
                reject(e);
            }
        }
        function step(result) {
            result.done
                ? resolve(result.value)
                : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}
var TYPE;
(function (TYPE2) {
    TYPE2["SUCCESS"] = "success";
    TYPE2["ERROR"] = "error";
    TYPE2["WARNING"] = "warning";
    TYPE2["INFO"] = "info";
    TYPE2["DEFAULT"] = "default";
})(TYPE || (TYPE = {}));
var POSITION;
(function (POSITION2) {
    POSITION2["TOP_LEFT"] = "top-left";
    POSITION2["TOP_CENTER"] = "top-center";
    POSITION2["TOP_RIGHT"] = "top-right";
    POSITION2["BOTTOM_LEFT"] = "bottom-left";
    POSITION2["BOTTOM_CENTER"] = "bottom-center";
    POSITION2["BOTTOM_RIGHT"] = "bottom-right";
})(POSITION || (POSITION = {}));
var EVENTS;
(function (EVENTS2) {
    EVENTS2["ADD"] = "add";
    EVENTS2["DISMISS"] = "dismiss";
    EVENTS2["UPDATE"] = "update";
    EVENTS2["CLEAR"] = "clear";
    EVENTS2["UPDATE_DEFAULTS"] = "update_defaults";
})(EVENTS || (EVENTS = {}));
const VT_NAMESPACE = "Vue-Toastification";
const COMMON = {
    type: {
        type: String,
        default: TYPE.DEFAULT,
    },
    classNames: {
        type: [String, Array],
        default: () => [],
    },
    trueBoolean: {
        type: Boolean,
        default: true,
    },
};
const ICON = {
    type: COMMON.type,
    customIcon: {
        type: [String, Boolean, Object, Function],
        default: true,
    },
};
const CLOSE_BUTTON = {
    component: {
        type: [String, Object, Function, Boolean],
        default: "button",
    },
    classNames: COMMON.classNames,
    showOnHover: Boolean,
    ariaLabel: {
        type: String,
        default: "close",
    },
};
const PROGRESS_BAR = {
    timeout: {
        type: [Number, Boolean],
        default: 5e3,
    },
    hideProgressBar: Boolean,
    isRunning: Boolean,
};
const TRANSITION = {
    transition: {
        type: [Object, String],
        default: `${VT_NAMESPACE}__bounce`,
    },
    transitionDuration: {
        type: [Number, Object],
        default: 750,
    },
};
const CORE_TOAST = {
    position: {
        type: String,
        default: POSITION.TOP_RIGHT,
    },
    draggable: COMMON.trueBoolean,
    draggablePercent: {
        type: Number,
        default: 0.6,
    },
    pauseOnFocusLoss: COMMON.trueBoolean,
    pauseOnHover: COMMON.trueBoolean,
    closeOnClick: COMMON.trueBoolean,
    timeout: PROGRESS_BAR.timeout,
    hideProgressBar: PROGRESS_BAR.hideProgressBar,
    toastClassName: COMMON.classNames,
    bodyClassName: COMMON.classNames,
    icon: ICON.customIcon,
    closeButton: CLOSE_BUTTON.component,
    closeButtonClassName: CLOSE_BUTTON.classNames,
    showCloseButtonOnHover: CLOSE_BUTTON.showOnHover,
    accessibility: {
        type: Object,
        default: () => ({
            toastRole: "alert",
            closeButtonLabel: "close",
        }),
    },
    rtl: Boolean,
    eventBus: Object,
};
const TOAST = {
    id: {
        type: [String, Number],
        required: true,
    },
    type: COMMON.type,
    content: {
        type: [String, Object, Function],
        required: true,
    },
    onClick: Function,
    onClose: Function,
};
const CONTAINER = {
    container: {
        type: void 0,
        default: () => document.body,
    },
    newestOnTop: COMMON.trueBoolean,
    maxToasts: {
        type: Number,
        default: 20,
    },
    transition: TRANSITION.transition,
    transitionDuration: TRANSITION.transitionDuration,
    toastDefaults: Object,
    filterBeforeCreate: {
        type: Function,
        default: (toast) => toast,
    },
    filterToasts: {
        type: Function,
        default: (toasts) => toasts,
    },
    containerClassName: COMMON.classNames,
    onMounted: Function,
};
var PROPS = {
    CORE_TOAST,
    TOAST,
    CONTAINER,
    PROGRESS_BAR,
    ICON,
    TRANSITION,
    CLOSE_BUTTON,
};
const isFunction$6 = (value) => typeof value === "function";
const isString$1 = (value) => typeof value === "string";
const isNonEmptyString = (value) =>
    isString$1(value) && value.trim().length > 0;
const isNumber$1 = (value) => typeof value === "number";
const isUndefined = (value) => typeof value === "undefined";
const isObject$9 = (value) => typeof value === "object" && value !== null;
const isJSX = (obj) => hasProp(obj, "tag") && isNonEmptyString(obj.tag);
const isTouchEvent = (event2) =>
    window.TouchEvent && event2 instanceof TouchEvent;
const isToastComponent = (obj) =>
    hasProp(obj, "component") && isToastContent(obj.component);
const isConstructor = (c) => {
    return isFunction$6(c) && hasProp(c, "cid");
};
const isVueComponent = (c) => {
    if (isConstructor(c)) {
        return true;
    }
    if (!isObject$9(c)) {
        return false;
    }
    if (c.extends || c._Ctor) {
        return true;
    }
    if (isString$1(c.template)) {
        return true;
    }
    return hasRenderFunction(c);
};
const isVueInstanceOrComponent = (obj) =>
    obj instanceof Vue || isVueComponent(obj);
const isToastContent = (obj) =>
    !isUndefined(obj) &&
    (isString$1(obj) ||
        isVueInstanceOrComponent(obj) ||
        hasRenderFunction(obj) ||
        isJSX(obj) ||
        isToastComponent(obj));
const isDOMRect = (obj) =>
    isObject$9(obj) &&
    isNumber$1(obj.height) &&
    isNumber$1(obj.width) &&
    isNumber$1(obj.right) &&
    isNumber$1(obj.left) &&
    isNumber$1(obj.top) &&
    isNumber$1(obj.bottom);
const hasProp = (obj, propKey) =>
    Object.prototype.hasOwnProperty.call(obj, propKey);
const hasRenderFunction = (obj) =>
    hasProp(obj, "render") && isFunction$6(obj.render);
const getId = (
    (i) => () =>
        i++
)(0);
function getX(event2) {
    return isTouchEvent(event2)
        ? event2.targetTouches[0].clientX
        : event2.clientX;
}
function getY(event2) {
    return isTouchEvent(event2)
        ? event2.targetTouches[0].clientY
        : event2.clientY;
}
const removeElement = (el) => {
    if (!isUndefined(el.remove)) {
        el.remove();
    } else if (el.parentNode) {
        el.parentNode.removeChild(el);
    }
};
const getVueComponentFromObj = (obj) => {
    if (isToastComponent(obj)) {
        return getVueComponentFromObj(obj.component);
    }
    if (isJSX(obj)) {
        return {
            render() {
                return obj;
            },
        };
    }
    return obj;
};
var script$2 = Vue.extend({
    props: PROPS.PROGRESS_BAR,
    data() {
        return {
            hasClass: true,
        };
    },
    computed: {
        style() {
            return {
                animationDuration: `${this.timeout}ms`,
                animationPlayState: this.isRunning ? "running" : "paused",
                opacity: this.hideProgressBar ? 0 : 1,
            };
        },
        cpClass() {
            return this.hasClass ? `${VT_NAMESPACE}__progress-bar` : "";
        },
    },
    mounted() {
        this.$el.addEventListener("animationend", this.animationEnded);
    },
    beforeDestroy() {
        this.$el.removeEventListener("animationend", this.animationEnded);
    },
    methods: {
        animationEnded() {
            this.$emit("close-toast");
        },
    },
    watch: {
        timeout() {
            this.hasClass = false;
            this.$nextTick(() => (this.hasClass = true));
        },
    },
});
function normalizeComponent$2(
    template,
    style2,
    script2,
    scopeId,
    isFunctionalTemplate,
    moduleIdentifier,
    shadowMode,
    createInjector,
    createInjectorSSR,
    createInjectorShadow
) {
    if (typeof shadowMode !== "boolean") {
        createInjectorSSR = createInjector;
        createInjector = shadowMode;
        shadowMode = false;
    }
    const options = typeof script2 === "function" ? script2.options : script2;
    if (template && template.render) {
        options.render = template.render;
        options.staticRenderFns = template.staticRenderFns;
        options._compiled = true;
        if (isFunctionalTemplate) {
            options.functional = true;
        }
    }
    if (scopeId) {
        options._scopeId = scopeId;
    }
    let hook;
    if (moduleIdentifier) {
        hook = function (context) {
            context =
                context ||
                (this.$vnode && this.$vnode.ssrContext) ||
                (this.parent &&
                    this.parent.$vnode &&
                    this.parent.$vnode.ssrContext);
            if (!context && typeof __VUE_SSR_CONTEXT__ !== "undefined") {
                context = __VUE_SSR_CONTEXT__;
            }
            if (style2) {
                style2.call(this, createInjectorSSR(context));
            }
            if (context && context._registeredComponents) {
                context._registeredComponents.add(moduleIdentifier);
            }
        };
        options._ssrRegister = hook;
    } else if (style2) {
        hook = shadowMode
            ? function (context) {
                  style2.call(
                      this,
                      createInjectorShadow(
                          context,
                          this.$root.$options.shadowRoot
                      )
                  );
              }
            : function (context) {
                  style2.call(this, createInjector(context));
              };
    }
    if (hook) {
        if (options.functional) {
            const originalRender = options.render;
            options.render = function renderWithStyleInjection(h, context) {
                hook.call(context);
                return originalRender(h, context);
            };
        } else {
            const existing = options.beforeCreate;
            options.beforeCreate = existing
                ? [].concat(existing, hook)
                : [hook];
        }
    }
    return script2;
}
const __vue_script__$2 = script$2;
var __vue_render__$2 = function () {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c("div", { class: _vm.cpClass, style: _vm.style });
};
var __vue_staticRenderFns__$2 = [];
__vue_render__$2._withStripped = true;
const __vue_inject_styles__$2 = void 0;
const __vue_scope_id__$2 = void 0;
const __vue_module_identifier__$2 = void 0;
const __vue_is_functional_template__$2 = false;
const __vue_component__$2 = /* @__PURE__ */ normalizeComponent$2(
    { render: __vue_render__$2, staticRenderFns: __vue_staticRenderFns__$2 },
    __vue_inject_styles__$2,
    __vue_script__$2,
    __vue_scope_id__$2,
    __vue_is_functional_template__$2,
    __vue_module_identifier__$2,
    false,
    void 0,
    void 0,
    void 0
);
var script$1$1 = Vue.extend({
    props: PROPS.CLOSE_BUTTON,
    computed: {
        buttonComponent() {
            if (this.component !== false) {
                return getVueComponentFromObj(this.component);
            }
            return "button";
        },
        classes() {
            const classes = [`${VT_NAMESPACE}__close-button`];
            if (this.showOnHover) {
                classes.push("show-on-hover");
            }
            return classes.concat(this.classNames);
        },
    },
});
const __vue_script__$1$1 = script$1$1;
var __vue_render__$1$1 = function () {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
        _vm.buttonComponent,
        _vm._g(
            {
                tag: "component",
                class: _vm.classes,
                attrs: { "aria-label": _vm.ariaLabel },
            },
            _vm.$listeners
        ),
        [_vm._v("\n  \xD7\n")]
    );
};
var __vue_staticRenderFns__$1$1 = [];
__vue_render__$1$1._withStripped = true;
const __vue_inject_styles__$1$1 = void 0;
const __vue_scope_id__$1$1 = void 0;
const __vue_module_identifier__$1$1 = void 0;
const __vue_is_functional_template__$1$1 = false;
const __vue_component__$1$1 = /* @__PURE__ */ normalizeComponent$2(
    {
        render: __vue_render__$1$1,
        staticRenderFns: __vue_staticRenderFns__$1$1,
    },
    __vue_inject_styles__$1$1,
    __vue_script__$1$1,
    __vue_scope_id__$1$1,
    __vue_is_functional_template__$1$1,
    __vue_module_identifier__$1$1,
    false,
    void 0,
    void 0,
    void 0
);
var script$2$1 = {};
const __vue_script__$2$1 = script$2$1;
var __vue_render__$2$1 = function () {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
        "svg",
        {
            staticClass: "svg-inline--fa fa-check-circle fa-w-16",
            attrs: {
                "aria-hidden": "true",
                focusable: "false",
                "data-prefix": "fas",
                "data-icon": "check-circle",
                role: "img",
                xmlns: "http://www.w3.org/2000/svg",
                viewBox: "0 0 512 512",
            },
        },
        [
            _c("path", {
                attrs: {
                    fill: "currentColor",
                    d: "M504 256c0 136.967-111.033 248-248 248S8 392.967 8 256 119.033 8 256 8s248 111.033 248 248zM227.314 387.314l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.249-16.379-6.249-22.628 0L216 308.118l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.249 16.379 6.249 22.628.001z",
                },
            }),
        ]
    );
};
var __vue_staticRenderFns__$2$1 = [];
__vue_render__$2$1._withStripped = true;
const __vue_inject_styles__$2$1 = void 0;
const __vue_scope_id__$2$1 = void 0;
const __vue_module_identifier__$2$1 = void 0;
const __vue_is_functional_template__$2$1 = false;
const __vue_component__$2$1 = /* @__PURE__ */ normalizeComponent$2(
    {
        render: __vue_render__$2$1,
        staticRenderFns: __vue_staticRenderFns__$2$1,
    },
    __vue_inject_styles__$2$1,
    __vue_script__$2$1,
    __vue_scope_id__$2$1,
    __vue_is_functional_template__$2$1,
    __vue_module_identifier__$2$1,
    false,
    void 0,
    void 0,
    void 0
);
var script$3 = {};
const __vue_script__$3 = script$3;
var __vue_render__$3 = function () {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
        "svg",
        {
            staticClass: "svg-inline--fa fa-info-circle fa-w-16",
            attrs: {
                "aria-hidden": "true",
                focusable: "false",
                "data-prefix": "fas",
                "data-icon": "info-circle",
                role: "img",
                xmlns: "http://www.w3.org/2000/svg",
                viewBox: "0 0 512 512",
            },
        },
        [
            _c("path", {
                attrs: {
                    fill: "currentColor",
                    d: "M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z",
                },
            }),
        ]
    );
};
var __vue_staticRenderFns__$3 = [];
__vue_render__$3._withStripped = true;
const __vue_inject_styles__$3 = void 0;
const __vue_scope_id__$3 = void 0;
const __vue_module_identifier__$3 = void 0;
const __vue_is_functional_template__$3 = false;
const __vue_component__$3 = /* @__PURE__ */ normalizeComponent$2(
    { render: __vue_render__$3, staticRenderFns: __vue_staticRenderFns__$3 },
    __vue_inject_styles__$3,
    __vue_script__$3,
    __vue_scope_id__$3,
    __vue_is_functional_template__$3,
    __vue_module_identifier__$3,
    false,
    void 0,
    void 0,
    void 0
);
var script$4 = {};
const __vue_script__$4 = script$4;
var __vue_render__$4 = function () {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
        "svg",
        {
            staticClass: "svg-inline--fa fa-exclamation-circle fa-w-16",
            attrs: {
                "aria-hidden": "true",
                focusable: "false",
                "data-prefix": "fas",
                "data-icon": "exclamation-circle",
                role: "img",
                xmlns: "http://www.w3.org/2000/svg",
                viewBox: "0 0 512 512",
            },
        },
        [
            _c("path", {
                attrs: {
                    fill: "currentColor",
                    d: "M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z",
                },
            }),
        ]
    );
};
var __vue_staticRenderFns__$4 = [];
__vue_render__$4._withStripped = true;
const __vue_inject_styles__$4 = void 0;
const __vue_scope_id__$4 = void 0;
const __vue_module_identifier__$4 = void 0;
const __vue_is_functional_template__$4 = false;
const __vue_component__$4 = /* @__PURE__ */ normalizeComponent$2(
    { render: __vue_render__$4, staticRenderFns: __vue_staticRenderFns__$4 },
    __vue_inject_styles__$4,
    __vue_script__$4,
    __vue_scope_id__$4,
    __vue_is_functional_template__$4,
    __vue_module_identifier__$4,
    false,
    void 0,
    void 0,
    void 0
);
var script$5 = {};
const __vue_script__$5 = script$5;
var __vue_render__$5 = function () {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
        "svg",
        {
            staticClass: "svg-inline--fa fa-exclamation-triangle fa-w-18",
            attrs: {
                "aria-hidden": "true",
                focusable: "false",
                "data-prefix": "fas",
                "data-icon": "exclamation-triangle",
                role: "img",
                xmlns: "http://www.w3.org/2000/svg",
                viewBox: "0 0 576 512",
            },
        },
        [
            _c("path", {
                attrs: {
                    fill: "currentColor",
                    d: "M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z",
                },
            }),
        ]
    );
};
var __vue_staticRenderFns__$5 = [];
__vue_render__$5._withStripped = true;
const __vue_inject_styles__$5 = void 0;
const __vue_scope_id__$5 = void 0;
const __vue_module_identifier__$5 = void 0;
const __vue_is_functional_template__$5 = false;
const __vue_component__$5 = /* @__PURE__ */ normalizeComponent$2(
    { render: __vue_render__$5, staticRenderFns: __vue_staticRenderFns__$5 },
    __vue_inject_styles__$5,
    __vue_script__$5,
    __vue_scope_id__$5,
    __vue_is_functional_template__$5,
    __vue_module_identifier__$5,
    false,
    void 0,
    void 0,
    void 0
);
var script$6 = Vue.extend({
    props: PROPS.ICON,
    computed: {
        customIconChildren() {
            return hasProp(this.customIcon, "iconChildren")
                ? this.trimValue(this.customIcon.iconChildren)
                : "";
        },
        customIconClass() {
            if (isString$1(this.customIcon)) {
                return this.trimValue(this.customIcon);
            } else if (hasProp(this.customIcon, "iconClass")) {
                return this.trimValue(this.customIcon.iconClass);
            }
            return "";
        },
        customIconTag() {
            if (hasProp(this.customIcon, "iconTag")) {
                return this.trimValue(this.customIcon.iconTag, "i");
            }
            return "i";
        },
        hasCustomIcon() {
            return this.customIconClass.length > 0;
        },
        component() {
            if (this.hasCustomIcon) {
                return this.customIconTag;
            }
            if (isToastContent(this.customIcon)) {
                return getVueComponentFromObj(this.customIcon);
            }
            return this.iconTypeComponent;
        },
        iconTypeComponent() {
            const types = {
                [TYPE.DEFAULT]: __vue_component__$3,
                [TYPE.INFO]: __vue_component__$3,
                [TYPE.SUCCESS]: __vue_component__$2$1,
                [TYPE.ERROR]: __vue_component__$5,
                [TYPE.WARNING]: __vue_component__$4,
            };
            return types[this.type];
        },
        iconClasses() {
            const classes = [`${VT_NAMESPACE}__icon`];
            if (this.hasCustomIcon) {
                return classes.concat(this.customIconClass);
            }
            return classes;
        },
    },
    methods: {
        trimValue(value, empty = "") {
            return isNonEmptyString(value) ? value.trim() : empty;
        },
    },
});
const __vue_script__$6 = script$6;
var __vue_render__$6 = function () {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(_vm.component, { tag: "component", class: _vm.iconClasses }, [
        _vm._v(_vm._s(_vm.customIconChildren)),
    ]);
};
var __vue_staticRenderFns__$6 = [];
__vue_render__$6._withStripped = true;
const __vue_inject_styles__$6 = void 0;
const __vue_scope_id__$6 = void 0;
const __vue_module_identifier__$6 = void 0;
const __vue_is_functional_template__$6 = false;
const __vue_component__$6 = /* @__PURE__ */ normalizeComponent$2(
    { render: __vue_render__$6, staticRenderFns: __vue_staticRenderFns__$6 },
    __vue_inject_styles__$6,
    __vue_script__$6,
    __vue_scope_id__$6,
    __vue_is_functional_template__$6,
    __vue_module_identifier__$6,
    false,
    void 0,
    void 0,
    void 0
);
var script$7 = Vue.extend({
    components: {
        ProgressBar: __vue_component__$2,
        CloseButton: __vue_component__$1$1,
        Icon: __vue_component__$6,
    },
    inheritAttrs: false,
    props: Object.assign({}, PROPS.CORE_TOAST, PROPS.TOAST),
    data() {
        const data3 = {
            isRunning: true,
            disableTransitions: false,
            beingDragged: false,
            dragStart: 0,
            dragPos: { x: 0, y: 0 },
            dragRect: {},
        };
        return data3;
    },
    computed: {
        classes() {
            const classes = [
                `${VT_NAMESPACE}__toast`,
                `${VT_NAMESPACE}__toast--${this.type}`,
                `${this.position}`,
            ].concat(this.toastClassName);
            if (this.disableTransitions) {
                classes.push("disable-transition");
            }
            if (this.rtl) {
                classes.push(`${VT_NAMESPACE}__toast--rtl`);
            }
            return classes;
        },
        bodyClasses() {
            const classes = [
                `${VT_NAMESPACE}__toast-${
                    isString$1(this.content) ? "body" : "component-body"
                }`,
            ].concat(this.bodyClassName);
            return classes;
        },
        draggableStyle() {
            if (this.dragStart === this.dragPos.x) {
                return {};
            }
            if (this.beingDragged) {
                return {
                    transform: `translateX(${this.dragDelta}px)`,
                    opacity:
                        1 - Math.abs(this.dragDelta / this.removalDistance),
                };
            }
            return {
                transition: "transform 0.2s, opacity 0.2s",
                transform: "translateX(0)",
                opacity: 1,
            };
        },
        dragDelta() {
            return this.beingDragged ? this.dragPos.x - this.dragStart : 0;
        },
        removalDistance() {
            if (isDOMRect(this.dragRect)) {
                return (
                    (this.dragRect.right - this.dragRect.left) *
                    this.draggablePercent
                );
            }
            return 0;
        },
    },
    mounted() {
        if (this.draggable) {
            this.draggableSetup();
        }
        if (this.pauseOnFocusLoss) {
            this.focusSetup();
        }
    },
    beforeDestroy() {
        if (this.draggable) {
            this.draggableCleanup();
        }
        if (this.pauseOnFocusLoss) {
            this.focusCleanup();
        }
    },
    destroyed() {
        setTimeout(() => {
            removeElement(this.$el);
        }, 1e3);
    },
    methods: {
        getVueComponentFromObj,
        closeToast() {
            this.eventBus.$emit(EVENTS.DISMISS, this.id);
        },
        clickHandler() {
            if (this.onClick) {
                this.onClick(this.closeToast);
            }
            if (this.closeOnClick) {
                if (!this.beingDragged || this.dragStart === this.dragPos.x) {
                    this.closeToast();
                }
            }
        },
        timeoutHandler() {
            this.closeToast();
        },
        hoverPause() {
            if (this.pauseOnHover) {
                this.isRunning = false;
            }
        },
        hoverPlay() {
            if (this.pauseOnHover) {
                this.isRunning = true;
            }
        },
        focusPause() {
            this.isRunning = false;
        },
        focusPlay() {
            this.isRunning = true;
        },
        focusSetup() {
            addEventListener("blur", this.focusPause);
            addEventListener("focus", this.focusPlay);
        },
        focusCleanup() {
            removeEventListener("blur", this.focusPause);
            removeEventListener("focus", this.focusPlay);
        },
        draggableSetup() {
            const element = this.$el;
            element.addEventListener("touchstart", this.onDragStart, {
                passive: true,
            });
            element.addEventListener("mousedown", this.onDragStart);
            addEventListener("touchmove", this.onDragMove, { passive: false });
            addEventListener("mousemove", this.onDragMove);
            addEventListener("touchend", this.onDragEnd);
            addEventListener("mouseup", this.onDragEnd);
        },
        draggableCleanup() {
            const element = this.$el;
            element.removeEventListener("touchstart", this.onDragStart);
            element.removeEventListener("mousedown", this.onDragStart);
            removeEventListener("touchmove", this.onDragMove);
            removeEventListener("mousemove", this.onDragMove);
            removeEventListener("touchend", this.onDragEnd);
            removeEventListener("mouseup", this.onDragEnd);
        },
        onDragStart(event2) {
            this.beingDragged = true;
            this.dragPos = { x: getX(event2), y: getY(event2) };
            this.dragStart = getX(event2);
            this.dragRect = this.$el.getBoundingClientRect();
        },
        onDragMove(event2) {
            if (this.beingDragged) {
                event2.preventDefault();
                if (this.isRunning) {
                    this.isRunning = false;
                }
                this.dragPos = { x: getX(event2), y: getY(event2) };
            }
        },
        onDragEnd() {
            if (this.beingDragged) {
                if (Math.abs(this.dragDelta) >= this.removalDistance) {
                    this.disableTransitions = true;
                    this.$nextTick(() => this.closeToast());
                } else {
                    setTimeout(() => {
                        this.beingDragged = false;
                        if (
                            isDOMRect(this.dragRect) &&
                            this.pauseOnHover &&
                            this.dragRect.bottom >= this.dragPos.y &&
                            this.dragPos.y >= this.dragRect.top &&
                            this.dragRect.left <= this.dragPos.x &&
                            this.dragPos.x <= this.dragRect.right
                        ) {
                            this.isRunning = false;
                        } else {
                            this.isRunning = true;
                        }
                    });
                }
            }
        },
    },
});
const __vue_script__$7 = script$7;
var __vue_render__$7 = function () {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
        "div",
        {
            class: _vm.classes,
            style: _vm.draggableStyle,
            on: {
                click: _vm.clickHandler,
                mouseenter: _vm.hoverPause,
                mouseleave: _vm.hoverPlay,
            },
        },
        [
            _vm.icon
                ? _c("Icon", {
                      attrs: { "custom-icon": _vm.icon, type: _vm.type },
                  })
                : _vm._e(),
            _vm._v(" "),
            _c(
                "div",
                {
                    class: _vm.bodyClasses,
                    attrs: { role: _vm.accessibility.toastRole || "alert" },
                },
                [
                    typeof _vm.content === "string"
                        ? [_vm._v(_vm._s(_vm.content))]
                        : _c(
                              _vm.getVueComponentFromObj(_vm.content),
                              _vm._g(
                                  _vm._b(
                                      {
                                          tag: "component",
                                          attrs: { "toast-id": _vm.id },
                                          on: { "close-toast": _vm.closeToast },
                                      },
                                      "component",
                                      _vm.content.props,
                                      false
                                  ),
                                  _vm.content.listeners
                              )
                          ),
                ],
                2
            ),
            _vm._v(" "),
            !!_vm.closeButton
                ? _c("CloseButton", {
                      attrs: {
                          component: _vm.closeButton,
                          "class-names": _vm.closeButtonClassName,
                          "show-on-hover": _vm.showCloseButtonOnHover,
                          "aria-label": _vm.accessibility.closeButtonLabel,
                      },
                      on: {
                          click: function ($event) {
                              $event.stopPropagation();
                              return _vm.closeToast($event);
                          },
                      },
                  })
                : _vm._e(),
            _vm._v(" "),
            _vm.timeout
                ? _c("ProgressBar", {
                      attrs: {
                          "is-running": _vm.isRunning,
                          "hide-progress-bar": _vm.hideProgressBar,
                          timeout: _vm.timeout,
                      },
                      on: { "close-toast": _vm.timeoutHandler },
                  })
                : _vm._e(),
        ],
        1
    );
};
var __vue_staticRenderFns__$7 = [];
__vue_render__$7._withStripped = true;
const __vue_inject_styles__$7 = void 0;
const __vue_scope_id__$7 = void 0;
const __vue_module_identifier__$7 = void 0;
const __vue_is_functional_template__$7 = false;
const __vue_component__$7 = /* @__PURE__ */ normalizeComponent$2(
    { render: __vue_render__$7, staticRenderFns: __vue_staticRenderFns__$7 },
    __vue_inject_styles__$7,
    __vue_script__$7,
    __vue_scope_id__$7,
    __vue_is_functional_template__$7,
    __vue_module_identifier__$7,
    false,
    void 0,
    void 0,
    void 0
);
var script$8 = Vue.extend({
    inheritAttrs: false,
    props: PROPS.TRANSITION,
    methods: {
        beforeEnter(el) {
            const enterDuration =
                typeof this.transitionDuration === "number"
                    ? this.transitionDuration
                    : this.transitionDuration.enter;
            el.style.animationDuration = `${enterDuration}ms`;
            el.style.animationFillMode = "both";
            this.$emit("before-enter", el);
        },
        afterEnter(el) {
            this.cleanUpStyles(el);
            this.$emit("after-enter", el);
        },
        afterLeave(el) {
            this.cleanUpStyles(el);
            this.$emit("after-leave", el);
        },
        beforeLeave(el) {
            const leaveDuration =
                typeof this.transitionDuration === "number"
                    ? this.transitionDuration
                    : this.transitionDuration.leave;
            el.style.animationDuration = `${leaveDuration}ms`;
            el.style.animationFillMode = "both";
            this.$emit("before-leave", el);
        },
        leave(el, done) {
            this.setAbsolutePosition(el);
            this.$emit("leave", el, done);
        },
        setAbsolutePosition(el) {
            el.style.left = el.offsetLeft + "px";
            el.style.top = el.offsetTop + "px";
            el.style.width = getComputedStyle(el).width;
            el.style.height = getComputedStyle(el).height;
            el.style.position = "absolute";
        },
        cleanUpStyles(el) {
            el.style.animationFillMode = "";
            el.style.animationDuration = "";
        },
    },
});
const __vue_script__$8 = script$8;
var __vue_render__$8 = function () {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
        "transition-group",
        {
            attrs: {
                tag: "div",
                "enter-active-class": _vm.transition.enter
                    ? _vm.transition.enter
                    : _vm.transition + "-enter-active",
                "move-class": _vm.transition.move
                    ? _vm.transition.move
                    : _vm.transition + "-move",
                "leave-active-class": _vm.transition.leave
                    ? _vm.transition.leave
                    : _vm.transition + "-leave-active",
            },
            on: {
                leave: _vm.leave,
                "before-enter": _vm.beforeEnter,
                "before-leave": _vm.beforeLeave,
                "after-enter": _vm.afterEnter,
                "after-leave": _vm.afterLeave,
            },
        },
        [_vm._t("default")],
        2
    );
};
var __vue_staticRenderFns__$8 = [];
__vue_render__$8._withStripped = true;
const __vue_inject_styles__$8 = void 0;
const __vue_scope_id__$8 = void 0;
const __vue_module_identifier__$8 = void 0;
const __vue_is_functional_template__$8 = false;
const __vue_component__$8 = /* @__PURE__ */ normalizeComponent$2(
    { render: __vue_render__$8, staticRenderFns: __vue_staticRenderFns__$8 },
    __vue_inject_styles__$8,
    __vue_script__$8,
    __vue_scope_id__$8,
    __vue_is_functional_template__$8,
    __vue_module_identifier__$8,
    false,
    void 0,
    void 0,
    void 0
);
var script$9 = Vue.extend({
    components: {
        Toast: __vue_component__$7,
        VtTransition: __vue_component__$8,
    },
    props: Object.assign(
        {},
        PROPS.CORE_TOAST,
        PROPS.CONTAINER,
        PROPS.TRANSITION
    ),
    data() {
        const data3 = {
            count: 0,
            positions: Object.values(POSITION),
            toasts: {},
            defaults: {},
        };
        return data3;
    },
    computed: {
        toastArray() {
            return Object.values(this.toasts);
        },
        filteredToasts() {
            return this.defaults.filterToasts(this.toastArray);
        },
    },
    beforeMount() {
        this.setup(this.container);
        const events2 = this.eventBus;
        events2.$on(EVENTS.ADD, this.addToast);
        events2.$on(EVENTS.CLEAR, this.clearToasts);
        events2.$on(EVENTS.DISMISS, this.dismissToast);
        events2.$on(EVENTS.UPDATE, this.updateToast);
        events2.$on(EVENTS.UPDATE_DEFAULTS, this.updateDefaults);
        this.defaults = this.$props;
    },
    methods: {
        setup(container2) {
            return __awaiter(this, void 0, void 0, function* () {
                if (isFunction$6(container2)) {
                    container2 = yield container2();
                }
                removeElement(this.$el);
                container2.appendChild(this.$el);
            });
        },
        setToast(props2) {
            if (!isUndefined(props2.id)) {
                this.$set(this.toasts, props2.id, props2);
            }
        },
        addToast(params) {
            const props2 = Object.assign(
                {},
                this.defaults,
                params.type &&
                    this.defaults.toastDefaults &&
                    this.defaults.toastDefaults[params.type],
                params
            );
            const toast = this.defaults.filterBeforeCreate(
                props2,
                this.toastArray
            );
            toast && this.setToast(toast);
        },
        dismissToast(id) {
            const toast = this.toasts[id];
            if (!isUndefined(toast) && !isUndefined(toast.onClose)) {
                toast.onClose();
            }
            this.$delete(this.toasts, id);
        },
        clearToasts() {
            Object.keys(this.toasts).forEach((id) => {
                this.dismissToast(id);
            });
        },
        getPositionToasts(position) {
            const toasts = this.filteredToasts
                .filter((toast) => toast.position === position)
                .slice(0, this.defaults.maxToasts);
            return this.defaults.newestOnTop ? toasts.reverse() : toasts;
        },
        updateDefaults(update3) {
            if (!isUndefined(update3.container)) {
                this.setup(update3.container);
            }
            this.defaults = Object.assign({}, this.defaults, update3);
        },
        updateToast({ id, options, create: create2 }) {
            if (this.toasts[id]) {
                if (
                    options.timeout &&
                    options.timeout === this.toasts[id].timeout
                ) {
                    options.timeout++;
                }
                this.setToast(Object.assign({}, this.toasts[id], options));
            } else if (create2) {
                this.addToast(Object.assign({}, { id }, options));
            }
        },
        getClasses(position) {
            const classes = [`${VT_NAMESPACE}__container`, position];
            return classes.concat(this.defaults.containerClassName);
        },
    },
});
const __vue_script__$9 = script$9;
var __vue_render__$9 = function () {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
        "div",
        _vm._l(_vm.positions, function (pos) {
            return _c(
                "div",
                { key: pos },
                [
                    _c(
                        "VtTransition",
                        {
                            class: _vm.getClasses(pos),
                            attrs: {
                                transition: _vm.defaults.transition,
                                "transition-duration":
                                    _vm.defaults.transitionDuration,
                            },
                        },
                        _vm._l(_vm.getPositionToasts(pos), function (toast) {
                            return _c(
                                "Toast",
                                _vm._b({ key: toast.id }, "Toast", toast, false)
                            );
                        }),
                        1
                    ),
                ],
                1
            );
        }),
        0
    );
};
var __vue_staticRenderFns__$9 = [];
__vue_render__$9._withStripped = true;
const __vue_inject_styles__$9 = void 0;
const __vue_scope_id__$9 = void 0;
const __vue_module_identifier__$9 = void 0;
const __vue_is_functional_template__$9 = false;
const __vue_component__$9 = /* @__PURE__ */ normalizeComponent$2(
    { render: __vue_render__$9, staticRenderFns: __vue_staticRenderFns__$9 },
    __vue_inject_styles__$9,
    __vue_script__$9,
    __vue_scope_id__$9,
    __vue_is_functional_template__$9,
    __vue_module_identifier__$9,
    false,
    void 0,
    void 0,
    void 0
);
const ToastInterface = (Vue2, globalOptions = {}, mountContainer = true) => {
    const events2 = (globalOptions.eventBus =
        globalOptions.eventBus || new Vue2());
    if (mountContainer) {
        const containerComponent = new (Vue2.extend(__vue_component__$9))({
            el: document.createElement("div"),
            propsData: globalOptions,
        });
        const onMounted = globalOptions.onMounted;
        if (!isUndefined(onMounted)) {
            onMounted(containerComponent);
        }
    }
    const toast = (content, options) => {
        const props2 = Object.assign(
            {},
            { id: getId(), type: TYPE.DEFAULT },
            options,
            {
                content,
            }
        );
        events2.$emit(EVENTS.ADD, props2);
        return props2.id;
    };
    toast.clear = () => events2.$emit(EVENTS.CLEAR);
    toast.updateDefaults = (update3) => {
        events2.$emit(EVENTS.UPDATE_DEFAULTS, update3);
    };
    toast.dismiss = (id) => {
        events2.$emit(EVENTS.DISMISS, id);
    };
    function updateToast(id, { content, options }, create2 = false) {
        events2.$emit(EVENTS.UPDATE, {
            id,
            options: Object.assign({}, options, { content }),
            create: create2,
        });
    }
    toast.update = updateToast;
    toast.success = (content, options) =>
        toast(content, Object.assign({}, options, { type: TYPE.SUCCESS }));
    toast.info = (content, options) =>
        toast(content, Object.assign({}, options, { type: TYPE.INFO }));
    toast.error = (content, options) =>
        toast(content, Object.assign({}, options, { type: TYPE.ERROR }));
    toast.warning = (content, options) =>
        toast(content, Object.assign({}, options, { type: TYPE.WARNING }));
    return toast;
};
function createToastInterface(optionsOrEventBus, Vue$1 = Vue) {
    const isVueInstance = (obj) => obj instanceof Vue$1;
    if (isVueInstance(optionsOrEventBus)) {
        return ToastInterface(Vue$1, { eventBus: optionsOrEventBus }, false);
    }
    return ToastInterface(Vue$1, optionsOrEventBus, true);
}
const VueToastificationPlugin = (Vue2, options) => {
    const toast = createToastInterface(options, Vue2);
    Vue2.$toast = toast;
    Vue2.prototype.$toast = toast;
};
function _typeof(obj) {
    "@babel/helpers - typeof";
    return (
        (_typeof =
            "function" == typeof Symbol && "symbol" == typeof Symbol.iterator
                ? function (obj2) {
                      return typeof obj2;
                  }
                : function (obj2) {
                      return obj2 &&
                          "function" == typeof Symbol &&
                          obj2.constructor === Symbol &&
                          obj2 !== Symbol.prototype
                          ? "symbol"
                          : typeof obj2;
                  }),
        _typeof(obj)
    );
}
function _defineProperty$1(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value,
            enumerable: true,
            configurable: true,
            writable: true,
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
}
function _defineProperties(target2, props2) {
    for (var i = 0; i < props2.length; i++) {
        var descriptor = props2[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target2, descriptor.key, descriptor);
    }
}
function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);
    if (staticProps) _defineProperties(Constructor, staticProps);
    Object.defineProperty(Constructor, "prototype", {
        writable: false,
    });
    return Constructor;
}
/**!
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 1.16.1
 * @license
 * Copyright (c) Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
var isBrowser$3 =
    typeof window !== "undefined" &&
    typeof document !== "undefined" &&
    typeof navigator !== "undefined";
var timeoutDuration = (function () {
    var longerTimeoutBrowsers = ["Edge", "Trident", "Firefox"];
    for (var i = 0; i < longerTimeoutBrowsers.length; i += 1) {
        if (
            isBrowser$3 &&
            navigator.userAgent.indexOf(longerTimeoutBrowsers[i]) >= 0
        ) {
            return 1;
        }
    }
    return 0;
})();
function microtaskDebounce(fn2) {
    var called = false;
    return function () {
        if (called) {
            return;
        }
        called = true;
        window.Promise.resolve().then(function () {
            called = false;
            fn2();
        });
    };
}
function taskDebounce(fn2) {
    var scheduled = false;
    return function () {
        if (!scheduled) {
            scheduled = true;
            setTimeout(function () {
                scheduled = false;
                fn2();
            }, timeoutDuration);
        }
    };
}
var supportsMicroTasks = isBrowser$3 && window.Promise;
var debounce$1 = supportsMicroTasks ? microtaskDebounce : taskDebounce;
function isFunction$5(functionToCheck) {
    var getType2 = {};
    return (
        functionToCheck &&
        getType2.toString.call(functionToCheck) === "[object Function]"
    );
}
function getStyleComputedProperty(element, property) {
    if (element.nodeType !== 1) {
        return [];
    }
    var window2 = element.ownerDocument.defaultView;
    var css = window2.getComputedStyle(element, null);
    return property ? css[property] : css;
}
function getParentNode(element) {
    if (element.nodeName === "HTML") {
        return element;
    }
    return element.parentNode || element.host;
}
function getScrollParent(element) {
    if (!element) {
        return document.body;
    }
    switch (element.nodeName) {
        case "HTML":
        case "BODY":
            return element.ownerDocument.body;
        case "#document":
            return element.body;
    }
    var _getStyleComputedProp = getStyleComputedProperty(element),
        overflow = _getStyleComputedProp.overflow,
        overflowX = _getStyleComputedProp.overflowX,
        overflowY = _getStyleComputedProp.overflowY;
    if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
        return element;
    }
    return getScrollParent(getParentNode(element));
}
function getReferenceNode(reference) {
    return reference && reference.referenceNode
        ? reference.referenceNode
        : reference;
}
var isIE11$1 =
    isBrowser$3 && !!(window.MSInputMethodContext && document.documentMode);
var isIE10 = isBrowser$3 && /MSIE 10/.test(navigator.userAgent);
function isIE$1(version2) {
    if (version2 === 11) {
        return isIE11$1;
    }
    if (version2 === 10) {
        return isIE10;
    }
    return isIE11$1 || isIE10;
}
function getOffsetParent(element) {
    if (!element) {
        return document.documentElement;
    }
    var noOffsetParent = isIE$1(10) ? document.body : null;
    var offsetParent = element.offsetParent || null;
    while (offsetParent === noOffsetParent && element.nextElementSibling) {
        offsetParent = (element = element.nextElementSibling).offsetParent;
    }
    var nodeName = offsetParent && offsetParent.nodeName;
    if (!nodeName || nodeName === "BODY" || nodeName === "HTML") {
        return element
            ? element.ownerDocument.documentElement
            : document.documentElement;
    }
    if (
        ["TH", "TD", "TABLE"].indexOf(offsetParent.nodeName) !== -1 &&
        getStyleComputedProperty(offsetParent, "position") === "static"
    ) {
        return getOffsetParent(offsetParent);
    }
    return offsetParent;
}
function isOffsetContainer(element) {
    var nodeName = element.nodeName;
    if (nodeName === "BODY") {
        return false;
    }
    return (
        nodeName === "HTML" ||
        getOffsetParent(element.firstElementChild) === element
    );
}
function getRoot(node) {
    if (node.parentNode !== null) {
        return getRoot(node.parentNode);
    }
    return node;
}
function findCommonOffsetParent(element1, element2) {
    if (!element1 || !element1.nodeType || !element2 || !element2.nodeType) {
        return document.documentElement;
    }
    var order =
        element1.compareDocumentPosition(element2) &
        Node.DOCUMENT_POSITION_FOLLOWING;
    var start2 = order ? element1 : element2;
    var end = order ? element2 : element1;
    var range = document.createRange();
    range.setStart(start2, 0);
    range.setEnd(end, 0);
    var commonAncestorContainer = range.commonAncestorContainer;
    if (
        (element1 !== commonAncestorContainer &&
            element2 !== commonAncestorContainer) ||
        start2.contains(end)
    ) {
        if (isOffsetContainer(commonAncestorContainer)) {
            return commonAncestorContainer;
        }
        return getOffsetParent(commonAncestorContainer);
    }
    var element1root = getRoot(element1);
    if (element1root.host) {
        return findCommonOffsetParent(element1root.host, element2);
    } else {
        return findCommonOffsetParent(element1, getRoot(element2).host);
    }
}
function getScroll(element) {
    var side =
        arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : "top";
    var upperSide = side === "top" ? "scrollTop" : "scrollLeft";
    var nodeName = element.nodeName;
    if (nodeName === "BODY" || nodeName === "HTML") {
        var html = element.ownerDocument.documentElement;
        var scrollingElement = element.ownerDocument.scrollingElement || html;
        return scrollingElement[upperSide];
    }
    return element[upperSide];
}
function includeScroll(rect, element) {
    var subtract =
        arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
    var scrollTop = getScroll(element, "top");
    var scrollLeft = getScroll(element, "left");
    var modifier = subtract ? -1 : 1;
    rect.top += scrollTop * modifier;
    rect.bottom += scrollTop * modifier;
    rect.left += scrollLeft * modifier;
    rect.right += scrollLeft * modifier;
    return rect;
}
function getBordersSize(styles2, axis) {
    var sideA = axis === "x" ? "Left" : "Top";
    var sideB = sideA === "Left" ? "Right" : "Bottom";
    return (
        parseFloat(styles2["border" + sideA + "Width"]) +
        parseFloat(styles2["border" + sideB + "Width"])
    );
}
function getSize(axis, body, html, computedStyle) {
    return Math.max(
        body["offset" + axis],
        body["scroll" + axis],
        html["client" + axis],
        html["offset" + axis],
        html["scroll" + axis],
        isIE$1(10)
            ? parseInt(html["offset" + axis]) +
                  parseInt(
                      computedStyle[
                          "margin" + (axis === "Height" ? "Top" : "Left")
                      ]
                  ) +
                  parseInt(
                      computedStyle[
                          "margin" + (axis === "Height" ? "Bottom" : "Right")
                      ]
                  )
            : 0
    );
}
function getWindowSizes(document2) {
    var body = document2.body;
    var html = document2.documentElement;
    var computedStyle = isIE$1(10) && getComputedStyle(html);
    return {
        height: getSize("Height", body, html, computedStyle),
        width: getSize("Width", body, html, computedStyle),
    };
}
var classCallCheck = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
};
var createClass = (function () {
    function defineProperties(target2, props2) {
        for (var i = 0; i < props2.length; i++) {
            var descriptor = props2[i];
            descriptor.enumerable = descriptor.enumerable || false;
            descriptor.configurable = true;
            if ("value" in descriptor) descriptor.writable = true;
            Object.defineProperty(target2, descriptor.key, descriptor);
        }
    }
    return function (Constructor, protoProps, staticProps) {
        if (protoProps) defineProperties(Constructor.prototype, protoProps);
        if (staticProps) defineProperties(Constructor, staticProps);
        return Constructor;
    };
})();
var defineProperty$4 = function (obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value,
            enumerable: true,
            configurable: true,
            writable: true,
        });
    } else {
        obj[key] = value;
    }
    return obj;
};
var _extends =
    Object.assign ||
    function (target2) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];
            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target2[key] = source[key];
                }
            }
        }
        return target2;
    };
function getClientRect(offsets) {
    return _extends({}, offsets, {
        right: offsets.left + offsets.width,
        bottom: offsets.top + offsets.height,
    });
}
function getBoundingClientRect(element) {
    var rect = {};
    try {
        if (isIE$1(10)) {
            rect = element.getBoundingClientRect();
            var scrollTop = getScroll(element, "top");
            var scrollLeft = getScroll(element, "left");
            rect.top += scrollTop;
            rect.left += scrollLeft;
            rect.bottom += scrollTop;
            rect.right += scrollLeft;
        } else {
            rect = element.getBoundingClientRect();
        }
    } catch (e) {}
    var result = {
        left: rect.left,
        top: rect.top,
        width: rect.right - rect.left,
        height: rect.bottom - rect.top,
    };
    var sizes =
        element.nodeName === "HTML"
            ? getWindowSizes(element.ownerDocument)
            : {};
    var width = sizes.width || element.clientWidth || result.width;
    var height = sizes.height || element.clientHeight || result.height;
    var horizScrollbar = element.offsetWidth - width;
    var vertScrollbar = element.offsetHeight - height;
    if (horizScrollbar || vertScrollbar) {
        var styles2 = getStyleComputedProperty(element);
        horizScrollbar -= getBordersSize(styles2, "x");
        vertScrollbar -= getBordersSize(styles2, "y");
        result.width -= horizScrollbar;
        result.height -= vertScrollbar;
    }
    return getClientRect(result);
}
function getOffsetRectRelativeToArbitraryNode(children, parent) {
    var fixedPosition =
        arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : false;
    var isIE102 = isIE$1(10);
    var isHTML = parent.nodeName === "HTML";
    var childrenRect = getBoundingClientRect(children);
    var parentRect = getBoundingClientRect(parent);
    var scrollParent = getScrollParent(children);
    var styles2 = getStyleComputedProperty(parent);
    var borderTopWidth = parseFloat(styles2.borderTopWidth);
    var borderLeftWidth = parseFloat(styles2.borderLeftWidth);
    if (fixedPosition && isHTML) {
        parentRect.top = Math.max(parentRect.top, 0);
        parentRect.left = Math.max(parentRect.left, 0);
    }
    var offsets = getClientRect({
        top: childrenRect.top - parentRect.top - borderTopWidth,
        left: childrenRect.left - parentRect.left - borderLeftWidth,
        width: childrenRect.width,
        height: childrenRect.height,
    });
    offsets.marginTop = 0;
    offsets.marginLeft = 0;
    if (!isIE102 && isHTML) {
        var marginTop = parseFloat(styles2.marginTop);
        var marginLeft = parseFloat(styles2.marginLeft);
        offsets.top -= borderTopWidth - marginTop;
        offsets.bottom -= borderTopWidth - marginTop;
        offsets.left -= borderLeftWidth - marginLeft;
        offsets.right -= borderLeftWidth - marginLeft;
        offsets.marginTop = marginTop;
        offsets.marginLeft = marginLeft;
    }
    if (
        isIE102 && !fixedPosition
            ? parent.contains(scrollParent)
            : parent === scrollParent && scrollParent.nodeName !== "BODY"
    ) {
        offsets = includeScroll(offsets, parent);
    }
    return offsets;
}
function getViewportOffsetRectRelativeToArtbitraryNode(element) {
    var excludeScroll =
        arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
    var html = element.ownerDocument.documentElement;
    var relativeOffset = getOffsetRectRelativeToArbitraryNode(element, html);
    var width = Math.max(html.clientWidth, window.innerWidth || 0);
    var height = Math.max(html.clientHeight, window.innerHeight || 0);
    var scrollTop = !excludeScroll ? getScroll(html) : 0;
    var scrollLeft = !excludeScroll ? getScroll(html, "left") : 0;
    var offset2 = {
        top: scrollTop - relativeOffset.top + relativeOffset.marginTop,
        left: scrollLeft - relativeOffset.left + relativeOffset.marginLeft,
        width,
        height,
    };
    return getClientRect(offset2);
}
function isFixed(element) {
    var nodeName = element.nodeName;
    if (nodeName === "BODY" || nodeName === "HTML") {
        return false;
    }
    if (getStyleComputedProperty(element, "position") === "fixed") {
        return true;
    }
    var parentNode2 = getParentNode(element);
    if (!parentNode2) {
        return false;
    }
    return isFixed(parentNode2);
}
function getFixedPositionOffsetParent(element) {
    if (!element || !element.parentElement || isIE$1()) {
        return document.documentElement;
    }
    var el = element.parentElement;
    while (el && getStyleComputedProperty(el, "transform") === "none") {
        el = el.parentElement;
    }
    return el || document.documentElement;
}
function getBoundaries(popper, reference, padding, boundariesElement) {
    var fixedPosition =
        arguments.length > 4 && arguments[4] !== void 0 ? arguments[4] : false;
    var boundaries = { top: 0, left: 0 };
    var offsetParent = fixedPosition
        ? getFixedPositionOffsetParent(popper)
        : findCommonOffsetParent(popper, getReferenceNode(reference));
    if (boundariesElement === "viewport") {
        boundaries = getViewportOffsetRectRelativeToArtbitraryNode(
            offsetParent,
            fixedPosition
        );
    } else {
        var boundariesNode = void 0;
        if (boundariesElement === "scrollParent") {
            boundariesNode = getScrollParent(getParentNode(reference));
            if (boundariesNode.nodeName === "BODY") {
                boundariesNode = popper.ownerDocument.documentElement;
            }
        } else if (boundariesElement === "window") {
            boundariesNode = popper.ownerDocument.documentElement;
        } else {
            boundariesNode = boundariesElement;
        }
        var offsets = getOffsetRectRelativeToArbitraryNode(
            boundariesNode,
            offsetParent,
            fixedPosition
        );
        if (boundariesNode.nodeName === "HTML" && !isFixed(offsetParent)) {
            var _getWindowSizes = getWindowSizes(popper.ownerDocument),
                height = _getWindowSizes.height,
                width = _getWindowSizes.width;
            boundaries.top += offsets.top - offsets.marginTop;
            boundaries.bottom = height + offsets.top;
            boundaries.left += offsets.left - offsets.marginLeft;
            boundaries.right = width + offsets.left;
        } else {
            boundaries = offsets;
        }
    }
    padding = padding || 0;
    var isPaddingNumber = typeof padding === "number";
    boundaries.left += isPaddingNumber ? padding : padding.left || 0;
    boundaries.top += isPaddingNumber ? padding : padding.top || 0;
    boundaries.right -= isPaddingNumber ? padding : padding.right || 0;
    boundaries.bottom -= isPaddingNumber ? padding : padding.bottom || 0;
    return boundaries;
}
function getArea(_ref) {
    var width = _ref.width,
        height = _ref.height;
    return width * height;
}
function computeAutoPlacement(
    placement2,
    refRect,
    popper,
    reference,
    boundariesElement
) {
    var padding =
        arguments.length > 5 && arguments[5] !== void 0 ? arguments[5] : 0;
    if (placement2.indexOf("auto") === -1) {
        return placement2;
    }
    var boundaries = getBoundaries(
        popper,
        reference,
        padding,
        boundariesElement
    );
    var rects = {
        top: {
            width: boundaries.width,
            height: refRect.top - boundaries.top,
        },
        right: {
            width: boundaries.right - refRect.right,
            height: boundaries.height,
        },
        bottom: {
            width: boundaries.width,
            height: boundaries.bottom - refRect.bottom,
        },
        left: {
            width: refRect.left - boundaries.left,
            height: boundaries.height,
        },
    };
    var sortedAreas = Object.keys(rects)
        .map(function (key) {
            return _extends(
                {
                    key,
                },
                rects[key],
                {
                    area: getArea(rects[key]),
                }
            );
        })
        .sort(function (a, b) {
            return b.area - a.area;
        });
    var filteredAreas = sortedAreas.filter(function (_ref2) {
        var width = _ref2.width,
            height = _ref2.height;
        return width >= popper.clientWidth && height >= popper.clientHeight;
    });
    var computedPlacement =
        filteredAreas.length > 0 ? filteredAreas[0].key : sortedAreas[0].key;
    var variation = placement2.split("-")[1];
    return computedPlacement + (variation ? "-" + variation : "");
}
function getReferenceOffsets(state2, popper, reference) {
    var fixedPosition =
        arguments.length > 3 && arguments[3] !== void 0 ? arguments[3] : null;
    var commonOffsetParent = fixedPosition
        ? getFixedPositionOffsetParent(popper)
        : findCommonOffsetParent(popper, getReferenceNode(reference));
    return getOffsetRectRelativeToArbitraryNode(
        reference,
        commonOffsetParent,
        fixedPosition
    );
}
function getOuterSizes(element) {
    var window2 = element.ownerDocument.defaultView;
    var styles2 = window2.getComputedStyle(element);
    var x =
        parseFloat(styles2.marginTop || 0) +
        parseFloat(styles2.marginBottom || 0);
    var y =
        parseFloat(styles2.marginLeft || 0) +
        parseFloat(styles2.marginRight || 0);
    var result = {
        width: element.offsetWidth + y,
        height: element.offsetHeight + x,
    };
    return result;
}
function getOppositePlacement(placement2) {
    var hash = { left: "right", right: "left", bottom: "top", top: "bottom" };
    return placement2.replace(/left|right|bottom|top/g, function (matched) {
        return hash[matched];
    });
}
function getPopperOffsets(popper, referenceOffsets, placement2) {
    placement2 = placement2.split("-")[0];
    var popperRect = getOuterSizes(popper);
    var popperOffsets = {
        width: popperRect.width,
        height: popperRect.height,
    };
    var isHoriz = ["right", "left"].indexOf(placement2) !== -1;
    var mainSide = isHoriz ? "top" : "left";
    var secondarySide = isHoriz ? "left" : "top";
    var measurement = isHoriz ? "height" : "width";
    var secondaryMeasurement = !isHoriz ? "height" : "width";
    popperOffsets[mainSide] =
        referenceOffsets[mainSide] +
        referenceOffsets[measurement] / 2 -
        popperRect[measurement] / 2;
    if (placement2 === secondarySide) {
        popperOffsets[secondarySide] =
            referenceOffsets[secondarySide] - popperRect[secondaryMeasurement];
    } else {
        popperOffsets[secondarySide] =
            referenceOffsets[getOppositePlacement(secondarySide)];
    }
    return popperOffsets;
}
function find$1(arr, check) {
    if (Array.prototype.find) {
        return arr.find(check);
    }
    return arr.filter(check)[0];
}
function findIndex(arr, prop, value) {
    if (Array.prototype.findIndex) {
        return arr.findIndex(function (cur) {
            return cur[prop] === value;
        });
    }
    var match = find$1(arr, function (obj) {
        return obj[prop] === value;
    });
    return arr.indexOf(match);
}
function runModifiers(modifiers2, data3, ends) {
    var modifiersToRun =
        ends === void 0
            ? modifiers2
            : modifiers2.slice(0, findIndex(modifiers2, "name", ends));
    modifiersToRun.forEach(function (modifier) {
        if (modifier["function"]) {
            console.warn(
                "`modifier.function` is deprecated, use `modifier.fn`!"
            );
        }
        var fn2 = modifier["function"] || modifier.fn;
        if (modifier.enabled && isFunction$5(fn2)) {
            data3.offsets.popper = getClientRect(data3.offsets.popper);
            data3.offsets.reference = getClientRect(data3.offsets.reference);
            data3 = fn2(data3, modifier);
        }
    });
    return data3;
}
function update() {
    if (this.state.isDestroyed) {
        return;
    }
    var data3 = {
        instance: this,
        styles: {},
        arrowStyles: {},
        attributes: {},
        flipped: false,
        offsets: {},
    };
    data3.offsets.reference = getReferenceOffsets(
        this.state,
        this.popper,
        this.reference,
        this.options.positionFixed
    );
    data3.placement = computeAutoPlacement(
        this.options.placement,
        data3.offsets.reference,
        this.popper,
        this.reference,
        this.options.modifiers.flip.boundariesElement,
        this.options.modifiers.flip.padding
    );
    data3.originalPlacement = data3.placement;
    data3.positionFixed = this.options.positionFixed;
    data3.offsets.popper = getPopperOffsets(
        this.popper,
        data3.offsets.reference,
        data3.placement
    );
    data3.offsets.popper.position = this.options.positionFixed
        ? "fixed"
        : "absolute";
    data3 = runModifiers(this.modifiers, data3);
    if (!this.state.isCreated) {
        this.state.isCreated = true;
        this.options.onCreate(data3);
    } else {
        this.options.onUpdate(data3);
    }
}
function isModifierEnabled(modifiers2, modifierName) {
    return modifiers2.some(function (_ref) {
        var name2 = _ref.name,
            enabled = _ref.enabled;
        return enabled && name2 === modifierName;
    });
}
function getSupportedPropertyName(property) {
    var prefixes = [false, "ms", "Webkit", "Moz", "O"];
    var upperProp = property.charAt(0).toUpperCase() + property.slice(1);
    for (var i = 0; i < prefixes.length; i++) {
        var prefix2 = prefixes[i];
        var toCheck = prefix2 ? "" + prefix2 + upperProp : property;
        if (typeof document.body.style[toCheck] !== "undefined") {
            return toCheck;
        }
    }
    return null;
}
function destroy$1() {
    this.state.isDestroyed = true;
    if (isModifierEnabled(this.modifiers, "applyStyle")) {
        this.popper.removeAttribute("x-placement");
        this.popper.style.position = "";
        this.popper.style.top = "";
        this.popper.style.left = "";
        this.popper.style.right = "";
        this.popper.style.bottom = "";
        this.popper.style.willChange = "";
        this.popper.style[getSupportedPropertyName("transform")] = "";
    }
    this.disableEventListeners();
    if (this.options.removeOnDestroy) {
        this.popper.parentNode.removeChild(this.popper);
    }
    return this;
}
function getWindow(element) {
    var ownerDocument = element.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView : window;
}
function attachToScrollParents(scrollParent, event2, callback, scrollParents) {
    var isBody = scrollParent.nodeName === "BODY";
    var target2 = isBody
        ? scrollParent.ownerDocument.defaultView
        : scrollParent;
    target2.addEventListener(event2, callback, { passive: true });
    if (!isBody) {
        attachToScrollParents(
            getScrollParent(target2.parentNode),
            event2,
            callback,
            scrollParents
        );
    }
    scrollParents.push(target2);
}
function setupEventListeners(reference, options, state2, updateBound) {
    state2.updateBound = updateBound;
    getWindow(reference).addEventListener("resize", state2.updateBound, {
        passive: true,
    });
    var scrollElement = getScrollParent(reference);
    attachToScrollParents(
        scrollElement,
        "scroll",
        state2.updateBound,
        state2.scrollParents
    );
    state2.scrollElement = scrollElement;
    state2.eventsEnabled = true;
    return state2;
}
function enableEventListeners() {
    if (!this.state.eventsEnabled) {
        this.state = setupEventListeners(
            this.reference,
            this.options,
            this.state,
            this.scheduleUpdate
        );
    }
}
function removeEventListeners(reference, state2) {
    getWindow(reference).removeEventListener("resize", state2.updateBound);
    state2.scrollParents.forEach(function (target2) {
        target2.removeEventListener("scroll", state2.updateBound);
    });
    state2.updateBound = null;
    state2.scrollParents = [];
    state2.scrollElement = null;
    state2.eventsEnabled = false;
    return state2;
}
function disableEventListeners() {
    if (this.state.eventsEnabled) {
        cancelAnimationFrame(this.scheduleUpdate);
        this.state = removeEventListeners(this.reference, this.state);
    }
}
function isNumeric(n) {
    return n !== "" && !isNaN(parseFloat(n)) && isFinite(n);
}
function setStyles(element, styles2) {
    Object.keys(styles2).forEach(function (prop) {
        var unit = "";
        if (
            ["width", "height", "top", "right", "bottom", "left"].indexOf(
                prop
            ) !== -1 &&
            isNumeric(styles2[prop])
        ) {
            unit = "px";
        }
        element.style[prop] = styles2[prop] + unit;
    });
}
function setAttributes$1(element, attributes) {
    Object.keys(attributes).forEach(function (prop) {
        var value = attributes[prop];
        if (value !== false) {
            element.setAttribute(prop, attributes[prop]);
        } else {
            element.removeAttribute(prop);
        }
    });
}
function applyStyle(data3) {
    setStyles(data3.instance.popper, data3.styles);
    setAttributes$1(data3.instance.popper, data3.attributes);
    if (data3.arrowElement && Object.keys(data3.arrowStyles).length) {
        setStyles(data3.arrowElement, data3.arrowStyles);
    }
    return data3;
}
function applyStyleOnLoad(reference, popper, options, modifierOptions, state2) {
    var referenceOffsets = getReferenceOffsets(
        state2,
        popper,
        reference,
        options.positionFixed
    );
    var placement2 = computeAutoPlacement(
        options.placement,
        referenceOffsets,
        popper,
        reference,
        options.modifiers.flip.boundariesElement,
        options.modifiers.flip.padding
    );
    popper.setAttribute("x-placement", placement2);
    setStyles(popper, {
        position: options.positionFixed ? "fixed" : "absolute",
    });
    return options;
}
function getRoundedOffsets(data3, shouldRound) {
    var _data$offsets = data3.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var round = Math.round,
        floor = Math.floor;
    var noRound = function noRound2(v) {
        return v;
    };
    var referenceWidth = round(reference.width);
    var popperWidth = round(popper.width);
    var isVertical = ["left", "right"].indexOf(data3.placement) !== -1;
    var isVariation = data3.placement.indexOf("-") !== -1;
    var sameWidthParity = referenceWidth % 2 === popperWidth % 2;
    var bothOddWidth = referenceWidth % 2 === 1 && popperWidth % 2 === 1;
    var horizontalToInteger = !shouldRound
        ? noRound
        : isVertical || isVariation || sameWidthParity
        ? round
        : floor;
    var verticalToInteger = !shouldRound ? noRound : round;
    return {
        left: horizontalToInteger(
            bothOddWidth && !isVariation && shouldRound
                ? popper.left - 1
                : popper.left
        ),
        top: verticalToInteger(popper.top),
        bottom: verticalToInteger(popper.bottom),
        right: horizontalToInteger(popper.right),
    };
}
var isFirefox = isBrowser$3 && /Firefox/i.test(navigator.userAgent);
function computeStyle(data3, options) {
    var x = options.x,
        y = options.y;
    var popper = data3.offsets.popper;
    var legacyGpuAccelerationOption = find$1(
        data3.instance.modifiers,
        function (modifier) {
            return modifier.name === "applyStyle";
        }
    ).gpuAcceleration;
    if (legacyGpuAccelerationOption !== void 0) {
        console.warn(
            "WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!"
        );
    }
    var gpuAcceleration =
        legacyGpuAccelerationOption !== void 0
            ? legacyGpuAccelerationOption
            : options.gpuAcceleration;
    var offsetParent = getOffsetParent(data3.instance.popper);
    var offsetParentRect = getBoundingClientRect(offsetParent);
    var styles2 = {
        position: popper.position,
    };
    var offsets = getRoundedOffsets(
        data3,
        window.devicePixelRatio < 2 || !isFirefox
    );
    var sideA = x === "bottom" ? "top" : "bottom";
    var sideB = y === "right" ? "left" : "right";
    var prefixedProperty = getSupportedPropertyName("transform");
    var left = void 0,
        top = void 0;
    if (sideA === "bottom") {
        if (offsetParent.nodeName === "HTML") {
            top = -offsetParent.clientHeight + offsets.bottom;
        } else {
            top = -offsetParentRect.height + offsets.bottom;
        }
    } else {
        top = offsets.top;
    }
    if (sideB === "right") {
        if (offsetParent.nodeName === "HTML") {
            left = -offsetParent.clientWidth + offsets.right;
        } else {
            left = -offsetParentRect.width + offsets.right;
        }
    } else {
        left = offsets.left;
    }
    if (gpuAcceleration && prefixedProperty) {
        styles2[prefixedProperty] =
            "translate3d(" + left + "px, " + top + "px, 0)";
        styles2[sideA] = 0;
        styles2[sideB] = 0;
        styles2.willChange = "transform";
    } else {
        var invertTop = sideA === "bottom" ? -1 : 1;
        var invertLeft = sideB === "right" ? -1 : 1;
        styles2[sideA] = top * invertTop;
        styles2[sideB] = left * invertLeft;
        styles2.willChange = sideA + ", " + sideB;
    }
    var attributes = {
        "x-placement": data3.placement,
    };
    data3.attributes = _extends({}, attributes, data3.attributes);
    data3.styles = _extends({}, styles2, data3.styles);
    data3.arrowStyles = _extends({}, data3.offsets.arrow, data3.arrowStyles);
    return data3;
}
function isModifierRequired(modifiers2, requestingName, requestedName) {
    var requesting = find$1(modifiers2, function (_ref) {
        var name2 = _ref.name;
        return name2 === requestingName;
    });
    var isRequired =
        !!requesting &&
        modifiers2.some(function (modifier) {
            return (
                modifier.name === requestedName &&
                modifier.enabled &&
                modifier.order < requesting.order
            );
        });
    if (!isRequired) {
        var _requesting = "`" + requestingName + "`";
        var requested = "`" + requestedName + "`";
        console.warn(
            requested +
                " modifier is required by " +
                _requesting +
                " modifier in order to work, be sure to include it before " +
                _requesting +
                "!"
        );
    }
    return isRequired;
}
function arrow(data3, options) {
    var _data$offsets$arrow;
    if (
        !isModifierRequired(data3.instance.modifiers, "arrow", "keepTogether")
    ) {
        return data3;
    }
    var arrowElement = options.element;
    if (typeof arrowElement === "string") {
        arrowElement = data3.instance.popper.querySelector(arrowElement);
        if (!arrowElement) {
            return data3;
        }
    } else {
        if (!data3.instance.popper.contains(arrowElement)) {
            console.warn(
                "WARNING: `arrow.element` must be child of its popper element!"
            );
            return data3;
        }
    }
    var placement2 = data3.placement.split("-")[0];
    var _data$offsets = data3.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var isVertical = ["left", "right"].indexOf(placement2) !== -1;
    var len = isVertical ? "height" : "width";
    var sideCapitalized = isVertical ? "Top" : "Left";
    var side = sideCapitalized.toLowerCase();
    var altSide = isVertical ? "left" : "top";
    var opSide = isVertical ? "bottom" : "right";
    var arrowElementSize = getOuterSizes(arrowElement)[len];
    if (reference[opSide] - arrowElementSize < popper[side]) {
        data3.offsets.popper[side] -=
            popper[side] - (reference[opSide] - arrowElementSize);
    }
    if (reference[side] + arrowElementSize > popper[opSide]) {
        data3.offsets.popper[side] +=
            reference[side] + arrowElementSize - popper[opSide];
    }
    data3.offsets.popper = getClientRect(data3.offsets.popper);
    var center = reference[side] + reference[len] / 2 - arrowElementSize / 2;
    var css = getStyleComputedProperty(data3.instance.popper);
    var popperMarginSide = parseFloat(css["margin" + sideCapitalized]);
    var popperBorderSide = parseFloat(
        css["border" + sideCapitalized + "Width"]
    );
    var sideValue =
        center -
        data3.offsets.popper[side] -
        popperMarginSide -
        popperBorderSide;
    sideValue = Math.max(
        Math.min(popper[len] - arrowElementSize, sideValue),
        0
    );
    data3.arrowElement = arrowElement;
    data3.offsets.arrow =
        ((_data$offsets$arrow = {}),
        defineProperty$4(_data$offsets$arrow, side, Math.round(sideValue)),
        defineProperty$4(_data$offsets$arrow, altSide, ""),
        _data$offsets$arrow);
    return data3;
}
function getOppositeVariation(variation) {
    if (variation === "end") {
        return "start";
    } else if (variation === "start") {
        return "end";
    }
    return variation;
}
var placements = [
    "auto-start",
    "auto",
    "auto-end",
    "top-start",
    "top",
    "top-end",
    "right-start",
    "right",
    "right-end",
    "bottom-end",
    "bottom",
    "bottom-start",
    "left-end",
    "left",
    "left-start",
];
var validPlacements = placements.slice(3);
function clockwise(placement2) {
    var counter =
        arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
    var index2 = validPlacements.indexOf(placement2);
    var arr = validPlacements
        .slice(index2 + 1)
        .concat(validPlacements.slice(0, index2));
    return counter ? arr.reverse() : arr;
}
var BEHAVIORS = {
    FLIP: "flip",
    CLOCKWISE: "clockwise",
    COUNTERCLOCKWISE: "counterclockwise",
};
function flip(data3, options) {
    if (isModifierEnabled(data3.instance.modifiers, "inner")) {
        return data3;
    }
    if (data3.flipped && data3.placement === data3.originalPlacement) {
        return data3;
    }
    var boundaries = getBoundaries(
        data3.instance.popper,
        data3.instance.reference,
        options.padding,
        options.boundariesElement,
        data3.positionFixed
    );
    var placement2 = data3.placement.split("-")[0];
    var placementOpposite = getOppositePlacement(placement2);
    var variation = data3.placement.split("-")[1] || "";
    var flipOrder = [];
    switch (options.behavior) {
        case BEHAVIORS.FLIP:
            flipOrder = [placement2, placementOpposite];
            break;
        case BEHAVIORS.CLOCKWISE:
            flipOrder = clockwise(placement2);
            break;
        case BEHAVIORS.COUNTERCLOCKWISE:
            flipOrder = clockwise(placement2, true);
            break;
        default:
            flipOrder = options.behavior;
    }
    flipOrder.forEach(function (step, index2) {
        if (placement2 !== step || flipOrder.length === index2 + 1) {
            return data3;
        }
        placement2 = data3.placement.split("-")[0];
        placementOpposite = getOppositePlacement(placement2);
        var popperOffsets = data3.offsets.popper;
        var refOffsets = data3.offsets.reference;
        var floor = Math.floor;
        var overlapsRef =
            (placement2 === "left" &&
                floor(popperOffsets.right) > floor(refOffsets.left)) ||
            (placement2 === "right" &&
                floor(popperOffsets.left) < floor(refOffsets.right)) ||
            (placement2 === "top" &&
                floor(popperOffsets.bottom) > floor(refOffsets.top)) ||
            (placement2 === "bottom" &&
                floor(popperOffsets.top) < floor(refOffsets.bottom));
        var overflowsLeft = floor(popperOffsets.left) < floor(boundaries.left);
        var overflowsRight =
            floor(popperOffsets.right) > floor(boundaries.right);
        var overflowsTop = floor(popperOffsets.top) < floor(boundaries.top);
        var overflowsBottom =
            floor(popperOffsets.bottom) > floor(boundaries.bottom);
        var overflowsBoundaries =
            (placement2 === "left" && overflowsLeft) ||
            (placement2 === "right" && overflowsRight) ||
            (placement2 === "top" && overflowsTop) ||
            (placement2 === "bottom" && overflowsBottom);
        var isVertical = ["top", "bottom"].indexOf(placement2) !== -1;
        var flippedVariationByRef =
            !!options.flipVariations &&
            ((isVertical && variation === "start" && overflowsLeft) ||
                (isVertical && variation === "end" && overflowsRight) ||
                (!isVertical && variation === "start" && overflowsTop) ||
                (!isVertical && variation === "end" && overflowsBottom));
        var flippedVariationByContent =
            !!options.flipVariationsByContent &&
            ((isVertical && variation === "start" && overflowsRight) ||
                (isVertical && variation === "end" && overflowsLeft) ||
                (!isVertical && variation === "start" && overflowsBottom) ||
                (!isVertical && variation === "end" && overflowsTop));
        var flippedVariation =
            flippedVariationByRef || flippedVariationByContent;
        if (overlapsRef || overflowsBoundaries || flippedVariation) {
            data3.flipped = true;
            if (overlapsRef || overflowsBoundaries) {
                placement2 = flipOrder[index2 + 1];
            }
            if (flippedVariation) {
                variation = getOppositeVariation(variation);
            }
            data3.placement = placement2 + (variation ? "-" + variation : "");
            data3.offsets.popper = _extends(
                {},
                data3.offsets.popper,
                getPopperOffsets(
                    data3.instance.popper,
                    data3.offsets.reference,
                    data3.placement
                )
            );
            data3 = runModifiers(data3.instance.modifiers, data3, "flip");
        }
    });
    return data3;
}
function keepTogether(data3) {
    var _data$offsets = data3.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var placement2 = data3.placement.split("-")[0];
    var floor = Math.floor;
    var isVertical = ["top", "bottom"].indexOf(placement2) !== -1;
    var side = isVertical ? "right" : "bottom";
    var opSide = isVertical ? "left" : "top";
    var measurement = isVertical ? "width" : "height";
    if (popper[side] < floor(reference[opSide])) {
        data3.offsets.popper[opSide] =
            floor(reference[opSide]) - popper[measurement];
    }
    if (popper[opSide] > floor(reference[side])) {
        data3.offsets.popper[opSide] = floor(reference[side]);
    }
    return data3;
}
function toValue(str, measurement, popperOffsets, referenceOffsets) {
    var split = str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);
    var value = +split[1];
    var unit = split[2];
    if (!value) {
        return str;
    }
    if (unit.indexOf("%") === 0) {
        var element = void 0;
        switch (unit) {
            case "%p":
                element = popperOffsets;
                break;
            case "%":
            case "%r":
            default:
                element = referenceOffsets;
        }
        var rect = getClientRect(element);
        return (rect[measurement] / 100) * value;
    } else if (unit === "vh" || unit === "vw") {
        var size2 = void 0;
        if (unit === "vh") {
            size2 = Math.max(
                document.documentElement.clientHeight,
                window.innerHeight || 0
            );
        } else {
            size2 = Math.max(
                document.documentElement.clientWidth,
                window.innerWidth || 0
            );
        }
        return (size2 / 100) * value;
    } else {
        return value;
    }
}
function parseOffset(offset2, popperOffsets, referenceOffsets, basePlacement) {
    var offsets = [0, 0];
    var useHeight = ["right", "left"].indexOf(basePlacement) !== -1;
    var fragments = offset2.split(/(\+|\-)/).map(function (frag) {
        return frag.trim();
    });
    var divider = fragments.indexOf(
        find$1(fragments, function (frag) {
            return frag.search(/,|\s/) !== -1;
        })
    );
    if (fragments[divider] && fragments[divider].indexOf(",") === -1) {
        console.warn(
            "Offsets separated by white space(s) are deprecated, use a comma (,) instead."
        );
    }
    var splitRegex = /\s*,\s*|\s+/;
    var ops =
        divider !== -1
            ? [
                  fragments
                      .slice(0, divider)
                      .concat([fragments[divider].split(splitRegex)[0]]),
                  [fragments[divider].split(splitRegex)[1]].concat(
                      fragments.slice(divider + 1)
                  ),
              ]
            : [fragments];
    ops = ops.map(function (op, index2) {
        var measurement = (index2 === 1 ? !useHeight : useHeight)
            ? "height"
            : "width";
        var mergeWithPrevious = false;
        return op
            .reduce(function (a, b) {
                if (a[a.length - 1] === "" && ["+", "-"].indexOf(b) !== -1) {
                    a[a.length - 1] = b;
                    mergeWithPrevious = true;
                    return a;
                } else if (mergeWithPrevious) {
                    a[a.length - 1] += b;
                    mergeWithPrevious = false;
                    return a;
                } else {
                    return a.concat(b);
                }
            }, [])
            .map(function (str) {
                return toValue(
                    str,
                    measurement,
                    popperOffsets,
                    referenceOffsets
                );
            });
    });
    ops.forEach(function (op, index2) {
        op.forEach(function (frag, index22) {
            if (isNumeric(frag)) {
                offsets[index2] += frag * (op[index22 - 1] === "-" ? -1 : 1);
            }
        });
    });
    return offsets;
}
function offset(data3, _ref) {
    var offset2 = _ref.offset;
    var placement2 = data3.placement,
        _data$offsets = data3.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var basePlacement = placement2.split("-")[0];
    var offsets = void 0;
    if (isNumeric(+offset2)) {
        offsets = [+offset2, 0];
    } else {
        offsets = parseOffset(offset2, popper, reference, basePlacement);
    }
    if (basePlacement === "left") {
        popper.top += offsets[0];
        popper.left -= offsets[1];
    } else if (basePlacement === "right") {
        popper.top += offsets[0];
        popper.left += offsets[1];
    } else if (basePlacement === "top") {
        popper.left += offsets[0];
        popper.top -= offsets[1];
    } else if (basePlacement === "bottom") {
        popper.left += offsets[0];
        popper.top += offsets[1];
    }
    data3.popper = popper;
    return data3;
}
function preventOverflow(data3, options) {
    var boundariesElement =
        options.boundariesElement || getOffsetParent(data3.instance.popper);
    if (data3.instance.reference === boundariesElement) {
        boundariesElement = getOffsetParent(boundariesElement);
    }
    var transformProp = getSupportedPropertyName("transform");
    var popperStyles = data3.instance.popper.style;
    var top = popperStyles.top,
        left = popperStyles.left,
        transform = popperStyles[transformProp];
    popperStyles.top = "";
    popperStyles.left = "";
    popperStyles[transformProp] = "";
    var boundaries = getBoundaries(
        data3.instance.popper,
        data3.instance.reference,
        options.padding,
        boundariesElement,
        data3.positionFixed
    );
    popperStyles.top = top;
    popperStyles.left = left;
    popperStyles[transformProp] = transform;
    options.boundaries = boundaries;
    var order = options.priority;
    var popper = data3.offsets.popper;
    var check = {
        primary: function primary(placement2) {
            var value = popper[placement2];
            if (
                popper[placement2] < boundaries[placement2] &&
                !options.escapeWithReference
            ) {
                value = Math.max(popper[placement2], boundaries[placement2]);
            }
            return defineProperty$4({}, placement2, value);
        },
        secondary: function secondary(placement2) {
            var mainSide = placement2 === "right" ? "left" : "top";
            var value = popper[mainSide];
            if (
                popper[placement2] > boundaries[placement2] &&
                !options.escapeWithReference
            ) {
                value = Math.min(
                    popper[mainSide],
                    boundaries[placement2] -
                        (placement2 === "right" ? popper.width : popper.height)
                );
            }
            return defineProperty$4({}, mainSide, value);
        },
    };
    order.forEach(function (placement2) {
        var side =
            ["left", "top"].indexOf(placement2) !== -1
                ? "primary"
                : "secondary";
        popper = _extends({}, popper, check[side](placement2));
    });
    data3.offsets.popper = popper;
    return data3;
}
function shift(data3) {
    var placement2 = data3.placement;
    var basePlacement = placement2.split("-")[0];
    var shiftvariation = placement2.split("-")[1];
    if (shiftvariation) {
        var _data$offsets = data3.offsets,
            reference = _data$offsets.reference,
            popper = _data$offsets.popper;
        var isVertical = ["bottom", "top"].indexOf(basePlacement) !== -1;
        var side = isVertical ? "left" : "top";
        var measurement = isVertical ? "width" : "height";
        var shiftOffsets = {
            start: defineProperty$4({}, side, reference[side]),
            end: defineProperty$4(
                {},
                side,
                reference[side] + reference[measurement] - popper[measurement]
            ),
        };
        data3.offsets.popper = _extends(
            {},
            popper,
            shiftOffsets[shiftvariation]
        );
    }
    return data3;
}
function hide(data3) {
    if (
        !isModifierRequired(data3.instance.modifiers, "hide", "preventOverflow")
    ) {
        return data3;
    }
    var refRect = data3.offsets.reference;
    var bound = find$1(data3.instance.modifiers, function (modifier) {
        return modifier.name === "preventOverflow";
    }).boundaries;
    if (
        refRect.bottom < bound.top ||
        refRect.left > bound.right ||
        refRect.top > bound.bottom ||
        refRect.right < bound.left
    ) {
        if (data3.hide === true) {
            return data3;
        }
        data3.hide = true;
        data3.attributes["x-out-of-boundaries"] = "";
    } else {
        if (data3.hide === false) {
            return data3;
        }
        data3.hide = false;
        data3.attributes["x-out-of-boundaries"] = false;
    }
    return data3;
}
function inner(data3) {
    var placement2 = data3.placement;
    var basePlacement = placement2.split("-")[0];
    var _data$offsets = data3.offsets,
        popper = _data$offsets.popper,
        reference = _data$offsets.reference;
    var isHoriz = ["left", "right"].indexOf(basePlacement) !== -1;
    var subtractLength = ["top", "left"].indexOf(basePlacement) === -1;
    popper[isHoriz ? "left" : "top"] =
        reference[basePlacement] -
        (subtractLength ? popper[isHoriz ? "width" : "height"] : 0);
    data3.placement = getOppositePlacement(placement2);
    data3.offsets.popper = getClientRect(popper);
    return data3;
}
var modifiers = {
    shift: {
        order: 100,
        enabled: true,
        fn: shift,
    },
    offset: {
        order: 200,
        enabled: true,
        fn: offset,
        offset: 0,
    },
    preventOverflow: {
        order: 300,
        enabled: true,
        fn: preventOverflow,
        priority: ["left", "right", "top", "bottom"],
        padding: 5,
        boundariesElement: "scrollParent",
    },
    keepTogether: {
        order: 400,
        enabled: true,
        fn: keepTogether,
    },
    arrow: {
        order: 500,
        enabled: true,
        fn: arrow,
        element: "[x-arrow]",
    },
    flip: {
        order: 600,
        enabled: true,
        fn: flip,
        behavior: "flip",
        padding: 5,
        boundariesElement: "viewport",
        flipVariations: false,
        flipVariationsByContent: false,
    },
    inner: {
        order: 700,
        enabled: false,
        fn: inner,
    },
    hide: {
        order: 800,
        enabled: true,
        fn: hide,
    },
    computeStyle: {
        order: 850,
        enabled: true,
        fn: computeStyle,
        gpuAcceleration: true,
        x: "bottom",
        y: "right",
    },
    applyStyle: {
        order: 900,
        enabled: true,
        fn: applyStyle,
        onLoad: applyStyleOnLoad,
        gpuAcceleration: void 0,
    },
};
var Defaults = {
    placement: "bottom",
    positionFixed: false,
    eventsEnabled: true,
    removeOnDestroy: false,
    onCreate: function onCreate() {},
    onUpdate: function onUpdate() {},
    modifiers,
};
var Popper = (function () {
    function Popper2(reference, popper) {
        var _this = this;
        var options =
            arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
        classCallCheck(this, Popper2);
        this.scheduleUpdate = function () {
            return requestAnimationFrame(_this.update);
        };
        this.update = debounce$1(this.update.bind(this));
        this.options = _extends({}, Popper2.Defaults, options);
        this.state = {
            isDestroyed: false,
            isCreated: false,
            scrollParents: [],
        };
        this.reference =
            reference && reference.jquery ? reference[0] : reference;
        this.popper = popper && popper.jquery ? popper[0] : popper;
        this.options.modifiers = {};
        Object.keys(
            _extends({}, Popper2.Defaults.modifiers, options.modifiers)
        ).forEach(function (name2) {
            _this.options.modifiers[name2] = _extends(
                {},
                Popper2.Defaults.modifiers[name2] || {},
                options.modifiers ? options.modifiers[name2] : {}
            );
        });
        this.modifiers = Object.keys(this.options.modifiers)
            .map(function (name2) {
                return _extends(
                    {
                        name: name2,
                    },
                    _this.options.modifiers[name2]
                );
            })
            .sort(function (a, b) {
                return a.order - b.order;
            });
        this.modifiers.forEach(function (modifierOptions) {
            if (
                modifierOptions.enabled &&
                isFunction$5(modifierOptions.onLoad)
            ) {
                modifierOptions.onLoad(
                    _this.reference,
                    _this.popper,
                    _this.options,
                    modifierOptions,
                    _this.state
                );
            }
        });
        this.update();
        var eventsEnabled = this.options.eventsEnabled;
        if (eventsEnabled) {
            this.enableEventListeners();
        }
        this.state.eventsEnabled = eventsEnabled;
    }
    createClass(Popper2, [
        {
            key: "update",
            value: function update$$1() {
                return update.call(this);
            },
        },
        {
            key: "destroy",
            value: function destroy$$1() {
                return destroy$1.call(this);
            },
        },
        {
            key: "enableEventListeners",
            value: function enableEventListeners$$1() {
                return enableEventListeners.call(this);
            },
        },
        {
            key: "disableEventListeners",
            value: function disableEventListeners$$1() {
                return disableEventListeners.call(this);
            },
        },
    ]);
    return Popper2;
})();
Popper.Utils = (typeof window !== "undefined" ? window : global).PopperUtils;
Popper.placements = placements;
Popper.Defaults = Defaults;
const Popper$1 = Popper;
function listCacheClear$1() {
    this.__data__ = [];
    this.size = 0;
}
var _listCacheClear = listCacheClear$1;
function eq$5(value, other) {
    return value === other || (value !== value && other !== other);
}
var eq_1 = eq$5;
var eq$4 = eq_1;
function assocIndexOf$4(array, key) {
    var length = array.length;
    while (length--) {
        if (eq$4(array[length][0], key)) {
            return length;
        }
    }
    return -1;
}
var _assocIndexOf = assocIndexOf$4;
var assocIndexOf$3 = _assocIndexOf;
var arrayProto = Array.prototype;
var splice = arrayProto.splice;
function listCacheDelete$1(key) {
    var data3 = this.__data__,
        index2 = assocIndexOf$3(data3, key);
    if (index2 < 0) {
        return false;
    }
    var lastIndex = data3.length - 1;
    if (index2 == lastIndex) {
        data3.pop();
    } else {
        splice.call(data3, index2, 1);
    }
    --this.size;
    return true;
}
var _listCacheDelete = listCacheDelete$1;
var assocIndexOf$2 = _assocIndexOf;
function listCacheGet$1(key) {
    var data3 = this.__data__,
        index2 = assocIndexOf$2(data3, key);
    return index2 < 0 ? void 0 : data3[index2][1];
}
var _listCacheGet = listCacheGet$1;
var assocIndexOf$1 = _assocIndexOf;
function listCacheHas$1(key) {
    return assocIndexOf$1(this.__data__, key) > -1;
}
var _listCacheHas = listCacheHas$1;
var assocIndexOf = _assocIndexOf;
function listCacheSet$1(key, value) {
    var data3 = this.__data__,
        index2 = assocIndexOf(data3, key);
    if (index2 < 0) {
        ++this.size;
        data3.push([key, value]);
    } else {
        data3[index2][1] = value;
    }
    return this;
}
var _listCacheSet = listCacheSet$1;
var listCacheClear = _listCacheClear,
    listCacheDelete = _listCacheDelete,
    listCacheGet = _listCacheGet,
    listCacheHas = _listCacheHas,
    listCacheSet = _listCacheSet;
function ListCache$4(entries) {
    var index2 = -1,
        length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index2 < length) {
        var entry = entries[index2];
        this.set(entry[0], entry[1]);
    }
}
ListCache$4.prototype.clear = listCacheClear;
ListCache$4.prototype["delete"] = listCacheDelete;
ListCache$4.prototype.get = listCacheGet;
ListCache$4.prototype.has = listCacheHas;
ListCache$4.prototype.set = listCacheSet;
var _ListCache = ListCache$4;
var ListCache$3 = _ListCache;
function stackClear$1() {
    this.__data__ = new ListCache$3();
    this.size = 0;
}
var _stackClear = stackClear$1;
function stackDelete$1(key) {
    var data3 = this.__data__,
        result = data3["delete"](key);
    this.size = data3.size;
    return result;
}
var _stackDelete = stackDelete$1;
function stackGet$1(key) {
    return this.__data__.get(key);
}
var _stackGet = stackGet$1;
function stackHas$1(key) {
    return this.__data__.has(key);
}
var _stackHas = stackHas$1;
var freeGlobal$1 =
    typeof commonjsGlobal == "object" &&
    commonjsGlobal &&
    commonjsGlobal.Object === Object &&
    commonjsGlobal;
var _freeGlobal = freeGlobal$1;
var freeGlobal = _freeGlobal;
var freeSelf =
    typeof self == "object" && self && self.Object === Object && self;
var root$9 = freeGlobal || freeSelf || Function("return this")();
var _root = root$9;
var root$8 = _root;
var Symbol$4 = root$8.Symbol;
var _Symbol = Symbol$4;
var Symbol$3 = _Symbol;
var objectProto$e = Object.prototype;
var hasOwnProperty$b = objectProto$e.hasOwnProperty;
var nativeObjectToString$1 = objectProto$e.toString;
var symToStringTag$1 = Symbol$3 ? Symbol$3.toStringTag : void 0;
function getRawTag$1(value) {
    var isOwn = hasOwnProperty$b.call(value, symToStringTag$1),
        tag = value[symToStringTag$1];
    try {
        value[symToStringTag$1] = void 0;
        var unmasked = true;
    } catch (e) {}
    var result = nativeObjectToString$1.call(value);
    if (unmasked) {
        if (isOwn) {
            value[symToStringTag$1] = tag;
        } else {
            delete value[symToStringTag$1];
        }
    }
    return result;
}
var _getRawTag = getRawTag$1;
var objectProto$d = Object.prototype;
var nativeObjectToString = objectProto$d.toString;
function objectToString$1(value) {
    return nativeObjectToString.call(value);
}
var _objectToString = objectToString$1;
var Symbol$2 = _Symbol,
    getRawTag = _getRawTag,
    objectToString = _objectToString;
var nullTag = "[object Null]",
    undefinedTag = "[object Undefined]";
var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : void 0;
function baseGetTag$5(value) {
    if (value == null) {
        return value === void 0 ? undefinedTag : nullTag;
    }
    return symToStringTag && symToStringTag in Object(value)
        ? getRawTag(value)
        : objectToString(value);
}
var _baseGetTag = baseGetTag$5;
function isObject$8(value) {
    var type = typeof value;
    return value != null && (type == "object" || type == "function");
}
var isObject_1 = isObject$8;
var baseGetTag$4 = _baseGetTag,
    isObject$7 = isObject_1;
var asyncTag = "[object AsyncFunction]",
    funcTag$1 = "[object Function]",
    genTag = "[object GeneratorFunction]",
    proxyTag = "[object Proxy]";
function isFunction$4(value) {
    if (!isObject$7(value)) {
        return false;
    }
    var tag = baseGetTag$4(value);
    return (
        tag == funcTag$1 || tag == genTag || tag == asyncTag || tag == proxyTag
    );
}
var isFunction_1 = isFunction$4;
var root$7 = _root;
var coreJsData$1 = root$7["__core-js_shared__"];
var _coreJsData = coreJsData$1;
var coreJsData = _coreJsData;
var maskSrcKey = (function () {
    var uid2 = /[^.]+$/.exec(
        (coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO) || ""
    );
    return uid2 ? "Symbol(src)_1." + uid2 : "";
})();
function isMasked$1(func) {
    return !!maskSrcKey && maskSrcKey in func;
}
var _isMasked = isMasked$1;
var funcProto$2 = Function.prototype;
var funcToString$2 = funcProto$2.toString;
function toSource$2(func) {
    if (func != null) {
        try {
            return funcToString$2.call(func);
        } catch (e) {}
        try {
            return func + "";
        } catch (e) {}
    }
    return "";
}
var _toSource = toSource$2;
var isFunction$3 = isFunction_1,
    isMasked = _isMasked,
    isObject$6 = isObject_1,
    toSource$1 = _toSource;
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
var reIsHostCtor = /^\[object .+?Constructor\]$/;
var funcProto$1 = Function.prototype,
    objectProto$c = Object.prototype;
var funcToString$1 = funcProto$1.toString;
var hasOwnProperty$a = objectProto$c.hasOwnProperty;
var reIsNative = RegExp(
    "^" +
        funcToString$1
            .call(hasOwnProperty$a)
            .replace(reRegExpChar, "\\$&")
            .replace(
                /hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,
                "$1.*?"
            ) +
        "$"
);
function baseIsNative$1(value) {
    if (!isObject$6(value) || isMasked(value)) {
        return false;
    }
    var pattern = isFunction$3(value) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource$1(value));
}
var _baseIsNative = baseIsNative$1;
function getValue$1(object, key) {
    return object == null ? void 0 : object[key];
}
var _getValue = getValue$1;
var baseIsNative = _baseIsNative,
    getValue = _getValue;
function getNative$7(object, key) {
    var value = getValue(object, key);
    return baseIsNative(value) ? value : void 0;
}
var _getNative = getNative$7;
var getNative$6 = _getNative,
    root$6 = _root;
var Map$4 = getNative$6(root$6, "Map");
var _Map = Map$4;
var getNative$5 = _getNative;
var nativeCreate$4 = getNative$5(Object, "create");
var _nativeCreate = nativeCreate$4;
var nativeCreate$3 = _nativeCreate;
function hashClear$1() {
    this.__data__ = nativeCreate$3 ? nativeCreate$3(null) : {};
    this.size = 0;
}
var _hashClear = hashClear$1;
function hashDelete$1(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
}
var _hashDelete = hashDelete$1;
var nativeCreate$2 = _nativeCreate;
var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
var objectProto$b = Object.prototype;
var hasOwnProperty$9 = objectProto$b.hasOwnProperty;
function hashGet$1(key) {
    var data3 = this.__data__;
    if (nativeCreate$2) {
        var result = data3[key];
        return result === HASH_UNDEFINED$2 ? void 0 : result;
    }
    return hasOwnProperty$9.call(data3, key) ? data3[key] : void 0;
}
var _hashGet = hashGet$1;
var nativeCreate$1 = _nativeCreate;
var objectProto$a = Object.prototype;
var hasOwnProperty$8 = objectProto$a.hasOwnProperty;
function hashHas$1(key) {
    var data3 = this.__data__;
    return nativeCreate$1
        ? data3[key] !== void 0
        : hasOwnProperty$8.call(data3, key);
}
var _hashHas = hashHas$1;
var nativeCreate = _nativeCreate;
var HASH_UNDEFINED$1 = "__lodash_hash_undefined__";
function hashSet$1(key, value) {
    var data3 = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data3[key] = nativeCreate && value === void 0 ? HASH_UNDEFINED$1 : value;
    return this;
}
var _hashSet = hashSet$1;
var hashClear = _hashClear,
    hashDelete = _hashDelete,
    hashGet = _hashGet,
    hashHas = _hashHas,
    hashSet = _hashSet;
function Hash$1(entries) {
    var index2 = -1,
        length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index2 < length) {
        var entry = entries[index2];
        this.set(entry[0], entry[1]);
    }
}
Hash$1.prototype.clear = hashClear;
Hash$1.prototype["delete"] = hashDelete;
Hash$1.prototype.get = hashGet;
Hash$1.prototype.has = hashHas;
Hash$1.prototype.set = hashSet;
var _Hash = Hash$1;
var Hash = _Hash,
    ListCache$2 = _ListCache,
    Map$3 = _Map;
function mapCacheClear$1() {
    this.size = 0;
    this.__data__ = {
        hash: new Hash(),
        map: new (Map$3 || ListCache$2)(),
        string: new Hash(),
    };
}
var _mapCacheClear = mapCacheClear$1;
function isKeyable$1(value) {
    var type = typeof value;
    return type == "string" ||
        type == "number" ||
        type == "symbol" ||
        type == "boolean"
        ? value !== "__proto__"
        : value === null;
}
var _isKeyable = isKeyable$1;
var isKeyable = _isKeyable;
function getMapData$4(map2, key) {
    var data3 = map2.__data__;
    return isKeyable(key)
        ? data3[typeof key == "string" ? "string" : "hash"]
        : data3.map;
}
var _getMapData = getMapData$4;
var getMapData$3 = _getMapData;
function mapCacheDelete$1(key) {
    var result = getMapData$3(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
}
var _mapCacheDelete = mapCacheDelete$1;
var getMapData$2 = _getMapData;
function mapCacheGet$1(key) {
    return getMapData$2(this, key).get(key);
}
var _mapCacheGet = mapCacheGet$1;
var getMapData$1 = _getMapData;
function mapCacheHas$1(key) {
    return getMapData$1(this, key).has(key);
}
var _mapCacheHas = mapCacheHas$1;
var getMapData = _getMapData;
function mapCacheSet$1(key, value) {
    var data3 = getMapData(this, key),
        size2 = data3.size;
    data3.set(key, value);
    this.size += data3.size == size2 ? 0 : 1;
    return this;
}
var _mapCacheSet = mapCacheSet$1;
var mapCacheClear = _mapCacheClear,
    mapCacheDelete = _mapCacheDelete,
    mapCacheGet = _mapCacheGet,
    mapCacheHas = _mapCacheHas,
    mapCacheSet = _mapCacheSet;
function MapCache$2(entries) {
    var index2 = -1,
        length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index2 < length) {
        var entry = entries[index2];
        this.set(entry[0], entry[1]);
    }
}
MapCache$2.prototype.clear = mapCacheClear;
MapCache$2.prototype["delete"] = mapCacheDelete;
MapCache$2.prototype.get = mapCacheGet;
MapCache$2.prototype.has = mapCacheHas;
MapCache$2.prototype.set = mapCacheSet;
var _MapCache = MapCache$2;
var ListCache$1 = _ListCache,
    Map$2 = _Map,
    MapCache$1 = _MapCache;
var LARGE_ARRAY_SIZE = 200;
function stackSet$1(key, value) {
    var data3 = this.__data__;
    if (data3 instanceof ListCache$1) {
        var pairs = data3.__data__;
        if (!Map$2 || pairs.length < LARGE_ARRAY_SIZE - 1) {
            pairs.push([key, value]);
            this.size = ++data3.size;
            return this;
        }
        data3 = this.__data__ = new MapCache$1(pairs);
    }
    data3.set(key, value);
    this.size = data3.size;
    return this;
}
var _stackSet = stackSet$1;
var ListCache = _ListCache,
    stackClear = _stackClear,
    stackDelete = _stackDelete,
    stackGet = _stackGet,
    stackHas = _stackHas,
    stackSet = _stackSet;
function Stack$2(entries) {
    var data3 = (this.__data__ = new ListCache(entries));
    this.size = data3.size;
}
Stack$2.prototype.clear = stackClear;
Stack$2.prototype["delete"] = stackDelete;
Stack$2.prototype.get = stackGet;
Stack$2.prototype.has = stackHas;
Stack$2.prototype.set = stackSet;
var _Stack = Stack$2;
var HASH_UNDEFINED = "__lodash_hash_undefined__";
function setCacheAdd$1(value) {
    this.__data__.set(value, HASH_UNDEFINED);
    return this;
}
var _setCacheAdd = setCacheAdd$1;
function setCacheHas$1(value) {
    return this.__data__.has(value);
}
var _setCacheHas = setCacheHas$1;
var MapCache = _MapCache,
    setCacheAdd = _setCacheAdd,
    setCacheHas = _setCacheHas;
function SetCache$1(values) {
    var index2 = -1,
        length = values == null ? 0 : values.length;
    this.__data__ = new MapCache();
    while (++index2 < length) {
        this.add(values[index2]);
    }
}
SetCache$1.prototype.add = SetCache$1.prototype.push = setCacheAdd;
SetCache$1.prototype.has = setCacheHas;
var _SetCache = SetCache$1;
function arraySome$1(array, predicate) {
    var index2 = -1,
        length = array == null ? 0 : array.length;
    while (++index2 < length) {
        if (predicate(array[index2], index2, array)) {
            return true;
        }
    }
    return false;
}
var _arraySome = arraySome$1;
function cacheHas$1(cache, key) {
    return cache.has(key);
}
var _cacheHas = cacheHas$1;
var SetCache = _SetCache,
    arraySome = _arraySome,
    cacheHas = _cacheHas;
var COMPARE_PARTIAL_FLAG$3 = 1,
    COMPARE_UNORDERED_FLAG$1 = 2;
function equalArrays$2(array, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3,
        arrLength = array.length,
        othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
        return false;
    }
    var arrStacked = stack.get(array);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
        return arrStacked == other && othStacked == array;
    }
    var index2 = -1,
        result = true,
        seen = bitmask & COMPARE_UNORDERED_FLAG$1 ? new SetCache() : void 0;
    stack.set(array, other);
    stack.set(other, array);
    while (++index2 < arrLength) {
        var arrValue = array[index2],
            othValue = other[index2];
        if (customizer) {
            var compared = isPartial
                ? customizer(othValue, arrValue, index2, other, array, stack)
                : customizer(arrValue, othValue, index2, array, other, stack);
        }
        if (compared !== void 0) {
            if (compared) {
                continue;
            }
            result = false;
            break;
        }
        if (seen) {
            if (
                !arraySome(other, function (othValue2, othIndex) {
                    if (
                        !cacheHas(seen, othIndex) &&
                        (arrValue === othValue2 ||
                            equalFunc(
                                arrValue,
                                othValue2,
                                bitmask,
                                customizer,
                                stack
                            ))
                    ) {
                        return seen.push(othIndex);
                    }
                })
            ) {
                result = false;
                break;
            }
        } else if (
            !(
                arrValue === othValue ||
                equalFunc(arrValue, othValue, bitmask, customizer, stack)
            )
        ) {
            result = false;
            break;
        }
    }
    stack["delete"](array);
    stack["delete"](other);
    return result;
}
var _equalArrays = equalArrays$2;
var root$5 = _root;
var Uint8Array$3 = root$5.Uint8Array;
var _Uint8Array = Uint8Array$3;
function mapToArray$1(map2) {
    var index2 = -1,
        result = Array(map2.size);
    map2.forEach(function (value, key) {
        result[++index2] = [key, value];
    });
    return result;
}
var _mapToArray = mapToArray$1;
function setToArray$1(set3) {
    var index2 = -1,
        result = Array(set3.size);
    set3.forEach(function (value) {
        result[++index2] = value;
    });
    return result;
}
var _setToArray = setToArray$1;
var Symbol$1 = _Symbol,
    Uint8Array$2 = _Uint8Array,
    eq$3 = eq_1,
    equalArrays$1 = _equalArrays,
    mapToArray = _mapToArray,
    setToArray = _setToArray;
var COMPARE_PARTIAL_FLAG$2 = 1,
    COMPARE_UNORDERED_FLAG = 2;
var boolTag$1 = "[object Boolean]",
    dateTag$1 = "[object Date]",
    errorTag$1 = "[object Error]",
    mapTag$2 = "[object Map]",
    numberTag$1 = "[object Number]",
    regexpTag$1 = "[object RegExp]",
    setTag$2 = "[object Set]",
    stringTag$1 = "[object String]",
    symbolTag = "[object Symbol]";
var arrayBufferTag$1 = "[object ArrayBuffer]",
    dataViewTag$2 = "[object DataView]";
var symbolProto = Symbol$1 ? Symbol$1.prototype : void 0,
    symbolValueOf = symbolProto ? symbolProto.valueOf : void 0;
function equalByTag$1(
    object,
    other,
    tag,
    bitmask,
    customizer,
    equalFunc,
    stack
) {
    switch (tag) {
        case dataViewTag$2:
            if (
                object.byteLength != other.byteLength ||
                object.byteOffset != other.byteOffset
            ) {
                return false;
            }
            object = object.buffer;
            other = other.buffer;
        case arrayBufferTag$1:
            if (
                object.byteLength != other.byteLength ||
                !equalFunc(new Uint8Array$2(object), new Uint8Array$2(other))
            ) {
                return false;
            }
            return true;
        case boolTag$1:
        case dateTag$1:
        case numberTag$1:
            return eq$3(+object, +other);
        case errorTag$1:
            return object.name == other.name && object.message == other.message;
        case regexpTag$1:
        case stringTag$1:
            return object == other + "";
        case mapTag$2:
            var convert = mapToArray;
        case setTag$2:
            var isPartial = bitmask & COMPARE_PARTIAL_FLAG$2;
            convert || (convert = setToArray);
            if (object.size != other.size && !isPartial) {
                return false;
            }
            var stacked = stack.get(object);
            if (stacked) {
                return stacked == other;
            }
            bitmask |= COMPARE_UNORDERED_FLAG;
            stack.set(object, other);
            var result = equalArrays$1(
                convert(object),
                convert(other),
                bitmask,
                customizer,
                equalFunc,
                stack
            );
            stack["delete"](object);
            return result;
        case symbolTag:
            if (symbolValueOf) {
                return symbolValueOf.call(object) == symbolValueOf.call(other);
            }
    }
    return false;
}
var _equalByTag = equalByTag$1;
function arrayPush$1(array, values) {
    var index2 = -1,
        length = values.length,
        offset2 = array.length;
    while (++index2 < length) {
        array[offset2 + index2] = values[index2];
    }
    return array;
}
var _arrayPush = arrayPush$1;
var isArray$5 = Array.isArray;
var isArray_1 = isArray$5;
var arrayPush = _arrayPush,
    isArray$4 = isArray_1;
function baseGetAllKeys$1(object, keysFunc, symbolsFunc) {
    var result = keysFunc(object);
    return isArray$4(object) ? result : arrayPush(result, symbolsFunc(object));
}
var _baseGetAllKeys = baseGetAllKeys$1;
function arrayFilter$1(array, predicate) {
    var index2 = -1,
        length = array == null ? 0 : array.length,
        resIndex = 0,
        result = [];
    while (++index2 < length) {
        var value = array[index2];
        if (predicate(value, index2, array)) {
            result[resIndex++] = value;
        }
    }
    return result;
}
var _arrayFilter = arrayFilter$1;
function stubArray$1() {
    return [];
}
var stubArray_1 = stubArray$1;
var arrayFilter = _arrayFilter,
    stubArray = stubArray_1;
var objectProto$9 = Object.prototype;
var propertyIsEnumerable$1 = objectProto$9.propertyIsEnumerable;
var nativeGetSymbols = Object.getOwnPropertySymbols;
var getSymbols$1 = !nativeGetSymbols
    ? stubArray
    : function (object) {
          if (object == null) {
              return [];
          }
          object = Object(object);
          return arrayFilter(nativeGetSymbols(object), function (symbol) {
              return propertyIsEnumerable$1.call(object, symbol);
          });
      };
var _getSymbols = getSymbols$1;
function baseTimes$1(n, iteratee) {
    var index2 = -1,
        result = Array(n);
    while (++index2 < n) {
        result[index2] = iteratee(index2);
    }
    return result;
}
var _baseTimes = baseTimes$1;
function isObjectLike$6(value) {
    return value != null && typeof value == "object";
}
var isObjectLike_1 = isObjectLike$6;
var baseGetTag$3 = _baseGetTag,
    isObjectLike$5 = isObjectLike_1;
var argsTag$2 = "[object Arguments]";
function baseIsArguments$1(value) {
    return isObjectLike$5(value) && baseGetTag$3(value) == argsTag$2;
}
var _baseIsArguments = baseIsArguments$1;
var baseIsArguments = _baseIsArguments,
    isObjectLike$4 = isObjectLike_1;
var objectProto$8 = Object.prototype;
var hasOwnProperty$7 = objectProto$8.hasOwnProperty;
var propertyIsEnumerable = objectProto$8.propertyIsEnumerable;
var isArguments$2 = baseIsArguments(
    (function () {
        return arguments;
    })()
)
    ? baseIsArguments
    : function (value) {
          return (
              isObjectLike$4(value) &&
              hasOwnProperty$7.call(value, "callee") &&
              !propertyIsEnumerable.call(value, "callee")
          );
      };
var isArguments_1 = isArguments$2;
var isBuffer$3 = { exports: {} };
function stubFalse() {
    return false;
}
var stubFalse_1 = stubFalse;
(function (module, exports) {
    var root2 = _root,
        stubFalse2 = stubFalse_1;
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule =
        freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var Buffer2 = moduleExports ? root2.Buffer : void 0;
    var nativeIsBuffer = Buffer2 ? Buffer2.isBuffer : void 0;
    var isBuffer2 = nativeIsBuffer || stubFalse2;
    module.exports = isBuffer2;
})(isBuffer$3, isBuffer$3.exports);
var MAX_SAFE_INTEGER$1 = 9007199254740991;
var reIsUint = /^(?:0|[1-9]\d*)$/;
function isIndex$2(value, length) {
    var type = typeof value;
    length = length == null ? MAX_SAFE_INTEGER$1 : length;
    return (
        !!length &&
        (type == "number" || (type != "symbol" && reIsUint.test(value))) &&
        value > -1 &&
        value % 1 == 0 &&
        value < length
    );
}
var _isIndex = isIndex$2;
var MAX_SAFE_INTEGER = 9007199254740991;
function isLength$2(value) {
    return (
        typeof value == "number" &&
        value > -1 &&
        value % 1 == 0 &&
        value <= MAX_SAFE_INTEGER
    );
}
var isLength_1 = isLength$2;
var baseGetTag$2 = _baseGetTag,
    isLength$1 = isLength_1,
    isObjectLike$3 = isObjectLike_1;
var argsTag$1 = "[object Arguments]",
    arrayTag$1 = "[object Array]",
    boolTag = "[object Boolean]",
    dateTag = "[object Date]",
    errorTag = "[object Error]",
    funcTag = "[object Function]",
    mapTag$1 = "[object Map]",
    numberTag = "[object Number]",
    objectTag$3 = "[object Object]",
    regexpTag = "[object RegExp]",
    setTag$1 = "[object Set]",
    stringTag = "[object String]",
    weakMapTag$1 = "[object WeakMap]";
var arrayBufferTag = "[object ArrayBuffer]",
    dataViewTag$1 = "[object DataView]",
    float32Tag = "[object Float32Array]",
    float64Tag = "[object Float64Array]",
    int8Tag = "[object Int8Array]",
    int16Tag = "[object Int16Array]",
    int32Tag = "[object Int32Array]",
    uint8Tag = "[object Uint8Array]",
    uint8ClampedTag = "[object Uint8ClampedArray]",
    uint16Tag = "[object Uint16Array]",
    uint32Tag = "[object Uint32Array]";
var typedArrayTags = {};
typedArrayTags[float32Tag] =
    typedArrayTags[float64Tag] =
    typedArrayTags[int8Tag] =
    typedArrayTags[int16Tag] =
    typedArrayTags[int32Tag] =
    typedArrayTags[uint8Tag] =
    typedArrayTags[uint8ClampedTag] =
    typedArrayTags[uint16Tag] =
    typedArrayTags[uint32Tag] =
        true;
typedArrayTags[argsTag$1] =
    typedArrayTags[arrayTag$1] =
    typedArrayTags[arrayBufferTag] =
    typedArrayTags[boolTag] =
    typedArrayTags[dataViewTag$1] =
    typedArrayTags[dateTag] =
    typedArrayTags[errorTag] =
    typedArrayTags[funcTag] =
    typedArrayTags[mapTag$1] =
    typedArrayTags[numberTag] =
    typedArrayTags[objectTag$3] =
    typedArrayTags[regexpTag] =
    typedArrayTags[setTag$1] =
    typedArrayTags[stringTag] =
    typedArrayTags[weakMapTag$1] =
        false;
function baseIsTypedArray$1(value) {
    return (
        isObjectLike$3(value) &&
        isLength$1(value.length) &&
        !!typedArrayTags[baseGetTag$2(value)]
    );
}
var _baseIsTypedArray = baseIsTypedArray$1;
function baseUnary$1(func) {
    return function (value) {
        return func(value);
    };
}
var _baseUnary = baseUnary$1;
var _nodeUtil = { exports: {} };
(function (module, exports) {
    var freeGlobal2 = _freeGlobal;
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule =
        freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && freeGlobal2.process;
    var nodeUtil2 = (function () {
        try {
            var types =
                freeModule &&
                freeModule.require &&
                freeModule.require("util").types;
            if (types) {
                return types;
            }
            return (
                freeProcess &&
                freeProcess.binding &&
                freeProcess.binding("util")
            );
        } catch (e) {}
    })();
    module.exports = nodeUtil2;
})(_nodeUtil, _nodeUtil.exports);
var baseIsTypedArray = _baseIsTypedArray,
    baseUnary = _baseUnary,
    nodeUtil = _nodeUtil.exports;
var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;
var isTypedArray$3 = nodeIsTypedArray
    ? baseUnary(nodeIsTypedArray)
    : baseIsTypedArray;
var isTypedArray_1 = isTypedArray$3;
var baseTimes = _baseTimes,
    isArguments$1 = isArguments_1,
    isArray$3 = isArray_1,
    isBuffer$2 = isBuffer$3.exports,
    isIndex$1 = _isIndex,
    isTypedArray$2 = isTypedArray_1;
var objectProto$7 = Object.prototype;
var hasOwnProperty$6 = objectProto$7.hasOwnProperty;
function arrayLikeKeys$2(value, inherited) {
    var isArr = isArray$3(value),
        isArg = !isArr && isArguments$1(value),
        isBuff = !isArr && !isArg && isBuffer$2(value),
        isType = !isArr && !isArg && !isBuff && isTypedArray$2(value),
        skipIndexes = isArr || isArg || isBuff || isType,
        result = skipIndexes ? baseTimes(value.length, String) : [],
        length = result.length;
    for (var key in value) {
        if (
            (inherited || hasOwnProperty$6.call(value, key)) &&
            !(
                skipIndexes &&
                (key == "length" ||
                    (isBuff && (key == "offset" || key == "parent")) ||
                    (isType &&
                        (key == "buffer" ||
                            key == "byteLength" ||
                            key == "byteOffset")) ||
                    isIndex$1(key, length))
            )
        ) {
            result.push(key);
        }
    }
    return result;
}
var _arrayLikeKeys = arrayLikeKeys$2;
var objectProto$6 = Object.prototype;
function isPrototype$3(value) {
    var Ctor = value && value.constructor,
        proto = (typeof Ctor == "function" && Ctor.prototype) || objectProto$6;
    return value === proto;
}
var _isPrototype = isPrototype$3;
function overArg$2(func, transform) {
    return function (arg) {
        return func(transform(arg));
    };
}
var _overArg = overArg$2;
var overArg$1 = _overArg;
var nativeKeys$1 = overArg$1(Object.keys, Object);
var _nativeKeys = nativeKeys$1;
var isPrototype$2 = _isPrototype,
    nativeKeys = _nativeKeys;
var objectProto$5 = Object.prototype;
var hasOwnProperty$5 = objectProto$5.hasOwnProperty;
function baseKeys$1(object) {
    if (!isPrototype$2(object)) {
        return nativeKeys(object);
    }
    var result = [];
    for (var key in Object(object)) {
        if (hasOwnProperty$5.call(object, key) && key != "constructor") {
            result.push(key);
        }
    }
    return result;
}
var _baseKeys = baseKeys$1;
var isFunction$2 = isFunction_1,
    isLength = isLength_1;
function isArrayLike$4(value) {
    return value != null && isLength(value.length) && !isFunction$2(value);
}
var isArrayLike_1 = isArrayLike$4;
var arrayLikeKeys$1 = _arrayLikeKeys,
    baseKeys = _baseKeys,
    isArrayLike$3 = isArrayLike_1;
function keys$1(object) {
    return isArrayLike$3(object) ? arrayLikeKeys$1(object) : baseKeys(object);
}
var keys_1 = keys$1;
var baseGetAllKeys = _baseGetAllKeys,
    getSymbols = _getSymbols,
    keys = keys_1;
function getAllKeys$1(object) {
    return baseGetAllKeys(object, keys, getSymbols);
}
var _getAllKeys = getAllKeys$1;
var getAllKeys = _getAllKeys;
var COMPARE_PARTIAL_FLAG$1 = 1;
var objectProto$4 = Object.prototype;
var hasOwnProperty$4 = objectProto$4.hasOwnProperty;
function equalObjects$1(object, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$1,
        objProps = getAllKeys(object),
        objLength = objProps.length,
        othProps = getAllKeys(other),
        othLength = othProps.length;
    if (objLength != othLength && !isPartial) {
        return false;
    }
    var index2 = objLength;
    while (index2--) {
        var key = objProps[index2];
        if (!(isPartial ? key in other : hasOwnProperty$4.call(other, key))) {
            return false;
        }
    }
    var objStacked = stack.get(object);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
        return objStacked == other && othStacked == object;
    }
    var result = true;
    stack.set(object, other);
    stack.set(other, object);
    var skipCtor = isPartial;
    while (++index2 < objLength) {
        key = objProps[index2];
        var objValue = object[key],
            othValue = other[key];
        if (customizer) {
            var compared = isPartial
                ? customizer(othValue, objValue, key, other, object, stack)
                : customizer(objValue, othValue, key, object, other, stack);
        }
        if (
            !(compared === void 0
                ? objValue === othValue ||
                  equalFunc(objValue, othValue, bitmask, customizer, stack)
                : compared)
        ) {
            result = false;
            break;
        }
        skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
        var objCtor = object.constructor,
            othCtor = other.constructor;
        if (
            objCtor != othCtor &&
            "constructor" in object &&
            "constructor" in other &&
            !(
                typeof objCtor == "function" &&
                objCtor instanceof objCtor &&
                typeof othCtor == "function" &&
                othCtor instanceof othCtor
            )
        ) {
            result = false;
        }
    }
    stack["delete"](object);
    stack["delete"](other);
    return result;
}
var _equalObjects = equalObjects$1;
var getNative$4 = _getNative,
    root$4 = _root;
var DataView$1 = getNative$4(root$4, "DataView");
var _DataView = DataView$1;
var getNative$3 = _getNative,
    root$3 = _root;
var Promise$2 = getNative$3(root$3, "Promise");
var _Promise = Promise$2;
var getNative$2 = _getNative,
    root$2 = _root;
var Set$2 = getNative$2(root$2, "Set");
var _Set = Set$2;
var getNative$1 = _getNative,
    root$1 = _root;
var WeakMap$2 = getNative$1(root$1, "WeakMap");
var _WeakMap = WeakMap$2;
var DataView = _DataView,
    Map$1 = _Map,
    Promise$1 = _Promise,
    Set$1 = _Set,
    WeakMap$1 = _WeakMap,
    baseGetTag$1 = _baseGetTag,
    toSource = _toSource;
var mapTag = "[object Map]",
    objectTag$2 = "[object Object]",
    promiseTag = "[object Promise]",
    setTag = "[object Set]",
    weakMapTag = "[object WeakMap]";
var dataViewTag = "[object DataView]";
var dataViewCtorString = toSource(DataView),
    mapCtorString = toSource(Map$1),
    promiseCtorString = toSource(Promise$1),
    setCtorString = toSource(Set$1),
    weakMapCtorString = toSource(WeakMap$1);
var getTag$1 = baseGetTag$1;
if (
    (DataView && getTag$1(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
    (Map$1 && getTag$1(new Map$1()) != mapTag) ||
    (Promise$1 && getTag$1(Promise$1.resolve()) != promiseTag) ||
    (Set$1 && getTag$1(new Set$1()) != setTag) ||
    (WeakMap$1 && getTag$1(new WeakMap$1()) != weakMapTag)
) {
    getTag$1 = function (value) {
        var result = baseGetTag$1(value),
            Ctor = result == objectTag$2 ? value.constructor : void 0,
            ctorString = Ctor ? toSource(Ctor) : "";
        if (ctorString) {
            switch (ctorString) {
                case dataViewCtorString:
                    return dataViewTag;
                case mapCtorString:
                    return mapTag;
                case promiseCtorString:
                    return promiseTag;
                case setCtorString:
                    return setTag;
                case weakMapCtorString:
                    return weakMapTag;
            }
        }
        return result;
    };
}
var _getTag = getTag$1;
var Stack$1 = _Stack,
    equalArrays = _equalArrays,
    equalByTag = _equalByTag,
    equalObjects = _equalObjects,
    getTag = _getTag,
    isArray$2 = isArray_1,
    isBuffer$1 = isBuffer$3.exports,
    isTypedArray$1 = isTypedArray_1;
var COMPARE_PARTIAL_FLAG = 1;
var argsTag = "[object Arguments]",
    arrayTag = "[object Array]",
    objectTag$1 = "[object Object]";
var objectProto$3 = Object.prototype;
var hasOwnProperty$3 = objectProto$3.hasOwnProperty;
function baseIsEqualDeep$1(
    object,
    other,
    bitmask,
    customizer,
    equalFunc,
    stack
) {
    var objIsArr = isArray$2(object),
        othIsArr = isArray$2(other),
        objTag = objIsArr ? arrayTag : getTag(object),
        othTag = othIsArr ? arrayTag : getTag(other);
    objTag = objTag == argsTag ? objectTag$1 : objTag;
    othTag = othTag == argsTag ? objectTag$1 : othTag;
    var objIsObj = objTag == objectTag$1,
        othIsObj = othTag == objectTag$1,
        isSameTag = objTag == othTag;
    if (isSameTag && isBuffer$1(object)) {
        if (!isBuffer$1(other)) {
            return false;
        }
        objIsArr = true;
        objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
        stack || (stack = new Stack$1());
        return objIsArr || isTypedArray$1(object)
            ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)
            : equalByTag(
                  object,
                  other,
                  objTag,
                  bitmask,
                  customizer,
                  equalFunc,
                  stack
              );
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
        var objIsWrapped =
                objIsObj && hasOwnProperty$3.call(object, "__wrapped__"),
            othIsWrapped =
                othIsObj && hasOwnProperty$3.call(other, "__wrapped__");
        if (objIsWrapped || othIsWrapped) {
            var objUnwrapped = objIsWrapped ? object.value() : object,
                othUnwrapped = othIsWrapped ? other.value() : other;
            stack || (stack = new Stack$1());
            return equalFunc(
                objUnwrapped,
                othUnwrapped,
                bitmask,
                customizer,
                stack
            );
        }
    }
    if (!isSameTag) {
        return false;
    }
    stack || (stack = new Stack$1());
    return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
}
var _baseIsEqualDeep = baseIsEqualDeep$1;
var baseIsEqualDeep = _baseIsEqualDeep,
    isObjectLike$2 = isObjectLike_1;
function baseIsEqual$1(value, other, bitmask, customizer, stack) {
    if (value === other) {
        return true;
    }
    if (
        value == null ||
        other == null ||
        (!isObjectLike$2(value) && !isObjectLike$2(other))
    ) {
        return value !== value && other !== other;
    }
    return baseIsEqualDeep(
        value,
        other,
        bitmask,
        customizer,
        baseIsEqual$1,
        stack
    );
}
var _baseIsEqual = baseIsEqual$1;
var baseIsEqual = _baseIsEqual;
function isEqual(value, other) {
    return baseIsEqual(value, other);
}
var isEqual_1 = isEqual;
function getInternetExplorerVersion() {
    var ua = window.navigator.userAgent;
    var msie = ua.indexOf("MSIE ");
    if (msie > 0) {
        return parseInt(ua.substring(msie + 5, ua.indexOf(".", msie)), 10);
    }
    var trident = ua.indexOf("Trident/");
    if (trident > 0) {
        var rv = ua.indexOf("rv:");
        return parseInt(ua.substring(rv + 3, ua.indexOf(".", rv)), 10);
    }
    var edge = ua.indexOf("Edge/");
    if (edge > 0) {
        return parseInt(ua.substring(edge + 5, ua.indexOf(".", edge)), 10);
    }
    return -1;
}
var isIE;
function initCompat() {
    if (!initCompat.init) {
        initCompat.init = true;
        isIE = getInternetExplorerVersion() !== -1;
    }
}
var script$1 = {
    name: "ResizeObserver",
    props: {
        emitOnMount: {
            type: Boolean,
            default: false,
        },
        ignoreWidth: {
            type: Boolean,
            default: false,
        },
        ignoreHeight: {
            type: Boolean,
            default: false,
        },
    },
    mounted: function mounted() {
        var _this = this;
        initCompat();
        this.$nextTick(function () {
            _this._w = _this.$el.offsetWidth;
            _this._h = _this.$el.offsetHeight;
            if (_this.emitOnMount) {
                _this.emitSize();
            }
        });
        var object = document.createElement("object");
        this._resizeObject = object;
        object.setAttribute("aria-hidden", "true");
        object.setAttribute("tabindex", -1);
        object.onload = this.addResizeHandlers;
        object.type = "text/html";
        if (isIE) {
            this.$el.appendChild(object);
        }
        object.data = "about:blank";
        if (!isIE) {
            this.$el.appendChild(object);
        }
    },
    beforeDestroy: function beforeDestroy() {
        this.removeResizeHandlers();
    },
    methods: {
        compareAndNotify: function compareAndNotify() {
            if (
                (!this.ignoreWidth && this._w !== this.$el.offsetWidth) ||
                (!this.ignoreHeight && this._h !== this.$el.offsetHeight)
            ) {
                this._w = this.$el.offsetWidth;
                this._h = this.$el.offsetHeight;
                this.emitSize();
            }
        },
        emitSize: function emitSize() {
            this.$emit("notify", {
                width: this._w,
                height: this._h,
            });
        },
        addResizeHandlers: function addResizeHandlers() {
            this._resizeObject.contentDocument.defaultView.addEventListener(
                "resize",
                this.compareAndNotify
            );
            this.compareAndNotify();
        },
        removeResizeHandlers: function removeResizeHandlers() {
            if (this._resizeObject && this._resizeObject.onload) {
                if (!isIE && this._resizeObject.contentDocument) {
                    this._resizeObject.contentDocument.defaultView.removeEventListener(
                        "resize",
                        this.compareAndNotify
                    );
                }
                this.$el.removeChild(this._resizeObject);
                this._resizeObject.onload = null;
                this._resizeObject = null;
            }
        },
    },
};
function normalizeComponent$1(
    template,
    style2,
    script2,
    scopeId,
    isFunctionalTemplate,
    moduleIdentifier,
    shadowMode,
    createInjector,
    createInjectorSSR,
    createInjectorShadow
) {
    if (typeof shadowMode !== "boolean") {
        createInjectorSSR = createInjector;
        createInjector = shadowMode;
        shadowMode = false;
    }
    var options = typeof script2 === "function" ? script2.options : script2;
    if (template && template.render) {
        options.render = template.render;
        options.staticRenderFns = template.staticRenderFns;
        options._compiled = true;
        if (isFunctionalTemplate) {
            options.functional = true;
        }
    }
    if (scopeId) {
        options._scopeId = scopeId;
    }
    var hook;
    if (moduleIdentifier) {
        hook = function hook2(context) {
            context =
                context ||
                (this.$vnode && this.$vnode.ssrContext) ||
                (this.parent &&
                    this.parent.$vnode &&
                    this.parent.$vnode.ssrContext);
            if (!context && typeof __VUE_SSR_CONTEXT__ !== "undefined") {
                context = __VUE_SSR_CONTEXT__;
            }
            if (style2) {
                style2.call(this, createInjectorSSR(context));
            }
            if (context && context._registeredComponents) {
                context._registeredComponents.add(moduleIdentifier);
            }
        };
        options._ssrRegister = hook;
    } else if (style2) {
        hook = shadowMode
            ? function (context) {
                  style2.call(
                      this,
                      createInjectorShadow(
                          context,
                          this.$root.$options.shadowRoot
                      )
                  );
              }
            : function (context) {
                  style2.call(this, createInjector(context));
              };
    }
    if (hook) {
        if (options.functional) {
            var originalRender = options.render;
            options.render = function renderWithStyleInjection(h, context) {
                hook.call(context);
                return originalRender(h, context);
            };
        } else {
            var existing = options.beforeCreate;
            options.beforeCreate = existing
                ? [].concat(existing, hook)
                : [hook];
        }
    }
    return script2;
}
var __vue_script__$1 = script$1;
var __vue_render__$1 = function __vue_render__() {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c("div", {
        staticClass: "resize-observer",
        attrs: {
            tabindex: "-1",
        },
    });
};
var __vue_staticRenderFns__$1 = [];
__vue_render__$1._withStripped = true;
var __vue_inject_styles__$1 = void 0;
var __vue_scope_id__$1 = "data-v-8859cc6c";
var __vue_module_identifier__$1 = void 0;
var __vue_is_functional_template__$1 = false;
var __vue_component__$1 = /* @__PURE__ */ normalizeComponent$1(
    {
        render: __vue_render__$1,
        staticRenderFns: __vue_staticRenderFns__$1,
    },
    __vue_inject_styles__$1,
    __vue_script__$1,
    __vue_scope_id__$1,
    __vue_is_functional_template__$1,
    __vue_module_identifier__$1,
    false,
    void 0,
    void 0,
    void 0
);
function install$1(Vue2) {
    Vue2.component("resize-observer", __vue_component__$1);
    Vue2.component("ResizeObserver", __vue_component__$1);
}
var plugin$3 = {
    version: "1.0.1",
    install: install$1,
};
var GlobalVue$1 = null;
if (typeof window !== "undefined") {
    GlobalVue$1 = window.Vue;
} else if (typeof global !== "undefined") {
    GlobalVue$1 = global.Vue;
}
if (GlobalVue$1) {
    GlobalVue$1.use(plugin$3);
}
var getNative = _getNative;
var defineProperty$3 = (function () {
    try {
        var func = getNative(Object, "defineProperty");
        func({}, "", {});
        return func;
    } catch (e) {}
})();
var _defineProperty = defineProperty$3;
var defineProperty$2 = _defineProperty;
function baseAssignValue$3(object, key, value) {
    if (key == "__proto__" && defineProperty$2) {
        defineProperty$2(object, key, {
            configurable: true,
            enumerable: true,
            value: value,
            writable: true,
        });
    } else {
        object[key] = value;
    }
}
var _baseAssignValue = baseAssignValue$3;
var baseAssignValue$2 = _baseAssignValue,
    eq$2 = eq_1;
function assignMergeValue$2(object, key, value) {
    if (
        (value !== void 0 && !eq$2(object[key], value)) ||
        (value === void 0 && !(key in object))
    ) {
        baseAssignValue$2(object, key, value);
    }
}
var _assignMergeValue = assignMergeValue$2;
function createBaseFor$1(fromRight) {
    return function (object, iteratee, keysFunc) {
        var index2 = -1,
            iterable = Object(object),
            props2 = keysFunc(object),
            length = props2.length;
        while (length--) {
            var key = props2[fromRight ? length : ++index2];
            if (iteratee(iterable[key], key, iterable) === false) {
                break;
            }
        }
        return object;
    };
}
var _createBaseFor = createBaseFor$1;
var createBaseFor = _createBaseFor;
var baseFor$1 = createBaseFor();
var _baseFor = baseFor$1;
var _cloneBuffer = { exports: {} };
(function (module, exports) {
    var root2 = _root;
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule =
        freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var Buffer2 = moduleExports ? root2.Buffer : void 0,
        allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : void 0;
    function cloneBuffer2(buffer, isDeep) {
        if (isDeep) {
            return buffer.slice();
        }
        var length = buffer.length,
            result = allocUnsafe
                ? allocUnsafe(length)
                : new buffer.constructor(length);
        buffer.copy(result);
        return result;
    }
    module.exports = cloneBuffer2;
})(_cloneBuffer, _cloneBuffer.exports);
var Uint8Array$1 = _Uint8Array;
function cloneArrayBuffer$1(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new Uint8Array$1(result).set(new Uint8Array$1(arrayBuffer));
    return result;
}
var _cloneArrayBuffer = cloneArrayBuffer$1;
var cloneArrayBuffer = _cloneArrayBuffer;
function cloneTypedArray$1(typedArray, isDeep) {
    var buffer = isDeep
        ? cloneArrayBuffer(typedArray.buffer)
        : typedArray.buffer;
    return new typedArray.constructor(
        buffer,
        typedArray.byteOffset,
        typedArray.length
    );
}
var _cloneTypedArray = cloneTypedArray$1;
function copyArray$1(source, array) {
    var index2 = -1,
        length = source.length;
    array || (array = Array(length));
    while (++index2 < length) {
        array[index2] = source[index2];
    }
    return array;
}
var _copyArray = copyArray$1;
var isObject$5 = isObject_1;
var objectCreate = Object.create;
var baseCreate$1 = (function () {
    function object() {}
    return function (proto) {
        if (!isObject$5(proto)) {
            return {};
        }
        if (objectCreate) {
            return objectCreate(proto);
        }
        object.prototype = proto;
        var result = new object();
        object.prototype = void 0;
        return result;
    };
})();
var _baseCreate = baseCreate$1;
var overArg = _overArg;
var getPrototype$2 = overArg(Object.getPrototypeOf, Object);
var _getPrototype = getPrototype$2;
var baseCreate = _baseCreate,
    getPrototype$1 = _getPrototype,
    isPrototype$1 = _isPrototype;
function initCloneObject$1(object) {
    return typeof object.constructor == "function" && !isPrototype$1(object)
        ? baseCreate(getPrototype$1(object))
        : {};
}
var _initCloneObject = initCloneObject$1;
var isArrayLike$2 = isArrayLike_1,
    isObjectLike$1 = isObjectLike_1;
function isArrayLikeObject$1(value) {
    return isObjectLike$1(value) && isArrayLike$2(value);
}
var isArrayLikeObject_1 = isArrayLikeObject$1;
var baseGetTag = _baseGetTag,
    getPrototype = _getPrototype,
    isObjectLike = isObjectLike_1;
var objectTag = "[object Object]";
var funcProto = Function.prototype,
    objectProto$2 = Object.prototype;
var funcToString = funcProto.toString;
var hasOwnProperty$2 = objectProto$2.hasOwnProperty;
var objectCtorString = funcToString.call(Object);
function isPlainObject$1(value) {
    if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
        return false;
    }
    var proto = getPrototype(value);
    if (proto === null) {
        return true;
    }
    var Ctor = hasOwnProperty$2.call(proto, "constructor") && proto.constructor;
    return (
        typeof Ctor == "function" &&
        Ctor instanceof Ctor &&
        funcToString.call(Ctor) == objectCtorString
    );
}
var isPlainObject_1 = isPlainObject$1;
function safeGet$2(object, key) {
    if (key === "constructor" && typeof object[key] === "function") {
        return;
    }
    if (key == "__proto__") {
        return;
    }
    return object[key];
}
var _safeGet = safeGet$2;
var baseAssignValue$1 = _baseAssignValue,
    eq$1 = eq_1;
var objectProto$1 = Object.prototype;
var hasOwnProperty$1 = objectProto$1.hasOwnProperty;
function assignValue$1(object, key, value) {
    var objValue = object[key];
    if (
        !(hasOwnProperty$1.call(object, key) && eq$1(objValue, value)) ||
        (value === void 0 && !(key in object))
    ) {
        baseAssignValue$1(object, key, value);
    }
}
var _assignValue = assignValue$1;
var assignValue = _assignValue,
    baseAssignValue = _baseAssignValue;
function copyObject$1(source, props2, object, customizer) {
    var isNew = !object;
    object || (object = {});
    var index2 = -1,
        length = props2.length;
    while (++index2 < length) {
        var key = props2[index2];
        var newValue = customizer
            ? customizer(object[key], source[key], key, object, source)
            : void 0;
        if (newValue === void 0) {
            newValue = source[key];
        }
        if (isNew) {
            baseAssignValue(object, key, newValue);
        } else {
            assignValue(object, key, newValue);
        }
    }
    return object;
}
var _copyObject = copyObject$1;
function nativeKeysIn$1(object) {
    var result = [];
    if (object != null) {
        for (var key in Object(object)) {
            result.push(key);
        }
    }
    return result;
}
var _nativeKeysIn = nativeKeysIn$1;
var isObject$4 = isObject_1,
    isPrototype = _isPrototype,
    nativeKeysIn = _nativeKeysIn;
var objectProto = Object.prototype;
var hasOwnProperty = objectProto.hasOwnProperty;
function baseKeysIn$1(object) {
    if (!isObject$4(object)) {
        return nativeKeysIn(object);
    }
    var isProto = isPrototype(object),
        result = [];
    for (var key in object) {
        if (
            !(
                key == "constructor" &&
                (isProto || !hasOwnProperty.call(object, key))
            )
        ) {
            result.push(key);
        }
    }
    return result;
}
var _baseKeysIn = baseKeysIn$1;
var arrayLikeKeys = _arrayLikeKeys,
    baseKeysIn = _baseKeysIn,
    isArrayLike$1 = isArrayLike_1;
function keysIn$2(object) {
    return isArrayLike$1(object)
        ? arrayLikeKeys(object, true)
        : baseKeysIn(object);
}
var keysIn_1 = keysIn$2;
var copyObject = _copyObject,
    keysIn$1 = keysIn_1;
function toPlainObject$1(value) {
    return copyObject(value, keysIn$1(value));
}
var toPlainObject_1 = toPlainObject$1;
var assignMergeValue$1 = _assignMergeValue,
    cloneBuffer = _cloneBuffer.exports,
    cloneTypedArray = _cloneTypedArray,
    copyArray = _copyArray,
    initCloneObject = _initCloneObject,
    isArguments = isArguments_1,
    isArray$1 = isArray_1,
    isArrayLikeObject = isArrayLikeObject_1,
    isBuffer = isBuffer$3.exports,
    isFunction$1 = isFunction_1,
    isObject$3 = isObject_1,
    isPlainObject = isPlainObject_1,
    isTypedArray = isTypedArray_1,
    safeGet$1 = _safeGet,
    toPlainObject = toPlainObject_1;
function baseMergeDeep$1(
    object,
    source,
    key,
    srcIndex,
    mergeFunc,
    customizer,
    stack
) {
    var objValue = safeGet$1(object, key),
        srcValue = safeGet$1(source, key),
        stacked = stack.get(srcValue);
    if (stacked) {
        assignMergeValue$1(object, key, stacked);
        return;
    }
    var newValue = customizer
        ? customizer(objValue, srcValue, key + "", object, source, stack)
        : void 0;
    var isCommon = newValue === void 0;
    if (isCommon) {
        var isArr = isArray$1(srcValue),
            isBuff = !isArr && isBuffer(srcValue),
            isTyped = !isArr && !isBuff && isTypedArray(srcValue);
        newValue = srcValue;
        if (isArr || isBuff || isTyped) {
            if (isArray$1(objValue)) {
                newValue = objValue;
            } else if (isArrayLikeObject(objValue)) {
                newValue = copyArray(objValue);
            } else if (isBuff) {
                isCommon = false;
                newValue = cloneBuffer(srcValue, true);
            } else if (isTyped) {
                isCommon = false;
                newValue = cloneTypedArray(srcValue, true);
            } else {
                newValue = [];
            }
        } else if (isPlainObject(srcValue) || isArguments(srcValue)) {
            newValue = objValue;
            if (isArguments(objValue)) {
                newValue = toPlainObject(objValue);
            } else if (!isObject$3(objValue) || isFunction$1(objValue)) {
                newValue = initCloneObject(srcValue);
            }
        } else {
            isCommon = false;
        }
    }
    if (isCommon) {
        stack.set(srcValue, newValue);
        mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
        stack["delete"](srcValue);
    }
    assignMergeValue$1(object, key, newValue);
}
var _baseMergeDeep = baseMergeDeep$1;
var Stack = _Stack,
    assignMergeValue = _assignMergeValue,
    baseFor = _baseFor,
    baseMergeDeep = _baseMergeDeep,
    isObject$2 = isObject_1,
    keysIn = keysIn_1,
    safeGet = _safeGet;
function baseMerge$1(object, source, srcIndex, customizer, stack) {
    if (object === source) {
        return;
    }
    baseFor(
        source,
        function (srcValue, key) {
            stack || (stack = new Stack());
            if (isObject$2(srcValue)) {
                baseMergeDeep(
                    object,
                    source,
                    key,
                    srcIndex,
                    baseMerge$1,
                    customizer,
                    stack
                );
            } else {
                var newValue = customizer
                    ? customizer(
                          safeGet(object, key),
                          srcValue,
                          key + "",
                          object,
                          source,
                          stack
                      )
                    : void 0;
                if (newValue === void 0) {
                    newValue = srcValue;
                }
                assignMergeValue(object, key, newValue);
            }
        },
        keysIn
    );
}
var _baseMerge = baseMerge$1;
function identity$2(value) {
    return value;
}
var identity_1 = identity$2;
function apply$1(func, thisArg, args) {
    switch (args.length) {
        case 0:
            return func.call(thisArg);
        case 1:
            return func.call(thisArg, args[0]);
        case 2:
            return func.call(thisArg, args[0], args[1]);
        case 3:
            return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
}
var _apply = apply$1;
var apply = _apply;
var nativeMax = Math.max;
function overRest$1(func, start2, transform) {
    start2 = nativeMax(start2 === void 0 ? func.length - 1 : start2, 0);
    return function () {
        var args = arguments,
            index2 = -1,
            length = nativeMax(args.length - start2, 0),
            array = Array(length);
        while (++index2 < length) {
            array[index2] = args[start2 + index2];
        }
        index2 = -1;
        var otherArgs = Array(start2 + 1);
        while (++index2 < start2) {
            otherArgs[index2] = args[index2];
        }
        otherArgs[start2] = transform(array);
        return apply(func, this, otherArgs);
    };
}
var _overRest = overRest$1;
function constant$1(value) {
    return function () {
        return value;
    };
}
var constant_1 = constant$1;
var constant = constant_1,
    defineProperty$1 = _defineProperty,
    identity$1 = identity_1;
var baseSetToString$1 = !defineProperty$1
    ? identity$1
    : function (func, string) {
          return defineProperty$1(func, "toString", {
              configurable: true,
              enumerable: false,
              value: constant(string),
              writable: true,
          });
      };
var _baseSetToString = baseSetToString$1;
var HOT_COUNT = 800,
    HOT_SPAN = 16;
var nativeNow = Date.now;
function shortOut$1(func) {
    var count = 0,
        lastCalled = 0;
    return function () {
        var stamp = nativeNow(),
            remaining = HOT_SPAN - (stamp - lastCalled);
        lastCalled = stamp;
        if (remaining > 0) {
            if (++count >= HOT_COUNT) {
                return arguments[0];
            }
        } else {
            count = 0;
        }
        return func.apply(void 0, arguments);
    };
}
var _shortOut = shortOut$1;
var baseSetToString = _baseSetToString,
    shortOut = _shortOut;
var setToString$1 = shortOut(baseSetToString);
var _setToString = setToString$1;
var identity = identity_1,
    overRest = _overRest,
    setToString = _setToString;
function baseRest$1(func, start2) {
    return setToString(overRest(func, start2, identity), func + "");
}
var _baseRest = baseRest$1;
var eq = eq_1,
    isArrayLike = isArrayLike_1,
    isIndex = _isIndex,
    isObject$1 = isObject_1;
function isIterateeCall$1(value, index2, object) {
    if (!isObject$1(object)) {
        return false;
    }
    var type = typeof index2;
    if (
        type == "number"
            ? isArrayLike(object) && isIndex(index2, object.length)
            : type == "string" && index2 in object
    ) {
        return eq(object[index2], value);
    }
    return false;
}
var _isIterateeCall = isIterateeCall$1;
var baseRest = _baseRest,
    isIterateeCall = _isIterateeCall;
function createAssigner$1(assigner) {
    return baseRest(function (object, sources) {
        var index2 = -1,
            length = sources.length,
            customizer = length > 1 ? sources[length - 1] : void 0,
            guard = length > 2 ? sources[2] : void 0;
        customizer =
            assigner.length > 3 && typeof customizer == "function"
                ? (length--, customizer)
                : void 0;
        if (guard && isIterateeCall(sources[0], sources[1], guard)) {
            customizer = length < 3 ? void 0 : customizer;
            length = 1;
        }
        object = Object(object);
        while (++index2 < length) {
            var source = sources[index2];
            if (source) {
                assigner(object, source, index2, customizer);
            }
        }
        return object;
    });
}
var _createAssigner = createAssigner$1;
var baseMerge = _baseMerge,
    createAssigner = _createAssigner;
var merge = createAssigner(function (object, source, srcIndex) {
    baseMerge(object, source, srcIndex);
});
var merge_1 = merge;
var SVGAnimatedString = function SVGAnimatedString2() {};
if (typeof window !== "undefined") {
    SVGAnimatedString = window.SVGAnimatedString;
}
function convertToArray(value) {
    if (typeof value === "string") {
        value = value.split(" ");
    }
    return value;
}
function addClasses(el, classes) {
    var newClasses = convertToArray(classes);
    var classList;
    if (el.className instanceof SVGAnimatedString) {
        classList = convertToArray(el.className.baseVal);
    } else {
        classList = convertToArray(el.className);
    }
    newClasses.forEach(function (newClass) {
        if (classList.indexOf(newClass) === -1) {
            classList.push(newClass);
        }
    });
    if (el instanceof SVGElement) {
        el.setAttribute("class", classList.join(" "));
    } else {
        el.className = classList.join(" ");
    }
}
function removeClasses(el, classes) {
    var newClasses = convertToArray(classes);
    var classList;
    if (el.className instanceof SVGAnimatedString) {
        classList = convertToArray(el.className.baseVal);
    } else {
        classList = convertToArray(el.className);
    }
    newClasses.forEach(function (newClass) {
        var index2 = classList.indexOf(newClass);
        if (index2 !== -1) {
            classList.splice(index2, 1);
        }
    });
    if (el instanceof SVGElement) {
        el.setAttribute("class", classList.join(" "));
    } else {
        el.className = classList.join(" ");
    }
}
var supportsPassive = false;
if (typeof window !== "undefined") {
    supportsPassive = false;
    try {
        var opts = Object.defineProperty({}, "passive", {
            get: function get3() {
                supportsPassive = true;
            },
        });
        window.addEventListener("test", null, opts);
    } catch (e) {}
}
function ownKeys$2(object, enumerableOnly) {
    var keys2 = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);
        if (enumerableOnly)
            symbols = symbols.filter(function (sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            });
        keys2.push.apply(keys2, symbols);
    }
    return keys2;
}
function _objectSpread$2(target2) {
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};
        if (i % 2) {
            ownKeys$2(Object(source), true).forEach(function (key) {
                _defineProperty$1(target2, key, source[key]);
            });
        } else if (Object.getOwnPropertyDescriptors) {
            Object.defineProperties(
                target2,
                Object.getOwnPropertyDescriptors(source)
            );
        } else {
            ownKeys$2(Object(source)).forEach(function (key) {
                Object.defineProperty(
                    target2,
                    key,
                    Object.getOwnPropertyDescriptor(source, key)
                );
            });
        }
    }
    return target2;
}
var DEFAULT_OPTIONS = {
    container: false,
    delay: 0,
    html: false,
    placement: "top",
    title: "",
    template:
        '<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',
    trigger: "hover focus",
    offset: 0,
};
var openTooltips = [];
var Tooltip = /* @__PURE__ */ (function () {
    function Tooltip2(_reference, _options) {
        var _this = this;
        _classCallCheck(this, Tooltip2);
        _defineProperty$1(this, "_events", []);
        _defineProperty$1(
            this,
            "_setTooltipNodeEvent",
            function (evt, reference, delay, options) {
                var relatedreference =
                    evt.relatedreference || evt.toElement || evt.relatedTarget;
                var callback = function callback2(evt2) {
                    var relatedreference2 =
                        evt2.relatedreference ||
                        evt2.toElement ||
                        evt2.relatedTarget;
                    _this._tooltipNode.removeEventListener(evt.type, callback2);
                    if (!reference.contains(relatedreference2)) {
                        _this._scheduleHide(
                            reference,
                            options.delay,
                            options,
                            evt2
                        );
                    }
                };
                if (_this._tooltipNode.contains(relatedreference)) {
                    _this._tooltipNode.addEventListener(evt.type, callback);
                    return true;
                }
                return false;
            }
        );
        _options = _objectSpread$2(
            _objectSpread$2({}, DEFAULT_OPTIONS),
            _options
        );
        _reference.jquery && (_reference = _reference[0]);
        this.show = this.show.bind(this);
        this.hide = this.hide.bind(this);
        this.reference = _reference;
        this.options = _options;
        this._isOpen = false;
        this._init();
    }
    _createClass(Tooltip2, [
        {
            key: "show",
            value: function show3() {
                this._show(this.reference, this.options);
            },
        },
        {
            key: "hide",
            value: function hide3() {
                this._hide();
            },
        },
        {
            key: "dispose",
            value: function dispose2() {
                this._dispose();
            },
        },
        {
            key: "toggle",
            value: function toggle() {
                if (this._isOpen) {
                    return this.hide();
                } else {
                    return this.show();
                }
            },
        },
        {
            key: "setClasses",
            value: function setClasses2(classes) {
                this._classes = classes;
            },
        },
        {
            key: "setContent",
            value: function setContent(content) {
                this.options.title = content;
                if (this._tooltipNode) {
                    this._setContent(content, this.options);
                }
            },
        },
        {
            key: "setOptions",
            value: function setOptions2(options) {
                var classesUpdated = false;
                var classes =
                    (options && options.classes) ||
                    directive.options.defaultClass;
                if (!isEqual_1(this._classes, classes)) {
                    this.setClasses(classes);
                    classesUpdated = true;
                }
                options = getOptions$2(options);
                var needPopperUpdate = false;
                var needRestart = false;
                if (
                    this.options.offset !== options.offset ||
                    this.options.placement !== options.placement
                ) {
                    needPopperUpdate = true;
                }
                if (
                    this.options.template !== options.template ||
                    this.options.trigger !== options.trigger ||
                    this.options.container !== options.container ||
                    classesUpdated
                ) {
                    needRestart = true;
                }
                for (var key in options) {
                    this.options[key] = options[key];
                }
                if (this._tooltipNode) {
                    if (needRestart) {
                        var isOpen = this._isOpen;
                        this.dispose();
                        this._init();
                        if (isOpen) {
                            this.show();
                        }
                    } else if (needPopperUpdate) {
                        this.popperInstance.update();
                    }
                }
            },
        },
        {
            key: "_init",
            value: function _init() {
                var events2 =
                    typeof this.options.trigger === "string"
                        ? this.options.trigger.split(" ")
                        : [];
                this._isDisposed = false;
                this._enableDocumentTouch = events2.indexOf("manual") === -1;
                events2 = events2.filter(function (trigger3) {
                    return ["click", "hover", "focus"].indexOf(trigger3) !== -1;
                });
                this._setEventListeners(this.reference, events2, this.options);
                this.$_originalTitle = this.reference.getAttribute("title");
                this.reference.removeAttribute("title");
                this.reference.setAttribute(
                    "data-original-title",
                    this.$_originalTitle
                );
            },
        },
        {
            key: "_create",
            value: function _create(reference, template) {
                var _this2 = this;
                var tooltipGenerator = window.document.createElement("div");
                tooltipGenerator.innerHTML = template.trim();
                var tooltipNode = tooltipGenerator.childNodes[0];
                tooltipNode.id =
                    this.options.ariaId ||
                    "tooltip_".concat(Math.random().toString(36).substr(2, 10));
                tooltipNode.setAttribute("aria-hidden", "true");
                if (
                    this.options.autoHide &&
                    this.options.trigger.indexOf("hover") !== -1
                ) {
                    tooltipNode.addEventListener("mouseenter", function (evt) {
                        return _this2._scheduleHide(
                            reference,
                            _this2.options.delay,
                            _this2.options,
                            evt
                        );
                    });
                    tooltipNode.addEventListener("click", function (evt) {
                        return _this2._scheduleHide(
                            reference,
                            _this2.options.delay,
                            _this2.options,
                            evt
                        );
                    });
                }
                return tooltipNode;
            },
        },
        {
            key: "_setContent",
            value: function _setContent(content, options) {
                var _this3 = this;
                this.asyncContent = false;
                this._applyContent(content, options).then(function () {
                    if (!_this3.popperInstance) return;
                    _this3.popperInstance.update();
                });
            },
        },
        {
            key: "_applyContent",
            value: function _applyContent(title, options) {
                var _this4 = this;
                return new Promise(function (resolve, reject) {
                    var allowHtml = options.html;
                    var rootNode = _this4._tooltipNode;
                    if (!rootNode) return;
                    var titleNode = rootNode.querySelector(
                        _this4.options.innerSelector
                    );
                    if (title.nodeType === 1) {
                        if (allowHtml) {
                            while (titleNode.firstChild) {
                                titleNode.removeChild(titleNode.firstChild);
                            }
                            titleNode.appendChild(title);
                        }
                    } else if (typeof title === "function") {
                        var result = title();
                        if (result && typeof result.then === "function") {
                            _this4.asyncContent = true;
                            options.loadingClass &&
                                addClasses(rootNode, options.loadingClass);
                            if (options.loadingContent) {
                                _this4._applyContent(
                                    options.loadingContent,
                                    options
                                );
                            }
                            result
                                .then(function (asyncResult) {
                                    options.loadingClass &&
                                        removeClasses(
                                            rootNode,
                                            options.loadingClass
                                        );
                                    return _this4._applyContent(
                                        asyncResult,
                                        options
                                    );
                                })
                                .then(resolve)
                                .catch(reject);
                        } else {
                            _this4
                                ._applyContent(result, options)
                                .then(resolve)
                                .catch(reject);
                        }
                        return;
                    } else {
                        allowHtml
                            ? (titleNode.innerHTML = title)
                            : (titleNode.innerText = title);
                    }
                    resolve();
                });
            },
        },
        {
            key: "_show",
            value: function _show(reference, options) {
                if (options && typeof options.container === "string") {
                    var container2 = document.querySelector(options.container);
                    if (!container2) return;
                }
                clearTimeout(this._disposeTimer);
                options = Object.assign({}, options);
                delete options.offset;
                var updateClasses = true;
                if (this._tooltipNode) {
                    addClasses(this._tooltipNode, this._classes);
                    updateClasses = false;
                }
                var result = this._ensureShown(reference, options);
                if (updateClasses && this._tooltipNode) {
                    addClasses(this._tooltipNode, this._classes);
                }
                addClasses(reference, ["v-tooltip-open"]);
                return result;
            },
        },
        {
            key: "_ensureShown",
            value: function _ensureShown(reference, options) {
                var _this5 = this;
                if (this._isOpen) {
                    return this;
                }
                this._isOpen = true;
                openTooltips.push(this);
                if (this._tooltipNode) {
                    this._tooltipNode.style.display = "";
                    this._tooltipNode.setAttribute("aria-hidden", "false");
                    this.popperInstance.enableEventListeners();
                    this.popperInstance.update();
                    if (this.asyncContent) {
                        this._setContent(options.title, options);
                    }
                    return this;
                }
                var title = reference.getAttribute("title") || options.title;
                if (!title) {
                    return this;
                }
                var tooltipNode = this._create(reference, options.template);
                this._tooltipNode = tooltipNode;
                reference.setAttribute("aria-describedby", tooltipNode.id);
                var container2 = this._findContainer(
                    options.container,
                    reference
                );
                this._append(tooltipNode, container2);
                var popperOptions = _objectSpread$2(
                    _objectSpread$2({}, options.popperOptions),
                    {},
                    {
                        placement: options.placement,
                    }
                );
                popperOptions.modifiers = _objectSpread$2(
                    _objectSpread$2({}, popperOptions.modifiers),
                    {},
                    {
                        arrow: {
                            element: this.options.arrowSelector,
                        },
                    }
                );
                if (options.boundariesElement) {
                    popperOptions.modifiers.preventOverflow = {
                        boundariesElement: options.boundariesElement,
                    };
                }
                this.popperInstance = new Popper$1(
                    reference,
                    tooltipNode,
                    popperOptions
                );
                this._setContent(title, options);
                requestAnimationFrame(function () {
                    if (!_this5._isDisposed && _this5.popperInstance) {
                        _this5.popperInstance.update();
                        requestAnimationFrame(function () {
                            if (!_this5._isDisposed) {
                                _this5._isOpen &&
                                    tooltipNode.setAttribute(
                                        "aria-hidden",
                                        "false"
                                    );
                            } else {
                                _this5.dispose();
                            }
                        });
                    } else {
                        _this5.dispose();
                    }
                });
                return this;
            },
        },
        {
            key: "_noLongerOpen",
            value: function _noLongerOpen() {
                var index2 = openTooltips.indexOf(this);
                if (index2 !== -1) {
                    openTooltips.splice(index2, 1);
                }
            },
        },
        {
            key: "_hide",
            value: function _hide() {
                var _this6 = this;
                if (!this._isOpen) {
                    return this;
                }
                this._isOpen = false;
                this._noLongerOpen();
                this._tooltipNode.style.display = "none";
                this._tooltipNode.setAttribute("aria-hidden", "true");
                if (this.popperInstance) {
                    this.popperInstance.disableEventListeners();
                }
                clearTimeout(this._disposeTimer);
                var disposeTime = directive.options.disposeTimeout;
                if (disposeTime !== null) {
                    this._disposeTimer = setTimeout(function () {
                        if (_this6._tooltipNode) {
                            _this6._tooltipNode.removeEventListener(
                                "mouseenter",
                                _this6.hide
                            );
                            _this6._tooltipNode.removeEventListener(
                                "click",
                                _this6.hide
                            );
                            _this6._removeTooltipNode();
                        }
                    }, disposeTime);
                }
                removeClasses(this.reference, ["v-tooltip-open"]);
                return this;
            },
        },
        {
            key: "_removeTooltipNode",
            value: function _removeTooltipNode() {
                if (!this._tooltipNode) return;
                var parentNode2 = this._tooltipNode.parentNode;
                if (parentNode2) {
                    parentNode2.removeChild(this._tooltipNode);
                    this.reference.removeAttribute("aria-describedby");
                }
                this._tooltipNode = null;
            },
        },
        {
            key: "_dispose",
            value: function _dispose() {
                var _this7 = this;
                this._isDisposed = true;
                this.reference.removeAttribute("data-original-title");
                if (this.$_originalTitle) {
                    this.reference.setAttribute("title", this.$_originalTitle);
                }
                this._events.forEach(function (_ref) {
                    var func = _ref.func,
                        event2 = _ref.event;
                    _this7.reference.removeEventListener(event2, func);
                });
                this._events = [];
                if (this._tooltipNode) {
                    this._hide();
                    this._tooltipNode.removeEventListener(
                        "mouseenter",
                        this.hide
                    );
                    this._tooltipNode.removeEventListener("click", this.hide);
                    this.popperInstance.destroy();
                    if (!this.popperInstance.options.removeOnDestroy) {
                        this._removeTooltipNode();
                    }
                } else {
                    this._noLongerOpen();
                }
                return this;
            },
        },
        {
            key: "_findContainer",
            value: function _findContainer(container2, reference) {
                if (typeof container2 === "string") {
                    container2 = window.document.querySelector(container2);
                } else if (container2 === false) {
                    container2 = reference.parentNode;
                }
                return container2;
            },
        },
        {
            key: "_append",
            value: function _append(tooltipNode, container2) {
                container2.appendChild(tooltipNode);
            },
        },
        {
            key: "_setEventListeners",
            value: function _setEventListeners(reference, events2, options) {
                var _this8 = this;
                var directEvents = [];
                var oppositeEvents = [];
                events2.forEach(function (event2) {
                    switch (event2) {
                        case "hover":
                            directEvents.push("mouseenter");
                            oppositeEvents.push("mouseleave");
                            if (_this8.options.hideOnTargetClick)
                                oppositeEvents.push("click");
                            break;
                        case "focus":
                            directEvents.push("focus");
                            oppositeEvents.push("blur");
                            if (_this8.options.hideOnTargetClick)
                                oppositeEvents.push("click");
                            break;
                        case "click":
                            directEvents.push("click");
                            oppositeEvents.push("click");
                            break;
                    }
                });
                directEvents.forEach(function (event2) {
                    var func = function func2(evt) {
                        if (_this8._isOpen === true) {
                            return;
                        }
                        evt.usedByTooltip = true;
                        _this8._scheduleShow(
                            reference,
                            options.delay,
                            options,
                            evt
                        );
                    };
                    _this8._events.push({
                        event: event2,
                        func,
                    });
                    reference.addEventListener(event2, func);
                });
                oppositeEvents.forEach(function (event2) {
                    var func = function func2(evt) {
                        if (evt.usedByTooltip === true) {
                            return;
                        }
                        _this8._scheduleHide(
                            reference,
                            options.delay,
                            options,
                            evt
                        );
                    };
                    _this8._events.push({
                        event: event2,
                        func,
                    });
                    reference.addEventListener(event2, func);
                });
            },
        },
        {
            key: "_onDocumentTouch",
            value: function _onDocumentTouch(event2) {
                if (this._enableDocumentTouch) {
                    this._scheduleHide(
                        this.reference,
                        this.options.delay,
                        this.options,
                        event2
                    );
                }
            },
        },
        {
            key: "_scheduleShow",
            value: function _scheduleShow(reference, delay, options) {
                var _this9 = this;
                var computedDelay = (delay && delay.show) || delay || 0;
                clearTimeout(this._scheduleTimer);
                this._scheduleTimer = window.setTimeout(function () {
                    return _this9._show(reference, options);
                }, computedDelay);
            },
        },
        {
            key: "_scheduleHide",
            value: function _scheduleHide(reference, delay, options, evt) {
                var _this10 = this;
                var computedDelay = (delay && delay.hide) || delay || 0;
                clearTimeout(this._scheduleTimer);
                this._scheduleTimer = window.setTimeout(function () {
                    if (_this10._isOpen === false) {
                        return;
                    }
                    if (
                        !_this10._tooltipNode.ownerDocument.body.contains(
                            _this10._tooltipNode
                        )
                    ) {
                        return;
                    }
                    if (evt.type === "mouseleave") {
                        var isSet = _this10._setTooltipNodeEvent(
                            evt,
                            reference,
                            delay,
                            options
                        );
                        if (isSet) {
                            return;
                        }
                    }
                    _this10._hide(reference, options);
                }, computedDelay);
            },
        },
    ]);
    return Tooltip2;
})();
if (typeof document !== "undefined") {
    document.addEventListener(
        "touchstart",
        function (event2) {
            for (var i = 0; i < openTooltips.length; i++) {
                openTooltips[i]._onDocumentTouch(event2);
            }
        },
        supportsPassive
            ? {
                  passive: true,
                  capture: true,
              }
            : true
    );
}
function ownKeys$1(object, enumerableOnly) {
    var keys2 = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);
        if (enumerableOnly)
            symbols = symbols.filter(function (sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            });
        keys2.push.apply(keys2, symbols);
    }
    return keys2;
}
function _objectSpread$1(target2) {
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};
        if (i % 2) {
            ownKeys$1(Object(source), true).forEach(function (key) {
                _defineProperty$1(target2, key, source[key]);
            });
        } else if (Object.getOwnPropertyDescriptors) {
            Object.defineProperties(
                target2,
                Object.getOwnPropertyDescriptors(source)
            );
        } else {
            ownKeys$1(Object(source)).forEach(function (key) {
                Object.defineProperty(
                    target2,
                    key,
                    Object.getOwnPropertyDescriptor(source, key)
                );
            });
        }
    }
    return target2;
}
var state$1 = {
    enabled: true,
};
var positions = [
    "top",
    "top-start",
    "top-end",
    "right",
    "right-start",
    "right-end",
    "bottom",
    "bottom-start",
    "bottom-end",
    "left",
    "left-start",
    "left-end",
];
var defaultOptions$1 = {
    defaultPlacement: "top",
    defaultClass: "vue-tooltip-theme",
    defaultTargetClass: "has-tooltip",
    defaultHtml: true,
    defaultTemplate:
        '<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',
    defaultArrowSelector: ".tooltip-arrow, .tooltip__arrow",
    defaultInnerSelector: ".tooltip-inner, .tooltip__inner",
    defaultDelay: 0,
    defaultTrigger: "hover focus",
    defaultOffset: 0,
    defaultContainer: "body",
    defaultBoundariesElement: void 0,
    defaultPopperOptions: {},
    defaultLoadingClass: "tooltip-loading",
    defaultLoadingContent: "...",
    autoHide: true,
    defaultHideOnTargetClick: true,
    disposeTimeout: 5e3,
    popover: {
        defaultPlacement: "bottom",
        defaultClass: "vue-popover-theme",
        defaultBaseClass: "tooltip popover",
        defaultWrapperClass: "wrapper",
        defaultInnerClass: "tooltip-inner popover-inner",
        defaultArrowClass: "tooltip-arrow popover-arrow",
        defaultOpenClass: "open",
        defaultDelay: 0,
        defaultTrigger: "click",
        defaultOffset: 0,
        defaultContainer: "body",
        defaultBoundariesElement: void 0,
        defaultPopperOptions: {},
        defaultAutoHide: true,
        defaultHandleResize: true,
    },
};
function getOptions$2(options) {
    var result = {
        placement:
            typeof options.placement !== "undefined"
                ? options.placement
                : directive.options.defaultPlacement,
        delay:
            typeof options.delay !== "undefined"
                ? options.delay
                : directive.options.defaultDelay,
        html:
            typeof options.html !== "undefined"
                ? options.html
                : directive.options.defaultHtml,
        template:
            typeof options.template !== "undefined"
                ? options.template
                : directive.options.defaultTemplate,
        arrowSelector:
            typeof options.arrowSelector !== "undefined"
                ? options.arrowSelector
                : directive.options.defaultArrowSelector,
        innerSelector:
            typeof options.innerSelector !== "undefined"
                ? options.innerSelector
                : directive.options.defaultInnerSelector,
        trigger:
            typeof options.trigger !== "undefined"
                ? options.trigger
                : directive.options.defaultTrigger,
        offset:
            typeof options.offset !== "undefined"
                ? options.offset
                : directive.options.defaultOffset,
        container:
            typeof options.container !== "undefined"
                ? options.container
                : directive.options.defaultContainer,
        boundariesElement:
            typeof options.boundariesElement !== "undefined"
                ? options.boundariesElement
                : directive.options.defaultBoundariesElement,
        autoHide:
            typeof options.autoHide !== "undefined"
                ? options.autoHide
                : directive.options.autoHide,
        hideOnTargetClick:
            typeof options.hideOnTargetClick !== "undefined"
                ? options.hideOnTargetClick
                : directive.options.defaultHideOnTargetClick,
        loadingClass:
            typeof options.loadingClass !== "undefined"
                ? options.loadingClass
                : directive.options.defaultLoadingClass,
        loadingContent:
            typeof options.loadingContent !== "undefined"
                ? options.loadingContent
                : directive.options.defaultLoadingContent,
        popperOptions: _objectSpread$1(
            {},
            typeof options.popperOptions !== "undefined"
                ? options.popperOptions
                : directive.options.defaultPopperOptions
        ),
    };
    if (result.offset) {
        var typeofOffset = _typeof(result.offset);
        var offset2 = result.offset;
        if (
            typeofOffset === "number" ||
            (typeofOffset === "string" && offset2.indexOf(",") === -1)
        ) {
            offset2 = "0, ".concat(offset2);
        }
        if (!result.popperOptions.modifiers) {
            result.popperOptions.modifiers = {};
        }
        result.popperOptions.modifiers.offset = {
            offset: offset2,
        };
    }
    if (result.trigger && result.trigger.indexOf("click") !== -1) {
        result.hideOnTargetClick = false;
    }
    return result;
}
function getPlacement(value, modifiers2) {
    var placement2 = value.placement;
    for (var i = 0; i < positions.length; i++) {
        var pos = positions[i];
        if (modifiers2[pos]) {
            placement2 = pos;
        }
    }
    return placement2;
}
function getContent(value) {
    var type = _typeof(value);
    if (type === "string") {
        return value;
    } else if (value && type === "object") {
        return value.content;
    } else {
        return false;
    }
}
function createTooltip(el, value) {
    var modifiers2 =
        arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
    var content = getContent(value);
    var classes =
        typeof value.classes !== "undefined"
            ? value.classes
            : directive.options.defaultClass;
    var opts = _objectSpread$1(
        {
            title: content,
        },
        getOptions$2(
            _objectSpread$1(
                _objectSpread$1({}, _typeof(value) === "object" ? value : {}),
                {},
                {
                    placement: getPlacement(value, modifiers2),
                }
            )
        )
    );
    var tooltip = (el._tooltip = new Tooltip(el, opts));
    tooltip.setClasses(classes);
    tooltip._vueEl = el;
    var targetClasses =
        typeof value.targetClasses !== "undefined"
            ? value.targetClasses
            : directive.options.defaultTargetClass;
    el._tooltipTargetClasses = targetClasses;
    addClasses(el, targetClasses);
    return tooltip;
}
function destroyTooltip(el) {
    if (el._tooltip) {
        el._tooltip.dispose();
        delete el._tooltip;
        delete el._tooltipOldShow;
    }
    if (el._tooltipTargetClasses) {
        removeClasses(el, el._tooltipTargetClasses);
        delete el._tooltipTargetClasses;
    }
}
function bind3(el, _ref) {
    var value = _ref.value;
    _ref.oldValue;
    var modifiers2 = _ref.modifiers;
    var content = getContent(value);
    if (!content || !state$1.enabled) {
        destroyTooltip(el);
    } else {
        var tooltip;
        if (el._tooltip) {
            tooltip = el._tooltip;
            tooltip.setContent(content);
            tooltip.setOptions(
                _objectSpread$1(
                    _objectSpread$1({}, value),
                    {},
                    {
                        placement: getPlacement(value, modifiers2),
                    }
                )
            );
        } else {
            tooltip = createTooltip(el, value, modifiers2);
        }
        if (
            typeof value.show !== "undefined" &&
            value.show !== el._tooltipOldShow
        ) {
            el._tooltipOldShow = value.show;
            value.show ? tooltip.show() : tooltip.hide();
        }
    }
}
var directive = {
    options: defaultOptions$1,
    bind: bind3,
    update: bind3,
    unbind: function unbind(el) {
        destroyTooltip(el);
    },
};
function addListeners(el) {
    el.addEventListener("click", onClick);
    el.addEventListener(
        "touchstart",
        onTouchStart,
        supportsPassive
            ? {
                  passive: true,
              }
            : false
    );
}
function removeListeners(el) {
    el.removeEventListener("click", onClick);
    el.removeEventListener("touchstart", onTouchStart);
    el.removeEventListener("touchend", onTouchEnd);
    el.removeEventListener("touchcancel", onTouchCancel);
}
function onClick(event2) {
    var el = event2.currentTarget;
    event2.closePopover = !el.$_vclosepopover_touch;
    event2.closeAllPopover =
        el.$_closePopoverModifiers && !!el.$_closePopoverModifiers.all;
}
function onTouchStart(event2) {
    if (event2.changedTouches.length === 1) {
        var el = event2.currentTarget;
        el.$_vclosepopover_touch = true;
        var touch = event2.changedTouches[0];
        el.$_vclosepopover_touchPoint = touch;
        el.addEventListener("touchend", onTouchEnd);
        el.addEventListener("touchcancel", onTouchCancel);
    }
}
function onTouchEnd(event2) {
    var el = event2.currentTarget;
    el.$_vclosepopover_touch = false;
    if (event2.changedTouches.length === 1) {
        var touch = event2.changedTouches[0];
        var firstTouch = el.$_vclosepopover_touchPoint;
        event2.closePopover =
            Math.abs(touch.screenY - firstTouch.screenY) < 20 &&
            Math.abs(touch.screenX - firstTouch.screenX) < 20;
        event2.closeAllPopover =
            el.$_closePopoverModifiers && !!el.$_closePopoverModifiers.all;
    }
}
function onTouchCancel(event2) {
    var el = event2.currentTarget;
    el.$_vclosepopover_touch = false;
}
var vclosepopover = {
    bind: function bind4(el, _ref) {
        var value = _ref.value,
            modifiers2 = _ref.modifiers;
        el.$_closePopoverModifiers = modifiers2;
        if (typeof value === "undefined" || value) {
            addListeners(el);
        }
    },
    update: function update2(el, _ref2) {
        var value = _ref2.value,
            oldValue = _ref2.oldValue,
            modifiers2 = _ref2.modifiers;
        el.$_closePopoverModifiers = modifiers2;
        if (value !== oldValue) {
            if (typeof value === "undefined" || value) {
                addListeners(el);
            } else {
                removeListeners(el);
            }
        }
    },
    unbind: function unbind2(el) {
        removeListeners(el);
    },
};
function ownKeys(object, enumerableOnly) {
    var keys2 = Object.keys(object);
    if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);
        if (enumerableOnly)
            symbols = symbols.filter(function (sym) {
                return Object.getOwnPropertyDescriptor(object, sym).enumerable;
            });
        keys2.push.apply(keys2, symbols);
    }
    return keys2;
}
function _objectSpread(target2) {
    for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};
        if (i % 2) {
            ownKeys(Object(source), true).forEach(function (key) {
                _defineProperty$1(target2, key, source[key]);
            });
        } else if (Object.getOwnPropertyDescriptors) {
            Object.defineProperties(
                target2,
                Object.getOwnPropertyDescriptors(source)
            );
        } else {
            ownKeys(Object(source)).forEach(function (key) {
                Object.defineProperty(
                    target2,
                    key,
                    Object.getOwnPropertyDescriptor(source, key)
                );
            });
        }
    }
    return target2;
}
function getDefault(key) {
    var value = directive.options.popover[key];
    if (typeof value === "undefined") {
        return directive.options[key];
    }
    return value;
}
var isIOS = false;
if (typeof window !== "undefined" && typeof navigator !== "undefined") {
    isIOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;
}
var openPopovers = [];
var Element$1 = function Element2() {};
if (typeof window !== "undefined") {
    Element$1 = window.Element;
}
var script = {
    name: "VPopover",
    components: {
        ResizeObserver: __vue_component__$1,
    },
    props: {
        open: {
            type: Boolean,
            default: false,
        },
        disabled: {
            type: Boolean,
            default: false,
        },
        placement: {
            type: String,
            default: function _default() {
                return getDefault("defaultPlacement");
            },
        },
        delay: {
            type: [String, Number, Object],
            default: function _default2() {
                return getDefault("defaultDelay");
            },
        },
        offset: {
            type: [String, Number],
            default: function _default3() {
                return getDefault("defaultOffset");
            },
        },
        trigger: {
            type: String,
            default: function _default4() {
                return getDefault("defaultTrigger");
            },
        },
        container: {
            type: [String, Object, Element$1, Boolean],
            default: function _default5() {
                return getDefault("defaultContainer");
            },
        },
        boundariesElement: {
            type: [String, Element$1],
            default: function _default6() {
                return getDefault("defaultBoundariesElement");
            },
        },
        popperOptions: {
            type: Object,
            default: function _default7() {
                return getDefault("defaultPopperOptions");
            },
        },
        popoverClass: {
            type: [String, Array],
            default: function _default8() {
                return getDefault("defaultClass");
            },
        },
        popoverBaseClass: {
            type: [String, Array],
            default: function _default9() {
                return directive.options.popover.defaultBaseClass;
            },
        },
        popoverInnerClass: {
            type: [String, Array],
            default: function _default10() {
                return directive.options.popover.defaultInnerClass;
            },
        },
        popoverWrapperClass: {
            type: [String, Array],
            default: function _default11() {
                return directive.options.popover.defaultWrapperClass;
            },
        },
        popoverArrowClass: {
            type: [String, Array],
            default: function _default12() {
                return directive.options.popover.defaultArrowClass;
            },
        },
        autoHide: {
            type: Boolean,
            default: function _default13() {
                return directive.options.popover.defaultAutoHide;
            },
        },
        handleResize: {
            type: Boolean,
            default: function _default14() {
                return directive.options.popover.defaultHandleResize;
            },
        },
        openGroup: {
            type: String,
            default: null,
        },
        openClass: {
            type: [String, Array],
            default: function _default15() {
                return directive.options.popover.defaultOpenClass;
            },
        },
        ariaId: {
            default: null,
        },
    },
    data: function data2() {
        return {
            isOpen: false,
            id: Math.random().toString(36).substr(2, 10),
        };
    },
    computed: {
        cssClass: function cssClass() {
            return _defineProperty$1({}, this.openClass, this.isOpen);
        },
        popoverId: function popoverId() {
            return "popover_".concat(
                this.ariaId != null ? this.ariaId : this.id
            );
        },
    },
    watch: {
        open: function open(val) {
            if (val) {
                this.show();
            } else {
                this.hide();
            }
        },
        disabled: function disabled(val, oldVal) {
            if (val !== oldVal) {
                if (val) {
                    this.hide();
                } else if (this.open) {
                    this.show();
                }
            }
        },
        container: function container(val) {
            if (this.isOpen && this.popperInstance) {
                var popoverNode = this.$refs.popover;
                var reference = this.$refs.trigger;
                var container2 = this.$_findContainer(
                    this.container,
                    reference
                );
                if (!container2) {
                    console.warn("No container for popover", this);
                    return;
                }
                container2.appendChild(popoverNode);
                this.popperInstance.scheduleUpdate();
            }
        },
        trigger: function trigger2(val) {
            this.$_removeEventListeners();
            this.$_addEventListeners();
        },
        placement: function placement(val) {
            var _this = this;
            this.$_updatePopper(function () {
                _this.popperInstance.options.placement = val;
            });
        },
        offset: "$_restartPopper",
        boundariesElement: "$_restartPopper",
        popperOptions: {
            handler: "$_restartPopper",
            deep: true,
        },
    },
    created: function created() {
        this.$_isDisposed = false;
        this.$_mounted = false;
        this.$_events = [];
        this.$_preventOpen = false;
    },
    mounted: function mounted2() {
        var popoverNode = this.$refs.popover;
        popoverNode.parentNode &&
            popoverNode.parentNode.removeChild(popoverNode);
        this.$_init();
        if (this.open) {
            this.show();
        }
    },
    deactivated: function deactivated() {
        this.hide();
    },
    beforeDestroy: function beforeDestroy2() {
        this.dispose();
    },
    methods: {
        show: function show2() {
            var _this2 = this;
            var _ref2 =
                    arguments.length > 0 && arguments[0] !== void 0
                        ? arguments[0]
                        : {},
                event2 = _ref2.event;
            _ref2.skipDelay;
            var _ref2$force = _ref2.force,
                force = _ref2$force === void 0 ? false : _ref2$force;
            if (force || !this.disabled) {
                this.$_scheduleShow(event2);
                this.$emit("show");
            }
            this.$emit("update:open", true);
            this.$_beingShowed = true;
            requestAnimationFrame(function () {
                _this2.$_beingShowed = false;
            });
        },
        hide: function hide2() {
            var _ref3 =
                    arguments.length > 0 && arguments[0] !== void 0
                        ? arguments[0]
                        : {},
                event2 = _ref3.event;
            _ref3.skipDelay;
            this.$_scheduleHide(event2);
            this.$emit("hide");
            this.$emit("update:open", false);
        },
        dispose: function dispose() {
            this.$_isDisposed = true;
            this.$_removeEventListeners();
            this.hide({
                skipDelay: true,
            });
            if (this.popperInstance) {
                this.popperInstance.destroy();
                if (!this.popperInstance.options.removeOnDestroy) {
                    var popoverNode = this.$refs.popover;
                    popoverNode.parentNode &&
                        popoverNode.parentNode.removeChild(popoverNode);
                }
            }
            this.$_mounted = false;
            this.popperInstance = null;
            this.isOpen = false;
            this.$emit("dispose");
        },
        $_init: function $_init() {
            if (this.trigger.indexOf("manual") === -1) {
                this.$_addEventListeners();
            }
        },
        $_show: function $_show() {
            var _this3 = this;
            var reference = this.$refs.trigger;
            var popoverNode = this.$refs.popover;
            clearTimeout(this.$_disposeTimer);
            if (this.isOpen) {
                return;
            }
            if (this.popperInstance) {
                this.isOpen = true;
                this.popperInstance.enableEventListeners();
                this.popperInstance.scheduleUpdate();
            }
            if (!this.$_mounted) {
                var container2 = this.$_findContainer(
                    this.container,
                    reference
                );
                if (!container2) {
                    console.warn("No container for popover", this);
                    return;
                }
                container2.appendChild(popoverNode);
                this.$_mounted = true;
                this.isOpen = false;
                if (this.popperInstance) {
                    requestAnimationFrame(function () {
                        if (!_this3.hidden) {
                            _this3.isOpen = true;
                        }
                    });
                }
            }
            if (!this.popperInstance) {
                var popperOptions = _objectSpread(
                    _objectSpread({}, this.popperOptions),
                    {},
                    {
                        placement: this.placement,
                    }
                );
                popperOptions.modifiers = _objectSpread(
                    _objectSpread({}, popperOptions.modifiers),
                    {},
                    {
                        arrow: _objectSpread(
                            _objectSpread(
                                {},
                                popperOptions.modifiers &&
                                    popperOptions.modifiers.arrow
                            ),
                            {},
                            {
                                element: this.$refs.arrow,
                            }
                        ),
                    }
                );
                if (this.offset) {
                    var offset2 = this.$_getOffset();
                    popperOptions.modifiers.offset = _objectSpread(
                        _objectSpread(
                            {},
                            popperOptions.modifiers &&
                                popperOptions.modifiers.offset
                        ),
                        {},
                        {
                            offset: offset2,
                        }
                    );
                }
                if (this.boundariesElement) {
                    popperOptions.modifiers.preventOverflow = _objectSpread(
                        _objectSpread(
                            {},
                            popperOptions.modifiers &&
                                popperOptions.modifiers.preventOverflow
                        ),
                        {},
                        {
                            boundariesElement: this.boundariesElement,
                        }
                    );
                }
                this.popperInstance = new Popper$1(
                    reference,
                    popoverNode,
                    popperOptions
                );
                requestAnimationFrame(function () {
                    if (_this3.hidden) {
                        _this3.hidden = false;
                        _this3.$_hide();
                        return;
                    }
                    if (!_this3.$_isDisposed && _this3.popperInstance) {
                        _this3.popperInstance.scheduleUpdate();
                        requestAnimationFrame(function () {
                            if (_this3.hidden) {
                                _this3.hidden = false;
                                _this3.$_hide();
                                return;
                            }
                            if (!_this3.$_isDisposed) {
                                _this3.isOpen = true;
                            } else {
                                _this3.dispose();
                            }
                        });
                    } else {
                        _this3.dispose();
                    }
                });
            }
            var openGroup = this.openGroup;
            if (openGroup) {
                var popover;
                for (var i = 0; i < openPopovers.length; i++) {
                    popover = openPopovers[i];
                    if (popover.openGroup !== openGroup) {
                        popover.hide();
                        popover.$emit("close-group");
                    }
                }
            }
            openPopovers.push(this);
            this.$emit("apply-show");
        },
        $_hide: function $_hide() {
            var _this4 = this;
            if (!this.isOpen) {
                return;
            }
            var index2 = openPopovers.indexOf(this);
            if (index2 !== -1) {
                openPopovers.splice(index2, 1);
            }
            this.isOpen = false;
            if (this.popperInstance) {
                this.popperInstance.disableEventListeners();
            }
            clearTimeout(this.$_disposeTimer);
            var disposeTime =
                directive.options.popover.disposeTimeout ||
                directive.options.disposeTimeout;
            if (disposeTime !== null) {
                this.$_disposeTimer = setTimeout(function () {
                    var popoverNode = _this4.$refs.popover;
                    if (popoverNode) {
                        popoverNode.parentNode &&
                            popoverNode.parentNode.removeChild(popoverNode);
                        _this4.$_mounted = false;
                    }
                }, disposeTime);
            }
            this.$emit("apply-hide");
        },
        $_findContainer: function $_findContainer(container2, reference) {
            if (typeof container2 === "string") {
                container2 = window.document.querySelector(container2);
            } else if (container2 === false) {
                container2 = reference.parentNode;
            }
            return container2;
        },
        $_getOffset: function $_getOffset() {
            var typeofOffset = _typeof(this.offset);
            var offset2 = this.offset;
            if (
                typeofOffset === "number" ||
                (typeofOffset === "string" && offset2.indexOf(",") === -1)
            ) {
                offset2 = "0, ".concat(offset2);
            }
            return offset2;
        },
        $_addEventListeners: function $_addEventListeners() {
            var _this5 = this;
            var reference = this.$refs.trigger;
            var directEvents = [];
            var oppositeEvents = [];
            var events2 =
                typeof this.trigger === "string"
                    ? this.trigger.split(" ").filter(function (trigger3) {
                          return (
                              ["click", "hover", "focus"].indexOf(trigger3) !==
                              -1
                          );
                      })
                    : [];
            events2.forEach(function (event2) {
                switch (event2) {
                    case "hover":
                        directEvents.push("mouseenter");
                        oppositeEvents.push("mouseleave");
                        break;
                    case "focus":
                        directEvents.push("focus");
                        oppositeEvents.push("blur");
                        break;
                    case "click":
                        directEvents.push("click");
                        oppositeEvents.push("click");
                        break;
                }
            });
            directEvents.forEach(function (event2) {
                var func = function func2(event3) {
                    if (_this5.isOpen) {
                        return;
                    }
                    event3.usedByTooltip = true;
                    !_this5.$_preventOpen &&
                        _this5.show({
                            event: event3,
                        });
                    _this5.hidden = false;
                };
                _this5.$_events.push({
                    event: event2,
                    func,
                });
                reference.addEventListener(event2, func);
            });
            oppositeEvents.forEach(function (event2) {
                var func = function func2(event3) {
                    if (event3.usedByTooltip) {
                        return;
                    }
                    _this5.hide({
                        event: event3,
                    });
                    _this5.hidden = true;
                };
                _this5.$_events.push({
                    event: event2,
                    func,
                });
                reference.addEventListener(event2, func);
            });
        },
        $_scheduleShow: function $_scheduleShow() {
            var skipDelay =
                arguments.length > 1 && arguments[1] !== void 0
                    ? arguments[1]
                    : false;
            clearTimeout(this.$_scheduleTimer);
            if (skipDelay) {
                this.$_show();
            } else {
                var computedDelay = parseInt(
                    (this.delay && this.delay.show) || this.delay || 0
                );
                this.$_scheduleTimer = setTimeout(
                    this.$_show.bind(this),
                    computedDelay
                );
            }
        },
        $_scheduleHide: function $_scheduleHide() {
            var _this6 = this;
            var event2 =
                arguments.length > 0 && arguments[0] !== void 0
                    ? arguments[0]
                    : null;
            var skipDelay =
                arguments.length > 1 && arguments[1] !== void 0
                    ? arguments[1]
                    : false;
            clearTimeout(this.$_scheduleTimer);
            if (skipDelay) {
                this.$_hide();
            } else {
                var computedDelay = parseInt(
                    (this.delay && this.delay.hide) || this.delay || 0
                );
                this.$_scheduleTimer = setTimeout(function () {
                    if (!_this6.isOpen) {
                        return;
                    }
                    if (event2 && event2.type === "mouseleave") {
                        var isSet = _this6.$_setTooltipNodeEvent(event2);
                        if (isSet) {
                            return;
                        }
                    }
                    _this6.$_hide();
                }, computedDelay);
            }
        },
        $_setTooltipNodeEvent: function $_setTooltipNodeEvent(event2) {
            var _this7 = this;
            var reference = this.$refs.trigger;
            var popoverNode = this.$refs.popover;
            var relatedreference =
                event2.relatedreference ||
                event2.toElement ||
                event2.relatedTarget;
            var callback = function callback2(event22) {
                var relatedreference2 =
                    event22.relatedreference ||
                    event22.toElement ||
                    event22.relatedTarget;
                popoverNode.removeEventListener(event2.type, callback2);
                if (!reference.contains(relatedreference2)) {
                    _this7.hide({
                        event: event22,
                    });
                }
            };
            if (popoverNode.contains(relatedreference)) {
                popoverNode.addEventListener(event2.type, callback);
                return true;
            }
            return false;
        },
        $_removeEventListeners: function $_removeEventListeners() {
            var reference = this.$refs.trigger;
            this.$_events.forEach(function (_ref4) {
                var func = _ref4.func,
                    event2 = _ref4.event;
                reference.removeEventListener(event2, func);
            });
            this.$_events = [];
        },
        $_updatePopper: function $_updatePopper(cb) {
            if (this.popperInstance) {
                cb();
                if (this.isOpen) this.popperInstance.scheduleUpdate();
            }
        },
        $_restartPopper: function $_restartPopper() {
            if (this.popperInstance) {
                var isOpen = this.isOpen;
                this.dispose();
                this.$_isDisposed = false;
                this.$_init();
                if (isOpen) {
                    this.show({
                        skipDelay: true,
                        force: true,
                    });
                }
            }
        },
        $_handleGlobalClose: function $_handleGlobalClose(event2) {
            var _this8 = this;
            var touch =
                arguments.length > 1 && arguments[1] !== void 0
                    ? arguments[1]
                    : false;
            if (this.$_beingShowed) return;
            this.hide({
                event: event2,
            });
            if (event2.closePopover) {
                this.$emit("close-directive");
            } else {
                this.$emit("auto-hide");
            }
            if (touch) {
                this.$_preventOpen = true;
                setTimeout(function () {
                    _this8.$_preventOpen = false;
                }, 300);
            }
        },
        $_handleResize: function $_handleResize() {
            if (this.isOpen && this.popperInstance) {
                this.popperInstance.scheduleUpdate();
                this.$emit("resize");
            }
        },
    },
};
if (typeof document !== "undefined" && typeof window !== "undefined") {
    if (isIOS) {
        document.addEventListener(
            "touchend",
            handleGlobalTouchend,
            supportsPassive
                ? {
                      passive: true,
                      capture: true,
                  }
                : true
        );
    } else {
        window.addEventListener("click", handleGlobalClick, true);
    }
}
function handleGlobalClick(event2) {
    handleGlobalClose(event2);
}
function handleGlobalTouchend(event2) {
    handleGlobalClose(event2, true);
}
function handleGlobalClose(event2) {
    var touch =
        arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : false;
    var _loop = function _loop2(i2) {
        var popover = openPopovers[i2];
        if (popover.$refs.popover) {
            var contains = popover.$refs.popover.contains(event2.target);
            requestAnimationFrame(function () {
                if (
                    event2.closeAllPopover ||
                    (event2.closePopover && contains) ||
                    (popover.autoHide && !contains)
                ) {
                    popover.$_handleGlobalClose(event2, touch);
                }
            });
        }
    };
    for (var i = 0; i < openPopovers.length; i++) {
        _loop(i);
    }
}
function normalizeComponent(
    template,
    style2,
    script2,
    scopeId,
    isFunctionalTemplate,
    moduleIdentifier,
    shadowMode,
    createInjector,
    createInjectorSSR,
    createInjectorShadow
) {
    if (typeof shadowMode !== "boolean") {
        createInjectorSSR = createInjector;
        createInjector = shadowMode;
        shadowMode = false;
    }
    const options = typeof script2 === "function" ? script2.options : script2;
    if (template && template.render) {
        options.render = template.render;
        options.staticRenderFns = template.staticRenderFns;
        options._compiled = true;
        if (isFunctionalTemplate) {
            options.functional = true;
        }
    }
    if (scopeId) {
        options._scopeId = scopeId;
    }
    let hook;
    if (moduleIdentifier) {
        hook = function (context) {
            context =
                context ||
                (this.$vnode && this.$vnode.ssrContext) ||
                (this.parent &&
                    this.parent.$vnode &&
                    this.parent.$vnode.ssrContext);
            if (!context && typeof __VUE_SSR_CONTEXT__ !== "undefined") {
                context = __VUE_SSR_CONTEXT__;
            }
            if (style2) {
                style2.call(this, createInjectorSSR(context));
            }
            if (context && context._registeredComponents) {
                context._registeredComponents.add(moduleIdentifier);
            }
        };
        options._ssrRegister = hook;
    } else if (style2) {
        hook = shadowMode
            ? function (context) {
                  style2.call(
                      this,
                      createInjectorShadow(
                          context,
                          this.$root.$options.shadowRoot
                      )
                  );
              }
            : function (context) {
                  style2.call(this, createInjector(context));
              };
    }
    if (hook) {
        if (options.functional) {
            const originalRender = options.render;
            options.render = function renderWithStyleInjection(h, context) {
                hook.call(context);
                return originalRender(h, context);
            };
        } else {
            const existing = options.beforeCreate;
            options.beforeCreate = existing
                ? [].concat(existing, hook)
                : [hook];
        }
    }
    return script2;
}
var __vue_script__ = script;
var __vue_render__2 = function __vue_render__3() {
    var _vm = this;
    var _h = _vm.$createElement;
    var _c = _vm._self._c || _h;
    return _c(
        "div",
        {
            staticClass: "v-popover",
            class: _vm.cssClass,
        },
        [
            _c(
                "div",
                {
                    ref: "trigger",
                    staticClass: "trigger",
                    staticStyle: {
                        display: "inline-block",
                    },
                    attrs: {
                        "aria-describedby": _vm.isOpen ? _vm.popoverId : void 0,
                        tabindex:
                            _vm.trigger.indexOf("focus") !== -1 ? 0 : void 0,
                    },
                },
                [_vm._t("default")],
                2
            ),
            _vm._v(" "),
            _c(
                "div",
                {
                    ref: "popover",
                    class: [
                        _vm.popoverBaseClass,
                        _vm.popoverClass,
                        _vm.cssClass,
                    ],
                    style: {
                        visibility: _vm.isOpen ? "visible" : "hidden",
                    },
                    attrs: {
                        id: _vm.popoverId,
                        "aria-hidden": _vm.isOpen ? "false" : "true",
                        tabindex: _vm.autoHide ? 0 : void 0,
                    },
                    on: {
                        keyup: function keyup($event) {
                            if (
                                !$event.type.indexOf("key") &&
                                _vm._k($event.keyCode, "esc", 27, $event.key, [
                                    "Esc",
                                    "Escape",
                                ])
                            ) {
                                return null;
                            }
                            _vm.autoHide && _vm.hide();
                        },
                    },
                },
                [
                    _c(
                        "div",
                        {
                            class: _vm.popoverWrapperClass,
                        },
                        [
                            _c(
                                "div",
                                {
                                    ref: "inner",
                                    class: _vm.popoverInnerClass,
                                    staticStyle: {
                                        position: "relative",
                                    },
                                },
                                [
                                    _c(
                                        "div",
                                        [
                                            _vm._t("popover", null, {
                                                isOpen: _vm.isOpen,
                                            }),
                                        ],
                                        2
                                    ),
                                    _vm._v(" "),
                                    _vm.handleResize
                                        ? _c("ResizeObserver", {
                                              on: {
                                                  notify: _vm.$_handleResize,
                                              },
                                          })
                                        : _vm._e(),
                                ],
                                1
                            ),
                            _vm._v(" "),
                            _c("div", {
                                ref: "arrow",
                                class: _vm.popoverArrowClass,
                            }),
                        ]
                    ),
                ]
            ),
        ]
    );
};
var __vue_staticRenderFns__ = [];
__vue_render__2._withStripped = true;
var __vue_inject_styles__ = void 0;
var __vue_scope_id__ = void 0;
var __vue_module_identifier__ = void 0;
var __vue_is_functional_template__ = false;
var __vue_component__ = /* @__PURE__ */ normalizeComponent(
    {
        render: __vue_render__2,
        staticRenderFns: __vue_staticRenderFns__,
    },
    __vue_inject_styles__,
    __vue_script__,
    __vue_scope_id__,
    __vue_is_functional_template__,
    __vue_module_identifier__,
    false,
    void 0,
    void 0,
    void 0
);
function styleInject(css, ref2) {
    if (ref2 === void 0) ref2 = {};
    var insertAt = ref2.insertAt;
    if (!css || typeof document === "undefined") {
        return;
    }
    var head = document.head || document.getElementsByTagName("head")[0];
    var style2 = document.createElement("style");
    style2.type = "text/css";
    if (insertAt === "top") {
        if (head.firstChild) {
            head.insertBefore(style2, head.firstChild);
        } else {
            head.appendChild(style2);
        }
    } else {
        head.appendChild(style2);
    }
    if (style2.styleSheet) {
        style2.styleSheet.cssText = css;
    } else {
        style2.appendChild(document.createTextNode(css));
    }
}
var css_248z =
    ".resize-observer[data-v-8859cc6c]{position:absolute;top:0;left:0;z-index:-1;width:100%;height:100%;border:none;background-color:transparent;pointer-events:none;display:block;overflow:hidden;opacity:0}.resize-observer[data-v-8859cc6c] object{display:block;position:absolute;top:0;left:0;height:100%;width:100%;overflow:hidden;pointer-events:none;z-index:-1}";
styleInject(css_248z);
function install(Vue2) {
    var options =
        arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
    if (install.installed) return;
    install.installed = true;
    var finalOptions = {};
    merge_1(finalOptions, defaultOptions$1, options);
    plugin$2.options = finalOptions;
    directive.options = finalOptions;
    Vue2.directive("tooltip", directive);
    Vue2.directive("close-popover", vclosepopover);
    Vue2.component("VPopover", __vue_component__);
}
var plugin$2 = {
    install,
    get enabled() {
        return state$1.enabled;
    },
    set enabled(value) {
        state$1.enabled = value;
    },
};
var GlobalVue = null;
if (typeof window !== "undefined") {
    GlobalVue = window.Vue;
} else if (typeof global !== "undefined") {
    GlobalVue = global.Vue;
}
if (GlobalVue) {
    GlobalVue.use(plugin$2);
}
const vueLoading = "";
const index = "";
Vue.use(VueToastificationPlugin, { position: "top-center" });
Vue.use(plugin$2);
plugin$2.options.defaultTemplate =
    '<div class="tooltip-vue" role="tooltip"><div class="tooltip-vue-arrow"></div><div class="tooltip-vue-inner"></div></div>';
plugin$2.options.defaultArrowSelector =
    ".tooltip-vue-arrow, .tooltip-vue__arrow";
plugin$2.options.defaultInnerSelector =
    ".tooltip-vue-inner, .tooltip-vue__inner";
if (document.getElementById("vue-create-post")) {
    new Vue({
        render: (h) => h(CreatePost),
    }).$mount("#vue-create-post");
}
if (document.getElementById("vue-update-post")) {
    new Vue({
        render: (h) => h(UpdatePost),
    }).$mount("#vue-update-post");
}
var jquery = { exports: {} };
/*!
 * jQuery JavaScript Library v3.6.4
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 *
 */
(function (module) {
    (function (global2, factory) {
        {
            module.exports = global2.document
                ? factory(global2, true)
                : function (w) {
                      if (!w.document) {
                          throw new Error(
                              "jQuery requires a window with a document"
                          );
                      }
                      return factory(w);
                  };
        }
    })(
        typeof window !== "undefined" ? window : commonjsGlobal,
        function (window2, noGlobal) {
            var arr = [];
            var getProto2 = Object.getPrototypeOf;
            var slice = arr.slice;
            var flat = arr.flat
                ? function (array) {
                      return arr.flat.call(array);
                  }
                : function (array) {
                      return arr.concat.apply([], array);
                  };
            var push = arr.push;
            var indexOf = arr.indexOf;
            var class2type = {};
            var toString2 = class2type.toString;
            var hasOwn2 = class2type.hasOwnProperty;
            var fnToString = hasOwn2.toString;
            var ObjectFunctionString = fnToString.call(Object);
            var support = {};
            var isFunction2 = function isFunction3(obj) {
                return (
                    typeof obj === "function" &&
                    typeof obj.nodeType !== "number" &&
                    typeof obj.item !== "function"
                );
            };
            var isWindow = function isWindow2(obj) {
                return obj != null && obj === obj.window;
            };
            var document2 = window2.document;
            var preservedScriptAttributes = {
                type: true,
                src: true,
                nonce: true,
                noModule: true,
            };
            function DOMEval(code, node, doc) {
                doc = doc || document2;
                var i,
                    val,
                    script2 = doc.createElement("script");
                script2.text = code;
                if (node) {
                    for (i in preservedScriptAttributes) {
                        val =
                            node[i] ||
                            (node.getAttribute && node.getAttribute(i));
                        if (val) {
                            script2.setAttribute(i, val);
                        }
                    }
                }
                doc.head.appendChild(script2).parentNode.removeChild(script2);
            }
            function toType(obj) {
                if (obj == null) {
                    return obj + "";
                }
                return typeof obj === "object" || typeof obj === "function"
                    ? class2type[toString2.call(obj)] || "object"
                    : typeof obj;
            }
            var version2 = "3.6.1",
                jQuery = function (selector, context) {
                    return new jQuery.fn.init(selector, context);
                };
            jQuery.fn = jQuery.prototype = {
                jquery: version2,
                constructor: jQuery,
                length: 0,
                toArray: function () {
                    return slice.call(this);
                },
                get: function (num) {
                    if (num == null) {
                        return slice.call(this);
                    }
                    return num < 0 ? this[num + this.length] : this[num];
                },
                pushStack: function (elems) {
                    var ret = jQuery.merge(this.constructor(), elems);
                    ret.prevObject = this;
                    return ret;
                },
                each: function (callback) {
                    return jQuery.each(this, callback);
                },
                map: function (callback) {
                    return this.pushStack(
                        jQuery.map(this, function (elem, i) {
                            return callback.call(elem, i, elem);
                        })
                    );
                },
                slice: function () {
                    return this.pushStack(slice.apply(this, arguments));
                },
                first: function () {
                    return this.eq(0);
                },
                last: function () {
                    return this.eq(-1);
                },
                even: function () {
                    return this.pushStack(
                        jQuery.grep(this, function (_elem, i) {
                            return (i + 1) % 2;
                        })
                    );
                },
                odd: function () {
                    return this.pushStack(
                        jQuery.grep(this, function (_elem, i) {
                            return i % 2;
                        })
                    );
                },
                eq: function (i) {
                    var len = this.length,
                        j = +i + (i < 0 ? len : 0);
                    return this.pushStack(j >= 0 && j < len ? [this[j]] : []);
                },
                end: function () {
                    return this.prevObject || this.constructor();
                },
                push,
                sort: arr.sort,
                splice: arr.splice,
            };
            jQuery.extend = jQuery.fn.extend = function () {
                var options,
                    name2,
                    src,
                    copy,
                    copyIsArray,
                    clone2,
                    target2 = arguments[0] || {},
                    i = 1,
                    length = arguments.length,
                    deep = false;
                if (typeof target2 === "boolean") {
                    deep = target2;
                    target2 = arguments[i] || {};
                    i++;
                }
                if (typeof target2 !== "object" && !isFunction2(target2)) {
                    target2 = {};
                }
                if (i === length) {
                    target2 = this;
                    i--;
                }
                for (; i < length; i++) {
                    if ((options = arguments[i]) != null) {
                        for (name2 in options) {
                            copy = options[name2];
                            if (name2 === "__proto__" || target2 === copy) {
                                continue;
                            }
                            if (
                                deep &&
                                copy &&
                                (jQuery.isPlainObject(copy) ||
                                    (copyIsArray = Array.isArray(copy)))
                            ) {
                                src = target2[name2];
                                if (copyIsArray && !Array.isArray(src)) {
                                    clone2 = [];
                                } else if (
                                    !copyIsArray &&
                                    !jQuery.isPlainObject(src)
                                ) {
                                    clone2 = {};
                                } else {
                                    clone2 = src;
                                }
                                copyIsArray = false;
                                target2[name2] = jQuery.extend(
                                    deep,
                                    clone2,
                                    copy
                                );
                            } else if (copy !== void 0) {
                                target2[name2] = copy;
                            }
                        }
                    }
                }
                return target2;
            };
            jQuery.extend({
                expando:
                    "jQuery" + (version2 + Math.random()).replace(/\D/g, ""),
                isReady: true,
                error: function (msg) {
                    throw new Error(msg);
                },
                noop: function () {},
                isPlainObject: function (obj) {
                    var proto, Ctor;
                    if (!obj || toString2.call(obj) !== "[object Object]") {
                        return false;
                    }
                    proto = getProto2(obj);
                    if (!proto) {
                        return true;
                    }
                    Ctor =
                        hasOwn2.call(proto, "constructor") && proto.constructor;
                    return (
                        typeof Ctor === "function" &&
                        fnToString.call(Ctor) === ObjectFunctionString
                    );
                },
                isEmptyObject: function (obj) {
                    var name2;
                    for (name2 in obj) {
                        return false;
                    }
                    return true;
                },
                globalEval: function (code, options, doc) {
                    DOMEval(code, { nonce: options && options.nonce }, doc);
                },
                each: function (obj, callback) {
                    var length,
                        i = 0;
                    if (isArrayLike2(obj)) {
                        length = obj.length;
                        for (; i < length; i++) {
                            if (callback.call(obj[i], i, obj[i]) === false) {
                                break;
                            }
                        }
                    } else {
                        for (i in obj) {
                            if (callback.call(obj[i], i, obj[i]) === false) {
                                break;
                            }
                        }
                    }
                    return obj;
                },
                makeArray: function (arr2, results) {
                    var ret = results || [];
                    if (arr2 != null) {
                        if (isArrayLike2(Object(arr2))) {
                            jQuery.merge(
                                ret,
                                typeof arr2 === "string" ? [arr2] : arr2
                            );
                        } else {
                            push.call(ret, arr2);
                        }
                    }
                    return ret;
                },
                inArray: function (elem, arr2, i) {
                    return arr2 == null ? -1 : indexOf.call(arr2, elem, i);
                },
                merge: function (first, second) {
                    var len = +second.length,
                        j = 0,
                        i = first.length;
                    for (; j < len; j++) {
                        first[i++] = second[j];
                    }
                    first.length = i;
                    return first;
                },
                grep: function (elems, callback, invert) {
                    var callbackInverse,
                        matches2 = [],
                        i = 0,
                        length = elems.length,
                        callbackExpect = !invert;
                    for (; i < length; i++) {
                        callbackInverse = !callback(elems[i], i);
                        if (callbackInverse !== callbackExpect) {
                            matches2.push(elems[i]);
                        }
                    }
                    return matches2;
                },
                map: function (elems, callback, arg) {
                    var length,
                        value,
                        i = 0,
                        ret = [];
                    if (isArrayLike2(elems)) {
                        length = elems.length;
                        for (; i < length; i++) {
                            value = callback(elems[i], i, arg);
                            if (value != null) {
                                ret.push(value);
                            }
                        }
                    } else {
                        for (i in elems) {
                            value = callback(elems[i], i, arg);
                            if (value != null) {
                                ret.push(value);
                            }
                        }
                    }
                    return flat(ret);
                },
                guid: 1,
                support,
            });
            if (typeof Symbol === "function") {
                jQuery.fn[Symbol.iterator] = arr[Symbol.iterator];
            }
            jQuery.each(
                "Boolean Number String Function Array Date RegExp Object Error Symbol".split(
                    " "
                ),
                function (_i, name2) {
                    class2type["[object " + name2 + "]"] = name2.toLowerCase();
                }
            );
            function isArrayLike2(obj) {
                var length = !!obj && "length" in obj && obj.length,
                    type = toType(obj);
                if (isFunction2(obj) || isWindow(obj)) {
                    return false;
                }
                return (
                    type === "array" ||
                    length === 0 ||
                    (typeof length === "number" &&
                        length > 0 &&
                        length - 1 in obj)
                );
            }
            var Sizzle = (function (window3) {
                var i,
                    support2,
                    Expr,
                    getText,
                    isXML,
                    tokenize,
                    compile,
                    select,
                    outermostContext,
                    sortInput,
                    hasDuplicate,
                    setDocument,
                    document3,
                    docElem,
                    documentIsHTML,
                    rbuggyQSA,
                    rbuggyMatches,
                    matches2,
                    contains,
                    expando = "sizzle" + 1 * new Date(),
                    preferredDoc = window3.document,
                    dirruns = 0,
                    done = 0,
                    classCache = createCache(),
                    tokenCache = createCache(),
                    compilerCache = createCache(),
                    nonnativeSelectorCache = createCache(),
                    sortOrder = function (a, b) {
                        if (a === b) {
                            hasDuplicate = true;
                        }
                        return 0;
                    },
                    hasOwn3 = {}.hasOwnProperty,
                    arr2 = [],
                    pop = arr2.pop,
                    pushNative = arr2.push,
                    push2 = arr2.push,
                    slice2 = arr2.slice,
                    indexOf2 = function (list2, elem) {
                        var i2 = 0,
                            len = list2.length;
                        for (; i2 < len; i2++) {
                            if (list2[i2] === elem) {
                                return i2;
                            }
                        }
                        return -1;
                    },
                    booleans =
                        "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",
                    whitespace2 = "[\\x20\\t\\r\\n\\f]",
                    identifier =
                        "(?:\\\\[\\da-fA-F]{1,6}" +
                        whitespace2 +
                        "?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",
                    attributes =
                        "\\[" +
                        whitespace2 +
                        "*(" +
                        identifier +
                        ")(?:" +
                        whitespace2 +
                        "*([*^$|!~]?=)" +
                        whitespace2 +
                        `*(?:'((?:\\\\.|[^\\\\'])*)'|"((?:\\\\.|[^\\\\"])*)"|(` +
                        identifier +
                        "))|)" +
                        whitespace2 +
                        "*\\]",
                    pseudos =
                        ":(" +
                        identifier +
                        `)(?:\\((('((?:\\\\.|[^\\\\'])*)'|"((?:\\\\.|[^\\\\"])*)")|((?:\\\\.|[^\\\\()[\\]]|` +
                        attributes +
                        ")*)|.*)\\)|)",
                    rwhitespace = new RegExp(whitespace2 + "+", "g"),
                    rtrim2 = new RegExp(
                        "^" +
                            whitespace2 +
                            "+|((?:^|[^\\\\])(?:\\\\.)*)" +
                            whitespace2 +
                            "+$",
                        "g"
                    ),
                    rcomma = new RegExp(
                        "^" + whitespace2 + "*," + whitespace2 + "*"
                    ),
                    rcombinators = new RegExp(
                        "^" +
                            whitespace2 +
                            "*([>+~]|" +
                            whitespace2 +
                            ")" +
                            whitespace2 +
                            "*"
                    ),
                    rdescend = new RegExp(whitespace2 + "|>"),
                    rpseudo = new RegExp(pseudos),
                    ridentifier = new RegExp("^" + identifier + "$"),
                    matchExpr = {
                        ID: new RegExp("^#(" + identifier + ")"),
                        CLASS: new RegExp("^\\.(" + identifier + ")"),
                        TAG: new RegExp("^(" + identifier + "|[*])"),
                        ATTR: new RegExp("^" + attributes),
                        PSEUDO: new RegExp("^" + pseudos),
                        CHILD: new RegExp(
                            "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
                                whitespace2 +
                                "*(even|odd|(([+-]|)(\\d*)n|)" +
                                whitespace2 +
                                "*(?:([+-]|)" +
                                whitespace2 +
                                "*(\\d+)|))" +
                                whitespace2 +
                                "*\\)|)",
                            "i"
                        ),
                        bool: new RegExp("^(?:" + booleans + ")$", "i"),
                        needsContext: new RegExp(
                            "^" +
                                whitespace2 +
                                "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" +
                                whitespace2 +
                                "*((?:-\\d)?\\d*)" +
                                whitespace2 +
                                "*\\)|)(?=[^-]|$)",
                            "i"
                        ),
                    },
                    rhtml2 = /HTML$/i,
                    rinputs = /^(?:input|select|textarea|button)$/i,
                    rheader = /^h\d$/i,
                    rnative = /^[^{]+\{\s*\[native \w/,
                    rquickExpr2 = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,
                    rsibling = /[+~]/,
                    runescape = new RegExp(
                        "\\\\[\\da-fA-F]{1,6}" +
                            whitespace2 +
                            "?|\\\\([^\\r\\n\\f])",
                        "g"
                    ),
                    funescape = function (escape, nonHex) {
                        var high = "0x" + escape.slice(1) - 65536;
                        return nonHex
                            ? nonHex
                            : high < 0
                            ? String.fromCharCode(high + 65536)
                            : String.fromCharCode(
                                  (high >> 10) | 55296,
                                  (high & 1023) | 56320
                              );
                    },
                    rcssescape =
                        /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
                    fcssescape = function (ch, asCodePoint) {
                        if (asCodePoint) {
                            if (ch === "\0") {
                                return "\uFFFD";
                            }
                            return (
                                ch.slice(0, -1) +
                                "\\" +
                                ch.charCodeAt(ch.length - 1).toString(16) +
                                " "
                            );
                        }
                        return "\\" + ch;
                    },
                    unloadHandler = function () {
                        setDocument();
                    },
                    inDisabledFieldset = addCombinator(
                        function (elem) {
                            return (
                                elem.disabled === true &&
                                elem.nodeName.toLowerCase() === "fieldset"
                            );
                        },
                        { dir: "parentNode", next: "legend" }
                    );
                try {
                    push2.apply(
                        (arr2 = slice2.call(preferredDoc.childNodes)),
                        preferredDoc.childNodes
                    );
                    arr2[preferredDoc.childNodes.length].nodeType;
                } catch (e) {
                    push2 = {
                        apply: arr2.length
                            ? function (target2, els) {
                                  pushNative.apply(target2, slice2.call(els));
                              }
                            : function (target2, els) {
                                  var j = target2.length,
                                      i2 = 0;
                                  while ((target2[j++] = els[i2++])) {}
                                  target2.length = j - 1;
                              },
                    };
                }
                function Sizzle2(selector, context, results, seed) {
                    var m,
                        i2,
                        elem,
                        nid,
                        match,
                        groups,
                        newSelector,
                        newContext = context && context.ownerDocument,
                        nodeType = context ? context.nodeType : 9;
                    results = results || [];
                    if (
                        typeof selector !== "string" ||
                        !selector ||
                        (nodeType !== 1 && nodeType !== 9 && nodeType !== 11)
                    ) {
                        return results;
                    }
                    if (!seed) {
                        setDocument(context);
                        context = context || document3;
                        if (documentIsHTML) {
                            if (
                                nodeType !== 11 &&
                                (match = rquickExpr2.exec(selector))
                            ) {
                                if ((m = match[1])) {
                                    if (nodeType === 9) {
                                        if (
                                            (elem = context.getElementById(m))
                                        ) {
                                            if (elem.id === m) {
                                                results.push(elem);
                                                return results;
                                            }
                                        } else {
                                            return results;
                                        }
                                    } else {
                                        if (
                                            newContext &&
                                            (elem =
                                                newContext.getElementById(m)) &&
                                            contains(context, elem) &&
                                            elem.id === m
                                        ) {
                                            results.push(elem);
                                            return results;
                                        }
                                    }
                                } else if (match[2]) {
                                    push2.apply(
                                        results,
                                        context.getElementsByTagName(selector)
                                    );
                                    return results;
                                } else if (
                                    (m = match[3]) &&
                                    support2.getElementsByClassName &&
                                    context.getElementsByClassName
                                ) {
                                    push2.apply(
                                        results,
                                        context.getElementsByClassName(m)
                                    );
                                    return results;
                                }
                            }
                            if (
                                support2.qsa &&
                                !nonnativeSelectorCache[selector + " "] &&
                                (!rbuggyQSA || !rbuggyQSA.test(selector)) &&
                                (nodeType !== 1 ||
                                    context.nodeName.toLowerCase() !== "object")
                            ) {
                                newSelector = selector;
                                newContext = context;
                                if (
                                    nodeType === 1 &&
                                    (rdescend.test(selector) ||
                                        rcombinators.test(selector))
                                ) {
                                    newContext =
                                        (rsibling.test(selector) &&
                                            testContext(context.parentNode)) ||
                                        context;
                                    if (
                                        newContext !== context ||
                                        !support2.scope
                                    ) {
                                        if (
                                            (nid = context.getAttribute("id"))
                                        ) {
                                            nid = nid.replace(
                                                rcssescape,
                                                fcssescape
                                            );
                                        } else {
                                            context.setAttribute(
                                                "id",
                                                (nid = expando)
                                            );
                                        }
                                    }
                                    groups = tokenize(selector);
                                    i2 = groups.length;
                                    while (i2--) {
                                        groups[i2] =
                                            (nid ? "#" + nid : ":scope") +
                                            " " +
                                            toSelector(groups[i2]);
                                    }
                                    newSelector = groups.join(",");
                                }
                                try {
                                    push2.apply(
                                        results,
                                        newContext.querySelectorAll(newSelector)
                                    );
                                    return results;
                                } catch (qsaError) {
                                    nonnativeSelectorCache(selector, true);
                                } finally {
                                    if (nid === expando) {
                                        context.removeAttribute("id");
                                    }
                                }
                            }
                        }
                    }
                    return select(
                        selector.replace(rtrim2, "$1"),
                        context,
                        results,
                        seed
                    );
                }
                function createCache() {
                    var keys2 = [];
                    function cache(key, value) {
                        if (keys2.push(key + " ") > Expr.cacheLength) {
                            delete cache[keys2.shift()];
                        }
                        return (cache[key + " "] = value);
                    }
                    return cache;
                }
                function markFunction(fn2) {
                    fn2[expando] = true;
                    return fn2;
                }
                function assert(fn2) {
                    var el = document3.createElement("fieldset");
                    try {
                        return !!fn2(el);
                    } catch (e) {
                        return false;
                    } finally {
                        if (el.parentNode) {
                            el.parentNode.removeChild(el);
                        }
                        el = null;
                    }
                }
                function addHandle(attrs2, handler3) {
                    var arr3 = attrs2.split("|"),
                        i2 = arr3.length;
                    while (i2--) {
                        Expr.attrHandle[arr3[i2]] = handler3;
                    }
                }
                function siblingCheck(a, b) {
                    var cur = b && a,
                        diff =
                            cur &&
                            a.nodeType === 1 &&
                            b.nodeType === 1 &&
                            a.sourceIndex - b.sourceIndex;
                    if (diff) {
                        return diff;
                    }
                    if (cur) {
                        while ((cur = cur.nextSibling)) {
                            if (cur === b) {
                                return -1;
                            }
                        }
                    }
                    return a ? 1 : -1;
                }
                function createInputPseudo(type) {
                    return function (elem) {
                        var name2 = elem.nodeName.toLowerCase();
                        return name2 === "input" && elem.type === type;
                    };
                }
                function createButtonPseudo(type) {
                    return function (elem) {
                        var name2 = elem.nodeName.toLowerCase();
                        return (
                            (name2 === "input" || name2 === "button") &&
                            elem.type === type
                        );
                    };
                }
                function createDisabledPseudo(disabled2) {
                    return function (elem) {
                        if ("form" in elem) {
                            if (elem.parentNode && elem.disabled === false) {
                                if ("label" in elem) {
                                    if ("label" in elem.parentNode) {
                                        return (
                                            elem.parentNode.disabled ===
                                            disabled2
                                        );
                                    } else {
                                        return elem.disabled === disabled2;
                                    }
                                }
                                return (
                                    elem.isDisabled === disabled2 ||
                                    (elem.isDisabled !== !disabled2 &&
                                        inDisabledFieldset(elem) === disabled2)
                                );
                            }
                            return elem.disabled === disabled2;
                        } else if ("label" in elem) {
                            return elem.disabled === disabled2;
                        }
                        return false;
                    };
                }
                function createPositionalPseudo(fn2) {
                    return markFunction(function (argument) {
                        argument = +argument;
                        return markFunction(function (seed, matches3) {
                            var j,
                                matchIndexes = fn2([], seed.length, argument),
                                i2 = matchIndexes.length;
                            while (i2--) {
                                if (seed[(j = matchIndexes[i2])]) {
                                    seed[j] = !(matches3[j] = seed[j]);
  