"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dateUtils = require("@wojtekmaj/date-utils");
var _Divider = _interopRequireDefault(require("./Divider"));
var _Hour12Input = _interopRequireDefault(require("./TimeInput/Hour12Input"));
var _Hour24Input = _interopRequireDefault(require("./TimeInput/Hour24Input"));
var _MinuteInput = _interopRequireDefault(require("./TimeInput/MinuteInput"));
var _SecondInput = _interopRequireDefault(require("./TimeInput/SecondInput"));
var _NativeInput = _interopRequireDefault(require("./TimeInput/NativeInput"));
var _AmPm = _interopRequireDefault(require("./TimeInput/AmPm"));
var _dateFormatter = require("./shared/dateFormatter");
var _dates = require("./shared/dates");
var _propTypes2 = require("./shared/propTypes");
var _utils = require("./shared/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArrayLimit(arr, i) { var _i = null == arr ? null : "undefined" != typeof Symbol && arr[Symbol.iterator] || arr["@@iterator"]; if (null != _i) { var _s, _e, _x, _r, _arr = [], _n = !0, _d = !1; try { if (_x = (_i = _i.call(arr)).next, 0 === i) { if (Object(_i) !== _i) return; _n = !1; } else for (; !(_n = (_s = _x.call(_i)).done) && (_arr.push(_s.value), _arr.length !== i); _n = !0); } catch (err) { _d = !0, _e = err; } finally { try { if (!_n && null != _i["return"] && (_r = _i["return"](), Object(_r) !== _r)) return; } finally { if (_d) throw _e; } } return _arr; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var getFormatterOptionsCache = {};
var allViews = ['hour', 'minute', 'second'];
function hoursAreDifferent(date1, date2) {
  return date1 && !date2 || !date1 && date2 || date1 && date2 && date1 !== date2 // TODO: Compare 11:22:00 and 11:22 properly
  ;
}

function isInternalInput(element) {
  return element.dataset.input === 'true';
}
function findInput(element, property) {
  var nextElement = element;
  do {
    nextElement = nextElement[property];
  } while (nextElement && !isInternalInput(nextElement));
  return nextElement;
}
function focus(element) {
  if (element) {
    element.focus();
  }
}
function _renderCustomInputs(placeholder, elementFunctions, allowMultipleInstances) {
  var usedFunctions = [];
  var pattern = new RegExp(Object.keys(elementFunctions).map(function (el) {
    return "".concat(el, "+");
  }).join('|'), 'g');
  var matches = placeholder.match(pattern);
  return placeholder.split(pattern).reduce(function (arr, element, index) {
    var divider = element &&
    /*#__PURE__*/
    // eslint-disable-next-line react/no-array-index-key
    _react["default"].createElement(_Divider["default"], {
      key: "separator_".concat(index)
    }, element);
    var res = [].concat(_toConsumableArray(arr), [divider]);
    var currentMatch = matches && matches[index];
    if (currentMatch) {
      var renderFunction = elementFunctions[currentMatch] || elementFunctions[Object.keys(elementFunctions).find(function (elementFunction) {
        return currentMatch.match(elementFunction);
      })];
      if (!allowMultipleInstances && usedFunctions.includes(renderFunction)) {
        res.push(currentMatch);
      } else {
        res.push(renderFunction(currentMatch, index));
        usedFunctions.push(renderFunction);
      }
    }
    return res;
  }, []);
}
var formatNumber = (0, _dateFormatter.getNumberFormatter)({
  useGrouping: false
});
var TimeInput = /*#__PURE__*/function (_PureComponent) {
  _inherits(TimeInput, _PureComponent);
  var _super = _createSuper(TimeInput);
  function TimeInput() {
    var _this;
    _classCallCheck(this, TimeInput);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "state", {
      amPm: null,
      hour: null,
      minute: null,
      second: null
    });
    _defineProperty(_assertThisInitialized(_this), "amPmInput", /*#__PURE__*/(0, _react.createRef)());
    _defineProperty(_assertThisInitialized(_this), "hour12Input", /*#__PURE__*/(0, _react.createRef)());
    _defineProperty(_assertThisInitialized(_this), "hour24Input", /*#__PURE__*/(0, _react.createRef)());
    _defineProperty(_assertThisInitialized(_this), "minuteInput", /*#__PURE__*/(0, _react.createRef)());
    _defineProperty(_assertThisInitialized(_this), "secondInput", /*#__PURE__*/(0, _react.createRef)());
    _defineProperty(_assertThisInitialized(_this), "onClick", function (event) {
      if (event.target === event.currentTarget) {
        // Wrapper was directly clicked
        var firstInput = event.target.children[1];
        focus(firstInput);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onKeyDown", function (event) {
      switch (event.key) {
        case 'ArrowLeft':
        case 'ArrowRight':
        case _this.divider:
          {
            event.preventDefault();
            var input = event.target;
            var property = event.key === 'ArrowLeft' ? 'previousElementSibling' : 'nextElementSibling';
            var nextInput = findInput(input, property);
            focus(nextInput);
            break;
          }
        default:
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onKeyUp", function (event) {
      var key = event.key,
        input = event.target;
      var isNumberKey = !isNaN(parseInt(key, 10));
      if (!isNumberKey) {
        return;
      }
      var value = input.value;
      var max = input.getAttribute('max');

      /**
       * Given 1, the smallest possible number the user could type by adding another digit is 10.
       * 10 would be a valid value given max = 12, so we won't jump to the next input.
       * However, given 2, smallers possible number would be 20, and thus keeping the focus in
       * this field doesn't make sense.
       */
      if (value * 10 > max || value.length >= max.length) {
        var property = 'nextElementSibling';
        var nextInput = findInput(input, property);
        focus(nextInput);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onChange", function (event) {
      var _event$target = event.target,
        name = _event$target.name,
        value = _event$target.value;
      switch (name) {
        case 'hour12':
          {
            _this.setState(function (prevState) {
              return {
                hour: value ? (0, _dates.convert12to24)(parseInt(value, 10), prevState.amPm).toString() : ''
              };
            }, _this.onChangeExternal);
            break;
          }
        case 'hour24':
          {
            _this.setState({
              hour: value
            }, _this.onChangeExternal);
            break;
          }
        default:
          {
            _this.setState(_defineProperty({}, name, value), _this.onChangeExternal);
          }
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onChangeNative", function (event) {
      var onChange = _this.props.onChange;
      var value = event.target.value;
      if (!onChange) {
        return;
      }
      var processedValue = function () {
        if (!value) {
          return null;
        }
        return value;
      }();
      onChange(processedValue, false);
    });
    _defineProperty(_assertThisInitialized(_this), "onChangeAmPm", function (event) {
      var value = event.target.value;
      _this.setState({
        amPm: value
      }, _this.onChangeExternal);
    });
    _defineProperty(_assertThisInitialized(_this), "onChangeExternal", function () {
      var onChange = _this.props.onChange;
      if (!onChange) {
        return;
      }
      var formElements = [_this.amPmInput.current, _this.hour12Input.current, _this.hour24Input.current, _this.minuteInput.current, _this.secondInput.current].filter(Boolean);
      var formElementsWithoutSelect = formElements.slice(1);
      var values = {};
      formElements.forEach(function (formElement) {
        values[formElement.name] = formElement.value;
      });
      if (formElementsWithoutSelect.every(function (formElement) {
        return !formElement.value;
      })) {
        onChange(null, false);
      } else if (formElements.every(function (formElement) {
        return formElement.value && formElement.validity.valid;
      })) {
        var hour = parseInt(values.hour24 || (0, _dates.convert12to24)(values.hour12, values.amPm) || 0, 10);
        var minute = parseInt(values.minute || 0, 10);
        var second = parseInt(values.second || 0, 10);
        var padStart = function padStart(num) {
          return "0".concat(num).slice(-2);
        };
        var proposedValue = "".concat(padStart(hour), ":").concat(padStart(minute), ":").concat(padStart(second));
        var processedValue = _this.getProcessedValue(proposedValue);
        onChange(processedValue, false);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "renderHour", function (currentMatch, index) {
      if (/h/.test(currentMatch)) {
        return _this.renderHour12(currentMatch, index);
      }
      return _this.renderHour24(currentMatch, index);
    });
    _defineProperty(_assertThisInitialized(_this), "renderHour12", function (currentMatch, index) {
      var _this$props = _this.props,
        autoFocus = _this$props.autoFocus,
        hourAriaLabel = _this$props.hourAriaLabel,
        hourPlaceholder = _this$props.hourPlaceholder;
      var _this$state = _this.state,
        amPm = _this$state.amPm,
        hour = _this$state.hour;
      if (currentMatch && currentMatch.length > 2) {
        throw new Error("Unsupported token: ".concat(currentMatch));
      }
      var showLeadingZeros = currentMatch && currentMatch.length === 2;
      return /*#__PURE__*/_react["default"].createElement(_Hour12Input["default"], _extends({
        key: "hour12"
      }, _this.commonInputProps, {
        amPm: amPm,
        ariaLabel: hourAriaLabel
        // eslint-disable-next-line jsx-a11y/no-autofocus
        ,
        autoFocus: index === 0 && autoFocus,
        inputRef: _this.hour12Input,
        placeholder: hourPlaceholder,
        showLeadingZeros: showLeadingZeros,
        value: hour
      }));
    });
    _defineProperty(_assertThisInitialized(_this), "renderHour24", function (currentMatch, index) {
      var _this$props2 = _this.props,
        autoFocus = _this$props2.autoFocus,
        hourAriaLabel = _this$props2.hourAriaLabel,
        hourPlaceholder = _this$props2.hourPlaceholder;
      var hour = _this.state.hour;
      if (currentMatch && currentMatch.length > 2) {
        throw new Error("Unsupported token: ".concat(currentMatch));
      }
      var showLeadingZeros = currentMatch && currentMatch.length === 2;
      return /*#__PURE__*/_react["default"].createElement(_Hour24Input["default"], _extends({
        key: "hour24"
      }, _this.commonInputProps, {
        ariaLabel: hourAriaLabel
        // eslint-disable-next-line jsx-a11y/no-autofocus
        ,
        autoFocus: index === 0 && autoFocus,
        inputRef: _this.hour24Input,
        placeholder: hourPlaceholder,
        showLeadingZeros: showLeadingZeros,
        value: hour
      }));
    });
    _defineProperty(_assertThisInitialized(_this), "renderMinute", function (currentMatch, index) {
      var _this$props3 = _this.props,
        autoFocus = _this$props3.autoFocus,
        minuteAriaLabel = _this$props3.minuteAriaLabel,
        minutePlaceholder = _this$props3.minutePlaceholder;
      var _this$state2 = _this.state,
        hour = _this$state2.hour,
        minute = _this$state2.minute;
      if (currentMatch && currentMatch.length > 2) {
        throw new Error("Unsupported token: ".concat(currentMatch));
      }
      var showLeadingZeros = currentMatch && currentMatch.length === 2;
      return /*#__PURE__*/_react["default"].createElement(_MinuteInput["default"], _extends({
        key: "minute"
      }, _this.commonInputProps, {
        ariaLabel: minuteAriaLabel
        // eslint-disable-next-line jsx-a11y/no-autofocus
        ,
        autoFocus: index === 0 && autoFocus,
        hour: hour,
        inputRef: _this.minuteInput,
        placeholder: minutePlaceholder,
        showLeadingZeros: showLeadingZeros,
        value: minute
      }));
    });
    _defineProperty(_assertThisInitialized(_this), "renderSecond", function (currentMatch, index) {
      var _this$props4 = _this.props,
        autoFocus = _this$props4.autoFocus,
        secondAriaLabel = _this$props4.secondAriaLabel,
        secondPlaceholder = _this$props4.secondPlaceholder;
      var _this$state3 = _this.state,
        hour = _this$state3.hour,
        minute = _this$state3.minute,
        second = _this$state3.second;
      if (currentMatch && currentMatch.length > 2) {
        throw new Error("Unsupported token: ".concat(currentMatch));
      }
      var showLeadingZeros = currentMatch ? currentMatch.length === 2 : true;
      return /*#__PURE__*/_react["default"].createElement(_SecondInput["default"], _extends({
        key: "second"
      }, _this.commonInputProps, {
        ariaLabel: secondAriaLabel
        // eslint-disable-next-line jsx-a11y/no-autofocus
        ,
        autoFocus: index === 0 && autoFocus,
        hour: hour,
        inputRef: _this.secondInput,
        minute: minute,
        placeholder: secondPlaceholder,
        showLeadingZeros: showLeadingZeros,
        value: second
      }));
    });
    _defineProperty(_assertThisInitialized(_this), "renderAmPm", function (currentMatch, index) {
      var _this$props5 = _this.props,
        amPmAriaLabel = _this$props5.amPmAriaLabel,
        autoFocus = _this$props5.autoFocus,
        locale = _this$props5.locale;
      var amPm = _this.state.amPm;
      return /*#__PURE__*/_react["default"].createElement(_AmPm["default"], _extends({
        key: "ampm"
      }, _this.commonInputProps, {
        ariaLabel: amPmAriaLabel
        // eslint-disable-next-line jsx-a11y/no-autofocus
        ,
        autoFocus: index === 0 && autoFocus,
        inputRef: _this.amPmInput,
        locale: locale,
        onChange: _this.onChangeAmPm,
        value: amPm
      }));
    });
    return _this;
  }
  _createClass(TimeInput, [{
    key: "formatTime",
    get: function get() {
      var maxDetail = this.props.maxDetail;
      var level = allViews.indexOf(maxDetail);
      var formatterOptions = getFormatterOptionsCache[level] || function () {
        var options = {
          hour: 'numeric'
        };
        if (level >= 1) {
          options.minute = 'numeric';
        }
        if (level >= 2) {
          options.second = 'numeric';
        }
        getFormatterOptionsCache[level] = options;
        return options;
      }();
      return (0, _dateFormatter.getFormatter)(formatterOptions);
    }
  }, {
    key: "formatNumber",
    get: function get() {
      return formatNumber;
    }

    /**
     * Gets current value in a desired format.
     */
  }, {
    key: "getProcessedValue",
    value: function getProcessedValue(value) {
      var _this2 = this;
      var processFunction = function () {
        switch (_this2.valueType) {
          case 'hour':
          case 'minute':
            return _dateUtils.getHoursMinutes;
          case 'second':
            return _dateUtils.getHoursMinutesSeconds;
          default:
            throw new Error('Invalid valueType.');
        }
      }();
      return processFunction(value);
    }

    /**
     * Returns value type that can be returned with currently applied settings.
     */
  }, {
    key: "valueType",
    get: function get() {
      var maxDetail = this.props.maxDetail;
      return maxDetail;
    }
  }, {
    key: "divider",
    get: function get() {
      var dividers = this.placeholder.match(/[^0-9a-z]/i);
      return dividers ? dividers[0] : null;
    }
  }, {
    key: "placeholder",
    get: function get() {
      var _this$props6 = this.props,
        format = _this$props6.format,
        locale = _this$props6.locale;
      if (format) {
        return format;
      }
      var hour24 = 21;
      var hour12 = 9;
      var minute = 13;
      var second = 14;
      var date = new Date(2017, 0, 1, hour24, minute, second);
      return this.formatTime(locale, date).replace(this.formatNumber(locale, hour12), 'h').replace(this.formatNumber(locale, hour24), 'H').replace(this.formatNumber(locale, minute), 'mm').replace(this.formatNumber(locale, second), 'ss').replace(new RegExp((0, _utils.getAmPmLabels)(locale).join('|')), 'a');
    }
  }, {
    key: "commonInputProps",
    get: function get() {
      var _this$props7 = this.props,
        className = _this$props7.className,
        disabled = _this$props7.disabled,
        isClockOpen = _this$props7.isClockOpen,
        maxTime = _this$props7.maxTime,
        minTime = _this$props7.minTime,
        required = _this$props7.required;
      return {
        className: className,
        disabled: disabled,
        maxTime: maxTime,
        minTime: minTime,
        onChange: this.onChange,
        onKeyDown: this.onKeyDown,
        onKeyUp: this.onKeyUp,
        placeholder: '--',
        // This is only for showing validity when editing
        required: required || isClockOpen
      };
    }
  }, {
    key: "renderCustomInputs",
    value: function renderCustomInputs() {
      var placeholder = this.placeholder;
      var format = this.props.format;
      var elementFunctions = {
        h: this.renderHour,
        H: this.renderHour,
        m: this.renderMinute,
        s: this.renderSecond,
        a: this.renderAmPm
      };
      var allowMultipleInstances = typeof format !== 'undefined';
      return _renderCustomInputs(placeholder, elementFunctions, allowMultipleInstances);
    }
  }, {
    key: "renderNativeInput",
    value: function renderNativeInput() {
      var _this$props8 = this.props,
        disabled = _this$props8.disabled,
        maxTime = _this$props8.maxTime,
        minTime = _this$props8.minTime,
        name = _this$props8.name,
        nativeInputAriaLabel = _this$props8.nativeInputAriaLabel,
        required = _this$props8.required,
        value = _this$props8.value;
      return /*#__PURE__*/_react["default"].createElement(_NativeInput["default"], {
        key: "time",
        ariaLabel: nativeInputAriaLabel,
        disabled: disabled,
        maxTime: maxTime,
        minTime: minTime,
        name: name,
        onChange: this.onChangeNative,
        required: required,
        value: value,
        valueType: this.valueType
      });
    }
  }, {
    key: "render",
    value: function render() {
      var className = this.props.className;
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
        _react["default"].createElement("div", {
          className: className,
          onClick: this.onClick
        }, this.renderNativeInput(), this.renderCustomInputs())
      );
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var nextState = {};

      /**
       * If isClockOpen flag has changed, we have to update it.
       * It's saved in state purely for use in getDerivedStateFromProps.
       */
      if (nextProps.isClockOpen !== prevState.isClockOpen) {
        nextState.isClockOpen = nextProps.isClockOpen;
      }

      /**
       * If the next value is different from the current one  (with an exception of situation in
       * which values provided are limited by minDate and maxDate so that the dates are the same),
       * get a new one.
       */
      var nextValue = nextProps.value;
      if (
      // Toggling calendar visibility resets values
      nextState.isClockOpen ||
      // Flag was toggled
      hoursAreDifferent(nextValue, prevState.value)) {
        if (nextValue) {
          var _convert24to = (0, _dates.convert24to12)((0, _dateUtils.getHours)(nextValue));
          var _convert24to2 = _slicedToArray(_convert24to, 2);
          nextState.amPm = _convert24to2[1];
          nextState.hour = (0, _dateUtils.getHours)(nextValue).toString();
          nextState.minute = (0, _dateUtils.getMinutes)(nextValue).toString();
          nextState.second = (0, _dateUtils.getSeconds)(nextValue).toString();
        } else {
          nextState.amPm = null;
          nextState.hour = null;
          nextState.minute = null;
          nextState.second = null;
        }
        nextState.value = nextValue;
      }
      return nextState;
    }
  }]);
  return TimeInput;
}(_react.PureComponent);
exports["default"] = TimeInput;
TimeInput.defaultProps = {
  maxDetail: 'minute',
  name: 'time'
};
TimeInput.propTypes = {
  amPmAriaLabel: _propTypes["default"].string,
  autoFocus: _propTypes["default"].bool,
  className: _propTypes["default"].string.isRequired,
  disabled: _propTypes["default"].bool,
  format: _propTypes["default"].string,
  hourAriaLabel: _propTypes["default"].string,
  hourPlaceholder: _propTypes["default"].string,
  isClockOpen: _propTypes["default"].bool,
  locale: _propTypes["default"].string,
  maxDetail: _propTypes["default"].oneOf(allViews),
  maxTime: _propTypes2.isTime,
  minTime: _propTypes2.isTime,
  minuteAriaLabel: _propTypes["default"].string,
  minutePlaceholder: _propTypes["default"].string,
  name: _propTypes["default"].string,
  nativeInputAriaLabel: _propTypes["default"].string,
  onChange: _propTypes["default"].func,
  required: _propTypes["default"].bool,
  secondAriaLabel: _propTypes["default"].string,
  secondPlaceholder: _propTypes["default"].string,
  value: _propTypes["default"].oneOfType([_propTypes2.isTime, _propTypes["default"].instanceOf(Date)])
};