import { Connector } from './connector';
import { AblyChannel, AblyPrivateChannel, AblyPresenceChannel, AblyAuth } from './../channel';
import { AblyRealtime } from '../../typings/ably';
/**
 * This class creates a connector to Ably.
 */
export declare class AblyConnector extends Connector {
    /**
     * The laravel-echo library version.
     */
    static LIB_VERSION: string;
    /**
     * The Ably instance.
     */
    ably: AblyRealtime;
    /**
     * All of the subscribed channel names.
     */
    channels: Record<string, AblyChannel>;
    /**
     * Auth instance containing all explicit channel authz ops.
     */
    ablyAuth: AblyAuth;
    /**
     * Create a fresh Ably connection.
     */
    connect(): void;
    /**
     * Listen for an event on a channel instance.
     */
    listen(name: string, event: string, callback: Function): AblyChannel;
    /**
     * Get a channel instance by name.
     */
    channel(name: string): AblyChannel;
    /**
     * Get a private channel instance by name.
     */
    privateChannel(name: string): AblyPrivateChannel;
    /**
     * Get a presence channel instance by name.
     */
    presenceChannel(name: string): AblyPresenceChannel;
    /**
     * Leave the given channel, as well as its private and presence variants.
     */
    leave(name: string): void;
    /**
     * Leave the given channel.
     */
    leaveChannel(name: string): void;
    /**
     * Get the socket ID for the connection.
     */
    socketId(): string;
    /**
     * Disconnect Ably connection.
     */
    disconnect(): void;
}
