import { AblyRealtime, AblyRealtimeChannel } from '../../typings/ably';
import { EventFormatter } from '../util';
import { Channel } from './channel';
/**
 * This class represents an Ably channel.
 */
export declare class AblyChannel extends Channel {
    /**
     * The Ably client instance.
     */
    ably: AblyRealtime;
    /**
     * The name of the channel.
     */
    name: string;
    /**
     * Channel options.
     */
    options: any;
    /**
     * The event formatter.
     */
    eventFormatter: EventFormatter;
    /**
     * The subscription of the channel.
     */
    channel: AblyRealtimeChannel;
    /**
     * An array containing all registered subscribed listeners.
     */
    subscribedListeners: Function[];
    /**
     * An array containing all registered error listeners.
     */
    errorListeners: Function[];
    /**
     * Channel event subscribe callbacks, maps callback to modified implementation.
     */
    callbacks: Map<Function, Function>;
    /**
     * Create a new class instance.
     */
    constructor(ably: any, name: string, options: any, autoSubscribe?: boolean);
    /**
     * Subscribe to an Ably channel.
     */
    subscribe(): any;
    /**
     * Unsubscribe from an Ably channel, unregister all callbacks and finally detach the channel
     */
    unsubscribe(): void;
    /**
     * Listen for an event on the channel instance.
     */
    listen(event: string, callback: Function): AblyChannel;
    /**
     * Listen for all events on the channel instance.
     */
    listenToAll(callback: Function): AblyChannel;
    /**
     * Stop listening for an event on the channel instance.
     */
    stopListening(event: string, callback?: Function): AblyChannel;
    /**
     * Stop listening for all events on the channel instance.
     */
    stopListeningToAll(callback?: Function): AblyChannel;
    /**
     * Register a callback to be called anytime a subscription succeeds.
     */
    subscribed(callback: Function): AblyChannel;
    /**
     * Register a callback to be called anytime a subscription error occurs.
     */
    error(callback: Function): AblyChannel;
    /**
     * Unregisters given error callback from the listeners.
     * @param callback
     * @returns AblyChannel
     */
    unregisterSubscribed(callback?: Function): AblyChannel;
    /**
     * Unregisters given error callback from the listeners.
     * @param callback
     * @returns AblyChannel
     */
    unregisterError(callback?: Function): AblyChannel;
    _alertErrorListeners: (err: any) => void;
}
