<?php
// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Retrieve and sanitize form data
    $name = isset($_POST["name"]) ? htmlspecialchars($_POST["name"]) : "";
    $notable_achievements = isset($_POST["notable_achievements"]) ? htmlspecialchars($_POST["notable_achievements"]) : "";
    $sport = isset($_POST["sport"]) ? htmlspecialchars($_POST["sport"]) : "";
    $position = isset($_POST["position"]) ? htmlspecialchars($_POST["position"]) : "";
    $current_team_club = isset($_POST["current_team_club"]) ? htmlspecialchars($_POST["current_team_club"]) : "";
    $email = isset($_POST["email"]) ? htmlspecialchars($_POST["email"]) : "";
    $contact = isset($_POST["contact"]) ? htmlspecialchars($_POST["contact"]) : "";
    $address = isset($_POST["address"]) ? htmlspecialchars($_POST["address"]) : "";
    $years_of_experience = isset($_POST["years_of_experience"]) ? htmlspecialchars($_POST["years_of_experience"]) : "";
    $notable_achievements_2 = isset($_POST["notable_achievements_2"]) ? htmlspecialchars($_POST["notable_achievements_2"]) : "";
    $previous_team_clubs = isset($_POST["previous_team_clubs"]) ? htmlspecialchars($_POST["previous_team_clubs"]) : "";
    $awards_honors = isset($_POST["awards_honors"]) ? htmlspecialchars($_POST["awards_honors"]) : "";
    $short_term_goals = isset($_POST["short_term_goals"]) ? htmlspecialchars($_POST["short_term_goals"]) : "";
    $long_term_goals = isset($_POST["long_term_goals"]) ? htmlspecialchars($_POST["long_term_goals"]) : "";
    $achieve_with_us = isset($_POST["achieve_with_us"]) ? htmlspecialchars($_POST["achieve_with_us"]) : "";
    $social_media_handles = isset($_POST["social_media_handles"]) ? htmlspecialchars($_POST["social_media_handles"]) : "";
    $current_sponsorships_endorsements = isset($_POST["current_sponsorships_endorsements"]) ? htmlspecialchars($_POST["current_sponsorships_endorsements"]) : "";
    $desired_sponsorship = isset($_POST["desired_sponsorship"]) ? htmlspecialchars($_POST["desired_sponsorship"]) : "";
    $work_with_management_team = isset($_POST["work_with_management_team"]) ? htmlspecialchars($_POST["work_with_management_team"]) : "";
    $sets_apart_from_other_athletes = isset($_POST["sets_apart_from_other_athletes"]) ? htmlspecialchars($_POST["sets_apart_from_other_athletes"]) : "";
    $additional_information = isset($_POST["additional_information"]) ? htmlspecialchars($_POST["additional_information"]) : "";
    $bio = isset($_POST["bio"]) ? htmlspecialchars($_POST["bio"]) : "";  // Fixed case sensitivity issue

    // Validate required fields
    if (empty($name) || empty($email) || empty($contact) || empty($sport)) {
        die("Error: Required fields must be filled.");
    }

    // Validate email format
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("Error: Invalid email format.");
    }

    // Set recipient email
    $to = "support@mostreams.com"; // Change this to your recipient email

    // Email subject
    $subject = "New Athlete Submission - $name";

    // Construct email message
    $message = "Athlete Information:\n";
    $message .= "Name: $name\n";
    $message .= "Notable Achievements: $notable_achievements\n\n";
    $message .= "Sport: $sport\n";
    $message .= "Position: $position\n";
    $message .= "Current Team Club: $current_team_club\n";

    $message .= "\nContact Information:\n";
    $message .= "Email: $email\n";
    $message .= "Contact: $contact\n";
    $message .= "Address: $address\n\n";

    $message .= "Athletic Experience:\n";
    $message .= "Years of Experience: $years_of_experience\n";
    $message .= "Notable Achievements 2: $notable_achievements_2\n";
    $message .= "Previous Teams/Clubs: $previous_team_clubs\n";
    $message .= "Awards Honors: $awards_honors\n\n";

    $message .= "Career Goals:\n";
    $message .= "Short Term Goals: $short_term_goals\n";
    $message .= "Long Term Goals: $long_term_goals\n";
    $message .= "What do you hope to achieve with our management team?: $achieve_with_us\n\n";

    $message .= "Marketing & Sponsorship:\n";
    $message .= "Social Media Handles: $social_media_handles\n";
    $message .= "Current Sponsorships/Endorsements: $current_sponsorships_endorsements\n";
    $message .= "Desired Sponsorship/Endorsement Opportunities: $desired_sponsorship\n\n";

    $message .= "Additional Information:\n";
    $message .= "Why do you want to work with our management team?: $work_with_management_team\n";
    $message .= "What sets you apart from other athletes in your sport?: $sets_apart_from_other_athletes\n";
    $message .= "Is there any additional information you'd like to share?: $additional_information\n\n";
    
    $message .= "Bio:\n$bio\n";

    // Headers
    $headers = "From: noreply@mostreams.com\r\n";
    $headers .= "Reply-To: $email\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    // Send the email
    if (mail($to, $subject, $message, $headers)) {
        // Successful submission message with styling and animation
        echo "
        <html>
        <head>
            <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css' rel='stylesheet'>
            <style>
                body, html {
                    background-color: #030303;
                    color: #E36220;
                    height: 100%;
                    margin: 0;
                    font-family: Arial, sans-serif;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    text-align: center;
                    position: relative;
                    overflow: hidden;
                }
                h2 {
                    margin: 0;
                }
                p {
                    margin-bottom: 30px;
                    margin-top: 10px;
                }
                a {
                    padding: 10px 20px;
                    background-color: #E36220; 
                    color: #000;
                    border-radius: 50px;
                    text-decoration: none;
                    font-weight: 700;
                }
                .animation-container {
                    position: absolute;
                    top: 20%;
                    left: 50%;
                    transform: translateX(-50%); 
                    width: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .bird {
                    font-size: 50px;
                    color: #E36220;
                    animation: fly 6s linear forwards;
                }
                @keyframes fly {
                    0% {
                        transform: translateX(-100%);
                    }
                    100% {
                        transform: translateX(100%);
                    }
                }
            </style>
        </head>
        <body>
            <div>
                <h2>Your Request has been submitted</h2>
                <p>We'll review it within 2 working days</p>
                <a href='https://mostreams.com/'>HOMEPAGE</a>
            </div>
            <div class='animation-container'>
                <div class='bird'>
                    <i class='fas fa-dove'></i> <!-- Bird icon -->
                </div>
            </div>
        </body>
        </html>
        ";
    } else {
        echo "Error in sending email.";
    }
}
?>
