<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $company_name = isset($_POST["company_name"]) ? htmlspecialchars($_POST["company_name"]) : "";
    $shareholders_name = isset($_POST["shareholders_name"]) ? htmlspecialchars($_POST["shareholders_name"]) : "";
    $email = isset($_POST["email"]) ? htmlspecialchars($_POST["email"]) : "";
    $phone = isset($_POST["phone"]) ? htmlspecialchars($_POST["phone"]) : "";
    $street = isset($_POST["street"]) ? htmlspecialchars($_POST["street"]) : "";
    $city = isset($_POST["city"]) ? htmlspecialchars($_POST["city"]) : "";
    $state = isset($_POST["state"]) ? htmlspecialchars($_POST["state"]) : "";
    $zip = isset($_POST["zip"]) ? htmlspecialchars($_POST["zip"]) : "";
    $partnership_options = isset($_POST["partnership_options"]) ? htmlspecialchars($_POST["partnership_options"]) : "";
    $additional_information = isset($_POST["additional_information"]) ? htmlspecialchars($_POST["additional_information"]) : "";
    $message = isset($_POST["message"]) ? htmlspecialchars($_POST["message"]) : "";

    // Fix for checkboxes: Convert arrays to strings
    $benefits_and_objectives = isset($_POST["benefits_and_objectives"]) ? implode(", ", $_POST["benefits_and_objectives"]) : "Not provided";
    $marketing_and_promotion = isset($_POST["marketing_and_promotion"]) ? implode(", ", $_POST["marketing_and_promotion"]) : "Not provided";

    // Validate required fields
    if (empty($company_name) || empty($shareholders_name) || empty($email) || empty($phone) || empty($street) || empty($message)) {
        die("Error: All required fields must be filled.");
    }

    // Validate email
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("Error: Invalid email format.");
    }

    // Email setup
    $to = "support@mostreams.com";
    $subject = "New Partner Form Submission - " . $company_name;

    // Email body
    $body = "Company Name: $company_name\n";
    $body .= "Shareholders Name: $shareholders_name\n";
    $body .= "Email: $email\n";
    $body .= "Phone: $phone\n";
    $body .= "Street: $street\n";
    $body .= "City: $city\n";
    $body .= "State: $state\n";
    $body .= "Zip: $zip\n";
    $body .= "Partnership Options: $partnership_options\n";
    $body .= "Benefits and Objectives: $benefits_and_objectives\n";
    $body .= "Marketing and Promotion: $marketing_and_promotion\n";
    $body .= "Additional Information: $additional_information\n";
    $body .= "Message:\n$message\n";

    // Email headers
    $headers = "From: noreply@mostreams.com\r\n";
    $headers .= "Reply-To: $email\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    // Send email
    if (mail($to, $subject, $body, $headers)) {
        echo "
        <html>
        <head>
            <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css' rel='stylesheet'>
            <style>
                body, html {
                    background-color: #030303;
                    color: #E36220;
                    height: 100%;
                    margin: 0;
                    font-family: Arial, sans-serif;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    text-align: center;
                    position: relative;
                    overflow: hidden;
                }
                h2 {
                    margin: 0;
                }
                p {
                    margin-bottom: 30px;
                    margin-top: 10px;
                }
                a {
                    padding: 10px 20px;
                    background-color: #E36220; 
                    color: #000;
                    border-radius: 50px;
                    text-decoration: none;
                    font-weight: 700;
                }
                .animation-container {
                    position: absolute;
                    top: 20%;
                    left: 50%;
                    transform: translateX(-50%); 
                    width: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .bird {
                    font-size: 50px;
                    color: #E36220;
                    animation: fly 6s linear forwards;
                }
                @keyframes fly {
                    0% {
                        transform: translateX(-100%);
                    }
                    100% {
                        transform: translateX(100%);
                    }
                }
            </style>
        </head>
        <body>
            <div>
                <h2>Your Request has been submitted</h2>
                <p>We'll review it within 2 working days</p>
                <a href='https://mostreams.com/'>HOMEPAGE</a>
            </div>
            <div class='animation-container'>
                <div class='bird'>
                    <i class='fas fa-dove'></i> 
                </div>
            </div>
        </body>
        </html>
        ";
    } else {
        echo "Error in sending email.";
    }
}
?>
